/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-02-11 20:24:20 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1386 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=10184 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=3957 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_bricks_form_submissions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `post_id` bigint NOT NULL,
  `form_id` char(6) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL,
  `form_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `browser` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `os` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referrer` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `favorite` tinyint DEFAULT NULL,
  `info` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `post_id` (`post_id`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `wp_gf_draft_submissions` (
  `uuid` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `form_id` mediumint unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source_url` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `submission` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_entry` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint unsigned NOT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint NOT NULL DEFAULT '0',
  `is_read` tinyint NOT NULL DEFAULT '0',
  `ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_agent` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `currency` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_status` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `transaction_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_fulfilled` tinyint DEFAULT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `transaction_type` tinyint DEFAULT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'active',
  `source_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_entry_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint unsigned NOT NULL DEFAULT '0',
  `entry_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `item_index` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_entry_notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int unsigned NOT NULL,
  `user_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `note_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sub_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint NOT NULL DEFAULT '1',
  `is_trash` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form_meta` (
  `form_id` mediumint unsigned NOT NULL,
  `display_meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `entries_grid_meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `confirmations` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `notifications` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form_revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint unsigned NOT NULL,
  `display_meta` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form_view` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `count` mediumint unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_rest_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=33626 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=18818 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1968 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rank_math_analytics_keyword_manager` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `keyword` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `collection` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rank_math_analytics_objects` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `page` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_subtype` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_id` bigint unsigned NOT NULL,
  `primary_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `seo_score` tinyint NOT NULL DEFAULT '0',
  `page_score` tinyint NOT NULL DEFAULT '0',
  `is_indexable` tinyint(1) NOT NULL DEFAULT '1',
  `schemas_in_use` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `desktop_interactive` double DEFAULT '0',
  `desktop_pagescore` double DEFAULT '0',
  `mobile_interactive` double DEFAULT '0',
  `mobile_pagescore` double DEFAULT '0',
  `pagespeed_refreshed` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190))
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rank_math_internal_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  `target_post_id` bigint unsigned NOT NULL,
  `type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `target_post_id` (`target_post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rank_math_internal_meta` (
  `object_id` bigint unsigned NOT NULL,
  `internal_link_count` int unsigned DEFAULT '0',
  `external_link_count` int unsigned DEFAULT '0',
  `incoming_link_count` int unsigned DEFAULT '0',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_sbr_form_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` varchar(50) NOT NULL DEFAULT '',
  `plugin` varchar(50) NOT NULL DEFAULT '',
  `form_id` int NOT NULL,
  `rating` int unsigned NOT NULL,
  `content` longtext NOT NULL,
  `date` datetime DEFAULT NULL,
  `json_data` longtext NOT NULL,
  `used_in` longtext NOT NULL,
  `archived_in` longtext NOT NULL,
  `deleted_in` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `wp_snippets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `code` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tags` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scope` varchar(15) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'global',
  `priority` smallint NOT NULL DEFAULT '10',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `revision` bigint NOT NULL DEFAULT '1',
  `cloud_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `condition_id` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=46129 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `last_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `company` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `state` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `postcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=940 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgb_cache` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `grid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expire` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgb_cards` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `favorite` tinyint(1) DEFAULT '0',
  `type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layout` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `css` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `modified_date` (`modified_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgb_facets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `favorite` tinyint(1) DEFAULT '0',
  `type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slug` (`slug`),
  KEY `slug_id` (`slug`,`id`),
  KEY `modified_date` (`modified_date`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgb_grids` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `favorite` tinyint(1) DEFAULT '0',
  `type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `modified_date` (`modified_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgb_index` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int unsigned DEFAULT NULL,
  `slug` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `facet_value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `facet_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `facet_id` int unsigned DEFAULT '0',
  `facet_parent` int unsigned DEFAULT '0',
  `facet_order` int unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `object_id_idx` (`object_id`),
  KEY `slug_idx` (`slug`),
  KEY `slug_value_idx` (`slug`,`facet_value`)
) ENGINE=InnoDB AUTO_INCREMENT=209 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgb_styles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `favorite` tinyint(1) DEFAULT '0',
  `type` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `css` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `modified_date` (`modified_date`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("72", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2024-05-06 20:43:09", "2024-05-06 20:43:09", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "1", "1", "2024-05-06 20:43:18", "2024-05-06 16:43:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("103", "action_scheduler/migration_hook", "failed", "2024-05-08 16:20:40", "2024-05-08 12:20:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715185240;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715185240;}", "2", "1", "2024-05-08 16:22:10", "2024-05-08 12:22:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("198", "action_scheduler/migration_hook", "failed", "2024-06-21 14:46:09", "2024-06-21 10:46:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1718981169;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1718981169;}", "2", "1", "2024-06-21 14:47:09", "2024-06-21 10:47:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("332", "woocommerce_cleanup_draft_orders", "failed", "2024-09-19 05:38:56", "2024-09-19 01:38:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726724336;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726724336;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-09-19 05:40:10", "2024-09-19 01:40:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("337", "woocommerce_cleanup_draft_orders", "failed", "2024-09-20 05:40:10", "2024-09-20 01:40:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726810810;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726810810;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-09-20 16:16:35", "2024-09-20 12:16:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("338", "woocommerce_cleanup_draft_orders", "failed", "2024-09-21 16:16:35", "2024-09-21 12:16:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1726935395;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1726935395;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-09-22 05:37:28", "2024-09-22 01:37:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("339", "woocommerce_cleanup_draft_orders", "failed", "2024-09-23 05:37:28", "2024-09-23 01:37:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727069848;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727069848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-09-23 05:38:56", "2024-09-23 01:38:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("341", "woocommerce_cleanup_draft_orders", "failed", "2024-09-24 05:38:56", "2024-09-24 01:38:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727156336;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727156336;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-09-24 15:27:33", "2024-09-24 11:27:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("342", "woocommerce_cleanup_draft_orders", "failed", "2024-09-25 15:27:33", "2024-09-25 11:27:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727278053;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727278053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-09-25 16:48:58", "2024-09-25 12:48:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("344", "woocommerce_cleanup_draft_orders", "failed", "2024-09-26 16:48:58", "2024-09-26 12:48:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727369338;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727369338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-09-26 20:12:49", "2024-09-26 16:12:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("345", "woocommerce_cleanup_draft_orders", "failed", "2024-09-27 20:12:49", "2024-09-27 16:12:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727467969;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727467969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-09-28 05:36:21", "2024-09-28 01:36:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("346", "woocommerce_cleanup_draft_orders", "failed", "2024-09-29 05:36:21", "2024-09-29 01:36:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727588181;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727588181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-09-29 05:37:49", "2024-09-29 01:37:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("348", "woocommerce_cleanup_draft_orders", "failed", "2024-09-30 05:37:49", "2024-09-30 01:37:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727674669;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727674669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-09-30 05:38:40", "2024-09-30 01:38:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("349", "woocommerce_cleanup_draft_orders", "failed", "2024-10-01 05:38:40", "2024-10-01 01:38:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727761120;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727761120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-01 05:39:22", "2024-10-01 01:39:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("350", "woocommerce_cleanup_draft_orders", "failed", "2024-10-02 05:39:22", "2024-10-02 01:39:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727847562;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727847562;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-02 05:42:15", "2024-10-02 01:42:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("352", "woocommerce_cleanup_draft_orders", "failed", "2024-10-03 05:42:15", "2024-10-03 01:42:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1727934135;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1727934135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-04 05:37:42", "2024-10-04 01:37:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("353", "woocommerce_cleanup_draft_orders", "failed", "2024-10-05 05:37:42", "2024-10-05 01:37:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728106662;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728106662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-05 05:39:01", "2024-10-05 01:39:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("354", "woocommerce_cleanup_draft_orders", "failed", "2024-10-06 05:39:01", "2024-10-06 01:39:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728193141;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728193141;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-06 05:39:28", "2024-10-06 01:39:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("356", "woocommerce_cleanup_draft_orders", "failed", "2024-10-07 05:39:28", "2024-10-07 01:39:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728279568;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728279568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-08 05:39:25", "2024-10-08 01:39:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("357", "woocommerce_cleanup_draft_orders", "failed", "2024-10-09 05:39:25", "2024-10-09 01:39:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728452365;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728452365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-09 14:21:26", "2024-10-09 10:21:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("359", "woocommerce_cleanup_draft_orders", "failed", "2024-10-10 14:21:26", "2024-10-10 10:21:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728570086;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728570086;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-10 20:11:49", "2024-10-10 16:11:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("360", "woocommerce_cleanup_draft_orders", "failed", "2024-10-11 20:11:49", "2024-10-11 16:11:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728677509;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728677509;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-11 20:14:02", "2024-10-11 16:14:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("361", "woocommerce_cleanup_draft_orders", "failed", "2024-10-12 20:14:02", "2024-10-12 16:14:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728764042;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728764042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-13 05:38:21", "2024-10-13 01:38:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("363", "woocommerce_cleanup_draft_orders", "failed", "2024-10-14 05:38:21", "2024-10-14 01:38:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728884301;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728884301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-14 05:38:30", "2024-10-14 01:38:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("364", "woocommerce_cleanup_draft_orders", "failed", "2024-10-15 05:38:30", "2024-10-15 01:38:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1728970710;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1728970710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-15 05:38:42", "2024-10-15 01:38:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("365", "woocommerce_cleanup_draft_orders", "failed", "2024-10-16 05:38:42", "2024-10-16 01:38:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1729057122;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1729057122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-16 05:40:08", "2024-10-16 01:40:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("367", "woocommerce_cleanup_draft_orders", "failed", "2024-10-17 05:40:08", "2024-10-17 01:40:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1729143608;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1729143608;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-18 05:37:13", "2024-10-18 01:37:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("368", "woocommerce_cleanup_draft_orders", "failed", "2024-10-19 05:37:13", "2024-10-19 01:37:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1729316233;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1729316233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-10-19 05:38:18", "2024-10-19 01:38:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("415", "woocommerce_cleanup_draft_orders", "failed", "2024-11-22 06:40:34", "2024-11-22 01:40:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732257634;s:18:\"\0*\0first_timestamp\";i:1715028121;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732257634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2024-11-22 06:40:48", "2024-11-22 01:40:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("428", "rank_math/analytics/data_fetch", "failed", "2024-11-30 06:36:52", "2024-11-30 01:36:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732948612;s:18:\"\0*\0first_timestamp\";i:1716018540;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732948612;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "6", "1", "2024-11-30 06:38:17", "2024-11-30 01:38:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("429", "rank_math/analytics/data_fetch", "failed", "2024-12-03 06:38:17", "2024-12-03 01:38:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733207897;s:18:\"\0*\0first_timestamp\";i:1716018540;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733207897;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "6", "1", "2024-12-03 06:38:40", "2024-12-03 01:38:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("430", "rank_math/analytics/data_fetch", "failed", "2024-12-06 06:38:40", "2024-12-06 01:38:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733467120;s:18:\"\0*\0first_timestamp\";i:1716018540;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733467120;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "6", "1", "2024-12-06 06:38:40", "2024-12-06 01:38:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("431", "rank_math/analytics/data_fetch", "failed", "2024-12-09 06:38:40", "2024-12-09 01:38:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733726320;s:18:\"\0*\0first_timestamp\";i:1716018540;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733726320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "6", "1", "2024-12-09 06:38:45", "2024-12-09 01:38:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("432", "rank_math/analytics/data_fetch", "failed", "2024-12-12 06:38:45", "2024-12-12 01:38:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733985525;s:18:\"\0*\0first_timestamp\";i:1716018540;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733985525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "6", "1", "2024-12-12 06:40:48", "2024-12-12 01:40:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("433", "rank_math/analytics/data_fetch", "failed", "2024-12-15 06:40:48", "2024-12-15 01:40:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734244848;s:18:\"\0*\0first_timestamp\";i:1716018540;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734244848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "6", "1", "2024-12-16 06:37:54", "2024-12-16 01:37:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("434", "rank_math/analytics/data_fetch", "failed", "2024-12-19 06:37:54", "2024-12-19 01:37:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734590274;s:18:\"\0*\0first_timestamp\";i:1716018540;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734590274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "6", "1", "2024-12-19 06:40:04", "2024-12-19 01:40:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("435", "rank_math/analytics/data_fetch", "failed", "2024-12-22 06:40:04", "2024-12-22 01:40:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734849604;s:18:\"\0*\0first_timestamp\";i:1716018540;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734849604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "6", "1", "2024-12-22 06:40:10", "2024-12-22 01:40:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("436", "rank_math/analytics/data_fetch", "failed", "2024-12-25 06:40:10", "2024-12-25 01:40:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735108810;s:18:\"\0*\0first_timestamp\";i:1716018540;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735108810;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "6", "1", "2024-12-26 06:37:39", "2024-12-26 01:37:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("437", "rank_math/analytics/data_fetch", "failed", "2024-12-29 06:37:39", "2024-12-29 01:37:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735454259;s:18:\"\0*\0first_timestamp\";i:1716018540;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735454259;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}", "6", "1", "2024-12-29 06:39:57", "2024-12-29 01:39:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1320", "wc_admin_daily_wrapper", "failed", "2025-10-25 15:20:24", "2025-10-25 11:20:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761405624;s:18:\"\0*\0first_timestamp\";i:1756136521;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761405624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-10-27 20:44:59", "2025-10-27 16:44:59", "7067", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1323", "woocommerce_cleanup_rate_limits_wrapper", "failed", "2025-10-25 15:20:25", "2025-10-25 11:20:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761405625;s:18:\"\0*\0first_timestamp\";i:1756147321;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761405625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-10-27 20:44:59", "2025-10-27 16:44:59", "7067", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1331", "wc_admin_daily_wrapper", "failed", "2025-10-28 20:44:59", "2025-10-28 16:44:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761684299;s:18:\"\0*\0first_timestamp\";i:1756136521;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761684299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-10-29 18:44:35", "2025-10-29 14:44:35", "7255", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1332", "woocommerce_cleanup_rate_limits_wrapper", "failed", "2025-10-28 20:44:59", "2025-10-28 16:44:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761684299;s:18:\"\0*\0first_timestamp\";i:1756147321;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761684299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-10-29 18:44:35", "2025-10-29 14:44:35", "7255", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1334", "wc_admin_daily_wrapper", "failed", "2025-10-30 18:44:35", "2025-10-30 14:44:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761849875;s:18:\"\0*\0first_timestamp\";i:1756136521;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761849875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-13 21:13:05", "2025-11-13 16:13:05", "7261", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1335", "woocommerce_cleanup_rate_limits_wrapper", "failed", "2025-10-30 18:44:35", "2025-10-30 14:44:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761849875;s:18:\"\0*\0first_timestamp\";i:1756147321;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761849875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-13 21:13:05", "2025-11-13 16:13:05", "7261", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1337", "wc_admin_daily_wrapper", "failed", "2025-11-14 21:13:05", "2025-11-14 16:13:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763154785;s:18:\"\0*\0first_timestamp\";i:1756136521;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763154785;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-14 21:57:59", "2025-11-14 16:57:59", "7264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1338", "woocommerce_cleanup_rate_limits_wrapper", "failed", "2025-11-14 21:13:05", "2025-11-14 16:13:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763154785;s:18:\"\0*\0first_timestamp\";i:1756147321;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763154785;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-14 21:57:59", "2025-11-14 16:57:59", "7264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1340", "wc_admin_daily_wrapper", "failed", "2025-11-15 21:57:59", "2025-11-15 16:57:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763243879;s:18:\"\0*\0first_timestamp\";i:1756136521;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763243879;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-17 14:50:14", "2025-11-17 09:50:14", "7276", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1341", "woocommerce_cleanup_rate_limits_wrapper", "failed", "2025-11-15 21:57:59", "2025-11-15 16:57:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763243879;s:18:\"\0*\0first_timestamp\";i:1756147321;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763243879;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-17 14:50:14", "2025-11-17 09:50:14", "7276", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1343", "wc_admin_daily_wrapper", "failed", "2025-11-18 14:50:14", "2025-11-18 09:50:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763477414;s:18:\"\0*\0first_timestamp\";i:1756136521;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763477414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-18 15:24:00", "2025-11-18 10:24:00", "7334", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1344", "woocommerce_cleanup_rate_limits_wrapper", "failed", "2025-11-18 14:50:14", "2025-11-18 09:50:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763477414;s:18:\"\0*\0first_timestamp\";i:1756147321;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763477414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-18 15:24:00", "2025-11-18 10:24:00", "7334", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1346", "wc_admin_daily_wrapper", "failed", "2025-11-19 15:24:00", "2025-11-19 10:24:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763565840;s:18:\"\0*\0first_timestamp\";i:1756136521;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763565840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-19 19:35:44", "2025-11-19 14:35:44", "7336", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1347", "woocommerce_cleanup_rate_limits_wrapper", "failed", "2025-11-19 15:24:00", "2025-11-19 10:24:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763565840;s:18:\"\0*\0first_timestamp\";i:1756147321;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763565840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-19 19:35:44", "2025-11-19 14:35:44", "7336", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1349", "wc_admin_daily_wrapper", "failed", "2025-11-20 19:35:44", "2025-11-20 14:35:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763667344;s:18:\"\0*\0first_timestamp\";i:1756136521;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763667344;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-24 15:31:23", "2025-11-24 10:31:23", "7338", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1350", "woocommerce_cleanup_rate_limits_wrapper", "failed", "2025-11-20 19:35:44", "2025-11-20 14:35:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763667344;s:18:\"\0*\0first_timestamp\";i:1756147321;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763667344;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-24 15:31:23", "2025-11-24 10:31:23", "7338", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1352", "wc_admin_daily_wrapper", "failed", "2025-11-25 15:31:23", "2025-11-25 10:31:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764084683;s:18:\"\0*\0first_timestamp\";i:1756136521;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764084683;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-25 16:59:54", "2025-11-25 11:59:54", "7343", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1353", "woocommerce_cleanup_rate_limits_wrapper", "failed", "2025-11-25 15:31:23", "2025-11-25 10:31:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764084683;s:18:\"\0*\0first_timestamp\";i:1756147321;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764084683;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-11-25 16:59:54", "2025-11-25 11:59:54", "7343", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1374", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-10 14:29:07", "2026-01-10 09:29:07", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768055347;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768055347;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-12 14:46:32", "2026-01-12 09:46:32", "10033", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1375", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-13 14:46:32", "2026-01-13 09:46:32", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768315592;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768315592;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-13 17:36:25", "2026-01-13 12:36:25", "10041", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1376", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-14 17:36:25", "2026-01-14 12:36:25", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768412185;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768412185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-14 18:07:12", "2026-01-14 13:07:12", "10048", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1377", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-15 18:07:12", "2026-01-15 13:07:12", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768500432;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768500432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-16 01:16:08", "2026-01-15 20:16:08", "10053", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1378", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-17 01:16:08", "2026-01-16 20:16:08", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768612568;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768612568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-27 15:34:43", "2026-01-27 10:34:43", "10061", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1379", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-28 15:34:43", "2026-01-28 10:34:43", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769614483;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769614483;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-29 16:57:15", "2026-01-29 11:57:15", "10076", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1380", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-30 16:57:15", "2026-01-30 11:57:15", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769792235;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769792235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-01-30 16:57:39", "2026-01-30 11:57:39", "10165", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1381", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-31 16:57:39", "2026-01-31 11:57:39", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769878659;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769878659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-02-02 14:05:40", "2026-02-02 09:05:40", "10167", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1382", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-02-03 14:05:40", "2026-02-03 09:05:40", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770127540;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770127540;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-02-06 17:12:46", "2026-02-06 12:12:46", "10173", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1383", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-02-07 17:12:46", "2026-02-07 12:12:46", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770484366;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770484366;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-02-09 12:33:06", "2026-02-09 07:33:06", "10176", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1384", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-02-10 12:33:06", "2026-02-10 07:33:06", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770726786;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770726786;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2026-02-11 17:21:23", "2026-02-11 12:21:23", "10179", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1385", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2026-02-12 17:21:23", "2026-02-12 12:21:23", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770916883;s:18:\"\0*\0first_timestamp\";i:1756136520;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770916883;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "wc_update_product_lookup_tables");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "rank-math");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("10", "woocommerce");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("11", "72", "action created", "2024-05-06 20:43:09", "2024-05-06 16:43:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("17", "72", "action started via WP Cron", "2024-05-06 20:43:18", "2024-05-06 16:43:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("18", "72", "action failed via WP Cron: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2024-05-06 20:43:18", "2024-05-06 16:43:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("108", "103", "action created", "2024-05-08 16:19:40", "2024-05-08 12:19:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("109", "103", "action started via WP Cron", "2024-05-08 16:22:10", "2024-05-08 12:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("110", "103", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-05-08 16:22:10", "2024-05-08 12:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("390", "198", "action created", "2024-06-21 14:45:09", "2024-06-21 10:45:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("391", "198", "action started via WP Cron", "2024-06-21 14:47:09", "2024-06-21 10:47:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("392", "198", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-06-21 14:47:09", "2024-06-21 10:47:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("795", "332", "action created", "2024-09-18 05:38:56", "2024-09-18 01:38:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("808", "332", "action started via WP Cron", "2024-09-19 05:40:10", "2024-09-19 01:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("809", "332", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-09-19 05:40:10", "2024-09-19 01:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("810", "337", "action created", "2024-09-19 05:40:10", "2024-09-19 01:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("811", "337", "action started via WP Cron", "2024-09-20 16:16:35", "2024-09-20 12:16:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("812", "337", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-09-20 16:16:35", "2024-09-20 12:16:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("813", "338", "action created", "2024-09-20 16:16:35", "2024-09-20 12:16:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("814", "338", "action started via WP Cron", "2024-09-22 05:37:28", "2024-09-22 01:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("815", "338", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-09-22 05:37:28", "2024-09-22 01:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("816", "339", "action created", "2024-09-22 05:37:28", "2024-09-22 01:37:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("820", "339", "action started via WP Cron", "2024-09-23 05:38:56", "2024-09-23 01:38:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("821", "339", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-09-23 05:38:56", "2024-09-23 01:38:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("822", "341", "action created", "2024-09-23 05:38:56", "2024-09-23 01:38:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("823", "341", "action started via WP Cron", "2024-09-24 15:27:33", "2024-09-24 11:27:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("824", "341", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-09-24 15:27:33", "2024-09-24 11:27:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("825", "342", "action created", "2024-09-24 15:27:33", "2024-09-24 11:27:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("829", "342", "action started via WP Cron", "2024-09-25 16:48:58", "2024-09-25 12:48:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("830", "342", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-09-25 16:48:58", "2024-09-25 12:48:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("831", "344", "action created", "2024-09-25 16:48:58", "2024-09-25 12:48:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("832", "344", "action started via WP Cron", "2024-09-26 20:12:49", "2024-09-26 16:12:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("833", "344", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-09-26 20:12:49", "2024-09-26 16:12:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("834", "345", "action created", "2024-09-26 20:12:49", "2024-09-26 16:12:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("835", "345", "action started via WP Cron", "2024-09-28 05:36:21", "2024-09-28 01:36:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("836", "345", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-09-28 05:36:21", "2024-09-28 01:36:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("837", "346", "action created", "2024-09-28 05:36:21", "2024-09-28 01:36:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("841", "346", "action started via WP Cron", "2024-09-29 05:37:49", "2024-09-29 01:37:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("842", "346", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-09-29 05:37:49", "2024-09-29 01:37:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("843", "348", "action created", "2024-09-29 05:37:49", "2024-09-29 01:37:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("844", "348", "action started via WP Cron", "2024-09-30 05:38:40", "2024-09-30 01:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("845", "348", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-09-30 05:38:40", "2024-09-30 01:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("846", "349", "action created", "2024-09-30 05:38:40", "2024-09-30 01:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("847", "349", "action started via WP Cron", "2024-10-01 05:39:22", "2024-10-01 01:39:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("848", "349", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-01 05:39:22", "2024-10-01 01:39:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("849", "350", "action created", "2024-10-01 05:39:22", "2024-10-01 01:39:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("853", "350", "action started via WP Cron", "2024-10-02 05:42:15", "2024-10-02 01:42:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("854", "350", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-02 05:42:15", "2024-10-02 01:42:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("855", "352", "action created", "2024-10-02 05:42:15", "2024-10-02 01:42:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("856", "352", "action started via WP Cron", "2024-10-04 05:37:42", "2024-10-04 01:37:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("857", "352", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-04 05:37:42", "2024-10-04 01:37:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("858", "353", "action created", "2024-10-04 05:37:42", "2024-10-04 01:37:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("859", "353", "action started via WP Cron", "2024-10-05 05:39:01", "2024-10-05 01:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("860", "353", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-05 05:39:01", "2024-10-05 01:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("861", "354", "action created", "2024-10-05 05:39:01", "2024-10-05 01:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("865", "354", "action started via WP Cron", "2024-10-06 05:39:28", "2024-10-06 01:39:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("866", "354", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-06 05:39:28", "2024-10-06 01:39:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("867", "356", "action created", "2024-10-06 05:39:28", "2024-10-06 01:39:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("868", "356", "action started via WP Cron", "2024-10-08 05:39:25", "2024-10-08 01:39:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("869", "356", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-08 05:39:25", "2024-10-08 01:39:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("870", "357", "action created", "2024-10-08 05:39:25", "2024-10-08 01:39:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("874", "357", "action started via WP Cron", "2024-10-09 14:21:26", "2024-10-09 10:21:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("875", "357", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-09 14:21:26", "2024-10-09 10:21:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("876", "359", "action created", "2024-10-09 14:21:26", "2024-10-09 10:21:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("877", "359", "action started via WP Cron", "2024-10-10 20:11:49", "2024-10-10 16:11:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("878", "359", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-10 20:11:49", "2024-10-10 16:11:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("879", "360", "action created", "2024-10-10 20:11:49", "2024-10-10 16:11:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("880", "360", "action started via WP Cron", "2024-10-11 20:14:02", "2024-10-11 16:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("881", "360", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-11 20:14:02", "2024-10-11 16:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("882", "361", "action created", "2024-10-11 20:14:02", "2024-10-11 16:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("886", "361", "action started via WP Cron", "2024-10-13 05:38:21", "2024-10-13 01:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("887", "361", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-13 05:38:21", "2024-10-13 01:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("888", "363", "action created", "2024-10-13 05:38:21", "2024-10-13 01:38:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("889", "363", "action started via WP Cron", "2024-10-14 05:38:30", "2024-10-14 01:38:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("890", "363", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-14 05:38:30", "2024-10-14 01:38:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("891", "364", "action created", "2024-10-14 05:38:30", "2024-10-14 01:38:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("892", "364", "action started via WP Cron", "2024-10-15 05:38:42", "2024-10-15 01:38:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("893", "364", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-15 05:38:42", "2024-10-15 01:38:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("894", "365", "action created", "2024-10-15 05:38:42", "2024-10-15 01:38:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("898", "365", "action started via WP Cron", "2024-10-16 05:40:08", "2024-10-16 01:40:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("899", "365", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-16 05:40:08", "2024-10-16 01:40:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("900", "367", "action created", "2024-10-16 05:40:08", "2024-10-16 01:40:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("901", "367", "action started via WP Cron", "2024-10-18 05:37:13", "2024-10-18 01:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("902", "367", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-18 05:37:13", "2024-10-18 01:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("903", "368", "action created", "2024-10-18 05:37:13", "2024-10-18 01:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("907", "368", "action started via WP Cron", "2024-10-19 05:38:18", "2024-10-19 01:38:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("908", "368", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-10-19 05:38:18", "2024-10-19 01:38:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1044", "415", "action created", "2024-11-21 06:40:34", "2024-11-21 01:40:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1078", "415", "action started via WP Cron", "2024-11-22 06:40:48", "2024-11-22 01:40:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1079", "415", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_draft_orders will not be executed as no callbacks are registered.", "2024-11-22 06:40:48", "2024-11-22 01:40:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1080", "415", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-11-22 06:40:48", "2024-11-22 01:40:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1086", "428", "action created", "2024-11-27 06:36:52", "2024-11-27 01:36:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1087", "428", "action started via WP Cron", "2024-11-30 06:38:17", "2024-11-30 01:38:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1088", "428", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2024-11-30 06:38:17", "2024-11-30 01:38:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1089", "429", "action created", "2024-11-30 06:38:17", "2024-11-30 01:38:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1090", "429", "action started via WP Cron", "2024-12-03 06:38:40", "2024-12-03 01:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1091", "429", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2024-12-03 06:38:40", "2024-12-03 01:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1092", "430", "action created", "2024-12-03 06:38:40", "2024-12-03 01:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1093", "430", "action started via WP Cron", "2024-12-06 06:38:40", "2024-12-06 01:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1094", "430", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2024-12-06 06:38:40", "2024-12-06 01:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1095", "431", "action created", "2024-12-06 06:38:40", "2024-12-06 01:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1096", "431", "action started via WP Cron", "2024-12-09 06:38:45", "2024-12-09 01:38:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1097", "431", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2024-12-09 06:38:45", "2024-12-09 01:38:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1098", "432", "action created", "2024-12-09 06:38:45", "2024-12-09 01:38:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1099", "432", "action started via WP Cron", "2024-12-12 06:40:48", "2024-12-12 01:40:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1100", "432", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2024-12-12 06:40:48", "2024-12-12 01:40:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1101", "433", "action created", "2024-12-12 06:40:48", "2024-12-12 01:40:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1102", "433", "action started via WP Cron", "2024-12-16 06:37:54", "2024-12-16 01:37:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1103", "433", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2024-12-16 06:37:54", "2024-12-16 01:37:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1104", "434", "action created", "2024-12-16 06:37:54", "2024-12-16 01:37:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1105", "434", "action started via WP Cron", "2024-12-19 06:40:04", "2024-12-19 01:40:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1106", "434", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2024-12-19 06:40:04", "2024-12-19 01:40:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1107", "435", "action created", "2024-12-19 06:40:04", "2024-12-19 01:40:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1108", "435", "action started via WP Cron", "2024-12-22 06:40:10", "2024-12-22 01:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1109", "435", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2024-12-22 06:40:10", "2024-12-22 01:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1110", "436", "action created", "2024-12-22 06:40:10", "2024-12-22 01:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1111", "436", "action started via WP Cron", "2024-12-26 06:37:39", "2024-12-26 01:37:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1112", "436", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2024-12-26 06:37:39", "2024-12-26 01:37:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1113", "437", "action created", "2024-12-26 06:37:39", "2024-12-26 01:37:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1114", "437", "action started via WP Cron", "2024-12-29 06:39:57", "2024-12-29 01:39:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1115", "437", "action failed via WP Cron: Scheduled action for rank_math/analytics/data_fetch will not be executed as no callbacks are registered.", "2024-12-29 06:39:57", "2024-12-29 01:39:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1116", "437", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-12-29 06:39:57", "2024-12-29 01:39:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3742", "1320", "action created", "2025-10-24 15:20:24", "2025-10-24 11:20:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3751", "1323", "action created", "2025-10-24 15:20:25", "2025-10-24 11:20:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3786", "1320", "action started via WP Cron", "2025-10-27 20:44:59", "2025-10-27 16:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3787", "1320", "action failed via WP Cron: Scheduled action for wc_admin_daily_wrapper will not be executed as no callbacks are registered.", "2025-10-27 20:44:59", "2025-10-27 16:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3788", "1331", "action created", "2025-10-27 20:44:59", "2025-10-27 16:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3789", "1323", "action started via WP Cron", "2025-10-27 20:44:59", "2025-10-27 16:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3790", "1323", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_rate_limits_wrapper will not be executed as no callbacks are registered.", "2025-10-27 20:44:59", "2025-10-27 16:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3791", "1332", "action created", "2025-10-27 20:44:59", "2025-10-27 16:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3795", "1331", "action started via WP Cron", "2025-10-29 18:44:35", "2025-10-29 14:44:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3796", "1331", "action failed via WP Cron: Scheduled action for wc_admin_daily_wrapper will not be executed as no callbacks are registered.", "2025-10-29 18:44:35", "2025-10-29 14:44:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3797", "1334", "action created", "2025-10-29 18:44:35", "2025-10-29 14:44:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3798", "1332", "action started via WP Cron", "2025-10-29 18:44:35", "2025-10-29 14:44:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3799", "1332", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_rate_limits_wrapper will not be executed as no callbacks are registered.", "2025-10-29 18:44:35", "2025-10-29 14:44:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3800", "1335", "action created", "2025-10-29 18:44:35", "2025-10-29 14:44:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3804", "1334", "action started via WP Cron", "2025-11-13 21:13:05", "2025-11-13 16:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3805", "1334", "action failed via WP Cron: Scheduled action for wc_admin_daily_wrapper will not be executed as no callbacks are registered.", "2025-11-13 21:13:05", "2025-11-13 16:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3806", "1337", "action created", "2025-11-13 21:13:05", "2025-11-13 16:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3807", "1335", "action started via WP Cron", "2025-11-13 21:13:05", "2025-11-13 16:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3808", "1335", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_rate_limits_wrapper will not be executed as no callbacks are registered.", "2025-11-13 21:13:05", "2025-11-13 16:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3809", "1338", "action created", "2025-11-13 21:13:05", "2025-11-13 16:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3813", "1337", "action started via WP Cron", "2025-11-14 21:57:59", "2025-11-14 16:57:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3814", "1337", "action failed via WP Cron: Scheduled action for wc_admin_daily_wrapper will not be executed as no callbacks are registered.", "2025-11-14 21:57:59", "2025-11-14 16:57:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3815", "1340", "action created", "2025-11-14 21:57:59", "2025-11-14 16:57:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3816", "1338", "action started via WP Cron", "2025-11-14 21:57:59", "2025-11-14 16:57:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3817", "1338", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_rate_limits_wrapper will not be executed as no callbacks are registered.", "2025-11-14 21:57:59", "2025-11-14 16:57:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3818", "1341", "action created", "2025-11-14 21:57:59", "2025-11-14 16:57:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("3822", "1340", "action started via WP Cron", "2025-11-17 14:50:14", "2025-11-17 09:50:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3823", "1340", "action failed via WP Cron: Scheduled action for wc_admin_daily_wrapper will not be executed as no callbacks are registered.", "2025-11-17 14:50:14", "2025-11-17 09:50:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3824", "1343", "action created", "2025-11-17 14:50:14", "2025-11-17 09:50:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3825", "1341", "action started via WP Cron", "2025-11-17 14:50:14", "2025-11-17 09:50:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3826", "1341", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_rate_limits_wrapper will not be executed as no callbacks are registered.", "2025-11-17 14:50:14", "2025-11-17 09:50:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3827", "1344", "action created", "2025-11-17 14:50:14", "2025-11-17 09:50:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3831", "1343", "action started via WP Cron", "2025-11-18 15:24:00", "2025-11-18 10:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3832", "1343", "action failed via WP Cron: Scheduled action for wc_admin_daily_wrapper will not be executed as no callbacks are registered.", "2025-11-18 15:24:00", "2025-11-18 10:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3833", "1346", "action created", "2025-11-18 15:24:00", "2025-11-18 10:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3834", "1344", "action started via WP Cron", "2025-11-18 15:24:00", "2025-11-18 10:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3835", "1344", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_rate_limits_wrapper will not be executed as no callbacks are registered.", "2025-11-18 15:24:00", "2025-11-18 10:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3836", "1347", "action created", "2025-11-18 15:24:00", "2025-11-18 10:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3840", "1346", "action started via WP Cron", "2025-11-19 19:35:44", "2025-11-19 14:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3841", "1346", "action failed via WP Cron: Scheduled action for wc_admin_daily_wrapper will not be executed as no callbacks are registered.", "2025-11-19 19:35:44", "2025-11-19 14:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3842", "1349", "action created", "2025-11-19 19:35:44", "2025-11-19 14:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3843", "1347", "action started via WP Cron", "2025-11-19 19:35:44", "2025-11-19 14:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3844", "1347", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_rate_limits_wrapper will not be executed as no callbacks are registered.", "2025-11-19 19:35:44", "2025-11-19 14:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3845", "1350", "action created", "2025-11-19 19:35:44", "2025-11-19 14:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3849", "1349", "action started via WP Cron", "2025-11-24 15:31:23", "2025-11-24 10:31:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3850", "1349", "action failed via WP Cron: Scheduled action for wc_admin_daily_wrapper will not be executed as no callbacks are registered.", "2025-11-24 15:31:23", "2025-11-24 10:31:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3851", "1352", "action created", "2025-11-24 15:31:23", "2025-11-24 10:31:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3852", "1350", "action started via WP Cron", "2025-11-24 15:31:23", "2025-11-24 10:31:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3853", "1350", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_rate_limits_wrapper will not be executed as no callbacks are registered.", "2025-11-24 15:31:23", "2025-11-24 10:31:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3854", "1353", "action created", "2025-11-24 15:31:23", "2025-11-24 10:31:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3858", "1352", "action started via WP Cron", "2025-11-25 16:59:54", "2025-11-25 11:59:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3859", "1352", "action failed via WP Cron: Scheduled action for wc_admin_daily_wrapper will not be executed as no callbacks are registered.", "2025-11-25 16:59:54", "2025-11-25 11:59:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3860", "1352", "This action appears to be consistently failing. A new instance will not be scheduled.", "2025-11-25 16:59:54", "2025-11-25 11:59:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3861", "1353", "action started via WP Cron", "2025-11-25 16:59:54", "2025-11-25 11:59:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3862", "1353", "action failed via WP Cron: Scheduled action for woocommerce_cleanup_rate_limits_wrapper will not be executed as no callbacks are registered.", "2025-11-25 16:59:54", "2025-11-25 11:59:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3863", "1353", "This action appears to be consistently failing. A new instance will not be scheduled.", "2025-11-25 16:59:54", "2025-11-25 11:59:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3923", "1374", "action created", "2026-01-09 14:29:07", "2026-01-09 09:29:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("3924", "1374", "action started via WP Cron", "2026-01-12 14:46:32", "2026-01-12 09:46:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("3925", "1374", "action complete via WP Cron", "2026-01-12 14:46:32", "2026-01-12 09:46:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("3926", "1375", "action created", "2026-01-12 14:46:32", "2026-01-12 09:46:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("3927", "1375", "action started via WP Cron", "2026-01-13 17:36:25", "2026-01-13 12:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3928", "1375", "action complete via WP Cron", "2026-01-13 17:36:25", "2026-01-13 12:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3929", "1376", "action created", "2026-01-13 17:36:25", "2026-01-13 12:36:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3930", "1376", "action started via Async Request", "2026-01-14 18:07:12", "2026-01-14 13:07:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3931", "1376", "action complete via Async Request", "2026-01-14 18:07:12", "2026-01-14 13:07:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3932", "1377", "action created", "2026-01-14 18:07:12", "2026-01-14 13:07:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3933", "1377", "action started via WP Cron", "2026-01-16 01:16:08", "2026-01-15 20:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("3934", "1377", "action complete via WP Cron", "2026-01-16 01:16:08", "2026-01-15 20:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("3935", "1378", "action created", "2026-01-16 01:16:08", "2026-01-15 20:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("3936", "1378", "action started via WP Cron", "2026-01-27 15:34:43", "2026-01-27 10:34:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3937", "1378", "action complete via WP Cron", "2026-01-27 15:34:43", "2026-01-27 10:34:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3938", "1379", "action created", "2026-01-27 15:34:43", "2026-01-27 10:34:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3939", "1379", "action started via WP Cron", "2026-01-29 16:57:15", "2026-01-29 11:57:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3940", "1379", "action complete via WP Cron", "2026-01-29 16:57:15", "2026-01-29 11:57:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3941", "1380", "action created", "2026-01-29 16:57:15", "2026-01-29 11:57:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3942", "1380", "action started via WP Cron", "2026-01-30 16:57:38", "2026-01-30 11:57:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3943", "1380", "action complete via WP Cron", "2026-01-30 16:57:39", "2026-01-30 11:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3944", "1381", "action created", "2026-01-30 16:57:39", "2026-01-30 11:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3945", "1381", "action started via WP Cron", "2026-02-02 14:05:40", "2026-02-02 09:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3946", "1381", "action complete via WP Cron", "2026-02-02 14:05:40", "2026-02-02 09:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3947", "1382", "action created", "2026-02-02 14:05:40", "2026-02-02 09:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3948", "1382", "action started via WP Cron", "2026-02-06 17:12:46", "2026-02-06 12:12:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3949", "1382", "action complete via WP Cron", "2026-02-06 17:12:46", "2026-02-06 12:12:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3950", "1383", "action created", "2026-02-06 17:12:46", "2026-02-06 12:12:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3951", "1383", "action started via WP Cron", "2026-02-09 12:33:06", "2026-02-09 07:33:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3952", "1383", "action complete via WP Cron", "2026-02-09 12:33:06", "2026-02-09 07:33:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3953", "1384", "action created", "2026-02-09 12:33:06", "2026-02-09 07:33:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3954", "1384", "action started via WP Cron", "2026-02-11 17:21:23", "2026-02-11 12:21:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3955", "1384", "action complete via WP Cron", "2026-02-11 17:21:23", "2026-02-11 12:21:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3956", "1385", "action created", "2026-02-11 17:21:23", "2026-02-11 12:21:23");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("2", "2", "verified", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "72", "innoadmin", "web-admin@innovative.ink", "https://stage.innovative.ink/bmi", "74.114.74.46", "2024-05-06 16:56:02", "2024-05-06 20:56:02", "This product is amazing!", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36 Edg/124.0.0.0", "review", "0", "1");
INSERT INTO `wp_comments` VALUES("3", "134", "WooCommerce", "woocommerce@stage.innovative.ink", "", "", "2024-05-06 20:31:06", "2024-05-07 00:31:06", "Awaiting cheque payment Order status changed from Pending payment to On hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "139", "WooCommerce", "woocommerce@stage.innovative.ink", "", "", "2024-05-06 20:35:01", "2024-05-07 00:35:01", "Awaiting cheque payment Order status changed from Pending payment to On hold.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "170", "WooCommerce", "woocommerce@stage.innovative.ink", "", "", "2024-05-07 15:45:29", "2024-05-07 19:45:29", "Payment to be made upon delivery. Order status changed from Pending payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("26", "20260211_prod_bmilaser", "92f1a5a47cc2acef8093_20260211202413", "21", "2026-02-11 20:24:20", "innoadmin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-02-11 20:24:13\";s:7:\"Version\";s:6:\"1.5.15\";s:9:\"VersionWP\";s:5:\"6.9.1\";s:9:\"VersionDB\";s:6:\"8.0.45\";s:10:\"VersionPHP\";s:6:\"8.3.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:26;s:4:\"Name\";s:22:\"20260211_prod_bmilaser\";s:4:\"Hash\";s:35:\"92f1a5a47cc2acef8093_20260211202413\";s:8:\"NameHash\";s:58:\"20260211_prod_bmilaser_92f1a5a47cc2acef8093_20260211202413\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:68:\"20260211_prod_bmilaser_92f1a5a47cc2acef8093_20260211202413_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.1\";s:6:\"WPUser\";s:9:\"innoadmin\";s:7:\"Archive\";O:11:\"DUP_Archive\":27:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:70:\"20260211_prod_bmilaser_92f1a5a47cc2acef8093_20260211202413_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:37:\"/home/stageinnovative/public_html/bmi\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1649;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:10806;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2026-02-11 20:24:13\";s:7:\"Version\";s:6:\"1.5.15\";s:9:\"VersionWP\";s:5:\"6.9.1\";s:9:\"VersionDB\";s:6:\"8.0.45\";s:10:\"VersionPHP\";s:6:\"8.3.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20260211_prod_bmilaser\";s:4:\"Hash\";s:35:\"92f1a5a47cc2acef8093_20260211202413\";s:8:\"NameHash\";s:58:\"20260211_prod_bmilaser_92f1a5a47cc2acef8093_20260211202413\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:76:\"20260211_prod_bmilaser_92f1a5a47cc2acef8093_20260211202413_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:66;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/stageinnovative/public_html/bmi/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:71:\"20260211_prod_bmilaser_92f1a5a47cc2acef8093_20260211202413_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:141:\"/home/stageinnovative/public_html/bmi/wp-content/backups-dup-lite/tmp/20260211_prod_bmilaser_92f1a5a47cc2acef8093_20260211202413_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:66;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/stageinnovative/public_html/bmi/wp-admin\";i:1;s:49:\"/home/stageinnovative/public_html/bmi/wp-includes\";i:2;s:58:\"/home/stageinnovative/public_html/bmi/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/stageinnovative/public_html/bmi\";i:1;s:37:\"/home/stageinnovative/public_html/bmi\";i:2;s:48:\"/home/stageinnovative/public_html/bmi/wp-content\";i:3;s:56:\"/home/stageinnovative/public_html/bmi/wp-content/uploads\";i:4;s:56:\"/home/stageinnovative/public_html/bmi/wp-content/plugins\";i:5;s:59:\"/home/stageinnovative/public_html/bmi/wp-content/mu-plugins\";i:6;s:55:\"/home/stageinnovative/public_html/bmi/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:3:{i:0;s:69:\"/home/stageinnovative/public_html/bmi/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";i:2;s:18:\"duplicator-backups\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;s:38:\"\0DUP_Archive\0wpContentDirNormalizePath\";N;}s:9:\"Installer\";r:87;s:8:\"Database\";r:106;s:13:\"BuildProgress\";r:145;}");

/* INSERT TABLE DATA: wp_gf_entry */
INSERT INTO `wp_gf_entry` VALUES("1", "5", NULL, "2025-12-09 15:46:24", "2025-12-09 15:46:24", "0", "0", "97.107.48.222", "https://stage.innovative.ink/bmi/work-order/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "CAD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active", "1698");
INSERT INTO `wp_gf_entry` VALUES("2", "6", NULL, "2026-01-05 14:34:45", "2026-01-05 14:34:45", "0", "1", "97.107.49.82", "https://stage.innovative.ink/bmi/preventative-maintenance/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "CAD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active", "1714");
INSERT INTO `wp_gf_entry` VALUES("3", "7", NULL, "2026-01-05 14:36:42", "2026-01-05 14:36:42", "0", "0", "97.107.49.82", "https://stage.innovative.ink/bmi/service-report/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36", "CAD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active", "1740");
INSERT INTO `wp_gf_entry` VALUES("4", "8", NULL, "2026-01-27 16:40:55", "2026-01-27 16:40:55", "0", "0", "74.220.167.186", "https://stage.innovative.ink/bmi/orders/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36", "CAD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active", "1745");
INSERT INTO `wp_gf_entry` VALUES("5", "6", NULL, "2026-01-27 16:41:39", "2026-01-27 16:41:39", "0", "0", "74.220.167.186", "https://stage.innovative.ink/bmi/preventative-maintenance/", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36", "CAD", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "active", "1714");

/* INSERT TABLE DATA: wp_gf_entry_meta */
INSERT INTO `wp_gf_entry_meta` VALUES("1", "5", "1", "1", "BeMoore", "");
INSERT INTO `wp_gf_entry_meta` VALUES("2", "5", "1", "submission_speeds", "{\"1\":[10817]}", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("3", "5", "1", "gravityformsrecaptcha_score", "disconnected", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("4", "6", "2", "4", "2026-01-05", "");
INSERT INTO `wp_gf_entry_meta` VALUES("5", "6", "2", "6", "BeMoore", "");
INSERT INTO `wp_gf_entry_meta` VALUES("6", "6", "2", "7", "09:05 am", "");
INSERT INTO `wp_gf_entry_meta` VALUES("7", "6", "2", "8", "12:15 pm", "");
INSERT INTO `wp_gf_entry_meta` VALUES("8", "6", "2", "9", "Aron", "");
INSERT INTO `wp_gf_entry_meta` VALUES("9", "6", "2", "13", "Y1 Axis", "");
INSERT INTO `wp_gf_entry_meta` VALUES("10", "6", "2", "14", "Y2 Axis", "");
INSERT INTO `wp_gf_entry_meta` VALUES("11", "6", "2", "15", "Y2 Axis", "");
INSERT INTO `wp_gf_entry_meta` VALUES("12", "6", "2", "16", "Y2 Axis", "");
INSERT INTO `wp_gf_entry_meta` VALUES("13", "6", "2", "submission_speeds", "{\"2\":[32718]}", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("14", "6", "2", "gravityformsrecaptcha_score", "disconnected", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("15", "7", "3", "4", "2026-01-05", "");
INSERT INTO `wp_gf_entry_meta` VALUES("16", "7", "3", "6", "Bemoore", "");
INSERT INTO `wp_gf_entry_meta` VALUES("17", "7", "3", "7", "08:00 am", "");
INSERT INTO `wp_gf_entry_meta` VALUES("18", "7", "3", "8", "02:30 pm", "");
INSERT INTO `wp_gf_entry_meta` VALUES("19", "7", "3", "9", "Aron", "");
INSERT INTO `wp_gf_entry_meta` VALUES("20", "7", "3", "21", "Yes", "");
INSERT INTO `wp_gf_entry_meta` VALUES("21", "7", "3", "22", "Pallet not working.", "");
INSERT INTO `wp_gf_entry_meta` VALUES("22", "7", "3", "24", "Found broken chain", "");
INSERT INTO `wp_gf_entry_meta` VALUES("23", "7", "3", "23", "2 meters #80 chain", "");
INSERT INTO `wp_gf_entry_meta` VALUES("24", "7", "3", "submission_speeds", "{\"1\":[106066]}", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("25", "7", "3", "gravityformsrecaptcha_score", "disconnected", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("26", "8", "4", "4", "2026-01-27", "");
INSERT INTO `wp_gf_entry_meta` VALUES("27", "8", "4", "9", "Aron", "");
INSERT INTO `wp_gf_entry_meta` VALUES("28", "8", "4", "22", "Ament", "");
INSERT INTO `wp_gf_entry_meta` VALUES("29", "8", "4", "24", "lenses", "");
INSERT INTO `wp_gf_entry_meta` VALUES("30", "8", "4", "submission_speeds", "{\"1\":[26038]}", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("31", "8", "4", "gravityformsrecaptcha_score", "disconnected", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("32", "6", "5", "4", "2026-01-27", "");
INSERT INTO `wp_gf_entry_meta` VALUES("33", "6", "5", "6", "Lmar", "");
INSERT INTO `wp_gf_entry_meta` VALUES("34", "6", "5", "7", "09:00 am", "");
INSERT INTO `wp_gf_entry_meta` VALUES("35", "6", "5", "8", "10:00 am", "");
INSERT INTO `wp_gf_entry_meta` VALUES("36", "6", "5", "9", "Aron", "");
INSERT INTO `wp_gf_entry_meta` VALUES("37", "6", "5", "submission_speeds", "{\"2\":[5655]}", NULL);
INSERT INTO `wp_gf_entry_meta` VALUES("38", "6", "5", "gravityformsrecaptcha_score", "disconnected", NULL);

/* INSERT TABLE DATA: wp_gf_entry_notes */
INSERT INTO `wp_gf_entry_notes` VALUES("1", "1", "Admin Notification (ID: 6931ea2ad2b2e)", "0", "2025-12-09 15:46:24", "WordPress successfully passed the notification email to the sending server.", "notification", "success");
INSERT INTO `wp_gf_entry_notes` VALUES("2", "2", "User Notification (ID: 51794abf1f0d1)", "0", "2026-01-05 14:34:45", "WordPress was unable to send the notification email. Cannot send email because the TO address is invalid.", "notification", "error");
INSERT INTO `wp_gf_entry_notes` VALUES("3", "2", "Admin Notification (ID: 51794abf1f0d2)", "0", "2026-01-05 14:34:45", "WordPress successfully passed the notification email to the sending server.", "notification", "success");
INSERT INTO `wp_gf_entry_notes` VALUES("4", "3", "User Notification (ID: 51794abf1f0d1)", "0", "2026-01-05 14:36:42", "WordPress was unable to send the notification email. Cannot send email because the TO address is invalid.", "notification", "error");
INSERT INTO `wp_gf_entry_notes` VALUES("5", "3", "Admin Notification (ID: 51794abf1f0d2)", "0", "2026-01-05 14:36:42", "WordPress successfully passed the notification email to the sending server.", "notification", "success");
INSERT INTO `wp_gf_entry_notes` VALUES("6", "4", "User Notification (ID: 51794abf1f0d1)", "0", "2026-01-27 16:40:55", "WordPress was unable to send the notification email. Cannot send email because the TO address is invalid.", "notification", "error");
INSERT INTO `wp_gf_entry_notes` VALUES("7", "4", "Admin Notification (ID: 51794abf1f0d2)", "0", "2026-01-27 16:40:55", "WordPress successfully passed the notification email to the sending server.", "notification", "success");
INSERT INTO `wp_gf_entry_notes` VALUES("8", "5", "User Notification (ID: 51794abf1f0d1)", "0", "2026-01-27 16:41:39", "WordPress was unable to send the notification email. Cannot send email because the TO address is invalid.", "notification", "error");
INSERT INTO `wp_gf_entry_notes` VALUES("9", "5", "Admin Notification (ID: 51794abf1f0d2)", "0", "2026-01-27 16:41:39", "WordPress successfully passed the notification email to the sending server.", "notification", "success");

/* INSERT TABLE DATA: wp_gf_form */
INSERT INTO `wp_gf_form` VALUES("1", "Contact Us", "2024-05-07 20:00:38", NULL, "1", "0");
INSERT INTO `wp_gf_form` VALUES("2", "Careers", "2024-08-27 18:46:41", NULL, "1", "1");
INSERT INTO `wp_gf_form` VALUES("3", "Lead Form", "2024-11-23 21:57:01", NULL, "1", "1");
INSERT INTO `wp_gf_form` VALUES("4", "Lead Form w Message", "2024-11-30 13:44:17", NULL, "1", "1");
INSERT INTO `wp_gf_form` VALUES("5", "Work Order", "2025-12-04 20:08:10", NULL, "1", "1");
INSERT INTO `wp_gf_form` VALUES("6", "Preventative Maintenance", "2025-12-12 20:09:32", NULL, "1", "0");
INSERT INTO `wp_gf_form` VALUES("7", "Service Report", "2025-12-12 21:27:31", NULL, "1", "0");
INSERT INTO `wp_gf_form` VALUES("8", "Orders", "2025-12-17 17:32:34", NULL, "1", "0");

/* INSERT TABLE DATA: wp_gf_form_meta */
INSERT INTO `wp_gf_form_meta` VALUES("1", "{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"postAuthor\":\"1\",\"postCategory\":\"1\",\"postStatus\":\"draft\",\"title\":\"Contact Us\",\"description\":\"\",\"maxEntriesAllowed\":\"0\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\",\"conditionalLogic\":null,\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12},\"fields\":[{\"is_payment\":false,\"type\":\"name\",\"id\":1,\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"We need to know your name. What if we wanted to send you a birthday cake?\",\"label\":\"Name\",\"inputs\":[{\"id\":\"1.2\",\"label\":\"Prefix\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-prefix\",\"choices\":[{\"text\":\"Mr.\",\"value\":\"Mr.\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Mrs.\",\"value\":\"Mrs.\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Miss\",\"value\":\"Miss\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Ms.\",\"value\":\"Ms.\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Dr.\",\"value\":\"Dr.\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Prof.\",\"value\":\"Prof.\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Rev.\",\"value\":\"Rev.\",\"isSelected\":false,\"price\":\"\"}],\"isHidden\":true,\"inputType\":\"radio\",\"placeholder\":\"Enter your prefix\"},{\"id\":\"1.3\",\"label\":\"First\",\"name\":\"\",\"placeholder\":\"First Name\",\"autocompleteAttribute\":\"given-name\"},{\"id\":\"1.4\",\"label\":\"Middle\",\"name\":\"\",\"autocompleteAttribute\":\"additional-name\",\"isHidden\":true,\"placeholder\":\"Enter your middle name\"},{\"id\":\"1.6\",\"label\":\"Last\",\"name\":\"\",\"placeholder\":\"Last Name\",\"autocompleteAttribute\":\"family-name\"},{\"id\":\"1.8\",\"label\":\"Suffix\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-suffix\",\"isHidden\":true,\"placeholder\":\"Enter your suffix\"}],\"inputType\":\"name\",\"displayOnly\":\"\",\"nameFormat\":\"advanced\",\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"hidden_label\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"defaultValue\":\"\",\"description\":\"\",\"visibility\":\"visible\",\"fields\":\"\",\"layoutGroupId\":\"755102fe\",\"adminLabel\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"enableAutocomplete\":true,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"formId\":1},{\"is_payment\":false,\"type\":\"email\",\"id\":2,\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"please supply a valid email address\",\"label\":\"Email\",\"inputType\":\"email\",\"displayOnly\":\"\",\"inputs\":[{\"id\":\"2\",\"label\":\"Enter Email\",\"name\":\"\",\"autocompleteAttribute\":\"email\",\"placeholder\":\"Enter Email\"},{\"id\":\"2.2\",\"label\":\"Confirm Email\",\"name\":\"\",\"autocompleteAttribute\":\"email\",\"placeholder\":\"Confirm Email\"}],\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"hidden_label\",\"placeholder\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"visibility\":\"visible\",\"fields\":\"\",\"inputMaskIsCustom\":false,\"layoutGroupId\":\"17f293c9\",\"autocompleteAttribute\":\"\",\"emailConfirmEnabled\":true,\"adminLabel\":\"\",\"description\":\"\",\"maxLength\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":true,\"pageNumber\":1,\"formId\":1},{\"is_payment\":false,\"type\":\"textarea\",\"id\":3,\"isRequired\":true,\"size\":\"medium\",\"label\":\"Comments\",\"inputType\":\"textarea\",\"displayOnly\":\"\",\"inputs\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Enter Your Message\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"allowsPrepopulate\":false,\"useRichTextEditor\":false,\"visibility\":\"visible\",\"fields\":\"\",\"inputMaskIsCustom\":false,\"description\":\"\",\"defaultValue\":\"\",\"checkboxLabel\":\"\",\"maxLength\":600,\"layoutGroupId\":\"2de1220e\",\"adminLabel\":\"\",\"errorMessage\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"formId\":1}],\"descriptionPlacement\":\"above\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"nextFieldId\":4,\"subLabelPlacement\":\"above\",\"cssClass\":\"\",\"enableHoneypot\":true,\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"version\":\"2.9.23\",\"validationSummary\":\"1\",\"requiredIndicator\":\"text\",\"customRequiredIndicator\":\"\",\"markupVersion\":2,\"autoResponder\":{\"from\":\"{admin_email}\",\"subject\":\"We have received your inquiry\",\"message\":\"<p>Hi there {Name (First):1.3},<\\/p><p>Thank you for getting in touch. We have received your inquiry and will get back to you within one business day.<\\/p>\",\"toField\":\"2\"},\"delete_entry\":\"\",\"delete_entry_condition\":\"\",\"delete_entry_period\":\"\",\"delete_entry_units\":\"hour\",\"template_id\":\"basic_contact\",\"id\":1,\"validationPlacement\":\"below\",\"saveButtonText\":\"Save and Continue Later\",\"honeypotAction\":\"abort\",\"deprecated\":\"\",\"saveEnabled\":\"\"}", NULL, "{\"5179518e5e160\":{\"type\":\"message\",\"id\":\"5179518e5e160\",\"isDefault\":true,\"message\":\"Thank you for contacting us! We will get in touch with you shortly.\",\"name\":\"Default Confirmation\",\"disableAutoformat\":false,\"pageId\":0,\"url\":\"\",\"queryString\":\"\",\"conditionalLogic\":[]}}", "{\"51794abf1f0d1\":{\"id\":\"51794abf1f0d1\",\"from\":\"{admin_email}\",\"subject\":\"We have received your inquiry\",\"message\":\"<p>Hi there {Name (First):1.3},<\\/p><p>Thank you for getting in touch. We have received your inquiry and will get back to you within one business day.<\\/p>\",\"toType\":\"field\",\"toField\":\"2\",\"to\":\"2\",\"event\":\"form_submission\",\"name\":\"User Notification\",\"type\":\"user\"},\"51794abf1f0d2\":{\"id\":\"51794abf1f0d2\",\"from\":\"website@innovative.ink\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\",\"toType\":\"email\",\"to\":\"web-admin@innovative.ink\",\"event\":\"form_submission\",\"name\":\"Admin Notification\",\"service\":\"wordpress\",\"toEmail\":\"web-admin@innovative.ink\",\"toField\":\"\",\"routing\":null,\"fromName\":\"{Name (First):1.3} {Name (Last):1.6}\",\"replyTo\":\"{Email:2}\",\"bcc\":\"\",\"disableAutoformat\":false,\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\",\"conditionalLogic\":null,\"cc\":\"\",\"enableAttachments\":false}}");
INSERT INTO `wp_gf_form_meta` VALUES("2", "{\"title\":\"Careers\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Submit Resume\",\"imageUrl\":\"\",\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12},\"fields\":[{\"type\":\"text\",\"id\":1,\"label\":\"Name\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Name\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"enablePasswordInput\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"layoutGroupId\":\"ecee84e0\"},{\"type\":\"text\",\"id\":3,\"label\":\"Address\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Address\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"enablePasswordInput\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"layoutGroupId\":\"be37b32c\"},{\"type\":\"phone\",\"id\":4,\"label\":\"Phone\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"standard\",\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"phone\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Phone\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"form_id\":\"\",\"productField\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"layoutGroupId\":\"5c171305\",\"layoutGridColumnSpan\":6},{\"type\":\"email\",\"id\":5,\"label\":\"Email\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"email\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Email\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"emailConfirmEnabled\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"layoutGroupId\":\"5c171305\",\"layoutGridColumnSpan\":6},{\"type\":\"fileupload\",\"id\":10,\"label\":\"Attach Cover Letter\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"fileupload\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"maxFileSize\":\"\",\"maxFiles\":\"\",\"multipleFiles\":false,\"allowedExtensions\":\"\",\"productField\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"fields\":\"\",\"displayOnly\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"layoutGroupId\":\"738d7dfa\"},{\"type\":\"fileupload\",\"id\":11,\"label\":\"Attach Resume\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"formId\":2,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"fileupload\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"maxFileSize\":\"\",\"maxFiles\":\"\",\"multipleFiles\":false,\"allowedExtensions\":\"\",\"productField\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"fields\":\"\",\"displayOnly\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"pageNumber\":1,\"layoutGroupId\":\"8b1d5d00\"}],\"version\":\"2.8.16\",\"id\":2,\"nextFieldId\":13,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"subLabelPlacement\":\"below\",\"cssClass\":\"\",\"enableHoneypot\":true,\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"requiredIndicator\":\"asterisk\",\"customRequiredIndicator\":\"(Required)\",\"saveButtonText\":\"Save and Continue Later\",\"honeypotAction\":\"abort\",\"validationSummary\":false,\"deprecated\":\"\",\"saveEnabled\":\"\",\"markupVersion\":2}", NULL, "{\"5d4b2dfb24f6e\":{\"id\":\"5d4b2dfb24f6e\",\"name\":\"Default Confirmation\",\"isDefault\":true,\"type\":\"message\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}", "{\"5d4b2dfb24d14\":{\"isActive\":true,\"name\":\"bricks@bricks.com\",\"service\":\"wordpress\",\"event\":\"form_submission\",\"to\":\"bricks@bricks.com\",\"toType\":\"email\",\"cc\":\"\",\"bcc\":\"\",\"subject\":\"Job Application From {Name:1}\",\"message\":\"{all_fields}\",\"from\":\"website@bricks.com\",\"fromName\":\"{Name:1}\",\"replyTo\":\"{Email:5}\",\"routing\":null,\"conditionalLogic\":null,\"disableAutoformat\":false,\"enableAttachments\":false,\"id\":\"5d4b2dfb24d14\",\"toEmail\":\"bricks@bricks.com\",\"toField\":\"\",\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\"}}");
INSERT INTO `wp_gf_form_meta` VALUES("3", "{\"title\":\"Lead Form\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\",\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12,\"id\":\"submit\"},\"fields\":[{\"type\":\"name\",\"id\":3,\"formId\":3,\"label\":\"Name\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"nameFormat\":\"advanced\",\"inputs\":[{\"id\":\"3.2\",\"label\":\"Prefix\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-prefix\",\"choices\":[{\"text\":\"Dr.\",\"value\":\"Dr.\"},{\"text\":\"Miss\",\"value\":\"Miss\"},{\"text\":\"Mr.\",\"value\":\"Mr.\"},{\"text\":\"Mrs.\",\"value\":\"Mrs.\"},{\"text\":\"Ms.\",\"value\":\"Ms.\"},{\"text\":\"Mx.\",\"value\":\"Mx.\"},{\"text\":\"Prof.\",\"value\":\"Prof.\"},{\"text\":\"Rev.\",\"value\":\"Rev.\"}],\"isHidden\":true,\"inputType\":\"radio\"},{\"id\":\"3.3\",\"label\":\"First\",\"name\":\"\",\"autocompleteAttribute\":\"given-name\",\"customLabel\":\"Name\",\"placeholder\":\"Your name\"},{\"id\":\"3.4\",\"label\":\"Middle\",\"name\":\"\",\"autocompleteAttribute\":\"additional-name\",\"isHidden\":true},{\"id\":\"3.6\",\"label\":\"Last\",\"name\":\"\",\"autocompleteAttribute\":\"family-name\",\"isHidden\":true},{\"id\":\"3.8\",\"label\":\"Suffix\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-suffix\",\"isHidden\":true}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"hidden_label\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableEnhancedUI\":0,\"layoutGroupId\":\"c6168cc3\",\"fields\":\"\",\"displayOnly\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"inputType\":\"\"},{\"type\":\"phone\",\"id\":4,\"formId\":3,\"label\":\"Phone\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"standard\",\"autocompleteAttribute\":\"tel\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your phone\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableEnhancedUI\":0,\"layoutGroupId\":\"52a16ea4\",\"fields\":\"\",\"displayOnly\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"inputType\":\"\"},{\"type\":\"email\",\"id\":5,\"formId\":3,\"label\":\"Email\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"autocompleteAttribute\":\"email\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your email\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"emailConfirmEnabled\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"52a16ea4\",\"fields\":\"\",\"displayOnly\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"inputType\":\"\"}],\"version\":\"2.9.0\",\"id\":3,\"markupVersion\":2,\"nextFieldId\":6,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"validationPlacement\":\"below\",\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"text\",\"customRequiredIndicator\":\"(Required)\",\"cssClass\":\"\",\"saveButtonText\":\"Save & Continue\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"enableHoneypot\":true,\"honeypotAction\":\"abort\",\"validationSummary\":false,\"deprecated\":\"\",\"saveEnabled\":\"\",\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save & Continue\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\"}", NULL, "{\"6348dac5b6968\":{\"id\":\"6348dac5b6968\",\"name\":\"Default Confirmation\",\"isDefault\":true,\"type\":\"message\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}", "{\"6348dac5b6736\":{\"id\":\"6348dac5b6736\",\"isActive\":true,\"to\":\"web-admin@innovative.ink\",\"name\":\"admin\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"New submission from {form_title}\",\"message\":\"New Quote Request from {Name (First):3.3}\\r\\n\\r\\n{all_fields}\",\"service\":\"wordpress\",\"toEmail\":\"web-admin@innovative.ink\",\"toField\":\"\",\"routing\":null,\"fromName\":\"{Name (First):3.3}\",\"from\":\"website@innovative.ink\",\"replyTo\":\"{Email:5}\",\"bcc\":\"\",\"disableAutoformat\":false,\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\",\"conditionalLogic\":null,\"cc\":\"\",\"enableAttachments\":false}}");
INSERT INTO `wp_gf_form_meta` VALUES("4", "{\"title\":\"Lead Form w Message\",\"description\":\"\",\"labelPlacement\":\"top_label\",\"descriptionPlacement\":\"below\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\",\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12,\"id\":\"submit\"},\"fields\":[{\"type\":\"name\",\"id\":3,\"formId\":4,\"label\":\"Name\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"nameFormat\":\"advanced\",\"inputs\":[{\"id\":\"3.2\",\"label\":\"Prefix\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-prefix\",\"choices\":[{\"text\":\"Dr.\",\"value\":\"Dr.\"},{\"text\":\"Miss\",\"value\":\"Miss\"},{\"text\":\"Mr.\",\"value\":\"Mr.\"},{\"text\":\"Mrs.\",\"value\":\"Mrs.\"},{\"text\":\"Ms.\",\"value\":\"Ms.\"},{\"text\":\"Mx.\",\"value\":\"Mx.\"},{\"text\":\"Prof.\",\"value\":\"Prof.\"},{\"text\":\"Rev.\",\"value\":\"Rev.\"}],\"isHidden\":true,\"inputType\":\"radio\"},{\"id\":\"3.3\",\"label\":\"First\",\"name\":\"\",\"autocompleteAttribute\":\"given-name\",\"customLabel\":\"Name\",\"placeholder\":\"Your name\"},{\"id\":\"3.4\",\"label\":\"Middle\",\"name\":\"\",\"autocompleteAttribute\":\"additional-name\",\"isHidden\":true},{\"id\":\"3.6\",\"label\":\"Last\",\"name\":\"\",\"autocompleteAttribute\":\"family-name\",\"isHidden\":true},{\"id\":\"3.8\",\"label\":\"Suffix\",\"name\":\"\",\"autocompleteAttribute\":\"honorific-suffix\",\"isHidden\":true}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"hidden_label\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableEnhancedUI\":0,\"layoutGroupId\":\"c6168cc3\",\"fields\":\"\",\"displayOnly\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"inputType\":\"name\"},{\"type\":\"phone\",\"id\":4,\"formId\":4,\"label\":\"Phone\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"phoneFormat\":\"standard\",\"autocompleteAttribute\":\"tel\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your phone\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableEnhancedUI\":0,\"layoutGroupId\":\"52a16ea4\",\"fields\":\"\",\"displayOnly\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"inputType\":\"phone\"},{\"type\":\"email\",\"id\":5,\"formId\":4,\"label\":\"Email\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"autocompleteAttribute\":\"email\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your email\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"emailConfirmEnabled\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"52a16ea4\",\"fields\":\"\",\"displayOnly\":\"\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"checkboxLabel\":\"\",\"pageNumber\":1,\"inputType\":\"email\"},{\"type\":\"textarea\",\"id\":6,\"formId\":4,\"label\":\"Your Message\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"medium\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"textarea\",\"labelPlacement\":\"hidden_label\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your message\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"form_id\":\"\",\"useRichTextEditor\":false,\"enableEnhancedUI\":0,\"layoutGroupId\":\"78a2da0c\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"}],\"version\":\"2.9.0\",\"id\":4,\"markupVersion\":2,\"nextFieldId\":7,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"validationPlacement\":\"below\",\"subLabelPlacement\":\"below\",\"requiredIndicator\":\"text\",\"customRequiredIndicator\":\"(Required)\",\"cssClass\":\"\",\"saveButtonText\":\"Save & Continue\",\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleEnd\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"enableHoneypot\":true,\"honeypotAction\":\"abort\",\"validationSummary\":false,\"deprecated\":\"\",\"saveEnabled\":\"\",\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save & Continue\"}},\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\"}", NULL, "{\"6348dac5b6968\":{\"id\":\"6348dac5b6968\",\"name\":\"Default Confirmation\",\"isDefault\":true,\"type\":\"message\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}", "{\"6348dac5b6736\":{\"id\":\"6348dac5b6736\",\"isActive\":true,\"to\":\"web-admin@innovative.ink\",\"name\":\"admin\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"New submission from {form_title}\",\"message\":\"New Quote Request from {Name (First):3.3}\\r\\n\\r\\n{all_fields}\",\"service\":\"wordpress\",\"toEmail\":\"web-admin@innovative.ink\",\"toField\":\"\",\"routing\":null,\"fromName\":\"{Name (First):3.3}\",\"from\":\"website@innovative.ink\",\"replyTo\":\"{Email:5}\",\"bcc\":\"\",\"disableAutoformat\":false,\"notification_conditional_logic_object\":\"\",\"notification_conditional_logic\":\"0\",\"conditionalLogic\":null,\"cc\":\"\",\"enableAttachments\":false}}");
INSERT INTO `wp_gf_form_meta` VALUES("5", "{\"fields\":[{\"is_payment\":false,\"type\":\"text\",\"id\":1,\"formId\":5,\"label\":\"Customer Name\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":\"\",\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"4ce8174a\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"}],\"button\":{\"type\":\"text\",\"text\":\"\",\"imageUrl\":\"\",\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12},\"title\":\"Work Order\",\"description\":\"\",\"version\":\"2.9.23.2\",\"id\":5,\"markupVersion\":2,\"nextFieldId\":3,\"useCurrentUserAsAuthor\":true,\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null}", NULL, "{\"6931ea2ad2be0\":{\"id\":\"6931ea2ad2be0\",\"name\":\"Default Confirmation\",\"isDefault\":true,\"type\":\"message\",\"message\":\"Thanks for contacting us! We will get in touch with you shortly.\",\"url\":\"\",\"pageId\":\"\",\"queryString\":\"\"}}", "{\"6931ea2ad2b2e\":{\"id\":\"6931ea2ad2b2e\",\"isActive\":true,\"to\":\"{admin_email}\",\"name\":\"Admin Notification\",\"event\":\"form_submission\",\"toType\":\"email\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\"}}");
INSERT INTO `wp_gf_form_meta` VALUES("6", "{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"postAuthor\":\"1\",\"postCategory\":\"1\",\"postStatus\":\"draft\",\"title\":\"Preventative Maintenance\",\"description\":\"Fill and Complete the Checklist on all PM\'s\",\"maxEntriesAllowed\":\"0\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\",\"conditionalLogic\":null,\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12},\"fields\":[{\"is_payment\":false,\"type\":\"date\",\"id\":4,\"formId\":6,\"label\":\"Date of the PM\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"dateType\":\"datepicker\",\"dateFormat\":\"mdy\",\"dateFormatPlacement\":\"below\",\"calendarIconType\":\"calendar\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"date\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"calendarIconUrl\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"ce1d3ad5\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"text\",\"id\":6,\"formId\":6,\"label\":\"Customer where the service was performed?\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Answer\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"9feab2a6\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"time\",\"id\":7,\"formId\":6,\"label\":\"Arrival Time\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":[{\"id\":\"7.1\",\"label\":\"Hour\",\"name\":\"\"},{\"id\":\"7.2\",\"label\":\"Minute\",\"name\":\"\"},{\"id\":\"7.3\",\"label\":\"AM\\/PM\",\"name\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"time\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"timeFormat\":\"12\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"183278c4\",\"layoutSpacerGridColumnSpan\":0,\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"time\",\"id\":8,\"formId\":6,\"label\":\"Departure\\/Completion Time\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":[{\"id\":\"8.1\",\"label\":\"Hour\",\"name\":\"\"},{\"id\":\"8.2\",\"label\":\"Minute\",\"name\":\"\"},{\"id\":\"8.3\",\"label\":\"AM\\/PM\",\"name\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"time\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"timeFormat\":\"12\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"183278c4\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"radio\",\"id\":9,\"formId\":6,\"label\":\"Name of Technician\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"Aron\",\"value\":\"Aron\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Ben\",\"value\":\"Ben\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Herman\",\"value\":\"Herman\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"radio\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableOtherChoice\":\"\",\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"2dfcc76d\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"page\",\"id\":10,\"formId\":6,\"label\":\"\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"nextButton\":{\"type\":\"text\",\"text\":\"Next\",\"imageUrl\":\"\",\"id\":10},\"previousButton\":{\"type\":\"text\",\"text\":\"Previous\",\"imageUrl\":\"\"},\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"page\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"eb607c53\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"pageNumber\":2,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"html\",\"id\":20,\"formId\":6,\"label\":\"Motion Axis Checklist\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"displayOnly\":true,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"html\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"content\":\"<h2>\\\"Motion Axis Checklist\\\"<\\/h2>\",\"disableMargins\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"420410c5\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":2,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"radio\",\"id\":13,\"formId\":6,\"label\":\"Bearings - No Wear Present and Oiling\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"Y1 Axis\",\"value\":\"Y1 Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Y2 Axis\",\"value\":\"Y2 Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"X Axis\",\"value\":\"X Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"z Axis\",\"value\":\"z Axis\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"radio\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":3,\"enableDisplayInColumns\":\"\",\"enableOtherChoice\":false,\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"41636325\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"layoutSpacerGridColumnSpan\":0,\"pageNumber\":2,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"radio\",\"id\":14,\"formId\":6,\"label\":\"Rack and Pinion - Tight, no Backlash\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"Y1 Axis\",\"value\":\"Y1 Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Y2 Axis\",\"value\":\"Y2 Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"X Axis\",\"value\":\"X Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"z Axis\",\"value\":\"z Axis\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"radio\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":3,\"enableDisplayInColumns\":\"\",\"enableOtherChoice\":false,\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"41636325\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"layoutSpacerGridColumnSpan\":0,\"pageNumber\":2,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"radio\",\"id\":15,\"formId\":6,\"label\":\"Motor and Gearbox - smooth and quiet\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"Y1 Axis\",\"value\":\"Y1 Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Y2 Axis\",\"value\":\"Y2 Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"X Axis\",\"value\":\"X Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"z Axis\",\"value\":\"z Axis\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"radio\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":3,\"enableDisplayInColumns\":\"\",\"enableOtherChoice\":false,\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"41636325\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"layoutSpacerGridColumnSpan\":0,\"pageNumber\":2,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"radio\",\"id\":16,\"formId\":6,\"label\":\"Bellows and Covers - Intact and no Holes\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"Y1 Axis\",\"value\":\"Y1 Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Y2 Axis\",\"value\":\"Y2 Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"X Axis\",\"value\":\"X Axis\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"z Axis\",\"value\":\"z Axis\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"radio\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":3,\"enableDisplayInColumns\":\"\",\"enableOtherChoice\":false,\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"41636325\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"layoutSpacerGridColumnSpan\":3,\"pageNumber\":2,\"fields\":\"\"}],\"descriptionPlacement\":\"above\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":{\"type\":\"text\",\"text\":\"Previous\",\"imageUrl\":\"\"},\"pagination\":{\"type\":\"percentage\",\"pages\":[\"\"],\"style\":\"blue\",\"backgroundColor\":null,\"color\":null,\"display_progressbar_on_confirmation\":false,\"progressbar_completion_text\":null},\"firstPageCssClass\":\"\",\"nextFieldId\":21,\"subLabelPlacement\":\"above\",\"cssClass\":\"\",\"enableHoneypot\":false,\"honeypotAction\":\"spam\",\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"version\":\"2.9.24\",\"validationSummary\":\"1\",\"requiredIndicator\":\"text\",\"customRequiredIndicator\":\"\",\"markupVersion\":2,\"autoResponder\":{\"from\":\"{admin_email}\",\"subject\":\"We have received your inquiry\",\"message\":\"<p>Hi there {Name (First):1.3},<\\/p><p>Thank you for getting in touch. We have received your inquiry and will get back to you within one business day.<\\/p>\",\"toField\":\"2\"},\"delete_entry\":\"\",\"delete_entry_condition\":\"\",\"delete_entry_period\":\"\",\"delete_entry_units\":\"hour\",\"template_id\":\"basic_contact\",\"id\":6}", NULL, "{\"5179518e5e160\":{\"type\":\"message\",\"id\":\"5179518e5e160\",\"isDefault\":true,\"message\":\"Thank you for contacting us! We will get in touch with you shortly.\",\"name\":\"Default Confirmation\",\"disableAutoformat\":false,\"pageId\":0,\"url\":\"\",\"queryString\":\"\",\"conditionalLogic\":[]}}", "{\"51794abf1f0d1\":{\"id\":\"51794abf1f0d1\",\"from\":\"{admin_email}\",\"subject\":\"We have received your inquiry\",\"message\":\"<p>Hi there {Name (First):1.3},<\\/p><p>Thank you for getting in touch. We have received your inquiry and will get back to you within one business day.<\\/p>\",\"toType\":\"field\",\"toField\":\"2\",\"to\":\"2\",\"event\":\"form_submission\",\"name\":\"User Notification\",\"type\":\"user\"},\"51794abf1f0d2\":{\"id\":\"51794abf1f0d2\",\"from\":\"{admin_email}\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\",\"toType\":\"email\",\"to\":\"{admin_email}\",\"event\":\"form_submission\",\"name\":\"Admin Notification\"}}");
INSERT INTO `wp_gf_form_meta` VALUES("7", "{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"postAuthor\":\"1\",\"postCategory\":\"1\",\"postStatus\":\"draft\",\"title\":\"Service Report\",\"description\":\"\",\"maxEntriesAllowed\":\"0\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\",\"conditionalLogic\":null,\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12},\"fields\":[{\"is_payment\":false,\"type\":\"date\",\"id\":4,\"formId\":7,\"label\":\"Service Date\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"dateType\":\"datepicker\",\"dateFormat\":\"mdy\",\"dateFormatPlacement\":\"below\",\"calendarIconType\":\"calendar\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"date\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"calendarIconUrl\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"ce1d3ad5\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"text\",\"id\":6,\"formId\":7,\"label\":\"Customer where the service was performed?\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Answer\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"9feab2a6\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"time\",\"id\":7,\"formId\":7,\"label\":\"Arrival Time\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":[{\"id\":\"7.1\",\"label\":\"Hour\",\"name\":\"\"},{\"id\":\"7.2\",\"label\":\"Minute\",\"name\":\"\"},{\"id\":\"7.3\",\"label\":\"AM\\/PM\",\"name\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"time\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"timeFormat\":\"12\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"183278c4\",\"layoutSpacerGridColumnSpan\":0,\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"time\",\"id\":8,\"formId\":7,\"label\":\"Departure\\/Completion Time\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":[{\"id\":\"8.1\",\"label\":\"Hour\",\"name\":\"\"},{\"id\":\"8.2\",\"label\":\"Minute\",\"name\":\"\"},{\"id\":\"8.3\",\"label\":\"AM\\/PM\",\"name\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"time\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"timeFormat\":\"12\",\"productField\":\"\",\"layoutGridColumnSpan\":6,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"183278c4\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"radio\",\"id\":9,\"formId\":7,\"label\":\"Name of Technician\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"Aron\",\"value\":\"Aron\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Ben\",\"value\":\"Ben\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Herman\",\"value\":\"Herman\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"radio\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableOtherChoice\":\"\",\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"2dfcc76d\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"select\",\"id\":21,\"formId\":7,\"label\":\"Was the job completed?\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"Yes\",\"value\":\"Yes\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"No\",\"value\":\"No\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"select\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Choose\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"enableEnhancedUI\":false,\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePrice\":\"\",\"layoutGroupId\":\"86d04ddb\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"},{\"is_payment\":false,\"type\":\"text\",\"id\":22,\"formId\":7,\"label\":\"What was the reason for the service call?\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Answer\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"571af291\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"text\",\"id\":24,\"formId\":7,\"label\":\"What was preformed on the service call?\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Answer\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"0d71bab8\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"text\",\"id\":23,\"formId\":7,\"label\":\"List of parts\\/ supplies used or replaced.\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Answer\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"82020b63\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"textarea\",\"id\":25,\"formId\":7,\"label\":\"Other Notes\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"textarea\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Answer\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"useRichTextEditor\":false,\"enableEnhancedUI\":0,\"layoutGroupId\":\"a2c84a92\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\"}],\"descriptionPlacement\":\"above\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"nextFieldId\":26,\"subLabelPlacement\":\"above\",\"cssClass\":\"\",\"enableHoneypot\":false,\"honeypotAction\":\"spam\",\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"version\":\"2.9.24\",\"validationSummary\":\"1\",\"requiredIndicator\":\"text\",\"customRequiredIndicator\":\"\",\"markupVersion\":2,\"autoResponder\":{\"from\":\"{admin_email}\",\"subject\":\"We have received your inquiry\",\"message\":\"<p>Hi there {Name (First):1.3},<\\/p><p>Thank you for getting in touch. We have received your inquiry and will get back to you within one business day.<\\/p>\",\"toField\":\"2\"},\"delete_entry\":\"\",\"delete_entry_condition\":\"\",\"delete_entry_period\":\"\",\"delete_entry_units\":\"hour\",\"template_id\":\"basic_contact\",\"id\":7,\"validationPlacement\":\"below\",\"saveButtonText\":\"Save and Continue Later\",\"submitSpeedCheckThreshold\":2000,\"submitSpeedCheckMode\":\"normal\",\"deprecated\":\"\",\"saveEnabled\":\"\",\"enableSubmitSpeedCheck\":false}", NULL, "{\"5179518e5e160\":{\"type\":\"message\",\"id\":\"5179518e5e160\",\"isDefault\":true,\"message\":\"Thank you for contacting us! We will get in touch with you shortly.\",\"name\":\"Default Confirmation\",\"disableAutoformat\":false,\"pageId\":0,\"url\":\"\",\"queryString\":\"\",\"conditionalLogic\":[]}}", "{\"51794abf1f0d1\":{\"id\":\"51794abf1f0d1\",\"from\":\"{admin_email}\",\"subject\":\"We have received your inquiry\",\"message\":\"<p>Hi there {Name (First):1.3},<\\/p><p>Thank you for getting in touch. We have received your inquiry and will get back to you within one business day.<\\/p>\",\"toType\":\"field\",\"toField\":\"2\",\"to\":\"2\",\"event\":\"form_submission\",\"name\":\"User Notification\",\"type\":\"user\"},\"51794abf1f0d2\":{\"id\":\"51794abf1f0d2\",\"from\":\"{admin_email}\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\",\"toType\":\"email\",\"to\":\"{admin_email}\",\"event\":\"form_submission\",\"name\":\"Admin Notification\"}}");
INSERT INTO `wp_gf_form_meta` VALUES("8", "{\"labelPlacement\":\"top_label\",\"useCurrentUserAsAuthor\":\"1\",\"postAuthor\":\"1\",\"postCategory\":\"1\",\"postStatus\":\"draft\",\"title\":\"Orders\",\"description\":\"\",\"maxEntriesAllowed\":\"0\",\"button\":{\"type\":\"text\",\"text\":\"Submit\",\"imageUrl\":\"\",\"conditionalLogic\":null,\"width\":\"auto\",\"location\":\"bottom\",\"layoutGridColumnSpan\":12},\"fields\":[{\"is_payment\":false,\"type\":\"date\",\"id\":4,\"formId\":8,\"label\":\"Date of Delivery\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"dateType\":\"datepicker\",\"dateFormat\":\"mdy\",\"dateFormatPlacement\":\"below\",\"calendarIconType\":\"calendar\",\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"date\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"calendarIconUrl\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"ce1d3ad5\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"radio\",\"id\":9,\"formId\":8,\"label\":\"Name of Deliverer\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"validateState\":true,\"inputs\":null,\"choices\":[{\"text\":\"Aron\",\"value\":\"Aron\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Ben\",\"value\":\"Ben\",\"isSelected\":false,\"price\":\"\"},{\"text\":\"Herman\",\"value\":\"Herman\",\"isSelected\":false,\"price\":\"\"}],\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"radio\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enableOtherChoice\":true,\"enablePrice\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"2dfcc76d\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"text\",\"id\":22,\"formId\":8,\"label\":\"Customer\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Answer\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"571af291\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"text\",\"id\":24,\"formId\":8,\"label\":\"List of Items Delivered\",\"adminLabel\":\"\",\"isRequired\":true,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"text\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Answer\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"enablePasswordInput\":\"\",\"enableEnhancedUI\":0,\"layoutGroupId\":\"0d71bab8\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"useRichTextEditor\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"},{\"is_payment\":false,\"type\":\"textarea\",\"id\":25,\"formId\":8,\"label\":\"Notes and Backorders\",\"adminLabel\":\"\",\"isRequired\":false,\"size\":\"large\",\"errorMessage\":\"\",\"visibility\":\"visible\",\"inputs\":null,\"description\":\"\",\"allowsPrepopulate\":false,\"inputMask\":false,\"inputMaskValue\":\"\",\"inputMaskIsCustom\":false,\"maxLength\":\"\",\"inputType\":\"textarea\",\"labelPlacement\":\"\",\"descriptionPlacement\":\"\",\"subLabelPlacement\":\"\",\"placeholder\":\"Your Answer\",\"cssClass\":\"\",\"inputName\":\"\",\"noDuplicates\":false,\"defaultValue\":\"\",\"enableAutocomplete\":false,\"autocompleteAttribute\":\"\",\"choices\":\"\",\"conditionalLogic\":\"\",\"productField\":\"\",\"layoutGridColumnSpan\":12,\"enableDisplayInColumns\":\"\",\"useRichTextEditor\":false,\"enableEnhancedUI\":0,\"layoutGroupId\":\"a2c84a92\",\"multipleFiles\":false,\"maxFiles\":\"\",\"calculationFormula\":\"\",\"calculationRounding\":\"\",\"enableCalculation\":\"\",\"disableQuantity\":false,\"displayAllCategories\":false,\"errors\":[],\"pageNumber\":1,\"fields\":\"\",\"displayOnly\":\"\"}],\"descriptionPlacement\":\"above\",\"postContentTemplateEnabled\":false,\"postTitleTemplateEnabled\":false,\"postTitleTemplate\":\"\",\"postContentTemplate\":\"\",\"lastPageButton\":null,\"pagination\":null,\"firstPageCssClass\":null,\"nextFieldId\":26,\"subLabelPlacement\":\"above\",\"cssClass\":\"\",\"enableHoneypot\":false,\"honeypotAction\":\"spam\",\"enableAnimation\":false,\"save\":{\"enabled\":false,\"button\":{\"type\":\"link\",\"text\":\"Save and Continue Later\"}},\"limitEntries\":false,\"limitEntriesCount\":\"\",\"limitEntriesPeriod\":\"\",\"limitEntriesMessage\":\"\",\"scheduleForm\":false,\"scheduleStart\":\"\",\"scheduleStartHour\":\"\",\"scheduleStartMinute\":\"\",\"scheduleStartAmpm\":\"\",\"scheduleEnd\":\"\",\"scheduleEndHour\":\"\",\"scheduleEndMinute\":\"\",\"scheduleEndAmpm\":\"\",\"schedulePendingMessage\":\"\",\"scheduleMessage\":\"\",\"requireLogin\":false,\"requireLoginMessage\":\"\",\"version\":\"2.9.24\",\"validationSummary\":\"1\",\"requiredIndicator\":\"text\",\"customRequiredIndicator\":\"\",\"markupVersion\":2,\"autoResponder\":{\"from\":\"{admin_email}\",\"subject\":\"We have received your inquiry\",\"message\":\"<p>Hi there {Name (First):1.3},<\\/p><p>Thank you for getting in touch. We have received your inquiry and will get back to you within one business day.<\\/p>\",\"toField\":\"2\"},\"delete_entry\":\"\",\"delete_entry_condition\":\"\",\"delete_entry_period\":\"\",\"delete_entry_units\":\"hour\",\"template_id\":\"basic_contact\",\"id\":8,\"validationPlacement\":\"below\",\"saveButtonText\":\"Save and Continue Later\",\"submitSpeedCheckThreshold\":2000,\"submitSpeedCheckMode\":\"normal\",\"deprecated\":\"\",\"saveEnabled\":\"\",\"enableSubmitSpeedCheck\":false}", NULL, "{\"5179518e5e160\":{\"type\":\"message\",\"id\":\"5179518e5e160\",\"isDefault\":true,\"message\":\"Thank you for contacting us! We will get in touch with you shortly.\",\"name\":\"Default Confirmation\",\"disableAutoformat\":false,\"pageId\":0,\"url\":\"\",\"queryString\":\"\",\"conditionalLogic\":[]}}", "{\"51794abf1f0d1\":{\"id\":\"51794abf1f0d1\",\"from\":\"{admin_email}\",\"subject\":\"We have received your inquiry\",\"message\":\"<p>Hi there {Name (First):1.3},<\\/p><p>Thank you for getting in touch. We have received your inquiry and will get back to you within one business day.<\\/p>\",\"toType\":\"field\",\"toField\":\"2\",\"to\":\"2\",\"event\":\"form_submission\",\"name\":\"User Notification\",\"type\":\"user\"},\"51794abf1f0d2\":{\"id\":\"51794abf1f0d2\",\"from\":\"{admin_email}\",\"subject\":\"New submission from {form_title}\",\"message\":\"{all_fields}\",\"toType\":\"email\",\"to\":\"{admin_email}\",\"event\":\"form_submission\",\"name\":\"Admin Notification\"}}");

/* INSERT TABLE DATA: wp_gf_form_view */
INSERT INTO `wp_gf_form_view` VALUES("1", "1", "2024-05-21 14:02:24", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("2", "1", "2024-05-28 01:38:05", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("3", "1", "2024-06-04 01:38:14", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("4", "1", "2024-06-26 20:18:07", "", "49");
INSERT INTO `wp_gf_form_view` VALUES("5", "1", "2024-07-03 15:35:25", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("6", "1", "2024-07-08 21:56:27", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("7", "1", "2024-07-10 05:37:18", "", "26");
INSERT INTO `wp_gf_form_view` VALUES("8", "1", "2024-07-11 17:10:31", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("9", "1", "2024-07-16 05:37:32", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("10", "1", "2024-07-17 05:44:49", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("11", "1", "2024-07-18 18:30:45", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("12", "1", "2024-07-22 12:50:22", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("13", "1", "2024-07-24 05:41:57", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("14", "1", "2024-07-26 03:12:43", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("15", "1", "2024-07-29 19:07:52", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("16", "1", "2024-07-31 05:38:14", "", "12");
INSERT INTO `wp_gf_form_view` VALUES("17", "1", "2024-08-02 16:45:39", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("18", "1", "2024-08-03 16:46:05", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("19", "1", "2024-08-05 16:05:24", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("20", "1", "2024-08-06 16:19:02", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("21", "1", "2024-08-09 01:39:16", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("22", "1", "2024-08-10 05:37:16", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("23", "1", "2024-08-11 05:38:07", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("24", "1", "2024-08-13 05:41:29", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("25", "1", "2024-08-15 05:37:42", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("26", "1", "2024-08-16 16:04:53", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("27", "1", "2024-08-20 05:37:43", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("28", "1", "2024-08-21 05:38:07", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("29", "1", "2024-08-26 13:28:42", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("30", "1", "2024-08-27 18:46:31", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("31", "1", "2024-10-09 22:05:20", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("32", "1", "2024-10-11 20:14:07", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("33", "1", "2024-10-14 05:38:36", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("34", "1", "2024-10-15 05:40:34", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("35", "1", "2024-10-17 05:39:20", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("36", "1", "2024-10-18 13:44:09", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("37", "1", "2024-10-19 19:06:56", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("38", "1", "2024-10-22 05:37:28", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("39", "1", "2024-10-23 05:39:21", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("40", "1", "2024-10-30 05:38:16", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("41", "1", "2024-11-02 05:38:48", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("42", "1", "2024-11-04 19:15:22", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("43", "1", "2024-11-06 06:38:25", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("44", "1", "2024-11-09 06:37:48", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("45", "1", "2024-11-13 06:47:00", "", "13");
INSERT INTO `wp_gf_form_view` VALUES("46", "1", "2024-11-17 14:46:39", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("47", "1", "2024-11-18 16:59:05", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("48", "1", "2024-11-20 06:38:18", "", "5");
INSERT INTO `wp_gf_form_view` VALUES("49", "1", "2024-11-21 20:49:17", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("50", "3", "2024-11-25 14:52:31", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("51", "3", "2024-11-30 12:46:30", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("52", "4", "2024-11-30 15:31:22", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("53", "4", "2024-12-03 01:28:37", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("54", "4", "2024-12-10 06:40:14", "", "13");
INSERT INTO `wp_gf_form_view` VALUES("55", "4", "2024-12-17 06:39:10", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("56", "4", "2025-01-07 06:37:55", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("57", "4", "2025-01-13 21:06:17", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("58", "4", "2025-01-28 06:39:02", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("59", "4", "2025-02-04 06:37:38", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("60", "4", "2025-02-07 21:50:20", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("61", "4", "2025-02-11 06:37:58", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("62", "1", "2025-02-18 06:38:06", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("63", "4", "2025-02-18 06:38:06", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("64", "1", "2025-02-25 06:42:03", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("65", "4", "2025-02-25 06:42:03", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("66", "1", "2025-03-04 06:38:48", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("67", "4", "2025-03-04 06:38:48", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("68", "4", "2025-03-11 05:39:45", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("69", "1", "2025-03-11 05:39:45", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("70", "4", "2025-03-18 05:38:42", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("71", "1", "2025-03-18 05:38:42", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("72", "4", "2025-03-20 11:05:26", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("73", "4", "2025-04-05 23:19:06", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("74", "1", "2025-04-05 23:45:36", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("75", "4", "2025-04-11 02:44:28", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("76", "4", "2025-04-15 20:03:50", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("77", "4", "2025-04-26 01:55:25", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("78", "4", "2025-05-11 02:00:09", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("79", "1", "2025-05-11 02:32:58", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("80", "4", "2025-05-21 04:18:04", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("81", "4", "2025-05-25 22:22:21", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("82", "4", "2025-05-31 02:59:05", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("83", "1", "2025-06-04 20:46:51", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("84", "4", "2025-06-09 20:05:14", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("85", "4", "2025-06-14 20:32:57", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("86", "4", "2025-06-19 17:22:32", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("87", "1", "2025-06-19 17:40:19", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("88", "4", "2025-06-24 18:53:39", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("89", "4", "2025-06-29 17:27:34", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("90", "4", "2025-07-02 02:14:13", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("91", "4", "2025-07-04 21:40:10", "", "7");
INSERT INTO `wp_gf_form_view` VALUES("92", "1", "2025-07-04 22:12:56", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("93", "4", "2025-07-06 22:36:52", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("94", "4", "2025-07-09 17:48:37", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("95", "1", "2025-07-14 19:14:48", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("96", "1", "2025-08-08 17:50:40", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("97", "4", "2025-08-13 20:43:43", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("98", "4", "2025-08-20 19:16:39", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("99", "4", "2025-08-23 17:56:14", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("100", "1", "2025-08-23 18:48:46", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("101", "4", "2025-08-26 04:52:31", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("102", "4", "2025-08-29 00:09:51", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("103", "1", "2025-09-02 18:23:43", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("104", "4", "2025-09-22 22:14:53", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("105", "4", "2025-09-24 18:44:23", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("106", "4", "2025-09-27 19:16:36", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("107", "4", "2025-10-07 19:51:41", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("108", "4", "2025-10-13 04:53:36", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("109", "4", "2025-10-20 07:47:06", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("110", "4", "2025-10-23 05:11:26", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("111", "1", "2025-10-24 15:22:00", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("112", "4", "2025-10-24 15:22:00", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("113", "1", "2025-12-01 16:08:48", "", "8");
INSERT INTO `wp_gf_form_view` VALUES("114", "1", "2025-12-03 18:06:26", "", "6");
INSERT INTO `wp_gf_form_view` VALUES("115", "1", "2025-12-04 21:22:41", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("116", "5", "2025-12-06 21:43:48", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("117", "5", "2025-12-08 16:42:38", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("118", "1", "2025-12-09 15:46:32", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("119", "1", "2025-12-10 20:32:45", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("120", "5", "2025-12-10 20:33:03", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("121", "1", "2025-12-12 20:21:59", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("122", "7", "2025-12-15 13:59:18", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("123", "5", "2025-12-15 14:53:47", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("124", "5", "2025-12-17 11:22:36", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("125", "8", "2025-12-17 18:24:59", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("126", "6", "2025-12-17 18:25:53", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("127", "7", "2025-12-17 18:27:42", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("128", "1", "2025-12-20 00:32:19", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("129", "8", "2025-12-20 00:38:06", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("130", "6", "2025-12-20 00:40:17", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("131", "7", "2025-12-20 00:40:47", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("132", "6", "2026-01-05 14:33:27", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("133", "7", "2026-01-05 14:34:55", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("134", "1", "2026-01-05 14:38:36", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("135", "1", "2026-01-09 14:30:37", "", "4");
INSERT INTO `wp_gf_form_view` VALUES("136", "7", "2026-01-09 15:31:56", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("137", "6", "2026-01-09 15:32:05", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("138", "1", "2026-01-13 00:55:29", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("139", "1", "2026-01-27 16:31:21", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("140", "6", "2026-01-27 16:40:02", "", "2");
INSERT INTO `wp_gf_form_view` VALUES("141", "8", "2026-01-27 16:40:29", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("142", "7", "2026-01-27 16:41:47", "", "1");
INSERT INTO `wp_gf_form_view` VALUES("143", "1", "2026-01-29 16:58:26", "", "3");
INSERT INTO `wp_gf_form_view` VALUES("144", "1", "2026-02-02 14:12:03", "", "1");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://stage.innovative.ink/bmi", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://stage.innovative.ink/bmi", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "BMI Laser", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "web-admin@innovative.ink", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "0", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j F Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:16:{i:0;s:29:\"gravityforms/gravityforms.php\";i:1;s:34:\"advanced-custom-fields-pro/acf.php\";i:2;s:43:\"automaticcss-plugin/automaticcss-plugin.php\";i:3;s:33:\"bricksultimate/bricksultimate.php\";i:4;s:31:\"code-snippets/code-snippets.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:25:\"duplicator/duplicator.php\";i:7;s:31:\"frames-plugin/frames-plugin.php\";i:8;s:35:\"gravityformsrecaptcha/recaptcha.php\";i:10;s:38:\"seo-by-rank-math-pro/rank-math-pro.php\";i:11;s:30:\"seo-by-rank-math/rank-math.php\";i:12;s:37:\"view-transitions/view-transitions.php\";i:13;s:49:\"wp-grid-builder-bricks/wp-grid-builder-bricks.php\";i:14;s:51:\"wp-grid-builder-caching/wp-grid-builder-caching.php\";i:15;s:55:\"wp-grid-builder-map-facet/wp-grid-builder-map-facet.php\";i:16;s:35:\"wp-grid-builder/wp-grid-builder.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "bricks", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "bricks-child", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "60717", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "America/Toronto", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "11", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "1712", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1730572798", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "wp_attachment_pages_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("100", "initial_db_version", "56657", "yes");
INSERT INTO `wp_options` VALUES("101", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:137:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;s:17:\"bricks_upload_svg\";b:1;s:19:\"bricks_execute_code\";b:1;s:29:\"bricks_form_submission_access\";b:1;s:16:\"create_customers\";b:1;s:18:\"bricks_full_access\";b:1;s:25:\"bricks_bypass_maintenance\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:14:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("102", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("103", "WPLANG", "en_CA", "yes");
INSERT INTO `wp_options` VALUES("104", "user_count", "1", "no");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("107", "cron", "a:20:{i:1770841481;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1770842521;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770844079;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1770844593;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1770846520;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770854400;a:2:{s:30:\"rank_math/links/internal_links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:35:\"rank_math/redirection/clean_trashed\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770874860;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1770878398;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1770878430;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1770905336;a:1:{s:37:\"wp_grid_builder_caching/cleanup_cache\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"wpgb_caching_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770910212;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1770921598;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770921630;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770923513;a:1:{s:35:\"rank_math/content-ai/update_prompts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1770926399;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1771125301;a:1:{s:23:\"sbr_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1771267198;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1771268400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1771353598;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("124", "theme_mods_twentytwentyfour", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1715020897;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("125", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("133", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("140", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"web-admin@innovative.ink\";s:7:\"version\";s:5:\"6.9.1\";s:9:\"timestamp\";i:1770397978;}", "off");
INSERT INTO `wp_options` VALUES("163", "recently_activated", "a:2:{s:35:\"reviews-feed-pro/sb-reviews-pro.php\";i:1761319506;s:27:\"woocommerce/woocommerce.php\";i:1761319473;}", "off");
INSERT INTO `wp_options` VALUES("168", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("171", "current_theme", "Bricks Child Theme", "yes");
INSERT INTO `wp_options` VALUES("172", "theme_mods_bricks-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:277;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1732233478;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "on");
INSERT INTO `wp_options` VALUES("173", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("174", "bricks_global_settings", "a:34:{s:9:\"postTypes\";a:1:{i:0;s:4:\"page\";}s:16:\"disableOpenGraph\";b:1;s:10:\"disableSeo\";b:1;s:19:\"elementAttsAsNeeded\";b:1;s:12:\"smoothScroll\";b:1;s:28:\"searchResultsQueryBricksData\";b:1;s:17:\"customBreakpoints\";b:1;s:10:\"login_page\";s:3:\"188\";s:20:\"wp_auth_url_behavior\";s:7:\"default\";s:24:\"disable_brx_use_wp_login\";b:1;s:15:\"remoteTemplates\";a:2:{i:0;a:3:{s:4:\"name\";s:6:\"Frames\";s:3:\"url\";s:27:\"https://bricks.getframes.io\";s:8:\"password\";s:32:\"ddceb878c91d495c70d02fdcec98d64a\";}i:1;a:3:{s:4:\"name\";s:11:\"BricksMaven\";s:3:\"url\";s:28:\"https://acss.bricksmaven.com\";s:8:\"password\";s:22:\"wEo8xsM6@0b5Xa9!TGgZz*\";}}s:23:\"builderAutosaveDisabled\";b:1;s:11:\"builderMode\";s:4:\"dark\";s:13:\"builderLocale\";s:5:\"en_US\";s:22:\"builderToolbarLogoLink\";s:7:\"current\";s:28:\"builderToolbarLogoLinkNewTab\";b:1;s:33:\"builderResponsiveControlIndicator\";s:3:\"any\";s:21:\"disableElementSpacing\";b:1;s:25:\"structureDuplicateElement\";b:1;s:22:\"structureDeleteElement\";b:1;s:18:\"structureCollapsed\";b:1;s:17:\"structureAutoSync\";b:1;s:24:\"enableDynamicDataPreview\";b:1;s:28:\"builderDisableWpCustomFields\";b:1;s:25:\"builderDynamicDropdownKey\";b:1;s:29:\"builderDynamicDropdownNoLabel\";b:1;s:28:\"builderDynamicDropdownExpand\";b:1;s:13:\"disableEmojis\";b:1;s:15:\"disableLazyLoad\";b:1;s:20:\"disableJqueryMigrate\";b:1;s:20:\"disableClassChaining\";b:1;s:14:\"apiKeyUnsplash\";s:43:\"W1JFy0Qk7S9L_gXsNzE_GCkqEeSQn1l9P6wtboKUEU0\";s:16:\"apiKeyGoogleMaps\";s:39:\"AIzaSyDoe2s5oIV3mIX0XLjf_myZ5ritmfl0Tjk\";s:18:\"executeCodeEnabled\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("176", "bricks_license_key", "61bf6da663c368bc17c01b66e4c0b06d", "yes");
INSERT INTO `wp_options` VALUES("179", "bricks_code_signatures_admin_notice", "1", "yes");
INSERT INTO `wp_options` VALUES("183", "code_snippets_version", "3.9.5", "yes");
INSERT INTO `wp_options` VALUES("184", "code_snippets_settings", "a:3:{s:5:\"debug\";a:0:{}s:7:\"general\";a:8:{s:19:\"activate_by_default\";b:1;s:11:\"enable_tags\";b:1;s:18:\"enable_description\";b:1;s:18:\"visual_editor_rows\";i:5;s:10:\"list_order\";s:12:\"priority-asc\";s:13:\"disable_prism\";b:0;s:17:\"hide_upgrade_menu\";b:0;s:18:\"complete_uninstall\";b:0;}s:6:\"editor\";a:11:{s:5:\"theme\";s:7:\"default\";s:16:\"indent_with_tabs\";b:1;s:8:\"tab_size\";i:4;s:11:\"indent_unit\";i:4;s:10:\"wrap_lines\";b:1;s:12:\"code_folding\";b:1;s:12:\"line_numbers\";b:1;s:19:\"auto_close_brackets\";b:1;s:27:\"highlight_selection_matches\";b:1;s:21:\"highlight_active_line\";b:1;s:6:\"keymap\";s:7:\"default\";}}", "yes");
INSERT INTO `wp_options` VALUES("192", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("198", "automatic_css_settings", "a:2126:{s:13:\"accent-comp-h\";i:79;s:17:\"accent-comp-h-alt\";i:79;s:13:\"accent-comp-l\";i:71;s:17:\"accent-comp-l-alt\";i:71;s:13:\"accent-comp-s\";i:26;s:17:\"accent-comp-s-alt\";i:26;s:13:\"accent-dark-h\";s:3:\"179\";s:17:\"accent-dark-h-alt\";d:79;s:13:\"accent-dark-l\";s:2:\"25\";s:17:\"accent-dark-l-alt\";d:25;s:13:\"accent-dark-s\";s:3:\"100\";s:17:\"accent-dark-s-alt\";d:26;s:14:\"accent-hover-h\";s:3:\"179\";s:18:\"accent-hover-h-alt\";d:79;s:14:\"accent-hover-l\";s:2:\"57\";s:18:\"accent-hover-l-alt\";d:81.6499999999999914734871708787977695465087890625;s:14:\"accent-hover-s\";s:3:\"100\";s:18:\"accent-hover-s-alt\";d:26;s:14:\"accent-light-h\";s:3:\"179\";s:18:\"accent-light-h-alt\";d:79;s:14:\"accent-light-l\";s:2:\"85\";s:18:\"accent-light-l-alt\";d:85;s:14:\"accent-light-s\";s:3:\"100\";s:18:\"accent-light-s-alt\";d:26;s:15:\"accent-medium-h\";s:3:\"179\";s:19:\"accent-medium-h-alt\";d:79;s:15:\"accent-medium-l\";s:2:\"50\";s:19:\"accent-medium-l-alt\";d:50;s:15:\"accent-medium-s\";s:3:\"100\";s:19:\"accent-medium-s-alt\";d:26;s:23:\"accent-outline-btn-text\";s:13:\"var(--accent)\";s:28:\"accent-outline-dark-btn-text\";s:18:\"var(--accent-dark)\";s:30:\"accent-outline-dark-hover-text\";s:25:\"var(--accent-ultra-light)\";s:25:\"accent-outline-hover-text\";s:25:\"var(--accent-ultra-light)\";s:29:\"accent-outline-light-btn-text\";s:19:\"var(--accent-light)\";s:31:\"accent-outline-light-hover-text\";s:18:\"var(--accent-dark)\";s:18:\"accent-semi-dark-h\";s:3:\"179\";s:22:\"accent-semi-dark-h-alt\";d:79;s:18:\"accent-semi-dark-l\";s:2:\"35\";s:22:\"accent-semi-dark-l-alt\";i:35;s:18:\"accent-semi-dark-s\";s:3:\"100\";s:22:\"accent-semi-dark-s-alt\";d:26;s:19:\"accent-semi-light-h\";s:3:\"179\";s:23:\"accent-semi-light-h-alt\";d:79;s:19:\"accent-semi-light-l\";s:2:\"65\";s:23:\"accent-semi-light-l-alt\";i:65;s:19:\"accent-semi-light-s\";s:3:\"100\";s:23:\"accent-semi-light-s-alt\";d:26;s:19:\"accent-ultra-dark-h\";s:3:\"179\";s:23:\"accent-ultra-dark-h-alt\";d:79;s:19:\"accent-ultra-dark-l\";s:2:\"10\";s:23:\"accent-ultra-dark-l-alt\";d:10;s:19:\"accent-ultra-dark-s\";s:3:\"100\";s:23:\"accent-ultra-dark-s-alt\";d:26;s:20:\"accent-ultra-light-h\";s:3:\"179\";s:24:\"accent-ultra-light-h-alt\";d:79;s:20:\"accent-ultra-light-l\";s:2:\"95\";s:24:\"accent-ultra-light-l-alt\";d:95;s:20:\"accent-ultra-light-s\";s:3:\"100\";s:24:\"accent-ultra-light-s-alt\";d:26;s:13:\"action-comp-h\";i:190;s:17:\"action-comp-h-alt\";i:190;s:13:\"action-comp-l\";i:50;s:17:\"action-comp-l-alt\";i:50;s:13:\"action-comp-s\";i:30;s:17:\"action-comp-s-alt\";i:30;s:13:\"action-dark-h\";i:42;s:17:\"action-dark-h-alt\";d:193;s:13:\"action-dark-l\";s:2:\"25\";s:17:\"action-dark-l-alt\";d:25;s:13:\"action-dark-s\";i:62;s:17:\"action-dark-s-alt\";d:59;s:14:\"action-hover-h\";i:42;s:18:\"action-hover-h-alt\";d:193;s:14:\"action-hover-l\";i:61;s:18:\"action-hover-l-alt\";d:55.19999999999999573674358543939888477325439453125;s:14:\"action-hover-s\";i:62;s:18:\"action-hover-s-alt\";d:59;s:14:\"action-light-h\";i:42;s:18:\"action-light-h-alt\";d:193;s:14:\"action-light-l\";s:2:\"85\";s:18:\"action-light-l-alt\";d:85;s:14:\"action-light-s\";i:62;s:18:\"action-light-s-alt\";d:59;s:15:\"action-medium-h\";i:42;s:19:\"action-medium-h-alt\";d:193;s:15:\"action-medium-l\";s:2:\"50\";s:19:\"action-medium-l-alt\";d:50;s:15:\"action-medium-s\";i:62;s:19:\"action-medium-s-alt\";d:59;s:23:\"action-outline-btn-text\";s:13:\"var(--action)\";s:25:\"action-outline-hover-text\";s:25:\"var(--action-ultra-light)\";s:18:\"action-semi-dark-h\";i:42;s:22:\"action-semi-dark-h-alt\";d:193;s:18:\"action-semi-dark-l\";s:2:\"35\";s:22:\"action-semi-dark-l-alt\";i:35;s:18:\"action-semi-dark-s\";i:62;s:22:\"action-semi-dark-s-alt\";d:59;s:19:\"action-semi-light-h\";i:42;s:23:\"action-semi-light-h-alt\";d:193;s:19:\"action-semi-light-l\";s:2:\"65\";s:23:\"action-semi-light-l-alt\";i:65;s:19:\"action-semi-light-s\";i:62;s:23:\"action-semi-light-s-alt\";d:59;s:19:\"action-ultra-dark-h\";i:42;s:23:\"action-ultra-dark-h-alt\";d:193;s:19:\"action-ultra-dark-l\";s:2:\"10\";s:23:\"action-ultra-dark-l-alt\";d:10;s:19:\"action-ultra-dark-s\";i:62;s:23:\"action-ultra-dark-s-alt\";d:59;s:20:\"action-ultra-light-h\";i:42;s:24:\"action-ultra-light-h-alt\";d:193;s:20:\"action-ultra-light-l\";s:2:\"95\";s:24:\"action-ultra-light-l-alt\";d:95;s:20:\"action-ultra-light-s\";i:62;s:24:\"action-ultra-light-s-alt\";d:59;s:17:\"admin-bar-enabled\";s:2:\"on\";s:19:\"admin-link-position\";i:90;s:24:\"auto-grid-aggressiveness\";s:2:\".7\";s:21:\"auto-grid-flow-option\";s:8:\"auto-fit\";s:33:\"auto-grid-force-even-column-count\";s:3:\"off\";s:44:\"auto-grid-force-even-column-count-breakpoint\";s:1:\"s\";s:21:\"auto-radius-selectors\";s:52:\"\":where(img)\", \":where(figure:not(figure:has(img)))\"\";s:30:\"auto-staggered-grid-breakpoint\";s:1:\"l\";s:11:\"base-comp-h\";i:203;s:15:\"base-comp-h-alt\";i:203;s:11:\"base-comp-l\";i:12;s:15:\"base-comp-l-alt\";i:12;s:11:\"base-comp-s\";i:68;s:15:\"base-comp-s-alt\";i:68;s:11:\"base-dark-h\";d:203;s:15:\"base-dark-h-alt\";d:203;s:11:\"base-dark-l\";d:25;s:15:\"base-dark-l-alt\";d:25;s:11:\"base-dark-s\";d:68;s:15:\"base-dark-s-alt\";d:68;s:17:\"base-heading-desk\";s:2:\"20\";s:15:\"base-heading-lh\";s:15:\"calc(4px + 2ex)\";s:16:\"base-heading-mob\";s:2:\"16\";s:12:\"base-hover-h\";d:203;s:16:\"base-hover-h-alt\";d:203;s:12:\"base-hover-l\";d:13.7999999999999989341858963598497211933135986328125;s:16:\"base-hover-l-alt\";d:13.7999999999999989341858963598497211933135986328125;s:12:\"base-hover-s\";d:68;s:16:\"base-hover-s-alt\";d:68;s:12:\"base-light-h\";d:203;s:16:\"base-light-h-alt\";d:203;s:12:\"base-light-l\";d:85;s:16:\"base-light-l-alt\";d:85;s:12:\"base-light-s\";d:68;s:16:\"base-light-s-alt\";d:68;s:13:\"base-medium-h\";d:203;s:17:\"base-medium-h-alt\";d:203;s:13:\"base-medium-l\";d:50;s:17:\"base-medium-l-alt\";d:50;s:13:\"base-medium-s\";d:68;s:17:\"base-medium-s-alt\";d:68;s:21:\"base-outline-btn-text\";s:11:\"var(--base)\";s:26:\"base-outline-dark-btn-text\";s:16:\"var(--base-dark)\";s:28:\"base-outline-dark-hover-text\";s:23:\"var(--base-ultra-light)\";s:23:\"base-outline-hover-text\";s:23:\"var(--base-ultra-light)\";s:27:\"base-outline-light-btn-text\";s:17:\"var(--base-light)\";s:29:\"base-outline-light-hover-text\";s:16:\"var(--base-dark)\";s:11:\"base-radius\";s:4:\"1rem\";s:16:\"base-semi-dark-h\";d:203;s:20:\"base-semi-dark-h-alt\";d:203;s:16:\"base-semi-dark-l\";i:35;s:20:\"base-semi-dark-l-alt\";i:35;s:16:\"base-semi-dark-s\";d:68;s:20:\"base-semi-dark-s-alt\";d:68;s:17:\"base-semi-light-h\";d:203;s:21:\"base-semi-light-h-alt\";d:203;s:17:\"base-semi-light-l\";i:65;s:21:\"base-semi-light-l-alt\";i:65;s:17:\"base-semi-light-s\";d:68;s:21:\"base-semi-light-s-alt\";d:68;s:10:\"base-space\";i:30;s:14:\"base-space-min\";i:24;s:14:\"base-text-desk\";s:2:\"20\";s:12:\"base-text-lh\";s:15:\"calc(6px + 2ex)\";s:13:\"base-text-mob\";s:2:\"16\";s:17:\"base-ultra-dark-h\";d:203;s:21:\"base-ultra-dark-h-alt\";d:203;s:17:\"base-ultra-dark-l\";d:10;s:21:\"base-ultra-dark-l-alt\";d:10;s:17:\"base-ultra-dark-s\";d:68;s:21:\"base-ultra-dark-s-alt\";d:68;s:18:\"base-ultra-light-h\";d:203;s:22:\"base-ultra-light-h-alt\";d:203;s:18:\"base-ultra-light-l\";d:95;s:22:\"base-ultra-light-l-alt\";d:95;s:18:\"base-ultra-light-s\";d:68;s:22:\"base-ultra-light-s-alt\";d:68;s:7:\"bg-dark\";s:25:\"var(--neutral-ultra-dark)\";s:14:\"bg-dark-button\";s:7:\"primary\";s:19:\"bg-dark-focus-color\";s:0:\"\";s:15:\"bg-dark-heading\";s:17:\"var(--text-light)\";s:12:\"bg-dark-link\";s:14:\"var(--primary)\";s:18:\"bg-dark-link-hover\";s:20:\"var(--primary-hover)\";s:12:\"bg-dark-text\";s:17:\"var(--text-light)\";s:8:\"bg-light\";s:26:\"var(--neutral-ultra-light)\";s:15:\"bg-light-button\";s:10:\"\"--action\"\";s:20:\"bg-light-focus-color\";s:0:\"\";s:16:\"bg-light-heading\";s:16:\"var(--text-dark)\";s:13:\"bg-light-link\";s:13:\"var(--action)\";s:19:\"bg-light-link-hover\";s:20:\"var(--primary-hover)\";s:13:\"bg-light-text\";s:16:\"var(--text-dark)\";s:13:\"bg-ultra-dark\";s:12:\"var(--black)\";s:20:\"bg-ultra-dark-button\";s:7:\"primary\";s:25:\"bg-ultra-dark-focus-color\";s:0:\"\";s:21:\"bg-ultra-dark-heading\";s:17:\"var(--text-light)\";s:18:\"bg-ultra-dark-link\";s:14:\"var(--primary)\";s:24:\"bg-ultra-dark-link-hover\";s:20:\"var(--primary-hover)\";s:18:\"bg-ultra-dark-text\";s:17:\"var(--text-light)\";s:14:\"bg-ultra-light\";s:12:\"var(--white)\";s:21:\"bg-ultra-light-button\";s:10:\"\"--action\"\";s:26:\"bg-ultra-light-focus-color\";s:0:\"\";s:22:\"bg-ultra-light-heading\";s:16:\"var(--text-dark)\";s:19:\"bg-ultra-light-link\";s:13:\"var(--action)\";s:25:\"bg-ultra-light-link-hover\";s:20:\"var(--primary-hover)\";s:19:\"bg-ultra-light-text\";s:16:\"var(--text-dark)\";s:22:\"black-outline-btn-text\";s:12:\"var(--black)\";s:24:\"black-outline-hover-text\";s:12:\"var(--black)\";s:18:\"blockquote-spacing\";s:24:\"var(--paragraph-spacing)\";s:13:\"body-bg-color\";s:12:\"var(--white)\";s:17:\"body-border-color\";s:11:\"transparent\";s:18:\"body-border-radius\";s:1:\"0\";s:17:\"body-border-style\";s:4:\"none\";s:17:\"body-border-width\";s:1:\"0\";s:15:\"body-box-shadow\";s:45:\"0 0 80px 0 var(--neutral-ultra-dark-trans-20)\";s:10:\"body-color\";s:12:\"var(--black)\";s:15:\"body-margin-top\";s:1:\"0\";s:14:\"body-max-width\";s:6:\"1920px\";s:17:\"border-color-dark\";s:21:\"var(--black-trans-20)\";s:18:\"border-color-light\";s:21:\"var(--white-trans-20)\";s:11:\"border-main\";s:63:\"var(--border-size) var(--border-style) var(--border-color-dark)\";s:11:\"border-size\";s:3:\"1px\";s:12:\"border-style\";s:5:\"solid\";s:17:\"box-shadow-1-name\";s:1:\"m\";s:18:\"box-shadow-1-value\";s:0:\"\";s:17:\"box-shadow-2-name\";s:1:\"l\";s:18:\"box-shadow-2-value\";s:0:\"\";s:17:\"box-shadow-3-name\";s:2:\"xl\";s:18:\"box-shadow-3-value\";s:0:\"\";s:12:\"breakpoint-l\";d:992;s:12:\"breakpoint-m\";d:768;s:12:\"breakpoint-s\";d:480;s:13:\"breakpoint-xl\";d:1280;s:13:\"breakpoint-xs\";d:360;s:14:\"breakpoint-xxl\";d:1440;s:13:\"btn-accent-bg\";s:13:\"var(--accent)\";s:23:\"btn-accent-border-color\";s:13:\"var(--accent)\";s:18:\"btn-accent-dark-bg\";s:18:\"var(--accent-dark)\";s:28:\"btn-accent-dark-border-color\";s:18:\"var(--accent-dark)\";s:27:\"btn-accent-dark-focus-color\";s:23:\"var(--accent-semi-dark)\";s:21:\"btn-accent-dark-hover\";s:24:\"var(--accent-ultra-dark)\";s:34:\"btn-accent-dark-hover-border-color\";s:24:\"var(--accent-ultra-dark)\";s:26:\"btn-accent-dark-hover-text\";s:25:\"var(--accent-ultra-light)\";s:20:\"btn-accent-dark-text\";s:25:\"var(--accent-ultra-light)\";s:22:\"btn-accent-focus-color\";s:18:\"var(--accent-dark)\";s:16:\"btn-accent-hover\";s:19:\"var(--accent-hover)\";s:29:\"btn-accent-hover-border-color\";s:19:\"var(--accent-hover)\";s:21:\"btn-accent-hover-text\";s:25:\"var(--accent-ultra-light)\";s:19:\"btn-accent-light-bg\";s:25:\"var(--accent-ultra-light)\";s:29:\"btn-accent-light-border-color\";s:25:\"var(--accent-ultra-light)\";s:28:\"btn-accent-light-focus-color\";s:19:\"var(--accent-light)\";s:22:\"btn-accent-light-hover\";s:19:\"var(--accent-light)\";s:35:\"btn-accent-light-hover-border-color\";s:19:\"var(--accent-light)\";s:27:\"btn-accent-light-hover-text\";s:24:\"var(--accent-ultra-dark)\";s:21:\"btn-accent-light-text\";s:13:\"var(--accent)\";s:29:\"btn-accent-outline-background\";s:11:\"transparent\";s:35:\"btn-accent-outline-background-hover\";s:19:\"var(--accent-hover)\";s:31:\"btn-accent-outline-border-color\";s:13:\"var(--accent)\";s:31:\"btn-accent-outline-border-hover\";s:19:\"var(--accent-hover)\";s:34:\"btn-accent-outline-dark-background\";s:11:\"transparent\";s:40:\"btn-accent-outline-dark-background-hover\";s:18:\"var(--accent-dark)\";s:36:\"btn-accent-outline-dark-border-color\";s:18:\"var(--accent-dark)\";s:36:\"btn-accent-outline-dark-border-hover\";s:18:\"var(--accent-dark)\";s:35:\"btn-accent-outline-dark-focus-color\";s:23:\"var(--accent-semi-dark)\";s:30:\"btn-accent-outline-focus-color\";s:24:\"var(--accent-semi-light)\";s:35:\"btn-accent-outline-light-background\";s:11:\"transparent\";s:41:\"btn-accent-outline-light-background-hover\";s:19:\"var(--accent-light)\";s:37:\"btn-accent-outline-light-border-color\";s:19:\"var(--accent-light)\";s:37:\"btn-accent-outline-light-border-hover\";s:19:\"var(--accent-light)\";s:36:\"btn-accent-outline-light-focus-color\";s:19:\"var(--accent-light)\";s:15:\"btn-accent-text\";s:25:\"var(--accent-ultra-light)\";s:13:\"btn-action-bg\";s:13:\"var(--action)\";s:23:\"btn-action-border-color\";s:13:\"var(--action)\";s:22:\"btn-action-focus-color\";s:18:\"var(--action-dark)\";s:16:\"btn-action-hover\";s:19:\"var(--action-hover)\";s:29:\"btn-action-hover-border-color\";s:19:\"var(--action-hover)\";s:21:\"btn-action-hover-text\";s:25:\"var(--action-ultra-light)\";s:29:\"btn-action-outline-background\";s:12:\"var(--white)\";s:35:\"btn-action-outline-background-hover\";s:19:\"var(--action-hover)\";s:31:\"btn-action-outline-border-color\";s:16:\"var(--text-dark)\";s:31:\"btn-action-outline-border-hover\";s:16:\"var(--text-dark)\";s:30:\"btn-action-outline-focus-color\";s:24:\"var(--action-semi-light)\";s:15:\"btn-action-text\";s:17:\"var(--text-light)\";s:11:\"btn-base-bg\";s:11:\"var(--base)\";s:21:\"btn-base-border-color\";s:11:\"var(--base)\";s:16:\"btn-base-dark-bg\";s:16:\"var(--base-dark)\";s:26:\"btn-base-dark-border-color\";s:16:\"var(--base-dark)\";s:25:\"btn-base-dark-focus-color\";s:21:\"var(--base-semi-dark)\";s:19:\"btn-base-dark-hover\";s:22:\"var(--base-ultra-dark)\";s:32:\"btn-base-dark-hover-border-color\";s:22:\"var(--base-ultra-dark)\";s:24:\"btn-base-dark-hover-text\";s:23:\"var(--base-ultra-light)\";s:18:\"btn-base-dark-text\";s:23:\"var(--base-ultra-light)\";s:20:\"btn-base-focus-color\";s:16:\"var(--base-dark)\";s:14:\"btn-base-hover\";s:17:\"var(--base-hover)\";s:27:\"btn-base-hover-border-color\";s:17:\"var(--base-hover)\";s:19:\"btn-base-hover-text\";s:23:\"var(--base-ultra-light)\";s:17:\"btn-base-light-bg\";s:23:\"var(--base-ultra-light)\";s:27:\"btn-base-light-border-color\";s:23:\"var(--base-ultra-light)\";s:26:\"btn-base-light-focus-color\";s:17:\"var(--base-light)\";s:20:\"btn-base-light-hover\";s:17:\"var(--base-light)\";s:33:\"btn-base-light-hover-border-color\";s:17:\"var(--base-light)\";s:25:\"btn-base-light-hover-text\";s:22:\"var(--base-ultra-dark)\";s:19:\"btn-base-light-text\";s:11:\"var(--base)\";s:27:\"btn-base-outline-background\";s:11:\"transparent\";s:33:\"btn-base-outline-background-hover\";s:17:\"var(--base-hover)\";s:29:\"btn-base-outline-border-color\";s:11:\"var(--base)\";s:29:\"btn-base-outline-border-hover\";s:17:\"var(--base-hover)\";s:32:\"btn-base-outline-dark-background\";s:11:\"transparent\";s:38:\"btn-base-outline-dark-background-hover\";s:16:\"var(--base-dark)\";s:34:\"btn-base-outline-dark-border-color\";s:16:\"var(--base-dark)\";s:34:\"btn-base-outline-dark-border-hover\";s:16:\"var(--base-dark)\";s:33:\"btn-base-outline-dark-focus-color\";s:21:\"var(--base-semi-dark)\";s:28:\"btn-base-outline-focus-color\";s:22:\"var(--base-semi-light)\";s:33:\"btn-base-outline-light-background\";s:11:\"transparent\";s:39:\"btn-base-outline-light-background-hover\";s:17:\"var(--base-light)\";s:35:\"btn-base-outline-light-border-color\";s:17:\"var(--base-light)\";s:35:\"btn-base-outline-light-border-hover\";s:17:\"var(--base-light)\";s:34:\"btn-base-outline-light-focus-color\";s:17:\"var(--base-light)\";s:13:\"btn-base-text\";s:23:\"var(--base-ultra-light)\";s:12:\"btn-black-bg\";s:12:\"var(--black)\";s:22:\"btn-black-border-color\";s:12:\"var(--black)\";s:21:\"btn-black-focus-color\";s:13:\"var(--action)\";s:15:\"btn-black-hover\";s:12:\"var(--white)\";s:28:\"btn-black-hover-border-color\";s:12:\"var(--white)\";s:20:\"btn-black-hover-text\";s:12:\"var(--black)\";s:28:\"btn-black-outline-background\";s:18:\"var(--transparent)\";s:34:\"btn-black-outline-background-hover\";s:19:\"var(--action-hover)\";s:30:\"btn-black-outline-border-color\";s:12:\"var(--black)\";s:30:\"btn-black-outline-border-hover\";s:19:\"var(--action-hover)\";s:29:\"btn-black-outline-focus-color\";s:13:\"var(--action)\";s:14:\"btn-black-text\";s:12:\"var(--white)\";s:17:\"btn-border-radius\";s:1:\"0\";s:16:\"btn-border-style\";s:5:\"solid\";s:16:\"btn-border-width\";s:7:\"0.25rem\";s:13:\"btn-danger-bg\";s:13:\"var(--danger)\";s:23:\"btn-danger-border-color\";s:13:\"var(--danger)\";s:18:\"btn-danger-dark-bg\";s:18:\"var(--danger-dark)\";s:28:\"btn-danger-dark-border-color\";s:18:\"var(--danger-dark)\";s:27:\"btn-danger-dark-focus-color\";s:23:\"var(--danger-semi-dark)\";s:21:\"btn-danger-dark-hover\";s:24:\"var(--danger-ultra-dark)\";s:34:\"btn-danger-dark-hover-border-color\";s:24:\"var(--danger-ultra-dark)\";s:26:\"btn-danger-dark-hover-text\";s:25:\"var(--danger-ultra-light)\";s:20:\"btn-danger-dark-text\";s:25:\"var(--danger-ultra-light)\";s:22:\"btn-danger-focus-color\";s:19:\"var(--danger-light)\";s:16:\"btn-danger-hover\";s:19:\"var(--danger-hover)\";s:29:\"btn-danger-hover-border-color\";s:19:\"var(--danger-hover)\";s:21:\"btn-danger-hover-text\";s:25:\"var(--danger-ultra-light)\";s:19:\"btn-danger-light-bg\";s:25:\"var(--danger-ultra-light)\";s:29:\"btn-danger-light-border-color\";s:25:\"var(--danger-ultra-light)\";s:28:\"btn-danger-light-focus-color\";s:19:\"var(--danger-light)\";s:22:\"btn-danger-light-hover\";s:19:\"var(--danger-light)\";s:35:\"btn-danger-light-hover-border-color\";s:19:\"var(--danger-light)\";s:27:\"btn-danger-light-hover-text\";s:24:\"var(--danger-ultra-dark)\";s:21:\"btn-danger-light-text\";s:13:\"var(--danger)\";s:29:\"btn-danger-outline-background\";s:11:\"transparent\";s:35:\"btn-danger-outline-background-hover\";s:19:\"var(--danger-hover)\";s:31:\"btn-danger-outline-border-color\";s:13:\"var(--danger)\";s:31:\"btn-danger-outline-border-hover\";s:19:\"var(--danger-hover)\";s:34:\"btn-danger-outline-dark-background\";s:11:\"transparent\";s:40:\"btn-danger-outline-dark-background-hover\";s:18:\"var(--danger-dark)\";s:36:\"btn-danger-outline-dark-border-color\";s:18:\"var(--danger-dark)\";s:36:\"btn-danger-outline-dark-border-hover\";s:18:\"var(--danger-dark)\";s:35:\"btn-danger-outline-dark-focus-color\";s:23:\"var(--danger-semi-dark)\";s:30:\"btn-danger-outline-focus-color\";s:24:\"var(--danger-semi-light)\";s:35:\"btn-danger-outline-light-background\";s:11:\"transparent\";s:41:\"btn-danger-outline-light-background-hover\";s:19:\"var(--danger-light)\";s:37:\"btn-danger-outline-light-border-color\";s:19:\"var(--danger-light)\";s:37:\"btn-danger-outline-light-border-hover\";s:19:\"var(--danger-light)\";s:36:\"btn-danger-outline-light-focus-color\";s:19:\"var(--danger-light)\";s:15:\"btn-danger-text\";s:25:\"var(--danger-ultra-light)\";s:28:\"btn-exclusion-selectors-user\";s:0:\"\";s:14:\"btn-font-style\";s:6:\"normal\";s:15:\"btn-font-weight\";i:600;s:11:\"btn-info-bg\";s:11:\"var(--info)\";s:21:\"btn-info-border-color\";s:11:\"var(--info)\";s:16:\"btn-info-dark-bg\";s:16:\"var(--info-dark)\";s:26:\"btn-info-dark-border-color\";s:16:\"var(--info-dark)\";s:25:\"btn-info-dark-focus-color\";s:21:\"var(--info-semi-dark)\";s:19:\"btn-info-dark-hover\";s:22:\"var(--info-ultra-dark)\";s:32:\"btn-info-dark-hover-border-color\";s:22:\"var(--info-ultra-dark)\";s:24:\"btn-info-dark-hover-text\";s:23:\"var(--info-ultra-light)\";s:18:\"btn-info-dark-text\";s:23:\"var(--info-ultra-light)\";s:20:\"btn-info-focus-color\";s:17:\"var(--info-light)\";s:14:\"btn-info-hover\";s:17:\"var(--info-hover)\";s:27:\"btn-info-hover-border-color\";s:17:\"var(--info-hover)\";s:19:\"btn-info-hover-text\";s:23:\"var(--info-ultra-light)\";s:17:\"btn-info-light-bg\";s:23:\"var(--info-ultra-light)\";s:27:\"btn-info-light-border-color\";s:23:\"var(--info-ultra-light)\";s:26:\"btn-info-light-focus-color\";s:17:\"var(--info-light)\";s:20:\"btn-info-light-hover\";s:17:\"var(--info-light)\";s:33:\"btn-info-light-hover-border-color\";s:17:\"var(--info-light)\";s:25:\"btn-info-light-hover-text\";s:22:\"var(--info-ultra-dark)\";s:19:\"btn-info-light-text\";s:11:\"var(--info)\";s:27:\"btn-info-outline-background\";s:11:\"transparent\";s:33:\"btn-info-outline-background-hover\";s:17:\"var(--info-hover)\";s:29:\"btn-info-outline-border-color\";s:11:\"var(--info)\";s:29:\"btn-info-outline-border-hover\";s:17:\"var(--info-hover)\";s:32:\"btn-info-outline-dark-background\";s:11:\"transparent\";s:38:\"btn-info-outline-dark-background-hover\";s:16:\"var(--info-dark)\";s:34:\"btn-info-outline-dark-border-color\";s:16:\"var(--info-dark)\";s:34:\"btn-info-outline-dark-border-hover\";s:16:\"var(--info-dark)\";s:33:\"btn-info-outline-dark-focus-color\";s:21:\"var(--info-semi-dark)\";s:28:\"btn-info-outline-focus-color\";s:22:\"var(--info-semi-light)\";s:33:\"btn-info-outline-light-background\";s:11:\"transparent\";s:39:\"btn-info-outline-light-background-hover\";s:17:\"var(--info-light)\";s:35:\"btn-info-outline-light-border-color\";s:17:\"var(--info-light)\";s:35:\"btn-info-outline-light-border-hover\";s:17:\"var(--info-light)\";s:34:\"btn-info-outline-light-focus-color\";s:17:\"var(--info-light)\";s:13:\"btn-info-text\";s:23:\"var(--info-ultra-light)\";s:19:\"btn-justify-content\";s:6:\"center\";s:18:\"btn-letter-spacing\";s:6:\"1.15px\";s:15:\"btn-line-height\";d:1;s:13:\"btn-min-width\";s:3:\"140\";s:14:\"btn-neutral-bg\";s:14:\"var(--neutral)\";s:24:\"btn-neutral-border-color\";s:14:\"var(--neutral)\";s:19:\"btn-neutral-dark-bg\";s:19:\"var(--neutral-dark)\";s:29:\"btn-neutral-dark-border-color\";s:19:\"var(--neutral-dark)\";s:28:\"btn-neutral-dark-focus-color\";s:24:\"var(--neutral-semi-dark)\";s:22:\"btn-neutral-dark-hover\";s:25:\"var(--neutral-ultra-dark)\";s:35:\"btn-neutral-dark-hover-border-color\";s:25:\"var(--neutral-ultra-dark)\";s:27:\"btn-neutral-dark-hover-text\";s:26:\"var(--neutral-ultra-light)\";s:21:\"btn-neutral-dark-text\";s:26:\"var(--neutral-ultra-light)\";s:23:\"btn-neutral-focus-color\";s:14:\"var(--primary)\";s:17:\"btn-neutral-hover\";s:19:\"var(--neutral-dark)\";s:30:\"btn-neutral-hover-border-color\";s:19:\"var(--neutral-dark)\";s:22:\"btn-neutral-hover-text\";s:26:\"var(--neutral-ultra-light)\";s:20:\"btn-neutral-light-bg\";s:26:\"var(--neutral-ultra-light)\";s:30:\"btn-neutral-light-border-color\";s:26:\"var(--neutral-ultra-light)\";s:29:\"btn-neutral-light-focus-color\";s:20:\"var(--neutral-light)\";s:23:\"btn-neutral-light-hover\";s:20:\"var(--neutral-light)\";s:36:\"btn-neutral-light-hover-border-color\";s:20:\"var(--neutral-light)\";s:28:\"btn-neutral-light-hover-text\";s:25:\"var(--neutral-ultra-dark)\";s:22:\"btn-neutral-light-text\";s:14:\"var(--neutral)\";s:30:\"btn-neutral-outline-background\";s:11:\"transparent\";s:36:\"btn-neutral-outline-background-hover\";s:20:\"var(--neutral-hover)\";s:32:\"btn-neutral-outline-border-color\";s:14:\"var(--neutral)\";s:32:\"btn-neutral-outline-border-hover\";s:20:\"var(--neutral-hover)\";s:35:\"btn-neutral-outline-dark-background\";s:11:\"transparent\";s:41:\"btn-neutral-outline-dark-background-hover\";s:19:\"var(--neutral-dark)\";s:37:\"btn-neutral-outline-dark-border-color\";s:19:\"var(--neutral-dark)\";s:37:\"btn-neutral-outline-dark-border-hover\";s:19:\"var(--neutral-dark)\";s:36:\"btn-neutral-outline-dark-focus-color\";s:24:\"var(--neutral-semi-dark)\";s:31:\"btn-neutral-outline-focus-color\";s:25:\"var(--neutral-semi-light)\";s:36:\"btn-neutral-outline-light-background\";s:11:\"transparent\";s:42:\"btn-neutral-outline-light-background-hover\";s:20:\"var(--neutral-light)\";s:38:\"btn-neutral-outline-light-border-color\";s:20:\"var(--neutral-light)\";s:38:\"btn-neutral-outline-light-border-hover\";s:20:\"var(--neutral-light)\";s:37:\"btn-neutral-outline-light-focus-color\";s:20:\"var(--neutral-light)\";s:16:\"btn-neutral-text\";s:26:\"var(--neutral-ultra-light)\";s:24:\"btn-outline-border-width\";s:7:\"0.25rem\";s:17:\"btn-padding-block\";s:6:\"0.75em\";s:18:\"btn-padding-inline\";s:5:\"1.5em\";s:14:\"btn-primary-bg\";s:14:\"var(--primary)\";s:24:\"btn-primary-border-color\";s:14:\"var(--primary)\";s:19:\"btn-primary-dark-bg\";s:19:\"var(--primary-dark)\";s:29:\"btn-primary-dark-border-color\";s:19:\"var(--primary-dark)\";s:28:\"btn-primary-dark-focus-color\";s:24:\"var(--primary-semi-dark)\";s:22:\"btn-primary-dark-hover\";s:25:\"var(--primary-ultra-dark)\";s:35:\"btn-primary-dark-hover-border-color\";s:25:\"var(--primary-ultra-dark)\";s:27:\"btn-primary-dark-hover-text\";s:26:\"var(--primary-ultra-light)\";s:21:\"btn-primary-dark-text\";s:26:\"var(--primary-ultra-light)\";s:23:\"btn-primary-focus-color\";s:19:\"var(--primary-dark)\";s:17:\"btn-primary-hover\";s:19:\"var(--action-hover)\";s:30:\"btn-primary-hover-border-color\";s:19:\"var(--action-hover)\";s:22:\"btn-primary-hover-text\";s:17:\"var(--text-light)\";s:20:\"btn-primary-light-bg\";s:14:\"var(--primary)\";s:30:\"btn-primary-light-border-color\";s:14:\"var(--primary)\";s:29:\"btn-primary-light-focus-color\";s:20:\"var(--primary-light)\";s:23:\"btn-primary-light-hover\";s:12:\"var(--white)\";s:36:\"btn-primary-light-hover-border-color\";s:12:\"var(--white)\";s:28:\"btn-primary-light-hover-text\";s:25:\"var(--primary-ultra-dark)\";s:22:\"btn-primary-light-text\";s:16:\"var(--text-dark)\";s:30:\"btn-primary-outline-background\";s:11:\"transparent\";s:36:\"btn-primary-outline-background-hover\";s:19:\"var(--action-hover)\";s:32:\"btn-primary-outline-border-color\";s:24:\"var(--primary-semi-dark)\";s:32:\"btn-primary-outline-border-hover\";s:20:\"var(--primary-hover)\";s:35:\"btn-primary-outline-dark-background\";s:11:\"transparent\";s:41:\"btn-primary-outline-dark-background-hover\";s:19:\"var(--primary-dark)\";s:37:\"btn-primary-outline-dark-border-color\";s:19:\"var(--primary-dark)\";s:37:\"btn-primary-outline-dark-border-hover\";s:19:\"var(--primary-dark)\";s:36:\"btn-primary-outline-dark-focus-color\";s:24:\"var(--primary-semi-dark)\";s:31:\"btn-primary-outline-focus-color\";s:25:\"var(--primary-semi-light)\";s:36:\"btn-primary-outline-light-background\";s:11:\"transparent\";s:42:\"btn-primary-outline-light-background-hover\";s:20:\"var(--primary-light)\";s:38:\"btn-primary-outline-light-border-color\";s:20:\"var(--primary-light)\";s:38:\"btn-primary-outline-light-border-hover\";s:20:\"var(--primary-light)\";s:37:\"btn-primary-outline-light-focus-color\";s:20:\"var(--primary-light)\";s:16:\"btn-primary-text\";s:19:\"var(--primary-dark)\";s:16:\"btn-secondary-bg\";s:16:\"var(--secondary)\";s:26:\"btn-secondary-border-color\";s:16:\"var(--secondary)\";s:21:\"btn-secondary-dark-bg\";s:21:\"var(--secondary-dark)\";s:31:\"btn-secondary-dark-border-color\";s:21:\"var(--secondary-dark)\";s:30:\"btn-secondary-dark-focus-color\";s:26:\"var(--secondary-semi-dark)\";s:24:\"btn-secondary-dark-hover\";s:27:\"var(--secondary-ultra-dark)\";s:37:\"btn-secondary-dark-hover-border-color\";s:27:\"var(--secondary-ultra-dark)\";s:29:\"btn-secondary-dark-hover-text\";s:28:\"var(--secondary-ultra-light)\";s:23:\"btn-secondary-dark-text\";s:28:\"var(--secondary-ultra-light)\";s:25:\"btn-secondary-focus-color\";s:21:\"var(--secondary-dark)\";s:19:\"btn-secondary-hover\";s:22:\"var(--secondary-hover)\";s:32:\"btn-secondary-hover-border-color\";s:22:\"var(--secondary-hover)\";s:24:\"btn-secondary-hover-text\";s:28:\"var(--secondary-ultra-light)\";s:22:\"btn-secondary-light-bg\";s:28:\"var(--secondary-ultra-light)\";s:32:\"btn-secondary-light-border-color\";s:28:\"var(--secondary-ultra-light)\";s:31:\"btn-secondary-light-focus-color\";s:22:\"var(--secondary-light)\";s:25:\"btn-secondary-light-hover\";s:22:\"var(--secondary-light)\";s:38:\"btn-secondary-light-hover-border-color\";s:22:\"var(--secondary-light)\";s:30:\"btn-secondary-light-hover-text\";s:27:\"var(--secondary-ultra-dark)\";s:24:\"btn-secondary-light-text\";s:16:\"var(--secondary)\";s:32:\"btn-secondary-outline-background\";s:11:\"transparent\";s:38:\"btn-secondary-outline-background-hover\";s:22:\"var(--secondary-hover)\";s:34:\"btn-secondary-outline-border-color\";s:16:\"var(--secondary)\";s:34:\"btn-secondary-outline-border-hover\";s:22:\"var(--secondary-hover)\";s:37:\"btn-secondary-outline-dark-background\";s:11:\"transparent\";s:43:\"btn-secondary-outline-dark-background-hover\";s:21:\"var(--secondary-dark)\";s:39:\"btn-secondary-outline-dark-border-color\";s:21:\"var(--secondary-dark)\";s:39:\"btn-secondary-outline-dark-border-hover\";s:21:\"var(--secondary-dark)\";s:38:\"btn-secondary-outline-dark-focus-color\";s:26:\"var(--secondary-semi-dark)\";s:33:\"btn-secondary-outline-focus-color\";s:27:\"var(--secondary-semi-light)\";s:38:\"btn-secondary-outline-light-background\";s:11:\"transparent\";s:44:\"btn-secondary-outline-light-background-hover\";s:22:\"var(--secondary-light)\";s:40:\"btn-secondary-outline-light-border-color\";s:22:\"var(--secondary-light)\";s:40:\"btn-secondary-outline-light-border-hover\";s:22:\"var(--secondary-light)\";s:39:\"btn-secondary-outline-light-focus-color\";s:22:\"var(--secondary-light)\";s:18:\"btn-secondary-text\";s:28:\"var(--secondary-ultra-light)\";s:12:\"btn-shade-bg\";s:12:\"var(--shade)\";s:22:\"btn-shade-border-color\";s:12:\"var(--shade)\";s:21:\"btn-shade-focus-color\";s:18:\"var(--shade-light)\";s:15:\"btn-shade-hover\";s:18:\"var(--shade-hover)\";s:28:\"btn-shade-hover-border-color\";s:18:\"var(--shade-hover)\";s:20:\"btn-shade-hover-text\";s:24:\"var(--shade-ultra-light)\";s:28:\"btn-shade-outline-background\";s:11:\"transparent\";s:34:\"btn-shade-outline-background-hover\";s:18:\"var(--shade-hover)\";s:30:\"btn-shade-outline-border-color\";s:12:\"var(--shade)\";s:30:\"btn-shade-outline-border-hover\";s:18:\"var(--shade-hover)\";s:29:\"btn-shade-outline-focus-color\";s:23:\"var(--shade-semi-light)\";s:14:\"btn-shade-text\";s:24:\"var(--shade-ultra-light)\";s:14:\"btn-success-bg\";s:14:\"var(--success)\";s:24:\"btn-success-border-color\";s:14:\"var(--success)\";s:19:\"btn-success-dark-bg\";s:19:\"var(--success-dark)\";s:29:\"btn-success-dark-border-color\";s:19:\"var(--success-dark)\";s:28:\"btn-success-dark-focus-color\";s:24:\"var(--success-semi-dark)\";s:22:\"btn-success-dark-hover\";s:25:\"var(--success-ultra-dark)\";s:35:\"btn-success-dark-hover-border-color\";s:25:\"var(--success-ultra-dark)\";s:27:\"btn-success-dark-hover-text\";s:26:\"var(--success-ultra-light)\";s:21:\"btn-success-dark-text\";s:26:\"var(--success-ultra-light)\";s:23:\"btn-success-focus-color\";s:20:\"var(--success-light)\";s:17:\"btn-success-hover\";s:20:\"var(--success-hover)\";s:30:\"btn-success-hover-border-color\";s:20:\"var(--success-hover)\";s:22:\"btn-success-hover-text\";s:26:\"var(--success-ultra-light)\";s:20:\"btn-success-light-bg\";s:26:\"var(--success-ultra-light)\";s:30:\"btn-success-light-border-color\";s:26:\"var(--success-ultra-light)\";s:29:\"btn-success-light-focus-color\";s:20:\"var(--success-light)\";s:23:\"btn-success-light-hover\";s:20:\"var(--success-light)\";s:36:\"btn-success-light-hover-border-color\";s:20:\"var(--success-light)\";s:28:\"btn-success-light-hover-text\";s:25:\"var(--success-ultra-dark)\";s:22:\"btn-success-light-text\";s:14:\"var(--success)\";s:30:\"btn-success-outline-background\";s:11:\"transparent\";s:36:\"btn-success-outline-background-hover\";s:20:\"var(--success-hover)\";s:32:\"btn-success-outline-border-color\";s:14:\"var(--success)\";s:32:\"btn-success-outline-border-hover\";s:20:\"var(--success-hover)\";s:35:\"btn-success-outline-dark-background\";s:11:\"transparent\";s:41:\"btn-success-outline-dark-background-hover\";s:19:\"var(--success-dark)\";s:37:\"btn-success-outline-dark-border-color\";s:19:\"var(--success-dark)\";s:37:\"btn-success-outline-dark-border-hover\";s:19:\"var(--success-dark)\";s:36:\"btn-success-outline-dark-focus-color\";s:24:\"var(--success-semi-dark)\";s:31:\"btn-success-outline-focus-color\";s:25:\"var(--success-semi-light)\";s:36:\"btn-success-outline-light-background\";s:11:\"transparent\";s:42:\"btn-success-outline-light-background-hover\";s:20:\"var(--success-light)\";s:38:\"btn-success-outline-light-border-color\";s:20:\"var(--success-light)\";s:38:\"btn-success-outline-light-border-hover\";s:20:\"var(--success-light)\";s:37:\"btn-success-outline-light-focus-color\";s:20:\"var(--success-light)\";s:16:\"btn-success-text\";s:26:\"var(--success-ultra-light)\";s:15:\"btn-tertiary-bg\";s:15:\"var(--tertiary)\";s:25:\"btn-tertiary-border-color\";s:15:\"var(--tertiary)\";s:20:\"btn-tertiary-dark-bg\";s:20:\"var(--tertiary-dark)\";s:30:\"btn-tertiary-dark-border-color\";s:20:\"var(--tertiary-dark)\";s:29:\"btn-tertiary-dark-focus-color\";s:25:\"var(--tertiary-semi-dark)\";s:23:\"btn-tertiary-dark-hover\";s:26:\"var(--tertiary-ultra-dark)\";s:36:\"btn-tertiary-dark-hover-border-color\";s:26:\"var(--tertiary-ultra-dark)\";s:28:\"btn-tertiary-dark-hover-text\";s:27:\"var(--tertiary-ultra-light)\";s:22:\"btn-tertiary-dark-text\";s:27:\"var(--tertiary-ultra-light)\";s:24:\"btn-tertiary-focus-color\";s:21:\"var(--tertiary-light)\";s:18:\"btn-tertiary-hover\";s:21:\"var(--tertiary-hover)\";s:31:\"btn-tertiary-hover-border-color\";s:21:\"var(--tertiary-hover)\";s:23:\"btn-tertiary-hover-text\";s:27:\"var(--tertiary-ultra-light)\";s:21:\"btn-tertiary-light-bg\";s:27:\"var(--tertiary-ultra-light)\";s:31:\"btn-tertiary-light-border-color\";s:27:\"var(--tertiary-ultra-light)\";s:30:\"btn-tertiary-light-focus-color\";s:21:\"var(--tertiary-light)\";s:24:\"btn-tertiary-light-hover\";s:21:\"var(--tertiary-light)\";s:37:\"btn-tertiary-light-hover-border-color\";s:21:\"var(--tertiary-light)\";s:29:\"btn-tertiary-light-hover-text\";s:26:\"var(--tertiary-ultra-dark)\";s:23:\"btn-tertiary-light-text\";s:15:\"var(--tertiary)\";s:31:\"btn-tertiary-outline-background\";s:11:\"transparent\";s:37:\"btn-tertiary-outline-background-hover\";s:21:\"var(--tertiary-hover)\";s:33:\"btn-tertiary-outline-border-color\";s:15:\"var(--tertiary)\";s:33:\"btn-tertiary-outline-border-hover\";s:21:\"var(--tertiary-hover)\";s:36:\"btn-tertiary-outline-dark-background\";s:11:\"transparent\";s:42:\"btn-tertiary-outline-dark-background-hover\";s:20:\"var(--tertiary-dark)\";s:38:\"btn-tertiary-outline-dark-border-color\";s:20:\"var(--tertiary-dark)\";s:38:\"btn-tertiary-outline-dark-border-hover\";s:20:\"var(--tertiary-dark)\";s:37:\"btn-tertiary-outline-dark-focus-color\";s:25:\"var(--tertiary-semi-dark)\";s:32:\"btn-tertiary-outline-focus-color\";s:26:\"var(--tertiary-semi-light)\";s:37:\"btn-tertiary-outline-light-background\";s:11:\"transparent\";s:43:\"btn-tertiary-outline-light-background-hover\";s:21:\"var(--tertiary-light)\";s:39:\"btn-tertiary-outline-light-border-color\";s:21:\"var(--tertiary-light)\";s:39:\"btn-tertiary-outline-light-border-hover\";s:21:\"var(--tertiary-light)\";s:38:\"btn-tertiary-outline-light-focus-color\";s:21:\"var(--tertiary-light)\";s:17:\"btn-tertiary-text\";s:27:\"var(--tertiary-ultra-light)\";s:14:\"btn-text-align\";s:6:\"center\";s:19:\"btn-text-decoration\";s:4:\"none\";s:25:\"btn-text-decoration-hover\";s:4:\"none\";s:12:\"btn-text-max\";i:18;s:12:\"btn-text-min\";i:14;s:18:\"btn-text-transform\";s:9:\"uppercase\";s:14:\"btn-transition\";s:0:\"\";s:32:\"btn-use-global-transition-option\";s:2:\"on\";s:14:\"btn-warning-bg\";s:14:\"var(--warning)\";s:24:\"btn-warning-border-color\";s:14:\"var(--warning)\";s:19:\"btn-warning-dark-bg\";s:19:\"var(--warning-dark)\";s:29:\"btn-warning-dark-border-color\";s:19:\"var(--warning-dark)\";s:28:\"btn-warning-dark-focus-color\";s:24:\"var(--warning-semi-dark)\";s:22:\"btn-warning-dark-hover\";s:25:\"var(--warning-ultra-dark)\";s:35:\"btn-warning-dark-hover-border-color\";s:25:\"var(--warning-ultra-dark)\";s:27:\"btn-warning-dark-hover-text\";s:26:\"var(--warning-ultra-light)\";s:21:\"btn-warning-dark-text\";s:26:\"var(--warning-ultra-light)\";s:23:\"btn-warning-focus-color\";s:20:\"var(--warning-light)\";s:17:\"btn-warning-hover\";s:20:\"var(--warning-hover)\";s:30:\"btn-warning-hover-border-color\";s:20:\"var(--warning-hover)\";s:22:\"btn-warning-hover-text\";s:26:\"var(--warning-ultra-light)\";s:20:\"btn-warning-light-bg\";s:26:\"var(--warning-ultra-light)\";s:30:\"btn-warning-light-border-color\";s:26:\"var(--warning-ultra-light)\";s:29:\"btn-warning-light-focus-color\";s:20:\"var(--warning-light)\";s:23:\"btn-warning-light-hover\";s:20:\"var(--warning-light)\";s:36:\"btn-warning-light-hover-border-color\";s:20:\"var(--warning-light)\";s:28:\"btn-warning-light-hover-text\";s:25:\"var(--warning-ultra-dark)\";s:22:\"btn-warning-light-text\";s:14:\"var(--warning)\";s:30:\"btn-warning-outline-background\";s:11:\"transparent\";s:36:\"btn-warning-outline-background-hover\";s:20:\"var(--warning-hover)\";s:32:\"btn-warning-outline-border-color\";s:14:\"var(--warning)\";s:32:\"btn-warning-outline-border-hover\";s:20:\"var(--warning-hover)\";s:35:\"btn-warning-outline-dark-background\";s:11:\"transparent\";s:41:\"btn-warning-outline-dark-background-hover\";s:19:\"var(--warning-dark)\";s:37:\"btn-warning-outline-dark-border-color\";s:19:\"var(--warning-dark)\";s:37:\"btn-warning-outline-dark-border-hover\";s:19:\"var(--warning-dark)\";s:36:\"btn-warning-outline-dark-focus-color\";s:24:\"var(--warning-semi-dark)\";s:31:\"btn-warning-outline-focus-color\";s:25:\"var(--warning-semi-light)\";s:36:\"btn-warning-outline-light-background\";s:11:\"transparent\";s:42:\"btn-warning-outline-light-background-hover\";s:20:\"var(--warning-light)\";s:38:\"btn-warning-outline-light-border-color\";s:20:\"var(--warning-light)\";s:38:\"btn-warning-outline-light-border-hover\";s:20:\"var(--warning-light)\";s:37:\"btn-warning-outline-light-focus-color\";s:20:\"var(--warning-light)\";s:16:\"btn-warning-text\";s:26:\"var(--warning-ultra-light)\";s:12:\"btn-white-bg\";s:12:\"var(--white)\";s:22:\"btn-white-border-color\";s:12:\"var(--white)\";s:21:\"btn-white-focus-color\";s:13:\"var(--action)\";s:15:\"btn-white-hover\";s:19:\"var(--action-light)\";s:28:\"btn-white-hover-border-color\";s:19:\"var(--action-light)\";s:20:\"btn-white-hover-text\";s:16:\"var(--text-dark)\";s:28:\"btn-white-outline-background\";s:11:\"transparent\";s:34:\"btn-white-outline-background-hover\";s:12:\"var(--white)\";s:30:\"btn-white-outline-border-color\";s:12:\"var(--white)\";s:30:\"btn-white-outline-border-hover\";s:12:\"var(--white)\";s:29:\"btn-white-outline-focus-color\";s:14:\"var(--primary)\";s:14:\"btn-white-text\";s:16:\"var(--text-dark)\";s:24:\"card-avatar-aspect-ratio\";s:1:\"1\";s:24:\"card-avatar-border-style\";s:19:\"var(--border-style)\";s:24:\"card-avatar-border-width\";s:19:\"var(--border-width)\";s:18:\"card-avatar-radius\";s:4:\"50vw\";s:16:\"card-avatar-size\";s:4:\"60px\";s:17:\"card-border-style\";s:4:\"none\";s:17:\"card-border-width\";s:3:\"1px\";s:21:\"card-button-font-size\";s:13:\"var(--text-s)\";s:8:\"card-gap\";s:28:\"calc(var(--content-gap) / 2)\";s:17:\"card-heading-size\";s:9:\"var(--h3)\";s:16:\"card-icon-radius\";s:18:\"var(--icon-radius)\";s:14:\"card-icon-size\";s:4:\"48px\";s:23:\"card-media-aspect-ratio\";s:5:\"4 / 3\";s:21:\"card-media-object-fit\";s:5:\"cover\";s:17:\"card-media-radius\";s:13:\"var(--radius)\";s:12:\"card-padding\";s:14:\"var(--space-l)\";s:11:\"card-radius\";s:13:\"var(--radius)\";s:18:\"card-selector-auto\";s:42:\":where([class*=\'card\']:not([class*=\'__\']))\";s:14:\"card-selectors\";s:5:\".card\";s:14:\"card-text-size\";s:13:\"var(--text-s)\";s:16:\"col-rule-width-l\";s:5:\"0.5em\";s:16:\"col-rule-width-m\";s:5:\"0.3em\";s:16:\"col-rule-width-s\";s:5:\"0.1em\";s:11:\"col-width-l\";s:5:\"38rem\";s:11:\"col-width-m\";s:5:\"25rem\";s:11:\"col-width-s\";s:5:\"13rem\";s:12:\"color-accent\";s:7:\"#00fffb\";s:16:\"color-accent-alt\";s:7:\"#bcc8a2\";s:12:\"color-action\";s:7:\"#d2a63c\";s:16:\"color-action-alt\";s:7:\"#32a2c1\";s:10:\"color-base\";s:7:\"#0a2434\";s:14:\"color-base-alt\";s:7:\"#0a2434\";s:12:\"color-danger\";s:7:\"#DC3545\";s:16:\"color-danger-alt\";s:7:\"#DC3545\";s:10:\"color-info\";s:7:\"#18A2B8\";s:14:\"color-info-alt\";s:7:\"#18A2B8\";s:13:\"color-neutral\";s:7:\"#000000\";s:17:\"color-neutral-alt\";s:7:\"#ffffff\";s:13:\"color-primary\";s:7:\"#f3f3e6\";s:17:\"color-primary-alt\";s:7:\"#5b99a6\";s:15:\"color-secondary\";s:7:\"#1c1930\";s:19:\"color-secondary-alt\";s:7:\"#1c1930\";s:11:\"color-shade\";s:7:\"#000000\";s:15:\"color-shade-alt\";s:7:\"#ffffff\";s:13:\"color-success\";s:7:\"#29A745\";s:17:\"color-success-alt\";s:7:\"#29A745\";s:14:\"color-tertiary\";s:7:\"#867A5B\";s:18:\"color-tertiary-alt\";s:7:\"#3D3829\";s:13:\"color-warning\";s:7:\"#FFC10A\";s:17:\"color-warning-alt\";s:7:\"#FFC10A\";s:28:\"colorscheme-locked-selectors\";s:0:\"\";s:15:\"content-feature\";s:4:\"50px\";s:19:\"content-feature-max\";s:5:\"100px\";s:23:\"content-grid-exclusions\";s:42:\"\".content-grid--off\", \".pswp__scroll-wrap\"\";s:24:\"contextual-container-gap\";s:15:\"var(--space-xl)\";s:22:\"contextual-content-gap\";s:14:\"var(--space-m)\";s:19:\"contextual-grid-gap\";s:14:\"var(--space-m)\";s:17:\"custom-global-css\";s:0:\"\";s:13:\"danger-comp-h\";i:354;s:17:\"danger-comp-h-alt\";i:354;s:13:\"danger-comp-l\";i:54;s:17:\"danger-comp-l-alt\";i:54;s:13:\"danger-comp-s\";i:70;s:17:\"danger-comp-s-alt\";i:70;s:13:\"danger-dark-h\";d:354;s:17:\"danger-dark-h-alt\";d:354;s:13:\"danger-dark-l\";d:15;s:17:\"danger-dark-l-alt\";d:15;s:13:\"danger-dark-s\";d:71;s:17:\"danger-dark-s-alt\";d:71;s:14:\"danger-hover-h\";d:354;s:18:\"danger-hover-h-alt\";d:354;s:14:\"danger-hover-l\";d:62.099999999999994315658113919198513031005859375;s:18:\"danger-hover-l-alt\";d:62.099999999999994315658113919198513031005859375;s:14:\"danger-hover-s\";d:71;s:18:\"danger-hover-s-alt\";d:71;s:14:\"danger-light-h\";d:354;s:18:\"danger-light-h-alt\";d:354;s:14:\"danger-light-l\";d:85;s:18:\"danger-light-l-alt\";d:85;s:14:\"danger-light-s\";d:71;s:18:\"danger-light-s-alt\";d:71;s:15:\"danger-medium-h\";i:354;s:19:\"danger-medium-h-alt\";i:354;s:15:\"danger-medium-l\";i:50;s:19:\"danger-medium-l-alt\";i:50;s:15:\"danger-medium-s\";i:70;s:19:\"danger-medium-s-alt\";i:70;s:23:\"danger-outline-btn-text\";s:13:\"var(--danger)\";s:28:\"danger-outline-dark-btn-text\";s:18:\"var(--danger-dark)\";s:30:\"danger-outline-dark-hover-text\";s:25:\"var(--danger-ultra-light)\";s:25:\"danger-outline-hover-text\";s:25:\"var(--danger-ultra-light)\";s:29:\"danger-outline-light-btn-text\";s:19:\"var(--danger-light)\";s:31:\"danger-outline-light-hover-text\";s:18:\"var(--danger-dark)\";s:18:\"danger-semi-dark-h\";d:354;s:22:\"danger-semi-dark-h-alt\";d:354;s:18:\"danger-semi-dark-l\";i:35;s:22:\"danger-semi-dark-l-alt\";i:35;s:18:\"danger-semi-dark-s\";d:70;s:22:\"danger-semi-dark-s-alt\";d:70;s:19:\"danger-semi-light-h\";d:354;s:23:\"danger-semi-light-h-alt\";d:354;s:19:\"danger-semi-light-l\";i:65;s:23:\"danger-semi-light-l-alt\";i:65;s:19:\"danger-semi-light-s\";d:70;s:23:\"danger-semi-light-s-alt\";d:70;s:19:\"danger-ultra-dark-h\";i:354;s:23:\"danger-ultra-dark-h-alt\";i:354;s:19:\"danger-ultra-dark-l\";i:10;s:23:\"danger-ultra-dark-l-alt\";i:10;s:19:\"danger-ultra-dark-s\";i:70;s:23:\"danger-ultra-dark-s-alt\";i:70;s:20:\"danger-ultra-light-h\";i:354;s:24:\"danger-ultra-light-h-alt\";i:354;s:20:\"danger-ultra-light-l\";i:95;s:24:\"danger-ultra-light-l-alt\";i:95;s:20:\"danger-ultra-light-s\";i:70;s:24:\"danger-ultra-light-s-alt\";i:70;s:29:\"dark-card-avatar-border-color\";s:0:\"\";s:20:\"dark-card-background\";s:12:\"var(--black)\";s:26:\"dark-card-background-hover\";s:27:\"var(--dark-card-background)\";s:22:\"dark-card-border-color\";s:0:\"\";s:22:\"dark-card-button-style\";s:7:\"primary\";s:23:\"dark-card-heading-color\";s:17:\"var(--text-light)\";s:20:\"dark-card-icon-style\";s:4:\"dark\";s:20:\"dark-card-link-color\";s:14:\"var(--primary)\";s:26:\"dark-card-link-color-hover\";s:20:\"var(--primary-hover)\";s:16:\"dark-card-shadow\";s:0:\"\";s:20:\"dark-card-text-color\";s:23:\"var(--text-light-muted)\";s:13:\"debug-enabled\";s:3:\"off\";s:22:\"delete-on-deactivation\";s:2:\"no\";s:15:\"device-bg-color\";s:12:\"var(--white)\";s:18:\"divider-color-dark\";s:21:\"var(--black-trans-20)\";s:19:\"divider-color-light\";s:21:\"var(--white-trans-20)\";s:11:\"divider-gap\";s:18:\"var(--content-gap)\";s:12:\"divider-main\";s:66:\"var(--divider-size) var(--divider-style) var(--divider-color-dark)\";s:12:\"divider-size\";s:3:\"1px\";s:13:\"divider-style\";s:5:\"solid\";s:23:\"external-link-indicator\";s:5:\"\\2197\";s:42:\"external-link-indicator-accessibility-text\";s:21:\"Link to external site\";s:33:\"external-link-indicator-alignment\";s:6:\"center\";s:29:\"external-link-indicator-color\";s:12:\"currentColor\";s:35:\"external-link-indicator-color-hover\";s:12:\"currentColor\";s:27:\"external-link-indicator-gap\";s:5:\".25em\";s:27:\"external-link-indicator-not\";s:39:\":has(> img, > figure, > picture, > svg)\";s:30:\"external-link-indicator-offset\";s:3:\"0 0\";s:32:\"external-link-indicator-position\";s:3:\"end\";s:28:\"external-link-indicator-size\";s:4:\".9em\";s:30:\"external-link-indicator-weight\";s:7:\"inherit\";s:19:\"f-btn-border-radius\";s:17:\"var(--btn-radius)\";s:18:\"f-btn-border-style\";s:5:\"solid\";s:18:\"f-btn-border-width\";s:23:\"var(--btn-border-width)\";s:17:\"f-btn-font-weight\";i:400;s:17:\"f-btn-line-height\";d:1;s:16:\"f-btn-margin-top\";s:1:\"0\";s:15:\"f-btn-padding-x\";s:5:\"1.5em\";s:15:\"f-btn-padding-y\";s:5:\".75em\";s:21:\"f-btn-text-decoration\";s:4:\"none\";s:19:\"f-btn-text-size-max\";i:18;s:19:\"f-btn-text-size-min\";i:14;s:20:\"f-btn-text-transform\";s:4:\"none\";s:21:\"f-dark-btn-background\";s:13:\"var(--action)\";s:27:\"f-dark-btn-background-hover\";s:19:\"var(--action-hover)\";s:23:\"f-dark-btn-border-color\";s:13:\"var(--action)\";s:29:\"f-dark-btn-border-color-hover\";s:19:\"var(--action-hover)\";s:21:\"f-dark-btn-text-color\";s:25:\"var(--action-ultra-light)\";s:27:\"f-dark-btn-text-color-hover\";s:25:\"var(--action-ultra-light)\";s:33:\"f-dark-clear-btn-background-color\";s:20:\"var(--neutral-light)\";s:39:\"f-dark-clear-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:27:\"f-dark-clear-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:33:\"f-dark-clear-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:25:\"f-dark-clear-button-style\";s:20:\"neutral.btn--outline\";s:18:\"f-dark-focus-color\";s:13:\"var(--action)\";s:26:\"f-dark-focus-color-opacity\";d:0.25;s:22:\"f-dark-help-text-color\";s:20:\"var(--neutral-light)\";s:23:\"f-dark-input-background\";s:19:\"var(--neutral-dark)\";s:25:\"f-dark-input-border-color\";s:21:\"var(--neutral-medium)\";s:31:\"f-dark-input-border-color-hover\";s:24:\"var(--neutral-semi-dark)\";s:35:\"f-dark-input-color-background-hover\";s:19:\"var(--neutral-dark)\";s:30:\"f-dark-input-placeholder-color\";s:26:\"var(--neutral-ultra-light)\";s:36:\"f-dark-input-placeholder-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:32:\"f-dark-input-placeholder-opacity\";d:0.5;s:23:\"f-dark-input-text-color\";s:26:\"var(--neutral-ultra-light)\";s:29:\"f-dark-input-text-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:29:\"f-dark-label-background-color\";s:0:\"\";s:36:\"f-dark-label-inside-background-color\";s:11:\"transparent\";s:42:\"f-dark-label-inside-background-color-focus\";s:11:\"transparent\";s:23:\"f-dark-label-text-color\";s:26:\"var(--neutral-ultra-light)\";s:24:\"f-dark-legend-text-color\";s:26:\"var(--neutral-ultra-light)\";s:32:\"f-dark-next-btn-background-color\";s:20:\"var(--neutral-light)\";s:38:\"f-dark-next-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:26:\"f-dark-next-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:32:\"f-dark-next-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:24:\"f-dark-next-button-style\";s:20:\"primary.btn--outline\";s:26:\"f-dark-option-action-color\";s:13:\"var(--action)\";s:30:\"f-dark-option-background-color\";s:11:\"transparent\";s:26:\"f-dark-option-border-color\";s:14:\"var(--neutral)\";s:32:\"f-dark-prev-btn-background-color\";s:20:\"var(--neutral-light)\";s:38:\"f-dark-prev-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:26:\"f-dark-prev-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:32:\"f-dark-prev-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:28:\"f-dark-previous-button-style\";s:20:\"primary.btn--outline\";s:32:\"f-dark-progress-background-color\";s:23:\"var(--base-ultra-light)\";s:30:\"f-dark-progress-bar-fill-color\";s:13:\"var(--action)\";s:26:\"f-dark-radio-button-active\";s:13:\"primary-light\";s:25:\"f-dark-radio-button-style\";s:7:\"primary\";s:29:\"f-dark-range-left-track-color\";s:21:\"var(--neutral-medium)\";s:30:\"f-dark-range-right-track-color\";s:21:\"var(--neutral-medium)\";s:24:\"f-dark-range-thumb-color\";s:13:\"var(--action)\";s:21:\"f-dark-required-color\";s:0:\"\";s:33:\"f-dark-reset-btn-background-color\";s:20:\"var(--neutral-light)\";s:39:\"f-dark-reset-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:27:\"f-dark-reset-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:33:\"f-dark-reset-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:25:\"f-dark-reset-button-style\";s:7:\"neutral\";s:32:\"f-dark-save-btn-background-color\";s:20:\"var(--neutral-light)\";s:38:\"f-dark-save-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:26:\"f-dark-save-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:32:\"f-dark-save-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:24:\"f-dark-save-button-style\";s:7:\"success\";s:37:\"f-dark-secondary-btn-background-color\";s:20:\"var(--neutral-light)\";s:43:\"f-dark-secondary-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:31:\"f-dark-secondary-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:37:\"f-dark-secondary-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:29:\"f-dark-secondary-button-style\";s:23:\"primary.btn--outlineary\";s:25:\"f-dark-select-arrow-color\";s:26:\"var(--neutral-ultra-light)\";s:26:\"f-dark-submit-button-style\";s:7:\"primary\";s:34:\"f-dark-tab-active-background-color\";s:11:\"transparent\";s:30:\"f-dark-tab-active-border-color\";s:13:\"var(--action)\";s:28:\"f-dark-tab-active-text-color\";s:20:\"var(--neutral-light)\";s:27:\"f-dark-tab-background-color\";s:11:\"transparent\";s:30:\"f-dark-tab-border-bottom-color\";s:13:\"var(--action)\";s:23:\"f-dark-tab-border-color\";s:13:\"var(--action)\";s:33:\"f-dark-tab-group-background-color\";s:11:\"transparent\";s:36:\"f-dark-tab-group-border-bottom-color\";s:26:\"var(--neutral-ultra-light)\";s:30:\"f-dark-tab-inactive-text-color\";s:29:\"var(--neutral-light-trans-80)\";s:21:\"f-dark-tab-text-color\";s:19:\"var(--neutral-dark)\";s:34:\"f-dark-upload-btn-background-color\";s:20:\"var(--neutral-light)\";s:40:\"f-dark-upload-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:28:\"f-dark-upload-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:34:\"f-dark-upload-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:26:\"f-dark-upload-button-style\";s:7:\"primary\";s:21:\"f-field-margin-bottom\";s:5:\"1.5em\";s:24:\"f-fieldset-margin-bottom\";s:5:\"1.5em\";s:13:\"f-grid-gutter\";s:4:\"2rem\";s:18:\"f-help-line-height\";d:1.399999999999999911182158029987476766109466552734375;s:19:\"f-help-margin-block\";s:7:\"0.5em 0\";s:15:\"f-help-size-max\";d:14;s:15:\"f-help-size-min\";d:12;s:18:\"f-help-text-weight\";i:400;s:26:\"f-input-border-bottom-size\";i:1;s:24:\"f-input-border-left-size\";i:1;s:21:\"f-input-border-radius\";s:17:\"var(--btn-radius)\";s:25:\"f-input-border-right-size\";i:1;s:20:\"f-input-border-style\";s:5:\"solid\";s:23:\"f-input-border-top-size\";i:1;s:19:\"f-input-font-weight\";i:400;s:14:\"f-input-height\";s:2:\"50\";s:19:\"f-input-line-height\";d:1;s:17:\"f-input-padding-x\";s:3:\"1em\";s:17:\"f-input-padding-y\";s:4:\".5em\";s:21:\"f-input-text-size-max\";s:2:\"20\";s:21:\"f-input-text-size-min\";s:2:\"16\";s:19:\"f-label-font-weight\";i:400;s:28:\"f-label-inside-position-left\";s:5:\"1.5em\";s:27:\"f-label-inside-position-top\";s:1:\"0\";s:20:\"f-label-inside-scale\";s:1:\"1\";s:19:\"f-label-line-height\";d:1;s:21:\"f-label-margin-bottom\";s:5:\"0.5em\";s:17:\"f-label-padding-x\";s:1:\"0\";s:17:\"f-label-padding-y\";s:1:\"0\";s:16:\"f-label-size-max\";d:16;s:16:\"f-label-size-min\";d:14;s:22:\"f-label-text-transform\";s:4:\"none\";s:20:\"f-legend-line-height\";d:1.1999999999999999555910790149937383830547332763671875;s:22:\"f-legend-margin-bottom\";s:3:\"1em\";s:17:\"f-legend-size-max\";d:16;s:17:\"f-legend-size-min\";d:14;s:20:\"f-legend-text-weight\";i:400;s:22:\"f-light-btn-background\";s:13:\"var(--action)\";s:28:\"f-light-btn-background-hover\";s:19:\"var(--action-hover)\";s:24:\"f-light-btn-border-color\";s:13:\"var(--action)\";s:30:\"f-light-btn-border-color-hover\";s:19:\"var(--action-hover)\";s:22:\"f-light-btn-text-color\";s:25:\"var(--action-ultra-light)\";s:28:\"f-light-btn-text-color-hover\";s:25:\"var(--action-ultra-light)\";s:34:\"f-light-clear-btn-background-color\";s:20:\"var(--neutral-light)\";s:40:\"f-light-clear-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:28:\"f-light-clear-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:34:\"f-light-clear-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:26:\"f-light-clear-button-style\";s:20:\"neutral.btn--outline\";s:19:\"f-light-focus-color\";s:13:\"var(--action)\";s:27:\"f-light-focus-color-opacity\";d:0.25;s:23:\"f-light-help-text-color\";s:21:\"var(--neutral-medium)\";s:24:\"f-light-input-background\";s:12:\"var(--white)\";s:26:\"f-light-input-border-color\";s:20:\"var(--neutral-light)\";s:32:\"f-light-input-border-color-hover\";s:20:\"var(--neutral-light)\";s:36:\"f-light-input-color-background-hover\";s:12:\"var(--white)\";s:31:\"f-light-input-placeholder-color\";s:19:\"var(--neutral-dark)\";s:37:\"f-light-input-placeholder-color-hover\";s:19:\"var(--neutral-dark)\";s:33:\"f-light-input-placeholder-opacity\";d:0.5;s:24:\"f-light-input-text-color\";s:19:\"var(--neutral-dark)\";s:30:\"f-light-input-text-color-hover\";s:19:\"var(--neutral-dark)\";s:30:\"f-light-label-background-color\";s:0:\"\";s:37:\"f-light-label-inside-background-color\";s:11:\"transparent\";s:43:\"f-light-label-inside-background-color-focus\";s:11:\"transparent\";s:24:\"f-light-label-text-color\";s:19:\"var(--neutral-dark)\";s:25:\"f-light-legend-text-color\";s:19:\"var(--neutral-dark)\";s:33:\"f-light-next-btn-background-color\";s:20:\"var(--neutral-light)\";s:39:\"f-light-next-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:27:\"f-light-next-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:33:\"f-light-next-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:25:\"f-light-next-button-style\";s:7:\"primary\";s:27:\"f-light-option-action-color\";s:13:\"var(--action)\";s:31:\"f-light-option-background-color\";s:11:\"transparent\";s:27:\"f-light-option-border-color\";s:14:\"var(--neutral)\";s:33:\"f-light-prev-btn-background-color\";s:20:\"var(--neutral-light)\";s:39:\"f-light-prev-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:27:\"f-light-prev-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:33:\"f-light-prev-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:29:\"f-light-previous-button-style\";s:20:\"primary.btn--outline\";s:33:\"f-light-progress-background-color\";s:23:\"var(--base-ultra-light)\";s:31:\"f-light-progress-bar-fill-color\";s:13:\"var(--action)\";s:27:\"f-light-radio-button-active\";s:13:\"primary-light\";s:26:\"f-light-radio-button-style\";s:7:\"primary\";s:30:\"f-light-range-left-track-color\";s:26:\"var(--neutral-ultra-light)\";s:31:\"f-light-range-right-track-color\";s:26:\"var(--neutral-ultra-light)\";s:25:\"f-light-range-thumb-color\";s:13:\"var(--action)\";s:22:\"f-light-required-color\";s:0:\"\";s:34:\"f-light-reset-btn-background-color\";s:20:\"var(--neutral-light)\";s:40:\"f-light-reset-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:28:\"f-light-reset-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:34:\"f-light-reset-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:26:\"f-light-reset-button-style\";s:7:\"neutral\";s:33:\"f-light-save-btn-background-color\";s:20:\"var(--neutral-light)\";s:39:\"f-light-save-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:27:\"f-light-save-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:33:\"f-light-save-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:25:\"f-light-save-button-style\";s:7:\"success\";s:38:\"f-light-secondary-btn-background-color\";s:20:\"var(--neutral-light)\";s:44:\"f-light-secondary-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:32:\"f-light-secondary-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:38:\"f-light-secondary-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:30:\"f-light-secondary-button-style\";s:20:\"primary.btn--outline\";s:26:\"f-light-select-arrow-color\";s:14:\"var(--neutral)\";s:27:\"f-light-submit-button-style\";s:7:\"primary\";s:35:\"f-light-tab-active-background-color\";s:11:\"transparent\";s:31:\"f-light-tab-active-border-color\";s:13:\"var(--action)\";s:29:\"f-light-tab-active-text-color\";s:19:\"var(--neutral-dark)\";s:28:\"f-light-tab-background-color\";s:11:\"transparent\";s:31:\"f-light-tab-border-bottom-color\";s:13:\"var(--action)\";s:24:\"f-light-tab-border-color\";s:13:\"var(--action)\";s:34:\"f-light-tab-group-background-color\";s:11:\"transparent\";s:37:\"f-light-tab-group-border-bottom-color\";s:26:\"var(--neutral-ultra-light)\";s:31:\"f-light-tab-inactive-text-color\";s:28:\"var(--neutral-dark-trans-80)\";s:22:\"f-light-tab-text-color\";s:19:\"var(--neutral-dark)\";s:35:\"f-light-upload-btn-background-color\";s:20:\"var(--neutral-light)\";s:41:\"f-light-upload-btn-background-color-hover\";s:26:\"var(--neutral-ultra-light)\";s:29:\"f-light-upload-btn-text-color\";s:25:\"var(--neutral-ultra-dark)\";s:35:\"f-light-upload-btn-text-color-hover\";s:25:\"var(--neutral-ultra-dark)\";s:27:\"f-light-upload-button-style\";s:7:\"primary\";s:28:\"f-option-label-font-size-max\";i:16;s:28:\"f-option-label-font-size-min\";i:14;s:26:\"f-option-label-font-weight\";i:400;s:26:\"f-option-label-line-height\";d:1.399999999999999911182158029987476766109466552734375;s:22:\"f-option-label-spacing\";s:5:\"0.5em\";s:21:\"f-progress-bar-radius\";s:17:\"var(--btn-radius)\";s:17:\"f-progress-height\";i:30;s:31:\"f-tab-active-border-bottom-size\";s:3:\"3px\";s:24:\"f-tab-active-border-size\";s:1:\"0\";s:25:\"f-tab-active-border-style\";s:5:\"solid\";s:24:\"f-tab-active-text-weight\";i:600;s:19:\"f-tab-border-radius\";s:1:\"0\";s:17:\"f-tab-border-size\";s:1:\"0\";s:18:\"f-tab-border-style\";s:5:\"solid\";s:30:\"f-tab-group-border-bottom-size\";s:3:\"2px\";s:31:\"f-tab-group-border-bottom-style\";s:5:\"solid\";s:25:\"f-tab-group-margin-bottom\";s:4:\"3rem\";s:21:\"f-tab-group-padding-x\";s:1:\"0\";s:21:\"f-tab-group-padding-y\";s:1:\"0\";s:14:\"f-tab-margin-x\";s:1:\"0\";s:15:\"f-tab-padding-x\";s:5:\"1.5em\";s:15:\"f-tab-padding-y\";s:5:\".75em\";s:16:\"f-tab-text-align\";s:6:\"center\";s:21:\"f-tab-text-decoration\";s:4:\"none\";s:22:\"f-tab-text-line-height\";d:1;s:19:\"f-tab-text-size-max\";i:18;s:19:\"f-tab-text-size-min\";i:16;s:20:\"f-tab-text-transform\";s:4:\"none\";s:17:\"f-tab-text-weight\";i:400;s:11:\"f-tab-width\";s:4:\"auto\";s:18:\"figcaption-spacing\";s:4:\".5em\";s:14:\"figure-spacing\";s:24:\"var(--paragraph-spacing)\";s:12:\"flow-spacing\";s:24:\"var(--paragraph-spacing)\";s:11:\"focus-color\";s:13:\"var(--action)\";s:12:\"focus-offset\";s:6:\"0.25em\";s:11:\"focus-style\";s:7:\"outline\";s:11:\"focus-width\";s:5:\"0.1em\";s:21:\"fr-card-avatar-radius\";s:3:\"50%\";s:20:\"fr-card-border-color\";s:20:\"var(--neutral-light)\";s:19:\"fr-card-border-size\";s:7:\"0.15rem\";s:20:\"fr-card-border-style\";s:5:\"solid\";s:11:\"fr-card-gap\";s:14:\"var(--space-s)\";s:15:\"fr-card-padding\";s:14:\"var(--space-m)\";s:14:\"fr-card-radius\";s:16:\"var(--radius-xs)\";s:15:\"fr-hero-padding\";s:23:\"var(--section-space-xl)\";s:13:\"fr-lede-width\";i:60;s:20:\"gradient-fade-amount\";s:3:\"25%\";s:8:\"h1-color\";s:0:\"\";s:14:\"h1-font-family\";s:0:\"\";s:13:\"h1-font-style\";s:0:\"\";s:14:\"h1-font-weight\";s:0:\"\";s:17:\"h1-letter-spacing\";s:0:\"\";s:14:\"h1-line-height\";d:1.1999999999999999555910790149937383830547332763671875;s:6:\"h1-max\";s:0:\"\";s:12:\"h1-max-width\";s:4:\"100%\";s:6:\"h1-min\";s:0:\"\";s:17:\"h1-text-transform\";s:0:\"\";s:8:\"h2-color\";s:0:\"\";s:14:\"h2-font-family\";s:0:\"\";s:13:\"h2-font-style\";s:0:\"\";s:14:\"h2-font-weight\";s:0:\"\";s:17:\"h2-letter-spacing\";s:0:\"\";s:14:\"h2-line-height\";d:1.1999999999999999555910790149937383830547332763671875;s:6:\"h2-max\";s:0:\"\";s:12:\"h2-max-width\";s:0:\"\";s:6:\"h2-min\";s:0:\"\";s:10:\"h2-spacing\";s:0:\"\";s:17:\"h2-text-transform\";s:0:\"\";s:8:\"h3-color\";s:0:\"\";s:14:\"h3-font-family\";s:0:\"\";s:13:\"h3-font-style\";s:0:\"\";s:14:\"h3-font-weight\";s:0:\"\";s:17:\"h3-letter-spacing\";s:0:\"\";s:14:\"h3-line-height\";d:1.1999999999999999555910790149937383830547332763671875;s:6:\"h3-max\";s:0:\"\";s:12:\"h3-max-width\";s:0:\"\";s:6:\"h3-min\";s:0:\"\";s:10:\"h3-spacing\";s:0:\"\";s:17:\"h3-text-transform\";s:0:\"\";s:8:\"h4-color\";s:0:\"\";s:14:\"h4-font-family\";s:0:\"\";s:13:\"h4-font-style\";s:0:\"\";s:14:\"h4-font-weight\";s:0:\"\";s:17:\"h4-letter-spacing\";s:0:\"\";s:6:\"h4-max\";s:0:\"\";s:12:\"h4-max-width\";s:0:\"\";s:6:\"h4-min\";s:0:\"\";s:10:\"h4-spacing\";s:0:\"\";s:17:\"h4-text-transform\";s:0:\"\";s:8:\"h5-color\";s:0:\"\";s:14:\"h5-font-family\";s:0:\"\";s:13:\"h5-font-style\";s:0:\"\";s:14:\"h5-font-weight\";s:0:\"\";s:17:\"h5-letter-spacing\";s:0:\"\";s:14:\"h5-line-height\";d:1.1999999999999999555910790149937383830547332763671875;s:6:\"h5-max\";d:12;s:12:\"h5-max-width\";s:0:\"\";s:6:\"h5-min\";d:12;s:10:\"h5-spacing\";s:0:\"\";s:17:\"h5-text-transform\";s:0:\"\";s:8:\"h6-color\";s:0:\"\";s:14:\"h6-font-family\";s:0:\"\";s:13:\"h6-font-style\";s:0:\"\";s:14:\"h6-font-weight\";s:0:\"\";s:17:\"h6-letter-spacing\";s:0:\"\";s:14:\"h6-line-height\";d:1.1999999999999999555910790149937383830547332763671875;s:6:\"h6-max\";d:11;s:12:\"h6-max-width\";s:0:\"\";s:6:\"h6-min\";d:11;s:10:\"h6-spacing\";s:0:\"\";s:17:\"h6-text-transform\";s:0:\"\";s:13:\"header-height\";d:0;s:15:\"header-height-l\";d:0;s:15:\"header-height-m\";d:0;s:15:\"header-height-s\";d:0;s:16:\"header-height-xl\";d:0;s:16:\"header-height-xs\";d:0;s:17:\"header-height-xxl\";d:0;s:13:\"heading-color\";s:0:\"\";s:19:\"heading-font-family\";s:0:\"\";s:18:\"heading-font-style\";s:0:\"\";s:22:\"heading-letter-spacing\";s:6:\"1.15px\";s:17:\"heading-max-width\";s:0:\"\";s:13:\"heading-scale\";d:1.3329999999999999626965063725947402417659759521484375;s:15:\"heading-spacing\";s:5:\"1.5em\";s:22:\"heading-text-transform\";s:0:\"\";s:17:\"heading-text-wrap\";s:6:\"pretty\";s:14:\"heading-weight\";s:3:\"600\";s:17:\"icon-block-offset\";s:0:\"\";s:17:\"icon-border-style\";s:19:\"var(--border-style)\";s:17:\"icon-border-width\";s:19:\"var(--border-width)\";s:20:\"icon-dark-background\";s:19:\"var(--primary-dark)\";s:26:\"icon-dark-background-hover\";s:24:\"var(--primary-semi-dark)\";s:22:\"icon-dark-border-color\";s:24:\"var(--border-color-dark)\";s:28:\"icon-dark-border-color-hover\";s:24:\"var(--border-color-dark)\";s:15:\"icon-dark-color\";s:20:\"var(--primary-light)\";s:21:\"icon-dark-color-hover\";s:25:\"var(--primary-semi-light)\";s:16:\"icon-dark-shadow\";s:0:\"\";s:19:\"icon-data-attribute\";s:9:\"data-icon\";s:18:\"icon-default-theme\";s:4:\"dark\";s:18:\"icon-inline-offset\";s:0:\"\";s:21:\"icon-light-background\";s:26:\"var(--primary-ultra-light)\";s:27:\"icon-light-background-hover\";s:20:\"var(--primary-light)\";s:23:\"icon-light-border-color\";s:25:\"var(--border-color-light)\";s:29:\"icon-light-border-color-hover\";s:25:\"var(--border-color-light)\";s:16:\"icon-light-color\";s:19:\"var(--primary-dark)\";s:22:\"icon-light-color-hover\";s:24:\"var(--primary-semi-dark)\";s:17:\"icon-light-shadow\";s:0:\"\";s:13:\"icon-list-gap\";s:3:\"1em\";s:19:\"icon-list-icon-size\";s:3:\"1em\";s:12:\"icon-padding\";s:5:\".35em\";s:14:\"icon-padding-l\";s:19:\"var(--icon-padding)\";s:14:\"icon-padding-m\";s:19:\"var(--icon-padding)\";s:14:\"icon-padding-s\";s:19:\"var(--icon-padding)\";s:15:\"icon-padding-xl\";s:19:\"var(--icon-padding)\";s:15:\"icon-padding-xs\";s:19:\"var(--icon-padding)\";s:16:\"icon-padding-xxl\";s:19:\"var(--icon-padding)\";s:11:\"icon-radius\";s:13:\"var(--radius)\";s:11:\"icon-size-l\";s:4:\"64px\";s:11:\"icon-size-m\";s:4:\"32px\";s:11:\"icon-size-s\";s:4:\"16px\";s:12:\"icon-size-xl\";s:5:\"128px\";s:12:\"icon-size-xs\";s:4:\"12px\";s:13:\"icon-size-xxl\";s:5:\"256px\";s:11:\"info-comp-h\";i:188;s:15:\"info-comp-h-alt\";i:188;s:11:\"info-comp-l\";i:41;s:15:\"info-comp-l-alt\";i:41;s:11:\"info-comp-s\";i:77;s:15:\"info-comp-s-alt\";i:77;s:11:\"info-dark-h\";d:188;s:15:\"info-dark-h-alt\";d:188;s:11:\"info-dark-l\";d:15;s:15:\"info-dark-l-alt\";d:15;s:11:\"info-dark-s\";d:77;s:15:\"info-dark-s-alt\";d:77;s:12:\"info-hover-h\";d:188;s:16:\"info-hover-h-alt\";d:188;s:12:\"info-hover-l\";d:47.14999999999999857891452847979962825775146484375;s:16:\"info-hover-l-alt\";d:47.14999999999999857891452847979962825775146484375;s:12:\"info-hover-s\";d:77;s:16:\"info-hover-s-alt\";d:77;s:12:\"info-light-h\";d:188;s:16:\"info-light-h-alt\";d:188;s:12:\"info-light-l\";d:85;s:16:\"info-light-l-alt\";d:85;s:12:\"info-light-s\";d:77;s:16:\"info-light-s-alt\";d:77;s:13:\"info-medium-h\";i:188;s:17:\"info-medium-h-alt\";i:188;s:13:\"info-medium-l\";i:50;s:17:\"info-medium-l-alt\";i:50;s:13:\"info-medium-s\";i:77;s:17:\"info-medium-s-alt\";i:77;s:21:\"info-outline-btn-text\";s:11:\"var(--info)\";s:26:\"info-outline-dark-btn-text\";s:16:\"var(--info-dark)\";s:28:\"info-outline-dark-hover-text\";s:23:\"var(--info-ultra-light)\";s:23:\"info-outline-hover-text\";s:23:\"var(--info-ultra-light)\";s:27:\"info-outline-light-btn-text\";s:17:\"var(--info-light)\";s:29:\"info-outline-light-hover-text\";s:16:\"var(--info-dark)\";s:16:\"info-semi-dark-h\";d:188;s:20:\"info-semi-dark-h-alt\";d:188;s:16:\"info-semi-dark-l\";i:35;s:20:\"info-semi-dark-l-alt\";i:35;s:16:\"info-semi-dark-s\";d:77;s:20:\"info-semi-dark-s-alt\";d:77;s:17:\"info-semi-light-h\";d:188;s:21:\"info-semi-light-h-alt\";d:188;s:17:\"info-semi-light-l\";i:65;s:21:\"info-semi-light-l-alt\";i:65;s:17:\"info-semi-light-s\";d:77;s:21:\"info-semi-light-s-alt\";d:77;s:17:\"info-ultra-dark-h\";i:188;s:21:\"info-ultra-dark-h-alt\";i:188;s:17:\"info-ultra-dark-l\";i:10;s:21:\"info-ultra-dark-l-alt\";i:10;s:17:\"info-ultra-dark-s\";i:77;s:21:\"info-ultra-dark-s-alt\";i:77;s:18:\"info-ultra-light-h\";i:188;s:22:\"info-ultra-light-h-alt\";i:188;s:18:\"info-ultra-light-l\";i:95;s:22:\"info-ultra-light-l-alt\";i:95;s:18:\"info-ultra-light-s\";i:77;s:22:\"info-ultra-light-s-alt\";i:77;s:30:\"light-card-avatar-border-color\";s:0:\"\";s:21:\"light-card-background\";s:12:\"var(--white)\";s:27:\"light-card-background-hover\";s:28:\"var(--light-card-background)\";s:23:\"light-card-border-color\";s:0:\"\";s:23:\"light-card-button-style\";s:7:\"primary\";s:24:\"light-card-heading-color\";s:16:\"var(--text-dark)\";s:21:\"light-card-icon-style\";s:5:\"light\";s:21:\"light-card-link-color\";s:14:\"var(--primary)\";s:27:\"light-card-link-color-hover\";s:20:\"var(--primary-hover)\";s:17:\"light-card-shadow\";s:0:\"\";s:21:\"light-card-text-color\";s:22:\"var(--text-dark-muted)\";s:10:\"link-color\";s:13:\"var(--action)\";s:16:\"link-color-hover\";s:19:\"var(--action-hover)\";s:15:\"link-decoration\";s:7:\"inherit\";s:21:\"link-decoration-color\";s:0:\"\";s:27:\"link-decoration-color-hover\";s:0:\"\";s:21:\"link-decoration-hover\";s:7:\"inherit\";s:25:\"link-decoration-thickness\";s:0:\"\";s:16:\"link-default-not\";s:0:\"\";s:15:\"link-transition\";s:0:\"\";s:21:\"link-underline-offset\";s:1:\"0\";s:33:\"link-use-global-transition-option\";s:2:\"on\";s:11:\"link-weight\";s:7:\"inherit\";s:19:\"list-indent-spacing\";s:3:\"2em\";s:17:\"list-item-spacing\";s:4:\".5em\";s:12:\"list-spacing\";s:3:\"1em\";s:17:\"mob-heading-scale\";d:1.1999999999999999555910790149937383830547332763671875;s:24:\"mob-space-adjust-section\";d:3;s:15:\"mob-space-scale\";d:1.3329999999999999626965063725947402417659759521484375;s:14:\"mob-text-scale\";d:1.1999999999999999555910790149937383830547332763671875;s:26:\"nested-list-indent-spacing\";s:3:\"1em\";s:24:\"nested-list-item-spacing\";s:0:\"\";s:19:\"nested-list-spacing\";s:0:\"\";s:14:\"neutral-comp-h\";i:0;s:18:\"neutral-comp-h-alt\";i:0;s:14:\"neutral-comp-l\";i:0;s:18:\"neutral-comp-l-alt\";i:100;s:14:\"neutral-comp-s\";i:0;s:18:\"neutral-comp-s-alt\";i:0;s:14:\"neutral-dark-h\";d:0;s:18:\"neutral-dark-h-alt\";d:0;s:14:\"neutral-dark-l\";d:25;s:18:\"neutral-dark-l-alt\";d:75;s:14:\"neutral-dark-s\";d:0;s:18:\"neutral-dark-s-alt\";d:0;s:15:\"neutral-hover-h\";d:0;s:19:\"neutral-hover-h-alt\";d:0;s:15:\"neutral-hover-l\";d:0;s:19:\"neutral-hover-l-alt\";d:114.9999999999999857891452847979962825775146484375;s:15:\"neutral-hover-s\";d:0;s:19:\"neutral-hover-s-alt\";d:0;s:15:\"neutral-light-h\";d:0;s:19:\"neutral-light-h-alt\";d:0;s:15:\"neutral-light-l\";d:85;s:19:\"neutral-light-l-alt\";d:15;s:15:\"neutral-light-s\";d:0;s:19:\"neutral-light-s-alt\";d:0;s:16:\"neutral-medium-h\";d:0;s:20:\"neutral-medium-h-alt\";d:0;s:16:\"neutral-medium-l\";d:50;s:20:\"neutral-medium-l-alt\";d:50;s:16:\"neutral-medium-s\";d:0;s:20:\"neutral-medium-s-alt\";d:0;s:24:\"neutral-outline-btn-text\";s:14:\"var(--neutral)\";s:29:\"neutral-outline-dark-btn-text\";s:19:\"var(--neutral-dark)\";s:31:\"neutral-outline-dark-hover-text\";s:26:\"var(--neutral-ultra-light)\";s:26:\"neutral-outline-hover-text\";s:26:\"var(--neutral-ultra-light)\";s:30:\"neutral-outline-light-btn-text\";s:20:\"var(--neutral-light)\";s:32:\"neutral-outline-light-hover-text\";s:19:\"var(--neutral-dark)\";s:19:\"neutral-semi-dark-h\";d:0;s:23:\"neutral-semi-dark-h-alt\";d:0;s:19:\"neutral-semi-dark-l\";i:35;s:23:\"neutral-semi-dark-l-alt\";i:35;s:19:\"neutral-semi-dark-s\";d:0;s:23:\"neutral-semi-dark-s-alt\";d:0;s:20:\"neutral-semi-light-h\";d:0;s:24:\"neutral-semi-light-h-alt\";d:0;s:20:\"neutral-semi-light-l\";i:65;s:24:\"neutral-semi-light-l-alt\";i:65;s:20:\"neutral-semi-light-s\";d:0;s:24:\"neutral-semi-light-s-alt\";d:0;s:20:\"neutral-ultra-dark-h\";d:0;s:24:\"neutral-ultra-dark-h-alt\";d:0;s:20:\"neutral-ultra-dark-l\";d:10;s:24:\"neutral-ultra-dark-l-alt\";d:90;s:20:\"neutral-ultra-dark-s\";d:0;s:24:\"neutral-ultra-dark-s-alt\";d:0;s:21:\"neutral-ultra-light-h\";d:0;s:25:\"neutral-ultra-light-h-alt\";d:0;s:21:\"neutral-ultra-light-l\";d:95;s:25:\"neutral-ultra-light-l-alt\";d:5;s:21:\"neutral-ultra-light-s\";d:0;s:25:\"neutral-ultra-light-s-alt\";d:0;s:31:\"offset-content-header-exclusion\";s:26:\"\"[data-sticky-header=\'0\']\"\";s:30:\"offset-content-page-exclusions\";s:22:\"\".content-offset--off\"\";s:17:\"option-accent-btn\";s:2:\"on\";s:25:\"option-accent-btn-outline\";s:3:\"off\";s:24:\"option-accent-btn-shades\";s:3:\"off\";s:17:\"option-accent-clr\";s:2:\"on\";s:21:\"option-accent-clr-alt\";s:3:\"off\";s:24:\"option-accent-dark-trans\";s:2:\"on\";s:25:\"option-accent-light-trans\";s:2:\"on\";s:24:\"option-accent-main-trans\";s:2:\"on\";s:30:\"option-accent-ultra-dark-trans\";s:2:\"on\";s:28:\"option-accessibility-classes\";s:2:\"on\";s:34:\"option-acss-dashboard-icon-display\";s:2:\"on\";s:17:\"option-action-btn\";s:2:\"on\";s:17:\"option-action-clr\";s:2:\"on\";s:21:\"option-action-clr-alt\";s:3:\"off\";s:24:\"option-action-dark-trans\";s:2:\"on\";s:25:\"option-action-light-trans\";s:2:\"on\";s:24:\"option-action-main-trans\";s:2:\"on\";s:30:\"option-action-ultra-dark-trans\";s:2:\"on\";s:20:\"option-aspect-ratios\";s:2:\"on\";s:25:\"option-auto-card-selector\";s:3:\"off\";s:16:\"option-auto-grid\";s:2:\"on\";s:22:\"option-auto-object-fit\";s:3:\"off\";s:18:\"option-auto-radius\";s:3:\"off\";s:18:\"option-backgrounds\";s:2:\"on\";s:15:\"option-base-btn\";s:2:\"on\";s:23:\"option-base-btn-outline\";s:3:\"off\";s:22:\"option-base-btn-shades\";s:3:\"off\";s:15:\"option-base-clr\";s:3:\"off\";s:19:\"option-base-clr-alt\";s:3:\"off\";s:22:\"option-base-dark-trans\";s:2:\"on\";s:23:\"option-base-light-trans\";s:2:\"on\";s:22:\"option-base-main-trans\";s:2:\"on\";s:28:\"option-base-ultra-dark-trans\";s:2:\"on\";s:25:\"option-basic-text-classes\";s:2:\"on\";s:33:\"option-bem-class-generator-enable\";s:2:\"on\";s:16:\"option-black-btn\";s:2:\"on\";s:21:\"option-border-classes\";s:2:\"on\";s:18:\"option-box-shadows\";s:2:\"on\";s:18:\"option-boxed-icons\";s:2:\"on\";s:19:\"option-boxed-layout\";s:3:\"off\";s:23:\"option-boxed-list-icons\";s:3:\"off\";s:16:\"option-breakouts\";s:2:\"on\";s:20:\"option-breakpoint-xs\";s:3:\"off\";s:21:\"option-breakpoint-xxl\";s:3:\"off\";s:48:\"option-bricks-color-swatches-checkerboard-enable\";s:2:\"on\";s:23:\"option-bricks-css-first\";s:3:\"off\";s:26:\"option-bricks-css-improved\";s:3:\"off\";s:26:\"option-bricks-grid-overlay\";s:2:\"on\";s:22:\"option-bricks-pro-mode\";s:3:\"off\";s:44:\"option-bricks-replace-components-with-frames\";s:3:\"off\";s:28:\"option-bricks-stack-elements\";s:3:\"off\";s:43:\"option-bricks-template-gallery-enhancements\";s:2:\"on\";s:20:\"option-btn-text-size\";s:3:\"off\";s:31:\"option-builder-input-validation\";s:2:\"on\";s:14:\"option-buttons\";s:2:\"on\";s:28:\"option-buttons-styles-enable\";s:5:\"false\";s:29:\"option-card-concentric-radius\";s:3:\"off\";s:29:\"option-card-container-queries\";s:3:\"off\";s:12:\"option-cards\";s:2:\"on\";s:21:\"option-cards-use-grid\";s:3:\"off\";s:16:\"option-centering\";s:2:\"on\";s:16:\"option-classless\";s:3:\"off\";s:35:\"option-color-scheme-switcher-enable\";s:2:\"on\";s:14:\"option-columns\";s:2:\"on\";s:18:\"option-comp-colors\";s:2:\"on\";s:20:\"option-container-gap\";s:2:\"on\";s:24:\"option-container-queries\";s:2:\"on\";s:18:\"option-content-gap\";s:2:\"on\";s:19:\"option-content-grid\";s:2:\"on\";s:28:\"option-content-grid-sections\";s:3:\"off\";s:30:\"option-contextual-menus-enable\";s:2:\"on\";s:21:\"option-corner-ribbons\";s:2:\"on\";s:17:\"option-danger-btn\";s:3:\"off\";s:25:\"option-danger-btn-outline\";s:3:\"off\";s:24:\"option-danger-btn-shades\";s:3:\"off\";s:17:\"option-danger-clr\";s:2:\"on\";s:21:\"option-danger-clr-alt\";s:3:\"off\";s:24:\"option-danger-dark-trans\";s:2:\"on\";s:25:\"option-danger-light-trans\";s:2:\"on\";s:24:\"option-danger-main-trans\";s:2:\"on\";s:30:\"option-danger-ultra-dark-trans\";s:2:\"on\";s:25:\"option-deprecated-padding\";s:2:\"on\";s:14:\"option-display\";s:2:\"on\";s:22:\"option-divider-classes\";s:2:\"on\";s:24:\"option-expand-icon-sizes\";s:3:\"off\";s:27:\"option-f-use-global-buttons\";s:3:\"off\";s:37:\"option-fix-bricks-template-ids-enable\";s:3:\"off\";s:11:\"option-flex\";s:2:\"on\";s:17:\"option-flex-grids\";s:2:\"on\";s:11:\"option-flip\";s:2:\"on\";s:12:\"option-forms\";s:2:\"on\";s:13:\"option-frames\";s:2:\"on\";s:30:\"option-frames-accordion-widget\";s:3:\"off\";s:33:\"option-frames-accordion-widget-v2\";s:3:\"off\";s:33:\"option-frames-color-scheme-widget\";s:3:\"off\";s:26:\"option-frames-modal-widget\";s:3:\"off\";s:26:\"option-frames-notes-widget\";s:2:\"on\";s:28:\"option-frames-own-admin-page\";s:3:\"off\";s:36:\"option-frames-slider-controls-widget\";s:3:\"off\";s:27:\"option-frames-slider-widget\";s:3:\"off\";s:27:\"option-frames-switch-widget\";s:3:\"off\";s:25:\"option-frames-tabs-widget\";s:3:\"off\";s:24:\"option-frames-toc-widget\";s:3:\"off\";s:27:\"option-frames-toc-widget-v2\";s:3:\"off\";s:28:\"option-frames-trigger-widget\";s:3:\"off\";s:11:\"option-gaps\";s:2:\"on\";s:21:\"option-gradient-fades\";s:2:\"on\";s:11:\"option-grid\";s:2:\"on\";s:15:\"option-grid-gap\";s:2:\"on\";s:39:\"option-gutenberg-color-palette-generate\";s:3:\"off\";s:38:\"option-gutenberg-color-palette-replace\";s:3:\"off\";s:37:\"option-gutenberg-load-styling-backend\";s:2:\"on\";s:13:\"option-height\";s:2:\"on\";s:31:\"option-hide-deactivated-classes\";s:2:\"on\";s:12:\"option-icons\";s:3:\"off\";s:30:\"option-indicate-external-links\";s:3:\"off\";s:15:\"option-info-btn\";s:3:\"off\";s:23:\"option-info-btn-outline\";s:3:\"off\";s:22:\"option-info-btn-shades\";s:3:\"off\";s:15:\"option-info-clr\";s:2:\"on\";s:19:\"option-info-clr-alt\";s:3:\"off\";s:22:\"option-info-dark-trans\";s:2:\"on\";s:23:\"option-info-light-trans\";s:2:\"on\";s:22:\"option-info-main-trans\";s:2:\"on\";s:28:\"option-info-ultra-dark-trans\";s:2:\"on\";s:32:\"option-inverted-radius-framework\";s:3:\"off\";s:40:\"option-keyboard-nav-hover-preview-enable\";s:2:\"on\";s:25:\"option-line-clamp-classes\";s:2:\"on\";s:40:\"option-link-classes-use-decoration-color\";s:3:\"off\";s:17:\"option-link-color\";s:2:\"on\";s:23:\"option-link-default-not\";s:3:\"off\";s:34:\"option-lock-color-scheme-selectors\";s:3:\"off\";s:13:\"option-margin\";s:2:\"on\";s:20:\"option-marker-colors\";s:2:\"on\";s:19:\"option-medium-shade\";s:2:\"on\";s:31:\"option-move-gutenberg-css-input\";s:2:\"on\";s:18:\"option-neutral-btn\";s:3:\"off\";s:26:\"option-neutral-btn-outline\";s:3:\"off\";s:25:\"option-neutral-btn-shades\";s:3:\"off\";s:18:\"option-neutral-clr\";s:2:\"on\";s:22:\"option-neutral-clr-alt\";s:3:\"off\";s:25:\"option-neutral-dark-trans\";s:2:\"on\";s:26:\"option-neutral-light-trans\";s:2:\"on\";s:25:\"option-neutral-main-trans\";s:2:\"on\";s:31:\"option-neutral-ultra-dark-trans\";s:2:\"on\";s:17:\"option-object-fit\";s:2:\"on\";s:26:\"option-offset-page-content\";s:3:\"off\";s:16:\"option-opacities\";s:2:\"on\";s:25:\"option-overflow-detection\";s:3:\"off\";s:15:\"option-overlays\";s:2:\"on\";s:10:\"option-owl\";s:2:\"on\";s:14:\"option-padding\";s:2:\"on\";s:15:\"option-position\";s:2:\"on\";s:27:\"option-prefers-color-scheme\";s:3:\"off\";s:18:\"option-primary-btn\";s:2:\"on\";s:26:\"option-primary-btn-outline\";s:2:\"on\";s:25:\"option-primary-btn-shades\";s:2:\"on\";s:18:\"option-primary-clr\";s:2:\"on\";s:22:\"option-primary-clr-alt\";s:3:\"off\";s:25:\"option-primary-dark-trans\";s:2:\"on\";s:26:\"option-primary-light-trans\";s:2:\"on\";s:25:\"option-primary-main-trans\";s:2:\"on\";s:31:\"option-primary-ultra-dark-trans\";s:2:\"on\";s:15:\"option-pro-mode\";s:3:\"off\";s:19:\"option-radius-sizes\";s:2:\"on\";s:20:\"option-reduce-motion\";s:2:\"on\";s:21:\"option-relate-bg-text\";s:2:\"on\";s:46:\"option-remove-deactivated-classes-from-globals\";s:3:\"off\";s:14:\"option-rounded\";s:2:\"on\";s:20:\"option-secondary-btn\";s:2:\"on\";s:28:\"option-secondary-btn-outline\";s:2:\"on\";s:27:\"option-secondary-btn-shades\";s:2:\"on\";s:20:\"option-secondary-clr\";s:3:\"off\";s:24:\"option-secondary-clr-alt\";s:3:\"off\";s:27:\"option-secondary-dark-trans\";s:2:\"on\";s:28:\"option-secondary-light-trans\";s:2:\"on\";s:27:\"option-secondary-main-trans\";s:2:\"on\";s:33:\"option-secondary-ultra-dark-trans\";s:2:\"on\";s:22:\"option-section-padding\";s:2:\"on\";s:16:\"option-shade-btn\";s:3:\"off\";s:16:\"option-shade-clr\";s:2:\"on\";s:20:\"option-shade-clr-alt\";s:3:\"off\";s:23:\"option-shade-dark-trans\";s:2:\"on\";s:24:\"option-shade-light-trans\";s:2:\"on\";s:23:\"option-shade-main-trans\";s:2:\"on\";s:29:\"option-shade-ultra-dark-trans\";s:2:\"on\";s:20:\"option-smart-spacing\";s:2:\"on\";s:23:\"option-smooth-scrolling\";s:3:\"off\";s:20:\"option-sticky-offset\";s:2:\"on\";s:34:\"option-style-buttons-automatically\";s:3:\"off\";s:18:\"option-success-btn\";s:3:\"off\";s:26:\"option-success-btn-outline\";s:3:\"off\";s:25:\"option-success-btn-shades\";s:3:\"off\";s:18:\"option-success-clr\";s:2:\"on\";s:22:\"option-success-clr-alt\";s:3:\"off\";s:25:\"option-success-dark-trans\";s:2:\"on\";s:26:\"option-success-light-trans\";s:2:\"on\";s:25:\"option-success-main-trans\";s:2:\"on\";s:31:\"option-success-ultra-dark-trans\";s:2:\"on\";s:19:\"option-tertiary-btn\";s:3:\"off\";s:27:\"option-tertiary-btn-outline\";s:3:\"off\";s:26:\"option-tertiary-btn-shades\";s:3:\"off\";s:19:\"option-tertiary-clr\";s:3:\"off\";s:23:\"option-tertiary-clr-alt\";s:3:\"off\";s:26:\"option-tertiary-dark-trans\";s:2:\"on\";s:27:\"option-tertiary-light-trans\";s:2:\"on\";s:26:\"option-tertiary-main-trans\";s:2:\"on\";s:32:\"option-tertiary-ultra-dark-trans\";s:2:\"on\";s:17:\"option-text-color\";s:2:\"on\";s:18:\"option-text-larger\";s:2:\"on\";s:15:\"option-textures\";s:3:\"off\";s:38:\"option-use-gutenberg-for-page-building\";s:3:\"off\";s:42:\"option-use-header-height-for-scroll-offset\";s:2:\"on\";s:20:\"option-variable-grid\";s:2:\"on\";s:17:\"option-visibility\";s:2:\"on\";s:18:\"option-warning-btn\";s:3:\"off\";s:26:\"option-warning-btn-outline\";s:3:\"off\";s:25:\"option-warning-btn-shades\";s:3:\"off\";s:18:\"option-warning-clr\";s:2:\"on\";s:22:\"option-warning-clr-alt\";s:3:\"off\";s:25:\"option-warning-dark-trans\";s:2:\"on\";s:26:\"option-warning-light-trans\";s:2:\"on\";s:25:\"option-warning-main-trans\";s:2:\"on\";s:31:\"option-warning-ultra-dark-trans\";s:2:\"on\";s:16:\"option-white-btn\";s:2:\"on\";s:12:\"option-width\";s:2:\"on\";s:14:\"option-z-index\";s:2:\"on\";s:17:\"paragraph-spacing\";s:3:\"1em\";s:18:\"primary-card-style\";s:5:\"Light\";s:14:\"primary-comp-h\";i:193;s:18:\"primary-comp-h-alt\";i:193;s:14:\"primary-comp-l\";i:48;s:18:\"primary-comp-l-alt\";i:48;s:14:\"primary-comp-s\";i:59;s:18:\"primary-comp-s-alt\";i:59;s:14:\"primary-dark-h\";i:60;s:18:\"primary-dark-h-alt\";d:190;s:14:\"primary-dark-l\";s:2:\"25\";s:18:\"primary-dark-l-alt\";d:25;s:14:\"primary-dark-s\";i:35;s:18:\"primary-dark-s-alt\";d:30;s:15:\"primary-hover-h\";i:60;s:19:\"primary-hover-h-alt\";d:190;s:15:\"primary-hover-l\";i:100;s:19:\"primary-hover-l-alt\";d:57.49999999999999289457264239899814128875732421875;s:15:\"primary-hover-s\";i:35;s:19:\"primary-hover-s-alt\";d:30;s:15:\"primary-light-h\";i:60;s:19:\"primary-light-h-alt\";d:190;s:15:\"primary-light-l\";s:2:\"85\";s:19:\"primary-light-l-alt\";d:85;s:15:\"primary-light-s\";i:35;s:19:\"primary-light-s-alt\";d:30;s:16:\"primary-medium-h\";i:60;s:20:\"primary-medium-h-alt\";d:190;s:16:\"primary-medium-l\";s:2:\"50\";s:20:\"primary-medium-l-alt\";d:50;s:16:\"primary-medium-s\";i:35;s:20:\"primary-medium-s-alt\";d:30;s:24:\"primary-outline-btn-text\";s:24:\"var(--primary-semi-dark)\";s:29:\"primary-outline-dark-btn-text\";s:19:\"var(--primary-dark)\";s:31:\"primary-outline-dark-hover-text\";s:26:\"var(--primary-ultra-light)\";s:26:\"primary-outline-hover-text\";s:17:\"var(--text-light)\";s:30:\"primary-outline-light-btn-text\";s:20:\"var(--primary-light)\";s:32:\"primary-outline-light-hover-text\";s:19:\"var(--primary-dark)\";s:19:\"primary-semi-dark-h\";i:60;s:23:\"primary-semi-dark-h-alt\";d:190;s:19:\"primary-semi-dark-l\";s:2:\"35\";s:23:\"primary-semi-dark-l-alt\";i:35;s:19:\"primary-semi-dark-s\";i:35;s:23:\"primary-semi-dark-s-alt\";d:30;s:20:\"primary-semi-light-h\";i:60;s:24:\"primary-semi-light-h-alt\";d:190;s:20:\"primary-semi-light-l\";s:2:\"65\";s:24:\"primary-semi-light-l-alt\";i:65;s:20:\"primary-semi-light-s\";i:35;s:24:\"primary-semi-light-s-alt\";d:30;s:20:\"primary-ultra-dark-h\";i:60;s:24:\"primary-ultra-dark-h-alt\";d:190;s:20:\"primary-ultra-dark-l\";s:2:\"10\";s:24:\"primary-ultra-dark-l-alt\";d:10;s:20:\"primary-ultra-dark-s\";i:35;s:24:\"primary-ultra-dark-s-alt\";d:30;s:21:\"primary-ultra-light-h\";i:60;s:25:\"primary-ultra-light-h-alt\";d:190;s:21:\"primary-ultra-light-l\";s:2:\"95\";s:25:\"primary-ultra-light-l-alt\";d:95;s:21:\"primary-ultra-light-s\";i:35;s:25:\"primary-ultra-light-s-alt\";d:30;s:12:\"radius-scale\";s:3:\"1.5\";s:21:\"receive-beta-releases\";s:3:\"off\";s:14:\"root-font-size\";d:62.5;s:13:\"scroll-margin\";i:0;s:15:\"scroll-margin-l\";i:0;s:15:\"scroll-margin-m\";i:0;s:15:\"scroll-margin-s\";i:0;s:16:\"scroll-margin-xl\";i:0;s:16:\"scroll-margin-xs\";i:0;s:17:\"scroll-margin-xxl\";i:0;s:16:\"secondary-comp-h\";i:248;s:20:\"secondary-comp-h-alt\";i:248;s:16:\"secondary-comp-l\";i:14;s:20:\"secondary-comp-l-alt\";i:14;s:16:\"secondary-comp-s\";i:32;s:20:\"secondary-comp-s-alt\";i:32;s:16:\"secondary-dark-h\";d:248;s:20:\"secondary-dark-h-alt\";d:248;s:16:\"secondary-dark-l\";d:25;s:20:\"secondary-dark-l-alt\";d:25;s:16:\"secondary-dark-s\";d:32;s:20:\"secondary-dark-s-alt\";d:32;s:17:\"secondary-hover-h\";d:248;s:21:\"secondary-hover-h-alt\";d:248;s:17:\"secondary-hover-l\";d:16.099999999999997868371792719699442386627197265625;s:21:\"secondary-hover-l-alt\";d:16.099999999999997868371792719699442386627197265625;s:17:\"secondary-hover-s\";d:32;s:21:\"secondary-hover-s-alt\";d:32;s:17:\"secondary-light-h\";d:248;s:21:\"secondary-light-h-alt\";d:248;s:17:\"secondary-light-l\";d:85;s:21:\"secondary-light-l-alt\";d:85;s:17:\"secondary-light-s\";d:32;s:21:\"secondary-light-s-alt\";d:32;s:18:\"secondary-medium-h\";d:248;s:22:\"secondary-medium-h-alt\";d:248;s:18:\"secondary-medium-l\";d:50;s:22:\"secondary-medium-l-alt\";d:50;s:18:\"secondary-medium-s\";d:32;s:22:\"secondary-medium-s-alt\";d:32;s:26:\"secondary-outline-btn-text\";s:16:\"var(--secondary)\";s:31:\"secondary-outline-dark-btn-text\";s:21:\"var(--secondary-dark)\";s:33:\"secondary-outline-dark-hover-text\";s:28:\"var(--secondary-ultra-light)\";s:28:\"secondary-outline-hover-text\";s:28:\"var(--secondary-ultra-light)\";s:32:\"secondary-outline-light-btn-text\";s:22:\"var(--secondary-light)\";s:34:\"secondary-outline-light-hover-text\";s:21:\"var(--secondary-dark)\";s:21:\"secondary-semi-dark-h\";d:248;s:25:\"secondary-semi-dark-h-alt\";d:248;s:21:\"secondary-semi-dark-l\";i:35;s:25:\"secondary-semi-dark-l-alt\";i:35;s:21:\"secondary-semi-dark-s\";d:32;s:25:\"secondary-semi-dark-s-alt\";d:32;s:22:\"secondary-semi-light-h\";d:248;s:26:\"secondary-semi-light-h-alt\";d:248;s:22:\"secondary-semi-light-l\";i:65;s:26:\"secondary-semi-light-l-alt\";i:65;s:22:\"secondary-semi-light-s\";d:32;s:26:\"secondary-semi-light-s-alt\";d:32;s:22:\"secondary-ultra-dark-h\";d:248;s:26:\"secondary-ultra-dark-h-alt\";d:248;s:22:\"secondary-ultra-dark-l\";d:10;s:26:\"secondary-ultra-dark-l-alt\";d:10;s:22:\"secondary-ultra-dark-s\";d:32;s:26:\"secondary-ultra-dark-s-alt\";d:32;s:23:\"secondary-ultra-light-h\";d:248;s:27:\"secondary-ultra-light-h-alt\";d:248;s:23:\"secondary-ultra-light-l\";d:95;s:27:\"secondary-ultra-light-l-alt\";d:95;s:23:\"secondary-ultra-light-s\";d:32;s:27:\"secondary-ultra-light-s-alt\";d:32;s:21:\"section-padding-block\";s:22:\"var(--section-space-m)\";s:21:\"section-padding-x-max\";d:30;s:21:\"section-padding-x-min\";d:24;s:12:\"selection-bg\";s:13:\"var(--action)\";s:16:\"selection-bg-alt\";s:0:\"\";s:14:\"selection-text\";s:12:\"var(--white)\";s:18:\"selection-text-alt\";s:0:\"\";s:12:\"shade-comp-h\";i:0;s:16:\"shade-comp-h-alt\";i:0;s:12:\"shade-comp-l\";i:0;s:16:\"shade-comp-l-alt\";i:100;s:12:\"shade-comp-s\";i:0;s:16:\"shade-comp-s-alt\";i:0;s:12:\"shade-dark-h\";d:0;s:16:\"shade-dark-h-alt\";d:358;s:12:\"shade-dark-l\";d:25;s:16:\"shade-dark-l-alt\";d:75;s:12:\"shade-dark-s\";d:0;s:16:\"shade-dark-s-alt\";d:0;s:13:\"shade-hover-h\";d:0;s:17:\"shade-hover-h-alt\";d:358;s:13:\"shade-hover-l\";d:0;s:17:\"shade-hover-l-alt\";d:114.9999999999999857891452847979962825775146484375;s:13:\"shade-hover-s\";d:0;s:17:\"shade-hover-s-alt\";d:0;s:13:\"shade-light-h\";d:0;s:17:\"shade-light-h-alt\";d:358;s:13:\"shade-light-l\";d:85;s:17:\"shade-light-l-alt\";d:15;s:13:\"shade-light-s\";d:0;s:17:\"shade-light-s-alt\";d:0;s:14:\"shade-medium-h\";d:0;s:18:\"shade-medium-h-alt\";d:358;s:14:\"shade-medium-l\";d:50;s:18:\"shade-medium-l-alt\";d:50;s:14:\"shade-medium-s\";d:0;s:18:\"shade-medium-s-alt\";d:0;s:22:\"shade-outline-btn-text\";s:12:\"var(--shade)\";s:24:\"shade-outline-hover-text\";s:24:\"var(--shade-ultra-light)\";s:17:\"shade-semi-dark-h\";d:0;s:21:\"shade-semi-dark-h-alt\";d:0;s:17:\"shade-semi-dark-l\";i:35;s:21:\"shade-semi-dark-l-alt\";i:35;s:17:\"shade-semi-dark-s\";d:0;s:21:\"shade-semi-dark-s-alt\";d:0;s:18:\"shade-semi-light-h\";d:0;s:22:\"shade-semi-light-h-alt\";d:0;s:18:\"shade-semi-light-l\";i:65;s:22:\"shade-semi-light-l-alt\";i:65;s:18:\"shade-semi-light-s\";d:0;s:22:\"shade-semi-light-s-alt\";d:0;s:18:\"shade-ultra-dark-h\";d:0;s:22:\"shade-ultra-dark-h-alt\";d:358;s:18:\"shade-ultra-dark-l\";d:10;s:22:\"shade-ultra-dark-l-alt\";d:90;s:18:\"shade-ultra-dark-s\";d:0;s:22:\"shade-ultra-dark-s-alt\";d:0;s:19:\"shade-ultra-light-h\";d:0;s:23:\"shade-ultra-light-h-alt\";d:358;s:19:\"shade-ultra-light-l\";d:95;s:23:\"shade-ultra-light-l-alt\";d:5;s:19:\"shade-ultra-light-s\";d:0;s:23:\"shade-ultra-light-s-alt\";d:0;s:39:\"smart-spacing-duplicate-margin-elements\";s:33:\"\":is(figure, blockquote, ul, ol)\"\";s:23:\"smart-spacing-selectors\";s:0:\"\";s:20:\"space-adjust-section\";d:4;s:11:\"space-scale\";d:1.5;s:12:\"sticky-top-l\";s:3:\"10%\";s:12:\"sticky-top-m\";s:2:\"5%\";s:12:\"sticky-top-s\";s:4:\"2.5%\";s:14:\"success-comp-h\";i:133;s:18:\"success-comp-h-alt\";i:133;s:14:\"success-comp-l\";i:41;s:18:\"success-comp-l-alt\";i:41;s:14:\"success-comp-s\";i:61;s:18:\"success-comp-s-alt\";i:61;s:14:\"success-dark-h\";d:133;s:18:\"success-dark-h-alt\";d:133;s:14:\"success-dark-l\";d:15;s:18:\"success-dark-l-alt\";d:15;s:14:\"success-dark-s\";d:61;s:18:\"success-dark-s-alt\";d:61;s:15:\"success-hover-h\";d:133;s:19:\"success-hover-h-alt\";d:133;s:15:\"success-hover-l\";d:47.14999999999999857891452847979962825775146484375;s:19:\"success-hover-l-alt\";d:47.14999999999999857891452847979962825775146484375;s:15:\"success-hover-s\";d:61;s:19:\"success-hover-s-alt\";d:61;s:15:\"success-light-h\";d:133;s:19:\"success-light-h-alt\";d:133;s:15:\"success-light-l\";d:85;s:19:\"success-light-l-alt\";d:85;s:15:\"success-light-s\";d:61;s:19:\"success-light-s-alt\";d:61;s:16:\"success-medium-h\";i:133;s:20:\"success-medium-h-alt\";i:133;s:16:\"success-medium-l\";i:50;s:20:\"success-medium-l-alt\";i:50;s:16:\"success-medium-s\";i:61;s:20:\"success-medium-s-alt\";i:61;s:24:\"success-outline-btn-text\";s:14:\"var(--success)\";s:29:\"success-outline-dark-btn-text\";s:19:\"var(--success-dark)\";s:31:\"success-outline-dark-hover-text\";s:26:\"var(--success-ultra-light)\";s:26:\"success-outline-hover-text\";s:26:\"var(--success-ultra-light)\";s:30:\"success-outline-light-btn-text\";s:20:\"var(--success-light)\";s:32:\"success-outline-light-hover-text\";s:19:\"var(--success-dark)\";s:19:\"success-semi-dark-h\";d:133;s:23:\"success-semi-dark-h-alt\";d:133;s:19:\"success-semi-dark-l\";i:35;s:23:\"success-semi-dark-l-alt\";i:35;s:19:\"success-semi-dark-s\";d:61;s:23:\"success-semi-dark-s-alt\";d:61;s:20:\"success-semi-light-h\";d:133;s:24:\"success-semi-light-h-alt\";d:133;s:20:\"success-semi-light-l\";i:65;s:24:\"success-semi-light-l-alt\";i:65;s:20:\"success-semi-light-s\";d:61;s:24:\"success-semi-light-s-alt\";d:61;s:20:\"success-ultra-dark-h\";i:133;s:24:\"success-ultra-dark-h-alt\";i:133;s:20:\"success-ultra-dark-l\";i:10;s:24:\"success-ultra-dark-l-alt\";i:10;s:20:\"success-ultra-dark-s\";i:61;s:24:\"success-ultra-dark-s-alt\";i:61;s:21:\"success-ultra-light-h\";i:133;s:25:\"success-ultra-light-h-alt\";i:133;s:21:\"success-ultra-light-l\";i:95;s:25:\"success-ultra-light-l-alt\";i:95;s:21:\"success-ultra-light-s\";i:61;s:25:\"success-ultra-light-s-alt\";i:61;s:15:\"tertiary-comp-h\";i:43;s:19:\"tertiary-comp-h-alt\";i:45;s:15:\"tertiary-comp-l\";i:44;s:19:\"tertiary-comp-l-alt\";i:20;s:15:\"tertiary-comp-s\";i:19;s:19:\"tertiary-comp-s-alt\";i:20;s:15:\"tertiary-dark-h\";i:43;s:19:\"tertiary-dark-h-alt\";i:45;s:15:\"tertiary-dark-l\";i:25;s:19:\"tertiary-dark-l-alt\";i:25;s:15:\"tertiary-dark-s\";i:19;s:19:\"tertiary-dark-s-alt\";i:20;s:16:\"tertiary-hover-h\";i:43;s:20:\"tertiary-hover-h-alt\";i:45;s:16:\"tertiary-hover-l\";d:50.599999999999994315658113919198513031005859375;s:20:\"tertiary-hover-l-alt\";d:23;s:16:\"tertiary-hover-s\";i:19;s:20:\"tertiary-hover-s-alt\";i:20;s:16:\"tertiary-light-h\";i:43;s:20:\"tertiary-light-h-alt\";i:45;s:16:\"tertiary-light-l\";i:85;s:20:\"tertiary-light-l-alt\";i:85;s:16:\"tertiary-light-s\";i:19;s:20:\"tertiary-light-s-alt\";i:20;s:17:\"tertiary-medium-h\";i:43;s:21:\"tertiary-medium-h-alt\";i:45;s:17:\"tertiary-medium-l\";i:50;s:21:\"tertiary-medium-l-alt\";i:50;s:17:\"tertiary-medium-s\";i:19;s:21:\"tertiary-medium-s-alt\";i:20;s:25:\"tertiary-outline-btn-text\";s:15:\"var(--tertiary)\";s:30:\"tertiary-outline-dark-btn-text\";s:20:\"var(--tertiary-dark)\";s:32:\"tertiary-outline-dark-hover-text\";s:27:\"var(--tertiary-ultra-light)\";s:27:\"tertiary-outline-hover-text\";s:27:\"var(--tertiary-ultra-light)\";s:31:\"tertiary-outline-light-btn-text\";s:21:\"var(--tertiary-light)\";s:33:\"tertiary-outline-light-hover-text\";s:20:\"var(--tertiary-dark)\";s:20:\"tertiary-semi-dark-h\";i:43;s:24:\"tertiary-semi-dark-h-alt\";i:45;s:20:\"tertiary-semi-dark-l\";i:35;s:24:\"tertiary-semi-dark-l-alt\";i:35;s:20:\"tertiary-semi-dark-s\";i:19;s:24:\"tertiary-semi-dark-s-alt\";i:20;s:21:\"tertiary-semi-light-h\";i:43;s:25:\"tertiary-semi-light-h-alt\";i:45;s:21:\"tertiary-semi-light-l\";i:65;s:25:\"tertiary-semi-light-l-alt\";i:65;s:21:\"tertiary-semi-light-s\";i:19;s:25:\"tertiary-semi-light-s-alt\";i:20;s:21:\"tertiary-ultra-dark-h\";i:43;s:25:\"tertiary-ultra-dark-h-alt\";i:45;s:21:\"tertiary-ultra-dark-l\";i:10;s:25:\"tertiary-ultra-dark-l-alt\";i:10;s:21:\"tertiary-ultra-dark-s\";i:19;s:25:\"tertiary-ultra-dark-s-alt\";i:20;s:22:\"tertiary-ultra-light-h\";i:43;s:26:\"tertiary-ultra-light-h-alt\";i:45;s:22:\"tertiary-ultra-light-l\";i:95;s:26:\"tertiary-ultra-light-l-alt\";i:95;s:22:\"tertiary-ultra-light-s\";i:19;s:26:\"tertiary-ultra-light-s-alt\";i:20;s:9:\"text-dark\";s:12:\"var(--black)\";s:15:\"text-dark-muted\";s:19:\"var(--neutral-dark)\";s:16:\"text-font-family\";s:0:\"\";s:15:\"text-font-style\";s:0:\"\";s:16:\"text-font-weight\";s:0:\"\";s:17:\"text-l-font-style\";s:0:\"\";s:18:\"text-l-font-weight\";s:0:\"\";s:21:\"text-l-letter-spacing\";s:0:\"\";s:18:\"text-l-line-height\";s:3:\"1.2\";s:10:\"text-l-max\";s:0:\"\";s:16:\"text-l-max-width\";s:0:\"\";s:10:\"text-l-min\";s:0:\"\";s:21:\"text-l-text-transform\";s:0:\"\";s:19:\"text-letter-spacing\";s:0:\"\";s:10:\"text-light\";s:12:\"var(--white)\";s:16:\"text-light-muted\";s:20:\"var(--neutral-light)\";s:17:\"text-m-font-style\";s:0:\"\";s:18:\"text-m-font-weight\";s:0:\"\";s:21:\"text-m-letter-spacing\";s:0:\"\";s:10:\"text-m-max\";s:0:\"\";s:16:\"text-m-max-width\";s:4:\"100%\";s:10:\"text-m-min\";s:0:\"\";s:21:\"text-m-text-transform\";s:0:\"\";s:14:\"text-max-width\";s:0:\"\";s:15:\"text-multiplier\";d:1.5;s:19:\"text-multiplier-min\";d:1.1999999999999999555910790149937383830547332763671875;s:17:\"text-s-font-style\";s:0:\"\";s:18:\"text-s-font-weight\";s:0:\"\";s:21:\"text-s-letter-spacing\";s:0:\"\";s:18:\"text-s-line-height\";d:1.5;s:10:\"text-s-max\";d:12;s:16:\"text-s-max-width\";s:0:\"\";s:10:\"text-s-min\";d:12;s:21:\"text-s-text-transform\";s:0:\"\";s:10:\"text-scale\";d:1.3329999999999999626965063725947402417659759521484375;s:14:\"text-transform\";s:0:\"\";s:9:\"text-wrap\";s:6:\"pretty\";s:18:\"text-xl-font-style\";s:0:\"\";s:19:\"text-xl-font-weight\";s:0:\"\";s:22:\"text-xl-letter-spacing\";s:0:\"\";s:19:\"text-xl-line-height\";d:1.5;s:11:\"text-xl-max\";s:0:\"\";s:17:\"text-xl-max-width\";s:0:\"\";s:11:\"text-xl-min\";s:0:\"\";s:22:\"text-xl-text-transform\";s:0:\"\";s:18:\"text-xs-font-style\";s:0:\"\";s:19:\"text-xs-font-weight\";s:0:\"\";s:22:\"text-xs-letter-spacing\";s:0:\"\";s:19:\"text-xs-line-height\";d:1.5;s:11:\"text-xs-max\";d:11;s:17:\"text-xs-max-width\";s:0:\"\";s:11:\"text-xs-min\";d:11;s:22:\"text-xs-text-transform\";s:0:\"\";s:19:\"text-xxl-font-style\";s:0:\"\";s:20:\"text-xxl-font-weight\";s:0:\"\";s:23:\"text-xxl-letter-spacing\";s:0:\"\";s:20:\"text-xxl-line-height\";d:1.5;s:12:\"text-xxl-max\";s:0:\"\";s:18:\"text-xxl-max-width\";s:0:\"\";s:12:\"text-xxl-min\";s:0:\"\";s:23:\"text-xxl-text-transform\";s:0:\"\";s:25:\"texture-1-animate-overlay\";s:3:\"off\";s:25:\"texture-1-animate-texture\";s:3:\"off\";s:19:\"texture-1-animation\";s:0:\"\";s:15:\"texture-1-asset\";s:0:\"\";s:22:\"texture-1-asset-is-url\";s:2:\"on\";s:20:\"texture-1-attachment\";s:6:\"scroll\";s:18:\"texture-1-bg-color\";s:20:\"var(--body-bg-color)\";s:20:\"texture-1-blend-mode\";s:6:\"normal\";s:28:\"texture-1-color-relationship\";s:4:\"none\";s:14:\"texture-1-name\";s:1:\"1\";s:17:\"texture-1-overlay\";s:0:\"\";s:25:\"texture-1-overlay-opacity\";s:2:\".8\";s:24:\"texture-1-overlay-option\";s:3:\"off\";s:25:\"texture-1-overlay-overlay\";s:0:\"\";s:18:\"texture-1-position\";s:13:\"center center\";s:16:\"texture-1-repeat\";s:6:\"repeat\";s:14:\"texture-1-size\";s:5:\"200px\";s:25:\"texture-2-animate-overlay\";s:3:\"off\";s:25:\"texture-2-animate-texture\";s:3:\"off\";s:19:\"texture-2-animation\";s:0:\"\";s:15:\"texture-2-asset\";s:0:\"\";s:22:\"texture-2-asset-is-url\";s:2:\"on\";s:20:\"texture-2-attachment\";s:6:\"scroll\";s:18:\"texture-2-bg-color\";s:20:\"var(--body-bg-color)\";s:20:\"texture-2-blend-mode\";s:6:\"normal\";s:28:\"texture-2-color-relationship\";s:4:\"none\";s:14:\"texture-2-name\";s:1:\"2\";s:17:\"texture-2-overlay\";s:0:\"\";s:25:\"texture-2-overlay-opacity\";s:2:\".8\";s:24:\"texture-2-overlay-option\";s:3:\"off\";s:25:\"texture-2-overlay-overlay\";s:0:\"\";s:18:\"texture-2-position\";s:13:\"center center\";s:16:\"texture-2-repeat\";s:6:\"repeat\";s:14:\"texture-2-size\";s:5:\"200px\";s:25:\"texture-3-animate-overlay\";s:3:\"off\";s:25:\"texture-3-animate-texture\";s:3:\"off\";s:19:\"texture-3-animation\";s:0:\"\";s:15:\"texture-3-asset\";s:0:\"\";s:22:\"texture-3-asset-is-url\";s:2:\"on\";s:20:\"texture-3-attachment\";s:6:\"scroll\";s:18:\"texture-3-bg-color\";s:20:\"var(--body-bg-color)\";s:20:\"texture-3-blend-mode\";s:6:\"normal\";s:28:\"texture-3-color-relationship\";s:4:\"none\";s:14:\"texture-3-name\";s:1:\"3\";s:17:\"texture-3-overlay\";s:0:\"\";s:25:\"texture-3-overlay-opacity\";s:2:\".8\";s:24:\"texture-3-overlay-option\";s:3:\"off\";s:25:\"texture-3-overlay-overlay\";s:0:\"\";s:18:\"texture-3-position\";s:13:\"center center\";s:16:\"texture-3-repeat\";s:6:\"repeat\";s:14:\"texture-3-size\";s:5:\"200px\";s:25:\"texture-4-animate-overlay\";s:3:\"off\";s:25:\"texture-4-animate-texture\";s:3:\"off\";s:19:\"texture-4-animation\";s:0:\"\";s:15:\"texture-4-asset\";s:0:\"\";s:22:\"texture-4-asset-is-url\";s:2:\"on\";s:20:\"texture-4-attachment\";s:6:\"scroll\";s:18:\"texture-4-bg-color\";s:20:\"var(--body-bg-color)\";s:20:\"texture-4-blend-mode\";s:6:\"normal\";s:28:\"texture-4-color-relationship\";s:4:\"none\";s:14:\"texture-4-name\";s:1:\"4\";s:17:\"texture-4-overlay\";s:0:\"\";s:25:\"texture-4-overlay-opacity\";s:2:\".8\";s:24:\"texture-4-overlay-option\";s:3:\"off\";s:25:\"texture-4-overlay-overlay\";s:0:\"\";s:18:\"texture-4-position\";s:13:\"center center\";s:16:\"texture-4-repeat\";s:6:\"repeat\";s:14:\"texture-4-size\";s:5:\"200px\";s:25:\"texture-5-animate-overlay\";s:3:\"off\";s:25:\"texture-5-animate-texture\";s:3:\"off\";s:19:\"texture-5-animation\";s:0:\"\";s:15:\"texture-5-asset\";s:0:\"\";s:22:\"texture-5-asset-is-url\";s:2:\"on\";s:20:\"texture-5-attachment\";s:6:\"scroll\";s:18:\"texture-5-bg-color\";s:20:\"var(--body-bg-color)\";s:20:\"texture-5-blend-mode\";s:6:\"normal\";s:28:\"texture-5-color-relationship\";s:4:\"none\";s:14:\"texture-5-name\";s:1:\"5\";s:17:\"texture-5-overlay\";s:0:\"\";s:25:\"texture-5-overlay-opacity\";s:2:\".8\";s:24:\"texture-5-overlay-option\";s:3:\"off\";s:25:\"texture-5-overlay-overlay\";s:0:\"\";s:18:\"texture-5-position\";s:13:\"center center\";s:16:\"texture-5-repeat\";s:6:\"repeat\";s:14:\"texture-5-size\";s:5:\"200px\";s:9:\"timestamp\";i:1769719792;s:16:\"transition-delay\";s:2:\"0s\";s:19:\"transition-duration\";s:4:\"0.3s\";s:17:\"transition-global\";s:253:\"background var(--transition-duration) var(--transition-timing) var(--transition-delay), color var(--transition-duration) var(--transition-timing) var(--transition-delay), border var(--transition-duration) var(--transition-timing) var(--transition-delay)\";s:17:\"transition-timing\";s:11:\"ease-in-out\";s:6:\"vp-max\";i:1280;s:6:\"vp-min\";i:320;s:14:\"warning-comp-h\";i:45;s:18:\"warning-comp-h-alt\";i:45;s:14:\"warning-comp-l\";i:52;s:18:\"warning-comp-l-alt\";i:52;s:14:\"warning-comp-s\";i:100;s:18:\"warning-comp-s-alt\";i:100;s:14:\"warning-dark-h\";d:45;s:18:\"warning-dark-h-alt\";d:45;s:14:\"warning-dark-l\";d:15;s:18:\"warning-dark-l-alt\";d:15;s:14:\"warning-dark-s\";d:100;s:18:\"warning-dark-s-alt\";d:100;s:15:\"warning-hover-h\";d:45;s:19:\"warning-hover-h-alt\";d:45;s:15:\"warning-hover-l\";d:59.7999999999999971578290569595992565155029296875;s:19:\"warning-hover-l-alt\";d:59.7999999999999971578290569595992565155029296875;s:15:\"warning-hover-s\";d:100;s:19:\"warning-hover-s-alt\";d:100;s:15:\"warning-light-h\";d:45;s:19:\"warning-light-h-alt\";d:45;s:15:\"warning-light-l\";d:85;s:19:\"warning-light-l-alt\";d:85;s:15:\"warning-light-s\";d:100;s:19:\"warning-light-s-alt\";d:100;s:16:\"warning-medium-h\";i:45;s:20:\"warning-medium-h-alt\";i:45;s:16:\"warning-medium-l\";i:50;s:20:\"warning-medium-l-alt\";i:50;s:16:\"warning-medium-s\";i:100;s:20:\"warning-medium-s-alt\";i:100;s:24:\"warning-outline-btn-text\";s:14:\"var(--warning)\";s:29:\"warning-outline-dark-btn-text\";s:19:\"var(--warning-dark)\";s:31:\"warning-outline-dark-hover-text\";s:26:\"var(--warning-ultra-light)\";s:26:\"warning-outline-hover-text\";s:26:\"var(--warning-ultra-light)\";s:30:\"warning-outline-light-btn-text\";s:20:\"var(--warning-light)\";s:32:\"warning-outline-light-hover-text\";s:19:\"var(--warning-dark)\";s:19:\"warning-semi-dark-h\";d:45;s:23:\"warning-semi-dark-h-alt\";d:45;s:19:\"warning-semi-dark-l\";i:35;s:23:\"warning-semi-dark-l-alt\";i:35;s:19:\"warning-semi-dark-s\";d:100;s:23:\"warning-semi-dark-s-alt\";d:100;s:20:\"warning-semi-light-h\";d:45;s:24:\"warning-semi-light-h-alt\";d:45;s:20:\"warning-semi-light-l\";i:65;s:24:\"warning-semi-light-l-alt\";i:65;s:20:\"warning-semi-light-s\";d:100;s:24:\"warning-semi-light-s-alt\";d:100;s:20:\"warning-ultra-dark-h\";i:45;s:24:\"warning-ultra-dark-h-alt\";i:45;s:20:\"warning-ultra-dark-l\";i:10;s:24:\"warning-ultra-dark-l-alt\";i:10;s:20:\"warning-ultra-dark-s\";i:100;s:24:\"warning-ultra-dark-s-alt\";i:100;s:21:\"warning-ultra-light-h\";i:45;s:25:\"warning-ultra-light-h-alt\";i:45;s:21:\"warning-ultra-light-l\";i:95;s:25:\"warning-ultra-light-l-alt\";i:95;s:21:\"warning-ultra-light-s\";i:100;s:25:\"warning-ultra-light-s-alt\";i:100;s:20:\"website-color-scheme\";s:5:\"light\";s:22:\"white-outline-btn-text\";s:12:\"var(--white)\";s:24:\"white-outline-hover-text\";s:16:\"var(--text-dark)\";s:19:\"wp-page-block-width\";s:4:\"100%\";s:19:\"wp-post-block-width\";s:5:\"767px\";s:18:\"wp-post-types-list\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("199", "bricks_global_classes_categories", "a:1:{i:0;a:2:{s:2:\"id\";s:4:\"acss\";s:4:\"name\";s:13:\"Automatic.css\";}}", "yes");
INSERT INTO `wp_options` VALUES("200", "bricks_global_classes", "a:3494:{i:0;a:4:{s:2:\"id\";s:19:\"acss_import_grid--1\";s:4:\"name\";s:7:\"grid--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1;a:4:{s:2:\"id\";s:21:\"acss_import_grid--s-1\";s:4:\"name\";s:9:\"grid--s-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2;a:4:{s:2:\"id\";s:21:\"acss_import_grid--m-1\";s:4:\"name\";s:9:\"grid--m-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3;a:4:{s:2:\"id\";s:21:\"acss_import_grid--l-1\";s:4:\"name\";s:9:\"grid--l-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:4;a:4:{s:2:\"id\";s:22:\"acss_import_grid--xl-1\";s:4:\"name\";s:10:\"grid--xl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:5;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xxl-1\";s:4:\"name\";s:11:\"grid--xxl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:6;a:4:{s:2:\"id\";s:19:\"acss_import_grid--2\";s:4:\"name\";s:7:\"grid--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:7;a:4:{s:2:\"id\";s:21:\"acss_import_grid--s-2\";s:4:\"name\";s:9:\"grid--s-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:8;a:4:{s:2:\"id\";s:21:\"acss_import_grid--m-2\";s:4:\"name\";s:9:\"grid--m-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:9;a:4:{s:2:\"id\";s:21:\"acss_import_grid--l-2\";s:4:\"name\";s:9:\"grid--l-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:10;a:4:{s:2:\"id\";s:22:\"acss_import_grid--xl-2\";s:4:\"name\";s:10:\"grid--xl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:11;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xxl-2\";s:4:\"name\";s:11:\"grid--xxl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:12;a:4:{s:2:\"id\";s:19:\"acss_import_grid--3\";s:4:\"name\";s:7:\"grid--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:13;a:4:{s:2:\"id\";s:21:\"acss_import_grid--s-3\";s:4:\"name\";s:9:\"grid--s-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:14;a:4:{s:2:\"id\";s:21:\"acss_import_grid--m-3\";s:4:\"name\";s:9:\"grid--m-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:15;a:4:{s:2:\"id\";s:21:\"acss_import_grid--l-3\";s:4:\"name\";s:9:\"grid--l-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:16;a:4:{s:2:\"id\";s:22:\"acss_import_grid--xl-3\";s:4:\"name\";s:10:\"grid--xl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:17;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xxl-3\";s:4:\"name\";s:11:\"grid--xxl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:18;a:4:{s:2:\"id\";s:19:\"acss_import_grid--4\";s:4:\"name\";s:7:\"grid--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:19;a:4:{s:2:\"id\";s:21:\"acss_import_grid--s-4\";s:4:\"name\";s:9:\"grid--s-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:20;a:4:{s:2:\"id\";s:21:\"acss_import_grid--m-4\";s:4:\"name\";s:9:\"grid--m-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:21;a:4:{s:2:\"id\";s:21:\"acss_import_grid--l-4\";s:4:\"name\";s:9:\"grid--l-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:22;a:4:{s:2:\"id\";s:22:\"acss_import_grid--xl-4\";s:4:\"name\";s:10:\"grid--xl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:23;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xxl-4\";s:4:\"name\";s:11:\"grid--xxl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:24;a:4:{s:2:\"id\";s:19:\"acss_import_grid--5\";s:4:\"name\";s:7:\"grid--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:25;a:4:{s:2:\"id\";s:21:\"acss_import_grid--s-5\";s:4:\"name\";s:9:\"grid--s-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:26;a:4:{s:2:\"id\";s:21:\"acss_import_grid--m-5\";s:4:\"name\";s:9:\"grid--m-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:27;a:4:{s:2:\"id\";s:21:\"acss_import_grid--l-5\";s:4:\"name\";s:9:\"grid--l-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:28;a:4:{s:2:\"id\";s:22:\"acss_import_grid--xl-5\";s:4:\"name\";s:10:\"grid--xl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:29;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xxl-5\";s:4:\"name\";s:11:\"grid--xxl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:30;a:4:{s:2:\"id\";s:19:\"acss_import_grid--6\";s:4:\"name\";s:7:\"grid--6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:31;a:4:{s:2:\"id\";s:21:\"acss_import_grid--s-6\";s:4:\"name\";s:9:\"grid--s-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:32;a:4:{s:2:\"id\";s:21:\"acss_import_grid--m-6\";s:4:\"name\";s:9:\"grid--m-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:33;a:4:{s:2:\"id\";s:21:\"acss_import_grid--l-6\";s:4:\"name\";s:9:\"grid--l-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:34;a:4:{s:2:\"id\";s:22:\"acss_import_grid--xl-6\";s:4:\"name\";s:10:\"grid--xl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:35;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xxl-6\";s:4:\"name\";s:11:\"grid--xxl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:36;a:4:{s:2:\"id\";s:19:\"acss_import_grid--7\";s:4:\"name\";s:7:\"grid--7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:37;a:4:{s:2:\"id\";s:21:\"acss_import_grid--s-7\";s:4:\"name\";s:9:\"grid--s-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:38;a:4:{s:2:\"id\";s:21:\"acss_import_grid--m-7\";s:4:\"name\";s:9:\"grid--m-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:39;a:4:{s:2:\"id\";s:21:\"acss_import_grid--l-7\";s:4:\"name\";s:9:\"grid--l-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:40;a:4:{s:2:\"id\";s:22:\"acss_import_grid--xl-7\";s:4:\"name\";s:10:\"grid--xl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:41;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xxl-7\";s:4:\"name\";s:11:\"grid--xxl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:42;a:4:{s:2:\"id\";s:19:\"acss_import_grid--8\";s:4:\"name\";s:7:\"grid--8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:43;a:4:{s:2:\"id\";s:21:\"acss_import_grid--s-8\";s:4:\"name\";s:9:\"grid--s-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:44;a:4:{s:2:\"id\";s:21:\"acss_import_grid--m-8\";s:4:\"name\";s:9:\"grid--m-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:45;a:4:{s:2:\"id\";s:21:\"acss_import_grid--l-8\";s:4:\"name\";s:9:\"grid--l-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:46;a:4:{s:2:\"id\";s:22:\"acss_import_grid--xl-8\";s:4:\"name\";s:10:\"grid--xl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:47;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xxl-8\";s:4:\"name\";s:11:\"grid--xxl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:48;a:4:{s:2:\"id\";s:19:\"acss_import_grid--9\";s:4:\"name\";s:7:\"grid--9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:49;a:4:{s:2:\"id\";s:21:\"acss_import_grid--s-9\";s:4:\"name\";s:9:\"grid--s-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:50;a:4:{s:2:\"id\";s:21:\"acss_import_grid--m-9\";s:4:\"name\";s:9:\"grid--m-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:51;a:4:{s:2:\"id\";s:21:\"acss_import_grid--l-9\";s:4:\"name\";s:9:\"grid--l-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:52;a:4:{s:2:\"id\";s:22:\"acss_import_grid--xl-9\";s:4:\"name\";s:10:\"grid--xl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:53;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xxl-9\";s:4:\"name\";s:11:\"grid--xxl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:54;a:4:{s:2:\"id\";s:20:\"acss_import_grid--10\";s:4:\"name\";s:8:\"grid--10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:55;a:4:{s:2:\"id\";s:22:\"acss_import_grid--s-10\";s:4:\"name\";s:10:\"grid--s-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:56;a:4:{s:2:\"id\";s:22:\"acss_import_grid--m-10\";s:4:\"name\";s:10:\"grid--m-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:57;a:4:{s:2:\"id\";s:22:\"acss_import_grid--l-10\";s:4:\"name\";s:10:\"grid--l-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:58;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xl-10\";s:4:\"name\";s:11:\"grid--xl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:59;a:4:{s:2:\"id\";s:24:\"acss_import_grid--xxl-10\";s:4:\"name\";s:12:\"grid--xxl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:60;a:4:{s:2:\"id\";s:20:\"acss_import_grid--11\";s:4:\"name\";s:8:\"grid--11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:61;a:4:{s:2:\"id\";s:22:\"acss_import_grid--s-11\";s:4:\"name\";s:10:\"grid--s-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:62;a:4:{s:2:\"id\";s:22:\"acss_import_grid--m-11\";s:4:\"name\";s:10:\"grid--m-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:63;a:4:{s:2:\"id\";s:22:\"acss_import_grid--l-11\";s:4:\"name\";s:10:\"grid--l-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:64;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xl-11\";s:4:\"name\";s:11:\"grid--xl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:65;a:4:{s:2:\"id\";s:24:\"acss_import_grid--xxl-11\";s:4:\"name\";s:12:\"grid--xxl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:66;a:4:{s:2:\"id\";s:20:\"acss_import_grid--12\";s:4:\"name\";s:8:\"grid--12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:67;a:4:{s:2:\"id\";s:22:\"acss_import_grid--s-12\";s:4:\"name\";s:10:\"grid--s-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:68;a:4:{s:2:\"id\";s:22:\"acss_import_grid--m-12\";s:4:\"name\";s:10:\"grid--m-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:69;a:4:{s:2:\"id\";s:22:\"acss_import_grid--l-12\";s:4:\"name\";s:10:\"grid--l-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:70;a:4:{s:2:\"id\";s:23:\"acss_import_grid--xl-12\";s:4:\"name\";s:11:\"grid--xl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:71;a:4:{s:2:\"id\";s:24:\"acss_import_grid--xxl-12\";s:4:\"name\";s:12:\"grid--xxl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:72;a:4:{s:2:\"id\";s:21:\"acss_import_grid--1-2\";s:4:\"name\";s:9:\"grid--1-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:73;a:4:{s:2:\"id\";s:21:\"acss_import_grid--1-3\";s:4:\"name\";s:9:\"grid--1-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:74;a:4:{s:2:\"id\";s:21:\"acss_import_grid--2-1\";s:4:\"name\";s:9:\"grid--2-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:75;a:4:{s:2:\"id\";s:21:\"acss_import_grid--2-3\";s:4:\"name\";s:9:\"grid--2-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:76;a:4:{s:2:\"id\";s:21:\"acss_import_grid--3-1\";s:4:\"name\";s:9:\"grid--3-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:77;a:4:{s:2:\"id\";s:21:\"acss_import_grid--3-2\";s:4:\"name\";s:9:\"grid--3-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:78;a:4:{s:2:\"id\";s:24:\"acss_import_grid--auto-2\";s:4:\"name\";s:12:\"grid--auto-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:79;a:4:{s:2:\"id\";s:24:\"acss_import_grid--auto-3\";s:4:\"name\";s:12:\"grid--auto-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:80;a:4:{s:2:\"id\";s:24:\"acss_import_grid--auto-4\";s:4:\"name\";s:12:\"grid--auto-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:81;a:4:{s:2:\"id\";s:24:\"acss_import_grid--auto-5\";s:4:\"name\";s:12:\"grid--auto-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:82;a:4:{s:2:\"id\";s:24:\"acss_import_grid--auto-6\";s:4:\"name\";s:12:\"grid--auto-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:83;a:4:{s:2:\"id\";s:26:\"acss_import_grid--auto-1-2\";s:4:\"name\";s:14:\"grid--auto-1-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:84;a:4:{s:2:\"id\";s:26:\"acss_import_grid--auto-1-3\";s:4:\"name\";s:14:\"grid--auto-1-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:85;a:4:{s:2:\"id\";s:26:\"acss_import_grid--auto-2-1\";s:4:\"name\";s:14:\"grid--auto-2-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:86;a:4:{s:2:\"id\";s:26:\"acss_import_grid--auto-2-3\";s:4:\"name\";s:14:\"grid--auto-2-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:87;a:4:{s:2:\"id\";s:26:\"acss_import_grid--auto-3-1\";s:4:\"name\";s:14:\"grid--auto-3-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:88;a:4:{s:2:\"id\";s:26:\"acss_import_grid--auto-3-2\";s:4:\"name\";s:14:\"grid--auto-3-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:89;a:4:{s:2:\"id\";s:27:\"acss_import_grid--auto-rows\";s:4:\"name\";s:15:\"grid--auto-rows\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:90;a:4:{s:2:\"id\";s:29:\"acss_import_grid--alternate-s\";s:4:\"name\";s:17:\"grid--alternate-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:91;a:4:{s:2:\"id\";s:29:\"acss_import_grid--alternate-m\";s:4:\"name\";s:17:\"grid--alternate-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:92;a:4:{s:2:\"id\";s:29:\"acss_import_grid--alternate-l\";s:4:\"name\";s:17:\"grid--alternate-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:93;a:4:{s:2:\"id\";s:30:\"acss_import_grid--alternate-xl\";s:4:\"name\";s:18:\"grid--alternate-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:94;a:4:{s:2:\"id\";s:25:\"acss_import_variable-grid\";s:4:\"name\";s:13:\"variable-grid\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:95;a:4:{s:2:\"id\";s:24:\"acss_import_content-grid\";s:4:\"name\";s:12:\"content-grid\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:96;a:4:{s:2:\"id\";s:28:\"acss_import_content--feature\";s:4:\"name\";s:16:\"content--feature\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:97;a:4:{s:2:\"id\";s:32:\"acss_import_content--feature-max\";s:4:\"name\";s:20:\"content--feature-max\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:98;a:4:{s:2:\"id\";s:25:\"acss_import_content--full\";s:4:\"name\";s:13:\"content--full\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:99;a:4:{s:2:\"id\";s:30:\"acss_import_content--full-safe\";s:4:\"name\";s:18:\"content--full-safe\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:100;a:4:{s:2:\"id\";s:24:\"acss_import_col-start--1\";s:4:\"name\";s:12:\"col-start--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:101;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--s-1\";s:4:\"name\";s:14:\"col-start--s-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:102;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--m-1\";s:4:\"name\";s:14:\"col-start--m-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:103;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--l-1\";s:4:\"name\";s:14:\"col-start--l-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:104;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--xl-1\";s:4:\"name\";s:15:\"col-start--xl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:105;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xxl-1\";s:4:\"name\";s:16:\"col-start--xxl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:106;a:4:{s:2:\"id\";s:24:\"acss_import_col-start--2\";s:4:\"name\";s:12:\"col-start--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:107;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--s-2\";s:4:\"name\";s:14:\"col-start--s-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:108;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--m-2\";s:4:\"name\";s:14:\"col-start--m-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:109;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--l-2\";s:4:\"name\";s:14:\"col-start--l-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:110;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--xl-2\";s:4:\"name\";s:15:\"col-start--xl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:111;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xxl-2\";s:4:\"name\";s:16:\"col-start--xxl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:112;a:4:{s:2:\"id\";s:24:\"acss_import_col-start--3\";s:4:\"name\";s:12:\"col-start--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:113;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--s-3\";s:4:\"name\";s:14:\"col-start--s-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:114;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--m-3\";s:4:\"name\";s:14:\"col-start--m-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:115;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--l-3\";s:4:\"name\";s:14:\"col-start--l-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:116;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--xl-3\";s:4:\"name\";s:15:\"col-start--xl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:117;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xxl-3\";s:4:\"name\";s:16:\"col-start--xxl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:118;a:4:{s:2:\"id\";s:24:\"acss_import_col-start--4\";s:4:\"name\";s:12:\"col-start--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:119;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--s-4\";s:4:\"name\";s:14:\"col-start--s-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:120;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--m-4\";s:4:\"name\";s:14:\"col-start--m-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:121;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--l-4\";s:4:\"name\";s:14:\"col-start--l-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:122;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--xl-4\";s:4:\"name\";s:15:\"col-start--xl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:123;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xxl-4\";s:4:\"name\";s:16:\"col-start--xxl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:124;a:4:{s:2:\"id\";s:24:\"acss_import_col-start--5\";s:4:\"name\";s:12:\"col-start--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:125;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--s-5\";s:4:\"name\";s:14:\"col-start--s-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:126;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--m-5\";s:4:\"name\";s:14:\"col-start--m-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:127;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--l-5\";s:4:\"name\";s:14:\"col-start--l-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:128;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--xl-5\";s:4:\"name\";s:15:\"col-start--xl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:129;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xxl-5\";s:4:\"name\";s:16:\"col-start--xxl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:130;a:4:{s:2:\"id\";s:24:\"acss_import_col-start--6\";s:4:\"name\";s:12:\"col-start--6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:131;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--s-6\";s:4:\"name\";s:14:\"col-start--s-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:132;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--m-6\";s:4:\"name\";s:14:\"col-start--m-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:133;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--l-6\";s:4:\"name\";s:14:\"col-start--l-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:134;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--xl-6\";s:4:\"name\";s:15:\"col-start--xl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:135;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xxl-6\";s:4:\"name\";s:16:\"col-start--xxl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:136;a:4:{s:2:\"id\";s:24:\"acss_import_col-start--7\";s:4:\"name\";s:12:\"col-start--7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:137;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--s-7\";s:4:\"name\";s:14:\"col-start--s-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:138;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--m-7\";s:4:\"name\";s:14:\"col-start--m-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:139;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--l-7\";s:4:\"name\";s:14:\"col-start--l-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:140;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--xl-7\";s:4:\"name\";s:15:\"col-start--xl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:141;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xxl-7\";s:4:\"name\";s:16:\"col-start--xxl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:142;a:4:{s:2:\"id\";s:24:\"acss_import_col-start--8\";s:4:\"name\";s:12:\"col-start--8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:143;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--s-8\";s:4:\"name\";s:14:\"col-start--s-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:144;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--m-8\";s:4:\"name\";s:14:\"col-start--m-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:145;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--l-8\";s:4:\"name\";s:14:\"col-start--l-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:146;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--xl-8\";s:4:\"name\";s:15:\"col-start--xl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:147;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xxl-8\";s:4:\"name\";s:16:\"col-start--xxl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:148;a:4:{s:2:\"id\";s:24:\"acss_import_col-start--9\";s:4:\"name\";s:12:\"col-start--9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:149;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--s-9\";s:4:\"name\";s:14:\"col-start--s-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:150;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--m-9\";s:4:\"name\";s:14:\"col-start--m-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:151;a:4:{s:2:\"id\";s:26:\"acss_import_col-start--l-9\";s:4:\"name\";s:14:\"col-start--l-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:152;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--xl-9\";s:4:\"name\";s:15:\"col-start--xl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:153;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xxl-9\";s:4:\"name\";s:16:\"col-start--xxl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:154;a:4:{s:2:\"id\";s:25:\"acss_import_col-start--10\";s:4:\"name\";s:13:\"col-start--10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:155;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--s-10\";s:4:\"name\";s:15:\"col-start--s-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:156;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--m-10\";s:4:\"name\";s:15:\"col-start--m-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:157;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--l-10\";s:4:\"name\";s:15:\"col-start--l-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:158;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xl-10\";s:4:\"name\";s:16:\"col-start--xl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:159;a:4:{s:2:\"id\";s:29:\"acss_import_col-start--xxl-10\";s:4:\"name\";s:17:\"col-start--xxl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:160;a:4:{s:2:\"id\";s:25:\"acss_import_col-start--11\";s:4:\"name\";s:13:\"col-start--11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:161;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--s-11\";s:4:\"name\";s:15:\"col-start--s-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:162;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--m-11\";s:4:\"name\";s:15:\"col-start--m-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:163;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--l-11\";s:4:\"name\";s:15:\"col-start--l-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:164;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xl-11\";s:4:\"name\";s:16:\"col-start--xl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:165;a:4:{s:2:\"id\";s:29:\"acss_import_col-start--xxl-11\";s:4:\"name\";s:17:\"col-start--xxl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:166;a:4:{s:2:\"id\";s:25:\"acss_import_col-start--12\";s:4:\"name\";s:13:\"col-start--12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:167;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--s-12\";s:4:\"name\";s:15:\"col-start--s-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:168;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--m-12\";s:4:\"name\";s:15:\"col-start--m-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:169;a:4:{s:2:\"id\";s:27:\"acss_import_col-start--l-12\";s:4:\"name\";s:15:\"col-start--l-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:170;a:4:{s:2:\"id\";s:28:\"acss_import_col-start--xl-12\";s:4:\"name\";s:16:\"col-start--xl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:171;a:4:{s:2:\"id\";s:29:\"acss_import_col-start--xxl-12\";s:4:\"name\";s:17:\"col-start--xxl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:172;a:4:{s:2:\"id\";s:22:\"acss_import_col-end--1\";s:4:\"name\";s:10:\"col-end--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:173;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--s-1\";s:4:\"name\";s:12:\"col-end--s-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:174;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--m-1\";s:4:\"name\";s:12:\"col-end--m-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:175;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--l-1\";s:4:\"name\";s:12:\"col-end--l-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:176;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--xl-1\";s:4:\"name\";s:13:\"col-end--xl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:177;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xxl-1\";s:4:\"name\";s:14:\"col-end--xxl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:178;a:4:{s:2:\"id\";s:22:\"acss_import_col-end--2\";s:4:\"name\";s:10:\"col-end--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:179;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--s-2\";s:4:\"name\";s:12:\"col-end--s-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:180;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--m-2\";s:4:\"name\";s:12:\"col-end--m-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:181;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--l-2\";s:4:\"name\";s:12:\"col-end--l-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:182;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--xl-2\";s:4:\"name\";s:13:\"col-end--xl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:183;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xxl-2\";s:4:\"name\";s:14:\"col-end--xxl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:184;a:4:{s:2:\"id\";s:22:\"acss_import_col-end--3\";s:4:\"name\";s:10:\"col-end--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:185;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--s-3\";s:4:\"name\";s:12:\"col-end--s-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:186;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--m-3\";s:4:\"name\";s:12:\"col-end--m-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:187;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--l-3\";s:4:\"name\";s:12:\"col-end--l-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:188;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--xl-3\";s:4:\"name\";s:13:\"col-end--xl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:189;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xxl-3\";s:4:\"name\";s:14:\"col-end--xxl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:190;a:4:{s:2:\"id\";s:22:\"acss_import_col-end--4\";s:4:\"name\";s:10:\"col-end--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:191;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--s-4\";s:4:\"name\";s:12:\"col-end--s-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:192;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--m-4\";s:4:\"name\";s:12:\"col-end--m-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:193;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--l-4\";s:4:\"name\";s:12:\"col-end--l-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:194;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--xl-4\";s:4:\"name\";s:13:\"col-end--xl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:195;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xxl-4\";s:4:\"name\";s:14:\"col-end--xxl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:196;a:4:{s:2:\"id\";s:22:\"acss_import_col-end--5\";s:4:\"name\";s:10:\"col-end--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:197;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--s-5\";s:4:\"name\";s:12:\"col-end--s-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:198;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--m-5\";s:4:\"name\";s:12:\"col-end--m-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:199;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--l-5\";s:4:\"name\";s:12:\"col-end--l-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:200;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--xl-5\";s:4:\"name\";s:13:\"col-end--xl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:201;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xxl-5\";s:4:\"name\";s:14:\"col-end--xxl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:202;a:4:{s:2:\"id\";s:22:\"acss_import_col-end--6\";s:4:\"name\";s:10:\"col-end--6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:203;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--s-6\";s:4:\"name\";s:12:\"col-end--s-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:204;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--m-6\";s:4:\"name\";s:12:\"col-end--m-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:205;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--l-6\";s:4:\"name\";s:12:\"col-end--l-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:206;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--xl-6\";s:4:\"name\";s:13:\"col-end--xl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:207;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xxl-6\";s:4:\"name\";s:14:\"col-end--xxl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:208;a:4:{s:2:\"id\";s:22:\"acss_import_col-end--7\";s:4:\"name\";s:10:\"col-end--7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:209;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--s-7\";s:4:\"name\";s:12:\"col-end--s-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:210;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--m-7\";s:4:\"name\";s:12:\"col-end--m-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:211;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--l-7\";s:4:\"name\";s:12:\"col-end--l-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:212;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--xl-7\";s:4:\"name\";s:13:\"col-end--xl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:213;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xxl-7\";s:4:\"name\";s:14:\"col-end--xxl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:214;a:4:{s:2:\"id\";s:22:\"acss_import_col-end--8\";s:4:\"name\";s:10:\"col-end--8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:215;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--s-8\";s:4:\"name\";s:12:\"col-end--s-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:216;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--m-8\";s:4:\"name\";s:12:\"col-end--m-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:217;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--l-8\";s:4:\"name\";s:12:\"col-end--l-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:218;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--xl-8\";s:4:\"name\";s:13:\"col-end--xl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:219;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xxl-8\";s:4:\"name\";s:14:\"col-end--xxl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:220;a:4:{s:2:\"id\";s:22:\"acss_import_col-end--9\";s:4:\"name\";s:10:\"col-end--9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:221;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--s-9\";s:4:\"name\";s:12:\"col-end--s-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:222;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--m-9\";s:4:\"name\";s:12:\"col-end--m-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:223;a:4:{s:2:\"id\";s:24:\"acss_import_col-end--l-9\";s:4:\"name\";s:12:\"col-end--l-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:224;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--xl-9\";s:4:\"name\";s:13:\"col-end--xl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:225;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xxl-9\";s:4:\"name\";s:14:\"col-end--xxl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:226;a:4:{s:2:\"id\";s:23:\"acss_import_col-end--10\";s:4:\"name\";s:11:\"col-end--10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:227;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--s-10\";s:4:\"name\";s:13:\"col-end--s-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:228;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--m-10\";s:4:\"name\";s:13:\"col-end--m-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:229;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--l-10\";s:4:\"name\";s:13:\"col-end--l-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:230;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xl-10\";s:4:\"name\";s:14:\"col-end--xl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:231;a:4:{s:2:\"id\";s:27:\"acss_import_col-end--xxl-10\";s:4:\"name\";s:15:\"col-end--xxl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:232;a:4:{s:2:\"id\";s:23:\"acss_import_col-end--11\";s:4:\"name\";s:11:\"col-end--11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:233;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--s-11\";s:4:\"name\";s:13:\"col-end--s-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:234;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--m-11\";s:4:\"name\";s:13:\"col-end--m-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:235;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--l-11\";s:4:\"name\";s:13:\"col-end--l-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:236;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xl-11\";s:4:\"name\";s:14:\"col-end--xl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:237;a:4:{s:2:\"id\";s:27:\"acss_import_col-end--xxl-11\";s:4:\"name\";s:15:\"col-end--xxl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:238;a:4:{s:2:\"id\";s:23:\"acss_import_col-end--12\";s:4:\"name\";s:11:\"col-end--12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:239;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--s-12\";s:4:\"name\";s:13:\"col-end--s-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:240;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--m-12\";s:4:\"name\";s:13:\"col-end--m-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:241;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--l-12\";s:4:\"name\";s:13:\"col-end--l-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:242;a:4:{s:2:\"id\";s:26:\"acss_import_col-end--xl-12\";s:4:\"name\";s:14:\"col-end--xl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:243;a:4:{s:2:\"id\";s:27:\"acss_import_col-end--xxl-12\";s:4:\"name\";s:15:\"col-end--xxl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:244;a:4:{s:2:\"id\";s:25:\"acss_import_col-end--last\";s:4:\"name\";s:13:\"col-end--last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:245;a:4:{s:2:\"id\";s:27:\"acss_import_col-end--s-last\";s:4:\"name\";s:15:\"col-end--s-last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:246;a:4:{s:2:\"id\";s:27:\"acss_import_col-end--m-last\";s:4:\"name\";s:15:\"col-end--m-last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:247;a:4:{s:2:\"id\";s:27:\"acss_import_col-end--l-last\";s:4:\"name\";s:15:\"col-end--l-last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:248;a:4:{s:2:\"id\";s:28:\"acss_import_col-end--xl-last\";s:4:\"name\";s:16:\"col-end--xl-last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:249;a:4:{s:2:\"id\";s:29:\"acss_import_col-end--xxl-last\";s:4:\"name\";s:17:\"col-end--xxl-last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:250;a:4:{s:2:\"id\";s:24:\"acss_import_row-start--1\";s:4:\"name\";s:12:\"row-start--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:251;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--s-1\";s:4:\"name\";s:14:\"row-start--s-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:252;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--m-1\";s:4:\"name\";s:14:\"row-start--m-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:253;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--l-1\";s:4:\"name\";s:14:\"row-start--l-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:254;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--xl-1\";s:4:\"name\";s:15:\"row-start--xl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:255;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xxl-1\";s:4:\"name\";s:16:\"row-start--xxl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:256;a:4:{s:2:\"id\";s:24:\"acss_import_row-start--2\";s:4:\"name\";s:12:\"row-start--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:257;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--s-2\";s:4:\"name\";s:14:\"row-start--s-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:258;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--m-2\";s:4:\"name\";s:14:\"row-start--m-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:259;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--l-2\";s:4:\"name\";s:14:\"row-start--l-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:260;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--xl-2\";s:4:\"name\";s:15:\"row-start--xl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:261;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xxl-2\";s:4:\"name\";s:16:\"row-start--xxl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:262;a:4:{s:2:\"id\";s:24:\"acss_import_row-start--3\";s:4:\"name\";s:12:\"row-start--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:263;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--s-3\";s:4:\"name\";s:14:\"row-start--s-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:264;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--m-3\";s:4:\"name\";s:14:\"row-start--m-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:265;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--l-3\";s:4:\"name\";s:14:\"row-start--l-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:266;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--xl-3\";s:4:\"name\";s:15:\"row-start--xl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:267;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xxl-3\";s:4:\"name\";s:16:\"row-start--xxl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:268;a:4:{s:2:\"id\";s:24:\"acss_import_row-start--4\";s:4:\"name\";s:12:\"row-start--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:269;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--s-4\";s:4:\"name\";s:14:\"row-start--s-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:270;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--m-4\";s:4:\"name\";s:14:\"row-start--m-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:271;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--l-4\";s:4:\"name\";s:14:\"row-start--l-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:272;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--xl-4\";s:4:\"name\";s:15:\"row-start--xl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:273;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xxl-4\";s:4:\"name\";s:16:\"row-start--xxl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:274;a:4:{s:2:\"id\";s:24:\"acss_import_row-start--5\";s:4:\"name\";s:12:\"row-start--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:275;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--s-5\";s:4:\"name\";s:14:\"row-start--s-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:276;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--m-5\";s:4:\"name\";s:14:\"row-start--m-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:277;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--l-5\";s:4:\"name\";s:14:\"row-start--l-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:278;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--xl-5\";s:4:\"name\";s:15:\"row-start--xl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:279;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xxl-5\";s:4:\"name\";s:16:\"row-start--xxl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:280;a:4:{s:2:\"id\";s:24:\"acss_import_row-start--6\";s:4:\"name\";s:12:\"row-start--6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:281;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--s-6\";s:4:\"name\";s:14:\"row-start--s-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:282;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--m-6\";s:4:\"name\";s:14:\"row-start--m-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:283;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--l-6\";s:4:\"name\";s:14:\"row-start--l-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:284;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--xl-6\";s:4:\"name\";s:15:\"row-start--xl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:285;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xxl-6\";s:4:\"name\";s:16:\"row-start--xxl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:286;a:4:{s:2:\"id\";s:24:\"acss_import_row-start--7\";s:4:\"name\";s:12:\"row-start--7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:287;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--s-7\";s:4:\"name\";s:14:\"row-start--s-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:288;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--m-7\";s:4:\"name\";s:14:\"row-start--m-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:289;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--l-7\";s:4:\"name\";s:14:\"row-start--l-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:290;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--xl-7\";s:4:\"name\";s:15:\"row-start--xl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:291;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xxl-7\";s:4:\"name\";s:16:\"row-start--xxl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:292;a:4:{s:2:\"id\";s:24:\"acss_import_row-start--8\";s:4:\"name\";s:12:\"row-start--8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:293;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--s-8\";s:4:\"name\";s:14:\"row-start--s-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:294;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--m-8\";s:4:\"name\";s:14:\"row-start--m-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:295;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--l-8\";s:4:\"name\";s:14:\"row-start--l-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:296;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--xl-8\";s:4:\"name\";s:15:\"row-start--xl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:297;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xxl-8\";s:4:\"name\";s:16:\"row-start--xxl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:298;a:4:{s:2:\"id\";s:24:\"acss_import_row-start--9\";s:4:\"name\";s:12:\"row-start--9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:299;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--s-9\";s:4:\"name\";s:14:\"row-start--s-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:300;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--m-9\";s:4:\"name\";s:14:\"row-start--m-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:301;a:4:{s:2:\"id\";s:26:\"acss_import_row-start--l-9\";s:4:\"name\";s:14:\"row-start--l-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:302;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--xl-9\";s:4:\"name\";s:15:\"row-start--xl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:303;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xxl-9\";s:4:\"name\";s:16:\"row-start--xxl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:304;a:4:{s:2:\"id\";s:25:\"acss_import_row-start--10\";s:4:\"name\";s:13:\"row-start--10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:305;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--s-10\";s:4:\"name\";s:15:\"row-start--s-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:306;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--m-10\";s:4:\"name\";s:15:\"row-start--m-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:307;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--l-10\";s:4:\"name\";s:15:\"row-start--l-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:308;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xl-10\";s:4:\"name\";s:16:\"row-start--xl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:309;a:4:{s:2:\"id\";s:29:\"acss_import_row-start--xxl-10\";s:4:\"name\";s:17:\"row-start--xxl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:310;a:4:{s:2:\"id\";s:25:\"acss_import_row-start--11\";s:4:\"name\";s:13:\"row-start--11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:311;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--s-11\";s:4:\"name\";s:15:\"row-start--s-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:312;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--m-11\";s:4:\"name\";s:15:\"row-start--m-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:313;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--l-11\";s:4:\"name\";s:15:\"row-start--l-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:314;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xl-11\";s:4:\"name\";s:16:\"row-start--xl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:315;a:4:{s:2:\"id\";s:29:\"acss_import_row-start--xxl-11\";s:4:\"name\";s:17:\"row-start--xxl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:316;a:4:{s:2:\"id\";s:25:\"acss_import_row-start--12\";s:4:\"name\";s:13:\"row-start--12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:317;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--s-12\";s:4:\"name\";s:15:\"row-start--s-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:318;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--m-12\";s:4:\"name\";s:15:\"row-start--m-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:319;a:4:{s:2:\"id\";s:27:\"acss_import_row-start--l-12\";s:4:\"name\";s:15:\"row-start--l-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:320;a:4:{s:2:\"id\";s:28:\"acss_import_row-start--xl-12\";s:4:\"name\";s:16:\"row-start--xl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:321;a:4:{s:2:\"id\";s:29:\"acss_import_row-start--xxl-12\";s:4:\"name\";s:17:\"row-start--xxl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:322;a:4:{s:2:\"id\";s:22:\"acss_import_row-end--1\";s:4:\"name\";s:10:\"row-end--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:323;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--s-1\";s:4:\"name\";s:12:\"row-end--s-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:324;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--m-1\";s:4:\"name\";s:12:\"row-end--m-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:325;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--l-1\";s:4:\"name\";s:12:\"row-end--l-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:326;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--xl-1\";s:4:\"name\";s:13:\"row-end--xl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:327;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xxl-1\";s:4:\"name\";s:14:\"row-end--xxl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:328;a:4:{s:2:\"id\";s:22:\"acss_import_row-end--2\";s:4:\"name\";s:10:\"row-end--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:329;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--s-2\";s:4:\"name\";s:12:\"row-end--s-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:330;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--m-2\";s:4:\"name\";s:12:\"row-end--m-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:331;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--l-2\";s:4:\"name\";s:12:\"row-end--l-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:332;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--xl-2\";s:4:\"name\";s:13:\"row-end--xl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:333;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xxl-2\";s:4:\"name\";s:14:\"row-end--xxl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:334;a:4:{s:2:\"id\";s:22:\"acss_import_row-end--3\";s:4:\"name\";s:10:\"row-end--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:335;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--s-3\";s:4:\"name\";s:12:\"row-end--s-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:336;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--m-3\";s:4:\"name\";s:12:\"row-end--m-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:337;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--l-3\";s:4:\"name\";s:12:\"row-end--l-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:338;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--xl-3\";s:4:\"name\";s:13:\"row-end--xl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:339;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xxl-3\";s:4:\"name\";s:14:\"row-end--xxl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:340;a:4:{s:2:\"id\";s:22:\"acss_import_row-end--4\";s:4:\"name\";s:10:\"row-end--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:341;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--s-4\";s:4:\"name\";s:12:\"row-end--s-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:342;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--m-4\";s:4:\"name\";s:12:\"row-end--m-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:343;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--l-4\";s:4:\"name\";s:12:\"row-end--l-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:344;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--xl-4\";s:4:\"name\";s:13:\"row-end--xl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:345;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xxl-4\";s:4:\"name\";s:14:\"row-end--xxl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:346;a:4:{s:2:\"id\";s:22:\"acss_import_row-end--5\";s:4:\"name\";s:10:\"row-end--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:347;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--s-5\";s:4:\"name\";s:12:\"row-end--s-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:348;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--m-5\";s:4:\"name\";s:12:\"row-end--m-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:349;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--l-5\";s:4:\"name\";s:12:\"row-end--l-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:350;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--xl-5\";s:4:\"name\";s:13:\"row-end--xl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:351;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xxl-5\";s:4:\"name\";s:14:\"row-end--xxl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:352;a:4:{s:2:\"id\";s:22:\"acss_import_row-end--6\";s:4:\"name\";s:10:\"row-end--6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:353;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--s-6\";s:4:\"name\";s:12:\"row-end--s-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:354;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--m-6\";s:4:\"name\";s:12:\"row-end--m-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:355;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--l-6\";s:4:\"name\";s:12:\"row-end--l-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:356;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--xl-6\";s:4:\"name\";s:13:\"row-end--xl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:357;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xxl-6\";s:4:\"name\";s:14:\"row-end--xxl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:358;a:4:{s:2:\"id\";s:22:\"acss_import_row-end--7\";s:4:\"name\";s:10:\"row-end--7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:359;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--s-7\";s:4:\"name\";s:12:\"row-end--s-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:360;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--m-7\";s:4:\"name\";s:12:\"row-end--m-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:361;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--l-7\";s:4:\"name\";s:12:\"row-end--l-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:362;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--xl-7\";s:4:\"name\";s:13:\"row-end--xl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:363;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xxl-7\";s:4:\"name\";s:14:\"row-end--xxl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:364;a:4:{s:2:\"id\";s:22:\"acss_import_row-end--8\";s:4:\"name\";s:10:\"row-end--8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:365;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--s-8\";s:4:\"name\";s:12:\"row-end--s-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:366;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--m-8\";s:4:\"name\";s:12:\"row-end--m-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:367;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--l-8\";s:4:\"name\";s:12:\"row-end--l-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:368;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--xl-8\";s:4:\"name\";s:13:\"row-end--xl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:369;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xxl-8\";s:4:\"name\";s:14:\"row-end--xxl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:370;a:4:{s:2:\"id\";s:22:\"acss_import_row-end--9\";s:4:\"name\";s:10:\"row-end--9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:371;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--s-9\";s:4:\"name\";s:12:\"row-end--s-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:372;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--m-9\";s:4:\"name\";s:12:\"row-end--m-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:373;a:4:{s:2:\"id\";s:24:\"acss_import_row-end--l-9\";s:4:\"name\";s:12:\"row-end--l-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:374;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--xl-9\";s:4:\"name\";s:13:\"row-end--xl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:375;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xxl-9\";s:4:\"name\";s:14:\"row-end--xxl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:376;a:4:{s:2:\"id\";s:23:\"acss_import_row-end--10\";s:4:\"name\";s:11:\"row-end--10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:377;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--s-10\";s:4:\"name\";s:13:\"row-end--s-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:378;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--m-10\";s:4:\"name\";s:13:\"row-end--m-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:379;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--l-10\";s:4:\"name\";s:13:\"row-end--l-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:380;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xl-10\";s:4:\"name\";s:14:\"row-end--xl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:381;a:4:{s:2:\"id\";s:27:\"acss_import_row-end--xxl-10\";s:4:\"name\";s:15:\"row-end--xxl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:382;a:4:{s:2:\"id\";s:23:\"acss_import_row-end--11\";s:4:\"name\";s:11:\"row-end--11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:383;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--s-11\";s:4:\"name\";s:13:\"row-end--s-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:384;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--m-11\";s:4:\"name\";s:13:\"row-end--m-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:385;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--l-11\";s:4:\"name\";s:13:\"row-end--l-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:386;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xl-11\";s:4:\"name\";s:14:\"row-end--xl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:387;a:4:{s:2:\"id\";s:27:\"acss_import_row-end--xxl-11\";s:4:\"name\";s:15:\"row-end--xxl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:388;a:4:{s:2:\"id\";s:23:\"acss_import_row-end--12\";s:4:\"name\";s:11:\"row-end--12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:389;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--s-12\";s:4:\"name\";s:13:\"row-end--s-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:390;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--m-12\";s:4:\"name\";s:13:\"row-end--m-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:391;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--l-12\";s:4:\"name\";s:13:\"row-end--l-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:392;a:4:{s:2:\"id\";s:26:\"acss_import_row-end--xl-12\";s:4:\"name\";s:14:\"row-end--xl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:393;a:4:{s:2:\"id\";s:27:\"acss_import_row-end--xxl-12\";s:4:\"name\";s:15:\"row-end--xxl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:394;a:4:{s:2:\"id\";s:25:\"acss_import_row-end--last\";s:4:\"name\";s:13:\"row-end--last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:395;a:4:{s:2:\"id\";s:27:\"acss_import_row-end--s-last\";s:4:\"name\";s:15:\"row-end--s-last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:396;a:4:{s:2:\"id\";s:27:\"acss_import_row-end--m-last\";s:4:\"name\";s:15:\"row-end--m-last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:397;a:4:{s:2:\"id\";s:27:\"acss_import_row-end--l-last\";s:4:\"name\";s:15:\"row-end--l-last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:398;a:4:{s:2:\"id\";s:28:\"acss_import_row-end--xl-last\";s:4:\"name\";s:16:\"row-end--xl-last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:399;a:4:{s:2:\"id\";s:29:\"acss_import_row-end--xxl-last\";s:4:\"name\";s:17:\"row-end--xxl-last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:400;a:4:{s:2:\"id\";s:23:\"acss_import_col-span--1\";s:4:\"name\";s:11:\"col-span--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:401;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--s-1\";s:4:\"name\";s:13:\"col-span--s-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:402;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--m-1\";s:4:\"name\";s:13:\"col-span--m-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:403;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--l-1\";s:4:\"name\";s:13:\"col-span--l-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:404;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--xl-1\";s:4:\"name\";s:14:\"col-span--xl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:405;a:4:{s:2:\"id\";s:23:\"acss_import_col-span--2\";s:4:\"name\";s:11:\"col-span--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:406;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--s-2\";s:4:\"name\";s:13:\"col-span--s-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:407;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--m-2\";s:4:\"name\";s:13:\"col-span--m-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:408;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--l-2\";s:4:\"name\";s:13:\"col-span--l-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:409;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--xl-2\";s:4:\"name\";s:14:\"col-span--xl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:410;a:4:{s:2:\"id\";s:23:\"acss_import_col-span--3\";s:4:\"name\";s:11:\"col-span--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:411;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--s-3\";s:4:\"name\";s:13:\"col-span--s-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:412;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--m-3\";s:4:\"name\";s:13:\"col-span--m-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:413;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--l-3\";s:4:\"name\";s:13:\"col-span--l-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:414;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--xl-3\";s:4:\"name\";s:14:\"col-span--xl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:415;a:4:{s:2:\"id\";s:23:\"acss_import_col-span--4\";s:4:\"name\";s:11:\"col-span--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:416;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--s-4\";s:4:\"name\";s:13:\"col-span--s-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:417;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--m-4\";s:4:\"name\";s:13:\"col-span--m-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:418;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--l-4\";s:4:\"name\";s:13:\"col-span--l-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:419;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--xl-4\";s:4:\"name\";s:14:\"col-span--xl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:420;a:4:{s:2:\"id\";s:23:\"acss_import_col-span--5\";s:4:\"name\";s:11:\"col-span--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:421;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--s-5\";s:4:\"name\";s:13:\"col-span--s-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:422;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--m-5\";s:4:\"name\";s:13:\"col-span--m-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:423;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--l-5\";s:4:\"name\";s:13:\"col-span--l-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:424;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--xl-5\";s:4:\"name\";s:14:\"col-span--xl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:425;a:4:{s:2:\"id\";s:23:\"acss_import_col-span--6\";s:4:\"name\";s:11:\"col-span--6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:426;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--s-6\";s:4:\"name\";s:13:\"col-span--s-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:427;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--m-6\";s:4:\"name\";s:13:\"col-span--m-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:428;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--l-6\";s:4:\"name\";s:13:\"col-span--l-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:429;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--xl-6\";s:4:\"name\";s:14:\"col-span--xl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:430;a:4:{s:2:\"id\";s:23:\"acss_import_col-span--7\";s:4:\"name\";s:11:\"col-span--7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:431;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--s-7\";s:4:\"name\";s:13:\"col-span--s-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:432;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--m-7\";s:4:\"name\";s:13:\"col-span--m-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:433;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--l-7\";s:4:\"name\";s:13:\"col-span--l-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:434;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--xl-7\";s:4:\"name\";s:14:\"col-span--xl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:435;a:4:{s:2:\"id\";s:23:\"acss_import_col-span--8\";s:4:\"name\";s:11:\"col-span--8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:436;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--s-8\";s:4:\"name\";s:13:\"col-span--s-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:437;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--m-8\";s:4:\"name\";s:13:\"col-span--m-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:438;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--l-8\";s:4:\"name\";s:13:\"col-span--l-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:439;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--xl-8\";s:4:\"name\";s:14:\"col-span--xl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:440;a:4:{s:2:\"id\";s:23:\"acss_import_col-span--9\";s:4:\"name\";s:11:\"col-span--9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:441;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--s-9\";s:4:\"name\";s:13:\"col-span--s-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:442;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--m-9\";s:4:\"name\";s:13:\"col-span--m-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:443;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--l-9\";s:4:\"name\";s:13:\"col-span--l-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:444;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--xl-9\";s:4:\"name\";s:14:\"col-span--xl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:445;a:4:{s:2:\"id\";s:24:\"acss_import_col-span--10\";s:4:\"name\";s:12:\"col-span--10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:446;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--s-10\";s:4:\"name\";s:14:\"col-span--s-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:447;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--m-10\";s:4:\"name\";s:14:\"col-span--m-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:448;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--l-10\";s:4:\"name\";s:14:\"col-span--l-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:449;a:4:{s:2:\"id\";s:27:\"acss_import_col-span--xl-10\";s:4:\"name\";s:15:\"col-span--xl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:450;a:4:{s:2:\"id\";s:24:\"acss_import_col-span--11\";s:4:\"name\";s:12:\"col-span--11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:451;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--s-11\";s:4:\"name\";s:14:\"col-span--s-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:452;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--m-11\";s:4:\"name\";s:14:\"col-span--m-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:453;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--l-11\";s:4:\"name\";s:14:\"col-span--l-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:454;a:4:{s:2:\"id\";s:27:\"acss_import_col-span--xl-11\";s:4:\"name\";s:15:\"col-span--xl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:455;a:4:{s:2:\"id\";s:24:\"acss_import_col-span--12\";s:4:\"name\";s:12:\"col-span--12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:456;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--s-12\";s:4:\"name\";s:14:\"col-span--s-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:457;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--m-12\";s:4:\"name\";s:14:\"col-span--m-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:458;a:4:{s:2:\"id\";s:26:\"acss_import_col-span--l-12\";s:4:\"name\";s:14:\"col-span--l-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:459;a:4:{s:2:\"id\";s:27:\"acss_import_col-span--xl-12\";s:4:\"name\";s:15:\"col-span--xl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:460;a:4:{s:2:\"id\";s:25:\"acss_import_col-span--all\";s:4:\"name\";s:13:\"col-span--all\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:461;a:4:{s:2:\"id\";s:27:\"acss_import_col-span--s-all\";s:4:\"name\";s:15:\"col-span--s-all\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:462;a:4:{s:2:\"id\";s:27:\"acss_import_col-span--m-all\";s:4:\"name\";s:15:\"col-span--m-all\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:463;a:4:{s:2:\"id\";s:27:\"acss_import_col-span--l-all\";s:4:\"name\";s:15:\"col-span--l-all\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:464;a:4:{s:2:\"id\";s:28:\"acss_import_col-span--xl-all\";s:4:\"name\";s:16:\"col-span--xl-all\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:465;a:4:{s:2:\"id\";s:23:\"acss_import_row-span--1\";s:4:\"name\";s:11:\"row-span--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:466;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--s-1\";s:4:\"name\";s:13:\"row-span--s-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:467;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--m-1\";s:4:\"name\";s:13:\"row-span--m-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:468;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--l-1\";s:4:\"name\";s:13:\"row-span--l-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:469;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--xl-1\";s:4:\"name\";s:14:\"row-span--xl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:470;a:4:{s:2:\"id\";s:23:\"acss_import_row-span--2\";s:4:\"name\";s:11:\"row-span--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:471;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--s-2\";s:4:\"name\";s:13:\"row-span--s-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:472;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--m-2\";s:4:\"name\";s:13:\"row-span--m-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:473;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--l-2\";s:4:\"name\";s:13:\"row-span--l-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:474;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--xl-2\";s:4:\"name\";s:14:\"row-span--xl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:475;a:4:{s:2:\"id\";s:23:\"acss_import_row-span--3\";s:4:\"name\";s:11:\"row-span--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:476;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--s-3\";s:4:\"name\";s:13:\"row-span--s-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:477;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--m-3\";s:4:\"name\";s:13:\"row-span--m-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:478;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--l-3\";s:4:\"name\";s:13:\"row-span--l-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:479;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--xl-3\";s:4:\"name\";s:14:\"row-span--xl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:480;a:4:{s:2:\"id\";s:23:\"acss_import_row-span--4\";s:4:\"name\";s:11:\"row-span--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:481;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--s-4\";s:4:\"name\";s:13:\"row-span--s-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:482;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--m-4\";s:4:\"name\";s:13:\"row-span--m-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:483;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--l-4\";s:4:\"name\";s:13:\"row-span--l-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:484;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--xl-4\";s:4:\"name\";s:14:\"row-span--xl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:485;a:4:{s:2:\"id\";s:23:\"acss_import_row-span--5\";s:4:\"name\";s:11:\"row-span--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:486;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--s-5\";s:4:\"name\";s:13:\"row-span--s-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:487;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--m-5\";s:4:\"name\";s:13:\"row-span--m-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:488;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--l-5\";s:4:\"name\";s:13:\"row-span--l-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:489;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--xl-5\";s:4:\"name\";s:14:\"row-span--xl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:490;a:4:{s:2:\"id\";s:23:\"acss_import_row-span--6\";s:4:\"name\";s:11:\"row-span--6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:491;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--s-6\";s:4:\"name\";s:13:\"row-span--s-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:492;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--m-6\";s:4:\"name\";s:13:\"row-span--m-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:493;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--l-6\";s:4:\"name\";s:13:\"row-span--l-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:494;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--xl-6\";s:4:\"name\";s:14:\"row-span--xl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:495;a:4:{s:2:\"id\";s:23:\"acss_import_row-span--7\";s:4:\"name\";s:11:\"row-span--7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:496;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--s-7\";s:4:\"name\";s:13:\"row-span--s-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:497;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--m-7\";s:4:\"name\";s:13:\"row-span--m-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:498;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--l-7\";s:4:\"name\";s:13:\"row-span--l-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:499;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--xl-7\";s:4:\"name\";s:14:\"row-span--xl-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:500;a:4:{s:2:\"id\";s:23:\"acss_import_row-span--8\";s:4:\"name\";s:11:\"row-span--8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:501;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--s-8\";s:4:\"name\";s:13:\"row-span--s-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:502;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--m-8\";s:4:\"name\";s:13:\"row-span--m-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:503;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--l-8\";s:4:\"name\";s:13:\"row-span--l-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:504;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--xl-8\";s:4:\"name\";s:14:\"row-span--xl-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:505;a:4:{s:2:\"id\";s:23:\"acss_import_row-span--9\";s:4:\"name\";s:11:\"row-span--9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:506;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--s-9\";s:4:\"name\";s:13:\"row-span--s-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:507;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--m-9\";s:4:\"name\";s:13:\"row-span--m-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:508;a:4:{s:2:\"id\";s:25:\"acss_import_row-span--l-9\";s:4:\"name\";s:13:\"row-span--l-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:509;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--xl-9\";s:4:\"name\";s:14:\"row-span--xl-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:510;a:4:{s:2:\"id\";s:24:\"acss_import_row-span--10\";s:4:\"name\";s:12:\"row-span--10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:511;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--s-10\";s:4:\"name\";s:14:\"row-span--s-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:512;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--m-10\";s:4:\"name\";s:14:\"row-span--m-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:513;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--l-10\";s:4:\"name\";s:14:\"row-span--l-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:514;a:4:{s:2:\"id\";s:27:\"acss_import_row-span--xl-10\";s:4:\"name\";s:15:\"row-span--xl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:515;a:4:{s:2:\"id\";s:24:\"acss_import_row-span--11\";s:4:\"name\";s:12:\"row-span--11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:516;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--s-11\";s:4:\"name\";s:14:\"row-span--s-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:517;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--m-11\";s:4:\"name\";s:14:\"row-span--m-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:518;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--l-11\";s:4:\"name\";s:14:\"row-span--l-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:519;a:4:{s:2:\"id\";s:27:\"acss_import_row-span--xl-11\";s:4:\"name\";s:15:\"row-span--xl-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:520;a:4:{s:2:\"id\";s:24:\"acss_import_row-span--12\";s:4:\"name\";s:12:\"row-span--12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:521;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--s-12\";s:4:\"name\";s:14:\"row-span--s-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:522;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--m-12\";s:4:\"name\";s:14:\"row-span--m-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:523;a:4:{s:2:\"id\";s:26:\"acss_import_row-span--l-12\";s:4:\"name\";s:14:\"row-span--l-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:524;a:4:{s:2:\"id\";s:27:\"acss_import_row-span--xl-12\";s:4:\"name\";s:15:\"row-span--xl-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:525;a:4:{s:2:\"id\";s:24:\"acss_import_order--first\";s:4:\"name\";s:12:\"order--first\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:526;a:4:{s:2:\"id\";s:28:\"acss_import_order--first-xxl\";s:4:\"name\";s:16:\"order--first-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:527;a:4:{s:2:\"id\";s:27:\"acss_import_order--first-xl\";s:4:\"name\";s:15:\"order--first-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:528;a:4:{s:2:\"id\";s:26:\"acss_import_order--first-l\";s:4:\"name\";s:14:\"order--first-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:529;a:4:{s:2:\"id\";s:26:\"acss_import_order--first-m\";s:4:\"name\";s:14:\"order--first-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:530;a:4:{s:2:\"id\";s:26:\"acss_import_order--first-s\";s:4:\"name\";s:14:\"order--first-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:531;a:4:{s:2:\"id\";s:27:\"acss_import_order--first-xs\";s:4:\"name\";s:15:\"order--first-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:532;a:4:{s:2:\"id\";s:23:\"acss_import_order--last\";s:4:\"name\";s:11:\"order--last\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:533;a:4:{s:2:\"id\";s:27:\"acss_import_order--last-xxl\";s:4:\"name\";s:15:\"order--last-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:534;a:4:{s:2:\"id\";s:26:\"acss_import_order--last-xl\";s:4:\"name\";s:14:\"order--last-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:535;a:4:{s:2:\"id\";s:25:\"acss_import_order--last-l\";s:4:\"name\";s:13:\"order--last-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:536;a:4:{s:2:\"id\";s:25:\"acss_import_order--last-m\";s:4:\"name\";s:13:\"order--last-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:537;a:4:{s:2:\"id\";s:25:\"acss_import_order--last-s\";s:4:\"name\";s:13:\"order--last-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:538;a:4:{s:2:\"id\";s:26:\"acss_import_order--last-xs\";s:4:\"name\";s:14:\"order--last-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:539;a:4:{s:2:\"id\";s:22:\"acss_import_flex--grow\";s:4:\"name\";s:10:\"flex--grow\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:540;a:4:{s:2:\"id\";s:22:\"acss_import_flex--wrap\";s:4:\"name\";s:10:\"flex--wrap\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:541;a:4:{s:2:\"id\";s:21:\"acss_import_flex--col\";s:4:\"name\";s:9:\"flex--col\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:542;a:4:{s:2:\"id\";s:23:\"acss_import_flex--col-s\";s:4:\"name\";s:11:\"flex--col-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:543;a:4:{s:2:\"id\";s:23:\"acss_import_flex--col-m\";s:4:\"name\";s:11:\"flex--col-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:544;a:4:{s:2:\"id\";s:23:\"acss_import_flex--col-l\";s:4:\"name\";s:11:\"flex--col-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:545;a:4:{s:2:\"id\";s:24:\"acss_import_flex--col-xl\";s:4:\"name\";s:12:\"flex--col-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:546;a:4:{s:2:\"id\";s:21:\"acss_import_flex--row\";s:4:\"name\";s:9:\"flex--row\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:547;a:4:{s:2:\"id\";s:23:\"acss_import_flex--row-s\";s:4:\"name\";s:11:\"flex--row-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:548;a:4:{s:2:\"id\";s:23:\"acss_import_flex--row-m\";s:4:\"name\";s:11:\"flex--row-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:549;a:4:{s:2:\"id\";s:23:\"acss_import_flex--row-l\";s:4:\"name\";s:11:\"flex--row-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:550;a:4:{s:2:\"id\";s:24:\"acss_import_flex--row-xl\";s:4:\"name\";s:12:\"flex--row-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:551;a:4:{s:2:\"id\";s:29:\"acss_import_flex--col-reverse\";s:4:\"name\";s:17:\"flex--col-reverse\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:552;a:4:{s:2:\"id\";s:31:\"acss_import_flex--col-reverse-s\";s:4:\"name\";s:19:\"flex--col-reverse-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:553;a:4:{s:2:\"id\";s:31:\"acss_import_flex--col-reverse-m\";s:4:\"name\";s:19:\"flex--col-reverse-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:554;a:4:{s:2:\"id\";s:31:\"acss_import_flex--col-reverse-l\";s:4:\"name\";s:19:\"flex--col-reverse-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:555;a:4:{s:2:\"id\";s:32:\"acss_import_flex--col-reverse-xl\";s:4:\"name\";s:20:\"flex--col-reverse-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:556;a:4:{s:2:\"id\";s:29:\"acss_import_flex--row-reverse\";s:4:\"name\";s:17:\"flex--row-reverse\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:557;a:4:{s:2:\"id\";s:31:\"acss_import_flex--row-reverse-s\";s:4:\"name\";s:19:\"flex--row-reverse-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:558;a:4:{s:2:\"id\";s:31:\"acss_import_flex--row-reverse-m\";s:4:\"name\";s:19:\"flex--row-reverse-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:559;a:4:{s:2:\"id\";s:31:\"acss_import_flex--row-reverse-l\";s:4:\"name\";s:19:\"flex--row-reverse-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:560;a:4:{s:2:\"id\";s:32:\"acss_import_flex--row-reverse-xl\";s:4:\"name\";s:20:\"flex--row-reverse-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:561;a:4:{s:2:\"id\";s:24:\"acss_import_flex-grid--1\";s:4:\"name\";s:12:\"flex-grid--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:562;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--s-1\";s:4:\"name\";s:14:\"flex-grid--s-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:563;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--m-1\";s:4:\"name\";s:14:\"flex-grid--m-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:564;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--l-1\";s:4:\"name\";s:14:\"flex-grid--l-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:565;a:4:{s:2:\"id\";s:27:\"acss_import_flex-grid--xl-1\";s:4:\"name\";s:15:\"flex-grid--xl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:566;a:4:{s:2:\"id\";s:24:\"acss_import_flex-grid--2\";s:4:\"name\";s:12:\"flex-grid--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:567;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--s-2\";s:4:\"name\";s:14:\"flex-grid--s-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:568;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--m-2\";s:4:\"name\";s:14:\"flex-grid--m-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:569;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--l-2\";s:4:\"name\";s:14:\"flex-grid--l-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:570;a:4:{s:2:\"id\";s:27:\"acss_import_flex-grid--xl-2\";s:4:\"name\";s:15:\"flex-grid--xl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:571;a:4:{s:2:\"id\";s:24:\"acss_import_flex-grid--3\";s:4:\"name\";s:12:\"flex-grid--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:572;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--s-3\";s:4:\"name\";s:14:\"flex-grid--s-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:573;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--m-3\";s:4:\"name\";s:14:\"flex-grid--m-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:574;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--l-3\";s:4:\"name\";s:14:\"flex-grid--l-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:575;a:4:{s:2:\"id\";s:27:\"acss_import_flex-grid--xl-3\";s:4:\"name\";s:15:\"flex-grid--xl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:576;a:4:{s:2:\"id\";s:24:\"acss_import_flex-grid--4\";s:4:\"name\";s:12:\"flex-grid--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:577;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--s-4\";s:4:\"name\";s:14:\"flex-grid--s-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:578;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--m-4\";s:4:\"name\";s:14:\"flex-grid--m-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:579;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--l-4\";s:4:\"name\";s:14:\"flex-grid--l-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:580;a:4:{s:2:\"id\";s:27:\"acss_import_flex-grid--xl-4\";s:4:\"name\";s:15:\"flex-grid--xl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:581;a:4:{s:2:\"id\";s:24:\"acss_import_flex-grid--5\";s:4:\"name\";s:12:\"flex-grid--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:582;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--s-5\";s:4:\"name\";s:14:\"flex-grid--s-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:583;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--m-5\";s:4:\"name\";s:14:\"flex-grid--m-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:584;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--l-5\";s:4:\"name\";s:14:\"flex-grid--l-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:585;a:4:{s:2:\"id\";s:27:\"acss_import_flex-grid--xl-5\";s:4:\"name\";s:15:\"flex-grid--xl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:586;a:4:{s:2:\"id\";s:24:\"acss_import_flex-grid--6\";s:4:\"name\";s:12:\"flex-grid--6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:587;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--s-6\";s:4:\"name\";s:14:\"flex-grid--s-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:588;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--m-6\";s:4:\"name\";s:14:\"flex-grid--m-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:589;a:4:{s:2:\"id\";s:26:\"acss_import_flex-grid--l-6\";s:4:\"name\";s:14:\"flex-grid--l-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:590;a:4:{s:2:\"id\";s:27:\"acss_import_flex-grid--xl-6\";s:4:\"name\";s:15:\"flex-grid--xl-6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:591;a:4:{s:2:\"id\";s:34:\"acss_import_justify-content--start\";s:4:\"name\";s:22:\"justify-content--start\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:592;a:4:{s:2:\"id\";s:32:\"acss_import_justify-content--end\";s:4:\"name\";s:20:\"justify-content--end\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:593;a:4:{s:2:\"id\";s:35:\"acss_import_justify-content--center\";s:4:\"name\";s:23:\"justify-content--center\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:594;a:4:{s:2:\"id\";s:36:\"acss_import_justify-content--between\";s:4:\"name\";s:24:\"justify-content--between\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:595;a:4:{s:2:\"id\";s:35:\"acss_import_justify-content--around\";s:4:\"name\";s:23:\"justify-content--around\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:596;a:4:{s:2:\"id\";s:36:\"acss_import_justify-content--stretch\";s:4:\"name\";s:24:\"justify-content--stretch\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:597;a:4:{s:2:\"id\";s:32:\"acss_import_justify-items--start\";s:4:\"name\";s:20:\"justify-items--start\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:598;a:4:{s:2:\"id\";s:30:\"acss_import_justify-items--end\";s:4:\"name\";s:18:\"justify-items--end\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:599;a:4:{s:2:\"id\";s:33:\"acss_import_justify-items--center\";s:4:\"name\";s:21:\"justify-items--center\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:600;a:4:{s:2:\"id\";s:34:\"acss_import_justify-items--stretch\";s:4:\"name\";s:22:\"justify-items--stretch\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:601;a:4:{s:2:\"id\";s:32:\"acss_import_align-content--start\";s:4:\"name\";s:20:\"align-content--start\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:602;a:4:{s:2:\"id\";s:30:\"acss_import_align-content--end\";s:4:\"name\";s:18:\"align-content--end\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:603;a:4:{s:2:\"id\";s:33:\"acss_import_align-content--center\";s:4:\"name\";s:21:\"align-content--center\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:604;a:4:{s:2:\"id\";s:35:\"acss_import_align-content--baseline\";s:4:\"name\";s:23:\"align-content--baseline\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:605;a:4:{s:2:\"id\";s:34:\"acss_import_align-content--stretch\";s:4:\"name\";s:22:\"align-content--stretch\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:606;a:4:{s:2:\"id\";s:30:\"acss_import_align-items--start\";s:4:\"name\";s:18:\"align-items--start\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:607;a:4:{s:2:\"id\";s:28:\"acss_import_align-items--end\";s:4:\"name\";s:16:\"align-items--end\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:608;a:4:{s:2:\"id\";s:31:\"acss_import_align-items--center\";s:4:\"name\";s:19:\"align-items--center\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:609;a:4:{s:2:\"id\";s:33:\"acss_import_align-items--baseline\";s:4:\"name\";s:21:\"align-items--baseline\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:610;a:4:{s:2:\"id\";s:32:\"acss_import_align-items--stretch\";s:4:\"name\";s:20:\"align-items--stretch\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:611;a:4:{s:2:\"id\";s:23:\"acss_import_self--start\";s:4:\"name\";s:11:\"self--start\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:612;a:4:{s:2:\"id\";s:21:\"acss_import_self--end\";s:4:\"name\";s:9:\"self--end\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:613;a:4:{s:2:\"id\";s:24:\"acss_import_self--center\";s:4:\"name\";s:12:\"self--center\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:614;a:4:{s:2:\"id\";s:25:\"acss_import_self--stretch\";s:4:\"name\";s:13:\"self--stretch\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:615;a:4:{s:2:\"id\";s:19:\"acss_import_stretch\";s:4:\"name\";s:7:\"stretch\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:616;a:4:{s:2:\"id\";s:21:\"acss_import_width--xs\";s:4:\"name\";s:9:\"width--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:617;a:4:{s:2:\"id\";s:20:\"acss_import_width--s\";s:4:\"name\";s:8:\"width--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:618;a:4:{s:2:\"id\";s:20:\"acss_import_width--m\";s:4:\"name\";s:8:\"width--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:619;a:4:{s:2:\"id\";s:20:\"acss_import_width--l\";s:4:\"name\";s:8:\"width--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:620;a:4:{s:2:\"id\";s:21:\"acss_import_width--xl\";s:4:\"name\";s:9:\"width--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:621;a:4:{s:2:\"id\";s:22:\"acss_import_width--xxl\";s:4:\"name\";s:10:\"width--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:622;a:4:{s:2:\"id\";s:25:\"acss_import_width--vp-max\";s:4:\"name\";s:13:\"width--vp-max\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:623;a:4:{s:2:\"id\";s:26:\"acss_import_width--content\";s:4:\"name\";s:14:\"width--content\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:624;a:4:{s:2:\"id\";s:21:\"acss_import_width--50\";s:4:\"name\";s:9:\"width--50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:625;a:4:{s:2:\"id\";s:23:\"acss_import_width--full\";s:4:\"name\";s:11:\"width--full\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:626;a:4:{s:2:\"id\";s:23:\"acss_import_width--auto\";s:4:\"name\";s:11:\"width--auto\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:627;a:4:{s:2:\"id\";s:25:\"acss_import_content-width\";s:4:\"name\";s:13:\"content-width\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:628;a:4:{s:2:\"id\";s:31:\"acss_import_content-width--safe\";s:4:\"name\";s:19:\"content-width--safe\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:629;a:4:{s:2:\"id\";s:24:\"acss_import_height--full\";s:4:\"name\";s:12:\"height--full\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:630;a:4:{s:2:\"id\";s:26:\"acss_import_height--vp-max\";s:4:\"name\";s:14:\"height--vp-max\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:631;a:4:{s:2:\"id\";s:27:\"acss_import_height--content\";s:4:\"name\";s:15:\"height--content\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:632;a:4:{s:2:\"id\";s:24:\"acss_import_height--auto\";s:4:\"name\";s:12:\"height--auto\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:633;a:4:{s:2:\"id\";s:22:\"acss_import_height--20\";s:4:\"name\";s:10:\"height--20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:634;a:4:{s:2:\"id\";s:26:\"acss_import_height--xxl-20\";s:4:\"name\";s:14:\"height--xxl-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:635;a:4:{s:2:\"id\";s:25:\"acss_import_height--xl-20\";s:4:\"name\";s:13:\"height--xl-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:636;a:4:{s:2:\"id\";s:24:\"acss_import_height--l-20\";s:4:\"name\";s:12:\"height--l-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:637;a:4:{s:2:\"id\";s:24:\"acss_import_height--m-20\";s:4:\"name\";s:12:\"height--m-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:638;a:4:{s:2:\"id\";s:24:\"acss_import_height--s-20\";s:4:\"name\";s:12:\"height--s-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:639;a:4:{s:2:\"id\";s:25:\"acss_import_height--xs-20\";s:4:\"name\";s:13:\"height--xs-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:640;a:4:{s:2:\"id\";s:22:\"acss_import_height--30\";s:4:\"name\";s:10:\"height--30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:641;a:4:{s:2:\"id\";s:26:\"acss_import_height--xxl-30\";s:4:\"name\";s:14:\"height--xxl-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:642;a:4:{s:2:\"id\";s:25:\"acss_import_height--xl-30\";s:4:\"name\";s:13:\"height--xl-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:643;a:4:{s:2:\"id\";s:24:\"acss_import_height--l-30\";s:4:\"name\";s:12:\"height--l-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:644;a:4:{s:2:\"id\";s:24:\"acss_import_height--m-30\";s:4:\"name\";s:12:\"height--m-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:645;a:4:{s:2:\"id\";s:24:\"acss_import_height--s-30\";s:4:\"name\";s:12:\"height--s-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:646;a:4:{s:2:\"id\";s:25:\"acss_import_height--xs-30\";s:4:\"name\";s:13:\"height--xs-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:647;a:4:{s:2:\"id\";s:22:\"acss_import_height--40\";s:4:\"name\";s:10:\"height--40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:648;a:4:{s:2:\"id\";s:26:\"acss_import_height--xxl-40\";s:4:\"name\";s:14:\"height--xxl-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:649;a:4:{s:2:\"id\";s:25:\"acss_import_height--xl-40\";s:4:\"name\";s:13:\"height--xl-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:650;a:4:{s:2:\"id\";s:24:\"acss_import_height--l-40\";s:4:\"name\";s:12:\"height--l-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:651;a:4:{s:2:\"id\";s:24:\"acss_import_height--m-40\";s:4:\"name\";s:12:\"height--m-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:652;a:4:{s:2:\"id\";s:24:\"acss_import_height--s-40\";s:4:\"name\";s:12:\"height--s-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:653;a:4:{s:2:\"id\";s:25:\"acss_import_height--xs-40\";s:4:\"name\";s:13:\"height--xs-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:654;a:4:{s:2:\"id\";s:22:\"acss_import_height--50\";s:4:\"name\";s:10:\"height--50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:655;a:4:{s:2:\"id\";s:26:\"acss_import_height--xxl-50\";s:4:\"name\";s:14:\"height--xxl-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:656;a:4:{s:2:\"id\";s:25:\"acss_import_height--xl-50\";s:4:\"name\";s:13:\"height--xl-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:657;a:4:{s:2:\"id\";s:24:\"acss_import_height--l-50\";s:4:\"name\";s:12:\"height--l-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:658;a:4:{s:2:\"id\";s:24:\"acss_import_height--m-50\";s:4:\"name\";s:12:\"height--m-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:659;a:4:{s:2:\"id\";s:24:\"acss_import_height--s-50\";s:4:\"name\";s:12:\"height--s-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:660;a:4:{s:2:\"id\";s:25:\"acss_import_height--xs-50\";s:4:\"name\";s:13:\"height--xs-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:661;a:4:{s:2:\"id\";s:22:\"acss_import_height--60\";s:4:\"name\";s:10:\"height--60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:662;a:4:{s:2:\"id\";s:26:\"acss_import_height--xxl-60\";s:4:\"name\";s:14:\"height--xxl-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:663;a:4:{s:2:\"id\";s:25:\"acss_import_height--xl-60\";s:4:\"name\";s:13:\"height--xl-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:664;a:4:{s:2:\"id\";s:24:\"acss_import_height--l-60\";s:4:\"name\";s:12:\"height--l-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:665;a:4:{s:2:\"id\";s:24:\"acss_import_height--m-60\";s:4:\"name\";s:12:\"height--m-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:666;a:4:{s:2:\"id\";s:24:\"acss_import_height--s-60\";s:4:\"name\";s:12:\"height--s-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:667;a:4:{s:2:\"id\";s:25:\"acss_import_height--xs-60\";s:4:\"name\";s:13:\"height--xs-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:668;a:4:{s:2:\"id\";s:22:\"acss_import_height--70\";s:4:\"name\";s:10:\"height--70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:669;a:4:{s:2:\"id\";s:26:\"acss_import_height--xxl-70\";s:4:\"name\";s:14:\"height--xxl-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:670;a:4:{s:2:\"id\";s:25:\"acss_import_height--xl-70\";s:4:\"name\";s:13:\"height--xl-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:671;a:4:{s:2:\"id\";s:24:\"acss_import_height--l-70\";s:4:\"name\";s:12:\"height--l-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:672;a:4:{s:2:\"id\";s:24:\"acss_import_height--m-70\";s:4:\"name\";s:12:\"height--m-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:673;a:4:{s:2:\"id\";s:24:\"acss_import_height--s-70\";s:4:\"name\";s:12:\"height--s-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:674;a:4:{s:2:\"id\";s:25:\"acss_import_height--xs-70\";s:4:\"name\";s:13:\"height--xs-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:675;a:4:{s:2:\"id\";s:22:\"acss_import_height--80\";s:4:\"name\";s:10:\"height--80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:676;a:4:{s:2:\"id\";s:26:\"acss_import_height--xxl-80\";s:4:\"name\";s:14:\"height--xxl-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:677;a:4:{s:2:\"id\";s:25:\"acss_import_height--xl-80\";s:4:\"name\";s:13:\"height--xl-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:678;a:4:{s:2:\"id\";s:24:\"acss_import_height--l-80\";s:4:\"name\";s:12:\"height--l-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:679;a:4:{s:2:\"id\";s:24:\"acss_import_height--m-80\";s:4:\"name\";s:12:\"height--m-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:680;a:4:{s:2:\"id\";s:24:\"acss_import_height--s-80\";s:4:\"name\";s:12:\"height--s-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:681;a:4:{s:2:\"id\";s:25:\"acss_import_height--xs-80\";s:4:\"name\";s:13:\"height--xs-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:682;a:4:{s:2:\"id\";s:22:\"acss_import_height--90\";s:4:\"name\";s:10:\"height--90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:683;a:4:{s:2:\"id\";s:26:\"acss_import_height--xxl-90\";s:4:\"name\";s:14:\"height--xxl-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:684;a:4:{s:2:\"id\";s:25:\"acss_import_height--xl-90\";s:4:\"name\";s:13:\"height--xl-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:685;a:4:{s:2:\"id\";s:24:\"acss_import_height--l-90\";s:4:\"name\";s:12:\"height--l-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:686;a:4:{s:2:\"id\";s:24:\"acss_import_height--m-90\";s:4:\"name\";s:12:\"height--m-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:687;a:4:{s:2:\"id\";s:24:\"acss_import_height--s-90\";s:4:\"name\";s:12:\"height--s-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:688;a:4:{s:2:\"id\";s:25:\"acss_import_height--xs-90\";s:4:\"name\";s:13:\"height--xs-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:689;a:4:{s:2:\"id\";s:23:\"acss_import_height--100\";s:4:\"name\";s:11:\"height--100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:690;a:4:{s:2:\"id\";s:27:\"acss_import_height--xxl-100\";s:4:\"name\";s:15:\"height--xxl-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:691;a:4:{s:2:\"id\";s:26:\"acss_import_height--xl-100\";s:4:\"name\";s:14:\"height--xl-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:692;a:4:{s:2:\"id\";s:25:\"acss_import_height--l-100\";s:4:\"name\";s:13:\"height--l-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:693;a:4:{s:2:\"id\";s:25:\"acss_import_height--m-100\";s:4:\"name\";s:13:\"height--m-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:694;a:4:{s:2:\"id\";s:25:\"acss_import_height--s-100\";s:4:\"name\";s:13:\"height--s-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:695;a:4:{s:2:\"id\";s:26:\"acss_import_height--xs-100\";s:4:\"name\";s:14:\"height--xs-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:696;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--full\";s:4:\"name\";s:16:\"max-height--full\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:697;a:4:{s:2:\"id\";s:26:\"acss_import_max-height--20\";s:4:\"name\";s:14:\"max-height--20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:698;a:4:{s:2:\"id\";s:30:\"acss_import_max-height--xxl-20\";s:4:\"name\";s:18:\"max-height--xxl-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:699;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xl-20\";s:4:\"name\";s:17:\"max-height--xl-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:700;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--l-20\";s:4:\"name\";s:16:\"max-height--l-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:701;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--m-20\";s:4:\"name\";s:16:\"max-height--m-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:702;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--s-20\";s:4:\"name\";s:16:\"max-height--s-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:703;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xs-20\";s:4:\"name\";s:17:\"max-height--xs-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:704;a:4:{s:2:\"id\";s:26:\"acss_import_max-height--30\";s:4:\"name\";s:14:\"max-height--30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:705;a:4:{s:2:\"id\";s:30:\"acss_import_max-height--xxl-30\";s:4:\"name\";s:18:\"max-height--xxl-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:706;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xl-30\";s:4:\"name\";s:17:\"max-height--xl-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:707;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--l-30\";s:4:\"name\";s:16:\"max-height--l-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:708;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--m-30\";s:4:\"name\";s:16:\"max-height--m-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:709;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--s-30\";s:4:\"name\";s:16:\"max-height--s-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:710;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xs-30\";s:4:\"name\";s:17:\"max-height--xs-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:711;a:4:{s:2:\"id\";s:26:\"acss_import_max-height--40\";s:4:\"name\";s:14:\"max-height--40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:712;a:4:{s:2:\"id\";s:30:\"acss_import_max-height--xxl-40\";s:4:\"name\";s:18:\"max-height--xxl-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:713;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xl-40\";s:4:\"name\";s:17:\"max-height--xl-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:714;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--l-40\";s:4:\"name\";s:16:\"max-height--l-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:715;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--m-40\";s:4:\"name\";s:16:\"max-height--m-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:716;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--s-40\";s:4:\"name\";s:16:\"max-height--s-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:717;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xs-40\";s:4:\"name\";s:17:\"max-height--xs-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:718;a:4:{s:2:\"id\";s:26:\"acss_import_max-height--50\";s:4:\"name\";s:14:\"max-height--50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:719;a:4:{s:2:\"id\";s:30:\"acss_import_max-height--xxl-50\";s:4:\"name\";s:18:\"max-height--xxl-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:720;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xl-50\";s:4:\"name\";s:17:\"max-height--xl-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:721;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--l-50\";s:4:\"name\";s:16:\"max-height--l-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:722;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--m-50\";s:4:\"name\";s:16:\"max-height--m-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:723;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--s-50\";s:4:\"name\";s:16:\"max-height--s-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:724;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xs-50\";s:4:\"name\";s:17:\"max-height--xs-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:725;a:4:{s:2:\"id\";s:26:\"acss_import_max-height--60\";s:4:\"name\";s:14:\"max-height--60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:726;a:4:{s:2:\"id\";s:30:\"acss_import_max-height--xxl-60\";s:4:\"name\";s:18:\"max-height--xxl-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:727;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xl-60\";s:4:\"name\";s:17:\"max-height--xl-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:728;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--l-60\";s:4:\"name\";s:16:\"max-height--l-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:729;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--m-60\";s:4:\"name\";s:16:\"max-height--m-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:730;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--s-60\";s:4:\"name\";s:16:\"max-height--s-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:731;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xs-60\";s:4:\"name\";s:17:\"max-height--xs-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:732;a:4:{s:2:\"id\";s:26:\"acss_import_max-height--70\";s:4:\"name\";s:14:\"max-height--70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:733;a:4:{s:2:\"id\";s:30:\"acss_import_max-height--xxl-70\";s:4:\"name\";s:18:\"max-height--xxl-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:734;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xl-70\";s:4:\"name\";s:17:\"max-height--xl-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:735;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--l-70\";s:4:\"name\";s:16:\"max-height--l-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:736;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--m-70\";s:4:\"name\";s:16:\"max-height--m-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:737;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--s-70\";s:4:\"name\";s:16:\"max-height--s-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:738;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xs-70\";s:4:\"name\";s:17:\"max-height--xs-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:739;a:4:{s:2:\"id\";s:26:\"acss_import_max-height--80\";s:4:\"name\";s:14:\"max-height--80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:740;a:4:{s:2:\"id\";s:30:\"acss_import_max-height--xxl-80\";s:4:\"name\";s:18:\"max-height--xxl-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:741;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xl-80\";s:4:\"name\";s:17:\"max-height--xl-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:742;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--l-80\";s:4:\"name\";s:16:\"max-height--l-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:743;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--m-80\";s:4:\"name\";s:16:\"max-height--m-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:744;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--s-80\";s:4:\"name\";s:16:\"max-height--s-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:745;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xs-80\";s:4:\"name\";s:17:\"max-height--xs-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:746;a:4:{s:2:\"id\";s:26:\"acss_import_max-height--90\";s:4:\"name\";s:14:\"max-height--90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:747;a:4:{s:2:\"id\";s:30:\"acss_import_max-height--xxl-90\";s:4:\"name\";s:18:\"max-height--xxl-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:748;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xl-90\";s:4:\"name\";s:17:\"max-height--xl-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:749;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--l-90\";s:4:\"name\";s:16:\"max-height--l-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:750;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--m-90\";s:4:\"name\";s:16:\"max-height--m-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:751;a:4:{s:2:\"id\";s:28:\"acss_import_max-height--s-90\";s:4:\"name\";s:16:\"max-height--s-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:752;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--xs-90\";s:4:\"name\";s:17:\"max-height--xs-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:753;a:4:{s:2:\"id\";s:27:\"acss_import_max-height--100\";s:4:\"name\";s:15:\"max-height--100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:754;a:4:{s:2:\"id\";s:31:\"acss_import_max-height--xxl-100\";s:4:\"name\";s:19:\"max-height--xxl-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:755;a:4:{s:2:\"id\";s:30:\"acss_import_max-height--xl-100\";s:4:\"name\";s:18:\"max-height--xl-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:756;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--l-100\";s:4:\"name\";s:17:\"max-height--l-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:757;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--m-100\";s:4:\"name\";s:17:\"max-height--m-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:758;a:4:{s:2:\"id\";s:29:\"acss_import_max-height--s-100\";s:4:\"name\";s:17:\"max-height--s-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:759;a:4:{s:2:\"id\";s:30:\"acss_import_max-height--xs-100\";s:4:\"name\";s:18:\"max-height--xs-100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:760;a:4:{s:2:\"id\";s:27:\"acss_import_display--inline\";s:4:\"name\";s:15:\"display--inline\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:761;a:4:{s:2:\"id\";s:29:\"acss_import_display--contents\";s:4:\"name\";s:17:\"display--contents\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:762;a:4:{s:2:\"id\";s:33:\"acss_import_display--inline-block\";s:4:\"name\";s:21:\"display--inline-block\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:763;a:4:{s:2:\"id\";s:32:\"acss_import_display--inline-flex\";s:4:\"name\";s:20:\"display--inline-flex\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:764;a:4:{s:2:\"id\";s:30:\"acss_import_display--list-item\";s:4:\"name\";s:18:\"display--list-item\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:765;a:4:{s:2:\"id\";s:26:\"acss_import_display--block\";s:4:\"name\";s:14:\"display--block\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:766;a:4:{s:2:\"id\";s:29:\"acss_import_display--xs-block\";s:4:\"name\";s:17:\"display--xs-block\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:767;a:4:{s:2:\"id\";s:28:\"acss_import_display--s-block\";s:4:\"name\";s:16:\"display--s-block\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:768;a:4:{s:2:\"id\";s:28:\"acss_import_display--m-block\";s:4:\"name\";s:16:\"display--m-block\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:769;a:4:{s:2:\"id\";s:28:\"acss_import_display--l-block\";s:4:\"name\";s:16:\"display--l-block\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:770;a:4:{s:2:\"id\";s:29:\"acss_import_display--xl-block\";s:4:\"name\";s:17:\"display--xl-block\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:771;a:4:{s:2:\"id\";s:30:\"acss_import_display--xxl-block\";s:4:\"name\";s:18:\"display--xxl-block\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:772;a:4:{s:2:\"id\";s:25:\"acss_import_display--none\";s:4:\"name\";s:13:\"display--none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:773;a:4:{s:2:\"id\";s:28:\"acss_import_display--xs-none\";s:4:\"name\";s:16:\"display--xs-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:774;a:4:{s:2:\"id\";s:27:\"acss_import_display--s-none\";s:4:\"name\";s:15:\"display--s-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:775;a:4:{s:2:\"id\";s:27:\"acss_import_display--m-none\";s:4:\"name\";s:15:\"display--m-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:776;a:4:{s:2:\"id\";s:27:\"acss_import_display--l-none\";s:4:\"name\";s:15:\"display--l-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:777;a:4:{s:2:\"id\";s:28:\"acss_import_display--xl-none\";s:4:\"name\";s:16:\"display--xl-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:778;a:4:{s:2:\"id\";s:29:\"acss_import_display--xxl-none\";s:4:\"name\";s:17:\"display--xxl-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:779;a:4:{s:2:\"id\";s:30:\"acss_import_visibility--hidden\";s:4:\"name\";s:18:\"visibility--hidden\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:780;a:4:{s:2:\"id\";s:33:\"acss_import_visibility--xs-hidden\";s:4:\"name\";s:21:\"visibility--xs-hidden\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:781;a:4:{s:2:\"id\";s:32:\"acss_import_visibility--s-hidden\";s:4:\"name\";s:20:\"visibility--s-hidden\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:782;a:4:{s:2:\"id\";s:32:\"acss_import_visibility--m-hidden\";s:4:\"name\";s:20:\"visibility--m-hidden\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:783;a:4:{s:2:\"id\";s:32:\"acss_import_visibility--l-hidden\";s:4:\"name\";s:20:\"visibility--l-hidden\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:784;a:4:{s:2:\"id\";s:33:\"acss_import_visibility--xl-hidden\";s:4:\"name\";s:21:\"visibility--xl-hidden\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:785;a:4:{s:2:\"id\";s:34:\"acss_import_visibility--xxl-hidden\";s:4:\"name\";s:22:\"visibility--xxl-hidden\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:786;a:4:{s:2:\"id\";s:31:\"acss_import_visibility--visible\";s:4:\"name\";s:19:\"visibility--visible\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:787;a:4:{s:2:\"id\";s:34:\"acss_import_visibility--xs-visible\";s:4:\"name\";s:22:\"visibility--xs-visible\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:788;a:4:{s:2:\"id\";s:33:\"acss_import_visibility--s-visible\";s:4:\"name\";s:21:\"visibility--s-visible\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:789;a:4:{s:2:\"id\";s:33:\"acss_import_visibility--m-visible\";s:4:\"name\";s:21:\"visibility--m-visible\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:790;a:4:{s:2:\"id\";s:33:\"acss_import_visibility--l-visible\";s:4:\"name\";s:21:\"visibility--l-visible\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:791;a:4:{s:2:\"id\";s:34:\"acss_import_visibility--xl-visible\";s:4:\"name\";s:22:\"visibility--xl-visible\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:792;a:4:{s:2:\"id\";s:35:\"acss_import_visibility--xxl-visible\";s:4:\"name\";s:23:\"visibility--xxl-visible\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:793;a:4:{s:2:\"id\";s:24:\"acss_import_center--self\";s:4:\"name\";s:12:\"center--self\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:794;a:4:{s:2:\"id\";s:23:\"acss_import_center--all\";s:4:\"name\";s:11:\"center--all\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:795;a:4:{s:2:\"id\";s:26:\"acss_import_center--all-xs\";s:4:\"name\";s:14:\"center--all-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:796;a:4:{s:2:\"id\";s:25:\"acss_import_center--all-s\";s:4:\"name\";s:13:\"center--all-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:797;a:4:{s:2:\"id\";s:25:\"acss_import_center--all-m\";s:4:\"name\";s:13:\"center--all-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:798;a:4:{s:2:\"id\";s:25:\"acss_import_center--all-l\";s:4:\"name\";s:13:\"center--all-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:799;a:4:{s:2:\"id\";s:26:\"acss_import_center--all-xl\";s:4:\"name\";s:14:\"center--all-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:800;a:4:{s:2:\"id\";s:27:\"acss_import_center--all-xxl\";s:4:\"name\";s:15:\"center--all-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:801;a:4:{s:2:\"id\";s:21:\"acss_import_center--y\";s:4:\"name\";s:9:\"center--y\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:802;a:4:{s:2:\"id\";s:24:\"acss_import_center--y-xs\";s:4:\"name\";s:12:\"center--y-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:803;a:4:{s:2:\"id\";s:23:\"acss_import_center--y-s\";s:4:\"name\";s:11:\"center--y-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:804;a:4:{s:2:\"id\";s:23:\"acss_import_center--y-m\";s:4:\"name\";s:11:\"center--y-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:805;a:4:{s:2:\"id\";s:23:\"acss_import_center--y-l\";s:4:\"name\";s:11:\"center--y-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:806;a:4:{s:2:\"id\";s:24:\"acss_import_center--y-xl\";s:4:\"name\";s:12:\"center--y-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:807;a:4:{s:2:\"id\";s:25:\"acss_import_center--y-xxl\";s:4:\"name\";s:13:\"center--y-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:808;a:4:{s:2:\"id\";s:21:\"acss_import_center--x\";s:4:\"name\";s:9:\"center--x\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:809;a:4:{s:2:\"id\";s:24:\"acss_import_center--x-xs\";s:4:\"name\";s:12:\"center--x-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:810;a:4:{s:2:\"id\";s:23:\"acss_import_center--x-s\";s:4:\"name\";s:11:\"center--x-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:811;a:4:{s:2:\"id\";s:23:\"acss_import_center--x-m\";s:4:\"name\";s:11:\"center--x-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:812;a:4:{s:2:\"id\";s:23:\"acss_import_center--x-l\";s:4:\"name\";s:11:\"center--x-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:813;a:4:{s:2:\"id\";s:24:\"acss_import_center--x-xl\";s:4:\"name\";s:12:\"center--x-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:814;a:4:{s:2:\"id\";s:25:\"acss_import_center--x-xxl\";s:4:\"name\";s:13:\"center--x-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:815;a:4:{s:2:\"id\";s:24:\"acss_import_center--left\";s:4:\"name\";s:12:\"center--left\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:816;a:4:{s:2:\"id\";s:27:\"acss_import_center--left-xs\";s:4:\"name\";s:15:\"center--left-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:817;a:4:{s:2:\"id\";s:26:\"acss_import_center--left-s\";s:4:\"name\";s:14:\"center--left-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:818;a:4:{s:2:\"id\";s:26:\"acss_import_center--left-m\";s:4:\"name\";s:14:\"center--left-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:819;a:4:{s:2:\"id\";s:26:\"acss_import_center--left-l\";s:4:\"name\";s:14:\"center--left-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:820;a:4:{s:2:\"id\";s:27:\"acss_import_center--left-xl\";s:4:\"name\";s:15:\"center--left-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:821;a:4:{s:2:\"id\";s:28:\"acss_import_center--left-xxl\";s:4:\"name\";s:16:\"center--left-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:822;a:4:{s:2:\"id\";s:25:\"acss_import_center--right\";s:4:\"name\";s:13:\"center--right\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:823;a:4:{s:2:\"id\";s:28:\"acss_import_center--right-xs\";s:4:\"name\";s:16:\"center--right-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:824;a:4:{s:2:\"id\";s:27:\"acss_import_center--right-s\";s:4:\"name\";s:15:\"center--right-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:825;a:4:{s:2:\"id\";s:27:\"acss_import_center--right-m\";s:4:\"name\";s:15:\"center--right-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:826;a:4:{s:2:\"id\";s:27:\"acss_import_center--right-l\";s:4:\"name\";s:15:\"center--right-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:827;a:4:{s:2:\"id\";s:28:\"acss_import_center--right-xl\";s:4:\"name\";s:16:\"center--right-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:828;a:4:{s:2:\"id\";s:29:\"acss_import_center--right-xxl\";s:4:\"name\";s:17:\"center--right-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:829;a:4:{s:2:\"id\";s:23:\"acss_import_center--top\";s:4:\"name\";s:11:\"center--top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:830;a:4:{s:2:\"id\";s:26:\"acss_import_center--top-xs\";s:4:\"name\";s:14:\"center--top-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:831;a:4:{s:2:\"id\";s:25:\"acss_import_center--top-s\";s:4:\"name\";s:13:\"center--top-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:832;a:4:{s:2:\"id\";s:25:\"acss_import_center--top-m\";s:4:\"name\";s:13:\"center--top-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:833;a:4:{s:2:\"id\";s:25:\"acss_import_center--top-l\";s:4:\"name\";s:13:\"center--top-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:834;a:4:{s:2:\"id\";s:26:\"acss_import_center--top-xl\";s:4:\"name\";s:14:\"center--top-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:835;a:4:{s:2:\"id\";s:27:\"acss_import_center--top-xxl\";s:4:\"name\";s:15:\"center--top-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:836;a:4:{s:2:\"id\";s:26:\"acss_import_center--bottom\";s:4:\"name\";s:14:\"center--bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:837;a:4:{s:2:\"id\";s:29:\"acss_import_center--bottom-xs\";s:4:\"name\";s:17:\"center--bottom-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:838;a:4:{s:2:\"id\";s:28:\"acss_import_center--bottom-s\";s:4:\"name\";s:16:\"center--bottom-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:839;a:4:{s:2:\"id\";s:28:\"acss_import_center--bottom-m\";s:4:\"name\";s:16:\"center--bottom-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:840;a:4:{s:2:\"id\";s:28:\"acss_import_center--bottom-l\";s:4:\"name\";s:16:\"center--bottom-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:841;a:4:{s:2:\"id\";s:29:\"acss_import_center--bottom-xl\";s:4:\"name\";s:17:\"center--bottom-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:842;a:4:{s:2:\"id\";s:30:\"acss_import_center--bottom-xxl\";s:4:\"name\";s:18:\"center--bottom-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:843;a:4:{s:2:\"id\";s:21:\"acss_import_z--bottom\";s:4:\"name\";s:9:\"z--bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:844;a:4:{s:2:\"id\";s:24:\"acss_import_z--xs-bottom\";s:4:\"name\";s:12:\"z--xs-bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:845;a:4:{s:2:\"id\";s:23:\"acss_import_z--s-bottom\";s:4:\"name\";s:11:\"z--s-bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:846;a:4:{s:2:\"id\";s:23:\"acss_import_z--m-bottom\";s:4:\"name\";s:11:\"z--m-bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:847;a:4:{s:2:\"id\";s:23:\"acss_import_z--l-bottom\";s:4:\"name\";s:11:\"z--l-bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:848;a:4:{s:2:\"id\";s:24:\"acss_import_z--xl-bottom\";s:4:\"name\";s:12:\"z--xl-bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:849;a:4:{s:2:\"id\";s:25:\"acss_import_z--xxl-bottom\";s:4:\"name\";s:13:\"z--xxl-bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:850;a:4:{s:2:\"id\";s:16:\"acss_import_z--0\";s:4:\"name\";s:4:\"z--0\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:851;a:4:{s:2:\"id\";s:19:\"acss_import_z--xs-0\";s:4:\"name\";s:7:\"z--xs-0\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:852;a:4:{s:2:\"id\";s:18:\"acss_import_z--s-0\";s:4:\"name\";s:6:\"z--s-0\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:853;a:4:{s:2:\"id\";s:18:\"acss_import_z--m-0\";s:4:\"name\";s:6:\"z--m-0\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:854;a:4:{s:2:\"id\";s:18:\"acss_import_z--l-0\";s:4:\"name\";s:6:\"z--l-0\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:855;a:4:{s:2:\"id\";s:19:\"acss_import_z--xl-0\";s:4:\"name\";s:7:\"z--xl-0\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:856;a:4:{s:2:\"id\";s:20:\"acss_import_z--xxl-0\";s:4:\"name\";s:8:\"z--xxl-0\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:857;a:4:{s:2:\"id\";s:17:\"acss_import_z--10\";s:4:\"name\";s:5:\"z--10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:858;a:4:{s:2:\"id\";s:20:\"acss_import_z--xs-10\";s:4:\"name\";s:8:\"z--xs-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:859;a:4:{s:2:\"id\";s:19:\"acss_import_z--s-10\";s:4:\"name\";s:7:\"z--s-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:860;a:4:{s:2:\"id\";s:19:\"acss_import_z--m-10\";s:4:\"name\";s:7:\"z--m-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:861;a:4:{s:2:\"id\";s:19:\"acss_import_z--l-10\";s:4:\"name\";s:7:\"z--l-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:862;a:4:{s:2:\"id\";s:20:\"acss_import_z--xl-10\";s:4:\"name\";s:8:\"z--xl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:863;a:4:{s:2:\"id\";s:21:\"acss_import_z--xxl-10\";s:4:\"name\";s:9:\"z--xxl-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:864;a:4:{s:2:\"id\";s:17:\"acss_import_z--20\";s:4:\"name\";s:5:\"z--20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:865;a:4:{s:2:\"id\";s:20:\"acss_import_z--xs-20\";s:4:\"name\";s:8:\"z--xs-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:866;a:4:{s:2:\"id\";s:19:\"acss_import_z--s-20\";s:4:\"name\";s:7:\"z--s-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:867;a:4:{s:2:\"id\";s:19:\"acss_import_z--m-20\";s:4:\"name\";s:7:\"z--m-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:868;a:4:{s:2:\"id\";s:19:\"acss_import_z--l-20\";s:4:\"name\";s:7:\"z--l-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:869;a:4:{s:2:\"id\";s:20:\"acss_import_z--xl-20\";s:4:\"name\";s:8:\"z--xl-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:870;a:4:{s:2:\"id\";s:21:\"acss_import_z--xxl-20\";s:4:\"name\";s:9:\"z--xxl-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:871;a:4:{s:2:\"id\";s:17:\"acss_import_z--30\";s:4:\"name\";s:5:\"z--30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:872;a:4:{s:2:\"id\";s:20:\"acss_import_z--xs-30\";s:4:\"name\";s:8:\"z--xs-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:873;a:4:{s:2:\"id\";s:19:\"acss_import_z--s-30\";s:4:\"name\";s:7:\"z--s-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:874;a:4:{s:2:\"id\";s:19:\"acss_import_z--m-30\";s:4:\"name\";s:7:\"z--m-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:875;a:4:{s:2:\"id\";s:19:\"acss_import_z--l-30\";s:4:\"name\";s:7:\"z--l-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:876;a:4:{s:2:\"id\";s:20:\"acss_import_z--xl-30\";s:4:\"name\";s:8:\"z--xl-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:877;a:4:{s:2:\"id\";s:21:\"acss_import_z--xxl-30\";s:4:\"name\";s:9:\"z--xxl-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:878;a:4:{s:2:\"id\";s:17:\"acss_import_z--40\";s:4:\"name\";s:5:\"z--40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:879;a:4:{s:2:\"id\";s:20:\"acss_import_z--xs-40\";s:4:\"name\";s:8:\"z--xs-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:880;a:4:{s:2:\"id\";s:19:\"acss_import_z--s-40\";s:4:\"name\";s:7:\"z--s-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:881;a:4:{s:2:\"id\";s:19:\"acss_import_z--m-40\";s:4:\"name\";s:7:\"z--m-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:882;a:4:{s:2:\"id\";s:19:\"acss_import_z--l-40\";s:4:\"name\";s:7:\"z--l-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:883;a:4:{s:2:\"id\";s:20:\"acss_import_z--xl-40\";s:4:\"name\";s:8:\"z--xl-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:884;a:4:{s:2:\"id\";s:21:\"acss_import_z--xxl-40\";s:4:\"name\";s:9:\"z--xxl-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:885;a:4:{s:2:\"id\";s:17:\"acss_import_z--50\";s:4:\"name\";s:5:\"z--50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:886;a:4:{s:2:\"id\";s:20:\"acss_import_z--xs-50\";s:4:\"name\";s:8:\"z--xs-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:887;a:4:{s:2:\"id\";s:19:\"acss_import_z--s-50\";s:4:\"name\";s:7:\"z--s-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:888;a:4:{s:2:\"id\";s:19:\"acss_import_z--m-50\";s:4:\"name\";s:7:\"z--m-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:889;a:4:{s:2:\"id\";s:19:\"acss_import_z--l-50\";s:4:\"name\";s:7:\"z--l-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:890;a:4:{s:2:\"id\";s:20:\"acss_import_z--xl-50\";s:4:\"name\";s:8:\"z--xl-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:891;a:4:{s:2:\"id\";s:21:\"acss_import_z--xxl-50\";s:4:\"name\";s:9:\"z--xxl-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:892;a:4:{s:2:\"id\";s:17:\"acss_import_z--60\";s:4:\"name\";s:5:\"z--60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:893;a:4:{s:2:\"id\";s:20:\"acss_import_z--xs-60\";s:4:\"name\";s:8:\"z--xs-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:894;a:4:{s:2:\"id\";s:19:\"acss_import_z--s-60\";s:4:\"name\";s:7:\"z--s-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:895;a:4:{s:2:\"id\";s:19:\"acss_import_z--m-60\";s:4:\"name\";s:7:\"z--m-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:896;a:4:{s:2:\"id\";s:19:\"acss_import_z--l-60\";s:4:\"name\";s:7:\"z--l-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:897;a:4:{s:2:\"id\";s:20:\"acss_import_z--xl-60\";s:4:\"name\";s:8:\"z--xl-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:898;a:4:{s:2:\"id\";s:21:\"acss_import_z--xxl-60\";s:4:\"name\";s:9:\"z--xxl-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:899;a:4:{s:2:\"id\";s:17:\"acss_import_z--70\";s:4:\"name\";s:5:\"z--70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:900;a:4:{s:2:\"id\";s:20:\"acss_import_z--xs-70\";s:4:\"name\";s:8:\"z--xs-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:901;a:4:{s:2:\"id\";s:19:\"acss_import_z--s-70\";s:4:\"name\";s:7:\"z--s-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:902;a:4:{s:2:\"id\";s:19:\"acss_import_z--m-70\";s:4:\"name\";s:7:\"z--m-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:903;a:4:{s:2:\"id\";s:19:\"acss_import_z--l-70\";s:4:\"name\";s:7:\"z--l-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:904;a:4:{s:2:\"id\";s:20:\"acss_import_z--xl-70\";s:4:\"name\";s:8:\"z--xl-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:905;a:4:{s:2:\"id\";s:21:\"acss_import_z--xxl-70\";s:4:\"name\";s:9:\"z--xxl-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:906;a:4:{s:2:\"id\";s:17:\"acss_import_z--80\";s:4:\"name\";s:5:\"z--80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:907;a:4:{s:2:\"id\";s:20:\"acss_import_z--xs-80\";s:4:\"name\";s:8:\"z--xs-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:908;a:4:{s:2:\"id\";s:19:\"acss_import_z--s-80\";s:4:\"name\";s:7:\"z--s-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:909;a:4:{s:2:\"id\";s:19:\"acss_import_z--m-80\";s:4:\"name\";s:7:\"z--m-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:910;a:4:{s:2:\"id\";s:19:\"acss_import_z--l-80\";s:4:\"name\";s:7:\"z--l-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:911;a:4:{s:2:\"id\";s:20:\"acss_import_z--xl-80\";s:4:\"name\";s:8:\"z--xl-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:912;a:4:{s:2:\"id\";s:21:\"acss_import_z--xxl-80\";s:4:\"name\";s:9:\"z--xxl-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:913;a:4:{s:2:\"id\";s:17:\"acss_import_z--90\";s:4:\"name\";s:5:\"z--90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:914;a:4:{s:2:\"id\";s:20:\"acss_import_z--xs-90\";s:4:\"name\";s:8:\"z--xs-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:915;a:4:{s:2:\"id\";s:19:\"acss_import_z--s-90\";s:4:\"name\";s:7:\"z--s-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:916;a:4:{s:2:\"id\";s:19:\"acss_import_z--m-90\";s:4:\"name\";s:7:\"z--m-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:917;a:4:{s:2:\"id\";s:19:\"acss_import_z--l-90\";s:4:\"name\";s:7:\"z--l-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:918;a:4:{s:2:\"id\";s:20:\"acss_import_z--xl-90\";s:4:\"name\";s:8:\"z--xl-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:919;a:4:{s:2:\"id\";s:21:\"acss_import_z--xxl-90\";s:4:\"name\";s:9:\"z--xxl-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:920;a:4:{s:2:\"id\";s:18:\"acss_import_z--top\";s:4:\"name\";s:6:\"z--top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:921;a:4:{s:2:\"id\";s:21:\"acss_import_z--xs-top\";s:4:\"name\";s:9:\"z--xs-top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:922;a:4:{s:2:\"id\";s:20:\"acss_import_z--s-top\";s:4:\"name\";s:8:\"z--s-top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:923;a:4:{s:2:\"id\";s:20:\"acss_import_z--m-top\";s:4:\"name\";s:8:\"z--m-top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:924;a:4:{s:2:\"id\";s:20:\"acss_import_z--l-top\";s:4:\"name\";s:8:\"z--l-top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:925;a:4:{s:2:\"id\";s:21:\"acss_import_z--xl-top\";s:4:\"name\";s:9:\"z--xl-top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:926;a:4:{s:2:\"id\";s:22:\"acss_import_z--xxl-top\";s:4:\"name\";s:10:\"z--xxl-top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:927;a:4:{s:2:\"id\";s:20:\"acss_import_relative\";s:4:\"name\";s:8:\"relative\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:928;a:4:{s:2:\"id\";s:18:\"acss_import_sticky\";s:4:\"name\";s:6:\"sticky\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:929;a:4:{s:2:\"id\";s:22:\"acss_import_sticky-top\";s:4:\"name\";s:10:\"sticky-top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:930;a:4:{s:2:\"id\";s:25:\"acss_import_sticky-top--s\";s:4:\"name\";s:13:\"sticky-top--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:931;a:4:{s:2:\"id\";s:25:\"acss_import_sticky-top--m\";s:4:\"name\";s:13:\"sticky-top--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:932;a:4:{s:2:\"id\";s:25:\"acss_import_sticky-top--l\";s:4:\"name\";s:13:\"sticky-top--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:933;a:4:{s:2:\"id\";s:30:\"acss_import_isolation--isolate\";s:4:\"name\";s:18:\"isolation--isolate\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:934;a:4:{s:2:\"id\";s:19:\"acss_import_contain\";s:4:\"name\";s:7:\"contain\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:935;a:4:{s:2:\"id\";s:22:\"acss_import_masonry--1\";s:4:\"name\";s:10:\"masonry--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:936;a:4:{s:2:\"id\";s:25:\"acss_import_masonry--xs-1\";s:4:\"name\";s:13:\"masonry--xs-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:937;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--s-1\";s:4:\"name\";s:12:\"masonry--s-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:938;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--m-1\";s:4:\"name\";s:12:\"masonry--m-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:939;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--l-1\";s:4:\"name\";s:12:\"masonry--l-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:940;a:4:{s:2:\"id\";s:25:\"acss_import_masonry--xl-1\";s:4:\"name\";s:13:\"masonry--xl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:941;a:4:{s:2:\"id\";s:26:\"acss_import_masonry--xxl-1\";s:4:\"name\";s:14:\"masonry--xxl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:942;a:4:{s:2:\"id\";s:22:\"acss_import_masonry--2\";s:4:\"name\";s:10:\"masonry--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:943;a:4:{s:2:\"id\";s:25:\"acss_import_masonry--xs-2\";s:4:\"name\";s:13:\"masonry--xs-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:944;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--s-2\";s:4:\"name\";s:12:\"masonry--s-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:945;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--m-2\";s:4:\"name\";s:12:\"masonry--m-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:946;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--l-2\";s:4:\"name\";s:12:\"masonry--l-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:947;a:4:{s:2:\"id\";s:25:\"acss_import_masonry--xl-2\";s:4:\"name\";s:13:\"masonry--xl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:948;a:4:{s:2:\"id\";s:26:\"acss_import_masonry--xxl-2\";s:4:\"name\";s:14:\"masonry--xxl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:949;a:4:{s:2:\"id\";s:22:\"acss_import_masonry--3\";s:4:\"name\";s:10:\"masonry--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:950;a:4:{s:2:\"id\";s:25:\"acss_import_masonry--xs-3\";s:4:\"name\";s:13:\"masonry--xs-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:951;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--s-3\";s:4:\"name\";s:12:\"masonry--s-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:952;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--m-3\";s:4:\"name\";s:12:\"masonry--m-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:953;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--l-3\";s:4:\"name\";s:12:\"masonry--l-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:954;a:4:{s:2:\"id\";s:25:\"acss_import_masonry--xl-3\";s:4:\"name\";s:13:\"masonry--xl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:955;a:4:{s:2:\"id\";s:26:\"acss_import_masonry--xxl-3\";s:4:\"name\";s:14:\"masonry--xxl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:956;a:4:{s:2:\"id\";s:22:\"acss_import_masonry--4\";s:4:\"name\";s:10:\"masonry--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:957;a:4:{s:2:\"id\";s:25:\"acss_import_masonry--xs-4\";s:4:\"name\";s:13:\"masonry--xs-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:958;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--s-4\";s:4:\"name\";s:12:\"masonry--s-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:959;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--m-4\";s:4:\"name\";s:12:\"masonry--m-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:960;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--l-4\";s:4:\"name\";s:12:\"masonry--l-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:961;a:4:{s:2:\"id\";s:25:\"acss_import_masonry--xl-4\";s:4:\"name\";s:13:\"masonry--xl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:962;a:4:{s:2:\"id\";s:26:\"acss_import_masonry--xxl-4\";s:4:\"name\";s:14:\"masonry--xxl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:963;a:4:{s:2:\"id\";s:22:\"acss_import_masonry--5\";s:4:\"name\";s:10:\"masonry--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:964;a:4:{s:2:\"id\";s:25:\"acss_import_masonry--xs-5\";s:4:\"name\";s:13:\"masonry--xs-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:965;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--s-5\";s:4:\"name\";s:12:\"masonry--s-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:966;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--m-5\";s:4:\"name\";s:12:\"masonry--m-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:967;a:4:{s:2:\"id\";s:24:\"acss_import_masonry--l-5\";s:4:\"name\";s:12:\"masonry--l-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:968;a:4:{s:2:\"id\";s:25:\"acss_import_masonry--xl-5\";s:4:\"name\";s:13:\"masonry--xl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:969;a:4:{s:2:\"id\";s:26:\"acss_import_masonry--xxl-5\";s:4:\"name\";s:14:\"masonry--xxl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:970;a:4:{s:2:\"id\";s:19:\"acss_import_pad--xs\";s:4:\"name\";s:7:\"pad--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:971;a:4:{s:2:\"id\";s:18:\"acss_import_pad--s\";s:4:\"name\";s:6:\"pad--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:972;a:4:{s:2:\"id\";s:18:\"acss_import_pad--m\";s:4:\"name\";s:6:\"pad--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:973;a:4:{s:2:\"id\";s:18:\"acss_import_pad--l\";s:4:\"name\";s:6:\"pad--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:974;a:4:{s:2:\"id\";s:19:\"acss_import_pad--xl\";s:4:\"name\";s:7:\"pad--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:975;a:4:{s:2:\"id\";s:20:\"acss_import_pad--xxl\";s:4:\"name\";s:8:\"pad--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:976;a:4:{s:2:\"id\";s:21:\"acss_import_pad--none\";s:4:\"name\";s:9:\"pad--none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:977;a:4:{s:2:\"id\";s:26:\"acss_import_pad-header--xs\";s:4:\"name\";s:14:\"pad-header--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:978;a:4:{s:2:\"id\";s:25:\"acss_import_pad-header--s\";s:4:\"name\";s:13:\"pad-header--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:979;a:4:{s:2:\"id\";s:25:\"acss_import_pad-header--m\";s:4:\"name\";s:13:\"pad-header--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:980;a:4:{s:2:\"id\";s:25:\"acss_import_pad-header--l\";s:4:\"name\";s:13:\"pad-header--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:981;a:4:{s:2:\"id\";s:26:\"acss_import_pad-header--xl\";s:4:\"name\";s:14:\"pad-header--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:982;a:4:{s:2:\"id\";s:27:\"acss_import_pad-header--xxl\";s:4:\"name\";s:15:\"pad-header--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:983;a:4:{s:2:\"id\";s:27:\"acss_import_pad-section--xs\";s:4:\"name\";s:15:\"pad-section--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:984;a:4:{s:2:\"id\";s:29:\"acss_import_pad-section--s-xs\";s:4:\"name\";s:17:\"pad-section--s-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:985;a:4:{s:2:\"id\";s:29:\"acss_import_pad-section--m-xs\";s:4:\"name\";s:17:\"pad-section--m-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:986;a:4:{s:2:\"id\";s:29:\"acss_import_pad-section--l-xs\";s:4:\"name\";s:17:\"pad-section--l-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:987;a:4:{s:2:\"id\";s:30:\"acss_import_pad-section--xl-xs\";s:4:\"name\";s:18:\"pad-section--xl-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:988;a:4:{s:2:\"id\";s:31:\"acss_import_pad-section--xxl-xs\";s:4:\"name\";s:19:\"pad-section--xxl-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:989;a:4:{s:2:\"id\";s:26:\"acss_import_pad-section--s\";s:4:\"name\";s:14:\"pad-section--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:990;a:4:{s:2:\"id\";s:28:\"acss_import_pad-section--s-s\";s:4:\"name\";s:16:\"pad-section--s-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:991;a:4:{s:2:\"id\";s:28:\"acss_import_pad-section--m-s\";s:4:\"name\";s:16:\"pad-section--m-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:992;a:4:{s:2:\"id\";s:28:\"acss_import_pad-section--l-s\";s:4:\"name\";s:16:\"pad-section--l-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:993;a:4:{s:2:\"id\";s:29:\"acss_import_pad-section--xl-s\";s:4:\"name\";s:17:\"pad-section--xl-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:994;a:4:{s:2:\"id\";s:30:\"acss_import_pad-section--xxl-s\";s:4:\"name\";s:18:\"pad-section--xxl-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:995;a:4:{s:2:\"id\";s:26:\"acss_import_pad-section--m\";s:4:\"name\";s:14:\"pad-section--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:996;a:4:{s:2:\"id\";s:28:\"acss_import_pad-section--s-m\";s:4:\"name\";s:16:\"pad-section--s-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:997;a:4:{s:2:\"id\";s:28:\"acss_import_pad-section--m-m\";s:4:\"name\";s:16:\"pad-section--m-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:998;a:4:{s:2:\"id\";s:28:\"acss_import_pad-section--l-m\";s:4:\"name\";s:16:\"pad-section--l-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:999;a:4:{s:2:\"id\";s:29:\"acss_import_pad-section--xl-m\";s:4:\"name\";s:17:\"pad-section--xl-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1000;a:4:{s:2:\"id\";s:30:\"acss_import_pad-section--xxl-m\";s:4:\"name\";s:18:\"pad-section--xxl-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1001;a:4:{s:2:\"id\";s:26:\"acss_import_pad-section--l\";s:4:\"name\";s:14:\"pad-section--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1002;a:4:{s:2:\"id\";s:28:\"acss_import_pad-section--s-l\";s:4:\"name\";s:16:\"pad-section--s-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1003;a:4:{s:2:\"id\";s:28:\"acss_import_pad-section--m-l\";s:4:\"name\";s:16:\"pad-section--m-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1004;a:4:{s:2:\"id\";s:28:\"acss_import_pad-section--l-l\";s:4:\"name\";s:16:\"pad-section--l-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1005;a:4:{s:2:\"id\";s:29:\"acss_import_pad-section--xl-l\";s:4:\"name\";s:17:\"pad-section--xl-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1006;a:4:{s:2:\"id\";s:30:\"acss_import_pad-section--xxl-l\";s:4:\"name\";s:18:\"pad-section--xxl-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1007;a:4:{s:2:\"id\";s:27:\"acss_import_pad-section--xl\";s:4:\"name\";s:15:\"pad-section--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1008;a:4:{s:2:\"id\";s:29:\"acss_import_pad-section--s-xl\";s:4:\"name\";s:17:\"pad-section--s-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1009;a:4:{s:2:\"id\";s:29:\"acss_import_pad-section--m-xl\";s:4:\"name\";s:17:\"pad-section--m-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1010;a:4:{s:2:\"id\";s:29:\"acss_import_pad-section--l-xl\";s:4:\"name\";s:17:\"pad-section--l-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1011;a:4:{s:2:\"id\";s:30:\"acss_import_pad-section--xl-xl\";s:4:\"name\";s:18:\"pad-section--xl-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1012;a:4:{s:2:\"id\";s:31:\"acss_import_pad-section--xxl-xl\";s:4:\"name\";s:19:\"pad-section--xxl-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1013;a:4:{s:2:\"id\";s:28:\"acss_import_pad-section--xxl\";s:4:\"name\";s:16:\"pad-section--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1014;a:4:{s:2:\"id\";s:30:\"acss_import_pad-section--s-xxl\";s:4:\"name\";s:18:\"pad-section--s-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1015;a:4:{s:2:\"id\";s:30:\"acss_import_pad-section--m-xxl\";s:4:\"name\";s:18:\"pad-section--m-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1016;a:4:{s:2:\"id\";s:30:\"acss_import_pad-section--l-xxl\";s:4:\"name\";s:18:\"pad-section--l-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1017;a:4:{s:2:\"id\";s:31:\"acss_import_pad-section--xl-xxl\";s:4:\"name\";s:19:\"pad-section--xl-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1018;a:4:{s:2:\"id\";s:32:\"acss_import_pad-section--xxl-xxl\";s:4:\"name\";s:20:\"pad-section--xxl-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1019;a:4:{s:2:\"id\";s:29:\"acss_import_pad-section--none\";s:4:\"name\";s:17:\"pad-section--none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1020;a:4:{s:2:\"id\";s:31:\"acss_import_pad-section--s-none\";s:4:\"name\";s:19:\"pad-section--s-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1021;a:4:{s:2:\"id\";s:31:\"acss_import_pad-section--m-none\";s:4:\"name\";s:19:\"pad-section--m-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1022;a:4:{s:2:\"id\";s:31:\"acss_import_pad-section--l-none\";s:4:\"name\";s:19:\"pad-section--l-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1023;a:4:{s:2:\"id\";s:32:\"acss_import_pad-section--xl-none\";s:4:\"name\";s:20:\"pad-section--xl-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1024;a:4:{s:2:\"id\";s:33:\"acss_import_pad-section--xxl-none\";s:4:\"name\";s:21:\"pad-section--xxl-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1025;a:4:{s:2:\"id\";s:26:\"acss_import_margin-top--xs\";s:4:\"name\";s:14:\"margin-top--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1026;a:4:{s:2:\"id\";s:25:\"acss_import_margin-top--s\";s:4:\"name\";s:13:\"margin-top--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1027;a:4:{s:2:\"id\";s:25:\"acss_import_margin-top--m\";s:4:\"name\";s:13:\"margin-top--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1028;a:4:{s:2:\"id\";s:25:\"acss_import_margin-top--l\";s:4:\"name\";s:13:\"margin-top--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1029;a:4:{s:2:\"id\";s:26:\"acss_import_margin-top--xl\";s:4:\"name\";s:14:\"margin-top--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1030;a:4:{s:2:\"id\";s:27:\"acss_import_margin-top--xxl\";s:4:\"name\";s:15:\"margin-top--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1031;a:4:{s:2:\"id\";s:29:\"acss_import_margin-bottom--xs\";s:4:\"name\";s:17:\"margin-bottom--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1032;a:4:{s:2:\"id\";s:28:\"acss_import_margin-bottom--s\";s:4:\"name\";s:16:\"margin-bottom--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1033;a:4:{s:2:\"id\";s:28:\"acss_import_margin-bottom--m\";s:4:\"name\";s:16:\"margin-bottom--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1034;a:4:{s:2:\"id\";s:28:\"acss_import_margin-bottom--l\";s:4:\"name\";s:16:\"margin-bottom--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1035;a:4:{s:2:\"id\";s:29:\"acss_import_margin-bottom--xl\";s:4:\"name\";s:17:\"margin-bottom--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1036;a:4:{s:2:\"id\";s:30:\"acss_import_margin-bottom--xxl\";s:4:\"name\";s:18:\"margin-bottom--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1037;a:4:{s:2:\"id\";s:27:\"acss_import_margin-left--xs\";s:4:\"name\";s:15:\"margin-left--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1038;a:4:{s:2:\"id\";s:26:\"acss_import_margin-left--s\";s:4:\"name\";s:14:\"margin-left--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1039;a:4:{s:2:\"id\";s:26:\"acss_import_margin-left--m\";s:4:\"name\";s:14:\"margin-left--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1040;a:4:{s:2:\"id\";s:26:\"acss_import_margin-left--l\";s:4:\"name\";s:14:\"margin-left--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1041;a:4:{s:2:\"id\";s:27:\"acss_import_margin-left--xl\";s:4:\"name\";s:15:\"margin-left--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1042;a:4:{s:2:\"id\";s:28:\"acss_import_margin-left--xxl\";s:4:\"name\";s:16:\"margin-left--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1043;a:4:{s:2:\"id\";s:28:\"acss_import_margin-right--xs\";s:4:\"name\";s:16:\"margin-right--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1044;a:4:{s:2:\"id\";s:27:\"acss_import_margin-right--s\";s:4:\"name\";s:15:\"margin-right--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1045;a:4:{s:2:\"id\";s:27:\"acss_import_margin-right--m\";s:4:\"name\";s:15:\"margin-right--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1046;a:4:{s:2:\"id\";s:27:\"acss_import_margin-right--l\";s:4:\"name\";s:15:\"margin-right--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1047;a:4:{s:2:\"id\";s:28:\"acss_import_margin-right--xl\";s:4:\"name\";s:16:\"margin-right--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1048;a:4:{s:2:\"id\";s:29:\"acss_import_margin-right--xxl\";s:4:\"name\";s:17:\"margin-right--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1049;a:4:{s:2:\"id\";s:21:\"acss_import_gap--none\";s:4:\"name\";s:9:\"gap--none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1050;a:4:{s:2:\"id\";s:19:\"acss_import_gap--xs\";s:4:\"name\";s:7:\"gap--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1051;a:4:{s:2:\"id\";s:21:\"acss_import_gap--s-xs\";s:4:\"name\";s:9:\"gap--s-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1052;a:4:{s:2:\"id\";s:21:\"acss_import_gap--m-xs\";s:4:\"name\";s:9:\"gap--m-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1053;a:4:{s:2:\"id\";s:21:\"acss_import_gap--l-xs\";s:4:\"name\";s:9:\"gap--l-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1054;a:4:{s:2:\"id\";s:22:\"acss_import_gap--xl-xs\";s:4:\"name\";s:10:\"gap--xl-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1055;a:4:{s:2:\"id\";s:18:\"acss_import_gap--s\";s:4:\"name\";s:6:\"gap--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1056;a:4:{s:2:\"id\";s:20:\"acss_import_gap--s-s\";s:4:\"name\";s:8:\"gap--s-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1057;a:4:{s:2:\"id\";s:20:\"acss_import_gap--m-s\";s:4:\"name\";s:8:\"gap--m-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1058;a:4:{s:2:\"id\";s:20:\"acss_import_gap--l-s\";s:4:\"name\";s:8:\"gap--l-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1059;a:4:{s:2:\"id\";s:21:\"acss_import_gap--xl-s\";s:4:\"name\";s:9:\"gap--xl-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1060;a:4:{s:2:\"id\";s:18:\"acss_import_gap--m\";s:4:\"name\";s:6:\"gap--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1061;a:4:{s:2:\"id\";s:20:\"acss_import_gap--s-m\";s:4:\"name\";s:8:\"gap--s-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1062;a:4:{s:2:\"id\";s:20:\"acss_import_gap--m-m\";s:4:\"name\";s:8:\"gap--m-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1063;a:4:{s:2:\"id\";s:20:\"acss_import_gap--l-m\";s:4:\"name\";s:8:\"gap--l-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1064;a:4:{s:2:\"id\";s:21:\"acss_import_gap--xl-m\";s:4:\"name\";s:9:\"gap--xl-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1065;a:4:{s:2:\"id\";s:18:\"acss_import_gap--l\";s:4:\"name\";s:6:\"gap--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1066;a:4:{s:2:\"id\";s:20:\"acss_import_gap--s-l\";s:4:\"name\";s:8:\"gap--s-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1067;a:4:{s:2:\"id\";s:20:\"acss_import_gap--m-l\";s:4:\"name\";s:8:\"gap--m-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1068;a:4:{s:2:\"id\";s:20:\"acss_import_gap--l-l\";s:4:\"name\";s:8:\"gap--l-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1069;a:4:{s:2:\"id\";s:21:\"acss_import_gap--xl-l\";s:4:\"name\";s:9:\"gap--xl-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1070;a:4:{s:2:\"id\";s:19:\"acss_import_gap--xl\";s:4:\"name\";s:7:\"gap--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1071;a:4:{s:2:\"id\";s:21:\"acss_import_gap--s-xl\";s:4:\"name\";s:9:\"gap--s-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1072;a:4:{s:2:\"id\";s:21:\"acss_import_gap--m-xl\";s:4:\"name\";s:9:\"gap--m-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1073;a:4:{s:2:\"id\";s:21:\"acss_import_gap--l-xl\";s:4:\"name\";s:9:\"gap--l-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1074;a:4:{s:2:\"id\";s:22:\"acss_import_gap--xl-xl\";s:4:\"name\";s:10:\"gap--xl-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1075;a:4:{s:2:\"id\";s:20:\"acss_import_gap--xxl\";s:4:\"name\";s:8:\"gap--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1076;a:4:{s:2:\"id\";s:22:\"acss_import_gap--s-xxl\";s:4:\"name\";s:10:\"gap--s-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1077;a:4:{s:2:\"id\";s:22:\"acss_import_gap--m-xxl\";s:4:\"name\";s:10:\"gap--m-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1078;a:4:{s:2:\"id\";s:22:\"acss_import_gap--l-xxl\";s:4:\"name\";s:10:\"gap--l-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1079;a:4:{s:2:\"id\";s:23:\"acss_import_gap--xl-xxl\";s:4:\"name\";s:11:\"gap--xl-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1080;a:4:{s:2:\"id\";s:25:\"acss_import_container-gap\";s:4:\"name\";s:13:\"container-gap\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1081;a:4:{s:2:\"id\";s:23:\"acss_import_content-gap\";s:4:\"name\";s:11:\"content-gap\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1082;a:4:{s:2:\"id\";s:20:\"acss_import_grid-gap\";s:4:\"name\";s:8:\"grid-gap\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1083;a:4:{s:2:\"id\";s:23:\"acss_import_row-gap--xs\";s:4:\"name\";s:11:\"row-gap--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1084;a:4:{s:2:\"id\";s:26:\"acss_import_row-gap--xs-xs\";s:4:\"name\";s:14:\"row-gap--xs-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1085;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--s-xs\";s:4:\"name\";s:13:\"row-gap--s-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1086;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--m-xs\";s:4:\"name\";s:13:\"row-gap--m-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1087;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--l-xs\";s:4:\"name\";s:13:\"row-gap--l-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1088;a:4:{s:2:\"id\";s:26:\"acss_import_row-gap--xl-xs\";s:4:\"name\";s:14:\"row-gap--xl-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1089;a:4:{s:2:\"id\";s:27:\"acss_import_row-gap--xxl-xs\";s:4:\"name\";s:15:\"row-gap--xxl-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1090;a:4:{s:2:\"id\";s:22:\"acss_import_row-gap--s\";s:4:\"name\";s:10:\"row-gap--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1091;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--xs-s\";s:4:\"name\";s:13:\"row-gap--xs-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1092;a:4:{s:2:\"id\";s:24:\"acss_import_row-gap--s-s\";s:4:\"name\";s:12:\"row-gap--s-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1093;a:4:{s:2:\"id\";s:24:\"acss_import_row-gap--m-s\";s:4:\"name\";s:12:\"row-gap--m-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1094;a:4:{s:2:\"id\";s:24:\"acss_import_row-gap--l-s\";s:4:\"name\";s:12:\"row-gap--l-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1095;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--xl-s\";s:4:\"name\";s:13:\"row-gap--xl-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1096;a:4:{s:2:\"id\";s:26:\"acss_import_row-gap--xxl-s\";s:4:\"name\";s:14:\"row-gap--xxl-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1097;a:4:{s:2:\"id\";s:22:\"acss_import_row-gap--m\";s:4:\"name\";s:10:\"row-gap--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1098;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--xs-m\";s:4:\"name\";s:13:\"row-gap--xs-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1099;a:4:{s:2:\"id\";s:24:\"acss_import_row-gap--s-m\";s:4:\"name\";s:12:\"row-gap--s-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1100;a:4:{s:2:\"id\";s:24:\"acss_import_row-gap--m-m\";s:4:\"name\";s:12:\"row-gap--m-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1101;a:4:{s:2:\"id\";s:24:\"acss_import_row-gap--l-m\";s:4:\"name\";s:12:\"row-gap--l-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1102;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--xl-m\";s:4:\"name\";s:13:\"row-gap--xl-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1103;a:4:{s:2:\"id\";s:26:\"acss_import_row-gap--xxl-m\";s:4:\"name\";s:14:\"row-gap--xxl-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1104;a:4:{s:2:\"id\";s:22:\"acss_import_row-gap--l\";s:4:\"name\";s:10:\"row-gap--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1105;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--xs-l\";s:4:\"name\";s:13:\"row-gap--xs-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1106;a:4:{s:2:\"id\";s:24:\"acss_import_row-gap--s-l\";s:4:\"name\";s:12:\"row-gap--s-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1107;a:4:{s:2:\"id\";s:24:\"acss_import_row-gap--m-l\";s:4:\"name\";s:12:\"row-gap--m-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1108;a:4:{s:2:\"id\";s:24:\"acss_import_row-gap--l-l\";s:4:\"name\";s:12:\"row-gap--l-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1109;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--xl-l\";s:4:\"name\";s:13:\"row-gap--xl-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1110;a:4:{s:2:\"id\";s:26:\"acss_import_row-gap--xxl-l\";s:4:\"name\";s:14:\"row-gap--xxl-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1111;a:4:{s:2:\"id\";s:23:\"acss_import_row-gap--xl\";s:4:\"name\";s:11:\"row-gap--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1112;a:4:{s:2:\"id\";s:26:\"acss_import_row-gap--xs-xl\";s:4:\"name\";s:14:\"row-gap--xs-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1113;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--s-xl\";s:4:\"name\";s:13:\"row-gap--s-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1114;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--m-xl\";s:4:\"name\";s:13:\"row-gap--m-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1115;a:4:{s:2:\"id\";s:25:\"acss_import_row-gap--l-xl\";s:4:\"name\";s:13:\"row-gap--l-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1116;a:4:{s:2:\"id\";s:26:\"acss_import_row-gap--xl-xl\";s:4:\"name\";s:14:\"row-gap--xl-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1117;a:4:{s:2:\"id\";s:27:\"acss_import_row-gap--xxl-xl\";s:4:\"name\";s:15:\"row-gap--xxl-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1118;a:4:{s:2:\"id\";s:24:\"acss_import_row-gap--xxl\";s:4:\"name\";s:12:\"row-gap--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1119;a:4:{s:2:\"id\";s:27:\"acss_import_row-gap--xs-xxl\";s:4:\"name\";s:15:\"row-gap--xs-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1120;a:4:{s:2:\"id\";s:26:\"acss_import_row-gap--s-xxl\";s:4:\"name\";s:14:\"row-gap--s-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1121;a:4:{s:2:\"id\";s:26:\"acss_import_row-gap--m-xxl\";s:4:\"name\";s:14:\"row-gap--m-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1122;a:4:{s:2:\"id\";s:26:\"acss_import_row-gap--l-xxl\";s:4:\"name\";s:14:\"row-gap--l-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1123;a:4:{s:2:\"id\";s:27:\"acss_import_row-gap--xl-xxl\";s:4:\"name\";s:15:\"row-gap--xl-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1124;a:4:{s:2:\"id\";s:28:\"acss_import_row-gap--xxl-xxl\";s:4:\"name\";s:16:\"row-gap--xxl-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1125;a:4:{s:2:\"id\";s:19:\"acss_import_owl--xs\";s:4:\"name\";s:7:\"owl--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1126;a:4:{s:2:\"id\";s:18:\"acss_import_owl--s\";s:4:\"name\";s:6:\"owl--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1127;a:4:{s:2:\"id\";s:18:\"acss_import_owl--m\";s:4:\"name\";s:6:\"owl--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1128;a:4:{s:2:\"id\";s:18:\"acss_import_owl--l\";s:4:\"name\";s:6:\"owl--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1129;a:4:{s:2:\"id\";s:19:\"acss_import_owl--xl\";s:4:\"name\";s:7:\"owl--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1130;a:4:{s:2:\"id\";s:20:\"acss_import_owl--xxl\";s:4:\"name\";s:8:\"owl--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1131;a:4:{s:2:\"id\";s:25:\"acss_import_smart-spacing\";s:4:\"name\";s:13:\"smart-spacing\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1132;a:4:{s:2:\"id\";s:22:\"acss_import_text--dark\";s:4:\"name\";s:10:\"text--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1133;a:4:{s:2:\"id\";s:28:\"acss_import_text--dark-muted\";s:4:\"name\";s:16:\"text--dark-muted\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1134;a:4:{s:2:\"id\";s:23:\"acss_import_text--light\";s:4:\"name\";s:11:\"text--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1135;a:4:{s:2:\"id\";s:29:\"acss_import_text--light-muted\";s:4:\"name\";s:17:\"text--light-muted\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1136;a:4:{s:2:\"id\";s:35:\"acss_import_text--action-ultra-dark\";s:4:\"name\";s:23:\"text--action-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1137;a:4:{s:2:\"id\";s:29:\"acss_import_text--action-dark\";s:4:\"name\";s:17:\"text--action-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1138;a:4:{s:2:\"id\";s:31:\"acss_import_text--action-medium\";s:4:\"name\";s:19:\"text--action-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1139;a:4:{s:2:\"id\";s:24:\"acss_import_text--action\";s:4:\"name\";s:12:\"text--action\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1140;a:4:{s:2:\"id\";s:30:\"acss_import_text--action-light\";s:4:\"name\";s:18:\"text--action-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1141;a:4:{s:2:\"id\";s:36:\"acss_import_text--action-ultra-light\";s:4:\"name\";s:24:\"text--action-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1142;a:4:{s:2:\"id\";s:29:\"acss_import_text--action-comp\";s:4:\"name\";s:17:\"text--action-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1143;a:4:{s:2:\"id\";s:30:\"acss_import_text--action-hover\";s:4:\"name\";s:18:\"text--action-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1144;a:4:{s:2:\"id\";s:36:\"acss_import_text--primary-ultra-dark\";s:4:\"name\";s:24:\"text--primary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1145;a:4:{s:2:\"id\";s:30:\"acss_import_text--primary-dark\";s:4:\"name\";s:18:\"text--primary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1146;a:4:{s:2:\"id\";s:32:\"acss_import_text--primary-medium\";s:4:\"name\";s:20:\"text--primary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1147;a:4:{s:2:\"id\";s:25:\"acss_import_text--primary\";s:4:\"name\";s:13:\"text--primary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1148;a:4:{s:2:\"id\";s:31:\"acss_import_text--primary-light\";s:4:\"name\";s:19:\"text--primary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1149;a:4:{s:2:\"id\";s:37:\"acss_import_text--primary-ultra-light\";s:4:\"name\";s:25:\"text--primary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1150;a:4:{s:2:\"id\";s:30:\"acss_import_text--primary-comp\";s:4:\"name\";s:18:\"text--primary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1151;a:4:{s:2:\"id\";s:31:\"acss_import_text--primary-hover\";s:4:\"name\";s:19:\"text--primary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1152;a:4:{s:2:\"id\";s:38:\"acss_import_text--secondary-ultra-dark\";s:4:\"name\";s:26:\"text--secondary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1153;a:4:{s:2:\"id\";s:32:\"acss_import_text--secondary-dark\";s:4:\"name\";s:20:\"text--secondary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1154;a:4:{s:2:\"id\";s:34:\"acss_import_text--secondary-medium\";s:4:\"name\";s:22:\"text--secondary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1155;a:4:{s:2:\"id\";s:27:\"acss_import_text--secondary\";s:4:\"name\";s:15:\"text--secondary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1156;a:4:{s:2:\"id\";s:33:\"acss_import_text--secondary-light\";s:4:\"name\";s:21:\"text--secondary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1157;a:4:{s:2:\"id\";s:39:\"acss_import_text--secondary-ultra-light\";s:4:\"name\";s:27:\"text--secondary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1158;a:4:{s:2:\"id\";s:32:\"acss_import_text--secondary-comp\";s:4:\"name\";s:20:\"text--secondary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1159;a:4:{s:2:\"id\";s:33:\"acss_import_text--secondary-hover\";s:4:\"name\";s:21:\"text--secondary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1160;a:4:{s:2:\"id\";s:35:\"acss_import_text--accent-ultra-dark\";s:4:\"name\";s:23:\"text--accent-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1161;a:4:{s:2:\"id\";s:29:\"acss_import_text--accent-dark\";s:4:\"name\";s:17:\"text--accent-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1162;a:4:{s:2:\"id\";s:31:\"acss_import_text--accent-medium\";s:4:\"name\";s:19:\"text--accent-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1163;a:4:{s:2:\"id\";s:24:\"acss_import_text--accent\";s:4:\"name\";s:12:\"text--accent\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1164;a:4:{s:2:\"id\";s:30:\"acss_import_text--accent-light\";s:4:\"name\";s:18:\"text--accent-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1165;a:4:{s:2:\"id\";s:36:\"acss_import_text--accent-ultra-light\";s:4:\"name\";s:24:\"text--accent-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1166;a:4:{s:2:\"id\";s:29:\"acss_import_text--accent-comp\";s:4:\"name\";s:17:\"text--accent-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1167;a:4:{s:2:\"id\";s:30:\"acss_import_text--accent-hover\";s:4:\"name\";s:18:\"text--accent-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1168;a:4:{s:2:\"id\";s:33:\"acss_import_text--base-ultra-dark\";s:4:\"name\";s:21:\"text--base-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1169;a:4:{s:2:\"id\";s:27:\"acss_import_text--base-dark\";s:4:\"name\";s:15:\"text--base-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1170;a:4:{s:2:\"id\";s:29:\"acss_import_text--base-medium\";s:4:\"name\";s:17:\"text--base-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1171;a:4:{s:2:\"id\";s:22:\"acss_import_text--base\";s:4:\"name\";s:10:\"text--base\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1172;a:4:{s:2:\"id\";s:28:\"acss_import_text--base-light\";s:4:\"name\";s:16:\"text--base-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1173;a:4:{s:2:\"id\";s:34:\"acss_import_text--base-ultra-light\";s:4:\"name\";s:22:\"text--base-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1174;a:4:{s:2:\"id\";s:27:\"acss_import_text--base-comp\";s:4:\"name\";s:15:\"text--base-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1175;a:4:{s:2:\"id\";s:28:\"acss_import_text--base-hover\";s:4:\"name\";s:16:\"text--base-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1176;a:4:{s:2:\"id\";s:34:\"acss_import_text--shade-ultra-dark\";s:4:\"name\";s:22:\"text--shade-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1177;a:4:{s:2:\"id\";s:28:\"acss_import_text--shade-dark\";s:4:\"name\";s:16:\"text--shade-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1178;a:4:{s:2:\"id\";s:30:\"acss_import_text--shade-medium\";s:4:\"name\";s:18:\"text--shade-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1179;a:4:{s:2:\"id\";s:23:\"acss_import_text--shade\";s:4:\"name\";s:11:\"text--shade\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1180;a:4:{s:2:\"id\";s:29:\"acss_import_text--shade-light\";s:4:\"name\";s:17:\"text--shade-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1181;a:4:{s:2:\"id\";s:35:\"acss_import_text--shade-ultra-light\";s:4:\"name\";s:23:\"text--shade-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1182;a:4:{s:2:\"id\";s:28:\"acss_import_text--shade-comp\";s:4:\"name\";s:16:\"text--shade-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1183;a:4:{s:2:\"id\";s:29:\"acss_import_text--shade-hover\";s:4:\"name\";s:17:\"text--shade-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1184;a:4:{s:2:\"id\";s:36:\"acss_import_text--neutral-ultra-dark\";s:4:\"name\";s:24:\"text--neutral-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1185;a:4:{s:2:\"id\";s:30:\"acss_import_text--neutral-dark\";s:4:\"name\";s:18:\"text--neutral-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1186;a:4:{s:2:\"id\";s:32:\"acss_import_text--neutral-medium\";s:4:\"name\";s:20:\"text--neutral-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1187;a:4:{s:2:\"id\";s:25:\"acss_import_text--neutral\";s:4:\"name\";s:13:\"text--neutral\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1188;a:4:{s:2:\"id\";s:31:\"acss_import_text--neutral-light\";s:4:\"name\";s:19:\"text--neutral-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1189;a:4:{s:2:\"id\";s:37:\"acss_import_text--neutral-ultra-light\";s:4:\"name\";s:25:\"text--neutral-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1190;a:4:{s:2:\"id\";s:30:\"acss_import_text--neutral-comp\";s:4:\"name\";s:18:\"text--neutral-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1191;a:4:{s:2:\"id\";s:31:\"acss_import_text--neutral-hover\";s:4:\"name\";s:19:\"text--neutral-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1192;a:4:{s:2:\"id\";s:23:\"acss_import_text--black\";s:4:\"name\";s:11:\"text--black\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1193;a:4:{s:2:\"id\";s:23:\"acss_import_text--white\";s:4:\"name\";s:11:\"text--white\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1194;a:4:{s:2:\"id\";s:25:\"acss_import_text--success\";s:4:\"name\";s:13:\"text--success\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1195;a:4:{s:2:\"id\";s:31:\"acss_import_text--success-light\";s:4:\"name\";s:19:\"text--success-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1196;a:4:{s:2:\"id\";s:30:\"acss_import_text--success-dark\";s:4:\"name\";s:18:\"text--success-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1197;a:4:{s:2:\"id\";s:31:\"acss_import_text--success-hover\";s:4:\"name\";s:19:\"text--success-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1198;a:4:{s:2:\"id\";s:24:\"acss_import_text--danger\";s:4:\"name\";s:12:\"text--danger\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1199;a:4:{s:2:\"id\";s:30:\"acss_import_text--danger-light\";s:4:\"name\";s:18:\"text--danger-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1200;a:4:{s:2:\"id\";s:29:\"acss_import_text--danger-dark\";s:4:\"name\";s:17:\"text--danger-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1201;a:4:{s:2:\"id\";s:30:\"acss_import_text--danger-hover\";s:4:\"name\";s:18:\"text--danger-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1202;a:4:{s:2:\"id\";s:25:\"acss_import_text--warning\";s:4:\"name\";s:13:\"text--warning\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1203;a:4:{s:2:\"id\";s:31:\"acss_import_text--warning-light\";s:4:\"name\";s:19:\"text--warning-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1204;a:4:{s:2:\"id\";s:30:\"acss_import_text--warning-dark\";s:4:\"name\";s:18:\"text--warning-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1205;a:4:{s:2:\"id\";s:31:\"acss_import_text--warning-hover\";s:4:\"name\";s:19:\"text--warning-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1206;a:4:{s:2:\"id\";s:22:\"acss_import_text--info\";s:4:\"name\";s:10:\"text--info\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1207;a:4:{s:2:\"id\";s:28:\"acss_import_text--info-light\";s:4:\"name\";s:16:\"text--info-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1208;a:4:{s:2:\"id\";s:27:\"acss_import_text--info-dark\";s:4:\"name\";s:15:\"text--info-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1209;a:4:{s:2:\"id\";s:28:\"acss_import_text--info-hover\";s:4:\"name\";s:16:\"text--info-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1210;a:4:{s:2:\"id\";s:20:\"acss_import_text--xs\";s:4:\"name\";s:8:\"text--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1211;a:4:{s:2:\"id\";s:19:\"acss_import_text--s\";s:4:\"name\";s:7:\"text--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1212;a:4:{s:2:\"id\";s:19:\"acss_import_text--m\";s:4:\"name\";s:7:\"text--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1213;a:4:{s:2:\"id\";s:19:\"acss_import_text--l\";s:4:\"name\";s:7:\"text--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1214;a:4:{s:2:\"id\";s:20:\"acss_import_text--xl\";s:4:\"name\";s:8:\"text--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1215;a:4:{s:2:\"id\";s:21:\"acss_import_text--xxl\";s:4:\"name\";s:9:\"text--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1216;a:4:{s:2:\"id\";s:24:\"acss_import_text--larger\";s:4:\"name\";s:12:\"text--larger\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1217;a:4:{s:2:\"id\";s:21:\"acss_import_text--100\";s:4:\"name\";s:9:\"text--100\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1218;a:4:{s:2:\"id\";s:21:\"acss_import_text--200\";s:4:\"name\";s:9:\"text--200\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1219;a:4:{s:2:\"id\";s:21:\"acss_import_text--300\";s:4:\"name\";s:9:\"text--300\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1220;a:4:{s:2:\"id\";s:21:\"acss_import_text--400\";s:4:\"name\";s:9:\"text--400\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1221;a:4:{s:2:\"id\";s:21:\"acss_import_text--500\";s:4:\"name\";s:9:\"text--500\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1222;a:4:{s:2:\"id\";s:21:\"acss_import_text--600\";s:4:\"name\";s:9:\"text--600\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1223;a:4:{s:2:\"id\";s:21:\"acss_import_text--700\";s:4:\"name\";s:9:\"text--700\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1224;a:4:{s:2:\"id\";s:21:\"acss_import_text--800\";s:4:\"name\";s:9:\"text--800\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1225;a:4:{s:2:\"id\";s:21:\"acss_import_text--900\";s:4:\"name\";s:9:\"text--900\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1226;a:4:{s:2:\"id\";s:22:\"acss_import_text--bold\";s:4:\"name\";s:10:\"text--bold\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1227;a:4:{s:2:\"id\";s:24:\"acss_import_text--italic\";s:4:\"name\";s:12:\"text--italic\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1228;a:4:{s:2:\"id\";s:25:\"acss_import_text--oblique\";s:4:\"name\";s:13:\"text--oblique\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1229;a:4:{s:2:\"id\";s:33:\"acss_import_text--decoration-none\";s:4:\"name\";s:21:\"text--decoration-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1230;a:4:{s:2:\"id\";s:27:\"acss_import_text--underline\";s:4:\"name\";s:15:\"text--underline\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1231;a:4:{s:2:\"id\";s:32:\"acss_import_text--underline-wavy\";s:4:\"name\";s:20:\"text--underline-wavy\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1232;a:4:{s:2:\"id\";s:34:\"acss_import_text--underline-dotted\";s:4:\"name\";s:22:\"text--underline-dotted\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1233;a:4:{s:2:\"id\";s:34:\"acss_import_text--underline-double\";s:4:\"name\";s:22:\"text--underline-double\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1234;a:4:{s:2:\"id\";s:34:\"acss_import_text--underline-dashed\";s:4:\"name\";s:22:\"text--underline-dashed\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1235;a:4:{s:2:\"id\";s:26:\"acss_import_text--overline\";s:4:\"name\";s:14:\"text--overline\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1236;a:4:{s:2:\"id\";s:30:\"acss_import_text--line-through\";s:4:\"name\";s:18:\"text--line-through\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1237;a:4:{s:2:\"id\";s:32:\"acss_import_text--transform-none\";s:4:\"name\";s:20:\"text--transform-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1238;a:4:{s:2:\"id\";s:27:\"acss_import_text--uppercase\";s:4:\"name\";s:15:\"text--uppercase\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1239;a:4:{s:2:\"id\";s:27:\"acss_import_text--lowercase\";s:4:\"name\";s:15:\"text--lowercase\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1240;a:4:{s:2:\"id\";s:28:\"acss_import_text--capitalize\";s:4:\"name\";s:16:\"text--capitalize\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1241;a:4:{s:2:\"id\";s:22:\"acss_import_text--left\";s:4:\"name\";s:10:\"text--left\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1242;a:4:{s:2:\"id\";s:24:\"acss_import_text--center\";s:4:\"name\";s:12:\"text--center\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1243;a:4:{s:2:\"id\";s:23:\"acss_import_text--right\";s:4:\"name\";s:11:\"text--right\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1244;a:4:{s:2:\"id\";s:25:\"acss_import_text--justify\";s:4:\"name\";s:13:\"text--justify\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1245;a:4:{s:2:\"id\";s:19:\"acss_import_balance\";s:4:\"name\";s:7:\"balance\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1246;a:4:{s:2:\"id\";s:21:\"acss_import_unbalance\";s:4:\"name\";s:9:\"unbalance\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1247;a:4:{s:2:\"id\";s:16:\"acss_import_h--1\";s:4:\"name\";s:4:\"h--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1248;a:4:{s:2:\"id\";s:16:\"acss_import_h--2\";s:4:\"name\";s:4:\"h--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1249;a:4:{s:2:\"id\";s:16:\"acss_import_h--3\";s:4:\"name\";s:4:\"h--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1250;a:4:{s:2:\"id\";s:16:\"acss_import_h--4\";s:4:\"name\";s:4:\"h--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1251;a:4:{s:2:\"id\";s:16:\"acss_import_h--5\";s:4:\"name\";s:4:\"h--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1252;a:4:{s:2:\"id\";s:16:\"acss_import_h--6\";s:4:\"name\";s:4:\"h--6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1253;a:4:{s:2:\"id\";s:26:\"acss_import_bg--ultra-dark\";s:4:\"name\";s:14:\"bg--ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1254;a:4:{s:2:\"id\";s:20:\"acss_import_bg--dark\";s:4:\"name\";s:8:\"bg--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1255;a:4:{s:2:\"id\";s:21:\"acss_import_bg--light\";s:4:\"name\";s:9:\"bg--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1256;a:4:{s:2:\"id\";s:27:\"acss_import_bg--ultra-light\";s:4:\"name\";s:15:\"bg--ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1257;a:4:{s:2:\"id\";s:33:\"acss_import_bg--action-ultra-dark\";s:4:\"name\";s:21:\"bg--action-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1258;a:4:{s:2:\"id\";s:42:\"acss_import_bg--action-ultra-dark-trans-90\";s:4:\"name\";s:30:\"bg--action-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1259;a:4:{s:2:\"id\";s:42:\"acss_import_bg--action-ultra-dark-trans-80\";s:4:\"name\";s:30:\"bg--action-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1260;a:4:{s:2:\"id\";s:42:\"acss_import_bg--action-ultra-dark-trans-70\";s:4:\"name\";s:30:\"bg--action-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1261;a:4:{s:2:\"id\";s:42:\"acss_import_bg--action-ultra-dark-trans-60\";s:4:\"name\";s:30:\"bg--action-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1262;a:4:{s:2:\"id\";s:42:\"acss_import_bg--action-ultra-dark-trans-50\";s:4:\"name\";s:30:\"bg--action-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1263;a:4:{s:2:\"id\";s:42:\"acss_import_bg--action-ultra-dark-trans-40\";s:4:\"name\";s:30:\"bg--action-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1264;a:4:{s:2:\"id\";s:42:\"acss_import_bg--action-ultra-dark-trans-30\";s:4:\"name\";s:30:\"bg--action-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1265;a:4:{s:2:\"id\";s:42:\"acss_import_bg--action-ultra-dark-trans-20\";s:4:\"name\";s:30:\"bg--action-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1266;a:4:{s:2:\"id\";s:42:\"acss_import_bg--action-ultra-dark-trans-10\";s:4:\"name\";s:30:\"bg--action-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1267;a:4:{s:2:\"id\";s:27:\"acss_import_bg--action-dark\";s:4:\"name\";s:15:\"bg--action-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1268;a:4:{s:2:\"id\";s:36:\"acss_import_bg--action-dark-trans-90\";s:4:\"name\";s:24:\"bg--action-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1269;a:4:{s:2:\"id\";s:36:\"acss_import_bg--action-dark-trans-80\";s:4:\"name\";s:24:\"bg--action-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1270;a:4:{s:2:\"id\";s:36:\"acss_import_bg--action-dark-trans-70\";s:4:\"name\";s:24:\"bg--action-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1271;a:4:{s:2:\"id\";s:36:\"acss_import_bg--action-dark-trans-60\";s:4:\"name\";s:24:\"bg--action-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1272;a:4:{s:2:\"id\";s:36:\"acss_import_bg--action-dark-trans-50\";s:4:\"name\";s:24:\"bg--action-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1273;a:4:{s:2:\"id\";s:36:\"acss_import_bg--action-dark-trans-40\";s:4:\"name\";s:24:\"bg--action-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1274;a:4:{s:2:\"id\";s:36:\"acss_import_bg--action-dark-trans-30\";s:4:\"name\";s:24:\"bg--action-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1275;a:4:{s:2:\"id\";s:36:\"acss_import_bg--action-dark-trans-20\";s:4:\"name\";s:24:\"bg--action-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1276;a:4:{s:2:\"id\";s:36:\"acss_import_bg--action-dark-trans-10\";s:4:\"name\";s:24:\"bg--action-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1277;a:4:{s:2:\"id\";s:29:\"acss_import_bg--action-medium\";s:4:\"name\";s:17:\"bg--action-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1278;a:4:{s:2:\"id\";s:22:\"acss_import_bg--action\";s:4:\"name\";s:10:\"bg--action\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1279;a:4:{s:2:\"id\";s:31:\"acss_import_bg--action-trans-90\";s:4:\"name\";s:19:\"bg--action-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1280;a:4:{s:2:\"id\";s:31:\"acss_import_bg--action-trans-80\";s:4:\"name\";s:19:\"bg--action-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1281;a:4:{s:2:\"id\";s:31:\"acss_import_bg--action-trans-70\";s:4:\"name\";s:19:\"bg--action-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1282;a:4:{s:2:\"id\";s:31:\"acss_import_bg--action-trans-60\";s:4:\"name\";s:19:\"bg--action-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1283;a:4:{s:2:\"id\";s:31:\"acss_import_bg--action-trans-50\";s:4:\"name\";s:19:\"bg--action-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1284;a:4:{s:2:\"id\";s:31:\"acss_import_bg--action-trans-40\";s:4:\"name\";s:19:\"bg--action-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1285;a:4:{s:2:\"id\";s:31:\"acss_import_bg--action-trans-30\";s:4:\"name\";s:19:\"bg--action-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1286;a:4:{s:2:\"id\";s:31:\"acss_import_bg--action-trans-20\";s:4:\"name\";s:19:\"bg--action-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1287;a:4:{s:2:\"id\";s:31:\"acss_import_bg--action-trans-10\";s:4:\"name\";s:19:\"bg--action-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1288;a:4:{s:2:\"id\";s:28:\"acss_import_bg--action-light\";s:4:\"name\";s:16:\"bg--action-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1289;a:4:{s:2:\"id\";s:37:\"acss_import_bg--action-light-trans-90\";s:4:\"name\";s:25:\"bg--action-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1290;a:4:{s:2:\"id\";s:37:\"acss_import_bg--action-light-trans-80\";s:4:\"name\";s:25:\"bg--action-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1291;a:4:{s:2:\"id\";s:37:\"acss_import_bg--action-light-trans-70\";s:4:\"name\";s:25:\"bg--action-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1292;a:4:{s:2:\"id\";s:37:\"acss_import_bg--action-light-trans-60\";s:4:\"name\";s:25:\"bg--action-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1293;a:4:{s:2:\"id\";s:37:\"acss_import_bg--action-light-trans-50\";s:4:\"name\";s:25:\"bg--action-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1294;a:4:{s:2:\"id\";s:37:\"acss_import_bg--action-light-trans-40\";s:4:\"name\";s:25:\"bg--action-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1295;a:4:{s:2:\"id\";s:37:\"acss_import_bg--action-light-trans-30\";s:4:\"name\";s:25:\"bg--action-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1296;a:4:{s:2:\"id\";s:37:\"acss_import_bg--action-light-trans-20\";s:4:\"name\";s:25:\"bg--action-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1297;a:4:{s:2:\"id\";s:37:\"acss_import_bg--action-light-trans-10\";s:4:\"name\";s:25:\"bg--action-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1298;a:4:{s:2:\"id\";s:34:\"acss_import_bg--action-ultra-light\";s:4:\"name\";s:22:\"bg--action-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1299;a:4:{s:2:\"id\";s:27:\"acss_import_bg--action-comp\";s:4:\"name\";s:15:\"bg--action-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1300;a:4:{s:2:\"id\";s:28:\"acss_import_bg--action-hover\";s:4:\"name\";s:16:\"bg--action-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1301;a:4:{s:2:\"id\";s:34:\"acss_import_bg--primary-ultra-dark\";s:4:\"name\";s:22:\"bg--primary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1302;a:4:{s:2:\"id\";s:43:\"acss_import_bg--primary-ultra-dark-trans-90\";s:4:\"name\";s:31:\"bg--primary-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1303;a:4:{s:2:\"id\";s:43:\"acss_import_bg--primary-ultra-dark-trans-80\";s:4:\"name\";s:31:\"bg--primary-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1304;a:4:{s:2:\"id\";s:43:\"acss_import_bg--primary-ultra-dark-trans-70\";s:4:\"name\";s:31:\"bg--primary-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1305;a:4:{s:2:\"id\";s:43:\"acss_import_bg--primary-ultra-dark-trans-60\";s:4:\"name\";s:31:\"bg--primary-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1306;a:4:{s:2:\"id\";s:43:\"acss_import_bg--primary-ultra-dark-trans-50\";s:4:\"name\";s:31:\"bg--primary-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1307;a:4:{s:2:\"id\";s:43:\"acss_import_bg--primary-ultra-dark-trans-40\";s:4:\"name\";s:31:\"bg--primary-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1308;a:4:{s:2:\"id\";s:43:\"acss_import_bg--primary-ultra-dark-trans-30\";s:4:\"name\";s:31:\"bg--primary-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1309;a:4:{s:2:\"id\";s:43:\"acss_import_bg--primary-ultra-dark-trans-20\";s:4:\"name\";s:31:\"bg--primary-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1310;a:4:{s:2:\"id\";s:43:\"acss_import_bg--primary-ultra-dark-trans-10\";s:4:\"name\";s:31:\"bg--primary-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1311;a:4:{s:2:\"id\";s:28:\"acss_import_bg--primary-dark\";s:4:\"name\";s:16:\"bg--primary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1312;a:4:{s:2:\"id\";s:37:\"acss_import_bg--primary-dark-trans-90\";s:4:\"name\";s:25:\"bg--primary-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1313;a:4:{s:2:\"id\";s:37:\"acss_import_bg--primary-dark-trans-80\";s:4:\"name\";s:25:\"bg--primary-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1314;a:4:{s:2:\"id\";s:37:\"acss_import_bg--primary-dark-trans-70\";s:4:\"name\";s:25:\"bg--primary-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1315;a:4:{s:2:\"id\";s:37:\"acss_import_bg--primary-dark-trans-60\";s:4:\"name\";s:25:\"bg--primary-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1316;a:4:{s:2:\"id\";s:37:\"acss_import_bg--primary-dark-trans-50\";s:4:\"name\";s:25:\"bg--primary-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1317;a:4:{s:2:\"id\";s:37:\"acss_import_bg--primary-dark-trans-40\";s:4:\"name\";s:25:\"bg--primary-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1318;a:4:{s:2:\"id\";s:37:\"acss_import_bg--primary-dark-trans-30\";s:4:\"name\";s:25:\"bg--primary-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1319;a:4:{s:2:\"id\";s:37:\"acss_import_bg--primary-dark-trans-20\";s:4:\"name\";s:25:\"bg--primary-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1320;a:4:{s:2:\"id\";s:37:\"acss_import_bg--primary-dark-trans-10\";s:4:\"name\";s:25:\"bg--primary-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1321;a:4:{s:2:\"id\";s:30:\"acss_import_bg--primary-medium\";s:4:\"name\";s:18:\"bg--primary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1322;a:4:{s:2:\"id\";s:23:\"acss_import_bg--primary\";s:4:\"name\";s:11:\"bg--primary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1323;a:4:{s:2:\"id\";s:32:\"acss_import_bg--primary-trans-90\";s:4:\"name\";s:20:\"bg--primary-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1324;a:4:{s:2:\"id\";s:32:\"acss_import_bg--primary-trans-80\";s:4:\"name\";s:20:\"bg--primary-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1325;a:4:{s:2:\"id\";s:32:\"acss_import_bg--primary-trans-70\";s:4:\"name\";s:20:\"bg--primary-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1326;a:4:{s:2:\"id\";s:32:\"acss_import_bg--primary-trans-60\";s:4:\"name\";s:20:\"bg--primary-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1327;a:4:{s:2:\"id\";s:32:\"acss_import_bg--primary-trans-50\";s:4:\"name\";s:20:\"bg--primary-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1328;a:4:{s:2:\"id\";s:32:\"acss_import_bg--primary-trans-40\";s:4:\"name\";s:20:\"bg--primary-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1329;a:4:{s:2:\"id\";s:32:\"acss_import_bg--primary-trans-30\";s:4:\"name\";s:20:\"bg--primary-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1330;a:4:{s:2:\"id\";s:32:\"acss_import_bg--primary-trans-20\";s:4:\"name\";s:20:\"bg--primary-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1331;a:4:{s:2:\"id\";s:32:\"acss_import_bg--primary-trans-10\";s:4:\"name\";s:20:\"bg--primary-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1332;a:4:{s:2:\"id\";s:29:\"acss_import_bg--primary-light\";s:4:\"name\";s:17:\"bg--primary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1333;a:4:{s:2:\"id\";s:38:\"acss_import_bg--primary-light-trans-90\";s:4:\"name\";s:26:\"bg--primary-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1334;a:4:{s:2:\"id\";s:38:\"acss_import_bg--primary-light-trans-80\";s:4:\"name\";s:26:\"bg--primary-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1335;a:4:{s:2:\"id\";s:38:\"acss_import_bg--primary-light-trans-70\";s:4:\"name\";s:26:\"bg--primary-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1336;a:4:{s:2:\"id\";s:38:\"acss_import_bg--primary-light-trans-60\";s:4:\"name\";s:26:\"bg--primary-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1337;a:4:{s:2:\"id\";s:38:\"acss_import_bg--primary-light-trans-50\";s:4:\"name\";s:26:\"bg--primary-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1338;a:4:{s:2:\"id\";s:38:\"acss_import_bg--primary-light-trans-40\";s:4:\"name\";s:26:\"bg--primary-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1339;a:4:{s:2:\"id\";s:38:\"acss_import_bg--primary-light-trans-30\";s:4:\"name\";s:26:\"bg--primary-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1340;a:4:{s:2:\"id\";s:38:\"acss_import_bg--primary-light-trans-20\";s:4:\"name\";s:26:\"bg--primary-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1341;a:4:{s:2:\"id\";s:38:\"acss_import_bg--primary-light-trans-10\";s:4:\"name\";s:26:\"bg--primary-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1342;a:4:{s:2:\"id\";s:35:\"acss_import_bg--primary-ultra-light\";s:4:\"name\";s:23:\"bg--primary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1343;a:4:{s:2:\"id\";s:28:\"acss_import_bg--primary-comp\";s:4:\"name\";s:16:\"bg--primary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1344;a:4:{s:2:\"id\";s:29:\"acss_import_bg--primary-hover\";s:4:\"name\";s:17:\"bg--primary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1345;a:4:{s:2:\"id\";s:36:\"acss_import_bg--secondary-ultra-dark\";s:4:\"name\";s:24:\"bg--secondary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1346;a:4:{s:2:\"id\";s:45:\"acss_import_bg--secondary-ultra-dark-trans-90\";s:4:\"name\";s:33:\"bg--secondary-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1347;a:4:{s:2:\"id\";s:45:\"acss_import_bg--secondary-ultra-dark-trans-80\";s:4:\"name\";s:33:\"bg--secondary-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1348;a:4:{s:2:\"id\";s:45:\"acss_import_bg--secondary-ultra-dark-trans-70\";s:4:\"name\";s:33:\"bg--secondary-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1349;a:4:{s:2:\"id\";s:45:\"acss_import_bg--secondary-ultra-dark-trans-60\";s:4:\"name\";s:33:\"bg--secondary-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1350;a:4:{s:2:\"id\";s:45:\"acss_import_bg--secondary-ultra-dark-trans-50\";s:4:\"name\";s:33:\"bg--secondary-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1351;a:4:{s:2:\"id\";s:45:\"acss_import_bg--secondary-ultra-dark-trans-40\";s:4:\"name\";s:33:\"bg--secondary-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1352;a:4:{s:2:\"id\";s:45:\"acss_import_bg--secondary-ultra-dark-trans-30\";s:4:\"name\";s:33:\"bg--secondary-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1353;a:4:{s:2:\"id\";s:45:\"acss_import_bg--secondary-ultra-dark-trans-20\";s:4:\"name\";s:33:\"bg--secondary-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1354;a:4:{s:2:\"id\";s:45:\"acss_import_bg--secondary-ultra-dark-trans-10\";s:4:\"name\";s:33:\"bg--secondary-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1355;a:4:{s:2:\"id\";s:30:\"acss_import_bg--secondary-dark\";s:4:\"name\";s:18:\"bg--secondary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1356;a:4:{s:2:\"id\";s:39:\"acss_import_bg--secondary-dark-trans-90\";s:4:\"name\";s:27:\"bg--secondary-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1357;a:4:{s:2:\"id\";s:39:\"acss_import_bg--secondary-dark-trans-80\";s:4:\"name\";s:27:\"bg--secondary-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1358;a:4:{s:2:\"id\";s:39:\"acss_import_bg--secondary-dark-trans-70\";s:4:\"name\";s:27:\"bg--secondary-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1359;a:4:{s:2:\"id\";s:39:\"acss_import_bg--secondary-dark-trans-60\";s:4:\"name\";s:27:\"bg--secondary-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1360;a:4:{s:2:\"id\";s:39:\"acss_import_bg--secondary-dark-trans-50\";s:4:\"name\";s:27:\"bg--secondary-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1361;a:4:{s:2:\"id\";s:39:\"acss_import_bg--secondary-dark-trans-40\";s:4:\"name\";s:27:\"bg--secondary-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1362;a:4:{s:2:\"id\";s:39:\"acss_import_bg--secondary-dark-trans-30\";s:4:\"name\";s:27:\"bg--secondary-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1363;a:4:{s:2:\"id\";s:39:\"acss_import_bg--secondary-dark-trans-20\";s:4:\"name\";s:27:\"bg--secondary-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1364;a:4:{s:2:\"id\";s:39:\"acss_import_bg--secondary-dark-trans-10\";s:4:\"name\";s:27:\"bg--secondary-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1365;a:4:{s:2:\"id\";s:32:\"acss_import_bg--secondary-medium\";s:4:\"name\";s:20:\"bg--secondary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1366;a:4:{s:2:\"id\";s:25:\"acss_import_bg--secondary\";s:4:\"name\";s:13:\"bg--secondary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1367;a:4:{s:2:\"id\";s:34:\"acss_import_bg--secondary-trans-90\";s:4:\"name\";s:22:\"bg--secondary-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1368;a:4:{s:2:\"id\";s:34:\"acss_import_bg--secondary-trans-80\";s:4:\"name\";s:22:\"bg--secondary-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1369;a:4:{s:2:\"id\";s:34:\"acss_import_bg--secondary-trans-70\";s:4:\"name\";s:22:\"bg--secondary-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1370;a:4:{s:2:\"id\";s:34:\"acss_import_bg--secondary-trans-60\";s:4:\"name\";s:22:\"bg--secondary-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1371;a:4:{s:2:\"id\";s:34:\"acss_import_bg--secondary-trans-50\";s:4:\"name\";s:22:\"bg--secondary-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1372;a:4:{s:2:\"id\";s:34:\"acss_import_bg--secondary-trans-40\";s:4:\"name\";s:22:\"bg--secondary-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1373;a:4:{s:2:\"id\";s:34:\"acss_import_bg--secondary-trans-30\";s:4:\"name\";s:22:\"bg--secondary-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1374;a:4:{s:2:\"id\";s:34:\"acss_import_bg--secondary-trans-20\";s:4:\"name\";s:22:\"bg--secondary-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1375;a:4:{s:2:\"id\";s:34:\"acss_import_bg--secondary-trans-10\";s:4:\"name\";s:22:\"bg--secondary-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1376;a:4:{s:2:\"id\";s:31:\"acss_import_bg--secondary-light\";s:4:\"name\";s:19:\"bg--secondary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1377;a:4:{s:2:\"id\";s:40:\"acss_import_bg--secondary-light-trans-90\";s:4:\"name\";s:28:\"bg--secondary-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1378;a:4:{s:2:\"id\";s:40:\"acss_import_bg--secondary-light-trans-80\";s:4:\"name\";s:28:\"bg--secondary-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1379;a:4:{s:2:\"id\";s:40:\"acss_import_bg--secondary-light-trans-70\";s:4:\"name\";s:28:\"bg--secondary-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1380;a:4:{s:2:\"id\";s:40:\"acss_import_bg--secondary-light-trans-60\";s:4:\"name\";s:28:\"bg--secondary-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1381;a:4:{s:2:\"id\";s:40:\"acss_import_bg--secondary-light-trans-50\";s:4:\"name\";s:28:\"bg--secondary-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1382;a:4:{s:2:\"id\";s:40:\"acss_import_bg--secondary-light-trans-40\";s:4:\"name\";s:28:\"bg--secondary-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1383;a:4:{s:2:\"id\";s:40:\"acss_import_bg--secondary-light-trans-30\";s:4:\"name\";s:28:\"bg--secondary-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1384;a:4:{s:2:\"id\";s:40:\"acss_import_bg--secondary-light-trans-20\";s:4:\"name\";s:28:\"bg--secondary-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1385;a:4:{s:2:\"id\";s:40:\"acss_import_bg--secondary-light-trans-10\";s:4:\"name\";s:28:\"bg--secondary-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1386;a:4:{s:2:\"id\";s:37:\"acss_import_bg--secondary-ultra-light\";s:4:\"name\";s:25:\"bg--secondary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1387;a:4:{s:2:\"id\";s:30:\"acss_import_bg--secondary-comp\";s:4:\"name\";s:18:\"bg--secondary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1388;a:4:{s:2:\"id\";s:31:\"acss_import_bg--secondary-hover\";s:4:\"name\";s:19:\"bg--secondary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1389;a:4:{s:2:\"id\";s:33:\"acss_import_bg--accent-ultra-dark\";s:4:\"name\";s:21:\"bg--accent-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1390;a:4:{s:2:\"id\";s:42:\"acss_import_bg--accent-ultra-dark-trans-90\";s:4:\"name\";s:30:\"bg--accent-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1391;a:4:{s:2:\"id\";s:42:\"acss_import_bg--accent-ultra-dark-trans-80\";s:4:\"name\";s:30:\"bg--accent-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1392;a:4:{s:2:\"id\";s:42:\"acss_import_bg--accent-ultra-dark-trans-70\";s:4:\"name\";s:30:\"bg--accent-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1393;a:4:{s:2:\"id\";s:42:\"acss_import_bg--accent-ultra-dark-trans-60\";s:4:\"name\";s:30:\"bg--accent-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1394;a:4:{s:2:\"id\";s:42:\"acss_import_bg--accent-ultra-dark-trans-50\";s:4:\"name\";s:30:\"bg--accent-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1395;a:4:{s:2:\"id\";s:42:\"acss_import_bg--accent-ultra-dark-trans-40\";s:4:\"name\";s:30:\"bg--accent-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1396;a:4:{s:2:\"id\";s:42:\"acss_import_bg--accent-ultra-dark-trans-30\";s:4:\"name\";s:30:\"bg--accent-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1397;a:4:{s:2:\"id\";s:42:\"acss_import_bg--accent-ultra-dark-trans-20\";s:4:\"name\";s:30:\"bg--accent-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1398;a:4:{s:2:\"id\";s:42:\"acss_import_bg--accent-ultra-dark-trans-10\";s:4:\"name\";s:30:\"bg--accent-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1399;a:4:{s:2:\"id\";s:27:\"acss_import_bg--accent-dark\";s:4:\"name\";s:15:\"bg--accent-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1400;a:4:{s:2:\"id\";s:36:\"acss_import_bg--accent-dark-trans-90\";s:4:\"name\";s:24:\"bg--accent-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1401;a:4:{s:2:\"id\";s:36:\"acss_import_bg--accent-dark-trans-80\";s:4:\"name\";s:24:\"bg--accent-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1402;a:4:{s:2:\"id\";s:36:\"acss_import_bg--accent-dark-trans-70\";s:4:\"name\";s:24:\"bg--accent-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1403;a:4:{s:2:\"id\";s:36:\"acss_import_bg--accent-dark-trans-60\";s:4:\"name\";s:24:\"bg--accent-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1404;a:4:{s:2:\"id\";s:36:\"acss_import_bg--accent-dark-trans-50\";s:4:\"name\";s:24:\"bg--accent-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1405;a:4:{s:2:\"id\";s:36:\"acss_import_bg--accent-dark-trans-40\";s:4:\"name\";s:24:\"bg--accent-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1406;a:4:{s:2:\"id\";s:36:\"acss_import_bg--accent-dark-trans-30\";s:4:\"name\";s:24:\"bg--accent-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1407;a:4:{s:2:\"id\";s:36:\"acss_import_bg--accent-dark-trans-20\";s:4:\"name\";s:24:\"bg--accent-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1408;a:4:{s:2:\"id\";s:36:\"acss_import_bg--accent-dark-trans-10\";s:4:\"name\";s:24:\"bg--accent-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1409;a:4:{s:2:\"id\";s:29:\"acss_import_bg--accent-medium\";s:4:\"name\";s:17:\"bg--accent-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1410;a:4:{s:2:\"id\";s:22:\"acss_import_bg--accent\";s:4:\"name\";s:10:\"bg--accent\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1411;a:4:{s:2:\"id\";s:31:\"acss_import_bg--accent-trans-90\";s:4:\"name\";s:19:\"bg--accent-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1412;a:4:{s:2:\"id\";s:31:\"acss_import_bg--accent-trans-80\";s:4:\"name\";s:19:\"bg--accent-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1413;a:4:{s:2:\"id\";s:31:\"acss_import_bg--accent-trans-70\";s:4:\"name\";s:19:\"bg--accent-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1414;a:4:{s:2:\"id\";s:31:\"acss_import_bg--accent-trans-60\";s:4:\"name\";s:19:\"bg--accent-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1415;a:4:{s:2:\"id\";s:31:\"acss_import_bg--accent-trans-50\";s:4:\"name\";s:19:\"bg--accent-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1416;a:4:{s:2:\"id\";s:31:\"acss_import_bg--accent-trans-40\";s:4:\"name\";s:19:\"bg--accent-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1417;a:4:{s:2:\"id\";s:31:\"acss_import_bg--accent-trans-30\";s:4:\"name\";s:19:\"bg--accent-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1418;a:4:{s:2:\"id\";s:31:\"acss_import_bg--accent-trans-20\";s:4:\"name\";s:19:\"bg--accent-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1419;a:4:{s:2:\"id\";s:31:\"acss_import_bg--accent-trans-10\";s:4:\"name\";s:19:\"bg--accent-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1420;a:4:{s:2:\"id\";s:28:\"acss_import_bg--accent-light\";s:4:\"name\";s:16:\"bg--accent-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1421;a:4:{s:2:\"id\";s:37:\"acss_import_bg--accent-light-trans-90\";s:4:\"name\";s:25:\"bg--accent-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1422;a:4:{s:2:\"id\";s:37:\"acss_import_bg--accent-light-trans-80\";s:4:\"name\";s:25:\"bg--accent-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1423;a:4:{s:2:\"id\";s:37:\"acss_import_bg--accent-light-trans-70\";s:4:\"name\";s:25:\"bg--accent-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1424;a:4:{s:2:\"id\";s:37:\"acss_import_bg--accent-light-trans-60\";s:4:\"name\";s:25:\"bg--accent-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1425;a:4:{s:2:\"id\";s:37:\"acss_import_bg--accent-light-trans-50\";s:4:\"name\";s:25:\"bg--accent-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1426;a:4:{s:2:\"id\";s:37:\"acss_import_bg--accent-light-trans-40\";s:4:\"name\";s:25:\"bg--accent-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1427;a:4:{s:2:\"id\";s:37:\"acss_import_bg--accent-light-trans-30\";s:4:\"name\";s:25:\"bg--accent-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1428;a:4:{s:2:\"id\";s:37:\"acss_import_bg--accent-light-trans-20\";s:4:\"name\";s:25:\"bg--accent-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1429;a:4:{s:2:\"id\";s:37:\"acss_import_bg--accent-light-trans-10\";s:4:\"name\";s:25:\"bg--accent-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1430;a:4:{s:2:\"id\";s:34:\"acss_import_bg--accent-ultra-light\";s:4:\"name\";s:22:\"bg--accent-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1431;a:4:{s:2:\"id\";s:27:\"acss_import_bg--accent-comp\";s:4:\"name\";s:15:\"bg--accent-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1432;a:4:{s:2:\"id\";s:28:\"acss_import_bg--accent-hover\";s:4:\"name\";s:16:\"bg--accent-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1433;a:4:{s:2:\"id\";s:31:\"acss_import_bg--base-ultra-dark\";s:4:\"name\";s:19:\"bg--base-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1434;a:4:{s:2:\"id\";s:40:\"acss_import_bg--base-ultra-dark-trans-90\";s:4:\"name\";s:28:\"bg--base-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1435;a:4:{s:2:\"id\";s:40:\"acss_import_bg--base-ultra-dark-trans-80\";s:4:\"name\";s:28:\"bg--base-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1436;a:4:{s:2:\"id\";s:40:\"acss_import_bg--base-ultra-dark-trans-70\";s:4:\"name\";s:28:\"bg--base-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1437;a:4:{s:2:\"id\";s:40:\"acss_import_bg--base-ultra-dark-trans-60\";s:4:\"name\";s:28:\"bg--base-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1438;a:4:{s:2:\"id\";s:40:\"acss_import_bg--base-ultra-dark-trans-50\";s:4:\"name\";s:28:\"bg--base-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1439;a:4:{s:2:\"id\";s:40:\"acss_import_bg--base-ultra-dark-trans-40\";s:4:\"name\";s:28:\"bg--base-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1440;a:4:{s:2:\"id\";s:40:\"acss_import_bg--base-ultra-dark-trans-30\";s:4:\"name\";s:28:\"bg--base-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1441;a:4:{s:2:\"id\";s:40:\"acss_import_bg--base-ultra-dark-trans-20\";s:4:\"name\";s:28:\"bg--base-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1442;a:4:{s:2:\"id\";s:40:\"acss_import_bg--base-ultra-dark-trans-10\";s:4:\"name\";s:28:\"bg--base-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1443;a:4:{s:2:\"id\";s:25:\"acss_import_bg--base-dark\";s:4:\"name\";s:13:\"bg--base-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1444;a:4:{s:2:\"id\";s:34:\"acss_import_bg--base-dark-trans-90\";s:4:\"name\";s:22:\"bg--base-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1445;a:4:{s:2:\"id\";s:34:\"acss_import_bg--base-dark-trans-80\";s:4:\"name\";s:22:\"bg--base-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1446;a:4:{s:2:\"id\";s:34:\"acss_import_bg--base-dark-trans-70\";s:4:\"name\";s:22:\"bg--base-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1447;a:4:{s:2:\"id\";s:34:\"acss_import_bg--base-dark-trans-60\";s:4:\"name\";s:22:\"bg--base-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1448;a:4:{s:2:\"id\";s:34:\"acss_import_bg--base-dark-trans-50\";s:4:\"name\";s:22:\"bg--base-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1449;a:4:{s:2:\"id\";s:34:\"acss_import_bg--base-dark-trans-40\";s:4:\"name\";s:22:\"bg--base-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1450;a:4:{s:2:\"id\";s:34:\"acss_import_bg--base-dark-trans-30\";s:4:\"name\";s:22:\"bg--base-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1451;a:4:{s:2:\"id\";s:34:\"acss_import_bg--base-dark-trans-20\";s:4:\"name\";s:22:\"bg--base-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1452;a:4:{s:2:\"id\";s:34:\"acss_import_bg--base-dark-trans-10\";s:4:\"name\";s:22:\"bg--base-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1453;a:4:{s:2:\"id\";s:27:\"acss_import_bg--base-medium\";s:4:\"name\";s:15:\"bg--base-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1454;a:4:{s:2:\"id\";s:20:\"acss_import_bg--base\";s:4:\"name\";s:8:\"bg--base\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1455;a:4:{s:2:\"id\";s:29:\"acss_import_bg--base-trans-90\";s:4:\"name\";s:17:\"bg--base-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1456;a:4:{s:2:\"id\";s:29:\"acss_import_bg--base-trans-80\";s:4:\"name\";s:17:\"bg--base-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1457;a:4:{s:2:\"id\";s:29:\"acss_import_bg--base-trans-70\";s:4:\"name\";s:17:\"bg--base-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1458;a:4:{s:2:\"id\";s:29:\"acss_import_bg--base-trans-60\";s:4:\"name\";s:17:\"bg--base-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1459;a:4:{s:2:\"id\";s:29:\"acss_import_bg--base-trans-50\";s:4:\"name\";s:17:\"bg--base-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1460;a:4:{s:2:\"id\";s:29:\"acss_import_bg--base-trans-40\";s:4:\"name\";s:17:\"bg--base-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1461;a:4:{s:2:\"id\";s:29:\"acss_import_bg--base-trans-30\";s:4:\"name\";s:17:\"bg--base-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1462;a:4:{s:2:\"id\";s:29:\"acss_import_bg--base-trans-20\";s:4:\"name\";s:17:\"bg--base-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1463;a:4:{s:2:\"id\";s:29:\"acss_import_bg--base-trans-10\";s:4:\"name\";s:17:\"bg--base-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1464;a:4:{s:2:\"id\";s:26:\"acss_import_bg--base-light\";s:4:\"name\";s:14:\"bg--base-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1465;a:4:{s:2:\"id\";s:35:\"acss_import_bg--base-light-trans-90\";s:4:\"name\";s:23:\"bg--base-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1466;a:4:{s:2:\"id\";s:35:\"acss_import_bg--base-light-trans-80\";s:4:\"name\";s:23:\"bg--base-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1467;a:4:{s:2:\"id\";s:35:\"acss_import_bg--base-light-trans-70\";s:4:\"name\";s:23:\"bg--base-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1468;a:4:{s:2:\"id\";s:35:\"acss_import_bg--base-light-trans-60\";s:4:\"name\";s:23:\"bg--base-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1469;a:4:{s:2:\"id\";s:35:\"acss_import_bg--base-light-trans-50\";s:4:\"name\";s:23:\"bg--base-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1470;a:4:{s:2:\"id\";s:35:\"acss_import_bg--base-light-trans-40\";s:4:\"name\";s:23:\"bg--base-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1471;a:4:{s:2:\"id\";s:35:\"acss_import_bg--base-light-trans-30\";s:4:\"name\";s:23:\"bg--base-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1472;a:4:{s:2:\"id\";s:35:\"acss_import_bg--base-light-trans-20\";s:4:\"name\";s:23:\"bg--base-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1473;a:4:{s:2:\"id\";s:35:\"acss_import_bg--base-light-trans-10\";s:4:\"name\";s:23:\"bg--base-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1474;a:4:{s:2:\"id\";s:32:\"acss_import_bg--base-ultra-light\";s:4:\"name\";s:20:\"bg--base-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1475;a:4:{s:2:\"id\";s:25:\"acss_import_bg--base-comp\";s:4:\"name\";s:13:\"bg--base-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1476;a:4:{s:2:\"id\";s:26:\"acss_import_bg--base-hover\";s:4:\"name\";s:14:\"bg--base-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1477;a:4:{s:2:\"id\";s:34:\"acss_import_bg--neutral-ultra-dark\";s:4:\"name\";s:22:\"bg--neutral-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1478;a:4:{s:2:\"id\";s:43:\"acss_import_bg--neutral-ultra-dark-trans-90\";s:4:\"name\";s:31:\"bg--neutral-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1479;a:4:{s:2:\"id\";s:43:\"acss_import_bg--neutral-ultra-dark-trans-80\";s:4:\"name\";s:31:\"bg--neutral-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1480;a:4:{s:2:\"id\";s:43:\"acss_import_bg--neutral-ultra-dark-trans-70\";s:4:\"name\";s:31:\"bg--neutral-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1481;a:4:{s:2:\"id\";s:43:\"acss_import_bg--neutral-ultra-dark-trans-60\";s:4:\"name\";s:31:\"bg--neutral-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1482;a:4:{s:2:\"id\";s:43:\"acss_import_bg--neutral-ultra-dark-trans-50\";s:4:\"name\";s:31:\"bg--neutral-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1483;a:4:{s:2:\"id\";s:43:\"acss_import_bg--neutral-ultra-dark-trans-40\";s:4:\"name\";s:31:\"bg--neutral-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1484;a:4:{s:2:\"id\";s:43:\"acss_import_bg--neutral-ultra-dark-trans-30\";s:4:\"name\";s:31:\"bg--neutral-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1485;a:4:{s:2:\"id\";s:43:\"acss_import_bg--neutral-ultra-dark-trans-20\";s:4:\"name\";s:31:\"bg--neutral-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1486;a:4:{s:2:\"id\";s:43:\"acss_import_bg--neutral-ultra-dark-trans-10\";s:4:\"name\";s:31:\"bg--neutral-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1487;a:4:{s:2:\"id\";s:28:\"acss_import_bg--neutral-dark\";s:4:\"name\";s:16:\"bg--neutral-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1488;a:4:{s:2:\"id\";s:37:\"acss_import_bg--neutral-dark-trans-90\";s:4:\"name\";s:25:\"bg--neutral-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1489;a:4:{s:2:\"id\";s:37:\"acss_import_bg--neutral-dark-trans-80\";s:4:\"name\";s:25:\"bg--neutral-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1490;a:4:{s:2:\"id\";s:37:\"acss_import_bg--neutral-dark-trans-70\";s:4:\"name\";s:25:\"bg--neutral-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1491;a:4:{s:2:\"id\";s:37:\"acss_import_bg--neutral-dark-trans-60\";s:4:\"name\";s:25:\"bg--neutral-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1492;a:4:{s:2:\"id\";s:37:\"acss_import_bg--neutral-dark-trans-50\";s:4:\"name\";s:25:\"bg--neutral-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1493;a:4:{s:2:\"id\";s:37:\"acss_import_bg--neutral-dark-trans-40\";s:4:\"name\";s:25:\"bg--neutral-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1494;a:4:{s:2:\"id\";s:37:\"acss_import_bg--neutral-dark-trans-30\";s:4:\"name\";s:25:\"bg--neutral-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1495;a:4:{s:2:\"id\";s:37:\"acss_import_bg--neutral-dark-trans-20\";s:4:\"name\";s:25:\"bg--neutral-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1496;a:4:{s:2:\"id\";s:37:\"acss_import_bg--neutral-dark-trans-10\";s:4:\"name\";s:25:\"bg--neutral-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1497;a:4:{s:2:\"id\";s:30:\"acss_import_bg--neutral-medium\";s:4:\"name\";s:18:\"bg--neutral-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1498;a:4:{s:2:\"id\";s:23:\"acss_import_bg--neutral\";s:4:\"name\";s:11:\"bg--neutral\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1499;a:4:{s:2:\"id\";s:32:\"acss_import_bg--neutral-trans-90\";s:4:\"name\";s:20:\"bg--neutral-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1500;a:4:{s:2:\"id\";s:32:\"acss_import_bg--neutral-trans-80\";s:4:\"name\";s:20:\"bg--neutral-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1501;a:4:{s:2:\"id\";s:32:\"acss_import_bg--neutral-trans-70\";s:4:\"name\";s:20:\"bg--neutral-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1502;a:4:{s:2:\"id\";s:32:\"acss_import_bg--neutral-trans-60\";s:4:\"name\";s:20:\"bg--neutral-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1503;a:4:{s:2:\"id\";s:32:\"acss_import_bg--neutral-trans-50\";s:4:\"name\";s:20:\"bg--neutral-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1504;a:4:{s:2:\"id\";s:32:\"acss_import_bg--neutral-trans-40\";s:4:\"name\";s:20:\"bg--neutral-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1505;a:4:{s:2:\"id\";s:32:\"acss_import_bg--neutral-trans-30\";s:4:\"name\";s:20:\"bg--neutral-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1506;a:4:{s:2:\"id\";s:32:\"acss_import_bg--neutral-trans-20\";s:4:\"name\";s:20:\"bg--neutral-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1507;a:4:{s:2:\"id\";s:32:\"acss_import_bg--neutral-trans-10\";s:4:\"name\";s:20:\"bg--neutral-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1508;a:4:{s:2:\"id\";s:29:\"acss_import_bg--neutral-light\";s:4:\"name\";s:17:\"bg--neutral-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1509;a:4:{s:2:\"id\";s:38:\"acss_import_bg--neutral-light-trans-90\";s:4:\"name\";s:26:\"bg--neutral-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1510;a:4:{s:2:\"id\";s:38:\"acss_import_bg--neutral-light-trans-80\";s:4:\"name\";s:26:\"bg--neutral-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1511;a:4:{s:2:\"id\";s:38:\"acss_import_bg--neutral-light-trans-70\";s:4:\"name\";s:26:\"bg--neutral-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1512;a:4:{s:2:\"id\";s:38:\"acss_import_bg--neutral-light-trans-60\";s:4:\"name\";s:26:\"bg--neutral-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1513;a:4:{s:2:\"id\";s:38:\"acss_import_bg--neutral-light-trans-50\";s:4:\"name\";s:26:\"bg--neutral-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1514;a:4:{s:2:\"id\";s:38:\"acss_import_bg--neutral-light-trans-40\";s:4:\"name\";s:26:\"bg--neutral-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1515;a:4:{s:2:\"id\";s:38:\"acss_import_bg--neutral-light-trans-30\";s:4:\"name\";s:26:\"bg--neutral-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1516;a:4:{s:2:\"id\";s:38:\"acss_import_bg--neutral-light-trans-20\";s:4:\"name\";s:26:\"bg--neutral-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1517;a:4:{s:2:\"id\";s:38:\"acss_import_bg--neutral-light-trans-10\";s:4:\"name\";s:26:\"bg--neutral-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1518;a:4:{s:2:\"id\";s:35:\"acss_import_bg--neutral-ultra-light\";s:4:\"name\";s:23:\"bg--neutral-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1519;a:4:{s:2:\"id\";s:28:\"acss_import_bg--neutral-comp\";s:4:\"name\";s:16:\"bg--neutral-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1520;a:4:{s:2:\"id\";s:29:\"acss_import_bg--neutral-hover\";s:4:\"name\";s:17:\"bg--neutral-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1521;a:4:{s:2:\"id\";s:32:\"acss_import_bg--shade-ultra-dark\";s:4:\"name\";s:20:\"bg--shade-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1522;a:4:{s:2:\"id\";s:41:\"acss_import_bg--shade-ultra-dark-trans-90\";s:4:\"name\";s:29:\"bg--shade-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1523;a:4:{s:2:\"id\";s:41:\"acss_import_bg--shade-ultra-dark-trans-80\";s:4:\"name\";s:29:\"bg--shade-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1524;a:4:{s:2:\"id\";s:41:\"acss_import_bg--shade-ultra-dark-trans-70\";s:4:\"name\";s:29:\"bg--shade-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1525;a:4:{s:2:\"id\";s:41:\"acss_import_bg--shade-ultra-dark-trans-60\";s:4:\"name\";s:29:\"bg--shade-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1526;a:4:{s:2:\"id\";s:41:\"acss_import_bg--shade-ultra-dark-trans-50\";s:4:\"name\";s:29:\"bg--shade-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1527;a:4:{s:2:\"id\";s:41:\"acss_import_bg--shade-ultra-dark-trans-40\";s:4:\"name\";s:29:\"bg--shade-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1528;a:4:{s:2:\"id\";s:41:\"acss_import_bg--shade-ultra-dark-trans-30\";s:4:\"name\";s:29:\"bg--shade-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1529;a:4:{s:2:\"id\";s:41:\"acss_import_bg--shade-ultra-dark-trans-20\";s:4:\"name\";s:29:\"bg--shade-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1530;a:4:{s:2:\"id\";s:41:\"acss_import_bg--shade-ultra-dark-trans-10\";s:4:\"name\";s:29:\"bg--shade-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1531;a:4:{s:2:\"id\";s:26:\"acss_import_bg--shade-dark\";s:4:\"name\";s:14:\"bg--shade-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1532;a:4:{s:2:\"id\";s:35:\"acss_import_bg--shade-dark-trans-90\";s:4:\"name\";s:23:\"bg--shade-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1533;a:4:{s:2:\"id\";s:35:\"acss_import_bg--shade-dark-trans-80\";s:4:\"name\";s:23:\"bg--shade-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1534;a:4:{s:2:\"id\";s:35:\"acss_import_bg--shade-dark-trans-70\";s:4:\"name\";s:23:\"bg--shade-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1535;a:4:{s:2:\"id\";s:35:\"acss_import_bg--shade-dark-trans-60\";s:4:\"name\";s:23:\"bg--shade-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1536;a:4:{s:2:\"id\";s:35:\"acss_import_bg--shade-dark-trans-50\";s:4:\"name\";s:23:\"bg--shade-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1537;a:4:{s:2:\"id\";s:35:\"acss_import_bg--shade-dark-trans-40\";s:4:\"name\";s:23:\"bg--shade-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1538;a:4:{s:2:\"id\";s:35:\"acss_import_bg--shade-dark-trans-30\";s:4:\"name\";s:23:\"bg--shade-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1539;a:4:{s:2:\"id\";s:35:\"acss_import_bg--shade-dark-trans-20\";s:4:\"name\";s:23:\"bg--shade-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1540;a:4:{s:2:\"id\";s:35:\"acss_import_bg--shade-dark-trans-10\";s:4:\"name\";s:23:\"bg--shade-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1541;a:4:{s:2:\"id\";s:28:\"acss_import_bg--shade-medium\";s:4:\"name\";s:16:\"bg--shade-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1542;a:4:{s:2:\"id\";s:21:\"acss_import_bg--shade\";s:4:\"name\";s:9:\"bg--shade\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1543;a:4:{s:2:\"id\";s:30:\"acss_import_bg--shade-trans-90\";s:4:\"name\";s:18:\"bg--shade-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1544;a:4:{s:2:\"id\";s:30:\"acss_import_bg--shade-trans-80\";s:4:\"name\";s:18:\"bg--shade-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1545;a:4:{s:2:\"id\";s:30:\"acss_import_bg--shade-trans-70\";s:4:\"name\";s:18:\"bg--shade-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1546;a:4:{s:2:\"id\";s:30:\"acss_import_bg--shade-trans-60\";s:4:\"name\";s:18:\"bg--shade-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1547;a:4:{s:2:\"id\";s:30:\"acss_import_bg--shade-trans-50\";s:4:\"name\";s:18:\"bg--shade-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1548;a:4:{s:2:\"id\";s:30:\"acss_import_bg--shade-trans-40\";s:4:\"name\";s:18:\"bg--shade-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1549;a:4:{s:2:\"id\";s:30:\"acss_import_bg--shade-trans-30\";s:4:\"name\";s:18:\"bg--shade-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1550;a:4:{s:2:\"id\";s:30:\"acss_import_bg--shade-trans-20\";s:4:\"name\";s:18:\"bg--shade-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1551;a:4:{s:2:\"id\";s:30:\"acss_import_bg--shade-trans-10\";s:4:\"name\";s:18:\"bg--shade-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1552;a:4:{s:2:\"id\";s:27:\"acss_import_bg--shade-light\";s:4:\"name\";s:15:\"bg--shade-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1553;a:4:{s:2:\"id\";s:36:\"acss_import_bg--shade-light-trans-90\";s:4:\"name\";s:24:\"bg--shade-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1554;a:4:{s:2:\"id\";s:36:\"acss_import_bg--shade-light-trans-80\";s:4:\"name\";s:24:\"bg--shade-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1555;a:4:{s:2:\"id\";s:36:\"acss_import_bg--shade-light-trans-70\";s:4:\"name\";s:24:\"bg--shade-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1556;a:4:{s:2:\"id\";s:36:\"acss_import_bg--shade-light-trans-60\";s:4:\"name\";s:24:\"bg--shade-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1557;a:4:{s:2:\"id\";s:36:\"acss_import_bg--shade-light-trans-50\";s:4:\"name\";s:24:\"bg--shade-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1558;a:4:{s:2:\"id\";s:36:\"acss_import_bg--shade-light-trans-40\";s:4:\"name\";s:24:\"bg--shade-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1559;a:4:{s:2:\"id\";s:36:\"acss_import_bg--shade-light-trans-30\";s:4:\"name\";s:24:\"bg--shade-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1560;a:4:{s:2:\"id\";s:36:\"acss_import_bg--shade-light-trans-20\";s:4:\"name\";s:24:\"bg--shade-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1561;a:4:{s:2:\"id\";s:36:\"acss_import_bg--shade-light-trans-10\";s:4:\"name\";s:24:\"bg--shade-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1562;a:4:{s:2:\"id\";s:33:\"acss_import_bg--shade-ultra-light\";s:4:\"name\";s:21:\"bg--shade-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1563;a:4:{s:2:\"id\";s:26:\"acss_import_bg--shade-comp\";s:4:\"name\";s:14:\"bg--shade-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1564;a:4:{s:2:\"id\";s:27:\"acss_import_bg--shade-hover\";s:4:\"name\";s:15:\"bg--shade-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1565;a:4:{s:2:\"id\";s:21:\"acss_import_bg--black\";s:4:\"name\";s:9:\"bg--black\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1566;a:4:{s:2:\"id\";s:30:\"acss_import_bg--black-trans-90\";s:4:\"name\";s:18:\"bg--black-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1567;a:4:{s:2:\"id\";s:30:\"acss_import_bg--black-trans-80\";s:4:\"name\";s:18:\"bg--black-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1568;a:4:{s:2:\"id\";s:30:\"acss_import_bg--black-trans-70\";s:4:\"name\";s:18:\"bg--black-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1569;a:4:{s:2:\"id\";s:30:\"acss_import_bg--black-trans-60\";s:4:\"name\";s:18:\"bg--black-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1570;a:4:{s:2:\"id\";s:30:\"acss_import_bg--black-trans-50\";s:4:\"name\";s:18:\"bg--black-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1571;a:4:{s:2:\"id\";s:30:\"acss_import_bg--black-trans-40\";s:4:\"name\";s:18:\"bg--black-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1572;a:4:{s:2:\"id\";s:30:\"acss_import_bg--black-trans-30\";s:4:\"name\";s:18:\"bg--black-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1573;a:4:{s:2:\"id\";s:30:\"acss_import_bg--black-trans-20\";s:4:\"name\";s:18:\"bg--black-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1574;a:4:{s:2:\"id\";s:30:\"acss_import_bg--black-trans-10\";s:4:\"name\";s:18:\"bg--black-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1575;a:4:{s:2:\"id\";s:21:\"acss_import_bg--white\";s:4:\"name\";s:9:\"bg--white\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1576;a:4:{s:2:\"id\";s:30:\"acss_import_bg--white-trans-90\";s:4:\"name\";s:18:\"bg--white-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1577;a:4:{s:2:\"id\";s:30:\"acss_import_bg--white-trans-80\";s:4:\"name\";s:18:\"bg--white-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1578;a:4:{s:2:\"id\";s:30:\"acss_import_bg--white-trans-70\";s:4:\"name\";s:18:\"bg--white-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1579;a:4:{s:2:\"id\";s:30:\"acss_import_bg--white-trans-60\";s:4:\"name\";s:18:\"bg--white-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1580;a:4:{s:2:\"id\";s:30:\"acss_import_bg--white-trans-50\";s:4:\"name\";s:18:\"bg--white-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1581;a:4:{s:2:\"id\";s:30:\"acss_import_bg--white-trans-40\";s:4:\"name\";s:18:\"bg--white-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1582;a:4:{s:2:\"id\";s:30:\"acss_import_bg--white-trans-30\";s:4:\"name\";s:18:\"bg--white-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1583;a:4:{s:2:\"id\";s:30:\"acss_import_bg--white-trans-20\";s:4:\"name\";s:18:\"bg--white-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1584;a:4:{s:2:\"id\";s:30:\"acss_import_bg--white-trans-10\";s:4:\"name\";s:18:\"bg--white-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1585;a:4:{s:2:\"id\";s:23:\"acss_import_bg--success\";s:4:\"name\";s:11:\"bg--success\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1586;a:4:{s:2:\"id\";s:29:\"acss_import_bg--success-light\";s:4:\"name\";s:17:\"bg--success-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1587;a:4:{s:2:\"id\";s:28:\"acss_import_bg--success-dark\";s:4:\"name\";s:16:\"bg--success-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1588;a:4:{s:2:\"id\";s:29:\"acss_import_bg--success-hover\";s:4:\"name\";s:17:\"bg--success-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1589;a:4:{s:2:\"id\";s:22:\"acss_import_bg--danger\";s:4:\"name\";s:10:\"bg--danger\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1590;a:4:{s:2:\"id\";s:28:\"acss_import_bg--danger-light\";s:4:\"name\";s:16:\"bg--danger-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1591;a:4:{s:2:\"id\";s:27:\"acss_import_bg--danger-dark\";s:4:\"name\";s:15:\"bg--danger-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1592;a:4:{s:2:\"id\";s:28:\"acss_import_bg--danger-hover\";s:4:\"name\";s:16:\"bg--danger-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1593;a:4:{s:2:\"id\";s:23:\"acss_import_bg--warning\";s:4:\"name\";s:11:\"bg--warning\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1594;a:4:{s:2:\"id\";s:29:\"acss_import_bg--warning-light\";s:4:\"name\";s:17:\"bg--warning-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1595;a:4:{s:2:\"id\";s:28:\"acss_import_bg--warning-dark\";s:4:\"name\";s:16:\"bg--warning-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1596;a:4:{s:2:\"id\";s:29:\"acss_import_bg--warning-hover\";s:4:\"name\";s:17:\"bg--warning-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1597;a:4:{s:2:\"id\";s:20:\"acss_import_bg--info\";s:4:\"name\";s:8:\"bg--info\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1598;a:4:{s:2:\"id\";s:26:\"acss_import_bg--info-light\";s:4:\"name\";s:14:\"bg--info-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1599;a:4:{s:2:\"id\";s:25:\"acss_import_bg--info-dark\";s:4:\"name\";s:13:\"bg--info-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1600;a:4:{s:2:\"id\";s:26:\"acss_import_bg--info-hover\";s:4:\"name\";s:14:\"bg--info-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1601;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--action-ultra-dark-trans-90\";s:4:\"name\";s:35:\"overlay--action-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1602;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--action-ultra-dark-trans-80\";s:4:\"name\";s:35:\"overlay--action-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1603;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--action-ultra-dark-trans-70\";s:4:\"name\";s:35:\"overlay--action-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1604;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--action-ultra-dark-trans-60\";s:4:\"name\";s:35:\"overlay--action-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1605;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--action-ultra-dark-trans-50\";s:4:\"name\";s:35:\"overlay--action-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1606;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--action-ultra-dark-trans-40\";s:4:\"name\";s:35:\"overlay--action-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1607;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--action-ultra-dark-trans-30\";s:4:\"name\";s:35:\"overlay--action-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1608;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--action-ultra-dark-trans-20\";s:4:\"name\";s:35:\"overlay--action-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1609;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--action-ultra-dark-trans-10\";s:4:\"name\";s:35:\"overlay--action-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1610;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--action-dark-trans-90\";s:4:\"name\";s:29:\"overlay--action-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1611;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--action-dark-trans-80\";s:4:\"name\";s:29:\"overlay--action-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1612;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--action-dark-trans-60\";s:4:\"name\";s:29:\"overlay--action-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1613;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--action-dark-trans-30\";s:4:\"name\";s:29:\"overlay--action-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1614;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--action-dark-trans-50\";s:4:\"name\";s:29:\"overlay--action-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1615;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--action-dark-trans-40\";s:4:\"name\";s:29:\"overlay--action-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1616;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--action-dark-trans-70\";s:4:\"name\";s:29:\"overlay--action-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1617;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--action-dark-trans-20\";s:4:\"name\";s:29:\"overlay--action-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1618;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--action-dark-trans-10\";s:4:\"name\";s:29:\"overlay--action-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1619;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--action-trans-90\";s:4:\"name\";s:24:\"overlay--action-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1620;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--action-trans-80\";s:4:\"name\";s:24:\"overlay--action-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1621;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--action-trans-70\";s:4:\"name\";s:24:\"overlay--action-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1622;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--action-trans-60\";s:4:\"name\";s:24:\"overlay--action-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1623;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--action-trans-50\";s:4:\"name\";s:24:\"overlay--action-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1624;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--action-trans-40\";s:4:\"name\";s:24:\"overlay--action-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1625;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--action-trans-30\";s:4:\"name\";s:24:\"overlay--action-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1626;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--action-trans-20\";s:4:\"name\";s:24:\"overlay--action-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1627;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--action-trans-10\";s:4:\"name\";s:24:\"overlay--action-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1628;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--action-light-trans-90\";s:4:\"name\";s:30:\"overlay--action-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1629;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--action-light-trans-80\";s:4:\"name\";s:30:\"overlay--action-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1630;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--action-light-trans-70\";s:4:\"name\";s:30:\"overlay--action-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1631;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--action-light-trans-60\";s:4:\"name\";s:30:\"overlay--action-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1632;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--action-light-trans-50\";s:4:\"name\";s:30:\"overlay--action-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1633;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--action-light-trans-40\";s:4:\"name\";s:30:\"overlay--action-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1634;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--action-light-trans-30\";s:4:\"name\";s:30:\"overlay--action-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1635;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--action-light-trans-20\";s:4:\"name\";s:30:\"overlay--action-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1636;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--action-light-trans-10\";s:4:\"name\";s:30:\"overlay--action-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1637;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--primary-ultra-dark-trans-90\";s:4:\"name\";s:36:\"overlay--primary-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1638;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--primary-ultra-dark-trans-80\";s:4:\"name\";s:36:\"overlay--primary-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1639;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--primary-ultra-dark-trans-70\";s:4:\"name\";s:36:\"overlay--primary-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1640;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--primary-ultra-dark-trans-60\";s:4:\"name\";s:36:\"overlay--primary-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1641;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--primary-ultra-dark-trans-50\";s:4:\"name\";s:36:\"overlay--primary-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1642;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--primary-ultra-dark-trans-40\";s:4:\"name\";s:36:\"overlay--primary-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1643;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--primary-ultra-dark-trans-30\";s:4:\"name\";s:36:\"overlay--primary-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1644;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--primary-ultra-dark-trans-20\";s:4:\"name\";s:36:\"overlay--primary-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1645;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--primary-ultra-dark-trans-10\";s:4:\"name\";s:36:\"overlay--primary-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1646;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--primary-dark-trans-90\";s:4:\"name\";s:30:\"overlay--primary-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1647;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--primary-dark-trans-80\";s:4:\"name\";s:30:\"overlay--primary-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1648;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--primary-dark-trans-60\";s:4:\"name\";s:30:\"overlay--primary-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1649;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--primary-dark-trans-30\";s:4:\"name\";s:30:\"overlay--primary-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1650;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--primary-dark-trans-50\";s:4:\"name\";s:30:\"overlay--primary-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1651;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--primary-dark-trans-40\";s:4:\"name\";s:30:\"overlay--primary-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1652;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--primary-dark-trans-70\";s:4:\"name\";s:30:\"overlay--primary-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1653;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--primary-dark-trans-20\";s:4:\"name\";s:30:\"overlay--primary-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1654;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--primary-dark-trans-10\";s:4:\"name\";s:30:\"overlay--primary-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1655;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--primary-trans-90\";s:4:\"name\";s:25:\"overlay--primary-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1656;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--primary-trans-80\";s:4:\"name\";s:25:\"overlay--primary-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1657;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--primary-trans-70\";s:4:\"name\";s:25:\"overlay--primary-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1658;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--primary-trans-60\";s:4:\"name\";s:25:\"overlay--primary-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1659;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--primary-trans-50\";s:4:\"name\";s:25:\"overlay--primary-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1660;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--primary-trans-40\";s:4:\"name\";s:25:\"overlay--primary-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1661;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--primary-trans-30\";s:4:\"name\";s:25:\"overlay--primary-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1662;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--primary-trans-20\";s:4:\"name\";s:25:\"overlay--primary-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1663;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--primary-trans-10\";s:4:\"name\";s:25:\"overlay--primary-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1664;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--primary-light-trans-90\";s:4:\"name\";s:31:\"overlay--primary-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1665;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--primary-light-trans-80\";s:4:\"name\";s:31:\"overlay--primary-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1666;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--primary-light-trans-70\";s:4:\"name\";s:31:\"overlay--primary-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1667;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--primary-light-trans-60\";s:4:\"name\";s:31:\"overlay--primary-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1668;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--primary-light-trans-50\";s:4:\"name\";s:31:\"overlay--primary-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1669;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--primary-light-trans-40\";s:4:\"name\";s:31:\"overlay--primary-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1670;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--primary-light-trans-30\";s:4:\"name\";s:31:\"overlay--primary-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1671;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--primary-light-trans-20\";s:4:\"name\";s:31:\"overlay--primary-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1672;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--primary-light-trans-10\";s:4:\"name\";s:31:\"overlay--primary-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1673;a:4:{s:2:\"id\";s:50:\"acss_import_overlay--secondary-ultra-dark-trans-90\";s:4:\"name\";s:38:\"overlay--secondary-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1674;a:4:{s:2:\"id\";s:50:\"acss_import_overlay--secondary-ultra-dark-trans-80\";s:4:\"name\";s:38:\"overlay--secondary-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1675;a:4:{s:2:\"id\";s:50:\"acss_import_overlay--secondary-ultra-dark-trans-70\";s:4:\"name\";s:38:\"overlay--secondary-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1676;a:4:{s:2:\"id\";s:50:\"acss_import_overlay--secondary-ultra-dark-trans-60\";s:4:\"name\";s:38:\"overlay--secondary-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1677;a:4:{s:2:\"id\";s:50:\"acss_import_overlay--secondary-ultra-dark-trans-50\";s:4:\"name\";s:38:\"overlay--secondary-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1678;a:4:{s:2:\"id\";s:50:\"acss_import_overlay--secondary-ultra-dark-trans-40\";s:4:\"name\";s:38:\"overlay--secondary-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1679;a:4:{s:2:\"id\";s:50:\"acss_import_overlay--secondary-ultra-dark-trans-30\";s:4:\"name\";s:38:\"overlay--secondary-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1680;a:4:{s:2:\"id\";s:50:\"acss_import_overlay--secondary-ultra-dark-trans-20\";s:4:\"name\";s:38:\"overlay--secondary-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1681;a:4:{s:2:\"id\";s:50:\"acss_import_overlay--secondary-ultra-dark-trans-10\";s:4:\"name\";s:38:\"overlay--secondary-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1682;a:4:{s:2:\"id\";s:44:\"acss_import_overlay--secondary-dark-trans-90\";s:4:\"name\";s:32:\"overlay--secondary-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1683;a:4:{s:2:\"id\";s:44:\"acss_import_overlay--secondary-dark-trans-80\";s:4:\"name\";s:32:\"overlay--secondary-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1684;a:4:{s:2:\"id\";s:44:\"acss_import_overlay--secondary-dark-trans-60\";s:4:\"name\";s:32:\"overlay--secondary-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1685;a:4:{s:2:\"id\";s:44:\"acss_import_overlay--secondary-dark-trans-30\";s:4:\"name\";s:32:\"overlay--secondary-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1686;a:4:{s:2:\"id\";s:44:\"acss_import_overlay--secondary-dark-trans-50\";s:4:\"name\";s:32:\"overlay--secondary-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1687;a:4:{s:2:\"id\";s:44:\"acss_import_overlay--secondary-dark-trans-40\";s:4:\"name\";s:32:\"overlay--secondary-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1688;a:4:{s:2:\"id\";s:44:\"acss_import_overlay--secondary-dark-trans-70\";s:4:\"name\";s:32:\"overlay--secondary-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1689;a:4:{s:2:\"id\";s:44:\"acss_import_overlay--secondary-dark-trans-20\";s:4:\"name\";s:32:\"overlay--secondary-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1690;a:4:{s:2:\"id\";s:44:\"acss_import_overlay--secondary-dark-trans-10\";s:4:\"name\";s:32:\"overlay--secondary-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1691;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--secondary-trans-90\";s:4:\"name\";s:27:\"overlay--secondary-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1692;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--secondary-trans-80\";s:4:\"name\";s:27:\"overlay--secondary-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1693;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--secondary-trans-70\";s:4:\"name\";s:27:\"overlay--secondary-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1694;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--secondary-trans-60\";s:4:\"name\";s:27:\"overlay--secondary-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1695;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--secondary-trans-50\";s:4:\"name\";s:27:\"overlay--secondary-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1696;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--secondary-trans-40\";s:4:\"name\";s:27:\"overlay--secondary-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1697;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--secondary-trans-30\";s:4:\"name\";s:27:\"overlay--secondary-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1698;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--secondary-trans-20\";s:4:\"name\";s:27:\"overlay--secondary-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1699;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--secondary-trans-10\";s:4:\"name\";s:27:\"overlay--secondary-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1700;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--secondary-light-trans-90\";s:4:\"name\";s:33:\"overlay--secondary-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1701;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--secondary-light-trans-80\";s:4:\"name\";s:33:\"overlay--secondary-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1702;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--secondary-light-trans-70\";s:4:\"name\";s:33:\"overlay--secondary-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1703;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--secondary-light-trans-60\";s:4:\"name\";s:33:\"overlay--secondary-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1704;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--secondary-light-trans-50\";s:4:\"name\";s:33:\"overlay--secondary-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1705;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--secondary-light-trans-40\";s:4:\"name\";s:33:\"overlay--secondary-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1706;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--secondary-light-trans-30\";s:4:\"name\";s:33:\"overlay--secondary-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1707;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--secondary-light-trans-20\";s:4:\"name\";s:33:\"overlay--secondary-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1708;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--secondary-light-trans-10\";s:4:\"name\";s:33:\"overlay--secondary-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1709;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--accent-ultra-dark-trans-90\";s:4:\"name\";s:35:\"overlay--accent-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1710;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--accent-ultra-dark-trans-80\";s:4:\"name\";s:35:\"overlay--accent-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1711;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--accent-ultra-dark-trans-70\";s:4:\"name\";s:35:\"overlay--accent-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1712;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--accent-ultra-dark-trans-60\";s:4:\"name\";s:35:\"overlay--accent-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1713;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--accent-ultra-dark-trans-50\";s:4:\"name\";s:35:\"overlay--accent-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1714;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--accent-ultra-dark-trans-40\";s:4:\"name\";s:35:\"overlay--accent-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1715;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--accent-ultra-dark-trans-30\";s:4:\"name\";s:35:\"overlay--accent-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1716;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--accent-ultra-dark-trans-20\";s:4:\"name\";s:35:\"overlay--accent-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1717;a:4:{s:2:\"id\";s:47:\"acss_import_overlay--accent-ultra-dark-trans-10\";s:4:\"name\";s:35:\"overlay--accent-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1718;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--accent-dark-trans-90\";s:4:\"name\";s:29:\"overlay--accent-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1719;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--accent-dark-trans-80\";s:4:\"name\";s:29:\"overlay--accent-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1720;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--accent-dark-trans-60\";s:4:\"name\";s:29:\"overlay--accent-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1721;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--accent-dark-trans-30\";s:4:\"name\";s:29:\"overlay--accent-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1722;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--accent-dark-trans-50\";s:4:\"name\";s:29:\"overlay--accent-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1723;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--accent-dark-trans-40\";s:4:\"name\";s:29:\"overlay--accent-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1724;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--accent-dark-trans-70\";s:4:\"name\";s:29:\"overlay--accent-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1725;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--accent-dark-trans-20\";s:4:\"name\";s:29:\"overlay--accent-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1726;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--accent-dark-trans-10\";s:4:\"name\";s:29:\"overlay--accent-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1727;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--accent-trans-90\";s:4:\"name\";s:24:\"overlay--accent-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1728;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--accent-trans-80\";s:4:\"name\";s:24:\"overlay--accent-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1729;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--accent-trans-70\";s:4:\"name\";s:24:\"overlay--accent-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1730;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--accent-trans-60\";s:4:\"name\";s:24:\"overlay--accent-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1731;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--accent-trans-50\";s:4:\"name\";s:24:\"overlay--accent-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1732;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--accent-trans-40\";s:4:\"name\";s:24:\"overlay--accent-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1733;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--accent-trans-30\";s:4:\"name\";s:24:\"overlay--accent-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1734;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--accent-trans-20\";s:4:\"name\";s:24:\"overlay--accent-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1735;a:4:{s:2:\"id\";s:36:\"acss_import_overlay--accent-trans-10\";s:4:\"name\";s:24:\"overlay--accent-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1736;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--accent-light-trans-90\";s:4:\"name\";s:30:\"overlay--accent-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1737;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--accent-light-trans-80\";s:4:\"name\";s:30:\"overlay--accent-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1738;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--accent-light-trans-70\";s:4:\"name\";s:30:\"overlay--accent-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1739;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--accent-light-trans-60\";s:4:\"name\";s:30:\"overlay--accent-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1740;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--accent-light-trans-50\";s:4:\"name\";s:30:\"overlay--accent-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1741;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--accent-light-trans-40\";s:4:\"name\";s:30:\"overlay--accent-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1742;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--accent-light-trans-30\";s:4:\"name\";s:30:\"overlay--accent-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1743;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--accent-light-trans-20\";s:4:\"name\";s:30:\"overlay--accent-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1744;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--accent-light-trans-10\";s:4:\"name\";s:30:\"overlay--accent-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1745;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--base-ultra-dark-trans-90\";s:4:\"name\";s:33:\"overlay--base-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1746;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--base-ultra-dark-trans-80\";s:4:\"name\";s:33:\"overlay--base-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1747;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--base-ultra-dark-trans-70\";s:4:\"name\";s:33:\"overlay--base-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1748;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--base-ultra-dark-trans-60\";s:4:\"name\";s:33:\"overlay--base-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1749;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--base-ultra-dark-trans-50\";s:4:\"name\";s:33:\"overlay--base-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1750;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--base-ultra-dark-trans-40\";s:4:\"name\";s:33:\"overlay--base-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1751;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--base-ultra-dark-trans-30\";s:4:\"name\";s:33:\"overlay--base-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1752;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--base-ultra-dark-trans-20\";s:4:\"name\";s:33:\"overlay--base-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1753;a:4:{s:2:\"id\";s:45:\"acss_import_overlay--base-ultra-dark-trans-10\";s:4:\"name\";s:33:\"overlay--base-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1754;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--base-dark-trans-90\";s:4:\"name\";s:27:\"overlay--base-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1755;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--base-dark-trans-80\";s:4:\"name\";s:27:\"overlay--base-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1756;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--base-dark-trans-60\";s:4:\"name\";s:27:\"overlay--base-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1757;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--base-dark-trans-30\";s:4:\"name\";s:27:\"overlay--base-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1758;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--base-dark-trans-50\";s:4:\"name\";s:27:\"overlay--base-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1759;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--base-dark-trans-40\";s:4:\"name\";s:27:\"overlay--base-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1760;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--base-dark-trans-70\";s:4:\"name\";s:27:\"overlay--base-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1761;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--base-dark-trans-20\";s:4:\"name\";s:27:\"overlay--base-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1762;a:4:{s:2:\"id\";s:39:\"acss_import_overlay--base-dark-trans-10\";s:4:\"name\";s:27:\"overlay--base-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1763;a:4:{s:2:\"id\";s:34:\"acss_import_overlay--base-trans-90\";s:4:\"name\";s:22:\"overlay--base-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1764;a:4:{s:2:\"id\";s:34:\"acss_import_overlay--base-trans-80\";s:4:\"name\";s:22:\"overlay--base-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1765;a:4:{s:2:\"id\";s:34:\"acss_import_overlay--base-trans-70\";s:4:\"name\";s:22:\"overlay--base-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1766;a:4:{s:2:\"id\";s:34:\"acss_import_overlay--base-trans-60\";s:4:\"name\";s:22:\"overlay--base-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1767;a:4:{s:2:\"id\";s:34:\"acss_import_overlay--base-trans-50\";s:4:\"name\";s:22:\"overlay--base-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1768;a:4:{s:2:\"id\";s:34:\"acss_import_overlay--base-trans-40\";s:4:\"name\";s:22:\"overlay--base-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1769;a:4:{s:2:\"id\";s:34:\"acss_import_overlay--base-trans-30\";s:4:\"name\";s:22:\"overlay--base-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1770;a:4:{s:2:\"id\";s:34:\"acss_import_overlay--base-trans-20\";s:4:\"name\";s:22:\"overlay--base-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1771;a:4:{s:2:\"id\";s:34:\"acss_import_overlay--base-trans-10\";s:4:\"name\";s:22:\"overlay--base-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1772;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--base-light-trans-90\";s:4:\"name\";s:28:\"overlay--base-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1773;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--base-light-trans-80\";s:4:\"name\";s:28:\"overlay--base-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1774;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--base-light-trans-70\";s:4:\"name\";s:28:\"overlay--base-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1775;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--base-light-trans-60\";s:4:\"name\";s:28:\"overlay--base-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1776;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--base-light-trans-50\";s:4:\"name\";s:28:\"overlay--base-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1777;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--base-light-trans-40\";s:4:\"name\";s:28:\"overlay--base-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1778;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--base-light-trans-30\";s:4:\"name\";s:28:\"overlay--base-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1779;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--base-light-trans-20\";s:4:\"name\";s:28:\"overlay--base-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1780;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--base-light-trans-10\";s:4:\"name\";s:28:\"overlay--base-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1781;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--neutral-ultra-dark-trans-90\";s:4:\"name\";s:36:\"overlay--neutral-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1782;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--neutral-ultra-dark-trans-80\";s:4:\"name\";s:36:\"overlay--neutral-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1783;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--neutral-ultra-dark-trans-70\";s:4:\"name\";s:36:\"overlay--neutral-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1784;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--neutral-ultra-dark-trans-60\";s:4:\"name\";s:36:\"overlay--neutral-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1785;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--neutral-ultra-dark-trans-50\";s:4:\"name\";s:36:\"overlay--neutral-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1786;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--neutral-ultra-dark-trans-40\";s:4:\"name\";s:36:\"overlay--neutral-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1787;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--neutral-ultra-dark-trans-30\";s:4:\"name\";s:36:\"overlay--neutral-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1788;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--neutral-ultra-dark-trans-20\";s:4:\"name\";s:36:\"overlay--neutral-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1789;a:4:{s:2:\"id\";s:48:\"acss_import_overlay--neutral-ultra-dark-trans-10\";s:4:\"name\";s:36:\"overlay--neutral-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1790;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--neutral-dark-trans-90\";s:4:\"name\";s:30:\"overlay--neutral-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1791;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--neutral-dark-trans-80\";s:4:\"name\";s:30:\"overlay--neutral-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1792;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--neutral-dark-trans-60\";s:4:\"name\";s:30:\"overlay--neutral-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1793;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--neutral-dark-trans-30\";s:4:\"name\";s:30:\"overlay--neutral-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1794;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--neutral-dark-trans-50\";s:4:\"name\";s:30:\"overlay--neutral-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1795;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--neutral-dark-trans-40\";s:4:\"name\";s:30:\"overlay--neutral-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1796;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--neutral-dark-trans-70\";s:4:\"name\";s:30:\"overlay--neutral-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1797;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--neutral-dark-trans-20\";s:4:\"name\";s:30:\"overlay--neutral-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1798;a:4:{s:2:\"id\";s:42:\"acss_import_overlay--neutral-dark-trans-10\";s:4:\"name\";s:30:\"overlay--neutral-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1799;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--neutral-trans-90\";s:4:\"name\";s:25:\"overlay--neutral-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1800;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--neutral-trans-80\";s:4:\"name\";s:25:\"overlay--neutral-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1801;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--neutral-trans-70\";s:4:\"name\";s:25:\"overlay--neutral-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1802;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--neutral-trans-60\";s:4:\"name\";s:25:\"overlay--neutral-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1803;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--neutral-trans-50\";s:4:\"name\";s:25:\"overlay--neutral-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1804;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--neutral-trans-40\";s:4:\"name\";s:25:\"overlay--neutral-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1805;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--neutral-trans-30\";s:4:\"name\";s:25:\"overlay--neutral-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1806;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--neutral-trans-20\";s:4:\"name\";s:25:\"overlay--neutral-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1807;a:4:{s:2:\"id\";s:37:\"acss_import_overlay--neutral-trans-10\";s:4:\"name\";s:25:\"overlay--neutral-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1808;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--neutral-light-trans-90\";s:4:\"name\";s:31:\"overlay--neutral-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1809;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--neutral-light-trans-80\";s:4:\"name\";s:31:\"overlay--neutral-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1810;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--neutral-light-trans-70\";s:4:\"name\";s:31:\"overlay--neutral-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1811;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--neutral-light-trans-60\";s:4:\"name\";s:31:\"overlay--neutral-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1812;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--neutral-light-trans-50\";s:4:\"name\";s:31:\"overlay--neutral-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1813;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--neutral-light-trans-40\";s:4:\"name\";s:31:\"overlay--neutral-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1814;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--neutral-light-trans-30\";s:4:\"name\";s:31:\"overlay--neutral-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1815;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--neutral-light-trans-20\";s:4:\"name\";s:31:\"overlay--neutral-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1816;a:4:{s:2:\"id\";s:43:\"acss_import_overlay--neutral-light-trans-10\";s:4:\"name\";s:31:\"overlay--neutral-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1817;a:4:{s:2:\"id\";s:46:\"acss_import_overlay--shade-ultra-dark-trans-90\";s:4:\"name\";s:34:\"overlay--shade-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1818;a:4:{s:2:\"id\";s:46:\"acss_import_overlay--shade-ultra-dark-trans-80\";s:4:\"name\";s:34:\"overlay--shade-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1819;a:4:{s:2:\"id\";s:46:\"acss_import_overlay--shade-ultra-dark-trans-70\";s:4:\"name\";s:34:\"overlay--shade-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1820;a:4:{s:2:\"id\";s:46:\"acss_import_overlay--shade-ultra-dark-trans-60\";s:4:\"name\";s:34:\"overlay--shade-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1821;a:4:{s:2:\"id\";s:46:\"acss_import_overlay--shade-ultra-dark-trans-50\";s:4:\"name\";s:34:\"overlay--shade-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1822;a:4:{s:2:\"id\";s:46:\"acss_import_overlay--shade-ultra-dark-trans-40\";s:4:\"name\";s:34:\"overlay--shade-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1823;a:4:{s:2:\"id\";s:46:\"acss_import_overlay--shade-ultra-dark-trans-30\";s:4:\"name\";s:34:\"overlay--shade-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1824;a:4:{s:2:\"id\";s:46:\"acss_import_overlay--shade-ultra-dark-trans-20\";s:4:\"name\";s:34:\"overlay--shade-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1825;a:4:{s:2:\"id\";s:46:\"acss_import_overlay--shade-ultra-dark-trans-10\";s:4:\"name\";s:34:\"overlay--shade-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1826;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--shade-dark-trans-90\";s:4:\"name\";s:28:\"overlay--shade-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1827;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--shade-dark-trans-80\";s:4:\"name\";s:28:\"overlay--shade-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1828;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--shade-dark-trans-60\";s:4:\"name\";s:28:\"overlay--shade-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1829;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--shade-dark-trans-30\";s:4:\"name\";s:28:\"overlay--shade-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1830;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--shade-dark-trans-50\";s:4:\"name\";s:28:\"overlay--shade-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1831;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--shade-dark-trans-40\";s:4:\"name\";s:28:\"overlay--shade-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1832;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--shade-dark-trans-70\";s:4:\"name\";s:28:\"overlay--shade-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1833;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--shade-dark-trans-20\";s:4:\"name\";s:28:\"overlay--shade-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1834;a:4:{s:2:\"id\";s:40:\"acss_import_overlay--shade-dark-trans-10\";s:4:\"name\";s:28:\"overlay--shade-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1835;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--shade-trans-90\";s:4:\"name\";s:23:\"overlay--shade-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1836;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--shade-trans-80\";s:4:\"name\";s:23:\"overlay--shade-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1837;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--shade-trans-70\";s:4:\"name\";s:23:\"overlay--shade-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1838;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--shade-trans-60\";s:4:\"name\";s:23:\"overlay--shade-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1839;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--shade-trans-50\";s:4:\"name\";s:23:\"overlay--shade-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1840;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--shade-trans-40\";s:4:\"name\";s:23:\"overlay--shade-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1841;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--shade-trans-30\";s:4:\"name\";s:23:\"overlay--shade-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1842;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--shade-trans-20\";s:4:\"name\";s:23:\"overlay--shade-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1843;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--shade-trans-10\";s:4:\"name\";s:23:\"overlay--shade-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1844;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--shade-light-trans-90\";s:4:\"name\";s:29:\"overlay--shade-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1845;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--shade-light-trans-80\";s:4:\"name\";s:29:\"overlay--shade-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1846;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--shade-light-trans-70\";s:4:\"name\";s:29:\"overlay--shade-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1847;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--shade-light-trans-60\";s:4:\"name\";s:29:\"overlay--shade-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1848;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--shade-light-trans-50\";s:4:\"name\";s:29:\"overlay--shade-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1849;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--shade-light-trans-40\";s:4:\"name\";s:29:\"overlay--shade-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1850;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--shade-light-trans-30\";s:4:\"name\";s:29:\"overlay--shade-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1851;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--shade-light-trans-20\";s:4:\"name\";s:29:\"overlay--shade-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1852;a:4:{s:2:\"id\";s:41:\"acss_import_overlay--shade-light-trans-10\";s:4:\"name\";s:29:\"overlay--shade-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1853;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--black-trans-90\";s:4:\"name\";s:23:\"overlay--black-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1854;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--black-trans-80\";s:4:\"name\";s:23:\"overlay--black-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1855;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--black-trans-70\";s:4:\"name\";s:23:\"overlay--black-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1856;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--black-trans-60\";s:4:\"name\";s:23:\"overlay--black-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1857;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--black-trans-50\";s:4:\"name\";s:23:\"overlay--black-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1858;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--black-trans-40\";s:4:\"name\";s:23:\"overlay--black-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1859;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--black-trans-30\";s:4:\"name\";s:23:\"overlay--black-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1860;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--black-trans-20\";s:4:\"name\";s:23:\"overlay--black-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1861;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--black-trans-10\";s:4:\"name\";s:23:\"overlay--black-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1862;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--white-trans-90\";s:4:\"name\";s:23:\"overlay--white-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1863;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--white-trans-80\";s:4:\"name\";s:23:\"overlay--white-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1864;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--white-trans-70\";s:4:\"name\";s:23:\"overlay--white-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1865;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--white-trans-60\";s:4:\"name\";s:23:\"overlay--white-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1866;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--white-trans-50\";s:4:\"name\";s:23:\"overlay--white-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1867;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--white-trans-40\";s:4:\"name\";s:23:\"overlay--white-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1868;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--white-trans-30\";s:4:\"name\";s:23:\"overlay--white-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1869;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--white-trans-20\";s:4:\"name\";s:23:\"overlay--white-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1870;a:4:{s:2:\"id\";s:35:\"acss_import_overlay--white-trans-10\";s:4:\"name\";s:23:\"overlay--white-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1871;a:4:{s:2:\"id\";s:24:\"acss_import_btn--outline\";s:4:\"name\";s:12:\"btn--outline\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1872;a:4:{s:2:\"id\";s:22:\"acss_import_btn--clear\";s:4:\"name\";s:10:\"btn--clear\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1873;a:4:{s:2:\"id\";s:23:\"acss_import_btn--action\";s:4:\"name\";s:11:\"btn--action\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1874;a:4:{s:2:\"id\";s:24:\"acss_import_btn--primary\";s:4:\"name\";s:12:\"btn--primary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1875;a:4:{s:2:\"id\";s:26:\"acss_import_btn--secondary\";s:4:\"name\";s:14:\"btn--secondary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1876;a:4:{s:2:\"id\";s:23:\"acss_import_btn--accent\";s:4:\"name\";s:11:\"btn--accent\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1877;a:4:{s:2:\"id\";s:21:\"acss_import_btn--base\";s:4:\"name\";s:9:\"btn--base\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1878;a:4:{s:2:\"id\";s:22:\"acss_import_btn--black\";s:4:\"name\";s:10:\"btn--black\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1879;a:4:{s:2:\"id\";s:22:\"acss_import_btn--white\";s:4:\"name\";s:10:\"btn--white\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1880;a:4:{s:2:\"id\";s:19:\"acss_import_btn--xs\";s:4:\"name\";s:7:\"btn--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1881;a:4:{s:2:\"id\";s:18:\"acss_import_btn--s\";s:4:\"name\";s:6:\"btn--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1882;a:4:{s:2:\"id\";s:18:\"acss_import_btn--m\";s:4:\"name\";s:6:\"btn--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1883;a:4:{s:2:\"id\";s:18:\"acss_import_btn--l\";s:4:\"name\";s:6:\"btn--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1884;a:4:{s:2:\"id\";s:19:\"acss_import_btn--xl\";s:4:\"name\";s:7:\"btn--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1885;a:4:{s:2:\"id\";s:20:\"acss_import_btn--xxl\";s:4:\"name\";s:8:\"btn--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1886;a:4:{s:2:\"id\";s:22:\"acss_import_link--skip\";s:4:\"name\";s:10:\"link--skip\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1887;a:4:{s:2:\"id\";s:21:\"acss_import_skip-link\";s:4:\"name\";s:9:\"skip-link\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1888;a:4:{s:2:\"id\";s:35:\"acss_import_link--action-ultra-dark\";s:4:\"name\";s:23:\"link--action-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1889;a:4:{s:2:\"id\";s:29:\"acss_import_link--action-dark\";s:4:\"name\";s:17:\"link--action-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1890;a:4:{s:2:\"id\";s:31:\"acss_import_link--action-medium\";s:4:\"name\";s:19:\"link--action-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1891;a:4:{s:2:\"id\";s:24:\"acss_import_link--action\";s:4:\"name\";s:12:\"link--action\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1892;a:4:{s:2:\"id\";s:30:\"acss_import_link--action-light\";s:4:\"name\";s:18:\"link--action-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1893;a:4:{s:2:\"id\";s:36:\"acss_import_link--action-ultra-light\";s:4:\"name\";s:24:\"link--action-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1894;a:4:{s:2:\"id\";s:29:\"acss_import_link--action-comp\";s:4:\"name\";s:17:\"link--action-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1895;a:4:{s:2:\"id\";s:30:\"acss_import_link--action-hover\";s:4:\"name\";s:18:\"link--action-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1896;a:4:{s:2:\"id\";s:36:\"acss_import_link--primary-ultra-dark\";s:4:\"name\";s:24:\"link--primary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1897;a:4:{s:2:\"id\";s:30:\"acss_import_link--primary-dark\";s:4:\"name\";s:18:\"link--primary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1898;a:4:{s:2:\"id\";s:32:\"acss_import_link--primary-medium\";s:4:\"name\";s:20:\"link--primary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1899;a:4:{s:2:\"id\";s:25:\"acss_import_link--primary\";s:4:\"name\";s:13:\"link--primary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1900;a:4:{s:2:\"id\";s:31:\"acss_import_link--primary-light\";s:4:\"name\";s:19:\"link--primary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1901;a:4:{s:2:\"id\";s:37:\"acss_import_link--primary-ultra-light\";s:4:\"name\";s:25:\"link--primary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1902;a:4:{s:2:\"id\";s:30:\"acss_import_link--primary-comp\";s:4:\"name\";s:18:\"link--primary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1903;a:4:{s:2:\"id\";s:31:\"acss_import_link--primary-hover\";s:4:\"name\";s:19:\"link--primary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1904;a:4:{s:2:\"id\";s:38:\"acss_import_link--secondary-ultra-dark\";s:4:\"name\";s:26:\"link--secondary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1905;a:4:{s:2:\"id\";s:32:\"acss_import_link--secondary-dark\";s:4:\"name\";s:20:\"link--secondary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1906;a:4:{s:2:\"id\";s:34:\"acss_import_link--secondary-medium\";s:4:\"name\";s:22:\"link--secondary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1907;a:4:{s:2:\"id\";s:27:\"acss_import_link--secondary\";s:4:\"name\";s:15:\"link--secondary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1908;a:4:{s:2:\"id\";s:33:\"acss_import_link--secondary-light\";s:4:\"name\";s:21:\"link--secondary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1909;a:4:{s:2:\"id\";s:39:\"acss_import_link--secondary-ultra-light\";s:4:\"name\";s:27:\"link--secondary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1910;a:4:{s:2:\"id\";s:32:\"acss_import_link--secondary-comp\";s:4:\"name\";s:20:\"link--secondary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1911;a:4:{s:2:\"id\";s:33:\"acss_import_link--secondary-hover\";s:4:\"name\";s:21:\"link--secondary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1912;a:4:{s:2:\"id\";s:35:\"acss_import_link--accent-ultra-dark\";s:4:\"name\";s:23:\"link--accent-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1913;a:4:{s:2:\"id\";s:29:\"acss_import_link--accent-dark\";s:4:\"name\";s:17:\"link--accent-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1914;a:4:{s:2:\"id\";s:31:\"acss_import_link--accent-medium\";s:4:\"name\";s:19:\"link--accent-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1915;a:4:{s:2:\"id\";s:24:\"acss_import_link--accent\";s:4:\"name\";s:12:\"link--accent\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1916;a:4:{s:2:\"id\";s:30:\"acss_import_link--accent-light\";s:4:\"name\";s:18:\"link--accent-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1917;a:4:{s:2:\"id\";s:36:\"acss_import_link--accent-ultra-light\";s:4:\"name\";s:24:\"link--accent-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1918;a:4:{s:2:\"id\";s:29:\"acss_import_link--accent-comp\";s:4:\"name\";s:17:\"link--accent-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1919;a:4:{s:2:\"id\";s:30:\"acss_import_link--accent-hover\";s:4:\"name\";s:18:\"link--accent-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1920;a:4:{s:2:\"id\";s:33:\"acss_import_link--base-ultra-dark\";s:4:\"name\";s:21:\"link--base-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1921;a:4:{s:2:\"id\";s:27:\"acss_import_link--base-dark\";s:4:\"name\";s:15:\"link--base-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1922;a:4:{s:2:\"id\";s:29:\"acss_import_link--base-medium\";s:4:\"name\";s:17:\"link--base-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1923;a:4:{s:2:\"id\";s:22:\"acss_import_link--base\";s:4:\"name\";s:10:\"link--base\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1924;a:4:{s:2:\"id\";s:28:\"acss_import_link--base-light\";s:4:\"name\";s:16:\"link--base-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1925;a:4:{s:2:\"id\";s:34:\"acss_import_link--base-ultra-light\";s:4:\"name\";s:22:\"link--base-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1926;a:4:{s:2:\"id\";s:27:\"acss_import_link--base-comp\";s:4:\"name\";s:15:\"link--base-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1927;a:4:{s:2:\"id\";s:28:\"acss_import_link--base-hover\";s:4:\"name\";s:16:\"link--base-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1928;a:4:{s:2:\"id\";s:36:\"acss_import_link--neutral-ultra-dark\";s:4:\"name\";s:24:\"link--neutral-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1929;a:4:{s:2:\"id\";s:30:\"acss_import_link--neutral-dark\";s:4:\"name\";s:18:\"link--neutral-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1930;a:4:{s:2:\"id\";s:32:\"acss_import_link--neutral-medium\";s:4:\"name\";s:20:\"link--neutral-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1931;a:4:{s:2:\"id\";s:25:\"acss_import_link--neutral\";s:4:\"name\";s:13:\"link--neutral\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1932;a:4:{s:2:\"id\";s:31:\"acss_import_link--neutral-light\";s:4:\"name\";s:19:\"link--neutral-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1933;a:4:{s:2:\"id\";s:37:\"acss_import_link--neutral-ultra-light\";s:4:\"name\";s:25:\"link--neutral-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1934;a:4:{s:2:\"id\";s:30:\"acss_import_link--neutral-comp\";s:4:\"name\";s:18:\"link--neutral-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1935;a:4:{s:2:\"id\";s:31:\"acss_import_link--neutral-hover\";s:4:\"name\";s:19:\"link--neutral-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1936;a:4:{s:2:\"id\";s:34:\"acss_import_link--shade-ultra-dark\";s:4:\"name\";s:22:\"link--shade-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1937;a:4:{s:2:\"id\";s:28:\"acss_import_link--shade-dark\";s:4:\"name\";s:16:\"link--shade-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1938;a:4:{s:2:\"id\";s:30:\"acss_import_link--shade-medium\";s:4:\"name\";s:18:\"link--shade-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1939;a:4:{s:2:\"id\";s:23:\"acss_import_link--shade\";s:4:\"name\";s:11:\"link--shade\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1940;a:4:{s:2:\"id\";s:29:\"acss_import_link--shade-light\";s:4:\"name\";s:17:\"link--shade-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1941;a:4:{s:2:\"id\";s:35:\"acss_import_link--shade-ultra-light\";s:4:\"name\";s:23:\"link--shade-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1942;a:4:{s:2:\"id\";s:28:\"acss_import_link--shade-comp\";s:4:\"name\";s:16:\"link--shade-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1943;a:4:{s:2:\"id\";s:29:\"acss_import_link--shade-hover\";s:4:\"name\";s:17:\"link--shade-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1944;a:4:{s:2:\"id\";s:23:\"acss_import_link--black\";s:4:\"name\";s:11:\"link--black\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1945;a:4:{s:2:\"id\";s:23:\"acss_import_link--white\";s:4:\"name\";s:11:\"link--white\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1946;a:4:{s:2:\"id\";s:25:\"acss_import_link--success\";s:4:\"name\";s:13:\"link--success\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1947;a:4:{s:2:\"id\";s:31:\"acss_import_link--success-light\";s:4:\"name\";s:19:\"link--success-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1948;a:4:{s:2:\"id\";s:30:\"acss_import_link--success-dark\";s:4:\"name\";s:18:\"link--success-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1949;a:4:{s:2:\"id\";s:31:\"acss_import_link--success-hover\";s:4:\"name\";s:19:\"link--success-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1950;a:4:{s:2:\"id\";s:24:\"acss_import_link--danger\";s:4:\"name\";s:12:\"link--danger\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1951;a:4:{s:2:\"id\";s:30:\"acss_import_link--danger-light\";s:4:\"name\";s:18:\"link--danger-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1952;a:4:{s:2:\"id\";s:29:\"acss_import_link--danger-dark\";s:4:\"name\";s:17:\"link--danger-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1953;a:4:{s:2:\"id\";s:30:\"acss_import_link--danger-hover\";s:4:\"name\";s:18:\"link--danger-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1954;a:4:{s:2:\"id\";s:25:\"acss_import_link--warning\";s:4:\"name\";s:13:\"link--warning\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1955;a:4:{s:2:\"id\";s:31:\"acss_import_link--warning-light\";s:4:\"name\";s:19:\"link--warning-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1956;a:4:{s:2:\"id\";s:30:\"acss_import_link--warning-dark\";s:4:\"name\";s:18:\"link--warning-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1957;a:4:{s:2:\"id\";s:31:\"acss_import_link--warning-hover\";s:4:\"name\";s:19:\"link--warning-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1958;a:4:{s:2:\"id\";s:22:\"acss_import_link--info\";s:4:\"name\";s:10:\"link--info\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1959;a:4:{s:2:\"id\";s:28:\"acss_import_link--info-light\";s:4:\"name\";s:16:\"link--info-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1960;a:4:{s:2:\"id\";s:27:\"acss_import_link--info-dark\";s:4:\"name\";s:15:\"link--info-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1961;a:4:{s:2:\"id\";s:28:\"acss_import_link--info-hover\";s:4:\"name\";s:16:\"link--info-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1962;a:4:{s:2:\"id\";s:23:\"acss_import_aspect--1-1\";s:4:\"name\";s:11:\"aspect--1-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1963;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xs-1-1\";s:4:\"name\";s:14:\"aspect--xs-1-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1964;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--s-1-1\";s:4:\"name\";s:13:\"aspect--s-1-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1965;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--m-1-1\";s:4:\"name\";s:13:\"aspect--m-1-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1966;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--l-1-1\";s:4:\"name\";s:13:\"aspect--l-1-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1967;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xl-1-1\";s:4:\"name\";s:14:\"aspect--xl-1-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1968;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xxl-1-1\";s:4:\"name\";s:15:\"aspect--xxl-1-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1969;a:4:{s:2:\"id\";s:23:\"acss_import_aspect--1-2\";s:4:\"name\";s:11:\"aspect--1-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1970;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xs-1-2\";s:4:\"name\";s:14:\"aspect--xs-1-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1971;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--s-1-2\";s:4:\"name\";s:13:\"aspect--s-1-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1972;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--m-1-2\";s:4:\"name\";s:13:\"aspect--m-1-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1973;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--l-1-2\";s:4:\"name\";s:13:\"aspect--l-1-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1974;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xl-1-2\";s:4:\"name\";s:14:\"aspect--xl-1-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1975;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xxl-1-2\";s:4:\"name\";s:15:\"aspect--xxl-1-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1976;a:4:{s:2:\"id\";s:23:\"acss_import_aspect--2-1\";s:4:\"name\";s:11:\"aspect--2-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1977;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xs-2-1\";s:4:\"name\";s:14:\"aspect--xs-2-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1978;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--s-2-1\";s:4:\"name\";s:13:\"aspect--s-2-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1979;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--m-2-1\";s:4:\"name\";s:13:\"aspect--m-2-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1980;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--l-2-1\";s:4:\"name\";s:13:\"aspect--l-2-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1981;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xl-2-1\";s:4:\"name\";s:14:\"aspect--xl-2-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1982;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xxl-2-1\";s:4:\"name\";s:15:\"aspect--xxl-2-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1983;a:4:{s:2:\"id\";s:23:\"acss_import_aspect--2-3\";s:4:\"name\";s:11:\"aspect--2-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1984;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xs-2-3\";s:4:\"name\";s:14:\"aspect--xs-2-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1985;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--s-2-3\";s:4:\"name\";s:13:\"aspect--s-2-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1986;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--m-2-3\";s:4:\"name\";s:13:\"aspect--m-2-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1987;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--l-2-3\";s:4:\"name\";s:13:\"aspect--l-2-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1988;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xl-2-3\";s:4:\"name\";s:14:\"aspect--xl-2-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1989;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xxl-2-3\";s:4:\"name\";s:15:\"aspect--xxl-2-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1990;a:4:{s:2:\"id\";s:23:\"acss_import_aspect--3-2\";s:4:\"name\";s:11:\"aspect--3-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1991;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xs-3-2\";s:4:\"name\";s:14:\"aspect--xs-3-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1992;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--s-3-2\";s:4:\"name\";s:13:\"aspect--s-3-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1993;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--m-3-2\";s:4:\"name\";s:13:\"aspect--m-3-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1994;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--l-3-2\";s:4:\"name\";s:13:\"aspect--l-3-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1995;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xl-3-2\";s:4:\"name\";s:14:\"aspect--xl-3-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1996;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xxl-3-2\";s:4:\"name\";s:15:\"aspect--xxl-3-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1997;a:4:{s:2:\"id\";s:23:\"acss_import_aspect--3-4\";s:4:\"name\";s:11:\"aspect--3-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1998;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xs-3-4\";s:4:\"name\";s:14:\"aspect--xs-3-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:1999;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--s-3-4\";s:4:\"name\";s:13:\"aspect--s-3-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2000;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--m-3-4\";s:4:\"name\";s:13:\"aspect--m-3-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2001;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--l-3-4\";s:4:\"name\";s:13:\"aspect--l-3-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2002;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xl-3-4\";s:4:\"name\";s:14:\"aspect--xl-3-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2003;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xxl-3-4\";s:4:\"name\";s:15:\"aspect--xxl-3-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2004;a:4:{s:2:\"id\";s:23:\"acss_import_aspect--4-3\";s:4:\"name\";s:11:\"aspect--4-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2005;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xs-4-3\";s:4:\"name\";s:14:\"aspect--xs-4-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2006;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--s-4-3\";s:4:\"name\";s:13:\"aspect--s-4-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2007;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--m-4-3\";s:4:\"name\";s:13:\"aspect--m-4-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2008;a:4:{s:2:\"id\";s:25:\"acss_import_aspect--l-4-3\";s:4:\"name\";s:13:\"aspect--l-4-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2009;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--xl-4-3\";s:4:\"name\";s:14:\"aspect--xl-4-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2010;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xxl-4-3\";s:4:\"name\";s:15:\"aspect--xxl-4-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2011;a:4:{s:2:\"id\";s:24:\"acss_import_aspect--16-9\";s:4:\"name\";s:12:\"aspect--16-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2012;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xs-16-9\";s:4:\"name\";s:15:\"aspect--xs-16-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2013;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--s-16-9\";s:4:\"name\";s:14:\"aspect--s-16-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2014;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--m-16-9\";s:4:\"name\";s:14:\"aspect--m-16-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2015;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--l-16-9\";s:4:\"name\";s:14:\"aspect--l-16-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2016;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xl-16-9\";s:4:\"name\";s:15:\"aspect--xl-16-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2017;a:4:{s:2:\"id\";s:28:\"acss_import_aspect--xxl-16-9\";s:4:\"name\";s:16:\"aspect--xxl-16-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2018;a:4:{s:2:\"id\";s:24:\"acss_import_aspect--9-16\";s:4:\"name\";s:12:\"aspect--9-16\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2019;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xs-9-16\";s:4:\"name\";s:15:\"aspect--xs-9-16\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2020;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--s-9-16\";s:4:\"name\";s:14:\"aspect--s-9-16\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2021;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--m-9-16\";s:4:\"name\";s:14:\"aspect--m-9-16\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2022;a:4:{s:2:\"id\";s:26:\"acss_import_aspect--l-9-16\";s:4:\"name\";s:14:\"aspect--l-9-16\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2023;a:4:{s:2:\"id\";s:27:\"acss_import_aspect--xl-9-16\";s:4:\"name\";s:15:\"aspect--xl-9-16\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2024;a:4:{s:2:\"id\";s:28:\"acss_import_aspect--xxl-9-16\";s:4:\"name\";s:16:\"aspect--xxl-9-16\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2025;a:4:{s:2:\"id\";s:32:\"acss_import_object-fit--top-left\";s:4:\"name\";s:20:\"object-fit--top-left\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2026;a:4:{s:2:\"id\";s:34:\"acss_import_object-fit--top-center\";s:4:\"name\";s:22:\"object-fit--top-center\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2027;a:4:{s:2:\"id\";s:33:\"acss_import_object-fit--top-right\";s:4:\"name\";s:21:\"object-fit--top-right\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2028;a:4:{s:2:\"id\";s:35:\"acss_import_object-fit--center-left\";s:4:\"name\";s:23:\"object-fit--center-left\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2029;a:4:{s:2:\"id\";s:36:\"acss_import_object-fit--center-right\";s:4:\"name\";s:24:\"object-fit--center-right\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2030;a:4:{s:2:\"id\";s:35:\"acss_import_object-fit--bottom-left\";s:4:\"name\";s:23:\"object-fit--bottom-left\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2031;a:4:{s:2:\"id\";s:37:\"acss_import_object-fit--bottom-center\";s:4:\"name\";s:25:\"object-fit--bottom-center\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2032;a:4:{s:2:\"id\";s:36:\"acss_import_object-fit--bottom-right\";s:4:\"name\";s:24:\"object-fit--bottom-right\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2033;a:4:{s:2:\"id\";s:29:\"acss_import_object-fit--cover\";s:4:\"name\";s:17:\"object-fit--cover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2034;a:4:{s:2:\"id\";s:31:\"acss_import_object-fit--contain\";s:4:\"name\";s:19:\"object-fit--contain\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2035;a:4:{s:2:\"id\";s:23:\"acss_import_breakout--s\";s:4:\"name\";s:11:\"breakout--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2036;a:4:{s:2:\"id\";s:23:\"acss_import_breakout--m\";s:4:\"name\";s:11:\"breakout--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2037;a:4:{s:2:\"id\";s:23:\"acss_import_breakout--l\";s:4:\"name\";s:11:\"breakout--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2038;a:4:{s:2:\"id\";s:24:\"acss_import_breakout--xl\";s:4:\"name\";s:12:\"breakout--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2039;a:4:{s:2:\"id\";s:26:\"acss_import_breakout--full\";s:4:\"name\";s:14:\"breakout--full\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2040;a:4:{s:2:\"id\";s:19:\"acss_import_flip--x\";s:4:\"name\";s:7:\"flip--x\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2041;a:4:{s:2:\"id\";s:19:\"acss_import_flip--y\";s:4:\"name\";s:7:\"flip--y\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2042;a:4:{s:2:\"id\";s:20:\"acss_import_flip--xy\";s:4:\"name\";s:8:\"flip--xy\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2043;a:4:{s:2:\"id\";s:22:\"acss_import_flip--both\";s:4:\"name\";s:10:\"flip--both\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2044;a:4:{s:2:\"id\";s:26:\"acss_import_selection--alt\";s:4:\"name\";s:14:\"selection--alt\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2045;a:4:{s:2:\"id\";s:22:\"acss_import_opacity--5\";s:4:\"name\";s:10:\"opacity--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2046;a:4:{s:2:\"id\";s:23:\"acss_import_opacity--10\";s:4:\"name\";s:11:\"opacity--10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2047;a:4:{s:2:\"id\";s:23:\"acss_import_opacity--20\";s:4:\"name\";s:11:\"opacity--20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2048;a:4:{s:2:\"id\";s:23:\"acss_import_opacity--30\";s:4:\"name\";s:11:\"opacity--30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2049;a:4:{s:2:\"id\";s:23:\"acss_import_opacity--40\";s:4:\"name\";s:11:\"opacity--40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2050;a:4:{s:2:\"id\";s:23:\"acss_import_opacity--50\";s:4:\"name\";s:11:\"opacity--50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2051;a:4:{s:2:\"id\";s:23:\"acss_import_opacity--60\";s:4:\"name\";s:11:\"opacity--60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2052;a:4:{s:2:\"id\";s:23:\"acss_import_opacity--70\";s:4:\"name\";s:11:\"opacity--70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2053;a:4:{s:2:\"id\";s:23:\"acss_import_opacity--80\";s:4:\"name\";s:11:\"opacity--80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2054;a:4:{s:2:\"id\";s:23:\"acss_import_opacity--90\";s:4:\"name\";s:11:\"opacity--90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2055;a:4:{s:2:\"id\";s:23:\"acss_import_opacity--95\";s:4:\"name\";s:11:\"opacity--95\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2056;a:4:{s:2:\"id\";s:25:\"acss_import_box-shadow--m\";s:4:\"name\";s:13:\"box-shadow--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2057;a:4:{s:2:\"id\";s:25:\"acss_import_box-shadow--l\";s:4:\"name\";s:13:\"box-shadow--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2058;a:4:{s:2:\"id\";s:26:\"acss_import_box-shadow--xl\";s:4:\"name\";s:14:\"box-shadow--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2059;a:4:{s:2:\"id\";s:29:\"acss_import_color-scheme--alt\";s:4:\"name\";s:17:\"color-scheme--alt\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2060;a:4:{s:2:\"id\";s:30:\"acss_import_color-scheme--main\";s:4:\"name\";s:18:\"color-scheme--main\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2061;a:4:{s:2:\"id\";s:18:\"acss_import_ribbon\";s:4:\"name\";s:6:\"ribbon\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2062;a:4:{s:2:\"id\";s:28:\"acss_import_ribbon--top-left\";s:4:\"name\";s:16:\"ribbon--top-left\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2063;a:4:{s:2:\"id\";s:29:\"acss_import_ribbon--top-right\";s:4:\"name\";s:17:\"ribbon--top-right\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2064;a:4:{s:2:\"id\";s:22:\"acss_import_radius--xs\";s:4:\"name\";s:10:\"radius--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2065;a:4:{s:2:\"id\";s:21:\"acss_import_radius--s\";s:4:\"name\";s:9:\"radius--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2066;a:4:{s:2:\"id\";s:21:\"acss_import_radius--m\";s:4:\"name\";s:9:\"radius--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2067;a:4:{s:2:\"id\";s:21:\"acss_import_radius--l\";s:4:\"name\";s:9:\"radius--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2068;a:4:{s:2:\"id\";s:22:\"acss_import_radius--xl\";s:4:\"name\";s:10:\"radius--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2069;a:4:{s:2:\"id\";s:23:\"acss_import_radius--xxl\";s:4:\"name\";s:11:\"radius--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2070;a:4:{s:2:\"id\";s:22:\"acss_import_radius--50\";s:4:\"name\";s:10:\"radius--50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2071;a:4:{s:2:\"id\";s:26:\"acss_import_radius--circle\";s:4:\"name\";s:14:\"radius--circle\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2072;a:4:{s:2:\"id\";s:23:\"acss_import_rounded--xs\";s:4:\"name\";s:11:\"rounded--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2073;a:4:{s:2:\"id\";s:22:\"acss_import_rounded--s\";s:4:\"name\";s:10:\"rounded--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2074;a:4:{s:2:\"id\";s:22:\"acss_import_rounded--m\";s:4:\"name\";s:10:\"rounded--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2075;a:4:{s:2:\"id\";s:22:\"acss_import_rounded--l\";s:4:\"name\";s:10:\"rounded--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2076;a:4:{s:2:\"id\";s:23:\"acss_import_rounded--xl\";s:4:\"name\";s:11:\"rounded--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2077;a:4:{s:2:\"id\";s:24:\"acss_import_rounded--xxl\";s:4:\"name\";s:12:\"rounded--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2078;a:4:{s:2:\"id\";s:23:\"acss_import_rounded--50\";s:4:\"name\";s:11:\"rounded--50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2079;a:4:{s:2:\"id\";s:27:\"acss_import_rounded--circle\";s:4:\"name\";s:15:\"rounded--circle\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2080;a:4:{s:2:\"id\";s:22:\"acss_import_list--none\";s:4:\"name\";s:10:\"list--none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2081;a:4:{s:2:\"id\";s:26:\"acss_import_marker--action\";s:4:\"name\";s:14:\"marker--action\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2082;a:4:{s:2:\"id\";s:32:\"acss_import_marker--action-hover\";s:4:\"name\";s:20:\"marker--action-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2083;a:4:{s:2:\"id\";s:38:\"acss_import_marker--action-ultra-light\";s:4:\"name\";s:26:\"marker--action-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2084;a:4:{s:2:\"id\";s:32:\"acss_import_marker--action-light\";s:4:\"name\";s:20:\"marker--action-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2085;a:4:{s:2:\"id\";s:33:\"acss_import_marker--action-medium\";s:4:\"name\";s:21:\"marker--action-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2086;a:4:{s:2:\"id\";s:31:\"acss_import_marker--action-dark\";s:4:\"name\";s:19:\"marker--action-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2087;a:4:{s:2:\"id\";s:37:\"acss_import_marker--action-ultra-dark\";s:4:\"name\";s:25:\"marker--action-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2088;a:4:{s:2:\"id\";s:31:\"acss_import_marker--action-comp\";s:4:\"name\";s:19:\"marker--action-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2089;a:4:{s:2:\"id\";s:27:\"acss_import_marker--primary\";s:4:\"name\";s:15:\"marker--primary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2090;a:4:{s:2:\"id\";s:33:\"acss_import_marker--primary-hover\";s:4:\"name\";s:21:\"marker--primary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2091;a:4:{s:2:\"id\";s:39:\"acss_import_marker--primary-ultra-light\";s:4:\"name\";s:27:\"marker--primary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2092;a:4:{s:2:\"id\";s:33:\"acss_import_marker--primary-light\";s:4:\"name\";s:21:\"marker--primary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2093;a:4:{s:2:\"id\";s:34:\"acss_import_marker--primary-medium\";s:4:\"name\";s:22:\"marker--primary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2094;a:4:{s:2:\"id\";s:32:\"acss_import_marker--primary-dark\";s:4:\"name\";s:20:\"marker--primary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2095;a:4:{s:2:\"id\";s:38:\"acss_import_marker--primary-ultra-dark\";s:4:\"name\";s:26:\"marker--primary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2096;a:4:{s:2:\"id\";s:32:\"acss_import_marker--primary-comp\";s:4:\"name\";s:20:\"marker--primary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2097;a:4:{s:2:\"id\";s:29:\"acss_import_marker--secondary\";s:4:\"name\";s:17:\"marker--secondary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2098;a:4:{s:2:\"id\";s:35:\"acss_import_marker--secondary-hover\";s:4:\"name\";s:23:\"marker--secondary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2099;a:4:{s:2:\"id\";s:41:\"acss_import_marker--secondary-ultra-light\";s:4:\"name\";s:29:\"marker--secondary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2100;a:4:{s:2:\"id\";s:35:\"acss_import_marker--secondary-light\";s:4:\"name\";s:23:\"marker--secondary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2101;a:4:{s:2:\"id\";s:36:\"acss_import_marker--secondary-medium\";s:4:\"name\";s:24:\"marker--secondary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2102;a:4:{s:2:\"id\";s:34:\"acss_import_marker--secondary-dark\";s:4:\"name\";s:22:\"marker--secondary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2103;a:4:{s:2:\"id\";s:40:\"acss_import_marker--secondary-ultra-dark\";s:4:\"name\";s:28:\"marker--secondary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2104;a:4:{s:2:\"id\";s:34:\"acss_import_marker--secondary-comp\";s:4:\"name\";s:22:\"marker--secondary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2105;a:4:{s:2:\"id\";s:26:\"acss_import_marker--accent\";s:4:\"name\";s:14:\"marker--accent\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2106;a:4:{s:2:\"id\";s:32:\"acss_import_marker--accent-hover\";s:4:\"name\";s:20:\"marker--accent-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2107;a:4:{s:2:\"id\";s:38:\"acss_import_marker--accent-ultra-light\";s:4:\"name\";s:26:\"marker--accent-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2108;a:4:{s:2:\"id\";s:32:\"acss_import_marker--accent-light\";s:4:\"name\";s:20:\"marker--accent-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2109;a:4:{s:2:\"id\";s:33:\"acss_import_marker--accent-medium\";s:4:\"name\";s:21:\"marker--accent-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2110;a:4:{s:2:\"id\";s:31:\"acss_import_marker--accent-dark\";s:4:\"name\";s:19:\"marker--accent-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2111;a:4:{s:2:\"id\";s:37:\"acss_import_marker--accent-ultra-dark\";s:4:\"name\";s:25:\"marker--accent-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2112;a:4:{s:2:\"id\";s:31:\"acss_import_marker--accent-comp\";s:4:\"name\";s:19:\"marker--accent-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2113;a:4:{s:2:\"id\";s:24:\"acss_import_marker--base\";s:4:\"name\";s:12:\"marker--base\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2114;a:4:{s:2:\"id\";s:30:\"acss_import_marker--base-hover\";s:4:\"name\";s:18:\"marker--base-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2115;a:4:{s:2:\"id\";s:36:\"acss_import_marker--base-ultra-light\";s:4:\"name\";s:24:\"marker--base-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2116;a:4:{s:2:\"id\";s:30:\"acss_import_marker--base-light\";s:4:\"name\";s:18:\"marker--base-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2117;a:4:{s:2:\"id\";s:31:\"acss_import_marker--base-medium\";s:4:\"name\";s:19:\"marker--base-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2118;a:4:{s:2:\"id\";s:29:\"acss_import_marker--base-dark\";s:4:\"name\";s:17:\"marker--base-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2119;a:4:{s:2:\"id\";s:35:\"acss_import_marker--base-ultra-dark\";s:4:\"name\";s:23:\"marker--base-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2120;a:4:{s:2:\"id\";s:29:\"acss_import_marker--base-comp\";s:4:\"name\";s:17:\"marker--base-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2121;a:4:{s:2:\"id\";s:27:\"acss_import_marker--neutral\";s:4:\"name\";s:15:\"marker--neutral\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2122;a:4:{s:2:\"id\";s:33:\"acss_import_marker--neutral-hover\";s:4:\"name\";s:21:\"marker--neutral-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2123;a:4:{s:2:\"id\";s:39:\"acss_import_marker--neutral-ultra-light\";s:4:\"name\";s:27:\"marker--neutral-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2124;a:4:{s:2:\"id\";s:33:\"acss_import_marker--neutral-light\";s:4:\"name\";s:21:\"marker--neutral-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2125;a:4:{s:2:\"id\";s:34:\"acss_import_marker--neutral-medium\";s:4:\"name\";s:22:\"marker--neutral-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2126;a:4:{s:2:\"id\";s:32:\"acss_import_marker--neutral-dark\";s:4:\"name\";s:20:\"marker--neutral-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2127;a:4:{s:2:\"id\";s:38:\"acss_import_marker--neutral-ultra-dark\";s:4:\"name\";s:26:\"marker--neutral-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2128;a:4:{s:2:\"id\";s:32:\"acss_import_marker--neutral-comp\";s:4:\"name\";s:20:\"marker--neutral-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2129;a:4:{s:2:\"id\";s:25:\"acss_import_marker--shade\";s:4:\"name\";s:13:\"marker--shade\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2130;a:4:{s:2:\"id\";s:31:\"acss_import_marker--shade-hover\";s:4:\"name\";s:19:\"marker--shade-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2131;a:4:{s:2:\"id\";s:37:\"acss_import_marker--shade-ultra-light\";s:4:\"name\";s:25:\"marker--shade-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2132;a:4:{s:2:\"id\";s:31:\"acss_import_marker--shade-light\";s:4:\"name\";s:19:\"marker--shade-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2133;a:4:{s:2:\"id\";s:32:\"acss_import_marker--shade-medium\";s:4:\"name\";s:20:\"marker--shade-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2134;a:4:{s:2:\"id\";s:30:\"acss_import_marker--shade-dark\";s:4:\"name\";s:18:\"marker--shade-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2135;a:4:{s:2:\"id\";s:36:\"acss_import_marker--shade-ultra-dark\";s:4:\"name\";s:24:\"marker--shade-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2136;a:4:{s:2:\"id\";s:30:\"acss_import_marker--shade-comp\";s:4:\"name\";s:18:\"marker--shade-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2137;a:4:{s:2:\"id\";s:25:\"acss_import_marker--white\";s:4:\"name\";s:13:\"marker--white\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2138;a:4:{s:2:\"id\";s:25:\"acss_import_marker--black\";s:4:\"name\";s:13:\"marker--black\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2139;a:4:{s:2:\"id\";s:24:\"acss_import_col-count--1\";s:4:\"name\";s:12:\"col-count--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2140;a:4:{s:2:\"id\";s:27:\"acss_import_col-count--xs-1\";s:4:\"name\";s:15:\"col-count--xs-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2141;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--s-1\";s:4:\"name\";s:14:\"col-count--s-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2142;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--m-1\";s:4:\"name\";s:14:\"col-count--m-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2143;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--l-1\";s:4:\"name\";s:14:\"col-count--l-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2144;a:4:{s:2:\"id\";s:27:\"acss_import_col-count--xl-1\";s:4:\"name\";s:15:\"col-count--xl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2145;a:4:{s:2:\"id\";s:28:\"acss_import_col-count--xxl-1\";s:4:\"name\";s:16:\"col-count--xxl-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2146;a:4:{s:2:\"id\";s:24:\"acss_import_col-count--2\";s:4:\"name\";s:12:\"col-count--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2147;a:4:{s:2:\"id\";s:27:\"acss_import_col-count--xs-2\";s:4:\"name\";s:15:\"col-count--xs-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2148;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--s-2\";s:4:\"name\";s:14:\"col-count--s-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2149;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--m-2\";s:4:\"name\";s:14:\"col-count--m-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2150;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--l-2\";s:4:\"name\";s:14:\"col-count--l-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2151;a:4:{s:2:\"id\";s:27:\"acss_import_col-count--xl-2\";s:4:\"name\";s:15:\"col-count--xl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2152;a:4:{s:2:\"id\";s:28:\"acss_import_col-count--xxl-2\";s:4:\"name\";s:16:\"col-count--xxl-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2153;a:4:{s:2:\"id\";s:24:\"acss_import_col-count--3\";s:4:\"name\";s:12:\"col-count--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2154;a:4:{s:2:\"id\";s:27:\"acss_import_col-count--xs-3\";s:4:\"name\";s:15:\"col-count--xs-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2155;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--s-3\";s:4:\"name\";s:14:\"col-count--s-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2156;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--m-3\";s:4:\"name\";s:14:\"col-count--m-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2157;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--l-3\";s:4:\"name\";s:14:\"col-count--l-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2158;a:4:{s:2:\"id\";s:27:\"acss_import_col-count--xl-3\";s:4:\"name\";s:15:\"col-count--xl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2159;a:4:{s:2:\"id\";s:28:\"acss_import_col-count--xxl-3\";s:4:\"name\";s:16:\"col-count--xxl-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2160;a:4:{s:2:\"id\";s:24:\"acss_import_col-count--4\";s:4:\"name\";s:12:\"col-count--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2161;a:4:{s:2:\"id\";s:27:\"acss_import_col-count--xs-4\";s:4:\"name\";s:15:\"col-count--xs-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2162;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--s-4\";s:4:\"name\";s:14:\"col-count--s-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2163;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--m-4\";s:4:\"name\";s:14:\"col-count--m-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2164;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--l-4\";s:4:\"name\";s:14:\"col-count--l-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2165;a:4:{s:2:\"id\";s:27:\"acss_import_col-count--xl-4\";s:4:\"name\";s:15:\"col-count--xl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2166;a:4:{s:2:\"id\";s:28:\"acss_import_col-count--xxl-4\";s:4:\"name\";s:16:\"col-count--xxl-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2167;a:4:{s:2:\"id\";s:24:\"acss_import_col-count--5\";s:4:\"name\";s:12:\"col-count--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2168;a:4:{s:2:\"id\";s:27:\"acss_import_col-count--xs-5\";s:4:\"name\";s:15:\"col-count--xs-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2169;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--s-5\";s:4:\"name\";s:14:\"col-count--s-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2170;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--m-5\";s:4:\"name\";s:14:\"col-count--m-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2171;a:4:{s:2:\"id\";s:26:\"acss_import_col-count--l-5\";s:4:\"name\";s:14:\"col-count--l-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2172;a:4:{s:2:\"id\";s:27:\"acss_import_col-count--xl-5\";s:4:\"name\";s:15:\"col-count--xl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2173;a:4:{s:2:\"id\";s:28:\"acss_import_col-count--xxl-5\";s:4:\"name\";s:16:\"col-count--xxl-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2174;a:4:{s:2:\"id\";s:24:\"acss_import_col-width--s\";s:4:\"name\";s:12:\"col-width--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2175;a:4:{s:2:\"id\";s:24:\"acss_import_col-width--m\";s:4:\"name\";s:12:\"col-width--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2176;a:4:{s:2:\"id\";s:24:\"acss_import_col-width--l\";s:4:\"name\";s:12:\"col-width--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2177;a:4:{s:2:\"id\";s:23:\"acss_import_col-gap--xs\";s:4:\"name\";s:11:\"col-gap--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2178;a:4:{s:2:\"id\";s:22:\"acss_import_col-gap--s\";s:4:\"name\";s:10:\"col-gap--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2179;a:4:{s:2:\"id\";s:22:\"acss_import_col-gap--m\";s:4:\"name\";s:10:\"col-gap--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2180;a:4:{s:2:\"id\";s:22:\"acss_import_col-gap--l\";s:4:\"name\";s:10:\"col-gap--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2181;a:4:{s:2:\"id\";s:23:\"acss_import_col-gap--xl\";s:4:\"name\";s:11:\"col-gap--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2182;a:4:{s:2:\"id\";s:24:\"acss_import_col-gap--xxl\";s:4:\"name\";s:12:\"col-gap--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2183;a:4:{s:2:\"id\";s:28:\"acss_import_col-rule--dotted\";s:4:\"name\";s:16:\"col-rule--dotted\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2184;a:4:{s:2:\"id\";s:28:\"acss_import_col-rule--dashed\";s:4:\"name\";s:16:\"col-rule--dashed\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2185;a:4:{s:2:\"id\";s:27:\"acss_import_col-rule--solid\";s:4:\"name\";s:15:\"col-rule--solid\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2186;a:4:{s:2:\"id\";s:28:\"acss_import_col-rule--double\";s:4:\"name\";s:16:\"col-rule--double\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2187;a:4:{s:2:\"id\";s:28:\"acss_import_col-rule--groove\";s:4:\"name\";s:16:\"col-rule--groove\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2188;a:4:{s:2:\"id\";s:27:\"acss_import_col-rule--ridge\";s:4:\"name\";s:15:\"col-rule--ridge\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2189;a:4:{s:2:\"id\";s:27:\"acss_import_col-rule--inset\";s:4:\"name\";s:15:\"col-rule--inset\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2190;a:4:{s:2:\"id\";s:28:\"acss_import_col-rule--outset\";s:4:\"name\";s:16:\"col-rule--outset\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2191;a:4:{s:2:\"id\";s:39:\"acss_import_col-rule--action-ultra-dark\";s:4:\"name\";s:27:\"col-rule--action-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2192;a:4:{s:2:\"id\";s:33:\"acss_import_col-rule--action-dark\";s:4:\"name\";s:21:\"col-rule--action-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2193;a:4:{s:2:\"id\";s:35:\"acss_import_col-rule--action-medium\";s:4:\"name\";s:23:\"col-rule--action-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2194;a:4:{s:2:\"id\";s:28:\"acss_import_col-rule--action\";s:4:\"name\";s:16:\"col-rule--action\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2195;a:4:{s:2:\"id\";s:34:\"acss_import_col-rule--action-light\";s:4:\"name\";s:22:\"col-rule--action-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2196;a:4:{s:2:\"id\";s:40:\"acss_import_col-rule--action-ultra-light\";s:4:\"name\";s:28:\"col-rule--action-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2197;a:4:{s:2:\"id\";s:33:\"acss_import_col-rule--action-comp\";s:4:\"name\";s:21:\"col-rule--action-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2198;a:4:{s:2:\"id\";s:34:\"acss_import_col-rule--action-hover\";s:4:\"name\";s:22:\"col-rule--action-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2199;a:4:{s:2:\"id\";s:40:\"acss_import_col-rule--primary-ultra-dark\";s:4:\"name\";s:28:\"col-rule--primary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2200;a:4:{s:2:\"id\";s:34:\"acss_import_col-rule--primary-dark\";s:4:\"name\";s:22:\"col-rule--primary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2201;a:4:{s:2:\"id\";s:36:\"acss_import_col-rule--primary-medium\";s:4:\"name\";s:24:\"col-rule--primary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2202;a:4:{s:2:\"id\";s:29:\"acss_import_col-rule--primary\";s:4:\"name\";s:17:\"col-rule--primary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2203;a:4:{s:2:\"id\";s:35:\"acss_import_col-rule--primary-light\";s:4:\"name\";s:23:\"col-rule--primary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2204;a:4:{s:2:\"id\";s:41:\"acss_import_col-rule--primary-ultra-light\";s:4:\"name\";s:29:\"col-rule--primary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2205;a:4:{s:2:\"id\";s:34:\"acss_import_col-rule--primary-comp\";s:4:\"name\";s:22:\"col-rule--primary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2206;a:4:{s:2:\"id\";s:35:\"acss_import_col-rule--primary-hover\";s:4:\"name\";s:23:\"col-rule--primary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2207;a:4:{s:2:\"id\";s:42:\"acss_import_col-rule--secondary-ultra-dark\";s:4:\"name\";s:30:\"col-rule--secondary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2208;a:4:{s:2:\"id\";s:36:\"acss_import_col-rule--secondary-dark\";s:4:\"name\";s:24:\"col-rule--secondary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2209;a:4:{s:2:\"id\";s:38:\"acss_import_col-rule--secondary-medium\";s:4:\"name\";s:26:\"col-rule--secondary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2210;a:4:{s:2:\"id\";s:31:\"acss_import_col-rule--secondary\";s:4:\"name\";s:19:\"col-rule--secondary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2211;a:4:{s:2:\"id\";s:37:\"acss_import_col-rule--secondary-light\";s:4:\"name\";s:25:\"col-rule--secondary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2212;a:4:{s:2:\"id\";s:43:\"acss_import_col-rule--secondary-ultra-light\";s:4:\"name\";s:31:\"col-rule--secondary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2213;a:4:{s:2:\"id\";s:36:\"acss_import_col-rule--secondary-comp\";s:4:\"name\";s:24:\"col-rule--secondary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2214;a:4:{s:2:\"id\";s:37:\"acss_import_col-rule--secondary-hover\";s:4:\"name\";s:25:\"col-rule--secondary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2215;a:4:{s:2:\"id\";s:39:\"acss_import_col-rule--accent-ultra-dark\";s:4:\"name\";s:27:\"col-rule--accent-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2216;a:4:{s:2:\"id\";s:33:\"acss_import_col-rule--accent-dark\";s:4:\"name\";s:21:\"col-rule--accent-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2217;a:4:{s:2:\"id\";s:35:\"acss_import_col-rule--accent-medium\";s:4:\"name\";s:23:\"col-rule--accent-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2218;a:4:{s:2:\"id\";s:28:\"acss_import_col-rule--accent\";s:4:\"name\";s:16:\"col-rule--accent\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2219;a:4:{s:2:\"id\";s:34:\"acss_import_col-rule--accent-light\";s:4:\"name\";s:22:\"col-rule--accent-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2220;a:4:{s:2:\"id\";s:40:\"acss_import_col-rule--accent-ultra-light\";s:4:\"name\";s:28:\"col-rule--accent-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2221;a:4:{s:2:\"id\";s:33:\"acss_import_col-rule--accent-comp\";s:4:\"name\";s:21:\"col-rule--accent-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2222;a:4:{s:2:\"id\";s:34:\"acss_import_col-rule--accent-hover\";s:4:\"name\";s:22:\"col-rule--accent-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2223;a:4:{s:2:\"id\";s:37:\"acss_import_col-rule--base-ultra-dark\";s:4:\"name\";s:25:\"col-rule--base-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2224;a:4:{s:2:\"id\";s:31:\"acss_import_col-rule--base-dark\";s:4:\"name\";s:19:\"col-rule--base-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2225;a:4:{s:2:\"id\";s:33:\"acss_import_col-rule--base-medium\";s:4:\"name\";s:21:\"col-rule--base-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2226;a:4:{s:2:\"id\";s:26:\"acss_import_col-rule--base\";s:4:\"name\";s:14:\"col-rule--base\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2227;a:4:{s:2:\"id\";s:32:\"acss_import_col-rule--base-light\";s:4:\"name\";s:20:\"col-rule--base-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2228;a:4:{s:2:\"id\";s:38:\"acss_import_col-rule--base-ultra-light\";s:4:\"name\";s:26:\"col-rule--base-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2229;a:4:{s:2:\"id\";s:31:\"acss_import_col-rule--base-comp\";s:4:\"name\";s:19:\"col-rule--base-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2230;a:4:{s:2:\"id\";s:32:\"acss_import_col-rule--base-hover\";s:4:\"name\";s:20:\"col-rule--base-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2231;a:4:{s:2:\"id\";s:40:\"acss_import_col-rule--neutral-ultra-dark\";s:4:\"name\";s:28:\"col-rule--neutral-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2232;a:4:{s:2:\"id\";s:34:\"acss_import_col-rule--neutral-dark\";s:4:\"name\";s:22:\"col-rule--neutral-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2233;a:4:{s:2:\"id\";s:36:\"acss_import_col-rule--neutral-medium\";s:4:\"name\";s:24:\"col-rule--neutral-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2234;a:4:{s:2:\"id\";s:29:\"acss_import_col-rule--neutral\";s:4:\"name\";s:17:\"col-rule--neutral\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2235;a:4:{s:2:\"id\";s:35:\"acss_import_col-rule--neutral-light\";s:4:\"name\";s:23:\"col-rule--neutral-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2236;a:4:{s:2:\"id\";s:41:\"acss_import_col-rule--neutral-ultra-light\";s:4:\"name\";s:29:\"col-rule--neutral-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2237;a:4:{s:2:\"id\";s:34:\"acss_import_col-rule--neutral-comp\";s:4:\"name\";s:22:\"col-rule--neutral-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2238;a:4:{s:2:\"id\";s:35:\"acss_import_col-rule--neutral-hover\";s:4:\"name\";s:23:\"col-rule--neutral-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2239;a:4:{s:2:\"id\";s:38:\"acss_import_col-rule--shade-ultra-dark\";s:4:\"name\";s:26:\"col-rule--shade-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2240;a:4:{s:2:\"id\";s:32:\"acss_import_col-rule--shade-dark\";s:4:\"name\";s:20:\"col-rule--shade-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2241;a:4:{s:2:\"id\";s:34:\"acss_import_col-rule--shade-medium\";s:4:\"name\";s:22:\"col-rule--shade-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2242;a:4:{s:2:\"id\";s:27:\"acss_import_col-rule--shade\";s:4:\"name\";s:15:\"col-rule--shade\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2243;a:4:{s:2:\"id\";s:33:\"acss_import_col-rule--shade-light\";s:4:\"name\";s:21:\"col-rule--shade-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2244;a:4:{s:2:\"id\";s:39:\"acss_import_col-rule--shade-ultra-light\";s:4:\"name\";s:27:\"col-rule--shade-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2245;a:4:{s:2:\"id\";s:32:\"acss_import_col-rule--shade-comp\";s:4:\"name\";s:20:\"col-rule--shade-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2246;a:4:{s:2:\"id\";s:33:\"acss_import_col-rule--shade-hover\";s:4:\"name\";s:21:\"col-rule--shade-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2247;a:4:{s:2:\"id\";s:27:\"acss_import_col-rule--black\";s:4:\"name\";s:15:\"col-rule--black\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2248;a:4:{s:2:\"id\";s:27:\"acss_import_col-rule--white\";s:4:\"name\";s:15:\"col-rule--white\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2249;a:4:{s:2:\"id\";s:23:\"acss_import_col-rule--s\";s:4:\"name\";s:11:\"col-rule--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2250;a:4:{s:2:\"id\";s:23:\"acss_import_col-rule--m\";s:4:\"name\";s:11:\"col-rule--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2251;a:4:{s:2:\"id\";s:23:\"acss_import_col-rule--l\";s:4:\"name\";s:11:\"col-rule--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2252;a:4:{s:2:\"id\";s:23:\"acss_import_form--light\";s:4:\"name\";s:11:\"form--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2253;a:4:{s:2:\"id\";s:22:\"acss_import_form--dark\";s:4:\"name\";s:10:\"form--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2254;a:4:{s:2:\"id\";s:24:\"acss_import_fr-bg--light\";s:4:\"name\";s:12:\"fr-bg--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2255;a:4:{s:2:\"id\";s:23:\"acss_import_fr-bg--dark\";s:4:\"name\";s:11:\"fr-bg--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2256;a:4:{s:2:\"id\";s:26:\"acss_import_fr-text--light\";s:4:\"name\";s:14:\"fr-text--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2257;a:4:{s:2:\"id\";s:25:\"acss_import_fr-text--dark\";s:4:\"name\";s:13:\"fr-text--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2258;a:4:{s:2:\"id\";s:27:\"acss_import_fr-hero-padding\";s:4:\"name\";s:15:\"fr-hero-padding\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2259;a:4:{s:2:\"id\";s:19:\"acss_import_fr-lede\";s:4:\"name\";s:7:\"fr-lede\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2260;a:4:{s:2:\"id\";s:28:\"acss_import_fr-container-gap\";s:4:\"name\";s:16:\"fr-container-gap\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2261;a:4:{s:2:\"id\";s:26:\"acss_import_fr-content-gap\";s:4:\"name\";s:14:\"fr-content-gap\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2262;a:4:{s:2:\"id\";s:23:\"acss_import_fr-grid-gap\";s:4:\"name\";s:11:\"fr-grid-gap\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2263;a:4:{s:2:\"id\";s:36:\"acss_import_focus--action-ultra-dark\";s:4:\"name\";s:24:\"focus--action-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2264;a:4:{s:2:\"id\";s:30:\"acss_import_focus--action-dark\";s:4:\"name\";s:18:\"focus--action-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2265;a:4:{s:2:\"id\";s:32:\"acss_import_focus--action-medium\";s:4:\"name\";s:20:\"focus--action-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2266;a:4:{s:2:\"id\";s:25:\"acss_import_focus--action\";s:4:\"name\";s:13:\"focus--action\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2267;a:4:{s:2:\"id\";s:31:\"acss_import_focus--action-light\";s:4:\"name\";s:19:\"focus--action-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2268;a:4:{s:2:\"id\";s:37:\"acss_import_focus--action-ultra-light\";s:4:\"name\";s:25:\"focus--action-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2269;a:4:{s:2:\"id\";s:37:\"acss_import_focus--primary-ultra-dark\";s:4:\"name\";s:25:\"focus--primary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2270;a:4:{s:2:\"id\";s:31:\"acss_import_focus--primary-dark\";s:4:\"name\";s:19:\"focus--primary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2271;a:4:{s:2:\"id\";s:33:\"acss_import_focus--primary-medium\";s:4:\"name\";s:21:\"focus--primary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2272;a:4:{s:2:\"id\";s:26:\"acss_import_focus--primary\";s:4:\"name\";s:14:\"focus--primary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2273;a:4:{s:2:\"id\";s:32:\"acss_import_focus--primary-light\";s:4:\"name\";s:20:\"focus--primary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2274;a:4:{s:2:\"id\";s:38:\"acss_import_focus--primary-ultra-light\";s:4:\"name\";s:26:\"focus--primary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2275;a:4:{s:2:\"id\";s:39:\"acss_import_focus--secondary-ultra-dark\";s:4:\"name\";s:27:\"focus--secondary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2276;a:4:{s:2:\"id\";s:33:\"acss_import_focus--secondary-dark\";s:4:\"name\";s:21:\"focus--secondary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2277;a:4:{s:2:\"id\";s:35:\"acss_import_focus--secondary-medium\";s:4:\"name\";s:23:\"focus--secondary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2278;a:4:{s:2:\"id\";s:28:\"acss_import_focus--secondary\";s:4:\"name\";s:16:\"focus--secondary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2279;a:4:{s:2:\"id\";s:34:\"acss_import_focus--secondary-light\";s:4:\"name\";s:22:\"focus--secondary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2280;a:4:{s:2:\"id\";s:40:\"acss_import_focus--secondary-ultra-light\";s:4:\"name\";s:28:\"focus--secondary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2281;a:4:{s:2:\"id\";s:36:\"acss_import_focus--accent-ultra-dark\";s:4:\"name\";s:24:\"focus--accent-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2282;a:4:{s:2:\"id\";s:30:\"acss_import_focus--accent-dark\";s:4:\"name\";s:18:\"focus--accent-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2283;a:4:{s:2:\"id\";s:32:\"acss_import_focus--accent-medium\";s:4:\"name\";s:20:\"focus--accent-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2284;a:4:{s:2:\"id\";s:25:\"acss_import_focus--accent\";s:4:\"name\";s:13:\"focus--accent\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2285;a:4:{s:2:\"id\";s:31:\"acss_import_focus--accent-light\";s:4:\"name\";s:19:\"focus--accent-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2286;a:4:{s:2:\"id\";s:37:\"acss_import_focus--accent-ultra-light\";s:4:\"name\";s:25:\"focus--accent-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2287;a:4:{s:2:\"id\";s:34:\"acss_import_focus--base-ultra-dark\";s:4:\"name\";s:22:\"focus--base-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2288;a:4:{s:2:\"id\";s:28:\"acss_import_focus--base-dark\";s:4:\"name\";s:16:\"focus--base-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2289;a:4:{s:2:\"id\";s:30:\"acss_import_focus--base-medium\";s:4:\"name\";s:18:\"focus--base-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2290;a:4:{s:2:\"id\";s:23:\"acss_import_focus--base\";s:4:\"name\";s:11:\"focus--base\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2291;a:4:{s:2:\"id\";s:29:\"acss_import_focus--base-light\";s:4:\"name\";s:17:\"focus--base-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2292;a:4:{s:2:\"id\";s:35:\"acss_import_focus--base-ultra-light\";s:4:\"name\";s:23:\"focus--base-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2293;a:4:{s:2:\"id\";s:37:\"acss_import_focus--neutral-ultra-dark\";s:4:\"name\";s:25:\"focus--neutral-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2294;a:4:{s:2:\"id\";s:31:\"acss_import_focus--neutral-dark\";s:4:\"name\";s:19:\"focus--neutral-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2295;a:4:{s:2:\"id\";s:33:\"acss_import_focus--neutral-medium\";s:4:\"name\";s:21:\"focus--neutral-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2296;a:4:{s:2:\"id\";s:26:\"acss_import_focus--neutral\";s:4:\"name\";s:14:\"focus--neutral\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2297;a:4:{s:2:\"id\";s:32:\"acss_import_focus--neutral-light\";s:4:\"name\";s:20:\"focus--neutral-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2298;a:4:{s:2:\"id\";s:38:\"acss_import_focus--neutral-ultra-light\";s:4:\"name\";s:26:\"focus--neutral-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2299;a:4:{s:2:\"id\";s:35:\"acss_import_focus--shade-ultra-dark\";s:4:\"name\";s:23:\"focus--shade-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2300;a:4:{s:2:\"id\";s:29:\"acss_import_focus--shade-dark\";s:4:\"name\";s:17:\"focus--shade-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2301;a:4:{s:2:\"id\";s:31:\"acss_import_focus--shade-medium\";s:4:\"name\";s:19:\"focus--shade-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2302;a:4:{s:2:\"id\";s:24:\"acss_import_focus--shade\";s:4:\"name\";s:12:\"focus--shade\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2303;a:4:{s:2:\"id\";s:30:\"acss_import_focus--shade-light\";s:4:\"name\";s:18:\"focus--shade-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2304;a:4:{s:2:\"id\";s:36:\"acss_import_focus--shade-ultra-light\";s:4:\"name\";s:24:\"focus--shade-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2305;a:4:{s:2:\"id\";s:24:\"acss_import_focus--black\";s:4:\"name\";s:12:\"focus--black\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2306;a:4:{s:2:\"id\";s:24:\"acss_import_focus--white\";s:4:\"name\";s:12:\"focus--white\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2307;a:4:{s:2:\"id\";s:24:\"acss_import_focus-parent\";s:4:\"name\";s:12:\"focus-parent\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2308;a:4:{s:2:\"id\";s:32:\"acss_import_focus-parent--shadow\";s:4:\"name\";s:20:\"focus-parent--shadow\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2309;a:4:{s:2:\"id\";s:33:\"acss_import_focus-parent--outline\";s:4:\"name\";s:21:\"focus-parent--outline\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2310;a:4:{s:2:\"id\";s:29:\"acss_import_hidden-accessible\";s:4:\"name\";s:17:\"hidden-accessible\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2311;a:4:{s:2:\"id\";s:28:\"acss_import_clickable-parent\";s:4:\"name\";s:16:\"clickable-parent\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2312;a:3:{s:2:\"id\";s:6:\"sjhbib\";s:4:\"name\";s:22:\"fr-header-foxtrot__top\";s:8:\"settings\";a:1:{s:8:\"_padding\";a:4:{s:4:\"left\";s:24:\"var(--section-padding-x)\";s:5:\"right\";s:24:\"var(--section-padding-x)\";s:3:\"top\";s:14:\"var(--space-m)\";s:6:\"bottom\";s:14:\"var(--space-m)\";}}}i:2313;a:3:{s:2:\"id\";s:6:\"neerqn\";s:4:\"name\";s:28:\"fr-header-foxtrot__top-inner\";s:8:\"settings\";a:5:{s:10:\"_columnGap\";s:21:\"var(--fr-content-gap)\";s:15:\"_justifyContent\";s:13:\"space-between\";s:10:\"_direction\";s:3:\"row\";s:11:\"_alignItems\";s:6:\"center\";s:7:\"_rowGap\";s:21:\"var(--fr-content-gap)\";}}i:2314;a:3:{s:2:\"id\";s:6:\"qdddlc\";s:4:\"name\";s:23:\"fr-header-foxtrot__logo\";s:8:\"settings\";a:0:{}}i:2315;a:3:{s:2:\"id\";s:6:\"horpzc\";s:4:\"name\";s:7:\"fr-logo\";s:8:\"settings\";a:0:{}}i:2316;a:3:{s:2:\"id\";s:6:\"cejuod\";s:4:\"name\";s:17:\"fr-header-foxtrot\";s:8:\"settings\";a:2:{s:8:\"_padding\";a:4:{s:4:\"left\";s:24:\"var(--section-padding-x)\";s:5:\"right\";s:24:\"var(--section-padding-x)\";s:3:\"top\";s:14:\"var(--space-s)\";s:6:\"bottom\";s:14:\"var(--space-s)\";}s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:18:\"var(--fr-bg-light)\";}}}}i:2317;a:3:{s:2:\"id\";s:6:\"piiawv\";s:4:\"name\";s:24:\"fr-header-foxtrot__inner\";s:8:\"settings\";a:2:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:3:\"row\";}}i:2318;a:3:{s:2:\"id\";s:6:\"xzqxtw\";s:4:\"name\";s:12:\"fr-nav-alpha\";s:8:\"settings\";a:22:{s:21:\"mobileMenuToggleColor\";a:1:{s:3:\"raw\";s:16:\"var(--text-dark)\";}s:27:\"_typography:tablet_portrait\";a:1:{s:11:\"line-height\";s:1:\"0\";}s:20:\"mobileMenuTypography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--text-light)\";}}s:10:\"menuMargin\";a:1:{s:4:\"left\";s:1:\"0\";}s:10:\"_cssCustom\";s:753:\".fr-nav-alpha {\n  --link-color: 				var(--action);\n  --link-color-hover: 	var(--action-hover);\n  --link-color-active: 	var(--action);\n  --toggle-gap: 				.5em;\n  --sub-item-padding:		1em;\n}\n\n.fr-nav-alpha ul.bricks-mobile-menu {\n  display: flex;\n}\n\n.show-mobile-menu ul.bricks-mobile-menu {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n\n.bricks-mobile-menu-toggle {\n	margin-inline-start: auto;\n}\n\n.fr-nav-alpha .brx-submenu-toggle {\n  display: flex;\n  flex-direction: row;\n  gap: var(--toggle-gap);\n}\n\n.fr-nav-alpha .brx-submenu-toggle button {\n  margin: 0!important;\n  padding: 0!important;\n}\n\n.fr-nav-alpha .sub-menu {\n  min-width: auto!important;\n}\n\n.fr-nav-alpha .sub-menu li {\n  padding-inline: var(--sub-item-padding);\n}\";s:21:\"subMenuIconTypography\";a:3:{s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--link-color)\";}s:9:\"font-size\";s:13:\"var(--text-s)\";s:11:\"line-height\";s:1:\"1\";}s:21:\"subMenuBackgroundList\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:15:\"var(--bg-light)\";}}s:17:\"subMenuTypography\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--link-color)\";}s:15:\"text-decoration\";s:4:\"none\";}s:18:\"menuIconTypography\";a:2:{s:9:\"font-size\";s:16:\"var(--icon-size)\";s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--icon-color)\";}}s:23:\"mobileSubMenuTypography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:20:\"var(--fr-text-light)\";}}s:41:\"mobileMenuIconTypography:mobile_landscape\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:20:\"var(--fr-text-light)\";}}s:20:\"menuTypography:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:23:\"var(--link-color-hover)\";}}s:14:\"menuTypography\";a:3:{s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--link-color)\";}s:11:\"line-height\";s:1:\"1\";s:15:\"text-decoration\";s:4:\"none\";}s:20:\"menuActiveTypography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:24:\"var(--link-color-active)\";}}s:11:\"menuPadding\";a:2:{s:3:\"top\";s:24:\"var(--btn-padding-block)\";s:6:\"bottom\";s:24:\"var(--btn-padding-block)\";}s:23:\"subMenuTypography:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:23:\"var(--link-color-hover)\";}}s:27:\"subMenuIconTypography:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:23:\"var(--link-color-hover)\";}}s:24:\"subMenuIconTransformOpen\";a:1:{s:7:\"rotateZ\";s:3:\"270\";}s:21:\"menuIconTransformOpen\";a:1:{s:7:\"rotateZ\";s:3:\"180\";}s:14:\"subMenuPadding\";a:2:{s:5:\"right\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:25:\"_display:mobile_landscape\";s:4:\"flex\";s:7:\"menuGap\";s:18:\"var(--content-gap)\";}}i:2319;a:3:{s:2:\"id\";s:6:\"jwmjjy\";s:4:\"name\";s:29:\"fr-header-foxtrot__cta-button\";s:8:\"settings\";a:1:{s:25:\"_display:mobile_landscape\";s:4:\"none\";}}i:2320;a:3:{s:2:\"id\";s:6:\"gbzdcd\";s:4:\"name\";s:24:\"fr-header-foxtrot__phone\";s:8:\"settings\";a:0:{}}i:2321;a:3:{s:2:\"id\";s:6:\"bixhzb\";s:4:\"name\";s:30:\"fr-header-foxtrot__cta-wrapper\";s:8:\"settings\";a:3:{s:8:\"_display\";s:4:\"flex\";s:11:\"_alignItems\";s:6:\"center\";s:10:\"_columnGap\";s:18:\"var(--content-gap)\";}}i:2322;a:3:{s:2:\"id\";s:6:\"nmsnls\";s:4:\"name\";s:15:\"fr-footer-hotel\";s:8:\"settings\";a:2:{s:7:\"_rowGap\";s:20:\"var(--container-gap)\";s:11:\"_typography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:20:\"var(--fr-text-light)\";}}}}i:2323;a:5:{s:2:\"id\";s:6:\"nvorto\";s:4:\"name\";s:16:\"legal-meta-bravo\";s:8:\"settings\";a:9:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:3:\"row\";s:9:\"_flexWrap\";s:4:\"wrap\";s:10:\"_columnGap\";s:15:\"var(--space-xs)\";s:7:\"_rowGap\";s:15:\"var(--space-xs)\";s:11:\"_typography\";a:1:{s:9:\"font-size\";s:13:\"var(--text-s)\";}s:15:\"_justifyContent\";s:13:\"space-between\";s:10:\"_cssCustom\";s:117:\".legal-meta-bravo a {\n	color: var(--action-light);\n}\n.legal-meta-bravo a:hover {\n	color: var(--action-ultra-light);\n}\";s:31:\"_justifyContent:mobile_portrait\";s:6:\"center\";}s:8:\"modified\";i:1769721114;s:7:\"user_id\";i:1;}i:2324;a:3:{s:2:\"id\";s:6:\"dgafxm\";s:4:\"name\";s:21:\"legal-meta-alpha__nav\";s:8:\"settings\";a:0:{}}i:2325;a:3:{s:2:\"id\";s:6:\"dxiecd\";s:4:\"name\";s:30:\"fr-subfooter-bravo__legal-list\";s:8:\"settings\";a:5:{s:11:\"_alignItems\";s:6:\"center\";s:8:\"_display\";s:4:\"flex\";s:9:\"_flexWrap\";s:4:\"wrap\";s:10:\"_columnGap\";s:18:\"var(--content-gap)\";s:7:\"_rowGap\";s:15:\"var(--space-xs)\";}}i:2326;a:3:{s:2:\"id\";s:6:\"juvywd\";s:4:\"name\";s:35:\"fr-subfooter-bravo__legal-list-item\";s:8:\"settings\";a:0:{}}i:2327;a:3:{s:2:\"id\";s:6:\"llydtv\";s:4:\"name\";s:24:\"fr-subfooter-bravo__link\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:15:\"text-decoration\";s:4:\"none\";}}}i:2328;a:5:{s:2:\"id\";s:6:\"pnzcyb\";s:4:\"name\";s:25:\"fr-footer-delta__legal-li\";s:8:\"settings\";a:0:{}s:8:\"modified\";i:1727193612;s:7:\"user_id\";i:1;}i:2329;a:3:{s:2:\"id\";s:6:\"uptksr\";s:4:\"name\";s:21:\"fr-footer-hotel__grid\";s:8:\"settings\";a:9:{s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-5)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:8:\"_gridGap\";s:20:\"var(--container-gap)\";s:17:\"_alignContentGrid\";s:7:\"stretch\";s:15:\"_alignItemsGrid\";s:10:\"flex-start\";s:10:\"_cssCustom\";s:322:\".fr-footer-hotel__grid,\n.fr-footer-hotel__grid > * {\n	position: relative;\n}\n.fr-footer-hotel__grid > *:first-child::after,\n.fr-footer-hotel__grid::after{\n	content: \'\';\n  position: absolute;\n  bottom: calc((var(--container-gap) / 2) * -1);\n  width: 100%;\n  height: .1em;\n  background-color: var(--neutral-light-trans-40);\n}\";s:24:\"_display:tablet_portrait\";s:4:\"flex\";s:26:\"_direction:tablet_portrait\";s:6:\"column\";}}i:2330;a:3:{s:2:\"id\";s:6:\"pucrbz\";s:4:\"name\";s:32:\"fr-footer-hotel__content-wrapper\";s:8:\"settings\";a:8:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:3:\"row\";s:11:\"_alignItems\";s:7:\"stretch\";s:7:\"_rowGap\";s:15:\"var(--grid-gap)\";s:15:\"_justifyContent\";s:13:\"space-between\";s:6:\"_width\";s:4:\"100%\";s:27:\"_direction:mobile_landscape\";s:6:\"column\";s:19:\"_gridItemColumnSpan\";s:5:\"1/end\";}}i:2331;a:3:{s:2:\"id\";s:6:\"ewingt\";s:4:\"name\";s:28:\"fr-footer-hotel__nav-wrapper\";s:8:\"settings\";a:8:{s:19:\"_gridItemColumnSpan\";s:5:\"1 / 4\";s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-3)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:6:\"_width\";s:4:\"100%\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-2)\";s:36:\"_gridTemplateColumns:mobile_portrait\";s:13:\"var(--grid-1)\";}}i:2332;a:3:{s:2:\"id\";s:6:\"aavuqg\";s:4:\"name\";s:32:\"fr-footer-hotel__contact-wrapper\";s:8:\"settings\";a:5:{s:19:\"_gridItemColumnSpan\";s:7:\"4 / end\";s:8:\"_display\";s:4:\"flex\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:10:\"_direction\";s:6:\"column\";s:11:\"_alignItems\";s:8:\"flex-end\";}}i:2333;a:3:{s:2:\"id\";s:6:\"pajwhc\";s:4:\"name\";s:17:\"fr-social-charlie\";s:8:\"settings\";a:9:{s:8:\"_display\";s:4:\"flex\";s:9:\"_flexWrap\";s:4:\"wrap\";s:10:\"_columnGap\";s:3:\"1em\";s:7:\"_rowGap\";s:3:\"1em\";s:10:\"_cssCustom\";s:229:\".fr-social-charlie {\n	--icon-size: 2em;\n  --icon-fill-color: transparent;\n  --icon-stroke-color: var(--bg-dark);\n  --icon-fill-color-hover: transparent;  \n  --icon-stroke-color-hover: var(--bg-dark);\n  \n  list-style-type: none;\n}\";s:7:\"_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";}s:8:\"_padding\";a:1:{s:4:\"left\";s:1:\"0\";}s:10:\"_direction\";s:3:\"row\";s:6:\"_width\";s:11:\"fit-content\";}}i:2334;a:3:{s:2:\"id\";s:6:\"kknkpc\";s:4:\"name\";s:31:\"fr-social-charlie__icon-wrapper\";s:8:\"settings\";a:5:{s:8:\"_display\";s:4:\"flex\";s:11:\"_alignItems\";s:6:\"center\";s:11:\"_typography\";a:1:{s:15:\"text-decoration\";s:4:\"none\";}s:10:\"_cssCustom\";s:557:\".fr-social-charlie__icon-wrapper:hover {\n	transform: translateY(-.15em); \n}\n\n.fr-social-charlie__icon-wrapper svg {\n  height: var(--icon-size);\n  width: var(--icon-size);\n  fill: var(--icon-fill-color);\n  color: var(--icon-stroke-color);\n}\n\n.fr-social-charlie__icon-wrapper i {\n  color: var(--icon-fill-color);\n  font-size: var(--icon-size);\n}\n\n.fr-social-charlie__icon-wrapper svg:hover {\n  fill: var(--icon-fill-color-hover);\n  color: var(--icon-stroke-color-hover);  \n}\n\n.fr-social-charlie__icon-wrapper i:hover {\n  color: var(--icon-fill-color-hover);\n}\";s:14:\"_cssTransition\";s:19:\"all .3s ease-in-out\";}}i:2335;a:3:{s:2:\"id\";s:6:\"gbzjjq\";s:4:\"name\";s:23:\"fr-social-charlie__icon\";s:8:\"settings\";a:7:{s:8:\"_display\";s:4:\"flex\";s:10:\"_alignSelf\";s:6:\"center\";s:15:\"_justifyContent\";s:6:\"center\";s:11:\"_alignItems\";s:6:\"center\";s:14:\"_flexDirection\";s:6:\"column\";s:8:\"_padding\";a:4:{s:3:\"top\";s:5:\".25em\";s:5:\"right\";s:5:\".25em\";s:6:\"bottom\";s:5:\".25em\";s:4:\"left\";s:5:\".25em\";}s:11:\"_background\";a:1:{s:5:\"color\";a:3:{s:3:\"raw\";s:18:\"var(--fr-bg-light)\";s:2:\"id\";s:6:\"lphijw\";s:4:\"name\";s:8:\"Color #1\";}}}}i:2336;a:3:{s:2:\"id\";s:6:\"itncdh\";s:4:\"name\";s:29:\"fr-social-charlie__icon-label\";s:8:\"settings\";a:0:{}}i:2337;a:3:{s:2:\"id\";s:6:\"yftxxl\";s:4:\"name\";s:27:\"fr-footer-hotel__nav-column\";s:8:\"settings\";a:4:{s:8:\"_display\";s:4:\"flex\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:10:\"_direction\";s:6:\"column\";s:11:\"_alignItems\";s:10:\"flex-start\";}}i:2338;a:3:{s:2:\"id\";s:6:\"mgrmpq\";s:4:\"name\";s:28:\"fr-footer-hotel__nav-heading\";s:8:\"settings\";a:0:{}}i:2339;a:3:{s:2:\"id\";s:6:\"asygxs\";s:4:\"name\";s:21:\"fr-footer-hotel__list\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"flex\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:10:\"_direction\";s:6:\"column\";s:7:\"_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";}s:8:\"_padding\";a:1:{s:4:\"left\";s:1:\"0\";}s:10:\"_cssCustom\";s:50:\".fr-footer-hotel__list {\n	list-style-type: none;\n}\";}}i:2340;a:3:{s:2:\"id\";s:6:\"jparrw\";s:4:\"name\";s:26:\"fr-footer-hotel__list-item\";s:8:\"settings\";a:0:{}}i:2341;a:3:{s:2:\"id\";s:6:\"irgssw\";s:4:\"name\";s:21:\"fr-footer-hotel__link\";s:8:\"settings\";a:2:{s:11:\"_typography\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:19:\"var(--action-light)\";}s:15:\"text-decoration\";s:4:\"none\";}s:10:\"_cssCustom\";s:67:\".fr-footer-hotel__link:hover {\n	color: var(--action-ultra-light);\n}\";}}i:2342;a:3:{s:2:\"id\";s:6:\"qyfjbk\";s:4:\"name\";s:20:\"fr-footer-hotel__cta\";s:8:\"settings\";a:1:{s:10:\"_cssCustom\";s:474:\"/* ACSS Overwrite */\n@media (min-width: 768px) {\n  .fr-footer-hotel__cta .bricks-button {\n    margin-top: 0!important;\n  }\n}\n\n.fr-footer-hotel__cta {\n	display: grid;\n  grid-template-columns: var(--grid-3-1);\n  gap: .5em;\n}\n\n.fr-footer-hotel__cta .form-group {\n	margin-bottom: 0!important;\n  padding: 0;\n}\n\n.fr-footer-hotel__cta .form-group:first-child {\n	padding-inline-start: 0!important;\n}\n.fr-footer-hotel__cta .form-group:last-child {\n	padding-inline-end: 0!important;\n}\";}}i:2343;a:3:{s:2:\"id\";s:6:\"eaonru\";s:4:\"name\";s:32:\"fr-footer-hotel__contact-heading\";s:8:\"settings\";a:0:{}}i:2344;a:3:{s:2:\"id\";s:6:\"vywgca\";s:4:\"name\";s:25:\"fr-footer-hotel__cta-lede\";s:8:\"settings\";a:0:{}}i:2345;a:3:{s:2:\"id\";s:6:\"ysmjpm\";s:4:\"name\";s:21:\"fr-footer-hotel__logo\";s:8:\"settings\";a:1:{s:6:\"_width\";s:4:\"15em\";}}i:2346;a:3:{s:2:\"id\";s:6:\"xchcud\";s:4:\"name\";s:32:\"fr-footer-hotel__contact-details\";s:8:\"settings\";a:7:{s:8:\"_display\";s:4:\"flex\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:11:\"_typography\";a:1:{s:9:\"font-size\";s:13:\"var(--text-s)\";}s:36:\"_gridTemplateColumns:mobile_portrait\";s:13:\"var(--grid-1)\";s:10:\"_columnGap\";s:18:\"var(--content-gap)\";s:7:\"_rowGap\";s:28:\"calc(var(--content-gap) / 2)\";s:9:\"_flexWrap\";s:4:\"wrap\";}}i:2347;a:3:{s:2:\"id\";s:6:\"ldrdfc\";s:4:\"name\";s:26:\"fr-footer-hotel__meta-link\";s:8:\"settings\";a:5:{s:9:\"iconColor\";a:1:{s:3:\"raw\";s:20:\"var(--fr-text-light)\";}s:8:\"iconSize\";s:5:\"1.5em\";s:11:\"_typography\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:19:\"var(--action-light)\";}s:15:\"text-decoration\";s:4:\"none\";}s:17:\"_typography:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:20:\"var(--fr-text-light)\";}}s:10:\"_cssCustom\";s:72:\".fr-footer-hotel__meta-link:hover {\n	color: var(--action-ultra-light);\n}\";}}i:2348;a:3:{s:2:\"id\";s:6:\"vbfrsb\";s:4:\"name\";s:29:\"fr-footer-hotel__meta-wrapper\";s:8:\"settings\";a:3:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:4:\".5em\";}}i:2349;a:3:{s:2:\"id\";s:6:\"vzovlx\";s:4:\"name\";s:29:\"fr-footer-hotel__meta-heading\";s:8:\"settings\";a:0:{}}i:2350;a:3:{s:2:\"id\";s:6:\"bviprr\";s:4:\"name\";s:28:\"fr-footer-hotel__cta-wrapper\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:19:\"_gridItemColumnSpan\";s:7:\"4 / end\";s:6:\"_width\";s:4:\"100%\";s:11:\"_alignItems\";s:10:\"flex-start\";}}i:2351;a:3:{s:2:\"id\";s:6:\"efiaih\";s:4:\"name\";s:13:\"fr-hero-hotel\";s:8:\"settings\";a:3:{s:8:\"_padding\";a:2:{s:3:\"top\";s:23:\"var(--section-space-xl)\";s:6:\"bottom\";s:23:\"var(--section-space-xl)\";}s:9:\"_position\";s:8:\"relative\";s:10:\"_isolation\";s:7:\"isolate\";}}i:2352;a:3:{s:2:\"id\";s:6:\"vtwwtv\";s:4:\"name\";s:7:\"fr-hero\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:20:\"var(--container-gap)\";}}i:2353;a:3:{s:2:\"id\";s:6:\"byzuqt\";s:4:\"name\";s:30:\"fr-hero-hotel__content-wrapper\";s:8:\"settings\";a:6:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:11:\"_alignItems\";s:6:\"center\";s:15:\"_justifyContent\";s:6:\"center\";s:11:\"_typography\";a:2:{s:10:\"text-align\";s:6:\"center\";s:5:\"color\";a:3:{s:3:\"raw\";s:20:\"var(--fr-text-light)\";s:2:\"id\";s:6:\"ualjvt\";s:4:\"name\";s:8:\"Color #3\";}}s:9:\"_position\";s:8:\"relative\";s:7:\"_zIndex\";s:1:\"1\";}}i:2354;a:3:{s:2:\"id\";s:6:\"mbnwqu\";s:4:\"name\";s:22:\"fr-hero-hotel__heading\";s:8:\"settings\";a:1:{s:27:\"_typography:mobile_portrait\";a:1:{s:10:\"text-align\";s:4:\"left\";}}}i:2355;a:3:{s:2:\"id\";s:6:\"zskxqv\";s:4:\"name\";s:19:\"fr-hero-hotel__lede\";s:8:\"settings\";a:1:{s:27:\"_typography:mobile_portrait\";a:1:{s:10:\"text-align\";s:4:\"left\";}}}i:2356;a:3:{s:2:\"id\";s:6:\"konmnk\";s:4:\"name\";s:18:\"fr-cta-links-alpha\";s:8:\"settings\";a:6:{s:10:\"_columnGap\";s:18:\"var(--content-gap)\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:8:\"_display\";s:4:\"flex\";s:9:\"_flexWrap\";s:4:\"wrap\";s:26:\"_cssCustom:mobile_portrait\";s:53:\".fr-cta-links-alpha > * {\n  width: 100% !important;\n}\";s:10:\"_direction\";s:3:\"row\";}}i:2357;a:3:{s:2:\"id\";s:6:\"wbvnsl\";s:4:\"name\";s:19:\"fr-background-alpha\";s:8:\"settings\";a:7:{s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:10:\"_cssCustom\";s:219:\"/* \n\nTo use this frame correctly, ensure the parent container is set to position relative. It\'s also advisable to add the following code to the parent container\'s CSS tab:\n\n.fr-background-alpha {isolation: isolate;}\n\n*/\";s:7:\"_zIndex\";s:2:\"-1\";}}i:2358;a:3:{s:2:\"id\";s:6:\"usirxg\";s:4:\"name\";s:26:\"fr-background-alpha__image\";s:8:\"settings\";a:9:{s:10:\"_objectFit\";s:5:\"cover\";s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:6:\"_width\";s:4:\"100%\";s:7:\"_zIndex\";s:2:\"-1\";s:7:\"_height\";s:4:\"100%\";}}i:2359;a:3:{s:2:\"id\";s:6:\"heyndn\";s:4:\"name\";s:28:\"fr-background-alpha__overlay\";s:8:\"settings\";a:7:{s:7:\"_zIndex\";s:2:\"-1\";s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:26:\"var(--shade-dark-trans-60)\";}}}}i:2360;a:3:{s:2:\"id\";s:6:\"rsjhvx\";s:4:\"name\";s:23:\"fr-content-section-golf\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:20:\"var(--container-gap)\";}}i:2361;a:3:{s:2:\"id\";s:6:\"sohcqn\";s:4:\"name\";s:40:\"fr-content-section-golf__content-wrapper\";s:8:\"settings\";a:0:{}}i:2362;a:3:{s:2:\"id\";s:6:\"qfdtjc\";s:4:\"name\";s:17:\"fr-accent-heading\";s:8:\"settings\";a:3:{s:11:\"_typography\";a:2:{s:11:\"line-height\";s:3:\"1.1\";s:9:\"font-size\";s:13:\"var(--text-m)\";}s:6:\"_order\";s:2:\"-1\";s:7:\"_margin\";a:1:{s:6:\"bottom\";s:1:\"0\";}}}i:2363;a:3:{s:2:\"id\";s:6:\"xkpyhk\";s:4:\"name\";s:29:\"fr-content-section-golf__text\";s:8:\"settings\";a:2:{s:10:\"_cssCustom\";s:106:\".fr-content-section-golf__text {\n  column-count: 2;\n  column-width: 30ch;\n  column-gap: var(--grid-gap);\n}\";s:6:\"_width\";s:4:\"100%\";}}i:2364;a:3:{s:2:\"id\";s:6:\"slhmuz\";s:4:\"name\";s:14:\"fr-intro-bravo\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";}}i:2365;a:3:{s:2:\"id\";s:6:\"okkigb\";s:4:\"name\";s:23:\"fr-intro-bravo__heading\";s:8:\"settings\";a:0:{}}i:2366;a:3:{s:2:\"id\";s:6:\"nhxpij\";s:4:\"name\";s:12:\"fr-cta-alpha\";s:8:\"settings\";a:2:{s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:18:\"var(--fr-bg-light)\";}}s:8:\"_padding\";a:2:{s:3:\"top\";s:22:\"var(--fr-hero-padding)\";s:6:\"bottom\";s:22:\"var(--fr-hero-padding)\";}}}i:2367;a:5:{s:2:\"id\";s:6:\"xyqbek\";s:4:\"name\";s:19:\"fr-cta-alpha__inner\";s:8:\"settings\";a:5:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:11:\"_alignItems\";s:6:\"center\";s:11:\"_typography\";a:1:{s:10:\"text-align\";s:6:\"center\";}s:28:\"_alignItems:mobile_landscape\";s:6:\"center\";s:28:\"_typography:mobile_landscape\";a:1:{s:10:\"text-align\";s:6:\"center\";}}s:8:\"modified\";i:1764795469;s:7:\"user_id\";i:1;}i:2368;a:5:{s:2:\"id\";s:6:\"wlvaip\";s:4:\"name\";s:21:\"fr-cta-alpha__heading\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:9:\"font-size\";s:9:\"var(--h3)\";}}s:8:\"modified\";i:1764777439;s:7:\"user_id\";i:1;}i:2369;a:3:{s:2:\"id\";s:6:\"mjbici\";s:4:\"name\";s:18:\"fr-cta-alpha__lede\";s:8:\"settings\";a:0:{}}i:2370;a:5:{s:2:\"id\";s:6:\"nrmxqn\";s:4:\"name\";s:21:\"fr-cta-alpha__buttons\";s:8:\"settings\";a:10:{s:10:\"_direction\";s:3:\"row\";s:11:\"_alignItems\";s:6:\"center\";s:10:\"_columnGap\";s:18:\"var(--content-gap)\";s:8:\"_display\";s:4:\"flex\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:27:\"_direction:mobile_landscape\";s:3:\"row\";s:26:\"_direction:mobile_portrait\";s:6:\"column\";s:26:\"_columnGap:mobile_portrait\";s:15:\"var(--space-xs)\";s:23:\"_rowGap:mobile_portrait\";s:15:\"var(--space-xs)\";s:22:\"_width:mobile_portrait\";s:4:\"100%\";}s:8:\"modified\";i:1764795469;s:7:\"user_id\";i:1;}i:2371;a:3:{s:2:\"id\";s:6:\"vquqbc\";s:4:\"name\";s:29:\"fr-cta-alpha__heading-wrapper\";s:8:\"settings\";a:2:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";}}i:2372;a:3:{s:2:\"id\";s:6:\"kuvuie\";s:4:\"name\";s:15:\"fr-hero-charlie\";s:8:\"settings\";a:2:{s:8:\"_padding\";a:2:{s:3:\"top\";i:0;s:6:\"bottom\";i:0;}s:9:\"_overflow\";s:6:\"hidden\";}}i:2373;a:3:{s:2:\"id\";s:6:\"ewbtpj\";s:4:\"name\";s:30:\"fr-hero-charlie__inner-wrapper\";s:8:\"settings\";a:8:{s:23:\"_rowGap:tablet_portrait\";s:3:\"0px\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:8:\"_display\";s:4:\"grid\";s:36:\"_gridTemplateColumns:tablet_portrait\";s:13:\"var(--grid-1)\";s:10:\"_cssCustom\";s:66:\".fr-hero-charlie__inner-wrapper {\n	--grid-gap: var(--space-xxl);\n}\";}}i:2374;a:3:{s:2:\"id\";s:6:\"rxyjcv\";s:4:\"name\";s:32:\"fr-hero-charlie__content-wrapper\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:15:\"_justifyContent\";s:6:\"center\";s:24:\"_padding:tablet_portrait\";a:2:{s:4:\"unit\";a:2:{s:3:\"top\";s:22:\"var(--section-space-m)\";s:6:\"bottom\";s:22:\"var(--section-space-m)\";}s:3:\"top\";s:0:\"\";}s:8:\"_padding\";a:2:{s:3:\"top\";s:16:\"var(--space-xxl)\";s:6:\"bottom\";s:16:\"var(--space-xxl)\";}}}i:2375;a:3:{s:2:\"id\";s:6:\"urnhlc\";s:4:\"name\";s:30:\"fr-hero-charlie__media-wrapper\";s:8:\"settings\";a:7:{s:22:\"_width:tablet_portrait\";s:5:\"100vw\";s:26:\"_heightMax:tablet_portrait\";s:6:\"70vmin\";s:22:\"_order:tablet_portrait\";s:2:\"-1\";s:25:\"_widthMax:tablet_portrait\";s:5:\"100vw\";s:26:\"_transform:tablet_portrait\";a:1:{s:10:\"translateX\";s:33:\"calc(var(--section-padding-x)*-1)\";}s:6:\"_width\";s:4:\"50vw\";s:9:\"_widthMax\";s:4:\"50vw\";}}i:2376;a:3:{s:2:\"id\";s:6:\"bnpjsi\";s:4:\"name\";s:22:\"fr-hero-charlie__media\";s:8:\"settings\";a:3:{s:10:\"_objectFit\";s:5:\"cover\";s:6:\"_width\";s:4:\"100%\";s:7:\"_height\";s:4:\"100%\";}}i:2377;a:3:{s:2:\"id\";s:6:\"kmpajx\";s:4:\"name\";s:24:\"fr-hero-charlie__heading\";s:8:\"settings\";a:0:{}}i:2378;a:3:{s:2:\"id\";s:6:\"exgkjt\";s:4:\"name\";s:28:\"fr-hero-charlie__cta-wrapper\";s:8:\"settings\";a:4:{s:8:\"_display\";s:4:\"flex\";s:9:\"_flexWrap\";s:4:\"wrap\";s:10:\"_columnGap\";s:18:\"var(--fr-card-gap)\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";}}i:2379;a:3:{s:2:\"id\";s:6:\"tffgfi\";s:4:\"name\";s:21:\"fr-hero-charlie__lede\";s:8:\"settings\";a:0:{}}i:2380;a:3:{s:2:\"id\";s:6:\"xddgnb\";s:4:\"name\";s:21:\"fr-article-grid-india\";s:8:\"settings\";a:7:{s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:26:\"_cssCustom:tablet_portrait\";s:66:\".fr-article-grid-india {\n	grid-template-columns: repeat(2, 1fr);\n}\";s:27:\"_cssCustom:mobile_landscape\";s:66:\".fr-article-grid-india {\n	grid-template-columns: repeat(1, 1fr);\n}\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-3)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:8:\"_display\";s:4:\"grid\";}}i:2381;a:3:{s:2:\"id\";s:6:\"mxcpbw\";s:4:\"name\";s:21:\"fr-article-card-india\";s:8:\"settings\";a:14:{s:8:\"_padding\";a:4:{s:3:\"top\";s:22:\"var(--fr-card-padding)\";s:5:\"right\";s:22:\"var(--fr-card-padding)\";s:6:\"bottom\";s:22:\"var(--fr-card-padding)\";s:4:\"left\";s:22:\"var(--fr-card-padding)\";}s:10:\"_alignSelf\";s:7:\"stretch\";s:9:\"_position\";s:8:\"relative\";s:10:\"_cssCustom\";s:808:\".fr-article-card-india {\n  /* Opacity of media / featured image */\n  --media-opacity: .2;\n  /* Increase or decrease hover effect (plus or minus) */\n  --media-opacity-operator: +;\n  /* Opacity shift on hover (must be decimal adjustment) */\n  --media-opacity-shift: .2;\n  /* Transition of opacity */\n  --media-transition: all .3s ease;\n  /* Adjust scale amount on hover */\n  --media-hover-scale: 1.1;\n  /* Footer Divider thickness */\n  --divider-thickness: 1px;\n  /* Footer Divider color */\n  --divider-color: var(--shade-light-trans-20);\n  /* Divider Gap */\n  --divider-gap: var(--fr-card-gap);\n  \n	isolation: isolate;\n}\n\n.fr-article-card-india:hover > .brxe-image {\n	opacity: calc(var(--media-opacity) var(--media-opacity-operator) var(--media-opacity-shift));\n  transform: scale(var(--media-hover-scale));\n}\";s:11:\"_background\";a:1:{s:5:\"color\";a:3:{s:2:\"id\";s:28:\"acss_import_shade-ultra-dark\";s:4:\"name\";s:16:\"shade-ultra-dark\";s:3:\"raw\";s:23:\"var(--shade-ultra-dark)\";}}s:11:\"_typography\";a:1:{s:5:\"color\";a:3:{s:3:\"raw\";s:20:\"var(--fr-text-light)\";s:2:\"id\";s:6:\"ualjvt\";s:4:\"name\";s:8:\"Color #3\";}}s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:14:\"_cssTransition\";s:12:\"all .3s ease\";s:9:\"_overflow\";s:6:\"hidden\";s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:21:\"var(--fr-card-radius)\";s:5:\"right\";s:21:\"var(--fr-card-radius)\";s:6:\"bottom\";s:21:\"var(--fr-card-radius)\";s:4:\"left\";s:21:\"var(--fr-card-radius)\";}}s:10:\"_direction\";s:6:\"column\";s:8:\"_display\";s:4:\"flex\";s:15:\"_justifyContent\";s:13:\"space-between\";s:10:\"_heightMin\";s:4:\"18em\";}}i:2382;a:3:{s:2:\"id\";s:6:\"oaivpr\";s:4:\"name\";s:29:\"fr-article-card-india__header\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";}}i:2383;a:3:{s:2:\"id\";s:6:\"vkuwyd\";s:4:\"name\";s:30:\"fr-article-card-india__heading\";s:8:\"settings\";a:0:{}}i:2384;a:3:{s:2:\"id\";s:6:\"ardvqz\";s:4:\"name\";s:37:\"fr-article-card-india__category-badge\";s:8:\"settings\";a:3:{s:11:\"_typography\";a:3:{s:5:\"color\";a:3:{s:3:\"raw\";s:20:\"var(--fr-text-light)\";s:2:\"id\";s:6:\"ualjvt\";s:4:\"name\";s:8:\"Color #3\";}s:15:\"text-decoration\";s:4:\"none\";s:9:\"font-size\";s:13:\"var(--text-s)\";}s:10:\"_cssCustom\";s:101:\".fr-article-card-india__category-badge > a {\n	color: var(--fr-text-light);\n  text-decoration: none;\n}\";s:6:\"_order\";s:2:\"-1\";}}i:2385;a:3:{s:2:\"id\";s:6:\"vzqbvh\";s:4:\"name\";s:27:\"fr-article-card-india__date\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:9:\"font-size\";s:13:\"var(--text-s)\";}}}i:2386;a:3:{s:2:\"id\";s:6:\"labfaz\";s:4:\"name\";s:29:\"fr-article-card-india__footer\";s:8:\"settings\";a:1:{s:10:\"_cssCustom\";s:203:\".fr-article-card-india__footer::before {\n	content: \'\';\n  width: 100%;\n  height: var(--divider-thickness);\n  display: flex;\n  background-color: var(--divider-color);\n  margin-bottom: var(--divider-gap);\n}\";}}i:2387;a:3:{s:2:\"id\";s:6:\"trxkhe\";s:4:\"name\";s:29:\"fr-article-card-india__author\";s:8:\"settings\";a:4:{s:10:\"_direction\";s:3:\"row\";s:10:\"_columnGap\";s:18:\"var(--fr-card-gap)\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:11:\"_alignItems\";s:6:\"center\";}}i:2388;a:3:{s:2:\"id\";s:6:\"wmmvgo\";s:4:\"name\";s:36:\"fr-article-card-india__author-avatar\";s:8:\"settings\";a:5:{s:10:\"_objectFit\";s:5:\"cover\";s:6:\"_width\";s:5:\"2.5em\";s:7:\"_height\";s:5:\"2.5em\";s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:3:\"50%\";s:5:\"right\";s:3:\"50%\";s:6:\"bottom\";s:3:\"50%\";s:4:\"left\";s:3:\"50%\";}}s:9:\"_overflow\";s:6:\"hidden\";}}i:2389;a:3:{s:2:\"id\";s:6:\"lplfgy\";s:4:\"name\";s:34:\"fr-article-card-india__author-name\";s:8:\"settings\";a:0:{}}i:2390;a:3:{s:2:\"id\";s:6:\"fzbupp\";s:4:\"name\";s:28:\"fr-article-card-india__media\";s:8:\"settings\";a:12:{s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:6:\"_width\";s:4:\"100%\";s:7:\"_height\";s:4:\"100%\";s:10:\"_objectFit\";s:5:\"cover\";s:7:\"_zIndex\";s:2:\"-1\";s:8:\"_opacity\";s:20:\"var(--media-opacity)\";s:14:\"_cssTransition\";s:23:\"var(--media-transition)\";s:8:\"_display\";s:4:\"flex\";}}i:2391;a:3:{s:2:\"id\";s:6:\"flermp\";s:4:\"name\";s:23:\"fr-contact-section-echo\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:23:\"var(--fr-container-gap)\";}}i:2392;a:3:{s:2:\"id\";s:6:\"dzsoqv\";s:4:\"name\";s:30:\"fr-contact-section-echo__inner\";s:8:\"settings\";a:2:{s:10:\"_cssCustom\";s:145:\".fr-contact-section-echo__inner {\n	display: grid;\n  grid-template-columns: repeat(2, 1fr);\n  gap: var(--fr-content-gap);\n  align-items: center;\n}\";s:26:\"_cssCustom:tablet_portrait\";s:65:\".fr-contact-section-echo__inner {\n  grid-template-columns: 1fr;\n}\";}}i:2393;a:3:{s:2:\"id\";s:6:\"mevyms\";s:4:\"name\";s:40:\"fr-contact-section-echo__content-wrapper\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:21:\"var(--fr-content-gap)\";}}i:2394;a:3:{s:2:\"id\";s:6:\"genroh\";s:4:\"name\";s:22:\"fr-form-alpha__wrapper\";s:8:\"settings\";a:0:{}}i:2395;a:3:{s:2:\"id\";s:6:\"kxcamf\";s:4:\"name\";s:32:\"fr-contact-section-echo__heading\";s:8:\"settings\";a:0:{}}i:2396;a:3:{s:2:\"id\";s:6:\"olzjai\";s:4:\"name\";s:29:\"fr-contact-section-echo__lede\";s:8:\"settings\";a:0:{}}i:2397;a:3:{s:2:\"id\";s:6:\"woidrf\";s:4:\"name\";s:13:\"fr-list-alpha\";s:8:\"settings\";a:6:{s:7:\"_rowGap\";s:4:\".5em\";s:8:\"_padding\";a:1:{s:4:\"left\";s:1:\"0\";}s:7:\"_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";}s:10:\"_cssCustom\";s:227:\".fr-list-alpha {\n	--icon-size: 1.5em;\n  --icon-fill-color: transparent;\n  --icon-stroke-color: var(--bg-dark);\n  --icon-fill-color-hover: transparent;  \n  --icon-stroke-color-hover: var(--bg-dark);\n  \n  list-style-type: none;\n}\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";}}i:2398;a:3:{s:2:\"id\";s:6:\"qyyvjt\";s:4:\"name\";s:17:\"fr-list-alpha__li\";s:8:\"settings\";a:5:{s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:19:\"auto minmax(0, 1fr)\";s:15:\"_alignItemsGrid\";s:6:\"center\";s:8:\"_gridGap\";s:4:\".5em\";s:10:\"_cssCustom\";s:418:\".fr-list-alpha__li svg {\n  height: var(--icon-size);\n  width: var(--icon-size);\n  fill: var(--icon-fill-color);\n  color: var(--icon-stroke-color);\n}\n\n.fr-list-alpha__li i {\n  color: var(--icon-fill-color);\n  font-size: var(--icon-size);\n}\n\n.fr-list-alpha__li svg:hover {\n  fill: var(--icon-fill-color-hover);\n  color: var(--icon-stroke-color);  \n}\n\n.fr-list-alpha__li i:hover {\n  color: var(--icon-fill-color-hover);\n}\";}}i:2399;a:3:{s:2:\"id\";s:6:\"oimttb\";s:4:\"name\";s:19:\"fr-list-alpha__icon\";s:8:\"settings\";a:4:{s:9:\"_position\";s:8:\"relative\";s:6:\"_width\";s:16:\"var(--icon-size)\";s:9:\"_widthMin\";s:16:\"var(--icon-size)\";s:8:\"iconSize\";s:13:\"var(--text-l)\";}}i:2400;a:3:{s:2:\"id\";s:6:\"rekwpw\";s:4:\"name\";s:19:\"fr-list-alpha__text\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:11:\"line-height\";s:3:\"1.2\";}}}i:2401;a:3:{s:2:\"id\";s:6:\"mithno\";s:4:\"name\";s:27:\"fr-contact-card-alpha__form\";s:8:\"settings\";a:1:{s:6:\"_width\";s:4:\"100%\";}}i:2402;a:3:{s:2:\"id\";s:6:\"wughmh\";s:4:\"name\";s:20:\"fr-badge-group-alpha\";s:8:\"settings\";a:5:{s:10:\"_direction\";s:3:\"row\";s:8:\"_display\";s:4:\"flex\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:10:\"_columnGap\";s:18:\"var(--content-gap)\";s:26:\"_direction:mobile_portrait\";s:6:\"column\";}}i:2403;a:3:{s:2:\"id\";s:6:\"cogkhk\";s:4:\"name\";s:14:\"fr-badge-alpha\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"flex\";s:11:\"_alignItems\";s:6:\"center\";s:10:\"_columnGap\";s:5:\"0.5em\";s:10:\"_cssCustom\";s:490:\".fr-badge-alpha {\n	--icon-size: 1em;\n  --icon-fill-color: transparent;\n  --icon-stroke-color: var(--text-dark);\n  --icon-fill-color-hover: transparent;  \n  --icon-stroke-color-hover: var(--text-dark);\n}\n\n/* \nAttribute value is set via data attribute\non the icon wrapper. The value may not render\ninside the editor, but will render on front end.\n*/\n\n.fr-badge-alpha__icon-wrapper::after {\n  content: attr(data-badge-value);\n  position: relative;\n  display: flex;\n  color: var(--text-dark);\n}\";s:11:\"_typography\";a:1:{s:11:\"line-height\";s:1:\"1\";}s:6:\"_width\";s:11:\"max-content\";}}i:2404;a:3:{s:2:\"id\";s:6:\"gsmrgo\";s:4:\"name\";s:20:\"fr-badge-alpha__icon\";s:8:\"settings\";a:0:{}}i:2405;a:3:{s:2:\"id\";s:6:\"uxsnwg\";s:4:\"name\";s:21:\"fr-badge-alpha__label\";s:8:\"settings\";a:0:{}}i:2406;a:3:{s:2:\"id\";s:6:\"axkvcb\";s:4:\"name\";s:28:\"fr-badge-alpha__icon-wrapper\";s:8:\"settings\";a:7:{s:8:\"_display\";s:4:\"flex\";s:11:\"_alignItems\";s:6:\"center\";s:10:\"_columnGap\";s:5:\".25em\";s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:21:\"var(--black-trans-10)\";}}s:8:\"_padding\";a:4:{s:3:\"top\";s:4:\".5em\";s:5:\"right\";s:4:\".5em\";s:6:\"bottom\";s:4:\".5em\";s:4:\"left\";s:4:\".5em\";}s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:21:\"var(--fr-card-radius)\";s:5:\"right\";s:21:\"var(--fr-card-radius)\";s:6:\"bottom\";s:21:\"var(--fr-card-radius)\";s:4:\"left\";s:21:\"var(--fr-card-radius)\";}}s:10:\"_cssCustom\";s:462:\".fr-badge-alpha__icon-wrapper svg {\n  height: var(--icon-size);\n  width: var(--icon-size);\n  fill: var(--icon-fill-color);\n  color: var(--icon-stroke-color);\n}\n\n.fr-badge-alpha__icon-wrapper i {\n  color: var(--icon-fill-color);\n  font-size: var(--icon-size);\n}\n\n.fr-badge-alpha__icon-wrapper svg:hover {\n  fill: var(--icon-fill-color-hover);\n  color: var(--icon-stroke-color);  \n}\n\n.fr-badge-alpha__icon-wrapper i:hover {\n  color: var(--icon-fill-color-hover);\n}\";}}i:2407;a:3:{s:2:\"id\";s:6:\"lbxdne\";s:4:\"name\";s:26:\"fr-contact-section-charlie\";s:8:\"settings\";a:2:{s:7:\"_rowGap\";s:20:\"var(--container-gap)\";s:8:\"_padding\";a:1:{s:3:\"top\";i:0;}}}i:2408;a:3:{s:2:\"id\";s:6:\"ivlllg\";s:4:\"name\";s:40:\"fr-contact-section-charlie__info-wrapper\";s:8:\"settings\";a:2:{s:10:\"_cssCustom\";s:129:\".fr-contact-section-charlie__info-wrapper {\n	display: grid;\n  grid-template-columns: repeat(3, 1fr);\n  gap: var(--fr-grid-gap);\n}\";s:27:\"_cssCustom:mobile_landscape\";s:75:\".fr-contact-section-charlie__info-wrapper {\n  grid-template-columns: 1fr;\n}\";}}i:2409;a:3:{s:2:\"id\";s:6:\"svfpre\";s:4:\"name\";s:21:\"fr-contact-info-bravo\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"flex\";s:11:\"_alignItems\";s:10:\"flex-start\";s:15:\"_justifyContent\";s:10:\"flex-start\";s:10:\"_cssCustom\";s:207:\".fr-contact-info-bravo {\n	--icon-size: 1.5em;\n  --icon-fill-color: transparent;\n  --icon-stroke-color: var(--bg-dark);\n  --icon-fill-color-hover: transparent;  \n  --icon-stroke-color-hover: var(--bg-dark);\n}\";s:11:\"_typography\";a:1:{s:10:\"font-style\";s:6:\"normal\";}s:10:\"_columnGap\";s:15:\"var(--space-xs)\";}}i:2410;a:3:{s:2:\"id\";s:6:\"xdmusy\";s:4:\"name\";s:27:\"fr-contact-info-bravo__icon\";s:8:\"settings\";a:0:{}}i:2411;a:5:{s:2:\"id\";s:6:\"hlmnio\";s:4:\"name\";s:38:\"fr-contact-info-bravo__content-wrapper\";s:8:\"settings\";a:3:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:17:\"var(--space-none)\";}s:8:\"modified\";i:1732397610;s:7:\"user_id\";i:1;}i:2412;a:3:{s:2:\"id\";s:6:\"uputxu\";s:4:\"name\";s:30:\"fr-contact-info-bravo__heading\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:2:{s:11:\"font-weight\";s:3:\"700\";s:9:\"font-size\";s:13:\"var(--text-m)\";}}}i:2413;a:3:{s:2:\"id\";s:6:\"vqnerm\";s:4:\"name\";s:30:\"fr-contact-info-bravo__details\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:2:{s:15:\"text-decoration\";s:4:\"none\";s:9:\"font-size\";s:13:\"var(--text-m)\";}}}i:2414;a:3:{s:2:\"id\";s:6:\"lerazo\";s:4:\"name\";s:41:\"fr-contact-section-charlie__media-wrapper\";s:8:\"settings\";a:4:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:6:\"_width\";s:4:\"100%\";s:6:\"_order\";s:2:\"-1\";}}i:2415;a:3:{s:2:\"id\";s:6:\"fwkbpr\";s:4:\"name\";s:31:\"fr-contact-section-charlie__map\";s:8:\"settings\";a:2:{s:6:\"height\";s:4:\"40vh\";s:10:\"_cssCustom\";s:52:\".fr-contact-section-charlie__map .map {height: 100%}\";}}i:2416;a:3:{s:2:\"id\";s:6:\"remgbt\";s:4:\"name\";s:21:\"fr-product-grid-alpha\";s:8:\"settings\";a:13:{s:10:\"_cssCustom\";s:46:\".fr-product-grid-alpha {\n  list-style: none;\n}\";s:26:\"_cssCustom:tablet_portrait\";s:67:\".fr-product-grid-alpha {\n  grid-template-columns: repeat(2, 1fr);\n}\";s:27:\"_cssCustom:mobile_landscape\";s:67:\".fr-product-grid-alpha {\n  grid-template-columns: repeat(1, 1fr);\n}\";s:10:\"_columnGap\";s:15:\"var(--grid-gap)\";s:7:\"_rowGap\";s:15:\"var(--grid-gap)\";s:8:\"_display\";s:4:\"grid\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-3)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:8:\"_padding\";a:1:{s:4:\"left\";s:1:\"0\";}s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:36:\"_gridTemplateColumns:tablet_portrait\";s:13:\"var(--grid-2)\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";}}i:2417;a:3:{s:2:\"id\";s:6:\"taoblw\";s:4:\"name\";s:21:\"fr-product-card-alpha\";s:8:\"settings\";a:5:{s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:9:\"_position\";s:8:\"relative\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:15:\"_justifyContent\";s:13:\"space-between\";}}i:2418;a:3:{s:2:\"id\";s:6:\"ooeina\";s:4:\"name\";s:27:\"fr-product-card-alpha__body\";s:8:\"settings\";a:2:{s:7:\"_rowGap\";s:28:\"calc(var(--fr-card-gap) / 2)\";s:11:\"_typography\";a:1:{s:15:\"text-decoration\";s:4:\"none\";}}}i:2419;a:3:{s:2:\"id\";s:6:\"tuqoqz\";s:4:\"name\";s:30:\"fr-product-card-alpha__heading\";s:8:\"settings\";a:0:{}}i:2420;a:3:{s:2:\"id\";s:6:\"hcydby\";s:4:\"name\";s:23:\"fr-product-rating-alpha\";s:8:\"settings\";a:5:{s:10:\"_cssCustom\";s:1505:\"/* RATINGS WON\'T RENDER IN BUILDER */\n\n/* To change the star rating, change the value of the data attribute in the attributes tab on this element. If you want the rating to be generated dynamically, create a \"rating\" custom field for your parent element and then inject the value of that field dynamically into the data attribute value field. */\n\n.fr-product-rating-alpha {\n	--icon-size: 1.25em;\n}\n\n.fr-product-rating-alpha svg {\n	width: var(--icon-size);\n  height: var(--icon-size);\n}\n\n.fr-product-rating-alpha > i:first-child,\n.fr-product-rating-alpha > svg:first-child {display: none;} /* Hide half star by default */\n\n[data-rating*=\".\"] > i:first-child,\n[data-rating*=\".\"] > svg:first-child {display: flex;} /* Show half star for decimal ratings */\n\n[data-rating*=\".0\"] > i:first-child,\n[data-rating*=\".0\"] > svg:first-child {display: none;} /* Hide half star for .0 ratings */\n\n[data-rating^=\"0\"] > i,\n[data-rating^=\"0\"] > svg {\n display: none;\n}\n\n[data-rating^=\"1\"] > i:nth-child(n+3),\n[data-rating^=\"1\"] > svg:nth-child(n+3){\n display: none;\n}\n\n[data-rating^=\"2\"] > i:nth-child(n+4),\n[data-rating^=\"2\"] > svg:nth-child(n+4){\n display: none;\n}\n\n[data-rating^=\"3\"] > i:nth-child(n+5),\n[data-rating^=\"3\"] > svg:nth-child(n+5){\n display: none;\n}\n\n[data-rating^=\"4\"] > i:nth-child(n+6),\n[data-rating^=\"4\"] > svg:nth-child(n+6){\n display: none;\n}\n\n[data-rating*=\".\"] > span.fr-product-rating-alpha__notice {\n display: none;\n}\n\n[data-rating^=\"0\"] > span.fr-product-rating-alpha__notice {\n display: flex;\n}\";s:8:\"_display\";s:4:\"flex\";s:7:\"_rowGap\";s:5:\".25em\";s:10:\"_columnGap\";s:5:\".25em\";s:11:\"_alignItems\";s:6:\"center\";}}i:2421;a:3:{s:2:\"id\";s:6:\"lwaybn\";s:4:\"name\";s:21:\"fr-rating-alpha__icon\";s:8:\"settings\";a:2:{s:9:\"iconColor\";a:3:{s:2:\"id\";s:18:\"acss_import_action\";s:4:\"name\";s:6:\"action\";s:3:\"raw\";s:13:\"var(--action)\";}s:8:\"iconSize\";s:13:\"var(--text-l)\";}}i:2422;a:3:{s:2:\"id\";s:6:\"tshuyw\";s:4:\"name\";s:26:\"fr-rating-alpha__icon-half\";s:8:\"settings\";a:1:{s:6:\"_order\";s:1:\"1\";}}i:2423;a:3:{s:2:\"id\";s:6:\"ocmxcb\";s:4:\"name\";s:31:\"fr-product-rating-alpha__notice\";s:8:\"settings\";a:1:{s:6:\"_order\";s:1:\"1\";}}i:2424;a:3:{s:2:\"id\";s:6:\"wlirwx\";s:4:\"name\";s:39:\"fr-product-rating-alpha__reviews-number\";s:8:\"settings\";a:1:{s:6:\"_order\";s:1:\"2\";}}i:2425;a:3:{s:2:\"id\";s:6:\"ziywgz\";s:4:\"name\";s:36:\"fr-product-card-alpha__price-wrapper\";s:8:\"settings\";a:0:{}}i:2426;a:3:{s:2:\"id\";s:6:\"ttvdnc\";s:4:\"name\";s:28:\"fr-product-card-alpha__price\";s:8:\"settings\";a:1:{s:10:\"_cssCustom\";s:34:\"ins {\n    text-decoration: none;\n}\";}}i:2427;a:3:{s:2:\"id\";s:6:\"oknvgj\";s:4:\"name\";s:33:\"fr-product-card-alpha__sale-badge\";s:8:\"settings\";a:5:{s:10:\"_cssCustom\";s:173:\".fr-product-card-alpha__sale-badge .onsale {\n	padding: .25em .75em;\n  background: var(--fr-bg-dark);\n  color: var(--fr-text-light);\n  border-radius: var(--fr-card-radius);\n}\";s:7:\"_zIndex\";s:1:\"1\";s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:3:\"1em\";s:5:\"_left\";s:3:\"1em\";}}i:2428;a:3:{s:2:\"id\";s:6:\"shvfvc\";s:4:\"name\";s:28:\"fr-product-card-alpha__image\";s:8:\"settings\";a:3:{s:6:\"_order\";s:2:\"-1\";s:10:\"_objectFit\";s:5:\"cover\";s:10:\"_cssCustom\";s:53:\".fr-product-card-alpha__image {\n	aspect-ratio: 4/3;\n}\";}}i:2429;a:3:{s:2:\"id\";s:6:\"svzfos\";s:4:\"name\";s:29:\"fr-product-card-alpha__footer\";s:8:\"settings\";a:7:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:3:\"row\";s:10:\"_columnGap\";s:15:\"var(--grid-gap)\";s:11:\"_alignItems\";s:6:\"center\";s:10:\"_cssCustom\";s:31:\".added_to_cart {\n	padding: 0;\n}\";s:7:\"_rowGap\";s:15:\"var(--grid-gap)\";s:9:\"_flexWrap\";s:4:\"wrap\";}}i:2430;a:3:{s:2:\"id\";s:6:\"amphvw\";s:4:\"name\";s:20:\"fr-add-to-cart-alpha\";s:8:\"settings\";a:1:{s:10:\"_cssCustom\";s:1271:\".fr-add-to-cart-alpha {\n	--button-color: 			var(--action);\n  --button-color-hover: var(--action-hover);  \n  --button-text: 				var(--fr-text-light);  \n  --button-text-hover: 	var(--fr-text-light); \n  --cart-gap: 					var(--grid-gap);\n}\n\n.fr-add-to-cart-alpha {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n	gap: var(--cart-gap);\n}\n\n.fr-add-to-cart-alpha a:not(.added_to_cart) {\n	background-color: var(--button-color)!important;\n  border-color: var(--button-color)!important;\n	color: var(--button-text)!important;  \n  border-width: var(--btn-border-size)!important;\n  border-radius: var(--btn-radius)!important;\n  border-style: solid;  \n  min-width: var(--btn-width)!important;\n  line-height: var(--btn-line-height)!important;  \n  letter-spacing: var(--btn-letter-spacing)!important;\n  text-transform: var(--btn-text-transform)!important;\n  text-decoration: var(--btn-text-decoration)!important;\n	font-style: var(--btn-text-style)!important;\n  font-weight: var(--btn-weight)!important;\n  padding: var(--btn-pad-y) var(--btn-pad-x)!important;\n}\n.fr-add-to-cart-alpha a:hover:not(.added_to_cart)  {\n	background-color: var(--button-color-hover)!important;\n  border-color: var(--button-color-hover)!important;\n	color: var(--button-text-hover)!important;   \n}\";}}i:2431;a:3:{s:2:\"id\";s:6:\"tjxshk\";s:4:\"name\";s:23:\"fr-single-product-alpha\";s:8:\"settings\";a:2:{s:7:\"_rowGap\";s:20:\"var(--container-gap)\";s:10:\"_cssCustom\";s:853:\".fr-single-product-alpha {\n  \n  /* Gallery Styling*/\n  --img-gallery-ratio: 1;\n  --img-gallery-radius: var(--btn-radius);\n  \n  /* Spacing - for a consistent look */\n  --product-gap: calc(var(--grid-gap) / 1.5);  \n  \n  /* Price Styling */\n  --price-color: var(--text-dark);\n  --canceled-price-color: var(--danger);\n  --price-font-size: var(--h3);\n  \n  /* Variation Styling */\n  --variation-label-color:var(--text-dark);\n  --variation-span: 3;	\n  --border-color: var(--neutral-light);\n  --border-width: .1em;\n  --quantity-width: var(--width-xs);\n  \n  /* Button (add to cart + review submit) Styling */\n  --button-color: var(--action);\n  --button-color-hover: var(--action-hover);  \n  --button-text: var(--text-light);  \n  --button-text-hover: var(--text-light); \n  \n  /* Review Styling */\n  --review-avatar-size: 3.5em;\n  --review-avatar-radius: 50%;\n  \n}\";}}i:2432;a:3:{s:2:\"id\";s:6:\"uwxhpo\";s:4:\"name\";s:29:\"fr-single-product-alpha__grid\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"grid\";s:8:\"_gridGap\";s:25:\"calc(var(--grid-gap) * 2)\";s:20:\"_gridTemplateColumns\";s:15:\"var(--grid-1-2)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";}}i:2433;a:3:{s:2:\"id\";s:6:\"npbshj\";s:4:\"name\";s:32:\"fr-single-product-alpha__content\";s:8:\"settings\";a:3:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--product-gap)\";}}i:2434;a:3:{s:2:\"id\";s:6:\"ffosbi\";s:4:\"name\";s:32:\"fr-single-product-alpha__heading\";s:8:\"settings\";a:0:{}}i:2435;a:3:{s:2:\"id\";s:6:\"jvsdyq\";s:4:\"name\";s:29:\"fr-single-product-alpha__tabs\";s:8:\"settings\";a:1:{s:10:\"_cssCustom\";s:1828:\".fr-single-product-alpha__tabs .woocommerce-tabs .wc-tabs {\n  flex-wrap: wrap;\n  gap: var(--product-gap);\n  padding: var(--product-gap);\n  border-color: var(--border-color);  \n}\n\n.fr-single-product-alpha__tabs .woocommerce-tabs .wc-tabs li {\n  padding: 0;\n}\n\n.fr-single-product-alpha__tabs .woocommerce-tabs {\n  border-color: var(--border-color); \n  border-width: 0 0 var(--border-width) 0!important;\n}\n\n.fr-single-product-alpha__tabs input.button {\n  background-color: var(--button-color);\n  border-color: var(--button-color);\n  color: var(--button-text);  \n  border-width: var(--btn-border-size);\n  border-radius: var(--btn-radius);\n  border-style: solid;  \n  min-width: var(--btn-width);\n  line-height: var(--btn-line-height);  \n  letter-spacing: var(--btn-letter-spacing);\n  text-transform: var(--btn-text-transform);\n  text-decoration: var(--btn-text-decoration);\n  font-style: var(--btn-text-style);\n  font-weight: var(--btn-weight);\n  padding: var(--btn-pad-y) var(--btn-pad-x);	\n}\n\n.fr-single-product-alpha__tabs input.button:hover {\n  background-color: var(--button-color-hover);\n  border-color: var(--button-color-hover);\n  color: var(--button-text-hover);   \n}\n\n.fr-single-product-alpha__tabs .woocommerce-tabs .panel {\n  padding: var(--product-gap);\n}\n\n.fr-single-product-alpha__tabs .woocommerce-Reviews {\n  max-width: 60ch\n}\n\n#reviews .description {\n  border-color: var(--border-color); \n  border-width: 0 0 var(--border-width) 0!important;\n  margin: 0;\n  padding: 0;\n}\n#reviews p.meta {\n  margin: 0;\n}\n\n#reviews .comment-text {\n  display: flex;\n  flex-direction: column;\n  gap: var(--product-gap);\n}\n\n#reviews .avatar {\n  border-radius: var(--review-avatar-radius);\n  height: var(--review-avatar-size);\n  margin: 0;\n  width: var(--review-avatar-size);\n}\n\n#reviews .comment_container {\n  gap: var(--product-gap);\n}\";}}i:2436;a:3:{s:2:\"id\";s:6:\"rfphcs\";s:4:\"name\";s:29:\"fr-single-product-alpha__cart\";s:8:\"settings\";a:5:{s:10:\"_cssCustom\";s:5300:\"/* Add to cart wrapper */\n.fr-single-product-alpha__cart form.cart button {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  gap: var(--product-gap);\n  margin: 0;\n}\n\n/* Add to cart Button Styling */\n.fr-single-product-alpha__cart form.cart button:not(.added_to_cart) {\n  background-color: var(--button-color);\n  border-color: var(--button-color);\n  color: var(--button-text);  \n  border-width: var(--btn-border-size);\n  border-radius: var(--btn-radius);\n  border-style: solid;  \n  min-width: var(--btn-width);\n  line-height: var(--btn-line-height);  \n  letter-spacing: var(--btn-letter-spacing);\n  text-transform: var(--btn-text-transform);\n  text-decoration: var(--btn-text-decoration);\n  font-style: var(--btn-text-style);\n  font-weight: var(--btn-weight);\n  padding: var(--btn-pad-y) var(--btn-pad-x);\n}\n\n.fr-single-product-alpha__cart form.cart button:hover:not(.added_to_cart)  {\n  background-color: var(--button-color-hover);\n  border-color: var(--button-color-hover);\n  color: var(--button-text-hover);   \n}\n\n/* Added label */\n.fr-single-product-alpha__cart .added_to_cart {\n  align-self: center;\n  height: auto;\n  padding: 0;  \n}\n\n/* Add to Cart with no Variation */\n.fr-single-product-alpha__cart form.cart:not(.variations_form),\n/* Add to Cart with Variation */\n.fr-single-product-alpha__cart form.cart .woocommerce-variation-add-to-cart{\n  display: flex;\n  flex-direction: row;\n  gap: var(--product-gap);\n}\n\n/* Add to Cart Wrapper with Variation */\n.fr-single-product-alpha__cart form.variations_form:not(.cart) {\n  display: flex;\n  flex-direction: column;\n  gap: var(--product-gap);\n}\n\n.fr-single-product-alpha__cart form.cart,\n.fr-single-product-alpha__cart .single_variation_wrap {\n  display: flex;\n  flex-direction: column;\n  gap: var(--product-gap);\n}\n\n/* Remove default margin-bottom styling */\n.fr-single-product-alpha__cart form.cart .woocommerce-variation,\n.fr-single-product-alpha__cart form.cart table.variations {\n  margin: 0;\n}\n\n/* Quantity Styling */\n.fr-single-product-alpha__cart form.cart .quantity {\n  margin: 0;\n  border-color: var(--button-color);\n  border-width: var(--btn-border-size);\n  border-radius: var(--btn-radius);\n  border-style: solid;\n  width: var(--quantity-width);\n  line-height: var(--btn-line-height);  \n  letter-spacing: var(--btn-letter-spacing);\n  text-transform: var(--btn-text-transform);\n  text-decoration: var(--btn-text-decoration);\n  font-style: var(--btn-text-style);\n  font-weight: var(--btn-weight);\n}\n\n/* Remove default border of Quantity */\n.fr-single-product-alpha__cart form.cart .quantity .action,\n.fr-single-product-alpha__cart form.cart .quantity input {\n  border: 0;\n}\n\n/* Icons Quantity */\n.fr-single-product-alpha__cart form.cart .quantity .minus svg,\n.fr-single-product-alpha__cart form.cart .quantity .plus svg {\n  height: 1.5em;\n  width: 1.5em;\n}\n\n/* Remove Quantity when out of stock */\n.fr-single-product-alpha__cart[data-woo-stock=\"1\"] > form > .quantity {\n	display: none;\n}\n\n/* Variation Table */\n.fr-single-product-alpha__cart table.variations tr {\n  display: grid;\n  grid-template-columns: var(--grid-12);\n  grid-template-rows: var(--grid-1);\n  align-items: center;\n  gap: var(--product-gap);\n  border-color: var(--border-color);\n  border-top-width: 0!important;\n  border-bottom-width: 0!important;\n  padding-block: var(--product-gap) 0;  \n}\n\n.fr-single-product-alpha__cart table.variations tr:first-child {\n  border-top-width: var(--border-width)!important;\n}\n.fr-single-product-alpha__cart table.variations tr:last-child {\n  border-bottom-width: var(--border-width)!important;\n  padding-block: var(--product-gap);   \n}\n\n.fr-single-product-alpha__cart table.variations th {\n  grid-column: span var(--variation-span);\n}\n\n/* Variation <td> */\n.fr-single-product-alpha__cart table.variations tr td {\n  display: grid;\n  grid-template-columns: var(--grid-3-1);\n  grid-template-rows: var(--grid-1);  \n  align-items: center;\n  gap: var(--product-gap);\n  grid-column: span calc(12 - var(--variation-span));  \n  width: 100%;\n  margin: 0;\n  padding-block: 0;\n}\n\n/* Variation select */\n.fr-single-product-alpha__cart td.value select {\n  border-color: var(--btn-border-color);\n  border-width: var(--btn-border-size);\n  border-radius: var(--btn-border-radius);\n  border-style: var(--btn-border-style);  \n  line-height: var(--btn-line-height);  \n  letter-spacing: var(--btn-letter-spacing);\n  text-transform: var(--btn-text-transform);\n  text-decoration: var(--btn-text-decoration);\n  font-style: var(--btn-font-style);\n  font-weight: var(--btn-font-weight);\n  padding: var(--btn-padding-inline) var(--btn-padding-block);\n}\n\n/* Variation Label */\n.fr-single-product-alpha__cart table.variations label {\n  margin: 0;\n  color: var(--variation-label-color);\n}\n\n/* Vartiation Price Styling */\n.fr-single-product-alpha__cart .woocommerce-variation-price {\n  font-size: var(--price-font-size);\n}\n.fr-single-product-alpha__cart .woocommerce-variation-price ins {\n  color: var(--price-color);\n  text-decoration: none;\n}\n.fr-single-product-alpha__cart .woocommerce-variation-price del {\n  color: var(--canceled-price-color);\n}\n\n/* Google Pay/ Apple Pay fix */\n.fr-single-product-alpha__cart {\n	max-width: max-content;\n}\n\n.fr-single-product-alpha__cart .wcpay-payment-request-wrapper {\n  margin-block-start: var(--product-gap);\n}\";s:26:\"_cssCustom:mobile_portrait\";s:411:\".fr-single-product-alpha__cart form.cart:not(.variations_form), \n.fr-single-product-alpha__cart form.cart .woocommerce-variation-add-to-cart {\n  display: flex;\n  flex-direction: column;\n  gap: var(--product-gap);\n}\n\n.fr-single-product-alpha__cart form.cart .quantity {\n  width: 100%;\n}\n\n.fr-single-product-alpha__cart table.variations tr {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\";s:8:\"_display\";s:4:\"flex\";s:14:\"_flexDirection\";s:6:\"column\";s:4:\"_gap\";s:4:\".5em\";}}i:2437;a:3:{s:2:\"id\";s:6:\"tyvpuz\";s:4:\"name\";s:29:\"fr-single-product-alpha__desc\";s:8:\"settings\";a:0:{}}i:2438;a:3:{s:2:\"id\";s:6:\"rahjyu\";s:4:\"name\";s:29:\"fr-single-product-alpha__head\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:28:\"calc(var(--content-gap) / 2)\";}}i:2439;a:3:{s:2:\"id\";s:6:\"xsfwwv\";s:4:\"name\";s:30:\"fr-single-product-alpha__price\";s:8:\"settings\";a:3:{s:22:\"regularPriceTypography\";a:2:{s:9:\"font-size\";s:22:\"var(--price-font-size)\";s:5:\"color\";a:1:{s:3:\"raw\";s:18:\"var(--price-color)\";}}s:19:\"salePriceTypography\";a:1:{s:9:\"font-size\";s:22:\"var(--price-font-size)\";}s:10:\"_cssCustom\";s:155:\".fr-single-product-alpha__price p,\n.fr-single-product-alpha__cart span.price {\n	display: flex;\n  flex-direction: row;\n  align-items: center;\n  gap: .5em;\n}\";}}i:2440;a:3:{s:2:\"id\";s:6:\"ivctea\";s:4:\"name\";s:32:\"fr-single-product-alpha__gallery\";s:8:\"settings\";a:3:{s:9:\"_position\";s:6:\"sticky\";s:4:\"_top\";s:20:\"var(--header-height)\";s:10:\"_cssCustom\";s:327:\".fr-single-product-alpha__gallery .woocommerce-product-gallery__image img {\n  aspect-ratio: var(--img-gallery-ratio);\n  object-fit: cover;  \n}\n\n.fr-single-product-alpha__gallery .flex-viewport,\n.fr-single-product-alpha__gallery .woocommerce-product-gallery li {\n  border-radius: var(--img-gallery-radius);\n  overflow: hidden;\n}\";}}i:2441;a:3:{s:2:\"id\";s:6:\"bgflsn\";s:4:\"name\";s:40:\"fr-single-product-alpha__gallery-wrapper\";s:8:\"settings\";a:1:{s:6:\"_order\";s:2:\"-1\";}}i:2442;a:3:{s:2:\"id\";s:6:\"bbxymr\";s:4:\"name\";s:22:\"fr-cart-alpha__section\";s:8:\"settings\";a:2:{s:7:\"_rowGap\";s:20:\"var(--container-gap)\";s:10:\"_cssCustom\";s:48:\".woocommerce-cart .woocommerce {\n  padding: 0;\n}\";}}i:2443;a:3:{s:2:\"id\";s:6:\"fbdwvz\";s:4:\"name\";s:13:\"fr-cart-alpha\";s:8:\"settings\";a:7:{s:8:\"_display\";s:4:\"grid\";s:8:\"_gridGap\";s:23:\"calc(var(--grid-gap)*2)\";s:20:\"_gridTemplateColumns\";s:14:\"var(--grid-12)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:24:\"_display:tablet_portrait\";s:4:\"flex\";s:26:\"_direction:tablet_portrait\";s:6:\"column\";}}i:2444;a:3:{s:2:\"id\";s:6:\"xprltn\";s:4:\"name\";s:21:\"woocommerce-cart-form\";s:8:\"settings\";a:0:{}}i:2445;a:3:{s:2:\"id\";s:6:\"bokkpy\";s:4:\"name\";s:19:\"fr-cart-alpha__main\";s:8:\"settings\";a:4:{s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:23:\"calc(var(--grid-gap)*2)\";s:11:\"_alignItems\";s:8:\"flex-end\";s:19:\"_gridItemColumnSpan\";s:3:\"1/9\";}}i:2446;a:3:{s:2:\"id\";s:6:\"qdjaye\";s:4:\"name\";s:19:\"fr-cart-alpha__cart\";s:8:\"settings\";a:11:{s:10:\"_cssCustom\";s:221:\".fr-cart-alpha__cart:not(:last-child)::after {\n  content: \'\';\n  position: absolute;\n  inset-block-end: calc((var(--grid-gap) * -1) / 2);\n  background-color: var(--shade-light);\n  block-size: 0.05em;\n  inline-size: 100%;\n}\";s:9:\"_position\";s:8:\"relative\";s:8:\"_display\";s:4:\"grid\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:15:\"_alignItemsGrid\";s:6:\"center\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:17:\"_justifyItemsGrid\";s:6:\"center\";s:36:\"_gridTemplateColumns:mobile_portrait\";s:13:\"var(--grid-1)\";s:25:\"_display:mobile_landscape\";s:4:\"flex\";s:27:\"_direction:mobile_landscape\";s:6:\"column\";}}i:2447;a:3:{s:2:\"id\";s:6:\"hflmvs\";s:4:\"name\";s:22:\"fr-cart-alpha__product\";s:8:\"settings\";a:7:{s:11:\"_alignItems\";s:6:\"center\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:3:\"row\";s:10:\"_columnGap\";s:3:\"1em\";s:26:\"_flexWrap:mobile_landscape\";s:6:\"nowrap\";s:7:\"_rowGap\";s:3:\"1em\";s:15:\"_justifyContent\";s:10:\"flex-start\";}}i:2448;a:3:{s:2:\"id\";s:6:\"jzuglv\";s:4:\"name\";s:28:\"fr-cart-alpha__product-image\";s:8:\"settings\";a:3:{s:10:\"_objectFit\";s:7:\"contain\";s:10:\"_cssCustom\";s:51:\".fr-cart-alpha__product-image {\n	aspect-ratio: 1;\n}\";s:6:\"_width\";s:3:\"6em\";}}i:2449;a:3:{s:2:\"id\";s:6:\"sdorlr\";s:4:\"name\";s:27:\"fr-cart-alpha__product-name\";s:8:\"settings\";a:2:{s:11:\"_typography\";a:2:{s:9:\"font-size\";s:9:\"var(--h3)\";s:11:\"line-height\";s:1:\"1\";}s:7:\"_margin\";a:1:{s:3:\"top\";s:11:\"0!important\";}}}i:2450;a:3:{s:2:\"id\";s:6:\"krsmps\";s:4:\"name\";s:27:\"fr-cart-alpha__product-desc\";s:8:\"settings\";a:2:{s:6:\"_width\";s:4:\"100%\";s:10:\"_cssCustom\";s:54:\".fr-cart-alpha__product-desc {\n	grid-column: span 2;\n}\";}}i:2451;a:3:{s:2:\"id\";s:6:\"sdmhcq\";s:4:\"name\";s:28:\"fr-cart-alpha__price-wrapper\";s:8:\"settings\";a:8:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:3:\"row\";s:11:\"_alignItems\";s:6:\"center\";s:10:\"_columnGap\";s:4:\".5em\";s:7:\"_rowGap\";s:4:\".5em\";s:15:\"_justifyContent\";s:12:\"space-around\";s:32:\"_justifyContent:mobile_landscape\";s:13:\"space-between\";s:26:\"_flexWrap:mobile_landscape\";s:6:\"nowrap\";}}i:2452;a:3:{s:2:\"id\";s:6:\"peyeal\";s:4:\"name\";s:20:\"fr-cart-alpha__price\";s:8:\"settings\";a:0:{}}i:2453;a:3:{s:2:\"id\";s:6:\"stmmxx\";s:4:\"name\";s:23:\"fr-cart-alpha__quantity\";s:8:\"settings\";a:2:{s:10:\"_cssCustom\";s:429:\".fr-cart-alpha__quantity {\n	grid-column: 9/11;\n}\n\n.fr-cart-alpha__quantity .quantity {\n	margin: 0!important;\n  inline-size: 100%!important;\n  border-style: solid;  \n  border-width: var(--btn-border-size)!important;\n  border-radius: var(--btn-radius)!important;\n}\n\n.fr-cart-alpha__quantity .minus, .fr-cart-alpha__quantity .plus, .fr-cart-alpha__quantity input {\n  border-style: none!important;\n  border-width: unset!important;	\n}\";s:6:\"_width\";s:3:\"5em\";}}i:2454;a:3:{s:2:\"id\";s:6:\"qlfnpd\";s:4:\"name\";s:23:\"fr-cart-alpha__subtotal\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:9:\"font-size\";s:13:\"var(--text-l)\";}}}i:2455;a:3:{s:2:\"id\";s:6:\"quhbaj\";s:4:\"name\";s:26:\"fr-cart-alpha__remove-link\";s:8:\"settings\";a:2:{s:11:\"_typography\";a:2:{s:11:\"line-height\";s:1:\"1\";s:9:\"font-size\";s:14:\"var(--text-xl)\";}s:10:\"_cssCustom\";s:57:\".fr-cart-alpha__remove-link a {\n	text-decoration: none;\n}\";}}i:2456;a:3:{s:2:\"id\";s:6:\"iohssy\";s:4:\"name\";s:25:\"fr-cart-alpha__update-btn\";s:8:\"settings\";a:1:{s:10:\"_cssCustom\";s:1059:\".fr-cart-alpha__update-btn { \n	--button-color: 			var(--action);\n  --button-color-hover: var(--action-hover);  \n  --button-text: 				var(--fr-text-light);  \n  --button-text-hover: 	var(--fr-text-light);  \n}\n\n/* Button Styling */\n.fr-cart-alpha__update-btn .button {\n	inline-size: 100%;\n	background-color: var(--button-color);\n  border-color: var(--button-color);\n  border-style: solid;  \n	color: var(--button-text);  \n  border-width: var(--btn-border-size);\n  border-radius: var(--btn-radius);\n  min-inline-size: var(--btn-width);\n  line-height: var(--btn-line-height)!important;  \n  letter-spacing: var(--btn-letter-spacing);\n  text-transform: var(--btn-text-transform);\n  text-decoration: var(--btn-text-decoration);\n	font-style: var(--btn-text-style);\n  font-weight: var(--btn-weight);\n  padding: var(--btn-pad-y) var(--btn-pad-x);\n  text-align: center;  \n}\n\n/* Button Hover Styling */\n.fr-cart-alpha__update-btn .button:hover {\n	background-color: var(--button-color-hover);\n  border-color: var(--button-color-hover);\n	color: var(--button-text-hover);   \n}\";}}i:2457;a:3:{s:2:\"id\";s:6:\"nczuur\";s:4:\"name\";s:29:\"fr-cart-alpha__totals-wrapper\";s:8:\"settings\";a:8:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:8:\"_padding\";a:4:{s:3:\"top\";s:14:\"var(--space-m)\";s:5:\"right\";s:14:\"var(--space-m)\";s:6:\"bottom\";s:14:\"var(--space-m)\";s:4:\"left\";s:14:\"var(--space-m)\";}s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:24:\"var(--btn-border-radius)\";s:5:\"right\";s:24:\"var(--btn-border-radius)\";s:6:\"bottom\";s:24:\"var(--btn-border-radius)\";s:4:\"left\";s:24:\"var(--btn-border-radius)\";}}s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:26:\"var(--neutral-ultra-light)\";}}s:35:\"_gridItemColumnSpan:tablet_portrait\";s:5:\"unset\";s:19:\"_gridItemColumnSpan\";s:5:\"9/end\";}}i:2458;a:3:{s:2:\"id\";s:6:\"ftrhom\";s:4:\"name\";s:28:\"fr-cart-alpha__totals-sticky\";s:8:\"settings\";a:5:{s:9:\"_position\";s:6:\"sticky\";s:4:\"_top\";s:20:\"var(--header-height)\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:27:\"_alignItems:tablet_portrait\";s:8:\"flex-end\";s:27:\"_typography:tablet_portrait\";a:1:{s:10:\"text-align\";s:5:\"right\";}}}i:2459;a:3:{s:2:\"id\";s:6:\"cctbpl\";s:4:\"name\";s:23:\"fr-cart-alpha__discount\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:10:\"_columnGap\";s:4:\".5em\";s:7:\"_rowGap\";s:4:\".5em\";s:27:\"_alignItems:tablet_portrait\";s:8:\"flex-end\";s:27:\"_alignItems:mobile_portrait\";s:10:\"flex-start\";}}i:2460;a:3:{s:2:\"id\";s:6:\"gzdtwz\";s:4:\"name\";s:31:\"fr-cart-alpha__discount-heading\";s:8:\"settings\";a:0:{}}i:2461;a:3:{s:2:\"id\";s:6:\"gafujl\";s:4:\"name\";s:21:\"fr-cart-alpha__coupon\";s:8:\"settings\";a:2:{s:10:\"_cssCustom\";s:1430:\".fr-cart-alpha__coupon {\n	--button-color: 			var(--action);\n  --button-color-hover: var(--action-hover);  \n  --button-text: 				var(--fr-text-light);  \n  --button-text-hover: 	var(--fr-text-light);\n}\n\n.fr-cart-alpha__coupon .coupon {\n	flex-wrap: nowrap;\n  align-items: unset!important;\n  gap: var(--space-xs);\n}\n\n.fr-cart-alpha__coupon .coupon input {\n  inline-size: 100%;\n  border-width: var(--btn-border-size);\n  border-radius: var(--btn-radius);\n  border-style: solid;  \n  padding: var(--btn-pad-y) var(--btn-pad-x);\n  line-height: var(--btn-line-height)!important;\n}\n\n/* Button Styling */\n.fr-cart-alpha__coupon .coupon button {\n	inline-size: 100%;\n	background-color: var(--button-color)!important;\n  border-color: var(--button-color)!important;\n	color: var(--button-text);  \n  border-width: var(--btn-border-size);\n  border-radius: var(--btn-radius);\n  border-style: solid;\n  line-height: var(--btn-line-height)!important;  \n  letter-spacing: var(--btn-letter-spacing);\n  text-transform: var(--btn-text-transform);\n  text-decoration: var(--btn-text-decoration);\n	font-style: var(--btn-text-style);\n  font-weight: var(--btn-weight);\n  padding: var(--btn-pad-y) var(--btn-pad-x);\n  text-align: center;  \n}\n\n/* Button Hover Styling */\n.fr-cart-alpha__coupon .coupon button:hover {\n	background-color: var(--button-color-hover)!important;\n  border-color: var(--button-color-hover)!important;\n	color: var(--button-text-hover);   \n}\";s:26:\"_cssCustom:mobile_portrait\";s:149:\".fr-cart-alpha__coupon .coupon {\n	flex-wrap: wrap;\n	justify-items: flex-end;\n}\n\n.fr-cart-alpha__coupon .coupon button[type=submit] {\n  width: 100%;\n}\";}}i:2462;a:3:{s:2:\"id\";s:6:\"kzbvwn\";s:4:\"name\";s:31:\"fr-cart-alpha__discount-message\";s:8:\"settings\";a:0:{}}i:2463;a:3:{s:2:\"id\";s:6:\"wtlrch\";s:4:\"name\";s:21:\"fr-cart-alpha__totals\";s:8:\"settings\";a:4:{s:9:\"hideTitle\";b:1;s:10:\"_cssCustom\";s:2346:\".fr-cart-alpha__totals {\n  /* Font size for total number */\n  --total-font-size: 		var(--text-l);\n  /* Font size for subtotal number */\n  --subtotal-font-size: var(--text-m);  \n  /* Button styling for main checkout button */\n  --button-color: 			var(--action);\n  --button-color-hover: var(--action-hover);  \n  --button-text: 				var(--fr-text-light);  \n  --button-text-hover: 	var(--fr-text-light);  \n}\n\n.fr-cart-alpha__totals .cart-subtotal span.woocommerce-Price-amount,\n.fr-cart-alpha__totals .order-total span.woocommerce-Price-amount {\n  inline-size: 100%;\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n\n.fr-cart-alpha__totals .cart-discount td {\n  display: flex;\n  flex-direction: row;\n  gap: 0.5em;\n  justify-content: flex-end;	\n}\n\n.fr-cart-alpha__totals .shipping td {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n  text-align: right;\n}\n\n.fr-cart-alpha__totals .cart-subtotal span.woocommerce-Price-amount::before {\n  content: \'\';\n  font-size: var(--subtotal-font-size);\n}\n\n.fr-cart-alpha__totals .order-total span.woocommerce-Price-amount::before {\n  content: \'\';\n  font-size: var(--total-font-size);\n}\n\n/* Tax */\n.fr-cart-alpha__totals .order-total td {\n  display: flex;\n  flex-direction: row;\n  gap: .5em;\n  justify-content: flex-end;  \n}\n.fr-cart-alpha__totals .order-total td small {\n  display: flex;\n  flex-direction: row;\n  gap: .25em;\n  justify-content: flex-end;  \n}\n\n/* Button Styling */\n.fr-cart-alpha__totals .button {\n  inline-size: 100%;\n  background-color: var(--button-color);\n  border-color: var(--button-color);\n  color: var(--button-text);  \n  border-width: var(--btn-border-size);\n  border-radius: var(--btn-radius);\n  border-style: solid;  \n  font-size: var(--text-m)!important;\n  min-inline-size: var(--btn-width);\n  line-height: var(--btn-line-height)!important;  \n  letter-spacing: var(--btn-letter-spacing);\n  text-transform: var(--btn-text-transform);\n  text-decoration: var(--btn-text-decoration)!important;\n  font-style: var(--btn-text-style);\n  font-weight: var(--btn-weight);\n  padding: var(--btn-pad-y) var(--btn-pad-x)!important;\n  text-align: center;  \n}\n\n/* Button Hover Styling */\n.fr-cart-alpha__totals .button:hover {\n  background-color: var(--button-color-hover);\n  border-color: var(--button-color-hover);\n  color: var(--button-text-hover);   \n}\n\";s:15:\"totalTypography\";a:1:{s:9:\"font-size\";s:32:\"var(--total-font-size)!important\";}s:18:\"subtotalTypography\";a:1:{s:9:\"font-size\";s:25:\"var(--subtotal-font-size)\";}}}i:2464;a:3:{s:2:\"id\";s:6:\"znxnjs\";s:4:\"name\";s:19:\"fr-woo-notice-alpha\";s:8:\"settings\";a:43:{s:21:\"noticeBackgroundColor\";a:1:{s:3:\"raw\";s:19:\"var(--notice-color)\";}s:16:\"noticeTypography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:12:\"var(--white)\";}}s:12:\"noticeBorder\";a:1:{s:6:\"radius\";a:4:{s:5:\"right\";s:24:\"var(--btn-border-radius)\";s:6:\"bottom\";s:24:\"var(--btn-border-radius)\";s:4:\"left\";s:24:\"var(--btn-border-radius)\";s:3:\"top\";s:24:\"var(--btn-border-radius)\";}}s:13:\"noticePadding\";a:4:{s:3:\"top\";s:24:\"var(--btn-padding-block)\";s:6:\"bottom\";s:24:\"var(--btn-padding-block)\";s:5:\"right\";s:25:\"var(--btn-padding-inline)\";s:4:\"left\";s:25:\"var(--btn-padding-inline)\";}s:14:\"successPadding\";a:4:{s:3:\"top\";s:24:\"var(--btn-padding-block)\";s:6:\"bottom\";s:24:\"var(--btn-padding-block)\";s:4:\"left\";s:25:\"var(--btn-padding-inline)\";s:5:\"right\";s:25:\"var(--btn-padding-inline)\";}s:22:\"successBackgroundColor\";a:1:{s:3:\"raw\";s:20:\"var(--success-color)\";}s:13:\"successBorder\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:17:\"var(--btn-radius)\";s:5:\"right\";s:17:\"var(--btn-radius)\";s:6:\"bottom\";s:17:\"var(--btn-radius)\";s:4:\"left\";s:17:\"var(--btn-radius)\";}}s:17:\"successTypography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--text-color)\";}}s:20:\"errorBackgroundColor\";a:1:{s:3:\"raw\";s:18:\"var(--error-color)\";}s:15:\"errorTypography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--text-color)\";}}s:11:\"errorBorder\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:17:\"var(--btn-radius)\";s:5:\"right\";s:17:\"var(--btn-radius)\";s:6:\"bottom\";s:17:\"var(--btn-radius)\";s:4:\"left\";s:17:\"var(--btn-radius)\";}}s:12:\"errorPadding\";a:4:{s:3:\"top\";s:24:\"var(--btn-padding-block)\";s:6:\"bottom\";s:24:\"var(--btn-padding-block)\";s:4:\"left\";s:25:\"var(--btn-padding-inline)\";s:5:\"right\";s:25:\"var(--btn-padding-inline)\";}s:16:\"errorLinkPadding\";a:4:{s:3:\"top\";s:24:\"var(--btn-padding-block)\";s:5:\"right\";s:25:\"var(--btn-padding-inline)\";s:4:\"left\";s:25:\"var(--btn-padding-inline)\";s:6:\"bottom\";s:24:\"var(--btn-padding-block)\";}s:15:\"errorLinkBorder\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:17:\"var(--btn-radius)\";s:5:\"right\";s:17:\"var(--btn-radius)\";s:6:\"bottom\";s:17:\"var(--btn-radius)\";s:4:\"left\";s:17:\"var(--btn-radius)\";}}s:18:\"successLinkPadding\";a:4:{s:3:\"top\";s:24:\"var(--btn-padding-block)\";s:4:\"left\";s:25:\"var(--btn-padding-inline)\";s:5:\"right\";s:25:\"var(--btn-padding-inline)\";s:6:\"bottom\";s:24:\"var(--btn-padding-block)\";}s:17:\"successLinkBorder\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:17:\"var(--btn-radius)\";s:5:\"right\";s:17:\"var(--btn-radius)\";s:6:\"bottom\";s:17:\"var(--btn-radius)\";s:4:\"left\";s:17:\"var(--btn-radius)\";}}s:16:\"noticeLinkBorder\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:17:\"var(--btn-radius)\";s:5:\"right\";s:17:\"var(--btn-radius)\";s:6:\"bottom\";s:17:\"var(--btn-radius)\";s:4:\"left\";s:17:\"var(--btn-radius)\";}}s:17:\"noticeLinkPadding\";a:4:{s:3:\"top\";s:24:\"var(--btn-padding-block)\";s:6:\"bottom\";s:24:\"var(--btn-padding-block)\";s:4:\"left\";s:25:\"var(--btn-padding-inline)\";s:5:\"right\";s:25:\"var(--btn-padding-inline)\";}s:26:\"successLinkBackgroundColor\";a:1:{s:3:\"raw\";s:19:\"var(--button-color)\";}s:25:\"noticeLinkBackgroundColor\";a:1:{s:3:\"raw\";s:19:\"var(--button-color)\";}s:24:\"errorLinkBackgroundColor\";a:1:{s:3:\"raw\";s:19:\"var(--button-color)\";}s:19:\"errorLinkTypography\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:18:\"var(--button-text)\";}s:15:\"text-decoration\";s:4:\"none\";}s:20:\"noticeLinkTypography\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:18:\"var(--button-text)\";}s:15:\"text-decoration\";s:4:\"none\";}s:10:\"_cssCustom\";s:404:\".fr-woo-notice-alpha {\n	--notice-color: var(--info);\n  --error-color: var(--danger);\n  --success-color: var(--success);\n  --text-color: var(--text-light);\n  --button-color: var(--neutral-trans-40);\n  --button-hover-color: var(--neutral-trans-60);\n  --button-text: var(--text-light);\n  --button-hover-text: var(--text-light);\n  --shadow: var(--box-shadow-m);\n}\n\n.fr-woo-notice-alpha a {\n	border-left: 0;\n}\";s:30:\"errorLinkBackgroundColor:hover\";a:1:{s:3:\"raw\";s:25:\"var(--button-hover-color)\";}s:32:\"successLinkBackgroundColor:hover\";a:1:{s:3:\"raw\";s:25:\"var(--button-hover-color)\";}s:31:\"noticeLinkBackgroundColor:hover\";a:1:{s:3:\"raw\";s:25:\"var(--button-hover-color)\";}s:21:\"successLinkTypography\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:18:\"var(--button-text)\";}s:15:\"text-decoration\";s:4:\"none\";}s:26:\"noticeLinkTypography:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:24:\"var(--button-hover-text)\";}}s:27:\"successLinkTypography:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:24:\"var(--button-hover-text)\";}}s:25:\"errorLinkTypography:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:24:\"var(--button-hover-text)\";}}s:15:\"errorLinkMargin\";a:1:{s:4:\"left\";s:1:\"0\";}s:16:\"noticeLinkMargin\";a:1:{s:4:\"left\";s:1:\"0\";}s:17:\"successLinkMargin\";a:1:{s:4:\"left\";s:1:\"0\";}s:9:\"_position\";s:5:\"fixed\";s:7:\"_bottom\";s:14:\"var(--space-l)\";s:9:\"_widthMax\";s:14:\"var(--width-l)\";s:5:\"_left\";s:3:\"50%\";s:14:\"errorBoxShadow\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:13:\"var(--shadow)\";}}s:15:\"noticeBoxShadow\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:13:\"var(--shadow)\";}}s:16:\"successBoxShadow\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:13:\"var(--shadow)\";}}s:7:\"_zIndex\";s:1:\"1\";s:10:\"_transform\";a:1:{s:10:\"translateX\";s:4:\"-50%\";}}}i:2465;a:3:{s:2:\"id\";s:6:\"pavhmq\";s:4:\"name\";s:17:\"fr-checkout-alpha\";s:8:\"settings\";a:2:{s:10:\"_cssCustom\";s:1158:\".fr-checkout-alpha {\n  /* Customer Details Styling */   \n  --f-size-label: var(--text-s);\n  --f-weight-label: 400;\n  \n  /* Input Styling */\n  --input-gap: var(--fr-card-gap);\n	--input-bg-color: var(--neutral-ultra-light);\n	--input-bg-color-hover: var(--neutral-trans-10);\n	--input-text-color: var(--fr-text-dark);\n	--input-text-color-hover: var(--fr-text-dark);\n	--input-placeholder-color: var(--neutral-trans-40);\n\n  /* Order Review Styling */  \n	--review-bg-color: var(--fr-bg-light);\n	--review-text-color: var(--fr-text-dark);\n	--review-radius: var(--fr-card-radius);  \n  --review-shadow: var(--box-shadow-m);\n  --order-gap: var(--fr-card-gap); \n  --section-gap: var(--content-gap);    \n  --product-qty-weight: 400; /* default bold */\n  \n  /* Payment Box Styling */\n	--pay-box-bg: var(--neutral-light);\n	--pay-box-text-color: var(--fr-text-dark);  \n	--pay-box-radius: var(--fr-card-radius);\n\n  /* Button Styling */\n  --button-color: 			var(--action);\n  --button-color-hover: var(--action-hover);  \n  --button-text: 				var(--fr-text-light);  \n  --button-text-hover: 	var(--fr-text-light);\n  --button-font-size:		var(--text-m);\n  --button-width:				100%;\n}\";s:7:\"_rowGap\";s:20:\"var(--container-gap)\";}}i:2466;a:3:{s:2:\"id\";s:6:\"jryvog\";s:4:\"name\";s:23:\"fr-checkout-alpha__grid\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"grid\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";}}i:2467;a:3:{s:2:\"id\";s:6:\"uqwkur\";s:4:\"name\";s:35:\"fr-checkout-alpha__customer-details\";s:8:\"settings\";a:3:{s:10:\"_cssCustom\";s:2744:\".fr-checkout-alpha__customer-details .woocommerce-billing-fields,\n.fr-checkout-alpha__customer-details .woocommerce-additional-fields,\n.fr-checkout-alpha__customer-details .col-2 {\n  display: flex;\n  flex-direction: column;\n	gap: var(--input-gap);\n  margin: 0!important;\n}\n\n.fr-checkout-alpha__customer-details .woocommerce-shipping-fields,\n.fr-checkout-alpha__customer-details .col2-set {\n  display: flex;\n  flex-direction: column;  \n  margin: 0!important;\n  gap: var(--section-gap);\n}\n\n.fr-checkout-alpha__customer-details .woocommerce-billing-fields__field-wrapper,\n.fr-checkout-alpha__customer-details .woocommerce-shipping-fields__field-wrapper {\n	display: grid;\n  grid-template-columns: var(--grid-2);\n  grid-template-rows: var(--grid-1);\n  gap: var(--input-gap);\n}\n\n.fr-checkout-alpha__customer-details p.form-row {\n    width: 100%!important;\n}\n\n.fr-checkout-alpha__customer-details label {\n  font-size: var(--f-size-label);\n  font-weight: var(--f-weight-label);\n  letter-spacing: 0;\n}\n\n.fr-checkout-alpha__customer-details .woocommerce-form__label-for-checkbox {\n	font-size: var(--h3)!important;\n  font-weight: 700;  \n  margin: 0!important;\n}\n\n/* ACSS Paragraph Fix */\n.fr-checkout-alpha__customer-details .woocommerce-billing-fields__field-wrapper p,\n.fr-checkout-alpha__customer-details .woocommerce-shipping-fields__field-wrapper p {\n  margin-block: 0!important;\n}\n.fr-checkout-alpha__customer-details .woocommerce-billing-fields__field-wrapper p#billing_address_2_field,\n.fr-checkout-alpha__customer-details .woocommerce-shipping-fields__field-wrapper p#shipping_address_2_field {\n  margin-block-start: auto!important;\n}\n\n/* Input Styling */\n.fr-checkout-alpha__customer-details input,\n.fr-checkout-alpha__customer-details textarea {\n	background: var(--input-bg-color);    \n	padding: calc(var(--btn-pad-y)/2) calc(var(--btn-pad-x)/2);\n  color: var(--input-text-color);\n  border-width: var(--btn-border-size);\n  border-radius: var(--btn-radius);\n  border-style: solid;    \n  line-height: var(--btn-line-height);  \n  font-style: var(--btn-text-style);\n  font-size: var(--button-font-size);\n  font-weight: var(--btn-weight);  \n}\n\n.fr-checkout-alpha__customer-details input:hover,\n.fr-checkout-alpha__customer-details input:focus,\n.fr-checkout-alpha__customer-details textarea:hover,\n.fr-checkout-alpha__customer-details textarea:focus {\n	background: var(--input-bg-color-hover);\n  color: var(--input-text-color-hover);  \n}\n.fr-checkout-alpha__customer-details input::placeholder {\n	color: var(--input-placeholder-color);\n}\n.fr-checkout-alpha__customer-details textarea::placeholder {\n	color: var(--input-placeholder-color);\n}\n/* asterisk Styling */\n.fr-checkout-alpha__customer-details abbr[title] {\n	text-decoration: none!important;\n}\";s:26:\"_cssCustom:tablet_portrait\";s:205:\".fr-checkout-alpha__customer-details .woocommerce-billing-fields__field-wrapper,\n.fr-checkout-alpha__customer-details .woocommerce-shipping-fields__field-wrapper {\n  grid-template-columns: var(--grid-1);\n}\";s:26:\"_cssCustom:mobile_portrait\";s:205:\".fr-checkout-alpha__customer-details .woocommerce-billing-fields__field-wrapper,\n.fr-checkout-alpha__customer-details .woocommerce-shipping-fields__field-wrapper {\n  grid-template-columns: var(--grid-1);\n}\";}}i:2468;a:3:{s:2:\"id\";s:6:\"yvlmct\";s:4:\"name\";s:31:\"fr-checkout-alpha__order-review\";s:8:\"settings\";a:7:{s:10:\"_cssCustom\";s:4281:\".fr-checkout-alpha__order-review {\n  background-color: var(--review-bg-color);\n	color: var(--review-text-color)  ;\n	border-radius: var(--review-radius);\n  height: max-content;\n}\n.fr-checkout-alpha__order-review #order_review {\n	display: flex;\n  flex-direction: column;\n  border-style: none;    \n}\n/* Allows you to determine the width of the button. */\n.fr-checkout-alpha__order-review .place-order {\n  align-items: start;\n}\n/* Button Styling */\n.fr-checkout-alpha__order-review .place-order button {\n  background-color: var(--button-color);\n  border-color: var(--button-color);\n  color: var(--button-text);  \n  border-width: var(--btn-border-size);\n  border-radius: var(--btn-radius);\n  border-style: solid;  \n  min-inline-size: var(--btn-width);\n  width: var(--button-width);\n  line-height: var(--btn-line-height)!important;\n  letter-spacing: var(--btn-letter-spacing);\n  text-transform: var(--btn-text-transform);\n  text-decoration: var(--btn-text-decoration);\n  font-style: var(--btn-text-style);\n  font-size: var(--button-font-size)!important;\n  font-weight: var(--btn-weight);\n  padding: var(--btn-pad-y) var(--btn-pad-x);\n}\n/* Button Hover Styling */\n.fr-checkout-alpha__order-review .place-order button:hover {\n	background-color: var(--button-color-hover);\n  border-color: var(--button-color-hover);\n	color: var(--button-text-hover);   \n}\n\n/* Order Table */\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order-table th,\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order-table td {\n	padding: 0!important;\n}\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order,\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order-table,\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order-table tbody,\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order-table tfoot {\n	display: flex;\n  flex-direction: column;\n}\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order-table tbody,\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order-table tfoot {\n  gap: var(--order-gap);\n}\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order,\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order-table {\n  gap: var(--section-gap);\n}\n.fr-checkout-alpha__order-review .woocommerce-checkout-review-order-table tr {\n	display: grid;\n  grid-template-columns: var(--grid-3-2);\n  grid-template-rows: var(--grid-1);  \n}\n.fr-checkout-alpha__order-review .product-quantity {\n	font-weight: var(--product-qty-weight);\n}\n.fr-checkout-alpha__order-review td.product-name,\n.fr-checkout-alpha__order-review td.product-total {\n	display: flex;\n  flex-direction: row;\n  align-items: center;\n  gap: .5em\n}\n.fr-checkout-alpha__order-review td.product-name img {\n	order: -2;\n}\n.fr-checkout-alpha__order-review td.product-name strong {\n	order: -1;\n}\n.fr-checkout-alpha__order-review #payment,\n.fr-checkout-alpha__order-review .place-order {\n	display: flex;\n  flex-direction: column;  \n  gap: var(--order-gap);  \n  padding: 0!important;\n}\n\n.fr-checkout-alpha__order-review .shop_table dl.variation {\n  display: block;\n	font-size: var(--text-s);\n  margin-inline: .5em;\n}\n\n.fr-checkout-alpha__order-review .shop_table dl.variation dt {\n  clear: left;\n  float: left;\n  font-weight: bold;\n  margin-inline-end: .5em;\n}\n.fr-checkout-alpha__order-review .shop_table dl.variation dd {\n   margin-inline-start: 0;\n}\n.fr-checkout-alpha__order-review .shop_table dl.variation dd::after {\n    display: block;\n    content: \'\';\n    clear: both;\n}\n\n.fr-checkout-alpha__order-review .payment_box {\n	background-color: var(--pay-box-bg)!important;\n  color: var(--pay-box-text-color);\n  border-radius: var(--pay-box-radius);\n  margin-block: 1em; \n  font-size: var(--text-s)!important;\n  padding: var(--space-xs)!important;\n}\n.fr-checkout-alpha__order-review li.woocommerce-notice {\n  font-size: var(--text-s)!important;\n  text-align: left;\n  margin: 0!important;\n  font-size: var(--text-s)!important;\n  padding: var(--space-xs)!important;\n}\n/* Stripe Payment Styling */\n.fr-checkout-alpha__order-review .woocommerce-SavedPaymentMethods-saveNew {\n	display: flex;\n  flex-direction: row;\n  gap: .5em;\n}\n.fr-checkout-alpha__order-review li.payment_method_woocommerce_payments > label {\n	height: 3em;\n}\";s:16:\"cartItemsPadding\";a:2:{s:5:\"right\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:8:\"_padding\";a:4:{s:3:\"top\";s:14:\"var(--space-s)\";s:5:\"right\";s:14:\"var(--space-s)\";s:6:\"bottom\";s:14:\"var(--space-s)\";s:4:\"left\";s:14:\"var(--space-s)\";}s:8:\"_display\";s:4:\"flex\";s:14:\"_flexDirection\";s:6:\"column\";s:4:\"_gap\";s:18:\"var(--section-gap)\";s:10:\"_boxShadow\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:20:\"var(--review-shadow)\";}}}}i:2469;a:3:{s:2:\"id\";s:6:\"fvqatm\";s:4:\"name\";s:33:\"fr-checkout-alpha__sticky-wrapper\";s:8:\"settings\";a:0:{}}i:2470;a:3:{s:2:\"id\";s:6:\"tuoukw\";s:4:\"name\";s:25:\"fr-checkout-alpha__sticky\";s:8:\"settings\";a:5:{s:9:\"_position\";s:6:\"sticky\";s:4:\"_top\";s:20:\"var(--header-height)\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";}}i:2471;a:3:{s:2:\"id\";s:6:\"qvoslz\";s:4:\"name\";s:26:\"fr-dashboard-section-alpha\";s:8:\"settings\";a:2:{s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:20:\"var(--container-gap)\";}}i:2472;a:3:{s:2:\"id\";s:6:\"kbwkau\";s:4:\"name\";s:27:\"fr-dashboard-alpha__content\";s:8:\"settings\";a:3:{s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:27:\"_cssCustom:mobile_landscape\";s:212:\".fr-dashboard-alpha__content {\n  inline-size: 100vw !important;\n  max-inline-size: 100vw !important;\n  margin-inline: calc(-50vw + 50%) !important;\n  align-self: flex-start;\n  padding-inline: section-padding-x;\n}\";}}i:2473;a:3:{s:2:\"id\";s:6:\"zuarbb\";s:4:\"name\";s:18:\"fr-dashboard-alpha\";s:8:\"settings\";a:14:{s:10:\"_cssCustom\";s:1391:\".fr-dashboard-alpha {\n  --grid-span: 3;\n  --active-bg-color: var(--action);\n}\n\n.fr-dashboard-alpha .woocommerce {\n  display: grid;\n  grid-template-columns: var(--grid-12);\n  grid-template-rows: var(--grid-1);\n  align-items: stretch;\n}\n\n.fr-dashboard-alpha .woocommerce .woocommerce-MyAccount-navigation {\n  grid-column: span var(--grid-span);\n}\n\n.fr-dashboard-alpha .woocommerce .woocommerce-MyAccount-content {\n  grid-column: span calc(12 - var(--grid-span)); \n  border-radius: var(--fr-card-radius);\n}\n\n.fr-dashboard-alpha .woocommerce-MyAccount-navigation ul {\n  list-style-type: none;\n  border-radius: var(--fr-card-radius);  \n  margin: 0;\n  padding: 0;\n}\n\n.fr-dashboard-alpha .woocommerce-MyAccount-navigation li a {\n  display: flex;\n  letter-spacing: var(--btn-letter-spacing);\n  font-weight: var(--btn-weight)!important;\n  font-style: var(--btn-text-style);\n  min-inline-size: var(--btn-width);  \n  line-height: var(--btn-line-height);    \n  border-width: var(--btn-border-size);\n  text-transform: var(--btn-text-transform);\n  text-decoration: none;\n  justify-content: space-between;\n}\n.fr-dashboard-alpha .woocommerce-MyAccount-navigation-link.is-active a {\n	background-color: var(--active-bg-color);\n  border-color: var(--active-bg-color);\n}\n.fr-dashboard-alpha .woocommerce-MyAccount-navigation li a:hover {\n  background-color: var(--action-hover);\n  color: var(--fr-text-light);\n}\";s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:24:\"var(--shade-ultra-light)\";}}s:8:\"_padding\";a:4:{s:3:\"top\";s:14:\"var(--space-m)\";s:5:\"right\";s:14:\"var(--space-m)\";s:6:\"bottom\";s:14:\"var(--space-m)\";s:4:\"left\";s:14:\"var(--space-m)\";}s:10:\"_boxShadow\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:19:\"var(--box-shadow-m)\";}}s:26:\"_cssCustom:tablet_portrait\";s:78:\".fr-dashboard-alpha .woocommerce {\n  display: flex;\n	flex-direction: column;\n}\";s:25:\"_padding:mobile_landscape\";a:2:{s:4:\"left\";s:24:\"var(--section-padding-x)\";s:5:\"right\";s:24:\"var(--section-padding-x)\";}s:3:\"gap\";s:25:\"calc(var(--grid-gap) * 2)\";s:14:\"navItemPadding\";a:4:{s:4:\"left\";s:16:\"var(--btn-pad-x)\";s:5:\"right\";s:16:\"var(--btn-pad-x)\";s:3:\"top\";s:16:\"var(--btn-pad-y)\";s:6:\"bottom\";s:16:\"var(--btn-pad-y)\";}s:17:\"navItemBackground\";a:1:{s:3:\"raw\";s:13:\"var(--action)\";}s:16:\"navItemTypogaphy\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:20:\"var(--fr-text-light)\";}s:11:\"line-height\";s:1:\"1\";}s:13:\"navItemBorder\";a:3:{s:6:\"radius\";a:4:{s:3:\"top\";s:17:\"var(--btn-radius)\";s:5:\"right\";s:17:\"var(--btn-radius)\";s:6:\"bottom\";s:17:\"var(--btn-radius)\";s:4:\"left\";s:17:\"var(--btn-radius)\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";a:1:{s:3:\"raw\";s:13:\"var(--action)\";}}s:6:\"navGap\";s:4:\".1em\";s:28:\"navDirection:tablet_portrait\";s:3:\"row\";s:9:\"direction\";s:3:\"row\";}}i:2474;a:3:{s:2:\"id\";s:6:\"ocfpyi\";s:4:\"name\";s:16:\"fr-intro-charlie\";s:8:\"settings\";a:4:{s:8:\"_display\";s:4:\"flex\";s:36:\"_gridTemplateColumns:tablet_portrait\";s:13:\"var(--grid-1)\";s:10:\"_direction\";s:3:\"row\";s:11:\"_alignItems\";s:6:\"center\";}}i:2475;a:3:{s:2:\"id\";s:6:\"dyluos\";s:4:\"name\";s:33:\"fr-intro-charlie__content-wrapper\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";}}i:2476;a:3:{s:2:\"id\";s:6:\"glrfij\";s:4:\"name\";s:25:\"fr-intro-charlie__heading\";s:8:\"settings\";a:0:{}}i:2477;a:3:{s:2:\"id\";s:6:\"ydlvhj\";s:4:\"name\";s:22:\"fr-intro-charlie__lede\";s:8:\"settings\";a:0:{}}i:2478;a:3:{s:2:\"id\";s:6:\"ekdrak\";s:4:\"name\";s:25:\"fr-intro-charlie__sidebar\";s:8:\"settings\";a:3:{s:11:\"_alignItems\";s:8:\"flex-end\";s:27:\"_alignItems:tablet_portrait\";s:10:\"flex-start\";s:15:\"_justifyContent\";s:6:\"center\";}}i:2479;a:3:{s:2:\"id\";s:6:\"zfjfik\";s:4:\"name\";s:14:\"fr-login-alpha\";s:8:\"settings\";a:3:{s:8:\"_padding\";a:4:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:24:\"_padding:tablet_portrait\";a:3:{s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:22:\"var(--section-space-m)\";}s:27:\"_background:tablet_portrait\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:26:\"var(--neutral-ultra-light)\";}}}}i:2480;a:3:{s:2:\"id\";s:6:\"mqzeou\";s:4:\"name\";s:21:\"fr-login-alpha__inner\";s:8:\"settings\";a:9:{s:10:\"_cssCustom\";s:444:\".fr-login-alpha__inner {\n  --content-span: 6; /* Width of Features Column */  \n  --grid-card-gap: calc(var(--grid-gap) * 2.5);\n}\n\n@media (min-width: 991px) {\n  \n  .fr-login-alpha__inner > *:nth-child(odd) {\n		order: 1;\n		display: flex;\n    flex-direction: column;    \n    align-items: flex-start;\n  }\n  \n  .fr-login-alpha__inner > *:nth-child(even) {\n		order: -1;\n		display: flex;\n    flex-direction: column;\n    align-items: flex-end;\n  }  \n\n}\";s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:14:\"var(--grid-12)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:8:\"_gridGap\";s:20:\"var(--grid-card-gap)\";s:15:\"_alignItemsGrid\";s:6:\"center\";s:36:\"_gridTemplateColumns:tablet_portrait\";s:13:\"var(--grid-1)\";s:24:\"_gridGap:tablet_portrait\";s:1:\"0\";s:6:\"_width\";s:4:\"100%\";}}i:2481;a:3:{s:2:\"id\";s:6:\"lvulcr\";s:4:\"name\";s:31:\"fr-login-alpha__content-wrapper\";s:8:\"settings\";a:11:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:8:\"_padding\";a:2:{s:3:\"top\";s:22:\"var(--section-space-m)\";s:6:\"bottom\";s:22:\"var(--section-space-m)\";}s:35:\"_gridItemColumnSpan:tablet_portrait\";s:4:\"auto\";s:22:\"_width:tablet_portrait\";s:25:\"var(--content-width-safe)\";s:23:\"_margin:tablet_portrait\";a:3:{s:4:\"left\";s:4:\"auto\";s:5:\"right\";s:4:\"auto\";s:3:\"top\";s:26:\"calc(var(--space-xl) * -1)\";}s:23:\"_zIndex:tablet_portrait\";s:1:\"1\";s:24:\"_padding:tablet_portrait\";a:4:{s:3:\"top\";s:14:\"var(--space-l)\";s:5:\"right\";s:14:\"var(--space-l)\";s:6:\"bottom\";s:14:\"var(--space-l)\";s:4:\"left\";s:14:\"var(--space-l)\";}s:27:\"_background:tablet_portrait\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:12:\"var(--white)\";}}s:19:\"_gridItemColumnSpan\";s:24:\"span var(--content-span)\";}}i:2482;a:3:{s:2:\"id\";s:6:\"hhkrmc\";s:4:\"name\";s:23:\"fr-login-alpha__heading\";s:8:\"settings\";a:0:{}}i:2483;a:3:{s:2:\"id\";s:6:\"ikontf\";s:4:\"name\";s:22:\"fr-login-alpha__notice\";s:8:\"settings\";a:3:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";}}i:2484;a:3:{s:2:\"id\";s:6:\"glrhvz\";s:4:\"name\";s:18:\"fr-cta-links-bravo\";s:8:\"settings\";a:9:{s:8:\"_display\";s:4:\"flex\";s:9:\"_flexWrap\";s:4:\"wrap\";s:11:\"_alignItems\";s:6:\"center\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:10:\"_columnGap\";s:18:\"var(--content-gap)\";s:26:\"_direction:mobile_portrait\";s:6:\"column\";s:22:\"_width:mobile_portrait\";s:4:\"100%\";s:26:\"_cssCustom:mobile_portrait\";s:52:\".fr-cta-links-bravo > * {\n	width: 100% !important;\n}\";s:11:\"_typography\";a:1:{s:10:\"text-align\";s:6:\"center\";}}}i:2485;a:3:{s:2:\"id\";s:6:\"aekezk\";s:4:\"name\";s:24:\"fr-cta-links-bravo__link\";s:8:\"settings\";a:0:{}}i:2486;a:3:{s:2:\"id\";s:6:\"huelml\";s:4:\"name\";s:20:\"fr-login-alpha__form\";s:8:\"settings\";a:8:{s:15:\"labelTypography\";a:1:{s:9:\"font-size\";s:13:\"var(--text-m)\";}s:11:\"fieldMargin\";a:1:{s:6:\"bottom\";s:1:\"0\";}s:14:\"_flexDirection\";s:6:\"column\";s:4:\"_gap\";s:18:\"var(--content-gap)\";s:11:\"_alignItems\";s:10:\"flex-start\";s:6:\"_width\";s:4:\"20em\";s:21:\"placeholderTypography\";a:1:{s:9:\"font-size\";s:13:\"var(--text-m)\";}s:22:\"_width:tablet_portrait\";s:4:\"100%\";}}i:2487;a:3:{s:2:\"id\";s:6:\"tqqkmn\";s:4:\"name\";s:20:\"fr-login-alpha__logo\";s:8:\"settings\";a:2:{s:6:\"_order\";s:2:\"-1\";s:6:\"_width\";s:5:\"200px\";}}i:2488;a:3:{s:2:\"id\";s:6:\"udfnqx\";s:4:\"name\";s:29:\"fr-login-alpha__media-wrapper\";s:8:\"settings\";a:5:{s:19:\"_gridItemColumnSpan\";s:35:\"span calc(12 - var(--content-span))\";s:22:\"_order:tablet_portrait\";s:2:\"-1\";s:35:\"_gridItemColumnSpan:tablet_portrait\";s:6:\"1 / -1\";s:23:\"_height:tablet_portrait\";s:5:\"320px\";s:9:\"_position\";s:8:\"relative\";}}i:2489;a:3:{s:2:\"id\";s:6:\"voympa\";s:4:\"name\";s:21:\"fr-login-alpha__media\";s:8:\"settings\";a:11:{s:10:\"_objectFit\";s:5:\"cover\";s:6:\"_width\";s:4:\"100%\";s:7:\"_height\";s:4:\"100%\";s:10:\"_cssCustom\";s:223:\".fr-login-alpha__media {\n	height: 100vh;\n}\n\n@media (min-width: 991px) {\n  .fr-login-alpha__media {\n    min-width: calc((50vw - ((var(--features-span) - 6) * (var(--content-width) / 12))) - (var(--grid-card-gap) / 4));\n  }\n}\";s:25:\"_position:tablet_portrait\";s:8:\"absolute\";s:20:\"_top:tablet_portrait\";s:1:\"0\";s:22:\"_right:tablet_portrait\";s:1:\"0\";s:23:\"_bottom:tablet_portrait\";s:1:\"0\";s:21:\"_left:tablet_portrait\";s:1:\"0\";s:22:\"_width:tablet_portrait\";s:4:\"100%\";s:23:\"_height:tablet_portrait\";s:4:\"100%\";}}i:2490;a:3:{s:2:\"id\";s:6:\"fkkfin\";s:4:\"name\";s:21:\"fr-contact-card-alpha\";s:8:\"settings\";a:7:{s:23:\"_rowGap:mobile_portrait\";s:18:\"var(--fr-grid-gap)\";s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:15:\"var(--grid-3-2)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:17:\"_alignContentGrid\";s:7:\"stretch\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";}}i:2491;a:3:{s:2:\"id\";s:6:\"grzadt\";s:4:\"name\";s:38:\"fr-contact-card-alpha__content-wrapper\";s:8:\"settings\";a:5:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:21:\"var(--fr-content-gap)\";s:24:\"_padding:mobile_portrait\";a:5:{s:4:\"unit\";a:4:{s:3:\"top\";s:2:\"px\";s:5:\"right\";s:2:\"px\";s:6:\"bottom\";s:2:\"px\";s:4:\"left\";s:2:\"px\";}s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:15:\"_justifyContent\";s:6:\"center\";}}i:2492;a:3:{s:2:\"id\";s:6:\"mjoavz\";s:4:\"name\";s:30:\"fr-contact-card-alpha__heading\";s:8:\"settings\";a:0:{}}i:2493;a:3:{s:2:\"id\";s:6:\"janppt\";s:4:\"name\";s:34:\"fr-contact-card-alpha__description\";s:8:\"settings\";a:0:{}}i:2494;a:3:{s:2:\"id\";s:6:\"clnbim\";s:4:\"name\";s:37:\"fr-contact-card-alpha__accent-heading\";s:8:\"settings\";a:0:{}}i:2495;a:3:{s:2:\"id\";s:6:\"ydrlqc\";s:4:\"name\";s:11:\"bm-header-2\";s:8:\"settings\";a:4:{s:27:\"_cssCustom:mobile_landscape\";s:32:\".header-2 {\n	overflow: hidden;\n}\";s:8:\"_padding\";a:2:{s:3:\"top\";s:15:\"var(--space-xl)\";s:6:\"bottom\";s:14:\"var(--space-s)\";}s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:14:\"var(--bg-dark)\";}}s:10:\"_boxShadow\";a:2:{s:6:\"values\";a:3:{s:7:\"offsetX\";s:1:\"1\";s:4:\"blur\";s:2:\"25\";s:6:\"spread\";s:1:\"5\";}s:5:\"color\";a:1:{s:3:\"raw\";s:34:\"var(--neutral-ultra-dark-trans-20)\";}}}}i:2496;a:3:{s:2:\"id\";s:6:\"efsgoo\";s:4:\"name\";s:22:\"bm-header-2__container\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:3:\"row\";s:15:\"_justifyContent\";s:10:\"flex-start\";s:11:\"_alignItems\";s:6:\"center\";s:10:\"_columnGap\";s:18:\"var(--content-gap)\";s:9:\"_flexWrap\";s:6:\"nowrap\";}}i:2497;a:5:{s:2:\"id\";s:6:\"ssatzy\";s:4:\"name\";s:23:\"bm-header-2__brand-logo\";s:8:\"settings\";a:2:{s:27:\"_cssCustom:mobile_landscape\";s:51:\".header-1__logo.white path {\n	fill: var(--white);\n}\";s:6:\"_width\";s:4:\"15em\";}s:8:\"modified\";i:1763157632;s:7:\"user_id\";i:1;}i:2498;a:5:{s:2:\"id\";s:6:\"vjqpxz\";s:4:\"name\";s:17:\"bm-header-2__menu\";s:8:\"settings\";a:22:{s:14:\"menuTypography\";a:4:{s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--text-light)\";}s:14:\"text-transform\";s:9:\"uppercase\";s:11:\"font-family\";s:9:\"Reem Kufi\";s:11:\"font-weight\";s:3:\"600\";}s:23:\"_order:mobile_landscape\";s:1:\"2\";s:10:\"menuMargin\";a:1:{s:4:\"left\";s:1:\"0\";}s:7:\"menuGap\";s:1:\"0\";s:11:\"menuPadding\";a:4:{s:4:\"left\";s:3:\"1em\";s:5:\"right\";s:3:\"1em\";s:6:\"bottom\";s:5:\"0.5em\";s:3:\"top\";s:5:\"0.5em\";}s:20:\"menuBackground:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:19:\"var(--neutral-dark)\";}}s:14:\"menuIconMargin\";a:1:{s:4:\"left\";s:4:\"-1em\";}s:15:\"menuIconPadding\";a:4:{s:4:\"left\";s:5:\"0.5em\";s:5:\"right\";s:3:\"1em\";s:3:\"top\";s:5:\"0.5em\";s:6:\"bottom\";s:5:\"0.5em\";}s:17:\"subMenuBackground\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:19:\"var(--neutral-dark)\";}}s:17:\"subMenuTypography\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--text-light)\";}s:11:\"font-weight\";s:3:\"600\";}s:23:\"subMenuBackground:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:19:\"var(--action-hover)\";}}s:24:\"_margin:mobile_landscape\";a:1:{s:4:\"left\";s:4:\"auto\";}s:38:\"mobileMenuToggleColor:mobile_landscape\";a:1:{s:3:\"raw\";s:17:\"var(--text-light)\";}s:38:\"mobileMenuToggleWidth:mobile_landscape\";s:6:\"1.25em\";s:43:\"mobileMenuToggleColorClose:mobile_landscape\";a:1:{s:3:\"raw\";s:17:\"var(--text-light)\";}s:37:\"mobileMenuBackground:mobile_landscape\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:13:\"var(--action)\";}}s:37:\"mobileMenuTypography:mobile_landscape\";a:3:{s:14:\"text-transform\";s:9:\"uppercase\";s:11:\"font-weight\";s:3:\"600\";s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--text-light)\";}}s:44:\"mobileSubMenuItemBackground:mobile_landscape\";a:1:{s:3:\"raw\";s:19:\"var(--action-hover)\";}s:50:\"mobileSubMenuItemBackground:mobile_landscape:hover\";a:1:{s:3:\"raw\";s:14:\"var(--bg-dark)\";}s:47:\"mobileMenuItemBackground:mobile_landscape:hover\";a:1:{s:3:\"raw\";s:20:\"var(--bg-ultra-dark)\";}s:40:\"mobileSubMenuTypography:mobile_landscape\";a:3:{s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--text-light)\";}s:14:\"text-transform\";s:9:\"uppercase\";s:11:\"font-weight\";s:3:\"600\";}s:27:\"_cssCustom:mobile_landscape\";s:76:\".brxe-nav-menu .bricks-mobile-menu-wrapper.right {\n    padding-top: 100px;\n}\";}s:8:\"modified\";i:1764797688;s:7:\"user_id\";i:1;}i:2499;a:3:{s:2:\"id\";s:6:\"hhftvh\";s:4:\"name\";s:18:\"bm-header-2__brand\";s:8:\"settings\";a:3:{s:36:\"_gridItemColumnSpan:mobile_landscape\";s:6:\"span 3\";s:19:\"_gridItemColumnSpan\";s:6:\"span 2\";s:6:\"_width\";s:4:\"auto\";}}i:2500;a:5:{s:2:\"id\";s:6:\"rgdpde\";s:4:\"name\";s:22:\"Header-2__right-column\";s:8:\"settings\";a:8:{s:19:\"_gridItemColumnSpan\";s:6:\"span 6\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:3:\"row\";s:11:\"_alignItems\";s:6:\"center\";s:36:\"_gridItemColumnSpan:mobile_landscape\";s:2:\"-1\";s:10:\"_columnGap\";s:18:\"var(--content-gap)\";s:15:\"_justifyContent\";s:13:\"space-between\";s:27:\"_direction:mobile_landscape\";s:3:\"row\";}s:8:\"modified\";i:1761660648;s:7:\"user_id\";i:1;}i:2501;a:3:{s:2:\"id\";s:6:\"fxtqvr\";s:4:\"name\";s:16:\"bm-header-2__cta\";s:8:\"settings\";a:0:{}}i:2502;a:3:{s:2:\"id\";s:6:\"cxwfpu\";s:4:\"name\";s:7:\"hero-41\";s:8:\"settings\";a:3:{s:9:\"_position\";s:8:\"relative\";s:7:\"_height\";s:4:\"78vh\";s:15:\"_justifyContent\";s:6:\"center\";}}i:2503;a:3:{s:2:\"id\";s:6:\"yzfmre\";s:4:\"name\";s:17:\"hero-41-container\";s:8:\"settings\";a:1:{s:11:\"_alignItems\";s:6:\"center\";}}i:2504;a:3:{s:2:\"id\";s:6:\"zyhspf\";s:4:\"name\";s:16:\"hero-41__content\";s:8:\"settings\";a:5:{s:9:\"_position\";s:8:\"relative\";s:7:\"_zIndex\";s:1:\"1\";s:11:\"_typography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:12:\"var(--white)\";}}s:6:\"_width\";s:4:\"100%\";s:9:\"_widthMax\";s:5:\"64rem\";}}i:2505;a:3:{s:2:\"id\";s:6:\"muadbq\";s:4:\"name\";s:5:\"intro\";s:8:\"settings\";a:7:{s:11:\"_typography\";a:1:{s:10:\"text-align\";s:6:\"center\";}s:10:\"_direction\";s:6:\"column\";s:8:\"_display\";s:4:\"flex\";s:11:\"_alignItems\";s:6:\"center\";s:7:\"_rowGap\";s:14:\"var(--space-s)\";s:23:\"_width:mobile_landscape\";s:4:\"100%\";s:10:\"_alignSelf\";s:6:\"center\";}}i:2506;a:3:{s:2:\"id\";s:6:\"wnpikx\";s:4:\"name\";s:14:\"intro__heading\";s:8:\"settings\";a:0:{}}i:2507;a:3:{s:2:\"id\";s:6:\"prgilv\";s:4:\"name\";s:17:\"intro__subheading\";s:8:\"settings\";a:0:{}}i:2508;a:3:{s:2:\"id\";s:6:\"samysq\";s:4:\"name\";s:21:\"intro__accent-heading\";s:8:\"settings\";a:2:{s:11:\"_typography\";a:1:{s:5:\"color\";a:3:{s:2:\"id\";s:19:\"acss_import_primary\";s:4:\"name\";s:7:\"primary\";s:3:\"raw\";s:14:\"var(--primary)\";}}s:6:\"_order\";s:2:\"-1\";}}i:2509;a:3:{s:2:\"id\";s:6:\"ogboaz\";s:4:\"name\";s:14:\"hero-41__media\";s:8:\"settings\";a:9:{s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:7:\"_height\";s:4:\"100%\";s:9:\"_overflow\";s:6:\"hidden\";}}i:2510;a:3:{s:2:\"id\";s:6:\"uhkgbs\";s:4:\"name\";s:19:\"hero-41__image-left\";s:8:\"settings\";a:4:{s:10:\"_objectFit\";s:5:\"cover\";s:7:\"_height\";s:4:\"100%\";s:12:\"_aspectRatio\";s:3:\"1/1\";s:6:\"_width\";s:4:\"100%\";}}i:2511;a:3:{s:2:\"id\";s:6:\"wojzek\";s:4:\"name\";s:20:\"hero-41__image-right\";s:8:\"settings\";a:4:{s:10:\"_objectFit\";s:5:\"cover\";s:7:\"_height\";s:4:\"100%\";s:12:\"_aspectRatio\";s:3:\"1/1\";s:6:\"_width\";s:4:\"100%\";}}i:2512;a:3:{s:2:\"id\";s:6:\"shvsri\";s:4:\"name\";s:16:\"hero-41__overlay\";s:8:\"settings\";a:6:{s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:9:\"_gradient\";a:1:{s:6:\"colors\";a:2:{i:0;a:2:{s:2:\"id\";s:6:\"fxaepc\";s:5:\"color\";a:3:{s:2:\"id\";s:26:\"acss_import_shade-trans-60\";s:4:\"name\";s:14:\"shade-trans-60\";s:3:\"raw\";s:21:\"var(--shade-trans-60)\";}}i:1;a:2:{s:2:\"id\";s:6:\"iutwwi\";s:5:\"color\";a:3:{s:2:\"id\";s:26:\"acss_import_shade-trans-90\";s:4:\"name\";s:14:\"shade-trans-90\";s:3:\"raw\";s:21:\"var(--shade-trans-90)\";}}}}}}i:2513;a:3:{s:2:\"id\";s:6:\"wowljt\";s:4:\"name\";s:12:\"hide-code-ct\";s:8:\"settings\";a:1:{s:10:\"_cssCustom\";s:34:\".hide-code-ct {\n	display: none; \n}\";}}i:2514;a:4:{s:2:\"id\";s:23:\"acss_import_padding--xs\";s:4:\"name\";s:11:\"padding--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2515;a:4:{s:2:\"id\";s:22:\"acss_import_padding--s\";s:4:\"name\";s:10:\"padding--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2516;a:4:{s:2:\"id\";s:22:\"acss_import_padding--m\";s:4:\"name\";s:10:\"padding--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2517;a:4:{s:2:\"id\";s:22:\"acss_import_padding--l\";s:4:\"name\";s:10:\"padding--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2518;a:4:{s:2:\"id\";s:23:\"acss_import_padding--xl\";s:4:\"name\";s:11:\"padding--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2519;a:4:{s:2:\"id\";s:24:\"acss_import_padding--xxl\";s:4:\"name\";s:12:\"padding--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2520;a:4:{s:2:\"id\";s:25:\"acss_import_padding--none\";s:4:\"name\";s:13:\"padding--none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2521;a:4:{s:2:\"id\";s:22:\"acss_import_header--xs\";s:4:\"name\";s:10:\"header--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2522;a:4:{s:2:\"id\";s:21:\"acss_import_header--s\";s:4:\"name\";s:9:\"header--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2523;a:4:{s:2:\"id\";s:21:\"acss_import_header--m\";s:4:\"name\";s:9:\"header--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2524;a:4:{s:2:\"id\";s:21:\"acss_import_header--l\";s:4:\"name\";s:9:\"header--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2525;a:4:{s:2:\"id\";s:22:\"acss_import_header--xl\";s:4:\"name\";s:10:\"header--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2526;a:4:{s:2:\"id\";s:23:\"acss_import_header--xxl\";s:4:\"name\";s:11:\"header--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2527;a:4:{s:2:\"id\";s:23:\"acss_import_section--xs\";s:4:\"name\";s:11:\"section--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2528;a:4:{s:2:\"id\";s:25:\"acss_import_section--s-xs\";s:4:\"name\";s:13:\"section--s-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2529;a:4:{s:2:\"id\";s:25:\"acss_import_section--m-xs\";s:4:\"name\";s:13:\"section--m-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2530;a:4:{s:2:\"id\";s:25:\"acss_import_section--l-xs\";s:4:\"name\";s:13:\"section--l-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2531;a:4:{s:2:\"id\";s:26:\"acss_import_section--xl-xs\";s:4:\"name\";s:14:\"section--xl-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2532;a:4:{s:2:\"id\";s:27:\"acss_import_section--xxl-xs\";s:4:\"name\";s:15:\"section--xxl-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2533;a:4:{s:2:\"id\";s:22:\"acss_import_section--s\";s:4:\"name\";s:10:\"section--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2534;a:4:{s:2:\"id\";s:24:\"acss_import_section--s-s\";s:4:\"name\";s:12:\"section--s-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2535;a:4:{s:2:\"id\";s:24:\"acss_import_section--m-s\";s:4:\"name\";s:12:\"section--m-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2536;a:4:{s:2:\"id\";s:24:\"acss_import_section--l-s\";s:4:\"name\";s:12:\"section--l-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2537;a:4:{s:2:\"id\";s:25:\"acss_import_section--xl-s\";s:4:\"name\";s:13:\"section--xl-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2538;a:4:{s:2:\"id\";s:26:\"acss_import_section--xxl-s\";s:4:\"name\";s:14:\"section--xxl-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2539;a:4:{s:2:\"id\";s:22:\"acss_import_section--m\";s:4:\"name\";s:10:\"section--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2540;a:4:{s:2:\"id\";s:24:\"acss_import_section--s-m\";s:4:\"name\";s:12:\"section--s-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2541;a:4:{s:2:\"id\";s:24:\"acss_import_section--m-m\";s:4:\"name\";s:12:\"section--m-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2542;a:4:{s:2:\"id\";s:24:\"acss_import_section--l-m\";s:4:\"name\";s:12:\"section--l-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2543;a:4:{s:2:\"id\";s:25:\"acss_import_section--xl-m\";s:4:\"name\";s:13:\"section--xl-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2544;a:4:{s:2:\"id\";s:26:\"acss_import_section--xxl-m\";s:4:\"name\";s:14:\"section--xxl-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2545;a:4:{s:2:\"id\";s:22:\"acss_import_section--l\";s:4:\"name\";s:10:\"section--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2546;a:4:{s:2:\"id\";s:24:\"acss_import_section--s-l\";s:4:\"name\";s:12:\"section--s-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2547;a:4:{s:2:\"id\";s:24:\"acss_import_section--m-l\";s:4:\"name\";s:12:\"section--m-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2548;a:4:{s:2:\"id\";s:24:\"acss_import_section--l-l\";s:4:\"name\";s:12:\"section--l-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2549;a:4:{s:2:\"id\";s:25:\"acss_import_section--xl-l\";s:4:\"name\";s:13:\"section--xl-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2550;a:4:{s:2:\"id\";s:26:\"acss_import_section--xxl-l\";s:4:\"name\";s:14:\"section--xxl-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2551;a:4:{s:2:\"id\";s:23:\"acss_import_section--xl\";s:4:\"name\";s:11:\"section--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2552;a:4:{s:2:\"id\";s:25:\"acss_import_section--s-xl\";s:4:\"name\";s:13:\"section--s-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2553;a:4:{s:2:\"id\";s:25:\"acss_import_section--m-xl\";s:4:\"name\";s:13:\"section--m-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2554;a:4:{s:2:\"id\";s:25:\"acss_import_section--l-xl\";s:4:\"name\";s:13:\"section--l-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2555;a:4:{s:2:\"id\";s:26:\"acss_import_section--xl-xl\";s:4:\"name\";s:14:\"section--xl-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2556;a:4:{s:2:\"id\";s:27:\"acss_import_section--xxl-xl\";s:4:\"name\";s:15:\"section--xxl-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2557;a:4:{s:2:\"id\";s:24:\"acss_import_section--xxl\";s:4:\"name\";s:12:\"section--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2558;a:4:{s:2:\"id\";s:26:\"acss_import_section--s-xxl\";s:4:\"name\";s:14:\"section--s-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2559;a:4:{s:2:\"id\";s:26:\"acss_import_section--m-xxl\";s:4:\"name\";s:14:\"section--m-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2560;a:4:{s:2:\"id\";s:26:\"acss_import_section--l-xxl\";s:4:\"name\";s:14:\"section--l-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2561;a:4:{s:2:\"id\";s:27:\"acss_import_section--xl-xxl\";s:4:\"name\";s:15:\"section--xl-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2562;a:4:{s:2:\"id\";s:28:\"acss_import_section--xxl-xxl\";s:4:\"name\";s:16:\"section--xxl-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2563;a:4:{s:2:\"id\";s:25:\"acss_import_section--none\";s:4:\"name\";s:13:\"section--none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2564;a:4:{s:2:\"id\";s:27:\"acss_import_section--s-none\";s:4:\"name\";s:15:\"section--s-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2565;a:4:{s:2:\"id\";s:27:\"acss_import_section--m-none\";s:4:\"name\";s:15:\"section--m-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2566;a:4:{s:2:\"id\";s:27:\"acss_import_section--l-none\";s:4:\"name\";s:15:\"section--l-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2567;a:4:{s:2:\"id\";s:28:\"acss_import_section--xl-none\";s:4:\"name\";s:16:\"section--xl-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2568;a:4:{s:2:\"id\";s:29:\"acss_import_section--xxl-none\";s:4:\"name\";s:17:\"section--xxl-none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2569;a:4:{s:2:\"id\";s:34:\"acss_import_text--action-semi-dark\";s:4:\"name\";s:22:\"text--action-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2570;a:4:{s:2:\"id\";s:35:\"acss_import_text--action-semi-light\";s:4:\"name\";s:23:\"text--action-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2571;a:4:{s:2:\"id\";s:35:\"acss_import_text--primary-semi-dark\";s:4:\"name\";s:23:\"text--primary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2572;a:4:{s:2:\"id\";s:36:\"acss_import_text--primary-semi-light\";s:4:\"name\";s:24:\"text--primary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2573;a:4:{s:2:\"id\";s:37:\"acss_import_text--secondary-semi-dark\";s:4:\"name\";s:25:\"text--secondary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2574;a:4:{s:2:\"id\";s:38:\"acss_import_text--secondary-semi-light\";s:4:\"name\";s:26:\"text--secondary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2575;a:4:{s:2:\"id\";s:34:\"acss_import_text--accent-semi-dark\";s:4:\"name\";s:22:\"text--accent-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2576;a:4:{s:2:\"id\";s:35:\"acss_import_text--accent-semi-light\";s:4:\"name\";s:23:\"text--accent-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2577;a:4:{s:2:\"id\";s:32:\"acss_import_text--base-semi-dark\";s:4:\"name\";s:20:\"text--base-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2578;a:4:{s:2:\"id\";s:33:\"acss_import_text--base-semi-light\";s:4:\"name\";s:21:\"text--base-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2579;a:4:{s:2:\"id\";s:33:\"acss_import_text--shade-semi-dark\";s:4:\"name\";s:21:\"text--shade-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2580;a:4:{s:2:\"id\";s:34:\"acss_import_text--shade-semi-light\";s:4:\"name\";s:22:\"text--shade-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2581;a:4:{s:2:\"id\";s:35:\"acss_import_text--neutral-semi-dark\";s:4:\"name\";s:23:\"text--neutral-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2582;a:4:{s:2:\"id\";s:36:\"acss_import_text--neutral-semi-light\";s:4:\"name\";s:24:\"text--neutral-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2583;a:4:{s:2:\"id\";s:36:\"acss_import_text--success-ultra-dark\";s:4:\"name\";s:24:\"text--success-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2584;a:4:{s:2:\"id\";s:35:\"acss_import_text--success-semi-dark\";s:4:\"name\";s:23:\"text--success-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2585;a:4:{s:2:\"id\";s:32:\"acss_import_text--success-medium\";s:4:\"name\";s:20:\"text--success-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2586;a:4:{s:2:\"id\";s:36:\"acss_import_text--success-semi-light\";s:4:\"name\";s:24:\"text--success-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2587;a:4:{s:2:\"id\";s:37:\"acss_import_text--success-ultra-light\";s:4:\"name\";s:25:\"text--success-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2588;a:4:{s:2:\"id\";s:30:\"acss_import_text--success-comp\";s:4:\"name\";s:18:\"text--success-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2589;a:4:{s:2:\"id\";s:35:\"acss_import_text--danger-ultra-dark\";s:4:\"name\";s:23:\"text--danger-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2590;a:4:{s:2:\"id\";s:34:\"acss_import_text--danger-semi-dark\";s:4:\"name\";s:22:\"text--danger-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2591;a:4:{s:2:\"id\";s:31:\"acss_import_text--danger-medium\";s:4:\"name\";s:19:\"text--danger-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2592;a:4:{s:2:\"id\";s:35:\"acss_import_text--danger-semi-light\";s:4:\"name\";s:23:\"text--danger-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2593;a:4:{s:2:\"id\";s:36:\"acss_import_text--danger-ultra-light\";s:4:\"name\";s:24:\"text--danger-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2594;a:4:{s:2:\"id\";s:29:\"acss_import_text--danger-comp\";s:4:\"name\";s:17:\"text--danger-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2595;a:4:{s:2:\"id\";s:36:\"acss_import_text--warning-ultra-dark\";s:4:\"name\";s:24:\"text--warning-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2596;a:4:{s:2:\"id\";s:35:\"acss_import_text--warning-semi-dark\";s:4:\"name\";s:23:\"text--warning-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2597;a:4:{s:2:\"id\";s:32:\"acss_import_text--warning-medium\";s:4:\"name\";s:20:\"text--warning-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2598;a:4:{s:2:\"id\";s:36:\"acss_import_text--warning-semi-light\";s:4:\"name\";s:24:\"text--warning-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2599;a:4:{s:2:\"id\";s:37:\"acss_import_text--warning-ultra-light\";s:4:\"name\";s:25:\"text--warning-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2600;a:4:{s:2:\"id\";s:30:\"acss_import_text--warning-comp\";s:4:\"name\";s:18:\"text--warning-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2601;a:4:{s:2:\"id\";s:33:\"acss_import_text--info-ultra-dark\";s:4:\"name\";s:21:\"text--info-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2602;a:4:{s:2:\"id\";s:32:\"acss_import_text--info-semi-dark\";s:4:\"name\";s:20:\"text--info-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2603;a:4:{s:2:\"id\";s:29:\"acss_import_text--info-medium\";s:4:\"name\";s:17:\"text--info-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2604;a:4:{s:2:\"id\";s:33:\"acss_import_text--info-semi-light\";s:4:\"name\";s:21:\"text--info-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2605;a:4:{s:2:\"id\";s:34:\"acss_import_text--info-ultra-light\";s:4:\"name\";s:22:\"text--info-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2606;a:4:{s:2:\"id\";s:27:\"acss_import_text--info-comp\";s:4:\"name\";s:15:\"text--info-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2607;a:4:{s:2:\"id\";s:14:\"acss_import_h1\";s:4:\"name\";s:2:\"h1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2608;a:4:{s:2:\"id\";s:14:\"acss_import_h2\";s:4:\"name\";s:2:\"h2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2609;a:4:{s:2:\"id\";s:14:\"acss_import_h3\";s:4:\"name\";s:2:\"h3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2610;a:4:{s:2:\"id\";s:14:\"acss_import_h4\";s:4:\"name\";s:2:\"h4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2611;a:4:{s:2:\"id\";s:14:\"acss_import_h5\";s:4:\"name\";s:2:\"h5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2612;a:4:{s:2:\"id\";s:14:\"acss_import_h6\";s:4:\"name\";s:2:\"h6\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2613;a:4:{s:2:\"id\";s:32:\"acss_import_bg--action-semi-dark\";s:4:\"name\";s:20:\"bg--action-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2614;a:4:{s:2:\"id\";s:33:\"acss_import_bg--action-semi-light\";s:4:\"name\";s:21:\"bg--action-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2615;a:4:{s:2:\"id\";s:33:\"acss_import_bg--primary-semi-dark\";s:4:\"name\";s:21:\"bg--primary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2616;a:4:{s:2:\"id\";s:34:\"acss_import_bg--primary-semi-light\";s:4:\"name\";s:22:\"bg--primary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2617;a:4:{s:2:\"id\";s:35:\"acss_import_bg--secondary-semi-dark\";s:4:\"name\";s:23:\"bg--secondary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2618;a:4:{s:2:\"id\";s:36:\"acss_import_bg--secondary-semi-light\";s:4:\"name\";s:24:\"bg--secondary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2619;a:4:{s:2:\"id\";s:32:\"acss_import_bg--accent-semi-dark\";s:4:\"name\";s:20:\"bg--accent-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2620;a:4:{s:2:\"id\";s:33:\"acss_import_bg--accent-semi-light\";s:4:\"name\";s:21:\"bg--accent-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2621;a:4:{s:2:\"id\";s:30:\"acss_import_bg--base-semi-dark\";s:4:\"name\";s:18:\"bg--base-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2622;a:4:{s:2:\"id\";s:31:\"acss_import_bg--base-semi-light\";s:4:\"name\";s:19:\"bg--base-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2623;a:4:{s:2:\"id\";s:33:\"acss_import_bg--neutral-semi-dark\";s:4:\"name\";s:21:\"bg--neutral-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2624;a:4:{s:2:\"id\";s:34:\"acss_import_bg--neutral-semi-light\";s:4:\"name\";s:22:\"bg--neutral-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2625;a:4:{s:2:\"id\";s:31:\"acss_import_bg--shade-semi-dark\";s:4:\"name\";s:19:\"bg--shade-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2626;a:4:{s:2:\"id\";s:32:\"acss_import_bg--shade-semi-light\";s:4:\"name\";s:20:\"bg--shade-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2627;a:4:{s:2:\"id\";s:34:\"acss_import_bg--success-ultra-dark\";s:4:\"name\";s:22:\"bg--success-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2628;a:4:{s:2:\"id\";s:43:\"acss_import_bg--success-ultra-dark-trans-90\";s:4:\"name\";s:31:\"bg--success-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2629;a:4:{s:2:\"id\";s:43:\"acss_import_bg--success-ultra-dark-trans-80\";s:4:\"name\";s:31:\"bg--success-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2630;a:4:{s:2:\"id\";s:43:\"acss_import_bg--success-ultra-dark-trans-70\";s:4:\"name\";s:31:\"bg--success-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2631;a:4:{s:2:\"id\";s:43:\"acss_import_bg--success-ultra-dark-trans-60\";s:4:\"name\";s:31:\"bg--success-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2632;a:4:{s:2:\"id\";s:43:\"acss_import_bg--success-ultra-dark-trans-50\";s:4:\"name\";s:31:\"bg--success-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2633;a:4:{s:2:\"id\";s:43:\"acss_import_bg--success-ultra-dark-trans-40\";s:4:\"name\";s:31:\"bg--success-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2634;a:4:{s:2:\"id\";s:43:\"acss_import_bg--success-ultra-dark-trans-30\";s:4:\"name\";s:31:\"bg--success-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2635;a:4:{s:2:\"id\";s:43:\"acss_import_bg--success-ultra-dark-trans-20\";s:4:\"name\";s:31:\"bg--success-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2636;a:4:{s:2:\"id\";s:43:\"acss_import_bg--success-ultra-dark-trans-10\";s:4:\"name\";s:31:\"bg--success-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2637;a:4:{s:2:\"id\";s:37:\"acss_import_bg--success-dark-trans-90\";s:4:\"name\";s:25:\"bg--success-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2638;a:4:{s:2:\"id\";s:37:\"acss_import_bg--success-dark-trans-80\";s:4:\"name\";s:25:\"bg--success-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2639;a:4:{s:2:\"id\";s:37:\"acss_import_bg--success-dark-trans-70\";s:4:\"name\";s:25:\"bg--success-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2640;a:4:{s:2:\"id\";s:37:\"acss_import_bg--success-dark-trans-60\";s:4:\"name\";s:25:\"bg--success-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2641;a:4:{s:2:\"id\";s:37:\"acss_import_bg--success-dark-trans-50\";s:4:\"name\";s:25:\"bg--success-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2642;a:4:{s:2:\"id\";s:37:\"acss_import_bg--success-dark-trans-40\";s:4:\"name\";s:25:\"bg--success-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2643;a:4:{s:2:\"id\";s:37:\"acss_import_bg--success-dark-trans-30\";s:4:\"name\";s:25:\"bg--success-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2644;a:4:{s:2:\"id\";s:37:\"acss_import_bg--success-dark-trans-20\";s:4:\"name\";s:25:\"bg--success-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2645;a:4:{s:2:\"id\";s:37:\"acss_import_bg--success-dark-trans-10\";s:4:\"name\";s:25:\"bg--success-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2646;a:4:{s:2:\"id\";s:33:\"acss_import_bg--success-semi-dark\";s:4:\"name\";s:21:\"bg--success-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2647;a:4:{s:2:\"id\";s:30:\"acss_import_bg--success-medium\";s:4:\"name\";s:18:\"bg--success-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2648;a:4:{s:2:\"id\";s:32:\"acss_import_bg--success-trans-90\";s:4:\"name\";s:20:\"bg--success-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2649;a:4:{s:2:\"id\";s:32:\"acss_import_bg--success-trans-80\";s:4:\"name\";s:20:\"bg--success-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2650;a:4:{s:2:\"id\";s:32:\"acss_import_bg--success-trans-70\";s:4:\"name\";s:20:\"bg--success-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2651;a:4:{s:2:\"id\";s:32:\"acss_import_bg--success-trans-60\";s:4:\"name\";s:20:\"bg--success-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2652;a:4:{s:2:\"id\";s:32:\"acss_import_bg--success-trans-50\";s:4:\"name\";s:20:\"bg--success-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2653;a:4:{s:2:\"id\";s:32:\"acss_import_bg--success-trans-40\";s:4:\"name\";s:20:\"bg--success-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2654;a:4:{s:2:\"id\";s:32:\"acss_import_bg--success-trans-30\";s:4:\"name\";s:20:\"bg--success-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2655;a:4:{s:2:\"id\";s:32:\"acss_import_bg--success-trans-20\";s:4:\"name\";s:20:\"bg--success-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2656;a:4:{s:2:\"id\";s:32:\"acss_import_bg--success-trans-10\";s:4:\"name\";s:20:\"bg--success-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2657;a:4:{s:2:\"id\";s:34:\"acss_import_bg--success-semi-light\";s:4:\"name\";s:22:\"bg--success-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2658;a:4:{s:2:\"id\";s:38:\"acss_import_bg--success-light-trans-90\";s:4:\"name\";s:26:\"bg--success-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2659;a:4:{s:2:\"id\";s:38:\"acss_import_bg--success-light-trans-80\";s:4:\"name\";s:26:\"bg--success-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2660;a:4:{s:2:\"id\";s:38:\"acss_import_bg--success-light-trans-70\";s:4:\"name\";s:26:\"bg--success-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2661;a:4:{s:2:\"id\";s:38:\"acss_import_bg--success-light-trans-60\";s:4:\"name\";s:26:\"bg--success-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2662;a:4:{s:2:\"id\";s:38:\"acss_import_bg--success-light-trans-50\";s:4:\"name\";s:26:\"bg--success-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2663;a:4:{s:2:\"id\";s:38:\"acss_import_bg--success-light-trans-40\";s:4:\"name\";s:26:\"bg--success-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2664;a:4:{s:2:\"id\";s:38:\"acss_import_bg--success-light-trans-30\";s:4:\"name\";s:26:\"bg--success-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2665;a:4:{s:2:\"id\";s:38:\"acss_import_bg--success-light-trans-20\";s:4:\"name\";s:26:\"bg--success-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2666;a:4:{s:2:\"id\";s:38:\"acss_import_bg--success-light-trans-10\";s:4:\"name\";s:26:\"bg--success-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2667;a:4:{s:2:\"id\";s:35:\"acss_import_bg--success-ultra-light\";s:4:\"name\";s:23:\"bg--success-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2668;a:4:{s:2:\"id\";s:28:\"acss_import_bg--success-comp\";s:4:\"name\";s:16:\"bg--success-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2669;a:4:{s:2:\"id\";s:33:\"acss_import_bg--danger-ultra-dark\";s:4:\"name\";s:21:\"bg--danger-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2670;a:4:{s:2:\"id\";s:42:\"acss_import_bg--danger-ultra-dark-trans-90\";s:4:\"name\";s:30:\"bg--danger-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2671;a:4:{s:2:\"id\";s:42:\"acss_import_bg--danger-ultra-dark-trans-80\";s:4:\"name\";s:30:\"bg--danger-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2672;a:4:{s:2:\"id\";s:42:\"acss_import_bg--danger-ultra-dark-trans-70\";s:4:\"name\";s:30:\"bg--danger-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2673;a:4:{s:2:\"id\";s:42:\"acss_import_bg--danger-ultra-dark-trans-60\";s:4:\"name\";s:30:\"bg--danger-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2674;a:4:{s:2:\"id\";s:42:\"acss_import_bg--danger-ultra-dark-trans-50\";s:4:\"name\";s:30:\"bg--danger-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2675;a:4:{s:2:\"id\";s:42:\"acss_import_bg--danger-ultra-dark-trans-40\";s:4:\"name\";s:30:\"bg--danger-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2676;a:4:{s:2:\"id\";s:42:\"acss_import_bg--danger-ultra-dark-trans-30\";s:4:\"name\";s:30:\"bg--danger-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2677;a:4:{s:2:\"id\";s:42:\"acss_import_bg--danger-ultra-dark-trans-20\";s:4:\"name\";s:30:\"bg--danger-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2678;a:4:{s:2:\"id\";s:42:\"acss_import_bg--danger-ultra-dark-trans-10\";s:4:\"name\";s:30:\"bg--danger-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2679;a:4:{s:2:\"id\";s:36:\"acss_import_bg--danger-dark-trans-90\";s:4:\"name\";s:24:\"bg--danger-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2680;a:4:{s:2:\"id\";s:36:\"acss_import_bg--danger-dark-trans-80\";s:4:\"name\";s:24:\"bg--danger-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2681;a:4:{s:2:\"id\";s:36:\"acss_import_bg--danger-dark-trans-70\";s:4:\"name\";s:24:\"bg--danger-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2682;a:4:{s:2:\"id\";s:36:\"acss_import_bg--danger-dark-trans-60\";s:4:\"name\";s:24:\"bg--danger-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2683;a:4:{s:2:\"id\";s:36:\"acss_import_bg--danger-dark-trans-50\";s:4:\"name\";s:24:\"bg--danger-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2684;a:4:{s:2:\"id\";s:36:\"acss_import_bg--danger-dark-trans-40\";s:4:\"name\";s:24:\"bg--danger-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2685;a:4:{s:2:\"id\";s:36:\"acss_import_bg--danger-dark-trans-30\";s:4:\"name\";s:24:\"bg--danger-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2686;a:4:{s:2:\"id\";s:36:\"acss_import_bg--danger-dark-trans-20\";s:4:\"name\";s:24:\"bg--danger-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2687;a:4:{s:2:\"id\";s:36:\"acss_import_bg--danger-dark-trans-10\";s:4:\"name\";s:24:\"bg--danger-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2688;a:4:{s:2:\"id\";s:32:\"acss_import_bg--danger-semi-dark\";s:4:\"name\";s:20:\"bg--danger-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2689;a:4:{s:2:\"id\";s:29:\"acss_import_bg--danger-medium\";s:4:\"name\";s:17:\"bg--danger-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2690;a:4:{s:2:\"id\";s:31:\"acss_import_bg--danger-trans-90\";s:4:\"name\";s:19:\"bg--danger-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2691;a:4:{s:2:\"id\";s:31:\"acss_import_bg--danger-trans-80\";s:4:\"name\";s:19:\"bg--danger-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2692;a:4:{s:2:\"id\";s:31:\"acss_import_bg--danger-trans-70\";s:4:\"name\";s:19:\"bg--danger-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2693;a:4:{s:2:\"id\";s:31:\"acss_import_bg--danger-trans-60\";s:4:\"name\";s:19:\"bg--danger-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2694;a:4:{s:2:\"id\";s:31:\"acss_import_bg--danger-trans-50\";s:4:\"name\";s:19:\"bg--danger-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2695;a:4:{s:2:\"id\";s:31:\"acss_import_bg--danger-trans-40\";s:4:\"name\";s:19:\"bg--danger-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2696;a:4:{s:2:\"id\";s:31:\"acss_import_bg--danger-trans-30\";s:4:\"name\";s:19:\"bg--danger-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2697;a:4:{s:2:\"id\";s:31:\"acss_import_bg--danger-trans-20\";s:4:\"name\";s:19:\"bg--danger-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2698;a:4:{s:2:\"id\";s:31:\"acss_import_bg--danger-trans-10\";s:4:\"name\";s:19:\"bg--danger-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2699;a:4:{s:2:\"id\";s:33:\"acss_import_bg--danger-semi-light\";s:4:\"name\";s:21:\"bg--danger-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2700;a:4:{s:2:\"id\";s:37:\"acss_import_bg--danger-light-trans-90\";s:4:\"name\";s:25:\"bg--danger-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2701;a:4:{s:2:\"id\";s:37:\"acss_import_bg--danger-light-trans-80\";s:4:\"name\";s:25:\"bg--danger-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2702;a:4:{s:2:\"id\";s:37:\"acss_import_bg--danger-light-trans-70\";s:4:\"name\";s:25:\"bg--danger-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2703;a:4:{s:2:\"id\";s:37:\"acss_import_bg--danger-light-trans-60\";s:4:\"name\";s:25:\"bg--danger-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2704;a:4:{s:2:\"id\";s:37:\"acss_import_bg--danger-light-trans-50\";s:4:\"name\";s:25:\"bg--danger-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2705;a:4:{s:2:\"id\";s:37:\"acss_import_bg--danger-light-trans-40\";s:4:\"name\";s:25:\"bg--danger-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2706;a:4:{s:2:\"id\";s:37:\"acss_import_bg--danger-light-trans-30\";s:4:\"name\";s:25:\"bg--danger-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2707;a:4:{s:2:\"id\";s:37:\"acss_import_bg--danger-light-trans-20\";s:4:\"name\";s:25:\"bg--danger-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2708;a:4:{s:2:\"id\";s:37:\"acss_import_bg--danger-light-trans-10\";s:4:\"name\";s:25:\"bg--danger-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2709;a:4:{s:2:\"id\";s:34:\"acss_import_bg--danger-ultra-light\";s:4:\"name\";s:22:\"bg--danger-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2710;a:4:{s:2:\"id\";s:27:\"acss_import_bg--danger-comp\";s:4:\"name\";s:15:\"bg--danger-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2711;a:4:{s:2:\"id\";s:34:\"acss_import_bg--warning-ultra-dark\";s:4:\"name\";s:22:\"bg--warning-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2712;a:4:{s:2:\"id\";s:43:\"acss_import_bg--warning-ultra-dark-trans-90\";s:4:\"name\";s:31:\"bg--warning-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2713;a:4:{s:2:\"id\";s:43:\"acss_import_bg--warning-ultra-dark-trans-80\";s:4:\"name\";s:31:\"bg--warning-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2714;a:4:{s:2:\"id\";s:43:\"acss_import_bg--warning-ultra-dark-trans-70\";s:4:\"name\";s:31:\"bg--warning-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2715;a:4:{s:2:\"id\";s:43:\"acss_import_bg--warning-ultra-dark-trans-60\";s:4:\"name\";s:31:\"bg--warning-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2716;a:4:{s:2:\"id\";s:43:\"acss_import_bg--warning-ultra-dark-trans-50\";s:4:\"name\";s:31:\"bg--warning-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2717;a:4:{s:2:\"id\";s:43:\"acss_import_bg--warning-ultra-dark-trans-40\";s:4:\"name\";s:31:\"bg--warning-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2718;a:4:{s:2:\"id\";s:43:\"acss_import_bg--warning-ultra-dark-trans-30\";s:4:\"name\";s:31:\"bg--warning-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2719;a:4:{s:2:\"id\";s:43:\"acss_import_bg--warning-ultra-dark-trans-20\";s:4:\"name\";s:31:\"bg--warning-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2720;a:4:{s:2:\"id\";s:43:\"acss_import_bg--warning-ultra-dark-trans-10\";s:4:\"name\";s:31:\"bg--warning-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2721;a:4:{s:2:\"id\";s:37:\"acss_import_bg--warning-dark-trans-90\";s:4:\"name\";s:25:\"bg--warning-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2722;a:4:{s:2:\"id\";s:37:\"acss_import_bg--warning-dark-trans-80\";s:4:\"name\";s:25:\"bg--warning-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2723;a:4:{s:2:\"id\";s:37:\"acss_import_bg--warning-dark-trans-70\";s:4:\"name\";s:25:\"bg--warning-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2724;a:4:{s:2:\"id\";s:37:\"acss_import_bg--warning-dark-trans-60\";s:4:\"name\";s:25:\"bg--warning-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2725;a:4:{s:2:\"id\";s:37:\"acss_import_bg--warning-dark-trans-50\";s:4:\"name\";s:25:\"bg--warning-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2726;a:4:{s:2:\"id\";s:37:\"acss_import_bg--warning-dark-trans-40\";s:4:\"name\";s:25:\"bg--warning-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2727;a:4:{s:2:\"id\";s:37:\"acss_import_bg--warning-dark-trans-30\";s:4:\"name\";s:25:\"bg--warning-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2728;a:4:{s:2:\"id\";s:37:\"acss_import_bg--warning-dark-trans-20\";s:4:\"name\";s:25:\"bg--warning-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2729;a:4:{s:2:\"id\";s:37:\"acss_import_bg--warning-dark-trans-10\";s:4:\"name\";s:25:\"bg--warning-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2730;a:4:{s:2:\"id\";s:33:\"acss_import_bg--warning-semi-dark\";s:4:\"name\";s:21:\"bg--warning-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2731;a:4:{s:2:\"id\";s:30:\"acss_import_bg--warning-medium\";s:4:\"name\";s:18:\"bg--warning-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2732;a:4:{s:2:\"id\";s:32:\"acss_import_bg--warning-trans-90\";s:4:\"name\";s:20:\"bg--warning-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2733;a:4:{s:2:\"id\";s:32:\"acss_import_bg--warning-trans-80\";s:4:\"name\";s:20:\"bg--warning-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2734;a:4:{s:2:\"id\";s:32:\"acss_import_bg--warning-trans-70\";s:4:\"name\";s:20:\"bg--warning-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2735;a:4:{s:2:\"id\";s:32:\"acss_import_bg--warning-trans-60\";s:4:\"name\";s:20:\"bg--warning-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2736;a:4:{s:2:\"id\";s:32:\"acss_import_bg--warning-trans-50\";s:4:\"name\";s:20:\"bg--warning-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2737;a:4:{s:2:\"id\";s:32:\"acss_import_bg--warning-trans-40\";s:4:\"name\";s:20:\"bg--warning-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2738;a:4:{s:2:\"id\";s:32:\"acss_import_bg--warning-trans-30\";s:4:\"name\";s:20:\"bg--warning-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2739;a:4:{s:2:\"id\";s:32:\"acss_import_bg--warning-trans-20\";s:4:\"name\";s:20:\"bg--warning-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2740;a:4:{s:2:\"id\";s:32:\"acss_import_bg--warning-trans-10\";s:4:\"name\";s:20:\"bg--warning-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2741;a:4:{s:2:\"id\";s:34:\"acss_import_bg--warning-semi-light\";s:4:\"name\";s:22:\"bg--warning-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2742;a:4:{s:2:\"id\";s:38:\"acss_import_bg--warning-light-trans-90\";s:4:\"name\";s:26:\"bg--warning-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2743;a:4:{s:2:\"id\";s:38:\"acss_import_bg--warning-light-trans-80\";s:4:\"name\";s:26:\"bg--warning-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2744;a:4:{s:2:\"id\";s:38:\"acss_import_bg--warning-light-trans-70\";s:4:\"name\";s:26:\"bg--warning-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2745;a:4:{s:2:\"id\";s:38:\"acss_import_bg--warning-light-trans-60\";s:4:\"name\";s:26:\"bg--warning-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2746;a:4:{s:2:\"id\";s:38:\"acss_import_bg--warning-light-trans-50\";s:4:\"name\";s:26:\"bg--warning-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2747;a:4:{s:2:\"id\";s:38:\"acss_import_bg--warning-light-trans-40\";s:4:\"name\";s:26:\"bg--warning-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2748;a:4:{s:2:\"id\";s:38:\"acss_import_bg--warning-light-trans-30\";s:4:\"name\";s:26:\"bg--warning-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2749;a:4:{s:2:\"id\";s:38:\"acss_import_bg--warning-light-trans-20\";s:4:\"name\";s:26:\"bg--warning-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2750;a:4:{s:2:\"id\";s:38:\"acss_import_bg--warning-light-trans-10\";s:4:\"name\";s:26:\"bg--warning-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2751;a:4:{s:2:\"id\";s:35:\"acss_import_bg--warning-ultra-light\";s:4:\"name\";s:23:\"bg--warning-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2752;a:4:{s:2:\"id\";s:28:\"acss_import_bg--warning-comp\";s:4:\"name\";s:16:\"bg--warning-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2753;a:4:{s:2:\"id\";s:31:\"acss_import_bg--info-ultra-dark\";s:4:\"name\";s:19:\"bg--info-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2754;a:4:{s:2:\"id\";s:40:\"acss_import_bg--info-ultra-dark-trans-90\";s:4:\"name\";s:28:\"bg--info-ultra-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2755;a:4:{s:2:\"id\";s:40:\"acss_import_bg--info-ultra-dark-trans-80\";s:4:\"name\";s:28:\"bg--info-ultra-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2756;a:4:{s:2:\"id\";s:40:\"acss_import_bg--info-ultra-dark-trans-70\";s:4:\"name\";s:28:\"bg--info-ultra-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2757;a:4:{s:2:\"id\";s:40:\"acss_import_bg--info-ultra-dark-trans-60\";s:4:\"name\";s:28:\"bg--info-ultra-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2758;a:4:{s:2:\"id\";s:40:\"acss_import_bg--info-ultra-dark-trans-50\";s:4:\"name\";s:28:\"bg--info-ultra-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2759;a:4:{s:2:\"id\";s:40:\"acss_import_bg--info-ultra-dark-trans-40\";s:4:\"name\";s:28:\"bg--info-ultra-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2760;a:4:{s:2:\"id\";s:40:\"acss_import_bg--info-ultra-dark-trans-30\";s:4:\"name\";s:28:\"bg--info-ultra-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2761;a:4:{s:2:\"id\";s:40:\"acss_import_bg--info-ultra-dark-trans-20\";s:4:\"name\";s:28:\"bg--info-ultra-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2762;a:4:{s:2:\"id\";s:40:\"acss_import_bg--info-ultra-dark-trans-10\";s:4:\"name\";s:28:\"bg--info-ultra-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2763;a:4:{s:2:\"id\";s:34:\"acss_import_bg--info-dark-trans-90\";s:4:\"name\";s:22:\"bg--info-dark-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2764;a:4:{s:2:\"id\";s:34:\"acss_import_bg--info-dark-trans-80\";s:4:\"name\";s:22:\"bg--info-dark-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2765;a:4:{s:2:\"id\";s:34:\"acss_import_bg--info-dark-trans-70\";s:4:\"name\";s:22:\"bg--info-dark-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2766;a:4:{s:2:\"id\";s:34:\"acss_import_bg--info-dark-trans-60\";s:4:\"name\";s:22:\"bg--info-dark-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2767;a:4:{s:2:\"id\";s:34:\"acss_import_bg--info-dark-trans-50\";s:4:\"name\";s:22:\"bg--info-dark-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2768;a:4:{s:2:\"id\";s:34:\"acss_import_bg--info-dark-trans-40\";s:4:\"name\";s:22:\"bg--info-dark-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2769;a:4:{s:2:\"id\";s:34:\"acss_import_bg--info-dark-trans-30\";s:4:\"name\";s:22:\"bg--info-dark-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2770;a:4:{s:2:\"id\";s:34:\"acss_import_bg--info-dark-trans-20\";s:4:\"name\";s:22:\"bg--info-dark-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2771;a:4:{s:2:\"id\";s:34:\"acss_import_bg--info-dark-trans-10\";s:4:\"name\";s:22:\"bg--info-dark-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2772;a:4:{s:2:\"id\";s:30:\"acss_import_bg--info-semi-dark\";s:4:\"name\";s:18:\"bg--info-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2773;a:4:{s:2:\"id\";s:27:\"acss_import_bg--info-medium\";s:4:\"name\";s:15:\"bg--info-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2774;a:4:{s:2:\"id\";s:29:\"acss_import_bg--info-trans-90\";s:4:\"name\";s:17:\"bg--info-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2775;a:4:{s:2:\"id\";s:29:\"acss_import_bg--info-trans-80\";s:4:\"name\";s:17:\"bg--info-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2776;a:4:{s:2:\"id\";s:29:\"acss_import_bg--info-trans-70\";s:4:\"name\";s:17:\"bg--info-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2777;a:4:{s:2:\"id\";s:29:\"acss_import_bg--info-trans-60\";s:4:\"name\";s:17:\"bg--info-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2778;a:4:{s:2:\"id\";s:29:\"acss_import_bg--info-trans-50\";s:4:\"name\";s:17:\"bg--info-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2779;a:4:{s:2:\"id\";s:29:\"acss_import_bg--info-trans-40\";s:4:\"name\";s:17:\"bg--info-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2780;a:4:{s:2:\"id\";s:29:\"acss_import_bg--info-trans-30\";s:4:\"name\";s:17:\"bg--info-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2781;a:4:{s:2:\"id\";s:29:\"acss_import_bg--info-trans-20\";s:4:\"name\";s:17:\"bg--info-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2782;a:4:{s:2:\"id\";s:29:\"acss_import_bg--info-trans-10\";s:4:\"name\";s:17:\"bg--info-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2783;a:4:{s:2:\"id\";s:31:\"acss_import_bg--info-semi-light\";s:4:\"name\";s:19:\"bg--info-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2784;a:4:{s:2:\"id\";s:35:\"acss_import_bg--info-light-trans-90\";s:4:\"name\";s:23:\"bg--info-light-trans-90\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2785;a:4:{s:2:\"id\";s:35:\"acss_import_bg--info-light-trans-80\";s:4:\"name\";s:23:\"bg--info-light-trans-80\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2786;a:4:{s:2:\"id\";s:35:\"acss_import_bg--info-light-trans-70\";s:4:\"name\";s:23:\"bg--info-light-trans-70\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2787;a:4:{s:2:\"id\";s:35:\"acss_import_bg--info-light-trans-60\";s:4:\"name\";s:23:\"bg--info-light-trans-60\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2788;a:4:{s:2:\"id\";s:35:\"acss_import_bg--info-light-trans-50\";s:4:\"name\";s:23:\"bg--info-light-trans-50\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2789;a:4:{s:2:\"id\";s:35:\"acss_import_bg--info-light-trans-40\";s:4:\"name\";s:23:\"bg--info-light-trans-40\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2790;a:4:{s:2:\"id\";s:35:\"acss_import_bg--info-light-trans-30\";s:4:\"name\";s:23:\"bg--info-light-trans-30\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2791;a:4:{s:2:\"id\";s:35:\"acss_import_bg--info-light-trans-20\";s:4:\"name\";s:23:\"bg--info-light-trans-20\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2792;a:4:{s:2:\"id\";s:35:\"acss_import_bg--info-light-trans-10\";s:4:\"name\";s:23:\"bg--info-light-trans-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2793;a:4:{s:2:\"id\";s:32:\"acss_import_bg--info-ultra-light\";s:4:\"name\";s:20:\"bg--info-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2794;a:4:{s:2:\"id\";s:25:\"acss_import_bg--info-comp\";s:4:\"name\";s:13:\"bg--info-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2795;a:4:{s:2:\"id\";s:34:\"acss_import_link--action-semi-dark\";s:4:\"name\";s:22:\"link--action-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2796;a:4:{s:2:\"id\";s:35:\"acss_import_link--action-semi-light\";s:4:\"name\";s:23:\"link--action-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2797;a:4:{s:2:\"id\";s:35:\"acss_import_link--primary-semi-dark\";s:4:\"name\";s:23:\"link--primary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2798;a:4:{s:2:\"id\";s:36:\"acss_import_link--primary-semi-light\";s:4:\"name\";s:24:\"link--primary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2799;a:4:{s:2:\"id\";s:37:\"acss_import_link--secondary-semi-dark\";s:4:\"name\";s:25:\"link--secondary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2800;a:4:{s:2:\"id\";s:38:\"acss_import_link--secondary-semi-light\";s:4:\"name\";s:26:\"link--secondary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2801;a:4:{s:2:\"id\";s:34:\"acss_import_link--accent-semi-dark\";s:4:\"name\";s:22:\"link--accent-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2802;a:4:{s:2:\"id\";s:35:\"acss_import_link--accent-semi-light\";s:4:\"name\";s:23:\"link--accent-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2803;a:4:{s:2:\"id\";s:32:\"acss_import_link--base-semi-dark\";s:4:\"name\";s:20:\"link--base-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2804;a:4:{s:2:\"id\";s:33:\"acss_import_link--base-semi-light\";s:4:\"name\";s:21:\"link--base-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2805;a:4:{s:2:\"id\";s:35:\"acss_import_link--neutral-semi-dark\";s:4:\"name\";s:23:\"link--neutral-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2806;a:4:{s:2:\"id\";s:36:\"acss_import_link--neutral-semi-light\";s:4:\"name\";s:24:\"link--neutral-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2807;a:4:{s:2:\"id\";s:33:\"acss_import_link--shade-semi-dark\";s:4:\"name\";s:21:\"link--shade-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2808;a:4:{s:2:\"id\";s:34:\"acss_import_link--shade-semi-light\";s:4:\"name\";s:22:\"link--shade-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2809;a:4:{s:2:\"id\";s:36:\"acss_import_link--success-ultra-dark\";s:4:\"name\";s:24:\"link--success-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2810;a:4:{s:2:\"id\";s:35:\"acss_import_link--success-semi-dark\";s:4:\"name\";s:23:\"link--success-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2811;a:4:{s:2:\"id\";s:32:\"acss_import_link--success-medium\";s:4:\"name\";s:20:\"link--success-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2812;a:4:{s:2:\"id\";s:36:\"acss_import_link--success-semi-light\";s:4:\"name\";s:24:\"link--success-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2813;a:4:{s:2:\"id\";s:37:\"acss_import_link--success-ultra-light\";s:4:\"name\";s:25:\"link--success-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2814;a:4:{s:2:\"id\";s:30:\"acss_import_link--success-comp\";s:4:\"name\";s:18:\"link--success-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2815;a:4:{s:2:\"id\";s:35:\"acss_import_link--danger-ultra-dark\";s:4:\"name\";s:23:\"link--danger-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2816;a:4:{s:2:\"id\";s:34:\"acss_import_link--danger-semi-dark\";s:4:\"name\";s:22:\"link--danger-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2817;a:4:{s:2:\"id\";s:31:\"acss_import_link--danger-medium\";s:4:\"name\";s:19:\"link--danger-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2818;a:4:{s:2:\"id\";s:35:\"acss_import_link--danger-semi-light\";s:4:\"name\";s:23:\"link--danger-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2819;a:4:{s:2:\"id\";s:36:\"acss_import_link--danger-ultra-light\";s:4:\"name\";s:24:\"link--danger-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2820;a:4:{s:2:\"id\";s:29:\"acss_import_link--danger-comp\";s:4:\"name\";s:17:\"link--danger-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2821;a:4:{s:2:\"id\";s:36:\"acss_import_link--warning-ultra-dark\";s:4:\"name\";s:24:\"link--warning-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2822;a:4:{s:2:\"id\";s:35:\"acss_import_link--warning-semi-dark\";s:4:\"name\";s:23:\"link--warning-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2823;a:4:{s:2:\"id\";s:32:\"acss_import_link--warning-medium\";s:4:\"name\";s:20:\"link--warning-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2824;a:4:{s:2:\"id\";s:36:\"acss_import_link--warning-semi-light\";s:4:\"name\";s:24:\"link--warning-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2825;a:4:{s:2:\"id\";s:37:\"acss_import_link--warning-ultra-light\";s:4:\"name\";s:25:\"link--warning-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2826;a:4:{s:2:\"id\";s:30:\"acss_import_link--warning-comp\";s:4:\"name\";s:18:\"link--warning-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2827;a:4:{s:2:\"id\";s:33:\"acss_import_link--info-ultra-dark\";s:4:\"name\";s:21:\"link--info-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2828;a:4:{s:2:\"id\";s:32:\"acss_import_link--info-semi-dark\";s:4:\"name\";s:20:\"link--info-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2829;a:4:{s:2:\"id\";s:29:\"acss_import_link--info-medium\";s:4:\"name\";s:17:\"link--info-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2830;a:4:{s:2:\"id\";s:33:\"acss_import_link--info-semi-light\";s:4:\"name\";s:21:\"link--info-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2831;a:4:{s:2:\"id\";s:34:\"acss_import_link--info-ultra-light\";s:4:\"name\";s:22:\"link--info-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2832;a:4:{s:2:\"id\";s:27:\"acss_import_link--info-comp\";s:4:\"name\";s:15:\"link--info-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2833;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--action-ultra-dark\";s:4:\"name\";s:29:\"link-hover--action-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2834;a:4:{s:2:\"id\";s:35:\"acss_import_link-hover--action-dark\";s:4:\"name\";s:23:\"link-hover--action-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2835;a:4:{s:2:\"id\";s:40:\"acss_import_link-hover--action-semi-dark\";s:4:\"name\";s:28:\"link-hover--action-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2836;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--action-medium\";s:4:\"name\";s:25:\"link-hover--action-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2837;a:4:{s:2:\"id\";s:30:\"acss_import_link-hover--action\";s:4:\"name\";s:18:\"link-hover--action\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2838;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--action-semi-light\";s:4:\"name\";s:29:\"link-hover--action-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2839;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--action-light\";s:4:\"name\";s:24:\"link-hover--action-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2840;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--action-ultra-light\";s:4:\"name\";s:30:\"link-hover--action-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2841;a:4:{s:2:\"id\";s:35:\"acss_import_link-hover--action-comp\";s:4:\"name\";s:23:\"link-hover--action-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2842;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--action-hover\";s:4:\"name\";s:24:\"link-hover--action-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2843;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--primary-ultra-dark\";s:4:\"name\";s:30:\"link-hover--primary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2844;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--primary-dark\";s:4:\"name\";s:24:\"link-hover--primary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2845;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--primary-semi-dark\";s:4:\"name\";s:29:\"link-hover--primary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2846;a:4:{s:2:\"id\";s:38:\"acss_import_link-hover--primary-medium\";s:4:\"name\";s:26:\"link-hover--primary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2847;a:4:{s:2:\"id\";s:31:\"acss_import_link-hover--primary\";s:4:\"name\";s:19:\"link-hover--primary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2848;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--primary-semi-light\";s:4:\"name\";s:30:\"link-hover--primary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2849;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--primary-light\";s:4:\"name\";s:25:\"link-hover--primary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2850;a:4:{s:2:\"id\";s:43:\"acss_import_link-hover--primary-ultra-light\";s:4:\"name\";s:31:\"link-hover--primary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2851;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--primary-comp\";s:4:\"name\";s:24:\"link-hover--primary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2852;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--primary-hover\";s:4:\"name\";s:25:\"link-hover--primary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2853;a:4:{s:2:\"id\";s:44:\"acss_import_link-hover--secondary-ultra-dark\";s:4:\"name\";s:32:\"link-hover--secondary-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2854;a:4:{s:2:\"id\";s:38:\"acss_import_link-hover--secondary-dark\";s:4:\"name\";s:26:\"link-hover--secondary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2855;a:4:{s:2:\"id\";s:43:\"acss_import_link-hover--secondary-semi-dark\";s:4:\"name\";s:31:\"link-hover--secondary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2856;a:4:{s:2:\"id\";s:40:\"acss_import_link-hover--secondary-medium\";s:4:\"name\";s:28:\"link-hover--secondary-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2857;a:4:{s:2:\"id\";s:33:\"acss_import_link-hover--secondary\";s:4:\"name\";s:21:\"link-hover--secondary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2858;a:4:{s:2:\"id\";s:44:\"acss_import_link-hover--secondary-semi-light\";s:4:\"name\";s:32:\"link-hover--secondary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2859;a:4:{s:2:\"id\";s:39:\"acss_import_link-hover--secondary-light\";s:4:\"name\";s:27:\"link-hover--secondary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2860;a:4:{s:2:\"id\";s:45:\"acss_import_link-hover--secondary-ultra-light\";s:4:\"name\";s:33:\"link-hover--secondary-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2861;a:4:{s:2:\"id\";s:38:\"acss_import_link-hover--secondary-comp\";s:4:\"name\";s:26:\"link-hover--secondary-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2862;a:4:{s:2:\"id\";s:39:\"acss_import_link-hover--secondary-hover\";s:4:\"name\";s:27:\"link-hover--secondary-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2863;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--accent-ultra-dark\";s:4:\"name\";s:29:\"link-hover--accent-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2864;a:4:{s:2:\"id\";s:35:\"acss_import_link-hover--accent-dark\";s:4:\"name\";s:23:\"link-hover--accent-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2865;a:4:{s:2:\"id\";s:40:\"acss_import_link-hover--accent-semi-dark\";s:4:\"name\";s:28:\"link-hover--accent-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2866;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--accent-medium\";s:4:\"name\";s:25:\"link-hover--accent-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2867;a:4:{s:2:\"id\";s:30:\"acss_import_link-hover--accent\";s:4:\"name\";s:18:\"link-hover--accent\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2868;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--accent-semi-light\";s:4:\"name\";s:29:\"link-hover--accent-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2869;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--accent-light\";s:4:\"name\";s:24:\"link-hover--accent-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2870;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--accent-ultra-light\";s:4:\"name\";s:30:\"link-hover--accent-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2871;a:4:{s:2:\"id\";s:35:\"acss_import_link-hover--accent-comp\";s:4:\"name\";s:23:\"link-hover--accent-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2872;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--accent-hover\";s:4:\"name\";s:24:\"link-hover--accent-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2873;a:4:{s:2:\"id\";s:39:\"acss_import_link-hover--base-ultra-dark\";s:4:\"name\";s:27:\"link-hover--base-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2874;a:4:{s:2:\"id\";s:33:\"acss_import_link-hover--base-dark\";s:4:\"name\";s:21:\"link-hover--base-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2875;a:4:{s:2:\"id\";s:38:\"acss_import_link-hover--base-semi-dark\";s:4:\"name\";s:26:\"link-hover--base-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2876;a:4:{s:2:\"id\";s:35:\"acss_import_link-hover--base-medium\";s:4:\"name\";s:23:\"link-hover--base-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2877;a:4:{s:2:\"id\";s:28:\"acss_import_link-hover--base\";s:4:\"name\";s:16:\"link-hover--base\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2878;a:4:{s:2:\"id\";s:39:\"acss_import_link-hover--base-semi-light\";s:4:\"name\";s:27:\"link-hover--base-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2879;a:4:{s:2:\"id\";s:34:\"acss_import_link-hover--base-light\";s:4:\"name\";s:22:\"link-hover--base-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2880;a:4:{s:2:\"id\";s:40:\"acss_import_link-hover--base-ultra-light\";s:4:\"name\";s:28:\"link-hover--base-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2881;a:4:{s:2:\"id\";s:33:\"acss_import_link-hover--base-comp\";s:4:\"name\";s:21:\"link-hover--base-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2882;a:4:{s:2:\"id\";s:34:\"acss_import_link-hover--base-hover\";s:4:\"name\";s:22:\"link-hover--base-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2883;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--neutral-ultra-dark\";s:4:\"name\";s:30:\"link-hover--neutral-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2884;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--neutral-dark\";s:4:\"name\";s:24:\"link-hover--neutral-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2885;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--neutral-semi-dark\";s:4:\"name\";s:29:\"link-hover--neutral-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2886;a:4:{s:2:\"id\";s:38:\"acss_import_link-hover--neutral-medium\";s:4:\"name\";s:26:\"link-hover--neutral-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2887;a:4:{s:2:\"id\";s:31:\"acss_import_link-hover--neutral\";s:4:\"name\";s:19:\"link-hover--neutral\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2888;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--neutral-semi-light\";s:4:\"name\";s:30:\"link-hover--neutral-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2889;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--neutral-light\";s:4:\"name\";s:25:\"link-hover--neutral-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2890;a:4:{s:2:\"id\";s:43:\"acss_import_link-hover--neutral-ultra-light\";s:4:\"name\";s:31:\"link-hover--neutral-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2891;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--neutral-comp\";s:4:\"name\";s:24:\"link-hover--neutral-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2892;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--neutral-hover\";s:4:\"name\";s:25:\"link-hover--neutral-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2893;a:4:{s:2:\"id\";s:40:\"acss_import_link-hover--shade-ultra-dark\";s:4:\"name\";s:28:\"link-hover--shade-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2894;a:4:{s:2:\"id\";s:34:\"acss_import_link-hover--shade-dark\";s:4:\"name\";s:22:\"link-hover--shade-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2895;a:4:{s:2:\"id\";s:39:\"acss_import_link-hover--shade-semi-dark\";s:4:\"name\";s:27:\"link-hover--shade-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2896;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--shade-medium\";s:4:\"name\";s:24:\"link-hover--shade-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2897;a:4:{s:2:\"id\";s:29:\"acss_import_link-hover--shade\";s:4:\"name\";s:17:\"link-hover--shade\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2898;a:4:{s:2:\"id\";s:40:\"acss_import_link-hover--shade-semi-light\";s:4:\"name\";s:28:\"link-hover--shade-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2899;a:4:{s:2:\"id\";s:35:\"acss_import_link-hover--shade-light\";s:4:\"name\";s:23:\"link-hover--shade-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2900;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--shade-ultra-light\";s:4:\"name\";s:29:\"link-hover--shade-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2901;a:4:{s:2:\"id\";s:34:\"acss_import_link-hover--shade-comp\";s:4:\"name\";s:22:\"link-hover--shade-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2902;a:4:{s:2:\"id\";s:35:\"acss_import_link-hover--shade-hover\";s:4:\"name\";s:23:\"link-hover--shade-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2903;a:4:{s:2:\"id\";s:29:\"acss_import_link-hover--black\";s:4:\"name\";s:17:\"link-hover--black\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2904;a:4:{s:2:\"id\";s:29:\"acss_import_link-hover--white\";s:4:\"name\";s:17:\"link-hover--white\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2905;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--success-ultra-dark\";s:4:\"name\";s:30:\"link-hover--success-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2906;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--success-dark\";s:4:\"name\";s:24:\"link-hover--success-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2907;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--success-semi-dark\";s:4:\"name\";s:29:\"link-hover--success-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2908;a:4:{s:2:\"id\";s:38:\"acss_import_link-hover--success-medium\";s:4:\"name\";s:26:\"link-hover--success-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2909;a:4:{s:2:\"id\";s:31:\"acss_import_link-hover--success\";s:4:\"name\";s:19:\"link-hover--success\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2910;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--success-semi-light\";s:4:\"name\";s:30:\"link-hover--success-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2911;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--success-light\";s:4:\"name\";s:25:\"link-hover--success-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2912;a:4:{s:2:\"id\";s:43:\"acss_import_link-hover--success-ultra-light\";s:4:\"name\";s:31:\"link-hover--success-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2913;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--success-comp\";s:4:\"name\";s:24:\"link-hover--success-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2914;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--success-hover\";s:4:\"name\";s:25:\"link-hover--success-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2915;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--danger-ultra-dark\";s:4:\"name\";s:29:\"link-hover--danger-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2916;a:4:{s:2:\"id\";s:35:\"acss_import_link-hover--danger-dark\";s:4:\"name\";s:23:\"link-hover--danger-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2917;a:4:{s:2:\"id\";s:40:\"acss_import_link-hover--danger-semi-dark\";s:4:\"name\";s:28:\"link-hover--danger-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2918;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--danger-medium\";s:4:\"name\";s:25:\"link-hover--danger-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2919;a:4:{s:2:\"id\";s:30:\"acss_import_link-hover--danger\";s:4:\"name\";s:18:\"link-hover--danger\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2920;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--danger-semi-light\";s:4:\"name\";s:29:\"link-hover--danger-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2921;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--danger-light\";s:4:\"name\";s:24:\"link-hover--danger-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2922;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--danger-ultra-light\";s:4:\"name\";s:30:\"link-hover--danger-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2923;a:4:{s:2:\"id\";s:35:\"acss_import_link-hover--danger-comp\";s:4:\"name\";s:23:\"link-hover--danger-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2924;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--danger-hover\";s:4:\"name\";s:24:\"link-hover--danger-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2925;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--warning-ultra-dark\";s:4:\"name\";s:30:\"link-hover--warning-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2926;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--warning-dark\";s:4:\"name\";s:24:\"link-hover--warning-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2927;a:4:{s:2:\"id\";s:41:\"acss_import_link-hover--warning-semi-dark\";s:4:\"name\";s:29:\"link-hover--warning-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2928;a:4:{s:2:\"id\";s:38:\"acss_import_link-hover--warning-medium\";s:4:\"name\";s:26:\"link-hover--warning-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2929;a:4:{s:2:\"id\";s:31:\"acss_import_link-hover--warning\";s:4:\"name\";s:19:\"link-hover--warning\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2930;a:4:{s:2:\"id\";s:42:\"acss_import_link-hover--warning-semi-light\";s:4:\"name\";s:30:\"link-hover--warning-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2931;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--warning-light\";s:4:\"name\";s:25:\"link-hover--warning-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2932;a:4:{s:2:\"id\";s:43:\"acss_import_link-hover--warning-ultra-light\";s:4:\"name\";s:31:\"link-hover--warning-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2933;a:4:{s:2:\"id\";s:36:\"acss_import_link-hover--warning-comp\";s:4:\"name\";s:24:\"link-hover--warning-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2934;a:4:{s:2:\"id\";s:37:\"acss_import_link-hover--warning-hover\";s:4:\"name\";s:25:\"link-hover--warning-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2935;a:4:{s:2:\"id\";s:39:\"acss_import_link-hover--info-ultra-dark\";s:4:\"name\";s:27:\"link-hover--info-ultra-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2936;a:4:{s:2:\"id\";s:33:\"acss_import_link-hover--info-dark\";s:4:\"name\";s:21:\"link-hover--info-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2937;a:4:{s:2:\"id\";s:38:\"acss_import_link-hover--info-semi-dark\";s:4:\"name\";s:26:\"link-hover--info-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2938;a:4:{s:2:\"id\";s:35:\"acss_import_link-hover--info-medium\";s:4:\"name\";s:23:\"link-hover--info-medium\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2939;a:4:{s:2:\"id\";s:28:\"acss_import_link-hover--info\";s:4:\"name\";s:16:\"link-hover--info\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2940;a:4:{s:2:\"id\";s:39:\"acss_import_link-hover--info-semi-light\";s:4:\"name\";s:27:\"link-hover--info-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2941;a:4:{s:2:\"id\";s:34:\"acss_import_link-hover--info-light\";s:4:\"name\";s:22:\"link-hover--info-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2942;a:4:{s:2:\"id\";s:40:\"acss_import_link-hover--info-ultra-light\";s:4:\"name\";s:28:\"link-hover--info-ultra-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2943;a:4:{s:2:\"id\";s:33:\"acss_import_link-hover--info-comp\";s:4:\"name\";s:21:\"link-hover--info-comp\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2944;a:4:{s:2:\"id\";s:34:\"acss_import_link-hover--info-hover\";s:4:\"name\";s:22:\"link-hover--info-hover\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2945;a:4:{s:2:\"id\";s:24:\"acss_import_radius--none\";s:4:\"name\";s:12:\"radius--none\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2946;a:4:{s:2:\"id\";s:37:\"acss_import_marker--action-semi-light\";s:4:\"name\";s:25:\"marker--action-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2947;a:4:{s:2:\"id\";s:36:\"acss_import_marker--action-semi-dark\";s:4:\"name\";s:24:\"marker--action-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2948;a:4:{s:2:\"id\";s:38:\"acss_import_marker--primary-semi-light\";s:4:\"name\";s:26:\"marker--primary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2949;a:4:{s:2:\"id\";s:37:\"acss_import_marker--primary-semi-dark\";s:4:\"name\";s:25:\"marker--primary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2950;a:4:{s:2:\"id\";s:40:\"acss_import_marker--secondary-semi-light\";s:4:\"name\";s:28:\"marker--secondary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2951;a:4:{s:2:\"id\";s:39:\"acss_import_marker--secondary-semi-dark\";s:4:\"name\";s:27:\"marker--secondary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2952;a:4:{s:2:\"id\";s:37:\"acss_import_marker--accent-semi-light\";s:4:\"name\";s:25:\"marker--accent-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2953;a:4:{s:2:\"id\";s:36:\"acss_import_marker--accent-semi-dark\";s:4:\"name\";s:24:\"marker--accent-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2954;a:4:{s:2:\"id\";s:35:\"acss_import_marker--base-semi-light\";s:4:\"name\";s:23:\"marker--base-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2955;a:4:{s:2:\"id\";s:34:\"acss_import_marker--base-semi-dark\";s:4:\"name\";s:22:\"marker--base-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2956;a:4:{s:2:\"id\";s:38:\"acss_import_marker--neutral-semi-light\";s:4:\"name\";s:26:\"marker--neutral-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2957;a:4:{s:2:\"id\";s:37:\"acss_import_marker--neutral-semi-dark\";s:4:\"name\";s:25:\"marker--neutral-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2958;a:4:{s:2:\"id\";s:36:\"acss_import_marker--shade-semi-light\";s:4:\"name\";s:24:\"marker--shade-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2959;a:4:{s:2:\"id\";s:35:\"acss_import_marker--shade-semi-dark\";s:4:\"name\";s:23:\"marker--shade-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2960;a:4:{s:2:\"id\";s:38:\"acss_import_col-rule--action-semi-dark\";s:4:\"name\";s:26:\"col-rule--action-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2961;a:4:{s:2:\"id\";s:39:\"acss_import_col-rule--action-semi-light\";s:4:\"name\";s:27:\"col-rule--action-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2962;a:4:{s:2:\"id\";s:39:\"acss_import_col-rule--primary-semi-dark\";s:4:\"name\";s:27:\"col-rule--primary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2963;a:4:{s:2:\"id\";s:40:\"acss_import_col-rule--primary-semi-light\";s:4:\"name\";s:28:\"col-rule--primary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2964;a:4:{s:2:\"id\";s:41:\"acss_import_col-rule--secondary-semi-dark\";s:4:\"name\";s:29:\"col-rule--secondary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2965;a:4:{s:2:\"id\";s:42:\"acss_import_col-rule--secondary-semi-light\";s:4:\"name\";s:30:\"col-rule--secondary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2966;a:4:{s:2:\"id\";s:38:\"acss_import_col-rule--accent-semi-dark\";s:4:\"name\";s:26:\"col-rule--accent-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2967;a:4:{s:2:\"id\";s:39:\"acss_import_col-rule--accent-semi-light\";s:4:\"name\";s:27:\"col-rule--accent-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2968;a:4:{s:2:\"id\";s:36:\"acss_import_col-rule--base-semi-dark\";s:4:\"name\";s:24:\"col-rule--base-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2969;a:4:{s:2:\"id\";s:37:\"acss_import_col-rule--base-semi-light\";s:4:\"name\";s:25:\"col-rule--base-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2970;a:4:{s:2:\"id\";s:39:\"acss_import_col-rule--neutral-semi-dark\";s:4:\"name\";s:27:\"col-rule--neutral-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2971;a:4:{s:2:\"id\";s:40:\"acss_import_col-rule--neutral-semi-light\";s:4:\"name\";s:28:\"col-rule--neutral-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2972;a:4:{s:2:\"id\";s:37:\"acss_import_col-rule--shade-semi-dark\";s:4:\"name\";s:25:\"col-rule--shade-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2973;a:4:{s:2:\"id\";s:38:\"acss_import_col-rule--shade-semi-light\";s:4:\"name\";s:26:\"col-rule--shade-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2974;a:4:{s:2:\"id\";s:35:\"acss_import_focus--action-semi-dark\";s:4:\"name\";s:23:\"focus--action-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2975;a:4:{s:2:\"id\";s:36:\"acss_import_focus--action-semi-light\";s:4:\"name\";s:24:\"focus--action-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2976;a:4:{s:2:\"id\";s:36:\"acss_import_focus--primary-semi-dark\";s:4:\"name\";s:24:\"focus--primary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2977;a:4:{s:2:\"id\";s:37:\"acss_import_focus--primary-semi-light\";s:4:\"name\";s:25:\"focus--primary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2978;a:4:{s:2:\"id\";s:38:\"acss_import_focus--secondary-semi-dark\";s:4:\"name\";s:26:\"focus--secondary-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2979;a:4:{s:2:\"id\";s:39:\"acss_import_focus--secondary-semi-light\";s:4:\"name\";s:27:\"focus--secondary-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2980;a:4:{s:2:\"id\";s:35:\"acss_import_focus--accent-semi-dark\";s:4:\"name\";s:23:\"focus--accent-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2981;a:4:{s:2:\"id\";s:36:\"acss_import_focus--accent-semi-light\";s:4:\"name\";s:24:\"focus--accent-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2982;a:4:{s:2:\"id\";s:33:\"acss_import_focus--base-semi-dark\";s:4:\"name\";s:21:\"focus--base-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2983;a:4:{s:2:\"id\";s:34:\"acss_import_focus--base-semi-light\";s:4:\"name\";s:22:\"focus--base-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2984;a:4:{s:2:\"id\";s:36:\"acss_import_focus--neutral-semi-dark\";s:4:\"name\";s:24:\"focus--neutral-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2985;a:4:{s:2:\"id\";s:37:\"acss_import_focus--neutral-semi-light\";s:4:\"name\";s:25:\"focus--neutral-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2986;a:4:{s:2:\"id\";s:34:\"acss_import_focus--shade-semi-dark\";s:4:\"name\";s:22:\"focus--shade-semi-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2987;a:4:{s:2:\"id\";s:35:\"acss_import_focus--shade-semi-light\";s:4:\"name\";s:23:\"focus--shade-semi-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2988;a:3:{s:2:\"id\";s:6:\"skgvov\";s:4:\"name\";s:17:\"contact-6-details\";s:8:\"settings\";a:3:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:14:\"var(--space-s)\";}}i:2989;a:3:{s:2:\"id\";s:6:\"kwgxan\";s:4:\"name\";s:33:\"contact-6-details__accent-heading\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:5:\"color\";a:3:{s:2:\"id\";s:19:\"acss_import_primary\";s:4:\"name\";s:7:\"primary\";s:3:\"raw\";s:14:\"var(--primary)\";}}}}i:2990;a:3:{s:2:\"id\";s:6:\"bxfhja\";s:4:\"name\";s:26:\"contact-6-details__heading\";s:8:\"settings\";a:1:{s:7:\"_margin\";a:1:{s:3:\"top\";s:1:\"0\";}}}i:2991;a:3:{s:2:\"id\";s:6:\"ghdien\";s:4:\"name\";s:17:\"contact-6-ul-list\";s:8:\"settings\";a:4:{s:8:\"_padding\";a:1:{s:4:\"left\";s:15:\"var(--space-xs)\";}s:8:\"_display\";s:4:\"flex\";s:7:\"_rowGap\";s:14:\"var(--space-s)\";s:10:\"_direction\";s:6:\"column\";}}i:2992;a:3:{s:2:\"id\";s:6:\"dbuvwn\";s:4:\"name\";s:14:\"contact-6-list\";s:8:\"settings\";a:6:{s:17:\"_typography:hover\";a:1:{s:5:\"color\";a:3:{s:2:\"id\";s:19:\"acss_import_primary\";s:4:\"name\";s:7:\"primary\";s:3:\"raw\";s:14:\"var(--primary)\";}}s:38:\"_typography:hover .contact-6-cta__text\";a:1:{s:5:\"color\";a:3:{s:2:\"id\";s:19:\"acss_import_primary\";s:4:\"name\";s:7:\"primary\";s:3:\"raw\";s:14:\"var(--primary)\";}}s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:3:\"row\";s:11:\"_alignItems\";s:6:\"center\";s:10:\"_columnGap\";s:15:\"var(--space-xs)\";}}i:2993;a:3:{s:2:\"id\";s:6:\"ttdkkr\";s:4:\"name\";s:20:\"contact-6-list__icon\";s:8:\"settings\";a:1:{s:8:\"iconSize\";s:6:\"2.4rem\";}}i:2994;a:5:{s:2:\"id\";s:6:\"rzkgxm\";s:4:\"name\";s:20:\"contact-6-list__text\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:2:{s:10:\"text-align\";s:4:\"left\";s:5:\"color\";a:2:{s:3:\"hex\";s:7:\"#ff0073\";s:3:\"raw\";s:14:\"var(--primary)\";}}}s:8:\"modified\";i:1721422534;s:7:\"user_id\";i:1;}i:2995;a:4:{s:2:\"id\";s:24:\"acss_import_grid--auto-7\";s:4:\"name\";s:12:\"grid--auto-7\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2996;a:4:{s:2:\"id\";s:24:\"acss_import_grid--auto-8\";s:4:\"name\";s:12:\"grid--auto-8\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2997;a:4:{s:2:\"id\";s:24:\"acss_import_grid--auto-9\";s:4:\"name\";s:12:\"grid--auto-9\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2998;a:4:{s:2:\"id\";s:25:\"acss_import_grid--auto-10\";s:4:\"name\";s:13:\"grid--auto-10\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:2999;a:4:{s:2:\"id\";s:25:\"acss_import_grid--auto-11\";s:4:\"name\";s:13:\"grid--auto-11\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3000;a:4:{s:2:\"id\";s:25:\"acss_import_grid--auto-12\";s:4:\"name\";s:13:\"grid--auto-12\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3001;a:4:{s:2:\"id\";s:30:\"acss_import_btn--primary-light\";s:4:\"name\";s:18:\"btn--primary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3002;a:4:{s:2:\"id\";s:29:\"acss_import_btn--primary-dark\";s:4:\"name\";s:17:\"btn--primary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3003;a:4:{s:2:\"id\";s:32:\"acss_import_btn--secondary-light\";s:4:\"name\";s:20:\"btn--secondary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3004;a:4:{s:2:\"id\";s:31:\"acss_import_btn--secondary-dark\";s:4:\"name\";s:19:\"btn--secondary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3005;a:4:{s:2:\"id\";s:25:\"acss_import_btn--tertiary\";s:4:\"name\";s:13:\"btn--tertiary\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3006;a:4:{s:2:\"id\";s:31:\"acss_import_btn--tertiary-light\";s:4:\"name\";s:19:\"btn--tertiary-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3007;a:4:{s:2:\"id\";s:30:\"acss_import_btn--tertiary-dark\";s:4:\"name\";s:18:\"btn--tertiary-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3008;a:4:{s:2:\"id\";s:29:\"acss_import_btn--accent-light\";s:4:\"name\";s:17:\"btn--accent-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3009;a:4:{s:2:\"id\";s:28:\"acss_import_btn--accent-dark\";s:4:\"name\";s:16:\"btn--accent-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3010;a:4:{s:2:\"id\";s:27:\"acss_import_btn--base-light\";s:4:\"name\";s:15:\"btn--base-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3011;a:4:{s:2:\"id\";s:26:\"acss_import_btn--base-dark\";s:4:\"name\";s:14:\"btn--base-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3012;a:4:{s:2:\"id\";s:24:\"acss_import_btn--neutral\";s:4:\"name\";s:12:\"btn--neutral\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3013;a:4:{s:2:\"id\";s:30:\"acss_import_btn--neutral-light\";s:4:\"name\";s:18:\"btn--neutral-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3014;a:4:{s:2:\"id\";s:29:\"acss_import_btn--neutral-dark\";s:4:\"name\";s:17:\"btn--neutral-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3015;a:3:{s:2:\"id\";s:6:\"ecqxgw\";s:4:\"name\";s:28:\"fr-social-charlie__list-item\";s:8:\"settings\";a:0:{}}i:3016;a:3:{s:2:\"id\";s:6:\"crpmrl\";s:4:\"name\";s:21:\"fr-profile-hero-alpha\";s:8:\"settings\";a:0:{}}i:3017;a:3:{s:2:\"id\";s:6:\"tzzkkp\";s:4:\"name\";s:28:\"fr-profile-hero-alpha__inner\";s:8:\"settings\";a:2:{s:10:\"_cssCustom\";s:131:\".fr-profile-hero-alpha__inner {\n	display: grid;\n  grid-template-columns: 2fr 3fr;\n  align-items: stretch;\n  gap: var(--space-xl);\n}\";s:27:\"_cssCustom:mobile_landscape\";s:92:\".fr-profile-hero-alpha__inner {\n	grid-template-columns: 1fr;\n  gap: var(--fr-content-gap);\n}\";}}i:3018;a:3:{s:2:\"id\";s:6:\"turost\";s:4:\"name\";s:36:\"fr-profile-hero-alpha__image-wrapper\";s:8:\"settings\";a:3:{s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:13:\"var(--radius)\";s:5:\"right\";s:13:\"var(--radius)\";s:6:\"bottom\";s:13:\"var(--radius)\";s:4:\"left\";s:13:\"var(--radius)\";}}s:9:\"_overflow\";s:6:\"hidden\";s:9:\"_flexGrow\";s:1:\"1\";}}i:3019;a:3:{s:2:\"id\";s:6:\"ppcdso\";s:4:\"name\";s:38:\"fr-profile-hero-alpha__content-wrapper\";s:8:\"settings\";a:2:{s:7:\"_rowGap\";s:15:\"var(--space-xs)\";s:15:\"_justifyContent\";s:6:\"center\";}}i:3020;a:3:{s:2:\"id\";s:6:\"vmcqtk\";s:4:\"name\";s:28:\"fr-profile-hero-alpha__image\";s:8:\"settings\";a:3:{s:10:\"_objectFit\";s:5:\"cover\";s:6:\"_width\";s:4:\"100%\";s:7:\"_height\";s:3:\"60%\";}}i:3021;a:3:{s:2:\"id\";s:6:\"ixdjox\";s:4:\"name\";s:30:\"fr-profile-hero-alpha__heading\";s:8:\"settings\";a:0:{}}i:3022;a:3:{s:2:\"id\";s:6:\"smqkil\";s:4:\"name\";s:27:\"fr-profile-hero-alpha__lede\";s:8:\"settings\";a:0:{}}i:3023;a:3:{s:2:\"id\";s:6:\"dvffmm\";s:4:\"name\";s:28:\"fr-profile-hero-alpha__title\";s:8:\"settings\";a:0:{}}i:3024;a:5:{s:2:\"id\";s:6:\"snskte\";s:4:\"name\";s:7:\"hero-22\";s:8:\"settings\";a:3:{s:7:\"_height\";s:4:\"60vh\";s:9:\"_position\";s:8:\"relative\";s:24:\"_height:mobile_landscape\";s:5:\"64rem\";}s:8:\"modified\";i:1723047833;s:7:\"user_id\";i:1;}i:3025;a:3:{s:2:\"id\";s:6:\"vqfass\";s:4:\"name\";s:17:\"hero-22-container\";s:8:\"settings\";a:0:{}}i:3026;a:5:{s:2:\"id\";s:6:\"ommfpi\";s:4:\"name\";s:15:\"hero-22-content\";s:8:\"settings\";a:10:{s:8:\"_display\";s:4:\"flex\";s:15:\"_justifyContent\";s:6:\"center\";s:11:\"_alignItems\";s:6:\"center\";s:10:\"_direction\";s:6:\"column\";s:24:\"_height:mobile_landscape\";s:5:\"64rem\";s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";}s:8:\"modified\";i:1722960722;s:7:\"user_id\";i:1;}i:3027;a:5:{s:2:\"id\";s:6:\"yijwqq\";s:4:\"name\";s:24:\"hero-22-content__wrapper\";s:8:\"settings\";a:8:{s:6:\"_width\";s:4:\"100%\";s:9:\"_widthMax\";s:14:\"var(--width-m)\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:11:\"_alignItems\";s:6:\"center\";s:11:\"_typography\";a:2:{s:10:\"text-align\";s:6:\"center\";s:5:\"color\";a:3:{s:2:\"id\";s:17:\"acss_import_white\";s:4:\"name\";s:5:\"White\";s:3:\"raw\";s:12:\"var(--white)\";}}s:7:\"_rowGap\";s:14:\"var(--space-s)\";s:25:\"_padding:mobile_landscape\";a:2:{s:4:\"left\";s:14:\"var(--space-l)\";s:5:\"right\";s:14:\"var(--space-l)\";}}s:8:\"modified\";i:1724246527;s:7:\"user_id\";i:1;}i:3028;a:3:{s:2:\"id\";s:6:\"vwvxbb\";s:4:\"name\";s:24:\"hero-22-content__heading\";s:8:\"settings\";a:0:{}}i:3029;a:5:{s:2:\"id\";s:6:\"dwvisg\";s:4:\"name\";s:31:\"hero-22-content__accent-heading\";s:8:\"settings\";a:3:{s:7:\"_margin\";a:1:{s:6:\"bottom\";s:1:\"0\";}s:11:\"_typography\";a:3:{s:5:\"color\";a:1:{s:3:\"raw\";s:13:\"var(--accent)\";}s:14:\"text-transform\";s:9:\"uppercase\";s:11:\"font-weight\";s:3:\"700\";}s:6:\"_order\";s:2:\"-1\";}s:8:\"modified\";i:1724728501;s:7:\"user_id\";i:1;}i:3030;a:3:{s:2:\"id\";s:6:\"broiyt\";s:4:\"name\";s:27:\"hero-22-content__background\";s:8:\"settings\";a:10:{s:10:\"_objectFit\";s:5:\"cover\";s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:7:\"_zIndex\";s:2:\"-5\";s:6:\"_width\";s:4:\"100%\";s:7:\"_height\";s:4:\"100%\";s:9:\"_gradient\";a:2:{s:7:\"applyTo\";s:7:\"overlay\";s:6:\"colors\";a:2:{i:0;a:2:{s:2:\"id\";s:6:\"zlzqza\";s:5:\"color\";a:3:{s:3:\"hex\";s:7:\"#000000\";s:3:\"rgb\";s:18:\"rgba(0, 0, 0, 0.6)\";s:3:\"hsl\";s:20:\"hsla(0, 0%, 0%, 0.6)\";}}i:1;a:2:{s:2:\"id\";s:6:\"zlzqza\";s:5:\"color\";a:3:{s:3:\"hex\";s:7:\"#000000\";s:3:\"rgb\";s:18:\"rgba(0, 0, 0, 0.6)\";s:3:\"hsl\";s:20:\"hsla(0, 0%, 0%, 0.6)\";}}}}}}i:3031;a:3:{s:2:\"id\";s:6:\"hdkbnd\";s:4:\"name\";s:7:\"grid-22\";s:8:\"settings\";a:0:{}}i:3032;a:3:{s:2:\"id\";s:6:\"vekurz\";s:4:\"name\";s:17:\"grid-22-container\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:20:\"var(--container-gap)\";}}i:3033;a:3:{s:2:\"id\";s:6:\"hdtzmo\";s:4:\"name\";s:12:\"grid-22-card\";s:8:\"settings\";a:5:{s:9:\"_position\";s:8:\"relative\";s:7:\"_height\";s:5:\"36rem\";s:9:\"_overflow\";s:6:\"hidden\";s:10:\"_cssCustom\";s:1193:\"/* Card */\n\n.grid-22-card:focus-within :focus {\n	outline: none;\n  box-shadow: none;\n}\n\n.grid-22-card:focus-within {\n	box-shadow: 0 0 10px 0 var(--black-trans-10);\n\n}\n\n/* Front */\n\n.grid-22-card__front {\n	transition: .5s ease-in-out;\n  backdrop-filter: blur(10px);\n}\n\n.grid-22-card:hover .grid-22-card__front, .grid-22-card:focus-within .grid-22-card__front {\n	transform: translateY(100%);\n}\n\n.grid-22-card:hover .grid-22-card__heading, .grid-22-card:focus-within .grid-22-card__heading {\n	opacity: 0;\n}\n\n\n/* Back */\n.grid-22-card__back {\n	transition: .5s ease-in-out;\n  transform: translateY(100%);\n  opacity: 0;\n}\n\n.grid-22-card:hover .grid-22-card__back, .grid-22-card:focus-within .grid-22-card__back {\n	transform: translateY(0%);\n  opacity: 1;\n}\n\n/* Overlay */\n.grid-22-card__overlay {\n	transition: .5s ease-in-out;\n  opacity: 0;\n}\n\n.grid-22-card:hover .grid-22-card__overlay, .grid-22-card:focus-within .grid-22-card__overlay {\n  opacity: 1;\n}\n\n/* Image */\n.grid-22-card__image {\n	transition: .8s ease-in-out;\n  filter: blur(10px) grayscale(1);\n}\n\n.grid-22-card:hover .grid-22-card__image, .grid-22-card:focus-within .grid-22-card__image {\n	filter: blur(0px) grayscale(0);\n  scale: 1.1;\n}\";s:10:\"_direction\";s:6:\"column\";}}i:3034;a:5:{s:2:\"id\";s:6:\"shuiyh\";s:4:\"name\";s:19:\"grid-22-card__front\";s:8:\"settings\";a:15:{s:7:\"_zIndex\";s:1:\"3\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_height\";s:4:\"100%\";s:6:\"_width\";s:4:\"100%\";s:8:\"_padding\";a:4:{s:3:\"top\";s:14:\"var(--space-s)\";s:5:\"right\";s:14:\"var(--space-s)\";s:6:\"bottom\";s:14:\"var(--space-s)\";s:4:\"left\";s:14:\"var(--space-s)\";}s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:11:\"_typography\";a:1:{s:10:\"text-align\";s:6:\"center\";}s:11:\"_background\";a:1:{s:5:\"color\";a:3:{s:2:\"id\";s:26:\"acss_import_shade-trans-80\";s:4:\"name\";s:14:\"shade-trans-80\";s:3:\"raw\";s:21:\"var(--shade-trans-80)\";}}s:15:\"_justifyContent\";s:6:\"center\";s:11:\"_alignItems\";s:6:\"center\";}s:8:\"modified\";i:1724101282;s:7:\"user_id\";i:1;}i:3035;a:3:{s:2:\"id\";s:6:\"uwjyxl\";s:4:\"name\";s:18:\"grid-22-card__back\";s:8:\"settings\";a:14:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:7:\"_zIndex\";s:1:\"2\";s:8:\"_padding\";a:4:{s:3:\"top\";s:14:\"var(--space-m)\";s:5:\"right\";s:14:\"var(--space-m)\";s:6:\"bottom\";s:14:\"var(--space-m)\";s:4:\"left\";s:14:\"var(--space-m)\";}s:11:\"_typography\";a:2:{s:10:\"text-align\";s:6:\"center\";s:5:\"color\";a:1:{s:3:\"raw\";s:12:\"var(--white)\";}}s:11:\"_alignItems\";s:6:\"center\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:15:\"_justifyContent\";s:6:\"center\";s:9:\"_flexWrap\";s:6:\"nowrap\";}}i:3036;a:5:{s:2:\"id\";s:6:\"vtrelr\";s:4:\"name\";s:21:\"grid-22-card__heading\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:12:\"var(--white)\";}s:9:\"font-size\";s:15:\"var(--text-xxl)\";}}s:8:\"modified\";i:1724101282;s:7:\"user_id\";i:1;}i:3037;a:3:{s:2:\"id\";s:6:\"nfzvxi\";s:4:\"name\";s:18:\"grid-22-card__text\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:9:\"font-size\";s:13:\"var(--text-m)\";}}}i:3038;a:3:{s:2:\"id\";s:6:\"sybkuq\";s:4:\"name\";s:19:\"grid-22-card__image\";s:8:\"settings\";a:9:{s:10:\"_objectFit\";s:5:\"cover\";s:12:\"_aspectRatio\";s:3:\"6/4\";s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:7:\"_height\";s:4:\"100%\";s:6:\"_width\";s:4:\"100%\";}}i:3039;a:3:{s:2:\"id\";s:6:\"xbehub\";s:4:\"name\";s:21:\"grid-22-card__overlay\";s:8:\"settings\";a:7:{s:9:\"_gradient\";a:1:{s:6:\"colors\";a:2:{i:0;a:2:{s:2:\"id\";s:6:\"nvxfqo\";s:5:\"color\";a:3:{s:2:\"id\";s:26:\"acss_import_shade-trans-20\";s:4:\"name\";s:14:\"shade-trans-20\";s:3:\"raw\";s:21:\"var(--shade-trans-20)\";}}i:1;a:2:{s:2:\"id\";s:6:\"cpxpxk\";s:5:\"color\";a:3:{s:2:\"id\";s:26:\"acss_import_shade-trans-90\";s:4:\"name\";s:14:\"shade-trans-90\";s:3:\"raw\";s:21:\"var(--shade-trans-90)\";}}}}s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:7:\"_zIndex\";s:1:\"1\";}}i:3040;a:3:{s:2:\"id\";s:6:\"zptyvm\";s:4:\"name\";s:7:\"login-1\";s:8:\"settings\";a:4:{s:9:\"_overflow\";s:6:\"hidden\";s:8:\"_padding\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";}s:7:\"_height\";s:5:\"100vh\";s:23:\"_height:tablet_portrait\";s:4:\"100%\";}}i:3041;a:3:{s:2:\"id\";s:6:\"slhkkp\";s:4:\"name\";s:18:\"login-1__container\";s:8:\"settings\";a:7:{s:8:\"_display\";s:4:\"grid\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:15:\"_alignItemsGrid\";s:6:\"center\";s:36:\"_gridTemplateColumns:tablet_portrait\";s:13:\"var(--grid-1)\";s:7:\"_height\";s:4:\"100%\";s:31:\"_alignItemsGrid:tablet_portrait\";s:10:\"flex-start\";}}i:3042;a:3:{s:2:\"id\";s:6:\"tqhbuq\";s:4:\"name\";s:16:\"login-1__content\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";}}i:3043;a:3:{s:2:\"id\";s:6:\"vdgnzh\";s:4:\"name\";s:17:\"bm-login-1__media\";s:8:\"settings\";a:5:{s:6:\"_order\";s:2:\"-1\";s:8:\"_display\";s:4:\"flex\";s:11:\"_alignItems\";s:8:\"flex-end\";s:27:\"_alignItems:tablet_portrait\";s:8:\"baseline\";s:7:\"_height\";s:4:\"100%\";}}i:3044;a:5:{s:2:\"id\";s:6:\"yakifq\";s:4:\"name\";s:14:\"login-1__image\";s:8:\"settings\";a:11:{s:10:\"_objectFit\";s:5:\"cover\";s:6:\"_width\";s:4:\"50vw\";s:9:\"_widthMax\";s:4:\"50vw\";s:29:\"_aspectRatio:mobile_landscape\";s:4:\"16/9\";s:27:\"_objectFit:mobile_landscape\";s:5:\"cover\";s:23:\"_margin:tablet_portrait\";a:1:{s:4:\"left\";s:17:\" -50vw !important\";}s:22:\"_width:tablet_portrait\";s:5:\"100vw\";s:25:\"_widthMax:tablet_portrait\";s:5:\"100vw\";s:21:\"_left:tablet_portrait\";s:3:\"50%\";s:7:\"_height\";s:4:\"100%\";s:23:\"_height:tablet_portrait\";s:5:\"32rem\";}s:8:\"modified\";i:1722974952;s:7:\"user_id\";i:7;}i:3045;a:3:{s:2:\"id\";s:6:\"pbxnjk\";s:4:\"name\";s:14:\"login-1__brand\";s:8:\"settings\";a:0:{}}i:3046;a:3:{s:2:\"id\";s:6:\"aolscs\";s:4:\"name\";s:13:\"login-1__logo\";s:8:\"settings\";a:1:{s:10:\"_objectFit\";s:7:\"contain\";}}i:3047;a:3:{s:2:\"id\";s:6:\"lhofej\";s:4:\"name\";s:16:\"login-1__heading\";s:8:\"settings\";a:0:{}}i:3048;a:5:{s:2:\"id\";s:6:\"wxylfm\";s:4:\"name\";s:18:\"login-form-wrapper\";s:8:\"settings\";a:2:{s:23:\"_width:mobile_landscape\";s:4:\"100%\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";}s:8:\"modified\";i:1722396720;s:7:\"user_id\";i:7;}i:3049;a:3:{s:2:\"id\";s:6:\"msdita\";s:4:\"name\";s:10:\"login-form\";s:8:\"settings\";a:5:{s:27:\"submitButtonBackgroundColor\";a:3:{s:2:\"id\";s:19:\"acss_import_neutral\";s:4:\"name\";s:7:\"neutral\";s:3:\"raw\";s:14:\"var(--neutral)\";}s:22:\"submitButtonTypography\";a:1:{s:5:\"color\";a:3:{s:2:\"id\";s:31:\"acss_import_neutral-ultra-light\";s:4:\"name\";s:19:\"neutral-ultra-light\";s:3:\"raw\";s:26:\"var(--neutral-ultra-light)\";}}s:11:\"fieldBorder\";a:3:{s:5:\"color\";a:3:{s:2:\"id\";s:25:\"acss_import_neutral-light\";s:4:\"name\";s:13:\"neutral-light\";s:3:\"raw\";s:20:\"var(--neutral-light)\";}s:5:\"width\";a:4:{s:3:\"top\";s:5:\".1rem\";s:5:\"right\";s:5:\".1rem\";s:6:\"bottom\";s:5:\".1rem\";s:4:\"left\";s:5:\".1rem\";}s:5:\"style\";s:5:\"solid\";}s:12:\"fieldPadding\";a:4:{s:3:\"top\";s:25:\"calc(var(--space-xs) / 2)\";s:6:\"bottom\";s:25:\"calc(var(--space-xs) / 2)\";s:4:\"left\";s:15:\"var(--space-xs)\";s:5:\"right\";s:15:\"var(--space-xs)\";}s:10:\"_cssCustom\";s:352:\".login-form .form-group ul li {\n	display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n\n.login-form .form-group span {\n	display: flex;\n  flex-direction: row;\n  align-items: end;\n}\n\n.login-form .form-group span a, .login-form .form-group ul li label {\n	font-size: var(--text-s);\n}\n\n.login-form .form-group:nth-child(4) {\n    align-items: end;\n}\";}}i:3050;a:3:{s:2:\"id\";s:6:\"bfyteo\";s:4:\"name\";s:12:\"login-footer\";s:8:\"settings\";a:3:{s:8:\"_display\";s:4:\"flex\";s:9:\"_flexWrap\";s:6:\"nowrap\";s:10:\"_columnGap\";s:18:\"var(--content-gap)\";}}i:3051;a:3:{s:2:\"id\";s:6:\"fjrrkt\";s:4:\"name\";s:18:\"login-footer__link\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:9:\"font-size\";s:13:\"var(--text-s)\";}}}i:3052;a:3:{s:2:\"id\";s:6:\"ytvjsk\";s:4:\"name\";s:16:\"login-footer__li\";s:8:\"settings\";a:0:{}}i:3053;a:3:{s:2:\"id\";s:6:\"buvxnz\";s:4:\"name\";s:34:\"login-1__logged-in-heading-wrapper\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";}}i:3054;a:3:{s:2:\"id\";s:6:\"hxnmtw\";s:4:\"name\";s:26:\"login-1__logged-in-heading\";s:8:\"settings\";a:0:{}}i:3055;a:3:{s:2:\"id\";s:6:\"rxnpwv\";s:4:\"name\";s:14:\"fr-error-alpha\";s:8:\"settings\";a:2:{s:8:\"_padding\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";}s:9:\"_overflow\";s:6:\"hidden\";}}i:3056;a:3:{s:2:\"id\";s:6:\"urujcv\";s:4:\"name\";s:23:\"fr-error-alpha__content\";s:8:\"settings\";a:5:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:10:\"_columnGap\";s:18:\"var(--content-gap)\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:15:\"_justifyContent\";s:6:\"center\";}}i:3057;a:3:{s:2:\"id\";s:6:\"ztczar\";s:4:\"name\";s:21:\"fr-error-alpha__image\";s:8:\"settings\";a:9:{s:10:\"_objectFit\";s:5:\"cover\";s:6:\"_width\";s:4:\"100%\";s:10:\"_alignSelf\";s:10:\"flex-start\";s:9:\"_widthMin\";s:34:\"calc(50vw - (var(--grid-gap) / 2))\";s:10:\"_heightMin\";s:5:\"100vh\";s:7:\"_height\";s:4:\"100%\";s:26:\"_widthMin:mobile_landscape\";s:4:\"100%\";s:26:\"_cssCustom:mobile_portrait\";s:169:\".fr-error-alpha__image {\n  inline-size: 100vw !important;\n  max-inline-size: 100vw !important;\n  margin-inline: calc(-50vw + 50%) !important;\n  align-self: flex-start;\n}\";s:26:\"_heightMin:mobile_portrait\";s:4:\"100%\";}}i:3058;a:3:{s:2:\"id\";s:6:\"oiwurx\";s:4:\"name\";s:23:\"fr-error-alpha__heading\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:9:\"font-size\";s:23:\"calc(var(--text-xxl)*2)\";}}}i:3059;a:3:{s:2:\"id\";s:6:\"ucfhiz\";s:4:\"name\";s:27:\"fr-error-alpha__description\";s:8:\"settings\";a:0:{}}i:3060;a:3:{s:2:\"id\";s:6:\"cicdmh\";s:4:\"name\";s:21:\"fr-error-alpha__inner\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:17:\"_alignContentGrid\";s:7:\"stretch\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";}}i:3061;a:3:{s:2:\"id\";s:6:\"ttcnng\";s:4:\"name\";s:6:\"team-9\";s:8:\"settings\";a:0:{}}i:3062;a:3:{s:2:\"id\";s:6:\"joiamr\";s:4:\"name\";s:16:\"team-9-container\";s:8:\"settings\";a:3:{s:7:\"_rowGap\";s:14:\"var(--space-l)\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";}}i:3063;a:3:{s:2:\"id\";s:6:\"xgmzei\";s:4:\"name\";s:14:\"fr-intro-alpha\";s:8:\"settings\";a:5:{s:11:\"_alignItems\";s:6:\"center\";s:11:\"_typography\";a:1:{s:10:\"text-align\";s:6:\"center\";}s:28:\"_typography:mobile_landscape\";a:1:{s:10:\"text-align\";s:4:\"left\";}s:28:\"_alignItems:mobile_landscape\";s:10:\"flex-start\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";}}i:3064;a:3:{s:2:\"id\";s:6:\"jqevap\";s:4:\"name\";s:21:\"fr-profile-card-delta\";s:8:\"settings\";a:4:{s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:9:\"_position\";s:8:\"relative\";}}i:3065;a:3:{s:2:\"id\";s:6:\"naodck\";s:4:\"name\";s:27:\"fr-profile-card-delta__body\";s:8:\"settings\";a:5:{s:11:\"_alignItems\";s:6:\"center\";s:7:\"_rowGap\";s:28:\"calc(var(--fr-card-gap) / 2)\";s:11:\"_typography\";a:1:{s:10:\"text-align\";s:6:\"center\";}s:28:\"_typography:mobile_landscape\";a:1:{s:10:\"text-align\";s:4:\"left\";}s:28:\"_alignItems:mobile_landscape\";s:10:\"flex-start\";}}i:3066;a:3:{s:2:\"id\";s:6:\"phfaky\";s:4:\"name\";s:27:\"fr-profile-card-delta__name\";s:8:\"settings\";a:0:{}}i:3067;a:3:{s:2:\"id\";s:6:\"lssfgs\";s:4:\"name\";s:28:\"fr-profile-card-delta__title\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:11:\"line-height\";s:3:\"1.1\";}}}i:3068;a:3:{s:2:\"id\";s:6:\"lqcovj\";s:4:\"name\";s:36:\"fr-profile-card-delta__media-wrapper\";s:8:\"settings\";a:3:{s:6:\"_order\";s:2:\"-1\";s:11:\"_alignItems\";s:6:\"center\";s:28:\"_alignItems:mobile_landscape\";s:10:\"flex-start\";}}i:3069;a:3:{s:2:\"id\";s:6:\"eflohm\";s:4:\"name\";s:29:\"fr-profile-card-delta__avatar\";s:8:\"settings\";a:8:{s:10:\"_objectFit\";s:5:\"cover\";s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:3:\"50%\";s:5:\"right\";s:3:\"50%\";s:6:\"bottom\";s:3:\"50%\";s:4:\"left\";s:3:\"50%\";}}s:9:\"_overflow\";s:6:\"hidden\";s:6:\"_width\";s:3:\"8em\";s:7:\"_height\";s:3:\"8em\";s:23:\"_width:mobile_landscape\";s:3:\"6em\";s:24:\"_height:mobile_landscape\";s:3:\"6em\";s:9:\"_position\";s:6:\"static\";}}i:3070;a:3:{s:2:\"id\";s:6:\"rdvmji\";s:4:\"name\";s:10:\"yellow-box\";s:8:\"settings\";a:0:{}}i:3071;a:3:{s:2:\"id\";s:6:\"xvrjko\";s:4:\"name\";s:9:\"facet-div\";s:8:\"settings\";a:0:{}}i:3072;a:3:{s:2:\"id\";s:6:\"orirea\";s:4:\"name\";s:18:\"wpgb-scroll-target\";s:8:\"settings\";a:0:{}}i:3073;a:4:{s:2:\"id\";s:24:\"acss_import_divider--all\";s:4:\"name\";s:12:\"divider--all\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3074;a:4:{s:2:\"id\";s:23:\"acss_import_divider-top\";s:4:\"name\";s:11:\"divider-top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3075;a:4:{s:2:\"id\";s:26:\"acss_import_divider-bottom\";s:4:\"name\";s:14:\"divider-bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3076;a:4:{s:2:\"id\";s:18:\"acss_import_border\";s:4:\"name\";s:6:\"border\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3077;a:4:{s:2:\"id\";s:24:\"acss_import_border-light\";s:4:\"name\";s:12:\"border-light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3078;a:4:{s:2:\"id\";s:23:\"acss_import_border-dark\";s:4:\"name\";s:11:\"border-dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3079;a:4:{s:2:\"id\";s:22:\"acss_import_border-top\";s:4:\"name\";s:10:\"border-top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3080;a:4:{s:2:\"id\";s:28:\"acss_import_border-top--dark\";s:4:\"name\";s:16:\"border-top--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3081;a:4:{s:2:\"id\";s:29:\"acss_import_border-top--light\";s:4:\"name\";s:17:\"border-top--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3082;a:4:{s:2:\"id\";s:24:\"acss_import_border-right\";s:4:\"name\";s:12:\"border-right\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3083;a:4:{s:2:\"id\";s:30:\"acss_import_border-right--dark\";s:4:\"name\";s:18:\"border-right--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3084;a:4:{s:2:\"id\";s:31:\"acss_import_border-right--light\";s:4:\"name\";s:19:\"border-right--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3085;a:4:{s:2:\"id\";s:25:\"acss_import_border-bottom\";s:4:\"name\";s:13:\"border-bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3086;a:4:{s:2:\"id\";s:31:\"acss_import_border-bottom--dark\";s:4:\"name\";s:19:\"border-bottom--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3087;a:4:{s:2:\"id\";s:32:\"acss_import_border-bottom--light\";s:4:\"name\";s:20:\"border-bottom--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3088;a:4:{s:2:\"id\";s:23:\"acss_import_border-left\";s:4:\"name\";s:11:\"border-left\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3089;a:4:{s:2:\"id\";s:29:\"acss_import_border-left--dark\";s:4:\"name\";s:17:\"border-left--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3090;a:4:{s:2:\"id\";s:30:\"acss_import_border-left--light\";s:4:\"name\";s:18:\"border-left--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3091;a:4:{s:2:\"id\";s:24:\"acss_import_border-block\";s:4:\"name\";s:12:\"border-block\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3092;a:4:{s:2:\"id\";s:30:\"acss_import_border-block--dark\";s:4:\"name\";s:18:\"border-block--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3093;a:4:{s:2:\"id\";s:31:\"acss_import_border-block--light\";s:4:\"name\";s:19:\"border-block--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3094;a:4:{s:2:\"id\";s:25:\"acss_import_border-inline\";s:4:\"name\";s:13:\"border-inline\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3095;a:4:{s:2:\"id\";s:31:\"acss_import_border-inline--dark\";s:4:\"name\";s:19:\"border-inline--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3096;a:4:{s:2:\"id\";s:32:\"acss_import_border-inline--light\";s:4:\"name\";s:20:\"border-inline--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3097;a:4:{s:2:\"id\";s:28:\"acss_import_margin-block--xs\";s:4:\"name\";s:16:\"margin-block--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3098;a:4:{s:2:\"id\";s:27:\"acss_import_margin-block--s\";s:4:\"name\";s:15:\"margin-block--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3099;a:4:{s:2:\"id\";s:27:\"acss_import_margin-block--m\";s:4:\"name\";s:15:\"margin-block--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3100;a:4:{s:2:\"id\";s:27:\"acss_import_margin-block--l\";s:4:\"name\";s:15:\"margin-block--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3101;a:4:{s:2:\"id\";s:28:\"acss_import_margin-block--xl\";s:4:\"name\";s:16:\"margin-block--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3102;a:4:{s:2:\"id\";s:29:\"acss_import_margin-block--xxl\";s:4:\"name\";s:17:\"margin-block--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3103;a:4:{s:2:\"id\";s:29:\"acss_import_margin-inline--xs\";s:4:\"name\";s:17:\"margin-inline--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3104;a:4:{s:2:\"id\";s:28:\"acss_import_margin-inline--s\";s:4:\"name\";s:16:\"margin-inline--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3105;a:4:{s:2:\"id\";s:28:\"acss_import_margin-inline--m\";s:4:\"name\";s:16:\"margin-inline--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3106;a:4:{s:2:\"id\";s:28:\"acss_import_margin-inline--l\";s:4:\"name\";s:16:\"margin-inline--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3107;a:4:{s:2:\"id\";s:29:\"acss_import_margin-inline--xl\";s:4:\"name\";s:17:\"margin-inline--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3108;a:4:{s:2:\"id\";s:30:\"acss_import_margin-inline--xxl\";s:4:\"name\";s:18:\"margin-inline--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3109;a:4:{s:2:\"id\";s:21:\"acss_import_texture-1\";s:4:\"name\";s:9:\"texture-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3110;a:4:{s:2:\"id\";s:21:\"acss_import_texture-2\";s:4:\"name\";s:9:\"texture-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3111;a:4:{s:2:\"id\";s:21:\"acss_import_texture-3\";s:4:\"name\";s:9:\"texture-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3112;a:4:{s:2:\"id\";s:21:\"acss_import_texture-4\";s:4:\"name\";s:9:\"texture-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3113;a:4:{s:2:\"id\";s:21:\"acss_import_texture-5\";s:4:\"name\";s:9:\"texture-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3114;a:4:{s:2:\"id\";s:21:\"acss_import_overlay-1\";s:4:\"name\";s:9:\"overlay-1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3115;a:4:{s:2:\"id\";s:21:\"acss_import_overlay-2\";s:4:\"name\";s:9:\"overlay-2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3116;a:4:{s:2:\"id\";s:21:\"acss_import_overlay-3\";s:4:\"name\";s:9:\"overlay-3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3117;a:4:{s:2:\"id\";s:21:\"acss_import_overlay-4\";s:4:\"name\";s:9:\"overlay-4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3118;a:4:{s:2:\"id\";s:21:\"acss_import_overlay-5\";s:4:\"name\";s:9:\"overlay-5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3119;a:4:{s:2:\"id\";s:21:\"acss_import_icon-list\";s:4:\"name\";s:9:\"icon-list\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3120;a:3:{s:2:\"id\";s:6:\"eoeusd\";s:4:\"name\";s:24:\"fr-contact-section-hotel\";s:8:\"settings\";a:3:{s:8:\"_padding\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";}s:9:\"_overflow\";s:6:\"hidden\";s:24:\"_padding:tablet_portrait\";a:2:{s:3:\"top\";s:22:\"var(--section-space-m)\";s:6:\"bottom\";s:22:\"var(--section-space-m)\";}}}i:3121;a:3:{s:2:\"id\";s:6:\"bvhgpk\";s:4:\"name\";s:21:\"fr-contact-grid-hotel\";s:8:\"settings\";a:7:{s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:8:\"_gridGap\";s:25:\"calc(var(--grid-gap) * 2)\";s:36:\"_gridTemplateColumns:tablet_portrait\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:24:\"_gridGap:tablet_portrait\";s:15:\"var(--grid-gap)\";}}i:3122;a:3:{s:2:\"id\";s:6:\"ibb67b\";s:4:\"name\";s:38:\"fr-contact-grid-hotel__content-wrapper\";s:8:\"settings\";a:3:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:8:\"_padding\";a:2:{s:3:\"top\";s:22:\"var(--section-space-l)\";s:6:\"bottom\";s:22:\"var(--section-space-l)\";}s:24:\"_padding:tablet_portrait\";a:2:{s:6:\"bottom\";s:1:\"0\";s:3:\"top\";s:1:\"0\";}}}i:3123;a:3:{s:2:\"id\";s:6:\"nk13uw\";s:4:\"name\";s:34:\"fr-contact-grid-hotel__map-wrapper\";s:8:\"settings\";a:0:{}}i:3124;a:5:{s:2:\"id\";s:6:\"y1zn2i\";s:4:\"name\";s:26:\"fr-contact-grid-hotel__map\";s:8:\"settings\";a:4:{s:8:\"_display\";s:4:\"flex\";s:9:\"_flexGrow\";s:1:\"1\";s:22:\"_width:tablet_portrait\";s:4:\"100%\";s:25:\"_widthMax:tablet_portrait\";s:4:\"100%\";}s:8:\"modified\";i:1731952596;s:7:\"user_id\";i:1;}i:3125;a:3:{s:2:\"id\";s:6:\"i3rqjg\";s:4:\"name\";s:30:\"fr-contact-grid-hotel__heading\";s:8:\"settings\";a:0:{}}i:3126;a:3:{s:2:\"id\";s:6:\"f3hkcs\";s:4:\"name\";s:27:\"fr-contact-grid-hotel__lede\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:9:\"font-size\";s:13:\"var(--text-m)\";}}}i:3127;a:3:{s:2:\"id\";s:6:\"j6skmj\";s:4:\"name\";s:27:\"fr-contact-grid-hotel__list\";s:8:\"settings\";a:3:{s:8:\"_padding\";a:1:{s:4:\"left\";s:1:\"0\";}s:10:\"_cssCustom\";s:360:\".fr-contact-grid-hotel__list {\n	--icon-size: 24px;\n  --icon-color: var(--black);\n  --list-col-count: 2; /* 2 or 3 */\n  --list-gap: calc(var(--content-gap) / 1.5);\n}\n\n.fr-contact-grid-hotel__list {\n  display: block !important;\n	columns: var(--list-col-count) 10em;\n}\n\n.fr-contact-grid-hotel__list-item {\n	margin-bottom: var(--list-gap);\n  break-inside: avoid;\n}\";s:7:\"_margin\";a:1:{s:3:\"top\";s:14:\"var(--space-m)\";}}}i:3128;a:5:{s:2:\"id\";s:6:\"sl6gvq\";s:4:\"name\";s:32:\"fr-contact-grid-hotel__list-item\";s:8:\"settings\";a:6:{s:7:\"_rowGap\";s:15:\"var(--space-xs)\";s:10:\"_direction\";s:3:\"row\";s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:7:\"1fr 1fr\";s:17:\"_justifyItemsGrid\";s:10:\"flex-start\";s:19:\"_justifyContentGrid\";s:10:\"flex-start\";}s:8:\"modified\";i:1732401561;s:7:\"user_id\";i:1;}i:3129;a:3:{s:2:\"id\";s:6:\"2uviuz\";s:4:\"name\";s:35:\"fr-contact-grid-hotel__link-wrapper\";s:8:\"settings\";a:5:{s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:19:\"auto minmax(0, 1fr)\";s:8:\"_gridGap\";s:4:\".5em\";s:15:\"_alignItemsGrid\";s:6:\"center\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";}}i:3130;a:3:{s:2:\"id\";s:6:\"sxvjcg\";s:4:\"name\";s:27:\"fr-contact-grid-hotel__icon\";s:8:\"settings\";a:0:{}}i:3131;a:3:{s:2:\"id\";s:6:\"5kialj\";s:4:\"name\";s:28:\"fr-contact-grid-hotel__label\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:11:\"line-height\";s:3:\"1.1\";}}}i:3132;a:3:{s:2:\"id\";s:6:\"gkhnmf\";s:4:\"name\";s:26:\"fr-feature-section-charlie\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:20:\"var(--container-gap)\";}}i:3133;a:3:{s:2:\"id\";s:6:\"blgfqd\";s:4:\"name\";s:30:\"fr-intro-alpha__accent-heading\";s:8:\"settings\";a:0:{}}i:3134;a:3:{s:2:\"id\";s:6:\"tkbujj\";s:4:\"name\";s:23:\"fr-intro-alpha__heading\";s:8:\"settings\";a:2:{s:11:\"_typography\";a:1:{s:11:\"line-height\";s:3:\"1.1\";}s:28:\"_typography:mobile_landscape\";a:1:{s:9:\"font-size\";s:9:\"var(--h1)\";}}}i:3135;a:3:{s:2:\"id\";s:6:\"dizast\";s:4:\"name\";s:20:\"fr-intro-alpha__lede\";s:8:\"settings\";a:0:{}}i:3136;a:3:{s:2:\"id\";s:6:\"sangpf\";s:4:\"name\";s:23:\"fr-feature-grid-charlie\";s:8:\"settings\";a:9:{s:8:\"_display\";s:4:\"grid\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-4)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:8:\"_padding\";a:1:{s:4:\"left\";s:1:\"0\";}s:36:\"_gridTemplateColumns:tablet_portrait\";s:13:\"var(--grid-2)\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";s:10:\"_cssCustom\";s:47:\".fr-feature-grid-charlie {\n	list-style: none;\n}\";}}i:3137;a:3:{s:2:\"id\";s:6:\"eavwud\";s:4:\"name\";s:23:\"fr-feature-card-charlie\";s:8:\"settings\";a:4:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:14:\"_cssTransition\";s:3:\"all\";}}i:3138;a:3:{s:2:\"id\";s:6:\"dkvffe\";s:4:\"name\";s:29:\"fr-feature-card-charlie__body\";s:8:\"settings\";a:4:{s:6:\"_width\";s:4:\"100%\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";}}i:3139;a:3:{s:2:\"id\";s:6:\"glhqrm\";s:4:\"name\";s:32:\"fr-feature-card-charlie__heading\";s:8:\"settings\";a:0:{}}i:3140;a:3:{s:2:\"id\";s:6:\"jrtbxt\";s:4:\"name\";s:29:\"fr-feature-card-charlie__lede\";s:8:\"settings\";a:0:{}}i:3141;a:3:{s:2:\"id\";s:6:\"zmiyrz\";s:4:\"name\";s:38:\"fr-feature-card-charlie__media-wrapper\";s:8:\"settings\";a:1:{s:6:\"_order\";s:2:\"-1\";}}i:3142;a:3:{s:2:\"id\";s:6:\"qnicyz\";s:4:\"name\";s:30:\"fr-feature-card-charlie__media\";s:8:\"settings\";a:4:{s:10:\"_objectFit\";s:5:\"cover\";s:6:\"_width\";s:4:\"100%\";s:12:\"_aspectRatio\";s:4:\"16/9\";s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:13:\"var(--radius)\";s:5:\"right\";s:13:\"var(--radius)\";s:6:\"bottom\";s:13:\"var(--radius)\";s:4:\"left\";s:13:\"var(--radius)\";}}}}i:3143;a:3:{s:2:\"id\";s:6:\"cyspam\";s:4:\"name\";s:20:\"fr-faq-section-alpha\";s:8:\"settings\";a:0:{}}i:3144;a:3:{s:2:\"id\";s:6:\"ebicef\";s:4:\"name\";s:17:\"fr-faq-grid-alpha\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"grid\";s:8:\"_gridGap\";s:16:\"var(--space-xxl)\";s:20:\"_gridTemplateColumns\";s:15:\"var(--grid-2-3)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:36:\"_gridTemplateColumns:tablet_portrait\";s:13:\"var(--grid-1)\";}}i:3145;a:3:{s:2:\"id\";s:6:\"vuelmk\";s:4:\"name\";s:26:\"fr-faq-section-alpha__left\";s:8:\"settings\";a:0:{}}i:3146;a:3:{s:2:\"id\";s:6:\"lzqcxn\";s:4:\"name\";s:27:\"fr-faq-section-alpha__right\";s:8:\"settings\";a:0:{}}i:3147;a:3:{s:2:\"id\";s:6:\"eqgpav\";s:4:\"name\";s:28:\"fr-faq-section-alpha__sticky\";s:8:\"settings\";a:3:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:9:\"_position\";s:6:\"sticky\";s:4:\"_top\";s:20:\"var(--header-height)\";}}i:3148;a:3:{s:2:\"id\";s:6:\"skqvou\";s:4:\"name\";s:29:\"fr-faq-section-alpha__heading\";s:8:\"settings\";a:0:{}}i:3149;a:3:{s:2:\"id\";s:6:\"bpvrjb\";s:4:\"name\";s:26:\"fr-faq-section-alpha__lede\";s:8:\"settings\";a:0:{}}i:3150;a:3:{s:2:\"id\";s:6:\"qvacsc\";s:4:\"name\";s:22:\"fr-faq-accordion-alpha\";s:8:\"settings\";a:8:{s:11:\"headPadding\";a:4:{s:3:\"top\";s:4:\".5em\";s:6:\"bottom\";s:4:\".5em\";s:5:\"right\";s:3:\"1em\";s:4:\"left\";s:3:\"1em\";}s:23:\"iconActiveTransformTest\";a:1:{s:7:\"rotateZ\";s:3:\"180\";}s:11:\"bodyPadding\";a:4:{s:3:\"top\";s:3:\"1em\";s:5:\"right\";s:3:\"1em\";s:6:\"bottom\";s:3:\"1em\";s:4:\"left\";s:3:\"1em\";}s:19:\"headBackgroundColor\";a:1:{s:3:\"raw\";s:15:\"var(--bg-light)\";}s:8:\"headFont\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:16:\"var(--text-dark)\";}}s:19:\"iconActiveTransform\";a:1:{s:7:\"rotateZ\";s:3:\"180\";}s:15:\"iconDefaultSize\";s:3:\"2em\";s:7:\"itemGap\";s:1:\"0\";}}i:3151;a:3:{s:2:\"id\";s:6:\"awqzzs\";s:4:\"name\";s:28:\"fr-faq-accordion-alpha__item\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:1:\"0\";}}i:3152;a:3:{s:2:\"id\";s:6:\"xxbjxz\";s:4:\"name\";s:30:\"fr-faq-accordion-alpha__header\";s:8:\"settings\";a:2:{s:15:\"_justifyContent\";s:13:\"space-between\";s:10:\"_alignSelf\";s:6:\"center\";}}i:3153;a:3:{s:2:\"id\";s:6:\"binpwn\";s:4:\"name\";s:32:\"fr-faq-accordion-alpha__question\";s:8:\"settings\";a:0:{}}i:3154;a:3:{s:2:\"id\";s:6:\"unupdr\";s:4:\"name\";s:36:\"fr-faq-accordion-alpha__icon-wrapper\";s:8:\"settings\";a:0:{}}i:3155;a:3:{s:2:\"id\";s:6:\"udwneg\";s:4:\"name\";s:28:\"fr-faq-accordion-alpha__icon\";s:8:\"settings\";a:1:{s:14:\"_cssTransition\";s:26:\"transform 0.2s ease-in-out\";}}i:3156;a:3:{s:2:\"id\";s:6:\"gbsxaf\";s:4:\"name\";s:25:\"faq-accordion-alpha__body\";s:8:\"settings\";a:1:{s:6:\"_width\";s:4:\"100%\";}}i:3157;a:3:{s:2:\"id\";s:6:\"uadmmf\";s:4:\"name\";s:38:\"fr-faq-accordion-alpha__answer-wrapper\";s:8:\"settings\";a:0:{}}i:3158;a:3:{s:2:\"id\";s:6:\"ycnvsy\";s:4:\"name\";s:30:\"fr-faq-accordion-alpha__answer\";s:8:\"settings\";a:0:{}}i:3159;a:3:{s:2:\"id\";s:6:\"twhwcy\";s:4:\"name\";s:17:\"fr-cta-list-alpha\";s:8:\"settings\";a:1:{s:10:\"_cssCustom\";s:671:\".fr-cta-list-alpha {\n  \n  /* Height (thickness) of divider between list items */\n  --divider-height: 1px;\n  /* Color of divider between list items */\n  --divider-color: var(--neutral-light);\n  \n	display: grid;\n  grid-template-columns: repeat(1, 1fr);\n  align-items: stretch;\n}\n\n/* Remove all below to remove dividers */\n\n/* Remove first-child instructions to remove top divider */\n\n.fr-cta-list-alpha > *:first-child::before {\n	content: \'\';\n  width: 100%;\n  height: var(--divider-height);\n  background-color: var(--divider-color);\n}\n\n.fr-cta-list-alpha > *::after {\n	content: \'\';\n  width: 100%;\n  height: var(--divider-height);\n  background-color: var(--divider-color);\n}\";}}i:3160;a:3:{s:2:\"id\";s:6:\"pohfdw\";s:4:\"name\";s:28:\"fr-cta-list-alpha__list-item\";s:8:\"settings\";a:0:{}}i:3161;a:3:{s:2:\"id\";s:6:\"vmbkiy\";s:4:\"name\";s:24:\"fr-cta-list-alpha__label\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:9:\"font-size\";s:9:\"var(--h3)\";}}}i:3162;a:3:{s:2:\"id\";s:6:\"tpxrsp\";s:4:\"name\";s:23:\"fr-cta-list-alpha__icon\";s:8:\"settings\";a:3:{s:11:\"_typography\";a:1:{s:15:\"text-decoration\";s:4:\"none\";}s:6:\"_width\";s:3:\"2em\";s:9:\"_widthMin\";s:3:\"2em\";}}i:3163;a:3:{s:2:\"id\";s:6:\"gsnhur\";s:4:\"name\";s:31:\"fr-cta-list-alpha__link-wrapper\";s:8:\"settings\";a:10:{s:10:\"_direction\";s:3:\"row\";s:11:\"_alignItems\";s:6:\"center\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:10:\"_columnGap\";s:18:\"var(--fr-card-gap)\";s:15:\"_justifyContent\";s:13:\"space-between\";s:8:\"_padding\";a:4:{s:4:\"left\";s:22:\"var(--fr-card-padding)\";s:3:\"top\";s:22:\"var(--fr-card-padding)\";s:5:\"right\";s:22:\"var(--fr-card-padding)\";s:6:\"bottom\";s:22:\"var(--fr-card-padding)\";}s:11:\"_typography\";a:1:{s:15:\"text-decoration\";s:4:\"none\";}s:10:\"_cssCustom\";s:247:\".fr-cta-list-alpha__link-wrapper > * {\n	transition: all .3s ease;\n}\n\n.fr-cta-list-alpha__link-wrapper:hover > *:first-child {\n	transform: translateX(.5em);\n}\n\n.fr-cta-list-alpha__link-wrapper:hover > *:last-child {\n	transform: translateX(-.5em);\n}\";s:14:\"_cssTransition\";s:12:\"all .3s ease\";s:9:\"_flexWrap\";s:6:\"nowrap\";}}i:3164;a:3:{s:2:\"id\";s:6:\"lvgzec\";s:4:\"name\";s:36:\"fr-contact-card-alpha__media-wrapper\";s:8:\"settings\";a:0:{}}i:3165;a:3:{s:2:\"id\";s:6:\"tayvon\";s:4:\"name\";s:28:\"fr-contact-card-alpha__media\";s:8:\"settings\";a:3:{s:6:\"_width\";s:4:\"100%\";s:7:\"_height\";s:4:\"100%\";s:6:\"height\";s:4:\"50vh\";}}i:3166;a:3:{s:2:\"id\";s:6:\"lbzcpk\";s:4:\"name\";s:23:\"fr-contact-section-golf\";s:8:\"settings\";a:5:{s:10:\"_cssCustom\";s:49:\".fr-contact-section-golf {\n	isolation: isolate;\n}\";s:11:\"_alignItems\";s:10:\"flex-start\";s:15:\"_justifyContent\";s:10:\"flex-start\";s:9:\"_position\";s:8:\"relative\";s:7:\"_rowGap\";s:20:\"var(--container-gap)\";}}i:3167;a:3:{s:2:\"id\";s:6:\"yfdvwj\";s:4:\"name\";s:30:\"fr-contact-section-golf__inner\";s:8:\"settings\";a:10:{s:7:\"_zIndex\";s:1:\"1\";s:24:\"_padding:mobile_portrait\";a:2:{s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:10:\"_cssCustom\";s:271:\".fr-contact-section-golf__inner > *:first-child {\n  grid-column: 1/7;\n  grid-row: 1;\n}\n.fr-contact-section-golf__inner > *:nth-child(2n) {\n  grid-column: 8/end;\n  grid-row: 1/6;\n}\n\n.fr-contact-section-golf__inner > *:last-child {\n  grid-column: 1/12;\n  grid-row: 2/end;\n}\";s:27:\"_cssCustom:mobile_landscape\";s:207:\".fr-contact-section-golf__inner > *:first-child { grid-area: auto; }\n.fr-contact-section-golf__inner > *:nth-child(2n) { grid-area: auto; }\n.fr-contact-section-golf__inner > *:last-child { grid-area: auto; }\";s:25:\"_gridGap:mobile_landscape\";s:15:\"var(--grid-gap)\";s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:14:\"var(--grid-12)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-6)\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";s:34:\"_gridTemplateRows:mobile_landscape\";s:13:\"var(--grid-1)\";}}i:3168;a:3:{s:2:\"id\";s:6:\"glpzdp\";s:4:\"name\";s:32:\"fr-contact-section-golf__heading\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:17:\"var(--text-light)\";}s:9:\"font-size\";s:9:\"var(--h1)\";}}}i:3169;a:3:{s:2:\"id\";s:6:\"tqjqew\";s:4:\"name\";s:37:\"fr-contact-section-golf__info-wrapper\";s:8:\"settings\";a:7:{s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:13:\"var(--radius)\";s:5:\"right\";s:13:\"var(--radius)\";s:6:\"bottom\";s:13:\"var(--radius)\";s:4:\"left\";s:13:\"var(--radius)\";}}s:8:\"_padding\";a:4:{s:3:\"top\";s:14:\"var(--space-m)\";s:5:\"right\";s:14:\"var(--space-m)\";s:6:\"bottom\";s:14:\"var(--space-m)\";s:4:\"left\";s:14:\"var(--space-m)\";}s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:12:\"var(--white)\";}}s:7:\"_zIndex\";s:1:\"1\";s:10:\"_boxShadow\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:19:\"var(--box-shadow-l)\";}}s:11:\"_typography\";a:1:{s:10:\"font-style\";s:6:\"normal\";}}}i:3170;a:3:{s:2:\"id\";s:6:\"rnocgq\";s:4:\"name\";s:40:\"fr-contact-section-golf__contact-heading\";s:8:\"settings\";a:0:{}}i:3171;a:3:{s:2:\"id\";s:6:\"oxiicp\";s:4:\"name\";s:38:\"fr-contact-section-golf__media-wrapper\";s:8:\"settings\";a:2:{s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:13:\"var(--radius)\";s:5:\"right\";s:13:\"var(--radius)\";s:6:\"bottom\";s:13:\"var(--radius)\";s:4:\"left\";s:13:\"var(--radius)\";}}s:9:\"_overflow\";s:6:\"hidden\";}}i:3172;a:3:{s:2:\"id\";s:6:\"idyign\";s:4:\"name\";s:28:\"fr-contact-section-golf__map\";s:8:\"settings\";a:1:{s:6:\"height\";s:4:\"30em\";}}i:3173;a:5:{s:2:\"id\";s:6:\"nrfpas\";s:4:\"name\";s:24:\"fr-feature-section-alpha\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:20:\"var(--container-gap)\";}s:8:\"modified\";i:1732395175;s:7:\"user_id\";i:1;}i:3174;a:3:{s:2:\"id\";s:6:\"pdcgtq\";s:4:\"name\";s:13:\"fr-intro-echo\";s:8:\"settings\";a:7:{s:27:\"_cssCustom:mobile_landscape\";s:48:\".fr-intro-echo {\n  grid-template-columns: 1fr;\n}\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:20:\"_gridTemplateColumns\";s:15:\"var(--grid-2-1)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:8:\"_display\";s:4:\"grid\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:6:\"center\";}}i:3175;a:3:{s:2:\"id\";s:6:\"cbghev\";s:4:\"name\";s:30:\"fr-intro-echo__heading-wrapper\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:28:\"calc(var(--content-gap) / 2)\";}}i:3176;a:3:{s:2:\"id\";s:6:\"bkgkvg\";s:4:\"name\";s:22:\"fr-intro-echo__heading\";s:8:\"settings\";a:0:{}}i:3177;a:3:{s:2:\"id\";s:6:\"pdtwel\";s:4:\"name\";s:27:\"fr-intro-echo__lede-wrapper\";s:8:\"settings\";a:0:{}}i:3178;a:3:{s:2:\"id\";s:6:\"wqqaxf\";s:4:\"name\";s:19:\"fr-intro-echo__lede\";s:8:\"settings\";a:0:{}}i:3179;a:3:{s:2:\"id\";s:6:\"npdafe\";s:4:\"name\";s:21:\"fr-feature-grid-alpha\";s:8:\"settings\";a:10:{s:8:\"_display\";s:4:\"grid\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-3)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:36:\"_gridTemplateColumns:tablet_portrait\";s:13:\"var(--grid-2)\";s:36:\"_gridTemplateColumns:mobile_portrait\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:7:\"_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";}s:8:\"_padding\";a:1:{s:4:\"left\";s:1:\"0\";}s:10:\"_cssCustom\";s:50:\".fr-feature-grid-alpha {\n	list-style-type: none;\n}\";}}i:3180;a:5:{s:2:\"id\";s:6:\"syesxw\";s:4:\"name\";s:21:\"fr-feature-card-alpha\";s:8:\"settings\";a:8:{s:10:\"_direction\";s:6:\"column\";s:8:\"_display\";s:4:\"flex\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:9:\"_position\";s:8:\"relative\";s:8:\"_padding\";a:4:{s:5:\"right\";s:22:\"var(--fr-card-padding)\";s:6:\"bottom\";s:22:\"var(--fr-card-padding)\";s:4:\"left\";s:22:\"var(--fr-card-padding)\";s:3:\"top\";s:22:\"var(--fr-card-padding)\";}s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:21:\"var(--bg-ultra-light)\";}}s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:13:\"var(--radius)\";s:5:\"right\";s:13:\"var(--radius)\";s:6:\"bottom\";s:13:\"var(--radius)\";s:4:\"left\";s:13:\"var(--radius)\";}}s:10:\"_cssCustom\";s:221:\".fr-feature-card-alpha {\n	--icon-size: 2.5em;\n  --icon-fill-color: var(--text-dark);\n  --icon-stroke-color: var(--text-dark);\n  --icon-fill-color-hover: var(--text-dark);  \n  --icon-stroke-color-hover: var(--text-dark);\n}\";}s:8:\"modified\";i:1722518566;s:7:\"user_id\";i:1;}i:3181;a:3:{s:2:\"id\";s:6:\"iqefmk\";s:4:\"name\";s:35:\"fr-feature-card-alpha__icon-wrapper\";s:8:\"settings\";a:1:{s:6:\"_order\";s:2:\"-1\";}}i:3182;a:5:{s:2:\"id\";s:6:\"skpbsf\";s:4:\"name\";s:27:\"fr-feature-card-alpha__icon\";s:8:\"settings\";a:0:{}s:8:\"modified\";i:1732395175;s:7:\"user_id\";i:1;}i:3183;a:3:{s:2:\"id\";s:6:\"pgdewm\";s:4:\"name\";s:27:\"fr-feature-card-alpha__body\";s:8:\"settings\";a:4:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:9:\"_position\";s:6:\"static\";}}i:3184;a:3:{s:2:\"id\";s:6:\"zjjfvp\";s:4:\"name\";s:30:\"fr-feature-card-alpha__heading\";s:8:\"settings\";a:1:{s:9:\"_position\";s:6:\"static\";}}i:3185;a:3:{s:2:\"id\";s:6:\"fqqqnf\";s:4:\"name\";s:27:\"fr-feature-card-alpha__lede\";s:8:\"settings\";a:1:{s:7:\"_margin\";a:1:{s:3:\"top\";i:0;}}}i:3186;a:3:{s:2:\"id\";s:6:\"ramirk\";s:4:\"name\";s:32:\"feature-card-alpha__icon-wrapper\";s:8:\"settings\";a:1:{s:10:\"_cssCustom\";s:478:\".feature-card-alpha__icon-wrapper svg {\n  height: var(--icon-size);\n  width: var(--icon-size);\n  fill: var(--icon-fill-color);\n  color: var(--icon-stroke-color);\n}\n\n.feature-card-alpha__icon-wrapper i {\n  color: var(--icon-fill-color);\n  font-size: var(--icon-size);\n}\n\n.feature-card-alpha__icon-wrapper svg:hover {\n  fill: var(--icon-fill-color-hover);\n  color: var(--icon-stroke-color);  \n}\n\n.feature-card-alpha__icon-wrapper i:hover {\n  color: var(--icon-fill-color-hover);\n}\";}}i:3187;a:3:{s:2:\"id\";s:6:\"jcwknf\";s:4:\"name\";s:12:\"fr-cta-delta\";s:8:\"settings\";a:2:{s:8:\"_padding\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:15:\"var(--bg-light)\";}}}}i:3188;a:3:{s:2:\"id\";s:6:\"yzhyrl\";s:4:\"name\";s:19:\"fr-cta-delta__inner\";s:8:\"settings\";a:7:{s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:6:\"_width\";s:4:\"100%\";}}i:3189;a:3:{s:2:\"id\";s:6:\"qpqdpd\";s:4:\"name\";s:29:\"fr-cta-delta__content-wrapper\";s:8:\"settings\";a:4:{s:8:\"_padding\";a:4:{s:3:\"top\";s:15:\"var(--space-xl)\";s:5:\"right\";s:15:\"var(--space-xl)\";s:6:\"bottom\";s:15:\"var(--space-xl)\";s:4:\"left\";s:15:\"var(--space-xl)\";}s:7:\"_rowGap\";s:21:\"var(--fr-content-gap)\";s:15:\"_justifyContent\";s:6:\"center\";s:25:\"_padding:mobile_landscape\";a:2:{s:4:\"left\";s:13:\"var(--gutter)\";s:5:\"right\";s:13:\"var(--gutter)\";}}}i:3190;a:3:{s:2:\"id\";s:6:\"yotsig\";s:4:\"name\";s:27:\"fr-cta-delta__media-wrapper\";s:8:\"settings\";a:2:{s:9:\"_flexGrow\";s:1:\"1\";s:6:\"_width\";s:4:\"100%\";}}i:3191;a:3:{s:2:\"id\";s:6:\"rcagll\";s:4:\"name\";s:19:\"fr-cta-delta__media\";s:8:\"settings\";a:3:{s:10:\"_objectFit\";s:5:\"cover\";s:10:\"_cssCustom\";s:31:\".fr-cta-delta__media {flex: 1;}\";s:9:\"_flexGrow\";s:1:\"1\";}}i:3192;a:3:{s:2:\"id\";s:6:\"vfxtov\";s:4:\"name\";s:21:\"fr-cta-delta__heading\";s:8:\"settings\";a:0:{}}i:3193;a:3:{s:2:\"id\";s:6:\"lfbwnb\";s:4:\"name\";s:18:\"fr-cta-delta__lede\";s:8:\"settings\";a:0:{}}i:3194;a:3:{s:2:\"id\";s:6:\"uetren\";s:4:\"name\";s:24:\"fr-contact-section-delta\";s:8:\"settings\";a:1:{s:8:\"_padding\";a:2:{s:3:\"top\";i:0;s:6:\"bottom\";i:0;}}}i:3195;a:3:{s:2:\"id\";s:6:\"zltgtz\";s:4:\"name\";s:21:\"fr-contact-grid-delta\";s:8:\"settings\";a:7:{s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:15:\"_alignItemsGrid\";s:7:\"stretch\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";s:8:\"_gridGap\";s:16:\"var(--grid-gap) \";s:25:\"_gridGap:mobile_landscape\";s:1:\"0\";}}i:3196;a:3:{s:2:\"id\";s:6:\"yqlwgd\";s:4:\"name\";s:28:\"fr-contact-grid-delta__media\";s:8:\"settings\";a:3:{s:6:\"height\";s:4:\"100%\";s:10:\"_heightMin\";s:5:\"50rem\";s:9:\"_widthMin\";s:34:\"calc(50vw - (var(--grid-gap) / 2))\";}}i:3197;a:3:{s:2:\"id\";s:6:\"zcsxkx\";s:4:\"name\";s:35:\"fr-contact-grid-delta__info-wrapper\";s:8:\"settings\";a:7:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:28:\"_typography:mobile_landscape\";a:1:{s:10:\"font-style\";s:6:\"normal\";}s:11:\"_typography\";a:1:{s:10:\"font-style\";s:6:\"normal\";}s:15:\"_justifyContent\";s:6:\"center\";s:8:\"_padding\";a:2:{s:3:\"top\";s:22:\"var(--section-space-m)\";s:6:\"bottom\";s:22:\"var(--section-space-m)\";}}}i:3198;a:3:{s:2:\"id\";s:6:\"qxzuwb\";s:4:\"name\";s:30:\"fr-contact-grid-delta__heading\";s:8:\"settings\";a:0:{}}i:3199;a:3:{s:2:\"id\";s:6:\"zsgdhe\";s:4:\"name\";s:36:\"fr-contact-grid-delta__media-wrapper\";s:8:\"settings\";a:4:{s:6:\"_width\";s:4:\"100%\";s:7:\"_height\";s:4:\"100%\";s:8:\"_display\";s:4:\"flex\";s:15:\"_justifyContent\";s:8:\"flex-end\";}}i:3200;a:3:{s:2:\"id\";s:6:\"xszafw\";s:4:\"name\";s:35:\"fr-contact-info-bravo__icon-wrapper\";s:8:\"settings\";a:10:{s:8:\"_display\";s:4:\"flex\";s:10:\"_direction\";s:6:\"column\";s:10:\"_cssCustom\";s:496:\".fr-contact-info-bravo__icon-wrapper svg {\n  height: var(--icon-size);\n  width: var(--icon-size);\n  fill: var(--icon-fill-color);\n  color: var(--icon-stroke-color);\n}\n\n.fr-contact-info-bravo__icon-wrapper i {\n  color: var(--icon-fill-color);\n  font-size: var(--icon-size);\n}\n\n.fr-contact-info-bravo__icon-wrapper svg:hover {\n  fill: var(--icon-fill-color-hover);\n  color: var(--icon-stroke-color-hover);  \n}\n\n.fr-contact-info-bravo__icon-wrapper i:hover {\n  color: var(--icon-fill-color-hover);\n}\";s:11:\"_alignItems\";s:6:\"center\";s:6:\"_order\";s:2:\"-1\";s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:15:\"var(--bg-light)\";}}s:8:\"_padding\";a:4:{s:3:\"top\";s:4:\".5em\";s:5:\"right\";s:4:\".5em\";s:6:\"bottom\";s:4:\".5em\";s:4:\"left\";s:4:\".5em\";}s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:3:\"50%\";s:5:\"right\";s:3:\"50%\";s:6:\"bottom\";s:3:\"50%\";s:4:\"left\";s:3:\"50%\";}}s:10:\"_alignSelf\";s:6:\"center\";s:15:\"_justifyContent\";s:6:\"center\";}}i:3201;a:3:{s:2:\"id\";s:6:\"0oyvbp\";s:4:\"name\";s:16:\"cta-section-papa\";s:8:\"settings\";a:1:{s:8:\"_padding\";a:2:{s:3:\"top\";s:22:\"var(--section-space-l)\";s:6:\"bottom\";s:22:\"var(--section-space-l)\";}}}i:3202;a:5:{s:2:\"id\";s:6:\"hfbp8a\";s:4:\"name\";s:23:\"cta-section-papa__inner\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:8:\"_gridGap\";s:28:\"calc(var(--content-gap) * 3)\";s:6:\"_width\";s:15:\"var(--width-xl)\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";s:25:\"_gridGap:mobile_landscape\";s:30:\"calc(var(--content-gap) * 1.5)\";}s:8:\"modified\";i:1718755985;s:7:\"user_id\";i:1;}i:3203;a:5:{s:2:\"id\";s:6:\"n5pfaj\";s:4:\"name\";s:33:\"cta-section-papa__content-wrapper\";s:8:\"settings\";a:2:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:15:\"_justifyContent\";s:6:\"center\";}s:8:\"modified\";i:1718755418;s:7:\"user_id\";i:1;}i:3204;a:3:{s:2:\"id\";s:6:\"l5zk3a\";s:4:\"name\";s:33:\"cta-section-papa__options-wrapper\";s:8:\"settings\";a:3:{s:7:\"_margin\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";}s:8:\"_padding\";a:1:{s:4:\"left\";s:1:\"0\";}s:7:\"_rowGap\";s:18:\"var(--content-gap)\";}}i:3205;a:3:{s:2:\"id\";s:6:\"lrx9n9\";s:4:\"name\";s:25:\"cta-section-papa__heading\";s:8:\"settings\";a:0:{}}i:3206;a:3:{s:2:\"id\";s:6:\"9vnmav\";s:4:\"name\";s:28:\"cta-section-papa__text-basic\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:9:\"font-size\";s:13:\"var(--text-l)\";}}}i:3207;a:5:{s:2:\"id\";s:6:\"90uddg\";s:4:\"name\";s:22:\"cta-section-papa__link\";s:8:\"settings\";a:9:{s:6:\"_width\";s:4:\"100%\";s:8:\"_padding\";a:4:{s:3:\"top\";s:14:\"var(--space-s)\";s:5:\"right\";s:14:\"var(--space-m)\";s:6:\"bottom\";s:14:\"var(--space-s)\";s:4:\"left\";s:14:\"var(--space-m)\";}s:8:\"_display\";s:4:\"flex\";s:11:\"_alignItems\";s:6:\"center\";s:15:\"_justifyContent\";s:13:\"space-between\";s:11:\"_typography\";a:3:{s:10:\"text-align\";s:6:\"center\";s:9:\"font-size\";s:13:\"var(--text-l)\";s:15:\"text-decoration\";s:4:\"none\";}s:7:\"_border\";a:4:{s:6:\"radius\";a:4:{s:3:\"top\";s:13:\"var(--radius)\";s:5:\"right\";s:13:\"var(--radius)\";s:6:\"bottom\";s:13:\"var(--radius)\";s:4:\"left\";s:13:\"var(--radius)\";}s:5:\"width\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:5:\"style\";s:5:\"solid\";s:5:\"color\";a:1:{s:3:\"raw\";s:12:\"var(--black)\";}}s:8:\"iconSize\";s:16:\"var(--icon-size)\";s:10:\"_cssCustom\";s:648:\".cta-section-papa__link {\n  /* Icon */\n	--icon-size: 1em;\n  --icon-fill-color: transparent;\n  --icon-stroke-color: var(--black);\n  /* Background */\n  --bg: transparent;\n  --bg-hover: var(--primary);\n  /* Foreground */\n  --fg: --black;\n  --fg-hover: var(--primary-ultra-light);\n  /* Transition */\n  --timing: .3s;\n  --function: ease;\n}\n\n.cta-section-papa__link {\n  background: var(--bg);\n	color: var(--fg);\n  transition: background var(--timing) var(--function), color var(--timing) var(--function);\n}\n\n.cta-section-papa__link:hover {\n	background-color: var(--bg-hover);\n  color: var(--fg-hover);\n  --icon-stroke-color: var(--primary-ultra-light);\n}\";}s:8:\"modified\";i:1718755860;s:7:\"user_id\";i:1;}i:3208;a:5:{s:2:\"id\";s:6:\"fqyy2g\";s:4:\"name\";s:24:\"cta-section-papa__option\";s:8:\"settings\";a:0:{}s:8:\"modified\";i:1718755418;s:7:\"user_id\";i:1;}i:3209;a:5:{s:2:\"id\";s:6:\"btowpj\";s:4:\"name\";s:3:\"map\";s:8:\"settings\";a:0:{}s:8:\"modified\";i:1732973627;s:7:\"user_id\";i:1;}i:3210;a:3:{s:2:\"id\";s:6:\"fgvisf\";s:4:\"name\";s:4:\"test\";s:8:\"settings\";a:2:{s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:23:\"var(--text-light-muted)\";}}s:8:\"_padding\";a:4:{s:3:\"top\";s:14:\"var(--space-l)\";s:4:\"left\";s:14:\"var(--space-m)\";s:5:\"right\";s:14:\"var(--space-m)\";s:6:\"bottom\";s:15:\"var(--space-xs)\";}}}i:3211;a:4:{s:2:\"id\";s:27:\"acss_import_grid--auto-fill\";s:4:\"name\";s:15:\"grid--auto-fill\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3212;a:4:{s:2:\"id\";s:26:\"acss_import_grid--auto-fit\";s:4:\"name\";s:14:\"grid--auto-fit\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3213;a:4:{s:2:\"id\";s:28:\"acss_import_grid--stack-even\";s:4:\"name\";s:16:\"grid--stack-even\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3214;a:4:{s:2:\"id\";s:32:\"acss_import_grid--stack-even-xxl\";s:4:\"name\";s:20:\"grid--stack-even-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3215;a:4:{s:2:\"id\";s:31:\"acss_import_grid--stack-even-xl\";s:4:\"name\";s:19:\"grid--stack-even-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3216;a:4:{s:2:\"id\";s:30:\"acss_import_grid--stack-even-l\";s:4:\"name\";s:18:\"grid--stack-even-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3217;a:4:{s:2:\"id\";s:30:\"acss_import_grid--stack-even-m\";s:4:\"name\";s:18:\"grid--stack-even-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3218;a:4:{s:2:\"id\";s:30:\"acss_import_grid--stack-even-s\";s:4:\"name\";s:18:\"grid--stack-even-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3219;a:4:{s:2:\"id\";s:31:\"acss_import_grid--stack-even-xs\";s:4:\"name\";s:19:\"grid--stack-even-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3220;a:4:{s:2:\"id\";s:27:\"acss_import_grid--stack-any\";s:4:\"name\";s:15:\"grid--stack-any\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3221;a:4:{s:2:\"id\";s:31:\"acss_import_grid--stack-any-xxl\";s:4:\"name\";s:19:\"grid--stack-any-xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3222;a:4:{s:2:\"id\";s:30:\"acss_import_grid--stack-any-xl\";s:4:\"name\";s:18:\"grid--stack-any-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3223;a:4:{s:2:\"id\";s:29:\"acss_import_grid--stack-any-l\";s:4:\"name\";s:17:\"grid--stack-any-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3224;a:4:{s:2:\"id\";s:29:\"acss_import_grid--stack-any-m\";s:4:\"name\";s:17:\"grid--stack-any-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3225;a:4:{s:2:\"id\";s:29:\"acss_import_grid--stack-any-s\";s:4:\"name\";s:17:\"grid--stack-any-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3226;a:4:{s:2:\"id\";s:30:\"acss_import_grid--stack-any-xs\";s:4:\"name\";s:18:\"grid--stack-any-xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3227;a:4:{s:2:\"id\";s:17:\"acss_import_is-bg\";s:4:\"name\";s:5:\"is-bg\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3228;a:4:{s:2:\"id\";s:23:\"acss_import_fade--block\";s:4:\"name\";s:11:\"fade--block\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3229;a:4:{s:2:\"id\";s:24:\"acss_import_fade--inline\";s:4:\"name\";s:12:\"fade--inline\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3230;a:4:{s:2:\"id\";s:21:\"acss_import_fade--top\";s:4:\"name\";s:9:\"fade--top\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3231;a:4:{s:2:\"id\";s:23:\"acss_import_fade--right\";s:4:\"name\";s:11:\"fade--right\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3232;a:4:{s:2:\"id\";s:24:\"acss_import_fade--bottom\";s:4:\"name\";s:12:\"fade--bottom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3233;a:4:{s:2:\"id\";s:22:\"acss_import_fade--left\";s:4:\"name\";s:10:\"fade--left\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3234;a:4:{s:2:\"id\";s:23:\"acss_import_icon--boxed\";s:4:\"name\";s:11:\"icon--boxed\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3235;a:4:{s:2:\"id\";s:23:\"acss_import_icon--naked\";s:4:\"name\";s:11:\"icon--naked\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3236;a:4:{s:2:\"id\";s:19:\"acss_import_icon--s\";s:4:\"name\";s:7:\"icon--s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3237;a:4:{s:2:\"id\";s:19:\"acss_import_icon--m\";s:4:\"name\";s:7:\"icon--m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3238;a:4:{s:2:\"id\";s:19:\"acss_import_icon--l\";s:4:\"name\";s:7:\"icon--l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3239;a:3:{s:2:\"id\";s:6:\"bpvteh\";s:4:\"name\";s:21:\"dwc-header-inner-wrap\";s:8:\"settings\";a:6:{s:10:\"_direction\";s:3:\"row\";s:27:\"_direction:mobile_landscape\";s:3:\"row\";s:32:\"_justifyContent:mobile_landscape\";s:13:\"space-between\";s:15:\"_justifyContent\";s:13:\"space-between\";s:10:\"_cssCustom\";s:56:\".dwc-header-inner-wrap{\n  transition: 0.5s !important;\n}\";s:11:\"_alignItems\";s:6:\"center\";}}i:3240;a:5:{s:2:\"id\";s:6:\"ggiytu\";s:4:\"name\";s:21:\"fr-header-alpha__logo\";s:8:\"settings\";a:2:{s:7:\"_height\";s:4:\"auto\";s:6:\"_width\";s:3:\"8em\";}s:8:\"modified\";i:1727715020;s:7:\"user_id\";i:1;}i:3241;a:3:{s:2:\"id\";s:6:\"pvxmul\";s:4:\"name\";s:13:\"toggle-button\";s:8:\"settings\";a:1:{s:10:\"_cssCustom\";s:182:\".toggle-button .toggle-close-icon {\n  display: none;\n}\n\n.toggle-button.is-open .toggle-open-icon {\n  display: none;\n}\n\n.toggle-button.is-open .toggle-close-icon {\n  display: block;\n}\";}}i:3242;a:5:{s:2:\"id\";s:6:\"fpyiuj\";s:4:\"name\";s:12:\"header-icons\";s:8:\"settings\";a:4:{s:14:\"iconTypography\";a:1:{s:9:\"font-size\";s:3:\"1em\";}s:8:\"iconSize\";s:5:\"1.1em\";s:9:\"iconColor\";a:1:{s:3:\"raw\";s:16:\"var(--text-dark)\";}s:10:\"_cssCustom\";s:36:\".header-icons {\n  cursor: pointer;\n}\";}s:8:\"modified\";i:1739305818;s:7:\"user_id\";i:1;}i:3243;a:3:{s:2:\"id\";s:6:\"uagcho\";s:4:\"name\";s:16:\"toggle-open-icon\";s:8:\"settings\";a:0:{}}i:3244;a:3:{s:2:\"id\";s:6:\"ncfsud\";s:4:\"name\";s:17:\"toggle-close-icon\";s:8:\"settings\";a:0:{}}i:3245;a:3:{s:2:\"id\";s:6:\"mwsyot\";s:4:\"name\";s:22:\"fr-header-alpha__inner\";s:8:\"settings\";a:3:{s:8:\"_display\";s:4:\"flex\";s:26:\"_flexWrap:mobile_landscape\";s:6:\"nowrap\";s:11:\"_alignItems\";s:6:\"center\";}}i:3246;a:5:{s:2:\"id\";s:6:\"zduaox\";s:4:\"name\";s:10:\"header-btn\";s:8:\"settings\";a:5:{s:8:\"_padding\";a:4:{s:3:\"top\";s:6:\"0.75em\";s:6:\"bottom\";s:6:\"0.75em\";s:4:\"left\";s:6:\"1.85em\";s:5:\"right\";s:6:\"1.85em\";}s:17:\"_background:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:14:\"var(--primary)\";}}s:17:\"_typography:hover\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:16:\"var(--secondary)\";}}s:11:\"_typography\";a:2:{s:5:\"color\";a:1:{s:3:\"raw\";s:16:\"var(--text-dark)\";}s:14:\"text-transform\";s:9:\"uppercase\";}s:11:\"_background\";a:1:{s:5:\"color\";a:3:{s:3:\"hex\";s:7:\"#000000\";s:3:\"rgb\";s:16:\"rgba(0, 0, 0, 0)\";s:3:\"hsl\";s:18:\"hsla(0, 0%, 0%, 0)\";}}}s:8:\"modified\";i:1739307746;s:7:\"user_id\";i:1;}i:3247;a:5:{s:2:\"id\";s:6:\"zrsgtx\";s:4:\"name\";s:15:\"dwc-nav-trigger\";s:8:\"settings\";a:2:{s:10:\"_cssCustom\";s:948:\".dwc-nav-trigger {\n    border: none;\n    background: none;\n    padding: 20px;\n}    \n\n.dwc-nav-trigger {\n        cursor: pointer;\n        position: relative;\n        min-width: 26px !important;\n        min-height: 0 !important;\n    }\n/*\n    .dwc-nav-trigger::before {\n        left: 0;\n        right: 0;\n        transform: translateY(-5px);\n    }\n\n    .dwc-nav-trigger::after {\n        left: 10px;\n        right: 0;\n        transform: translateY(5px);\n    }\n\n    .dwc-nav-trigger::before,\n    .dwc-nav-trigger:after {\n        content: \'\';\n        position: absolute;\n        transition: 0.4s 0.3s;\n        height: 3px;\n        background:  black;\n        top: 50%;\n        border-radius: 50vw\n    }*/\n\n  #header-row-one .dwc-nav-trigger:not(.slide-up *)::before{\n        transform: translateY(0) rotate(45deg);\n    }\n\n   #header-row-one .dwc-nav-trigger:not(.slide-up *)::after{\n        transform: translateY(0) rotate(-45deg);\n        left: 0;\n    }\";s:23:\"_margin:tablet_portrait\";a:1:{s:3:\"top\";s:5:\"1.5em\";}}s:8:\"modified\";i:1720259161;s:7:\"user_id\";i:1;}i:3248;a:3:{s:2:\"id\";s:6:\"ayu9j7\";s:4:\"name\";s:18:\"cta-section-quebec\";s:8:\"settings\";a:2:{s:9:\"_position\";s:8:\"relative\";s:11:\"_typography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:12:\"var(--white)\";}}}}i:3249;a:3:{s:2:\"id\";s:6:\"gijflg\";s:4:\"name\";s:25:\"cta-section-quebec__inner\";s:8:\"settings\";a:5:{s:8:\"_display\";s:4:\"grid\";s:20:\"_gridTemplateColumns\";s:15:\"var(--grid-3-2)\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:6:\"_width\";s:15:\"var(--width-xl)\";s:37:\"_gridTemplateColumns:mobile_landscape\";s:13:\"var(--grid-1)\";}}i:3250;a:3:{s:2:\"id\";s:6:\"d15t5m\";s:4:\"name\";s:35:\"cta-section-quebec__content-wrapper\";s:8:\"settings\";a:4:{s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:15:\"_justifyContent\";s:6:\"center\";s:6:\"_width\";s:4:\"100%\";s:9:\"_widthMax\";s:4:\"45ch\";}}i:3251;a:3:{s:2:\"id\";s:6:\"rpg0n5\";s:4:\"name\";s:33:\"cta-section-quebec__media-wrapper\";s:8:\"settings\";a:1:{s:9:\"_position\";s:8:\"relative\";}}i:3252;a:3:{s:2:\"id\";s:6:\"41nofj\";s:4:\"name\";s:25:\"cta-section-quebec__media\";s:8:\"settings\";a:7:{s:10:\"_alignSelf\";s:6:\"center\";s:10:\"_cssCustom\";s:215:\".cta-section-quebec__media {\n  /* Add additional media height */\n  --media-height-offset: 60px;\n  /* No touchey */\n  position: absolute;\n  inset-block-start: 50%;\n  inset-inline-start: 50%;\n  translate: -50% -50%;\n}\";s:10:\"_objectFit\";s:7:\"contain\";s:7:\"_height\";s:39:\"calc(100% + var(--media-height-offset))\";s:6:\"_width\";s:4:\"100%\";s:24:\"_height:mobile_landscape\";s:4:\"auto\";s:26:\"_position:mobile_landscape\";s:8:\"relative\";}}i:3253;a:3:{s:2:\"id\";s:6:\"cqyo2q\";s:4:\"name\";s:27:\"cta-section-quebec__heading\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:12:\"var(--white)\";}}}}i:3254;a:3:{s:2:\"id\";s:6:\"28ingf\";s:4:\"name\";s:34:\"cta-section-quebec__accent-heading\";s:8:\"settings\";a:0:{}}i:3255;a:3:{s:2:\"id\";s:6:\"fke33z\";s:4:\"name\";s:24:\"cta-section-quebec__lede\";s:8:\"settings\";a:0:{}}i:3256;a:3:{s:2:\"id\";s:6:\"x6p1fn\";s:4:\"name\";s:26:\"cta-section-quebec__button\";s:8:\"settings\";a:1:{s:7:\"_margin\";a:1:{s:3:\"top\";s:15:\"var(--space-xs)\";}}}i:3257;a:4:{s:2:\"id\";s:36:\"acss_import_justify-content--start-s\";s:4:\"name\";s:24:\"justify-content--start-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3258;a:4:{s:2:\"id\";s:36:\"acss_import_justify-content--start-m\";s:4:\"name\";s:24:\"justify-content--start-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3259;a:4:{s:2:\"id\";s:36:\"acss_import_justify-content--start-l\";s:4:\"name\";s:24:\"justify-content--start-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3260;a:4:{s:2:\"id\";s:37:\"acss_import_justify-content--start-xl\";s:4:\"name\";s:25:\"justify-content--start-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3261;a:4:{s:2:\"id\";s:34:\"acss_import_justify-content--end-s\";s:4:\"name\";s:22:\"justify-content--end-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3262;a:4:{s:2:\"id\";s:34:\"acss_import_justify-content--end-m\";s:4:\"name\";s:22:\"justify-content--end-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3263;a:4:{s:2:\"id\";s:34:\"acss_import_justify-content--end-l\";s:4:\"name\";s:22:\"justify-content--end-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3264;a:4:{s:2:\"id\";s:35:\"acss_import_justify-content--end-xl\";s:4:\"name\";s:23:\"justify-content--end-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3265;a:4:{s:2:\"id\";s:37:\"acss_import_justify-content--center-s\";s:4:\"name\";s:25:\"justify-content--center-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3266;a:4:{s:2:\"id\";s:37:\"acss_import_justify-content--center-m\";s:4:\"name\";s:25:\"justify-content--center-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3267;a:4:{s:2:\"id\";s:37:\"acss_import_justify-content--center-l\";s:4:\"name\";s:25:\"justify-content--center-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3268;a:4:{s:2:\"id\";s:38:\"acss_import_justify-content--center-xl\";s:4:\"name\";s:26:\"justify-content--center-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3269;a:4:{s:2:\"id\";s:38:\"acss_import_justify-content--between-s\";s:4:\"name\";s:26:\"justify-content--between-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3270;a:4:{s:2:\"id\";s:38:\"acss_import_justify-content--between-m\";s:4:\"name\";s:26:\"justify-content--between-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3271;a:4:{s:2:\"id\";s:38:\"acss_import_justify-content--between-l\";s:4:\"name\";s:26:\"justify-content--between-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3272;a:4:{s:2:\"id\";s:39:\"acss_import_justify-content--between-xl\";s:4:\"name\";s:27:\"justify-content--between-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3273;a:4:{s:2:\"id\";s:37:\"acss_import_justify-content--around-s\";s:4:\"name\";s:25:\"justify-content--around-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3274;a:4:{s:2:\"id\";s:37:\"acss_import_justify-content--around-m\";s:4:\"name\";s:25:\"justify-content--around-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3275;a:4:{s:2:\"id\";s:37:\"acss_import_justify-content--around-l\";s:4:\"name\";s:25:\"justify-content--around-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3276;a:4:{s:2:\"id\";s:38:\"acss_import_justify-content--around-xl\";s:4:\"name\";s:26:\"justify-content--around-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3277;a:4:{s:2:\"id\";s:38:\"acss_import_justify-content--stretch-s\";s:4:\"name\";s:26:\"justify-content--stretch-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3278;a:4:{s:2:\"id\";s:38:\"acss_import_justify-content--stretch-m\";s:4:\"name\";s:26:\"justify-content--stretch-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3279;a:4:{s:2:\"id\";s:38:\"acss_import_justify-content--stretch-l\";s:4:\"name\";s:26:\"justify-content--stretch-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3280;a:4:{s:2:\"id\";s:39:\"acss_import_justify-content--stretch-xl\";s:4:\"name\";s:27:\"justify-content--stretch-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3281;a:4:{s:2:\"id\";s:34:\"acss_import_justify-items--start-s\";s:4:\"name\";s:22:\"justify-items--start-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3282;a:4:{s:2:\"id\";s:34:\"acss_import_justify-items--start-m\";s:4:\"name\";s:22:\"justify-items--start-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3283;a:4:{s:2:\"id\";s:34:\"acss_import_justify-items--start-l\";s:4:\"name\";s:22:\"justify-items--start-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3284;a:4:{s:2:\"id\";s:35:\"acss_import_justify-items--start-xl\";s:4:\"name\";s:23:\"justify-items--start-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3285;a:4:{s:2:\"id\";s:32:\"acss_import_justify-items--end-s\";s:4:\"name\";s:20:\"justify-items--end-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3286;a:4:{s:2:\"id\";s:32:\"acss_import_justify-items--end-m\";s:4:\"name\";s:20:\"justify-items--end-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3287;a:4:{s:2:\"id\";s:32:\"acss_import_justify-items--end-l\";s:4:\"name\";s:20:\"justify-items--end-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3288;a:4:{s:2:\"id\";s:33:\"acss_import_justify-items--end-xl\";s:4:\"name\";s:21:\"justify-items--end-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3289;a:4:{s:2:\"id\";s:35:\"acss_import_justify-items--center-s\";s:4:\"name\";s:23:\"justify-items--center-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3290;a:4:{s:2:\"id\";s:35:\"acss_import_justify-items--center-m\";s:4:\"name\";s:23:\"justify-items--center-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3291;a:4:{s:2:\"id\";s:35:\"acss_import_justify-items--center-l\";s:4:\"name\";s:23:\"justify-items--center-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3292;a:4:{s:2:\"id\";s:36:\"acss_import_justify-items--center-xl\";s:4:\"name\";s:24:\"justify-items--center-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3293;a:4:{s:2:\"id\";s:36:\"acss_import_justify-items--stretch-s\";s:4:\"name\";s:24:\"justify-items--stretch-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3294;a:4:{s:2:\"id\";s:36:\"acss_import_justify-items--stretch-m\";s:4:\"name\";s:24:\"justify-items--stretch-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3295;a:4:{s:2:\"id\";s:36:\"acss_import_justify-items--stretch-l\";s:4:\"name\";s:24:\"justify-items--stretch-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3296;a:4:{s:2:\"id\";s:37:\"acss_import_justify-items--stretch-xl\";s:4:\"name\";s:25:\"justify-items--stretch-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3297;a:4:{s:2:\"id\";s:34:\"acss_import_align-content--start-s\";s:4:\"name\";s:22:\"align-content--start-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3298;a:4:{s:2:\"id\";s:34:\"acss_import_align-content--start-m\";s:4:\"name\";s:22:\"align-content--start-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3299;a:4:{s:2:\"id\";s:34:\"acss_import_align-content--start-l\";s:4:\"name\";s:22:\"align-content--start-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3300;a:4:{s:2:\"id\";s:35:\"acss_import_align-content--start-xl\";s:4:\"name\";s:23:\"align-content--start-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3301;a:4:{s:2:\"id\";s:32:\"acss_import_align-content--end-s\";s:4:\"name\";s:20:\"align-content--end-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3302;a:4:{s:2:\"id\";s:32:\"acss_import_align-content--end-m\";s:4:\"name\";s:20:\"align-content--end-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3303;a:4:{s:2:\"id\";s:32:\"acss_import_align-content--end-l\";s:4:\"name\";s:20:\"align-content--end-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3304;a:4:{s:2:\"id\";s:33:\"acss_import_align-content--end-xl\";s:4:\"name\";s:21:\"align-content--end-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3305;a:4:{s:2:\"id\";s:35:\"acss_import_align-content--center-s\";s:4:\"name\";s:23:\"align-content--center-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3306;a:4:{s:2:\"id\";s:35:\"acss_import_align-content--center-m\";s:4:\"name\";s:23:\"align-content--center-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3307;a:4:{s:2:\"id\";s:35:\"acss_import_align-content--center-l\";s:4:\"name\";s:23:\"align-content--center-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3308;a:4:{s:2:\"id\";s:36:\"acss_import_align-content--center-xl\";s:4:\"name\";s:24:\"align-content--center-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3309;a:4:{s:2:\"id\";s:37:\"acss_import_align-content--baseline-s\";s:4:\"name\";s:25:\"align-content--baseline-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3310;a:4:{s:2:\"id\";s:37:\"acss_import_align-content--baseline-m\";s:4:\"name\";s:25:\"align-content--baseline-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3311;a:4:{s:2:\"id\";s:37:\"acss_import_align-content--baseline-l\";s:4:\"name\";s:25:\"align-content--baseline-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3312;a:4:{s:2:\"id\";s:38:\"acss_import_align-content--baseline-xl\";s:4:\"name\";s:26:\"align-content--baseline-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3313;a:4:{s:2:\"id\";s:36:\"acss_import_align-content--stretch-s\";s:4:\"name\";s:24:\"align-content--stretch-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3314;a:4:{s:2:\"id\";s:36:\"acss_import_align-content--stretch-m\";s:4:\"name\";s:24:\"align-content--stretch-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3315;a:4:{s:2:\"id\";s:36:\"acss_import_align-content--stretch-l\";s:4:\"name\";s:24:\"align-content--stretch-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3316;a:4:{s:2:\"id\";s:37:\"acss_import_align-content--stretch-xl\";s:4:\"name\";s:25:\"align-content--stretch-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3317;a:4:{s:2:\"id\";s:32:\"acss_import_align-items--start-s\";s:4:\"name\";s:20:\"align-items--start-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3318;a:4:{s:2:\"id\";s:32:\"acss_import_align-items--start-m\";s:4:\"name\";s:20:\"align-items--start-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3319;a:4:{s:2:\"id\";s:32:\"acss_import_align-items--start-l\";s:4:\"name\";s:20:\"align-items--start-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3320;a:4:{s:2:\"id\";s:33:\"acss_import_align-items--start-xl\";s:4:\"name\";s:21:\"align-items--start-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3321;a:4:{s:2:\"id\";s:30:\"acss_import_align-items--end-s\";s:4:\"name\";s:18:\"align-items--end-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3322;a:4:{s:2:\"id\";s:30:\"acss_import_align-items--end-m\";s:4:\"name\";s:18:\"align-items--end-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3323;a:4:{s:2:\"id\";s:30:\"acss_import_align-items--end-l\";s:4:\"name\";s:18:\"align-items--end-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3324;a:4:{s:2:\"id\";s:31:\"acss_import_align-items--end-xl\";s:4:\"name\";s:19:\"align-items--end-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3325;a:4:{s:2:\"id\";s:33:\"acss_import_align-items--center-s\";s:4:\"name\";s:21:\"align-items--center-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3326;a:4:{s:2:\"id\";s:33:\"acss_import_align-items--center-m\";s:4:\"name\";s:21:\"align-items--center-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3327;a:4:{s:2:\"id\";s:33:\"acss_import_align-items--center-l\";s:4:\"name\";s:21:\"align-items--center-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3328;a:4:{s:2:\"id\";s:34:\"acss_import_align-items--center-xl\";s:4:\"name\";s:22:\"align-items--center-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3329;a:4:{s:2:\"id\";s:35:\"acss_import_align-items--baseline-s\";s:4:\"name\";s:23:\"align-items--baseline-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3330;a:4:{s:2:\"id\";s:35:\"acss_import_align-items--baseline-m\";s:4:\"name\";s:23:\"align-items--baseline-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3331;a:4:{s:2:\"id\";s:35:\"acss_import_align-items--baseline-l\";s:4:\"name\";s:23:\"align-items--baseline-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3332;a:4:{s:2:\"id\";s:36:\"acss_import_align-items--baseline-xl\";s:4:\"name\";s:24:\"align-items--baseline-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3333;a:4:{s:2:\"id\";s:34:\"acss_import_align-items--stretch-s\";s:4:\"name\";s:22:\"align-items--stretch-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3334;a:4:{s:2:\"id\";s:34:\"acss_import_align-items--stretch-m\";s:4:\"name\";s:22:\"align-items--stretch-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3335;a:4:{s:2:\"id\";s:34:\"acss_import_align-items--stretch-l\";s:4:\"name\";s:22:\"align-items--stretch-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3336;a:4:{s:2:\"id\";s:35:\"acss_import_align-items--stretch-xl\";s:4:\"name\";s:23:\"align-items--stretch-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3337;a:4:{s:2:\"id\";s:25:\"acss_import_self--start-s\";s:4:\"name\";s:13:\"self--start-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3338;a:4:{s:2:\"id\";s:25:\"acss_import_self--start-m\";s:4:\"name\";s:13:\"self--start-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3339;a:4:{s:2:\"id\";s:25:\"acss_import_self--start-l\";s:4:\"name\";s:13:\"self--start-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3340;a:4:{s:2:\"id\";s:26:\"acss_import_self--start-xl\";s:4:\"name\";s:14:\"self--start-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3341;a:4:{s:2:\"id\";s:23:\"acss_import_self--end-s\";s:4:\"name\";s:11:\"self--end-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3342;a:4:{s:2:\"id\";s:23:\"acss_import_self--end-m\";s:4:\"name\";s:11:\"self--end-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3343;a:4:{s:2:\"id\";s:23:\"acss_import_self--end-l\";s:4:\"name\";s:11:\"self--end-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3344;a:4:{s:2:\"id\";s:24:\"acss_import_self--end-xl\";s:4:\"name\";s:12:\"self--end-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3345;a:4:{s:2:\"id\";s:26:\"acss_import_self--center-s\";s:4:\"name\";s:14:\"self--center-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3346;a:4:{s:2:\"id\";s:26:\"acss_import_self--center-m\";s:4:\"name\";s:14:\"self--center-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3347;a:4:{s:2:\"id\";s:26:\"acss_import_self--center-l\";s:4:\"name\";s:14:\"self--center-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3348;a:4:{s:2:\"id\";s:27:\"acss_import_self--center-xl\";s:4:\"name\";s:15:\"self--center-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3349;a:4:{s:2:\"id\";s:27:\"acss_import_self--stretch-s\";s:4:\"name\";s:15:\"self--stretch-s\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3350;a:4:{s:2:\"id\";s:27:\"acss_import_self--stretch-m\";s:4:\"name\";s:15:\"self--stretch-m\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3351;a:4:{s:2:\"id\";s:27:\"acss_import_self--stretch-l\";s:4:\"name\";s:15:\"self--stretch-l\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3352;a:4:{s:2:\"id\";s:28:\"acss_import_self--stretch-xl\";s:4:\"name\";s:16:\"self--stretch-xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3353;a:4:{s:2:\"id\";s:25:\"acss_import_line-clamp--1\";s:4:\"name\";s:13:\"line-clamp--1\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3354;a:4:{s:2:\"id\";s:25:\"acss_import_line-clamp--2\";s:4:\"name\";s:13:\"line-clamp--2\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3355;a:4:{s:2:\"id\";s:25:\"acss_import_line-clamp--3\";s:4:\"name\";s:13:\"line-clamp--3\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3356;a:4:{s:2:\"id\";s:25:\"acss_import_line-clamp--4\";s:4:\"name\";s:13:\"line-clamp--4\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3357;a:4:{s:2:\"id\";s:25:\"acss_import_line-clamp--5\";s:4:\"name\";s:13:\"line-clamp--5\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3358;a:4:{s:2:\"id\";s:30:\"acss_import_line-clamp--custom\";s:4:\"name\";s:18:\"line-clamp--custom\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3359;a:4:{s:2:\"id\";s:23:\"acss_import_icon--light\";s:4:\"name\";s:11:\"icon--light\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3360;a:4:{s:2:\"id\";s:22:\"acss_import_icon--dark\";s:4:\"name\";s:10:\"icon--dark\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3361;a:4:{s:2:\"id\";s:20:\"acss_import_icon--xs\";s:4:\"name\";s:8:\"icon--xs\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3362;a:4:{s:2:\"id\";s:20:\"acss_import_icon--xl\";s:4:\"name\";s:8:\"icon--xl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3363;a:4:{s:2:\"id\";s:21:\"acss_import_icon--xxl\";s:4:\"name\";s:9:\"icon--xxl\";s:8:\"settings\";a:0:{}s:8:\"category\";s:4:\"acss\";}i:3364;a:5:{s:2:\"id\";s:6:\"agqnqy\";s:4:\"name\";s:10:\"bm-hero-64\";s:8:\"settings\";a:5:{s:11:\"_alignItems\";s:10:\"flex-start\";s:7:\"_height\";s:4:\"85vh\";s:9:\"_position\";s:8:\"relative\";s:15:\"_justifyContent\";s:6:\"center\";s:10:\"_isolation\";s:7:\"isolate\";}s:8:\"modified\";i:1767970165;s:7:\"user_id\";i:1;}i:3365;a:5:{s:2:\"id\";s:6:\"bnhlps\";s:4:\"name\";s:21:\"bm-hero-64__container\";s:8:\"settings\";a:4:{s:11:\"_typography\";a:1:{s:5:\"color\";a:3:{s:2:\"id\";s:17:\"acss_import_white\";s:4:\"name\";s:5:\"white\";s:3:\"raw\";s:12:\"var(--white)\";}}s:11:\"_alignItems\";s:6:\"center\";s:7:\"_rowGap\";s:18:\"var(--content-gap)\";s:15:\"_justifyContent\";s:10:\"flex-start\";}s:8:\"modified\";i:1767970165;s:7:\"user_id\";i:1;}i:3366;a:5:{s:2:\"id\";s:6:\"anpakh\";s:4:\"name\";s:19:\"bm-hero-64__content\";s:8:\"settings\";a:4:{s:7:\"_rowGap\";s:28:\"calc(var(--content-gap) * 3)\";s:11:\"_typography\";a:1:{s:5:\"color\";a:3:{s:2:\"id\";s:17:\"acss_import_white\";s:4:\"name\";s:5:\"white\";s:3:\"raw\";s:12:\"var(--white)\";}}s:11:\"_alignItems\";s:10:\"flex-start\";s:24:\"_rowGap:mobile_landscape\";s:18:\"var(--content-gap)\";}s:8:\"modified\";i:1761598614;s:7:\"user_id\";i:1;}i:3367;a:3:{s:2:\"id\";s:6:\"rnsrig\";s:4:\"name\";s:15:\"bm-hero-64__top\";s:8:\"settings\";a:6:{s:7:\"_rowGap\";s:14:\"var(--space-s)\";s:6:\"_width\";s:4:\"100%\";s:9:\"_widthMax\";s:14:\"var(--width-l)\";s:11:\"_typography\";a:1:{s:10:\"text-align\";s:6:\"center\";}s:10:\"_alignSelf\";s:6:\"center\";s:11:\"_alignItems\";s:6:\"center\";}}i:3368;a:3:{s:2:\"id\";s:6:\"jnydka\";s:4:\"name\";s:19:\"bm-hero-64__heading\";s:8:\"settings\";a:1:{s:11:\"_typography\";a:1:{s:9:\"font-size\";s:21:\"calc(var(--h1) * 1.4)\";}}}i:3369;a:5:{s:2:\"id\";s:6:\"zmjswc\";s:4:\"name\";s:22:\"bm-hero-64__subheading\";s:8:\"settings\";a:2:{s:6:\"_width\";s:4:\"100%\";s:9:\"_widthMax\";s:14:\"var(--width-m)\";}s:8:\"modified\";i:1769718930;s:7:\"user_id\";i:1;}i:3370;a:5:{s:2:\"id\";s:6:\"fhimks\";s:4:\"name\";s:9:\"cta-combo\";s:8:\"settings\";a:6:{s:8:\"_display\";s:4:\"flex\";s:11:\"_alignItems\";s:6:\"center\";s:10:\"_columnGap\";s:28:\"calc(var(--content-gap) / 2)\";s:23:\"_rowGap:mobile_portrait\";s:28:\"calc(var(--content-gap) / 2)\";s:27:\"_alignItems:mobile_portrait\";s:10:\"flex-start\";s:26:\"_direction:mobile_portrait\";s:6:\"column\";}s:8:\"modified\";i:1751657186;s:7:\"user_id\";i:7;}i:3371;a:3:{s:2:\"id\";s:6:\"mcfysf\";s:4:\"name\";s:9:\"btn--link\";s:8:\"settings\";a:3:{s:8:\"_padding\";a:2:{s:4:\"left\";s:1:\"0\";s:5:\"right\";s:1:\"0\";}s:11:\"_background\";a:1:{s:5:\"color\";a:3:{s:2:\"id\";s:23:\"acss_import_transparent\";s:4:\"name\";s:11:\"transparent\";s:3:\"raw\";s:11:\"transparent\";}}s:6:\"_width\";s:4:\"100%\";}}i:3372;a:5:{s:2:\"id\";s:6:\"vckvrw\";s:4:\"name\";s:17:\"bm-hero-64__image\";s:8:\"settings\";a:11:{s:9:\"_position\";s:8:\"absolute\";s:4:\"_top\";s:1:\"0\";s:6:\"_right\";s:1:\"0\";s:7:\"_bottom\";s:1:\"0\";s:5:\"_left\";s:1:\"0\";s:7:\"_zIndex\";s:2:\"-1\";s:10:\"_objectFit\";s:5:\"cover\";s:7:\"_height\";s:4:\"100%\";s:6:\"_width\";s:4:\"100%\";s:9:\"_gradient\";a:2:{s:7:\"applyTo\";s:7:\"overlay\";s:6:\"colors\";a:2:{i:0;a:2:{s:2:\"id\";s:6:\"mkdmip\";s:5:\"color\";a:1:{s:3:\"raw\";s:11:\"transparent\";}}i:1;a:3:{s:2:\"id\";s:6:\"qeagkv\";s:5:\"color\";a:3:{s:3:\"hex\";s:7:\"#000000\";s:3:\"rgb\";s:19:\"rgba(0, 0, 0, 0.59)\";s:3:\"hsl\";s:21:\"hsla(0, 0%, 0%, 0.59)\";}s:4:\"stop\";s:3:\"100\";}}}s:15:\"_objectPosition\";s:6:\"bottom\";}s:8:\"modified\";i:1766179627;s:7:\"user_id\";i:1;}i:3373;a:5:{s:2:\"id\";s:6:\"cuednq\";s:4:\"name\";s:18:\"bm-hero-64__footer\";s:8:\"settings\";a:7:{s:10:\"_direction\";s:3:\"row\";s:15:\"_justifyContent\";s:6:\"center\";s:11:\"_alignItems\";s:8:\"flex-end\";s:26:\"_direction:tablet_portrait\";s:14:\"column-reverse\";s:27:\"_alignItems:tablet_portrait\";s:10:\"flex-start\";s:31:\"_justifyContent:tablet_portrait\";s:10:\"flex-start\";s:23:\"_rowGap:tablet_portrait\";s:18:\"var(--content-gap)\";}s:8:\"modified\";i:1753355955;s:7:\"user_id\";i:7;}i:3374;a:3:{s:2:\"id\";s:6:\"81pcsa\";s:4:\"name\";s:22:\"feature-section-havana\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:30:\"calc(var(--content-gap) * 1.5)\";}}i:3375;a:3:{s:2:\"id\";s:6:\"sd18ac\";s:4:\"name\";s:45:\"feature-section-havana__slider-wrapper-havana\";s:8:\"settings\";a:1:{s:7:\"_rowGap\";s:14:\"var(--space-s)\";}}i:3376;a:3:{s:2:\"id\";s:6:\"wbfkbf\";s:4:\"name\";s:29:\"fr-intro-echo__accent-heading\";s:8:\"settings\";a:0:{}}i:3377;a:5:{s:2:\"id\";s:6:\"rzadtp\";s:4:\"name\";s:21:\"feature-slider-havana\";s:8:\"settings\";a:1:{s:6:\"_width\";s:4:\"100%\";}s:8:\"modified\";i:1738829616;s:7:\"user_id\";i:9;}i:3378;a:3:{s:2:\"id\";s:6:\"zz0uka\";s:4:\"name\";s:28:\"feature-slider-havana__slide\";s:8:\"settings\";a:0:{}}i:3379;a:3:{s:2:\"id\";s:6:\"jhxm4u\";s:4:\"name\";s:19:\"feature-card-havana\";s:8:\"settings\";a:5:{s:7:\"_rowGap\";s:15:\"var(--card-gap)\";s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:28:\"var(--light-card-background)\";}}s:8:\"_padding\";a:4:{s:3:\"top\";s:35:\"var(--card-padding, var(--space-m))\";s:5:\"right\";s:35:\"var(--card-padding, var(--space-m))\";s:6:\"bottom\";s:35:\"var(--card-padding, var(--space-m))\";s:4:\"left\";s:35:\"var(--card-padding, var(--space-m))\";}s:7:\"_border\";a:1:{s:6:\"radius\";a:4:{s:3:\"top\";s:18:\"var(--card-radius)\";s:5:\"right\";s:18:\"var(--card-radius)\";s:6:\"bottom\";s:18:\"var(--card-radius)\";s:4:\"left\";s:18:\"var(--card-radius)\";}}s:9:\"_flexGrow\";s:1:\"1\";}}i:3380;a:3:{s:2:\"id\";s:6:\"mxzkwf\";s:4:\"name\";s:28:\"feature-card-havana__heading\";s:8:\"settings\";a:0:{}}i:3381;a:3:{s:2:\"id\";s:6:\"3s92ht\";s:4:\"name\";s:32:\"feature-card-havana__description\";s:8:\"settings\";a:1:{s:7:\"_margin\";a:1:{s:6:\"bottom\";s:14:\"var(--space-s)\";}}}i:3382;a:3:{s:2:\"id\";s:6:\"bvdbdd\";s:4:\"name\";s:25:\"feature-card-havana__link\";s:8:\"settings\";a:4:{s:12:\"iconPosition\";s:5:\"right\";s:10:\"_cssCustom\";s:57:\".feature-card-havana__link svg {\n  color: currentColor;\n}\";s:7:\"_margin\";a:1:{s:3:\"top\";s:4:\"auto\";}s:8:\"iconSize\";s:3:\"1em\";}}i:3383;a:5:{s:2:\"id\";s:6:\"lqqjec\";s:4:\"name\";s:31:\"feature-slider-havana__controls\";s:8:\"settings\";a:2:{s:6:\"_width\";s:22:\"max-content !important\";s:10:\"_alignSelf\";s:8:\"flex-end\";}s:8:\"modified\";i:1737981592;s:7:\"user_id\";i:1;}i:3384;a:5:{s:2:\"id\";s:6:\"ieofwl\";s:4:\"name\";s:7:\"fr-note\";s:8:\"settings\";a:3:{s:10:\"_cssCustom\";s:370:\".fr-note {\n  padding: var(--card-padding, var(--space-m));\n  border-radius: var(--card-radius, var(--radius));\n  background: var(--warning-light, #FDEBB5);\n  color: var(--warning-ultra-dark, #544002);\n  margin-inline: auto;\n}\n\n.fr-note * + :is(h2, h3, h4) {\n  margin-top: var(--heading-spacing);\n  color: var(--text-dark);\n}\n\n.fr-note a {\n  text-decoration: underline;\n}\";s:6:\"_width\";s:4:\"60ch\";s:11:\"_typography\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:22:\"var(--text-dark-muted)\";}}}s:8:\"modified\";i:1744306417;s:7:\"user_id\";i:9;}i:3385;a:5:{s:2:\"id\";s:6:\"bhlwph\";s:4:\"name\";s:16:\"footer-amsterdam\";s:8:\"settings\";a:2:{s:10:\"_cssCustom\";s:116:\".footer-amsterdam a {\n  color: var(--text-light-muted);\n}\n\n.footer-amsterdam a:hover {\n  color: var(--text-light);\n}\";s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:14:\"var(--bg-dark)\";}}}s:8:\"modified\";i:1733445804;s:7:\"user_id\";i:9;}i:3386;a:5:{s:2:\"id\";s:6:\"lujjnr\";s:4:\"name\";s:20:\"footer-amsterdam-top\";s:8:\"settings\";a:3:{s:17:\"_alignContentGrid\";s:7:\"stretch\";s:11:\"_background\";a:1:{s:5:\"color\";a:1:{s:3:\"raw\";s:15:\"var(--bg-light)\";}}s:8:\"_padding\";a:2:{s:3:\"top\";s:22:\"var(--section-space-s)\";s:6:\"bottom\";s:22:\"var(--section-space-s)\";}}s:8:\"modified\";i:1733619979;s:7:\"user_id\";i:9;}i:3387;a:3:{s:2:\"id\";s:6:\"9x1uhc\";s:4:\"name\";s:27:\"footer-amsterdam-top__inner\";s:8:\"settings\";a:9:{s:8:\"_display\";s:4:\"grid\";s:8:\"_gridGap\";s:15:\"var(--grid-gap)\";s:20:\"_gridTemplateColumns\";s:13:\"var(--grid-2)\";s:17:\"_gridTemplateRows\";s:13:\"var(--grid-1)\";s:8:\"_padding\";a:1:{s:4:\"left\";s:1:\"0\";}s:10:\"_cssCustom\";s:53:\".footer-amsterdam-top__inner {list-style-type: none;}\";s:36:\"_gridTemplateColumns:tablet_portrait\";s:13:\"var(--grid-2)\";s:36:\"_gridTemplateColumns:mobile_portrait\";s:13:\"var(--grid-1)\";s:17:\"_justifyItemsGrid\";s:6:\"center\";}}i:3388;a:5:{s:2:\"id\";s:6:\"xtodmg\";s:4:\"name\";s:23:\"fr-feature-card-foxtrot\";s:8:\"settings\";a:10:{s:10:\"_direction\";s:6:\"column\";s:10:\"_columnGap\";s:18:\"var(--fr-card-gap)\";s:7:\"_rowGap\";s:18:\"var(--fr-card-gap)\";s:26:\"_flexWrap:mobile_landscape\";s:6:\"nowrap\";s:10:\"_cssCustom\";s:206:\".fr-feature-card-foxtrot {\n	--icon-size: 1.5em;\n  --icon-color: var(--neutral);\n}\n\n.fr-feature-card-foxtrot :is(svg, i) {\n  color: var(--icon-color);\n  height: var(--icon-size);\n  width: var(--icon-size);\n}\";s:8:\"_display\";s:4:\"flex\";s:11:\"_alignItems\";s:10:\"flex-start\";s:6:\"_width\";s:25:\"calc(var(--width-m)*0.75)\";s:27:\"_alignItems:mobile_portrait\";s:6:\"center\";s:27:\"_typography:mobile_portrait\";a:1:{s:10:\"text-align\";s:6:\"center\";}}s:8:\"modified\";i:1734008811;s:7:\"user_id\";i:9;}i:3389;a:3:{s:2:\"id\";s:6:\"ngmkpl\";s:4:\"name\";s:38:\"fr-feature-card-foxtrot__media-wrapper\";s:8:\"settings\";a:5:{s:6:\"_order\";