<?php
namespace BricksUltimate\Admin;

use Bricks\Helpers;
use Bricks\Capabilities;

/**
 * Class AdminMenuBar
 *
 * @package BricksUltimate\Admin
 */
class AdminMenuBar {
	private $url;
	function __construct() {
		if( ! class_exists('Bricks\Capabilities') )
			return;

		$this->url = \BricksUltimate\Plugin::BU_SITE_URL;

		add_action( 'admin_bar_menu', [ $this, 'bu_add_link_to_admin_bar' ], 999 );

		if ( Capabilities::current_user_has_full_access() ) {
			add_action('wp_head', [ $this, 'styleAdminBar'] );
			add_action('admin_head', [ $this, 'styleAdminBar'] );
		}
	}

	public function styleAdminBar() {
		echo "<style type='text/css'>
			#wp-admin-bar-bu-general-elements,
			#wp-admin-bar-bu-doc{border-top: 1px solid hsla(0,0%,87%,.25); margin-top: 10px!important; padding-top: 5px!important;}
			#wp-admin-bar-bu-parent-item-default .ab-sub-wrapper {
				overflow-x: hidden;
				overflow-y: auto;
				max-height: 75vh;
			}
			#wp-admin-bar-bu-parent-item-default .ab-submenu .dashicons, 
			#wp-admin-bar-bu-parent-item-default .ab-submenu .dashicons-before:before {
				font-family: dashicons;
			}

			#wp-admin-bar-bu-parent-item-default .ab-submenu li{
				display: flex;
				margin-right: 1px;
				align-items: center;
				justify-content: space-between;
			}
		</style>";
	}

	public function bu_add_link_to_admin_bar( $admin_bar ) {
		if ( ! Capabilities::current_user_can_use_builder() ) {
			return;
		}

		/*if ( is_admin() && get_current_screen()->base !== 'post' ) {
			return;
		}*/

		$menu_name = __( 'BricksUltimate', "bricksultimate" );
		$menu_slug = 'bricksultimate';

		$buwl = get_option('buwl');
		if( $buwl ) {
			$menu_name = ! empty( $buwl['menu_name'] ) ? esc_html( $buwl['menu_name'] ) : $menu_name;
			$menu_slug = ! empty( $buwl['menu_slug'] ) ? esc_html( $buwl['menu_slug'] ) : $menu_slug;
		}

		// bricksultimate parent menu
		$admin_bar->add_node([
			'id'    => 'bu-parent-item',
			'title' => $menu_name,
			'href' 	=> esc_url( admin_url( 'admin.php?page=' . $menu_slug ) ),
		]);

		$this->cpts_built_with_bricks( $admin_bar );

		//* General Elements sub menu item
		$admin_bar->add_node([
			'parent' => 'bu-parent-item',
			'id'     => 'bu-general-elements',
			'title'  => esc_html__( 'General Elements', 'bricksultimate' ),
			'href'   => esc_url( admin_url( 'admin.php?page=' . $menu_slug ) ),
		]);

		if( class_exists( 'WooCommerce' ) ) {
			//* Woo Elements sub menu
			$admin_bar->add_node([
				'parent' => 'bu-parent-item',
				'id'     => 'bu-woo-elements',
				'title'  => esc_html__( 'Woo Elements', 'bricksultimate' ),
				'href'   => esc_url( admin_url( 'admin.php?page=' . $menu_slug . '&tab=woo' ) ),
			]);

			if( ! empty( \BricksUltimate\Plugin::$bu_settings['myaccount_custom_ep'] ) && 
				\BricksUltimate\Plugin::$bu_settings['myaccount_custom_ep'] == 'enabled' ) {
				$admin_bar->add_node([
					'parent' => 'bu-parent-item',
					'id'     => 'bu-maep-tab',
					'title'  => esc_html__( 'Custom Endpoints', 'bricksultimate' ),
					'href'   => esc_url( admin_url( 'admin.php?page=' . $menu_slug . '&tab=maep' ) ),
				]);
			}

			if( ! empty( \BricksUltimate\Plugin::$bu_settings['orderbumps'] ) && 
				\BricksUltimate\Plugin::$bu_settings['orderbumps'] == 'enabled' ) {
				$admin_bar->add_node([
					'parent' => 'bu-parent-item',
					'id'     => 'bu-ob-tab',
					'title'  => esc_html__( 'Order Bumps', 'bricksultimate' ),
					'href'   => esc_url( admin_url( 'edit.php?post_type=bu_order_bumps' ) ),
				]);
			}

			if( ! empty( \BricksUltimate\Plugin::$bu_settings['linked_variation'] ) && 
				\BricksUltimate\Plugin::$bu_settings['linked_variation'] == 'enabled' ) {
				$admin_bar->add_node([
					'parent' => 'bu-parent-item',
					'id'     => 'bu-lv-tab',
					'title'  => esc_html__( 'Linked Variations', 'bricksultimate' ),
					'href'   => esc_url( admin_url( 'edit.php?post_type=bu_linked_variations' ) ),
				]);
			}
		}

		$admin_bar->add_node([
			'parent' => 'bu-parent-item',
			'id'     => 'bu-misc-tab',
			'title'  => esc_html__( 'Misc', 'bricksultimate' ),
			'href'   => esc_url( admin_url( 'admin.php?page=' . $menu_slug . '&tab=misc' ) ),
		]);

		$admin_bar->add_node([
			'parent' => 'bu-parent-item',
			'id'     => 'bu-doc',
			'title'  => esc_html__( 'Documentation', 'bricksultimate' ),
			'href'   => esc_url( $this->url . 'documentations/bricksultimate/' ),
			'meta' => array('target' => '_blank' )
		]);

		$admin_bar->add_node([
			'parent' => 'bu-parent-item',
			'id'     => 'bu-support',
			'title'  => esc_html__( 'Customer Support', 'bricksultimate' ),
			'href'   => esc_url( $this->url . 'mu-account/' ),
			'meta' => array('target' => '_blank' )
		]);

		$admin_bar->add_node([
			'parent' => 'bu-parent-item',
			'id'     => 'bu-community',
			'title'  => esc_html__( 'Facebook Group', 'bricksultimate' ),
			'href'   => esc_url( 'https://www.facebook.com/groups/bultimate' ),
			'meta' => array('target' => '_blank' )
		]);

		$admin_bar->add_node([
			'parent' => 'bu-parent-item',
			'id'     => 'bu-tutorials',
			'title'  => esc_html__( 'Bricks Tutorials', 'bricksultimate' ),
			'href'   => esc_url( $this->url . 'tutorials/' ),
			'meta' => array('target' => '_blank' )
		]);

		$admin_bar->add_node([
			'parent' => 'bu-parent-item',
			'id'     => 'bu-ask-tutorials',
			'title'  => esc_html__( 'Request Tutorials', 'bricksultimate' ),
			'href'   => esc_url( $this->url . 'request-tutorials/' ),
			'meta' => array('target' => '_blank' )
		]);

		$admin_bar->add_node([
			'parent' => 'bu-parent-item',
			'id'     => 'bu-features',
			'title'  => esc_html__( 'Features Request', 'bricksultimate' ),
			'href'   => esc_url( $this->url . 'request-tutorials/' ),
			'meta' => array('target' => '_blank' )
		]);
	}

	private function cpts_built_with_bricks( $admin_bar )
	{
		$supported_post_types = Helpers::get_supported_post_types();
		$supported_post_types['bricks_template'] = 'Bricks Templates';

		if( $supported_post_types ) :
			foreach( $supported_post_types as $type => $name ) :

				$posts = get_posts([
					'post_type' 				=> $type,
					'posts_per_page' 			=> -1,
					'post_status' 				=> 'any',
					'no_found_rows' 			=> true,
					'update_post_term_cache' 	=> false,
					'meta_query'    			=> [
						[
							'key'     => BRICKS_DB_EDITOR_MODE,
							'value'   => 'bricks',
							'compare' => '=',
						],
					],
				]);

				if( $posts ) 
				{
					$cpt = get_post_type_object( $type );

					if( ! $cpt )
						return;

					$admin_bar->add_node([
						'parent' => 'bu-parent-item',
						'id'     => 'bu-' . $type,
						'title'  => __('Edit') . ' ' . ( ( $type == 'bricks_template' ) ? 'Bricks Templates' : wp_kses_post( $cpt->labels->name ) ),
						'href'   => esc_url( admin_url( 'edit.php?post_type=' . $type ) ),
					]);

					foreach( $posts as $post ) 
					{
						$admin_bar->add_node([
							'parent' => 'bu-' . $type,
							'id'     => 'bu-' . $type . '-' . $post->ID,
							'title'  => wp_kses_post( $post->post_title ),
							'href'   => esc_url( Helpers::get_builder_edit_link( $post->ID ) ),
							'meta' 	=> [
								'html' => '<a href="' . get_permalink( $post->ID ) . '" target="_blank" title="Preview"><span class="dashicons dashicons-visibility"></span></a>',
								'title' => "Edit with bricks"
							]
						]);
					} //endforeach
				} //endif
			endforeach;
		endif;
	}
}