<?php
namespace BricksUltimate\Admin;

if ( ! class_exists('WP_List_Table') ) {
     require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}

class EndpointsListTable extends \WP_List_Table
{
	public function prepare_items()
	{
		$columns = $this->get_columns();
		$hidden = array();
		$sortable = array();
		$primary  = 'title';
		$this->_column_headers = array($columns, $hidden, $sortable, $primary);

		$this->items = $this->get_data();
	}

	// Define table columns
	public function get_columns()
	{
		$columns = array(
			'cb' 	=> '<input type="checkbox" />',
			'title' 	=> __('Name', 'bricksultimate'),
			'slug' 	=> __('Slug', 'bricksultimate'),
			'mask' 	=> __('Mask', 'bricksultimate'),
			'page' 	=> __('Page', 'bricksultimate'),
		);

		return $columns;
	}

	public function column_default($item, $column_name)
	{
		switch ($column_name) {
			case 'mask':
				$mask = $item[$column_name];
				return ( $mask == 'OR' ) ? "EP_ROOT | EP_PAGES" : $mask;
			case 'page':
				return ( $item[$column_name] == 'account' ) ? __('My Account', 'woocommerce') : __('Checkout', 'woocommerce');
			case 'title':
			case 'slug':
			default:
				return $item[$column_name];
		}
	}

	public function column_cb($item)
	{
		return sprintf(
			'<input type="checkbox" name="maeps[]" value="%s" />',
			$item['id']
		);
	}

	public function get_data() {
		$data = get_option('bu_endpoints');
		if( empty( $data ) )
			return [];
		else
			return maybe_unserialize( $data );
	}

	public function no_items() {
		_e( 'No endpoints found.' );
	}

	protected function get_default_primary_column_name() {
		return 'title';
	}

	protected function handle_row_actions( $item, $column_name, $primary ) {
		if ( $primary !== $column_name ) {
			return '';
		}

		// Restores the more descriptive, specific name for use within this method.
		$url = add_query_arg( 'tab', 'maep', menu_page_url( $this->_args['pageslug'], false ) );
		$edit_link = $url . '&action=edit&edit=' . $item['id'];
		$del_link = $url . '&action=delete&delete=' . $item['id'];

		$actions           = array();
		$actions['edit']   = '<a href="' . $edit_link . '">' . __( 'Edit' ) . '</a>';
		$actions['delete'] = sprintf(
			'<a class="submitdelete" href="%s" onclick="return confirm( \'%s\' );">%s</a>',
			$del_link,
			/* translators: %s: Link name. */
			esc_js( sprintf( __( "You are about to delete this endpoint '%s'\n 'Cancel' to stop, 'OK' to delete." ), $item['title'] ) ),
			__( 'Delete' )
		);
		
		if( class_exists( 'Bricks\Templates' ) ) {
			$template_data = \Bricks\Templates::get_templates_by_type( 'wc_account_' . str_replace( [ '-', ' '], '_', $item['slug'] ) );
			$editwithbricks = ( $template_data ) ? \Bricks\Helpers::get_builder_edit_link( $template_data[0] ) : admin_url( 'edit.php?post_type=bricks_template', false );
			$actions['editwithbricks']   = '<a href="' . $editwithbricks . '">' . __( 'Edit with Bricks', 'bricks' ) . '</a>';
		}

		return $this->row_actions( $actions );
	}

	protected function get_sortable_columns()
	{
		$sortable_columns = array(
			'title'  	=> array('title', false),
		);
		return $sortable_columns;
	}
}