<?php
namespace BricksUltimate\Admin;

use Bricks\Setup;

class TermsColumns {
	function __construct() {
		add_action( 'admin_init', [ $this, 'bu_taxonomy_add_columns' ] );
	}

	public function bu_taxonomy_add_columns() {
		
		if( !class_exists('Bricks\Setup') )
			return;

		$taxonomies = Setup::get_taxonomies_options();
		if( $taxonomies ) {
			foreach( $taxonomies as $taxonomy => $title ) {
				add_action( "manage_edit-{$taxonomy}_columns", [$this, 'add_custom_columns' ] );
				add_action( "manage_{$taxonomy}_custom_column", [$this, 'tax_add_value_custom_columns' ], 10, 3 );
			}
		}
	}

	public function add_custom_columns( $columns ) {
		$new_cols['cb'] = array_shift( $columns );
		$new_cols['term_id'] = esc_html__('Term ID', 'bricksultimate');
    	
    	return array_merge( $new_cols, $columns );
	}

	public function tax_add_value_custom_columns( $content,$column_name,$term_id ) {

		if ($column_name == 'term_id' ) {
			$content = $term_id;
		}

    	return $content;
	}
}