<?php
namespace BricksUltimate\Admin\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait ImportExportForm {
	private function bu_export_import_settings( $settings, $menu_slug ) {
		$url = add_query_arg( 'tab', 'impexp', menu_page_url( $menu_slug, false ) );

		$els = get_option('bu_active_els');
		$wcels = get_option('bu_active_wcels');
	?>
		<h2><?php _e( 'Import / Export Settings', 'bricksultimate' ); ?></h2>
		<p class="description">You can import or export the settings from one site to another site.</p>
		<form method="post" action="<?php echo $url; ?>" class="export-import-form">
			<table class="form-table">
				<tbody>
					<tr valign="top" style="border-top: 1px solid #dadada;">
						<th scope="row" valign="top">
							<?php _e( 'Misc Data' ); ?>
						</th>
						<td>
							<textarea id="export_settings" name="bu_export_settings" rows="9"><?php if( ! empty( $settings ) ) { echo maybe_serialize( $settings ); } ?></textarea>
							<p class="description">Copy this data and paste into the Import Misc Data box</p>
						</td>
					</tr>

					<tr valign="top">
						<th scope="row" valign="top">
							<?php _e( 'Import Misc Data' ); ?>
						</th>
						<td>
							<textarea id="import_misc" name="bu_import_misc" rows="7" placeholder="Paste Exported Misc Data here."></textarea>
						</td>
					</tr>

					<tr valign="top" style="border-top: 1px solid #dadada;">
						<th scope="row" valign="top">
							<?php _e( 'Active General Elements' ); ?>
						</th>
						<td>
							<textarea id="el_settings" name="bu_el_settings" rows="5"><?php if( ! empty( $els ) ) { echo maybe_serialize( $els ); } ?></textarea>
							<p class="description">Copy this data and paste into the Import Active General Elements box</p>
						</td>
					</tr>

					<tr valign="top">
						<th scope="row" valign="top">
							<?php _e( 'Import Active General Elements' ); ?>
						</th>
						<td>
							<textarea id="import_el" name="bu_import_el" rows="7" placeholder="Paste Active General Elements data here"></textarea>
						</td>
					</tr>

					<tr valign="top" style="border-top: 1px solid #dadada;">
						<th scope="row" valign="top">
							<?php _e( 'Active Woo Elements' ); ?>
						</th>
						<td>
							<textarea id="export_settings" name="bu_wcel_settings" rows="5"><?php if( ! empty( $wcels ) ) { echo maybe_serialize( $wcels ); } ?></textarea>
							<p class="description">Copy this data and paste into the Import Active Woo Elements box</p>
						</td>
					</tr>

					<tr valign="top">
						<th scope="row" valign="top">
							<?php _e( 'Import Active Woo Elements' ); ?>
						</th>
						<td>
							<textarea id="import_wcel" name="bu_import_wcel" rows="7" placeholder="Paste Active Woo Elements data here"></textarea>
						</td>

					<tr valign="top">
						<th colspan="2">
							<input type="submit" class="button button-primary" name="bu_import_data" value="<?php _e( 'Submit' ); ?>"/>
						</th>
					</tr>
				</tbody>
			</table>
			<?php wp_nonce_field( 'bu_nonce_action', 'bu_nonce_field' ); ?>
		</form>
		<?php
	}
}