<?php
namespace BricksUltimate\Admin\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait Misc {
	/**
	 * Misc settings
	 */
	public function bu_misc_settings( $settings ) {
		if( ! class_exists('Bricks\Templates') )
			return;

		$url = add_query_arg( 'tab', 'misc', menu_page_url( $this->menu_slug, false ) );
		if ( isset( $_POST[ 'action' ] ) && $_POST[ 'action' ] == "save_misc_data" ) {
			printf('<div class="notice notice-info is-dismissible"><p>%s</p></div>', __('Settings saved successfully.', 'bricksultimate'));
		}
	?>
		<div class="header-bar cols-2">
			<h3>Miscellaneous Settings</h3>
			<a href="https://www.bricksultimate.com/documentations/bricksultimate/misc.php/" target="_blank" class="user-guide">User Guide</a>
		</div>

		<form method="post" action="<?php echo $url; ?>">
			<table id="tab-misc">
				<tbody>
					<tr>
						<th>
							<label for="adminbar">Show admin bar in the editor</label>
						</th>
						<td>
							<input type="checkbox" name="misc[admin_bar]" id="adminbar" value="enabled" <?php echo ( ! empty( $settings['admin_bar'] ) && $settings['admin_bar'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
							<label for="adminbar"><?php _e('Yes', 'bricksultimate'); ?></label>
						</td>
					</tr>

					<tr>
						<th>
							<label for="quicklinks">BricksUltimate Quick Menu</label>
							<p class="description"><?php _e('Adds a quick menu on the admin bar and you can quickly jump to other section without leaving the builder editor.', 'bricksultimate'); ?></p>
						</th>
						<td>
							<input type="checkbox" name="misc[menu_bar]" id="quicklinks" value="enabled" <?php echo ( ! empty( $settings['menu_bar'] ) && $settings['menu_bar'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
							<label for="quicklinks"><?php _e('Enable', 'bricksultimate'); ?></label>
						</td>
					</tr>

					<tr>
						<th>
							<label for="whitelabel">Disable White Label Tab</label>
						</th>
						<td>
							<input type="checkbox" name="misc[wl_tab]" id="whitelabel" value="enabled" <?php echo ( ! empty( $settings['wl_tab'] ) && $settings['wl_tab'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
							<label for="whitelabel"><?php _e('Disable', 'bricksultimate'); ?></label>
						</td>
					</tr>

					<tr>
						<th>
							<label for="whitelabel">Disable Term ID Column</label>
						</th>
						<td>
							<input type="checkbox" name="misc[termid]" id="termid" value="enabled" <?php echo ( ! empty( $settings['termid'] ) && $settings['termid'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
							<label for="termid"><?php _e('Disable', 'bricksultimate'); ?></label>
						</td>
					</tr>

					<tr>
						<th>
							<label for="heading">Heading Element</label>
							<p class="description"><?php _e('Add the custom tag control with dynamic data option.', 'bricksultimate'); ?></p>
						</th>
						<td>
							<input type="checkbox" name="misc[heading]" id="heading" value="enabled" <?php echo ( ! empty( $settings['heading'] ) && $settings['heading'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
							<label for="heading"><?php _e('Enable to adding the custom tag control', 'bricksultimate'); ?></label>
						</td>
					</tr>

					<tr>
						<th>
							<label for="postcomments">Single Post Comments Element</label>
							<p class="description"><?php _e('Improve the inbuilt "Comments" element which is showing on single post page.', 'bricksultimate'); ?></p>
						</th>
						<td>
							<input type="checkbox" name="misc[post_comments]" id="postcomments" value="enabled" <?php echo ( ! empty( $settings['post_comments'] ) && $settings['post_comments'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
							<label for="postcomments"><?php _e('Enable to enhance the existing controls', 'bricksultimate'); ?></label>
							<p class="description"><?php _e('It will add extra controls like hover effect, focus, width, height, padding, margin, etc.', 'bricksultimate'); ?></p>
						</td>
					</tr>

					<tr>
						<th>
							<label for="imageMask">Image Mask</label>
							<p class="description"><?php _e('Add 64 different kind of svg shapes to the Brick\'s in-built image element.', 'bricksultimate'); ?></p>
						</th>
						<td>
							<input type="checkbox" name="misc[image_mask]" id="image_mask" value="enabled" <?php echo ( ! empty( $settings['image_mask'] ) && $settings['image_mask'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
							<label for="image_mask"><?php _e('Enable mask controls.', 'bricksultimate'); ?></label>
						</td>
					</tr>

					<?php if( is_plugin_active('wp-grid-builder-bricks/wp-grid-builder-bricks.php') ) : ?>
						<tr>
						<th>
							<label>WP Grid Builder Facets Styler</label>
							<p class="description"><?php _e('Adding custom styler for the filter types.', 'bricksultimate'); ?></p>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[gbl_wpgb_facet]" id="gbl_wpgb_facet" value="enabled" <?php echo ( ! empty( $settings['gbl_wpgb_facet'] ) && $settings['gbl_wpgb_facet'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="gbl_wpgb_facet"><?php _e('Enable global styler(coming soon)', 'bricksultimate'); ?></label>
								<p class="description" style="margin-bottom: 12px;"><?php _e('Navigate to Builder Editor -> Settings -> Theme Styles -> Unlimate - WPGB Facets Styler.', 'bricksultimate'); ?></p>
							</div>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[wpgb_facet]" id="wpgb_facet" value="enabled" <?php echo ( ! empty( $settings['wpgb_facet'] ) && $settings['wpgb_facet'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="wpgb_facet"><?php _e('Enable individual element styler', 'bricksultimate'); ?></label>
								<p class="description"><?php _e('It will extend the flexibility in the builder editor.', 'bricksultimate'); ?></p>
							</div>
						</td>
					</tr>

					<?php endif; ?>

					<tr>
						<th>
							<label>Ultimate Query Builder</label>
							<p class="description"><?php _e('Add custom query providers for Query Loop builder.', 'bricksultimate'); ?></p>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[ultimate_query]" id="ultimate_query" value="enabled" <?php echo ( ! empty( $settings['ultimate_query'] ) && $settings['ultimate_query'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="ultimate_query"><?php _e('Enable custom query providers.', 'bricksultimate'); ?></label>
								<p class="description"><?php _e('It will extend the default query loop builder options and add the flexibility in the builder editor.', 'bricksultimate'); ?></p>
							</div>
						</td>
					</tr>

					<?php if( class_exists('WooCommerce') ) : ?>
					<tr>
						<th>
							<label>Ultimate Woo Query Builder</label>
							<p class="description"><?php _e('best selling, top rated, on-sale, featured, related, etc products list will build by container query loop.', 'bricksultimate'); ?></p>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[woo_query]" id="woo_query" value="enabled" <?php echo ( ! empty( $settings['woo_query'] ) && $settings['woo_query'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="woo_query"><?php _e('Make products list with custom query loop.', 'bricksultimate'); ?></label>
								<p class="description"><?php _e('It will extend the default query loop options and add the flexibility in the builder editor.', 'bricksultimate'); ?></p>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Add To Cart Button</label>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[product_atc]" id="product_atc" value="enabled" <?php echo ( ! empty( $settings['product_atc'] ) && $settings['product_atc'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="product_atc"><?php _e('Enable', 'bricksultimate'); ?></label>
								<p class="description"><?php _e('It will the styler option for view cart button.', 'bricksultimate'); ?></p>
							</div>
						</td>
					</tr>
					<?php if(wc_shipping_enabled()): ?>
					<tr>
						<th>
							<label>Free Shipping Notice</label>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[fsn]" id="fsn" value="enabled" <?php echo ( ! empty( $settings['fsn'] ) && $settings['fsn'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="fsn"><?php _e('Enable', 'bricksultimate'); ?></label>
							</div>
						</td>
					</tr>
					<?php endif; ?>
					<tr>
						<th>
							<label>Cart Content Element</label>
							<p class="description"><?php _e('Adjust the parameters of cart content layout.', 'bricksultimate'); ?></p>
						</th>
						<td>
							<div class="setting-wrapper" style="margin-bottom:15px;">
								<label for="cc-img-size">
									<strong><?php esc_html_e('Image Size', 'bricksultimate'); ?></strong>
								</label><br/>
								<select name="misc[cc_image_size]" id="cc-image-size">
									<?php
										$sizes = \Bricks\Setup::get_image_sizes_options();
										foreach( $sizes as $size => $label ) {
											$seleted = ! empty( $settings['cc_image_size'] ) ? $settings['cc_image_size'] : 'woocommerce_thumbnail';
											echo '<option value="' . $size . '" ' . 
												selected( $size, $seleted, false ) . '>' . 
												esc_attr( $label ) . 
											'</option>';
										}
									?>
								</select>
							</div>

							<div class="setting-wrapper"> 
								<label for="ccempty">
									<strong><?php _e('Empty cart message', 'bricksultimate'); ?></strong>
								</label><br/>
								<select name="misc[ccempty]" id="ccempty">
									<option value="none"><?php esc_html_e( 'Select template', 'bricks' ); ?></option>
									<?php
										$templates = \Bricks\Templates::get_templates_list('section');
										foreach ( $templates as $templateId => $templateName ) {
											$seleted = ! empty( $settings['ccempty'] ) ? $settings['ccempty'] : 'none';
											echo '<option value="' . $templateId . '" ' . selected( $templateId, $seleted, false ) . '>' . $templateName . '</option>';
										}
									?>
								</select>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>WooCommerce Brands</label>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[wc_brand]" id="wc_brand" value="enabled" <?php echo ( ! empty( $settings['wc_brand'] ) && $settings['wc_brand'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="wc_brand"><?php _e('Disable', 'bricksultimate'); ?></label>
								<p class="description"><?php _e('WooCommerce 9.6 is automatically enabling the Brands functionality. Are you wanting to disable this feature?', 'bricksultimate'); ?></p>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Product Element</label>
							<p class="description"><?php _e('Add extra style options.', 'bricksultimate'); ?></p>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[product_el]" id="product_el" value="enabled" <?php echo ( ! empty( $settings['product_el'] ) && $settings['product_el'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="product_el"><?php _e('Enable to enhance the controls.', 'bricksultimate'); ?></label>
								<p class="description"><?php _e('It will add more style options in the builder editor.', 'bricksultimate'); ?></p>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Product Filter Element</label>
							<p class="description"><?php _e('Add extra style options.', 'bricksultimate'); ?></p>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[product_filter]" id="product_filter" value="enabled" <?php echo ( ! empty( $settings['product_filter'] ) && $settings['product_filter'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="product_filter"><?php _e('Enable to enhance the controls.', 'bricksultimate'); ?></label>
								<p class="description"><?php _e('It will extend the contorl options in the builder editor.', 'bricksultimate'); ?></p>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Related Products Element</label>
							<p class="description"><?php _e('Add extra style options.', 'bricksultimate'); ?></p>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[related_prds]" id="related_prds" value="enabled" <?php echo ( ! empty( $settings['related_prds'] ) && $settings['related_prds'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="related_prds"><?php _e('Enable to enhance the controls.', 'bricksultimate'); ?></label>
								<p class="description"><?php _e('It will extend the contorl options in the builder editor.', 'bricksultimate'); ?></p>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Product Up/Cross Sells Element</label>
							<p class="description"><?php _e('Add extra style options.', 'bricksultimate'); ?></p>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[upcross_sells]" id="upcross_sells" value="enabled" <?php echo ( ! empty( $settings['upcross_sells'] ) && $settings['upcross_sells'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="upcross_sells"><?php _e('Enable to enhance the controls.', 'bricksultimate'); ?></label>
								<p class="description"><?php _e('It will extend the contorl options in the builder editor.', 'bricksultimate'); ?></p>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Cart Items & Totals Element</label>
							<p class="description"><?php _e('Add extra style options.', 'bricksultimate'); ?></p>
						</th>

						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[cart_items]" id="cart_items" value="enabled" <?php echo ( ! empty( $settings['cart_items'] ) && $settings['cart_items'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="cart_items"><?php _e('Enable to enhance the controls.', 'bricksultimate'); ?></label>
								<p class="description"><?php _e('It will extend the contorl options in the builder editor.', 'bricksultimate'); ?></p>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label for="recently_viewed_cookie">Disable Recently Viewed Cookie</label>
							<p class="description"><?php _e('Disable the woocommerce_recently_viewed cookie.', 'bricksultimate'); ?></p>
						</th>
						<td>
							<input type="checkbox" name="misc[recently_viewed_cookie]" id="recently_viewed_cookie" value="enabled" <?php echo ( ! empty( $settings['recently_viewed_cookie'] ) && $settings['recently_viewed_cookie'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
							<label for="recently_viewed_cookie"><?php _e('Disable', 'bricksultimate'); ?></label>
							<p class="description"><?php _e('It will not register the recently viewed cookie from the BricksUltimate plugin.', 'bricksultimate'); ?></p>
						</td>
					</tr>

					<tr>
						<th>
							<label>Wishlist cookie life</label>
						</th>
						<td>
							<div class="setting-wrapper">
								<?php $seleted = ! empty( $settings['wsl_cookie_life'] ) ? $settings['wsl_cookie_life'] : 'week'; ?>
								<select name="misc[wsl_cookie_life]" id="wsl_cookie_life">
									<option value="week" <?php selected( "week", $seleted ); ?>><?php esc_html_e( '1 week', 'bricksultimate' ); ?></option>
									<option value="month" <?php selected( "month", $seleted ); ?>><?php esc_html_e( '1 month', 'bricksultimate' ); ?></option>
									<option value="3months" <?php selected( "3months", $seleted ); ?>><?php esc_html_e( '3 months', 'bricksultimate' ); ?></option>
									<option value="year" <?php selected( "year", $seleted ); ?>><?php esc_html_e( '1 year', 'bricksultimate' ); ?></option>
								</select>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Compare cookie life</label>
						</th>
						<td>
							<div class="setting-wrapper">
								<?php $seleted = ! empty( $settings['comp_cookie_life'] ) ? $settings['comp_cookie_life'] : 'week'; ?>
								<select name="misc[comp_cookie_life]" id="comp_cookie_life">
									<option value="week" <?php selected( "week", $seleted ); ?>><?php esc_html_e( '1 week', 'bricksultimate' ); ?></option>
									<option value="month" <?php selected( "month", $seleted ); ?>><?php esc_html_e( '1 month', 'bricksultimate' ); ?></option>
									<option value="3months" <?php selected( "3months", $seleted ); ?>><?php esc_html_e( '3 months', 'bricksultimate' ); ?></option>
									<option value="year" <?php selected( "year", $seleted ); ?>><?php esc_html_e( '1 year', 'bricksultimate' ); ?></option>
								</select>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Add to cart notification</label>
						</th>
						<td>
							<div class="setting-wrapper">
								<select name="misc[atc_notice]" id="atc_notice">
									<option value="none"><?php esc_html_e( 'Select template', 'bricks' ); ?></option>
									<?php
										foreach ( $templates as $templateId => $templateName ) {
											$seleted = ! empty( $settings['atc_notice'] ) ? $settings['atc_notice'] : 'none';
											echo '<option value="' . $templateId . '" ' . selected( $templateId, $seleted, false ) . '>' . $templateName . '</option>';
										}
									?>
								</select>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Swatches</label>
							<p class="description"><?php _e('Single product page and quick add form', 'bricksultimate'); ?></p>
						</th>
						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[swatches]" id="swatches" value="enabled" <?php echo ( ! empty( $settings['swatches'] ) && $settings['swatches'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="swatches"><?php esc_html_e('Enable', 'bricksultimate'); ?></label><br/>
								<input type="checkbox" name="misc[sw_variation_images]" id="sw_variation_images" value="enabled" <?php echo ( ! empty( $settings['sw_variation_images'] ) && $settings['sw_variation_images'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="sw_variation_images"><?php esc_html_e('Fetch images from product variations', 'bricksultimate'); ?></label>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Order Bumps</label>
							<p class="description">Allow Order Bumps to be displayed.</p>

						</th>
						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[orderbumps]" id="orderbumps" value="enabled" <?php echo ( ! empty( $settings['orderbumps'] ) && $settings['orderbumps'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="orderbumps"><?php esc_html_e('Enable', 'bricksultimate'); ?></label><br/>
								<p class="description">
									<?php esc_html_e('You can create the order bumps via Dashboard -> Bricks -> BricksUltimate -> Order Bumps.', 'bricksultimate'); ?> <a href="https://youtu.be/94GvOHr4Sqw" target="_blank"><?php esc_html_e('Checkout the video', 'bricksultimate') ; ?></a>
								</p>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Linked Variations</label>
							<p class="description">
								<?php esc_html_e('Create a new kind of variable product based on simple products.', 'bricksultimate' ); ?>
							</p>
						</th>
						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[linked_variation]" id="linked_variation" value="enabled" <?php echo ( ! empty( $settings['linked_variation'] ) && $settings['linked_variation'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="linked_variation"><?php esc_html_e('Enable', 'bricksultimate'); ?></label><br/>
								<p class="description">
									<?php esc_html_e('You can create the linked products via Dashboard -> Bricks -> BricksUltimate -> Linked Variations.', 'bricksultimate'); ?> <a href="https://youtu.be/F-tMwefaDK0" target="_blank"><?php esc_html_e('Checkout the video', 'bricksultimate') ; ?></a>
								</p>
							</div>
						</td>
					</tr>
					
					<tr>
						<th>
							<label>Checkout Page</label>
						</th>
						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[couponform]" id="couponform" value="enabled" <?php echo ( ! empty( $settings['couponform'] ) && $settings['couponform'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="couponform"><?php esc_html_e('Remove default coupon form', 'bricksultimate'); ?></label><br/>
								<input type="checkbox" name="misc[loginform]" id="loginform" value="enabled" <?php echo ( ! empty( $settings['loginform'] ) && $settings['loginform'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="loginform"><?php esc_html_e('Remove login form', 'bricksultimate'); ?></label><br/>
								<input type="checkbox" name="misc[wc_payment]" id="wc_payment" value="enabled" <?php echo ( ! empty( $settings['wc_payment'] ) && $settings['wc_payment'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="wc_payment"><?php esc_html_e('Disable payment gateway', 'bricksultimate'); ?></label><br/>
								<input type="checkbox" name="misc[free_shipping]" id="free_shipping" value="enabled" <?php echo ( ! empty( $settings['free_shipping'] ) && $settings['free_shipping'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="free_shipping"><?php esc_html_e('Hide shipping rates when free shipping is available', 'bricksultimate'); ?></label>
								<br/>
								<input type="checkbox" name="misc[local_pickup]" id="local_pickup" value="enabled" <?php echo ( ! empty( $settings['local_pickup'] ) && $settings['local_pickup'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="local_pickup"><?php esc_html_e('Hide shipping rates when free shipping is available, but keep "Local pickup"', 'bricksultimate'); ?></label>
								<div class="checkout-fields-wrapper">
									<div class="billing-fields">
										<h4><?php _e('Removes billing fields', 'bricksultimate'); ?></h4>
										<?php
											$billing_fields = WC()->checkout()->get_checkout_fields( 'billing' );
											foreach( $billing_fields as $key => $billing_field ) {
												if( empty( $billing_field['label'] ) )
													continue;
										?>	
										<input type="checkbox" name="misc[<?php echo $key; ?>]" id="<?php echo $key; ?>" value="enabled" <?php echo ( ! empty( $settings[ $key ] ) && $settings[ $key ] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
										<label for="<?php echo $key; ?>"><?php echo wp_kses_post( $billing_field['label'] ); ?></label><br/>
										<?php } ?>
									</div>
									<div class="shipping-fields">
										<h4><?php _e('Removes shipping fields', 'bricksultimate'); ?></h4>
										<?php
											$shipping_fields = WC()->checkout()->get_checkout_fields( 'shipping' );
											foreach( $shipping_fields as $key => $shipping_field ) {
												if( empty( $shipping_field['label'] ) )
													continue;
										?>	
										<input type="checkbox" name="misc[<?php echo $key; ?>]" id="<?php echo $key; ?>" value="enabled" <?php echo ( ! empty( $settings[ $key ] ) && $settings[ $key ] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
										<label for="<?php echo $key; ?>"><?php echo wp_kses_post( $shipping_field['label'] ); ?></label><br/>
										<?php } ?>
									</div>
								</div>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label>Checkout Empty Cart Message</label>
						</th>
						<td>
							<div class="setting-wrapper">
								<?php $selected = ! empty( $settings['checkout_notice'] ) ? $settings['checkout_notice'] : 'none'; ?>
								<select name="misc[checkout_notice]" id="checkout_notice">
									<option value="none"><?php esc_html_e( 'Select template', 'bricks' ); ?></option>
									<?php
										foreach ( $templates as $templateId => $templateName ) {
											$selected = ! empty( $settings['checkout_notice'] ) ? $settings['checkout_notice'] : 'none';
											echo '<option value="' . $templateId . '" ' . selected( $templateId, $selected, false ) . '>' . $templateName . '</option>';
										}
									?>
								</select>
							</div>
						</td>
					</tr>

					<tr>
						<th>
							<label for="uninstalldata">Show variation name in product title</label>
						</th>
						<td>
							<input type="checkbox" name="misc[order_item_name]" id="order_item_name" value="enabled" <?php echo ( ! empty( $settings['order_item_name'] ) && $settings['order_item_name'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
							<label for="order_item_name"><?php _e('Enable', 'bricksultimate'); ?></label>
						</td>
					</tr>

					<tr>
						<th>
							<label>My Account Page</label>
						</th>
						<td>
							<div class="setting-wrapper">
								<input type="checkbox" name="misc[myaccount_default_nav]" id="myaccount_default_nav" value="enabled" <?php echo ( ! empty( $settings['myaccount_default_nav'] ) && $settings['myaccount_default_nav'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="myaccount_default_nav"><?php esc_html_e('Disable navigation links', 'bricksultimate'); ?></label>
								<p class="description"><?php esc_html_e('Enable this option if you want to create the custom links.','bricksultimate'); ?></p><br/>
								<input type="checkbox" name="misc[myaccount_custom_ep]" id="myaccount_custom_ep" value="enabled" <?php echo ( ! empty( $settings['myaccount_custom_ep'] ) && $settings['myaccount_custom_ep'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
								<label for="myaccount_custom_ep"><?php esc_html_e('Creates custom endpoints', 'bricksultimate'); ?></label>
								<p class="description"><?php esc_html_e('Enable this option if you want to create the custom endpoints for the My Account page.','bricksultimate'); ?> <a href="https://youtu.be/NVb9T-iS38Q" target="_blank"><?php _e('Checkout the video', 'bricksultimate'); ?></a></p><br/>
							</div>
						</td>
					</tr>
					<?php endif; ?>

					<tr>
						<th>
							<label for="uninstalldata">Remove Data on Uninstall?</label>
						</th>
						<td>
							<input type="checkbox" name="misc[delete_data]" id="delete_data" value="enabled" <?php echo ( ! empty( $settings['delete_data'] ) && $settings['delete_data'] == 'enabled' ) ? 'checked="checked"' : ''; ?>>
							<label for="delete_data"><?php _e('Enable it if you would like BricksUltimate to completely remove all of its data when the plugin is deleted.', 'bricksultimate'); ?></label>
						</td>
					</tr>
				</tbody>
			</table>

			<?php wp_nonce_field( 'bu_nonce_action', 'bu_nonce_field' ); ?>
			<input type="hidden" name="action" value="save_misc_data" />
			<?php submit_button(); ?>
		</form>
	<?php
	}
}