<?php
namespace BricksUltimate\Admin\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Admin\EndpointsListTable;

trait MyAccountEndpoint {
	private function buwoo_custom_endpoint_wplist_table() {
		// check user capabilities
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		$edited_data = ['title' => '', 'slug' => '', 'mask' => 'OR', 'id' => '', 'page' => 'account'];
		$data = maybe_unserialize( get_option('bu_endpoints') );
		if( empty( $data ) )
			$data = [];

		if( isset( $_GET['action'] ) && $_GET['action'] == 'delete' && isset( $_GET['delete'] ) ) {
			unset( $data[ $_GET['delete'] ] );
			update_option( 'bu_endpoints', maybe_serialize( $data ), 'no');
			printf('<div class="notice notice-info is-dismissible"><p>%s</p></div>', __('Endpoint deleted successfully.', 'bricksultimate'));
		}

		if( isset( $_POST['action'] ) && $_POST['action'] == "add-maep" && isset( $_POST['bu_nonce_field'] ) && wp_verify_nonce( $_POST['bu_nonce_field'], 'bu_nonce_action') )
		{
			if( ! empty( $_POST['id'] ) && ! empty( $data ) && ! empty( $data[ $_POST['id'] ] ) ) {
				$data[ $_POST['id'] ] = [
					'id' 	=> $_POST['id'],
					'title' 	=> wp_kses_post( $_POST['ep-title'] ),
					'slug' 	=> esc_html( $_POST['ep-slug'] ),
					'mask' 	=> $_POST['ep-mask'],
					'page' 	=> $_POST['ep-page']
				];

				printf('<div class="notice notice-info is-dismissible"><p>%s "%s" %s</p></div>', 
					__('Endpoint', 'bricksultimate'),
					wp_kses_post( $_POST['ep-title'] ),
					__('updated successfully.', 'bricksultimate'));
			} else {
				$data[ time() ] = [
					'id' 	=> time(),
					'title' 	=> wp_kses_post( $_POST['ep-title'] ),
					'slug' 	=> esc_html( $_POST['ep-slug'] ),
					'mask' 	=> $_POST['ep-mask'],
					'page' 	=> $_POST['ep-page']
				];

				printf('<div class="notice notice-info is-dismissible"><p>%s</p></div>', __('Endpoint created successfully.', 'bricksultimate'));
			}

			update_option( 'bu_endpoints', maybe_serialize( $data ), 'no');
		}

		if( isset( $_GET['action'] ) && $_GET['action'] == 'edit' ) {
			$edited_data = $data[ $_GET['edit'] ];
		}

		$url = add_query_arg( 'tab', 'maep', menu_page_url( $this->menu_slug, false ) );
	?>
		<div id="col-container" class="wp-clearfix">
			<div id="col-left">
				<div class="col-wrap">
					<div class="form-wrap">
						<h2><?php esc_html_e('Add New Endpoint', 'bricksultimate'); ?></h2>
						<form class="maep-form" id="maep-form" method="post" action="<?php echo $url; ?>">
							<input type="hidden" name="action" value="add-maep">
							<input type="hidden" name="id" value="<?php echo $edited_data['id']; ?>">
							<?php wp_nonce_field( 'bu_nonce_action', 'bu_nonce_field' ); ?>
							<div class="form-field form-required ep-name-wrap">
								<label for="ep-title">Title</label>
								<input name="ep-title" id="ep-title" type="text" value="<?php echo $edited_data['title']; ?>" placeholder="Custom endpoint" size="40" aria-required="true" aria-describedby="ep-description">
								<p id="ep-description">The title is how it appears on your site.</p>
							</div>

							<div class="form-field form-required ep-slug-wrap">
								<label for="ep-slug">Slug</label>
								<input name="ep-slug" id="ep-slug" type="text" value="<?php echo $edited_data['slug']; ?>" placeholder="custom-enpoint-slug" size="40" aria-describedby="ep-slug-description">
								<p id="ep-slug-description">The “slug” is the URL-friendly version of the name. It is usually all lowercase and contains only letters, numbers, and hyphens.</p>
							</div>
							<div class="form-field form-required ep-mask-wrap">
								<label for="ep-mask">Mask</label>
								<select name="ep-mask" id="ep-mask" style="width: 95%;">
									<option value="OR" <?php selected( $edited_data['mask'], 'OR', 1 ) ?>>EP_ROOT | EP_PAGES</option>
									<option value="EP_PAGES" <?php selected( $edited_data['mask'], 'EP_PAGES', 1 ) ?>>EP_PAGES</option>
									<option value="EP_ROOT" <?php selected( $edited_data['mask'], 'EP_ROOT', 1 ) ?>>EP_ROOT</option>
								</select>
							</div>
							<div class="form-field form-required ep-page-wrap">
								<label for="ep-page">Page</label>
								<select name="ep-page" id="ep-page" style="width: 95%;">
									<option value="account" <?php selected( $edited_data['page'], 'account', 1 ) ?>>My Account</option>
								</select>
							</div>
							<?php submit_button(); ?>
						</form>
					</div>

					<div class="form-wrap edit-term-notes">
						<p>
							You add the content of these custom endpoints with <strong>Bricks -> Templates -> Add New</strong> page. You will use the <strong>(BU)Navigation</strong> element and display these endpoints at frontend. 
						</p><br/>
						<p>
							<strong>Reminder:</strong> You will flush the permalink after registering the new endpoint. Go to <a href="<?php echo admin_url('options-permalink.php'); ?>">Settings -> Permalinks</a> page and click on the <strong>"Save Changes"</strong> button.	
						</p>
					</div>
				</div>
			</div>
			<div id="col-right">
				<div class="col-wrap">
					<?php
						$table = new EndpointsListTable([ 'pageslug' => $this->menu_slug ] );
						// Prepare table
						$table->prepare_items();
						// Display table
						$table->display();
					?>
				</div>
			</div>
		</div>
		<?php
	}
}