<?php
namespace BricksUltimate\Admin\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait WhiteLabel {
	private $buwl = '';
	
	private function bu_save_whitelabel_data() {
		// check user capabilities
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		if( isset( $_POST['action'] ) && $_POST['action'] == "save_wl_data" ){
			if( isset( $_POST['buwl'] ) ) {
				update_option('buwl', $_POST['buwl']);
			} else {
				delete_option('buwl');
			}

			printf('<div class="notice notice-info is-dismissible"><p>%s</p></div>', __('Settings saved successfully.', 'bricksultimate'));

			$menu_slug = 'bricksultimate';

			if( ! empty( $_POST['buwl']['menu_slug'] ) ) {
				$menu_slug =  esc_html( $_POST['buwl']['menu_slug'] );
			}

			$url = add_query_arg( 'tab', 'whitelabel', menu_page_url( $menu_slug, false ) ) . '&page='. $menu_slug;

			if ( wp_safe_redirect( $url ) ) {
			    exit;
			}
		}
	}

	private function bu_white_label( $buwl = false ) {
		$plugin_name 	= 'placeholder="BricksUltimate"';
		$plugin_uri 	= 'placeholder="https://bricksultimate.com"';
		$author_name 	= 'placeholder="Chinmoy Paul"';
		$author_uri 	= 'placeholder="https://paulchinmoy.com"';
		$menu_name 		= 'placeholder="BricksUltimate"';
		$menu_slug 		= 'placeholder="bricksultimate"';
		$menuslug 		= 'bricksultimate';
		$plugin_desc 	= '';
		$tab_permission = 'placeholder="Enter user ID. Use comma for multiple users"';

		if( $buwl ) {
			$plugin_desc 	= ! empty( $buwl['plugin_desc'] ) ? esc_html( $buwl['plugin_desc'] ) : $plugin_desc;
			$menuslug 		= ! empty( $buwl['menu_slug'] ) ? esc_html( $buwl['menu_slug'] ) : $menuslug;
			$plugin_name 	= ! empty( $buwl['plugin_name'] ) ? 'value="' . esc_html( $buwl['plugin_name'] ) . '"' : $plugin_name;
			$plugin_uri 	= ! empty( $buwl['plugin_uri'] ) ? 'value="' . esc_html( $buwl['plugin_uri'] ) . '"' : $plugin_uri;
			$author_name 	= ! empty( $buwl['author_name'] ) ? 'value="' . esc_html( $buwl['author_name'] ) . '"' : $author_name;
			$author_uri 	= ! empty( $buwl['author_uri'] ) ? 'value="' . esc_html( $buwl['author_uri'] ) . '"' : $author_uri;
			$menu_name 		= ! empty( $buwl['menu_name'] ) ? 'value="' . esc_html( $buwl['menu_name'] ) . '"' : $menu_name;
			$menu_slug 		= ! empty( $buwl['menu_slug'] ) ? 'value="' . esc_html( $buwl['menu_slug'] ) . '"' : $menu_slug;
			$tab_permission = ! empty( $buwl['tab_permission'] ) ? 'value="' . esc_html( $buwl['tab_permission'] ) . '"' : $tab_permission;
		}

		$url = add_query_arg( 'tab', 'whitelabel', menu_page_url( $menuslug, false ) );
	?>
		<h2><?php _e( 'White Label', 'bricksultimate' ); ?></h2>
		<p class="description">It gives you the ability to control and transform the appearance of the back-end.</p>
		<div style="border-top: 1px solid #ccd0d4; margin-top: 15px;">
			<form method="post" action="<?php echo $url; ?>">
				<table class="form-table">
					<tbody>
						<tr valign="top">
							<th scope="row" valign="top">
								<?php _e( 'Plugin Name', 'bricksultimate' ); ?>
							</th>
							<td>
								<input id="plugin_name" name="buwl[plugin_name]" type="text" class="regular-text" <?php echo $plugin_name; ?> />
							</td>
						</tr>

						<tr valign="top">
							<th scope="row" valign="top">
								<?php _e( 'Plugin URI', 'bricksultimate' ); ?>
							</th>
							<td>
								<input id="plugin_uri" name="buwl[plugin_uri]" type="url" class="regular-text" <?php echo $plugin_uri; ?> />
							</td>
						</tr>

						<tr valign="top">
							<th scope="row" valign="top">
								<?php _e( 'Author Name', 'bricksultimate' ); ?>
							</th>
							<td>
								<input id="author_name" name="buwl[author_name]" type="text" class="regular-text" <?php echo $author_name; ?> />
							</td>
						</tr>

						<tr valign="top">
							<th scope="row" valign="top">
								<?php _e( 'Author URI', 'bricksultimate' ); ?>
							</th>
							<td>
								<input id="author_uri" name="buwl[author_uri]" type="url" class="regular-text" <?php echo $author_uri; ?> />
							</td>
						</tr>

						<tr valign="top">
							<th scope="row" valign="top">
								<?php _e( 'Plugin Description', 'bricksultimate' ); ?>
							</th>
							<td>
								<textarea id="plugin_desc" name="buwl[plugin_desc]" class="large-text" cols="5" rows="8" ><?php echo $plugin_desc; ?></textarea>
							</td>
						</tr>

						<tr valign="top">
							<th scope="row" valign="top">
								<?php _e( 'Admin Menu Name', 'bricksultimate' ); ?><br/>
							</th>
							<td>
								<input id="menu_name" name="buwl[menu_name]" type="text" class="regular-text" <?php echo $menu_name; ?> />
							</td>
						</tr>
						<tr valign="top">
							<th scope="row" valign="top">
								<?php _e( 'Admin Menu Link Slug', 'bricksultimate' ); ?>
							</th>
							<td>
								<input id="menu_slug" name="buwl[menu_slug]" type="text" class="regular-text" <?php echo $menu_slug; ?> />
							</td>
						</tr>
						<tr valign="top">
							<th scope="row" valign="top">
								<?php _e( 'Permission', 'bricksultimate' ); ?><br/>
								<lebel style="font-weight: normal; color: #999;"><?php _e( 'who can access this page', 'bricksultimate' ); ?></lebel>
							</th>
							<td>
								<input id="tab_permission" name="buwl[tab_permission]" type="text" class="regular-text" <?php echo $tab_permission; ?> />
							</td>
						</tr>
					</tbody>
				</table>
				<?php wp_nonce_field( 'bu_nonce_action', 'bu_nonce_field' ); ?>
				<input type="hidden" name="action" value="save_wl_data" />
				<?php submit_button(); ?>
			</form>
		</div>
	<?php
	}
}