<?php
namespace BricksUltimate\ElementConditions;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
class Base {
	
	public function __construct() {
		add_filter( 'bricks/conditions/groups', [ $this, 'add_element_condition_group' ] );
		add_filter( 'bricks/conditions/options',[ $this, 'add_element_condition' ] );
		add_filter( 'bricks/conditions/result', [ $this, 'result_element_condition' ], 99, 3 );
	}

	public static function getTrueFalseCondition($key, $label, $group) {
		return [
			'key'   => $key,
			'label' => $label,
			'group' => $group,
			'compare' => [
				'type'        => 'select',
				'options'     =>  [
					'==' => esc_html__( 'True', 'bricks' ),
					'!=' => esc_html__( 'False', 'bricks' ),
				],
				'placeholder' => esc_html__( 'True', 'bricks' ),
				'default' => '=='
			],
			'value'   => []
		];
	}

	public static function getEqualValueTextCondition($key, $label, $group, $placeholder = '', $info = '') {
		return [
			'key'   => $key,
			'label' => $label,
			'group' => $group,
			'compare' => [
				'type'        => 'select',
				'options'     =>  [
					'==' => esc_html__( 'is', 'bricks' ),
					'!=' => esc_html__( 'is not', 'bricks' ),
				],
				'placeholder' => esc_html__( 'is', 'bricks' ),
				'default' => '=='
			],
			'value'   => [
				'type' 	=> 'text',
				'placeholder' => $placeholder,
				'description' => $info,
				'info' 	=> $info
			]
		];
	}

	public static function getTrueFalseTextCondition($key, $label, $group, $placeholder = '', $info = '') {
		return [
			'key'   => $key,
			'label' => $label,
			'group' => $group,
			'compare' => [
				'type'        => 'select',
				'options'     =>  [
					'==' => esc_html__( 'True', 'bricks' ),
					'!=' => esc_html__( 'False', 'bricks' ),
				],
				'placeholder' => esc_html__( 'True', 'bricks' ),
				'default' => '=='
			],
			'value'   => [
				'type' 	=> 'text',
				'placeholder' => $placeholder,
				'description' => $info,
				'info' 	=> $info
			]
		];
	}

	public static function getDropDownCondition( $key, $label, $group, $placeholder = '', $options = [] ) {
		return [
			'key'   => $key,
			'label' => $label,
			'group' => $group,
			'compare' => [
				'type'        => 'select',
				'options'     =>  [
					'==' => esc_html__( 'yes', 'bricks' ),
					'!=' => esc_html__( 'no', 'bricks' ),
				],
				'placeholder'	=> esc_html__( 'yes', 'bricks' ),
				'default' 		=> '=='
			],
			'value'   => [
				'type' 	=> 'select',
				'options' => $options,
				'placeholder' => $placeholder
			]
		];
	}

	public static function getDropDownCondition2nd( $key, $label, $group, $placeholder = '', $options = [] ) {
		return [
			'key'   => $key,
			'label' => $label,
			'group' => $group,
			'compare' => [
				'type'        => 'select',
				'options'     =>  [
					'==' => esc_html__( 'is', 'bricks' ),
					'!=' => esc_html__( 'is not', 'bricks' ),
				],
				'placeholder' => esc_html__( 'is', 'bricks' ),
				'default' 	=> '=='
			],
			'value'   => [
				'type' 	=> 'select',
				'options' => $options,
				'placeholder' => $placeholder
			]
		];
	}

	public static function getMathCondition($key, $label, $group, $placeholder = '', $info = '') {
		return [
			'key'   => $key,
			'label' => $label,
			'group' => $group,
			'compare' => [
				'type'        => 'select',
				'options'     =>  [
					'==' => '==',
					'!=' => '!=',
					'>=' => '>=',
					'<=' => '<=',
					'>'  => '>',
					'<'  => '<',
				],
				'placeholder' => esc_html__( '==', 'bricks' ),
				'default' => '=='
			],
			'value'   => [
				'type' 			=> 'number',
				'unitless' 		=> true,
				'small' 		=> false,
				'medium' 		=> true,
				'placeholder' 	=> $placeholder,
				'description' 	=> $info,
				'info' 			=> $info
			]
		];
	}

	public static function execute_math_logic( $condition, $value ) {
		$condition_met = false;
		$compare = isset( $condition['compare'] ) ? $condition['compare'] : '==';
		$user_value = isset( $condition['value'] ) ? $condition['value'] : '';

		switch( $compare ) {
			case '==': 
				$condition_met = $value == $user_value;
				break;
			case '!=': 
				$condition_met = $value != $user_value;
				break;

			case '>=':
				$condition_met = $value >= $user_value;
				break;

			case '<=':
				$condition_met = $value <= $user_value;
				break;

			case '>':
				$condition_met = $value > $user_value;
				break;

			case '<':
				$condition_met = $value < $user_value;
				break;
		}

		return $condition_met;
	}

	public static function execute_equal_logic( $condition, $value ) {
		$condition_met = false;
		$compare = isset( $condition['compare'] ) ? $condition['compare'] : '==';
		$user_value = isset( $condition['value'] ) ? $condition['value'] : '';

		switch( $compare ) {
			case '==': // "is"
				$condition_met = $value === $user_value;
				break;
			case '!=': // "is not"
				$condition_met = $value !== $user_value;
				break;
		}

		return $condition_met;
	}

	public static function execute_true_false_logic( $condition, $value ) {
		$condition_met = false;
		$compare = isset( $condition['compare'] ) ? $condition['compare'] : '==';

		switch( $compare ) {
			case '==': // "true"
				$condition_met = $value === true;
				break;
			case '!=': // "false"
				$condition_met = $value === false;
				break;
		}

		return $condition_met;
	}
}