<?php
namespace BricksUltimate\ElementConditions;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WpConditions extends Base {

	public function add_element_condition_group( $groups ) {
		$groups[] = [
			'name'  => 'buct',
			'label' => esc_html__( 'Conditional Tags - BU', 'bricksultimate' ),
		];

		$groups[] = [
			'name'  => 'buterms',
			'label' => esc_html__( 'Terms - BU', 'bricksultimate' ),
		];

		if ( function_exists( 'EDD' ) ) {
			$groups[] = [
				'name'  => 'buedd',
				'label' => esc_html__( 'EDD - BU', 'bricksultimate' ),
			];
		}

		return $groups;
	}

	public function add_element_condition( $options ) {
		foreach( $this->get_conditional_tags_conditions() as $key => $tag ) {

			if( $tag['type'] == "truefalse" ) {
				$options[] = self::getTrueFalseCondition($key, $tag['label'], $tag['group']);
			}

			if( $tag['type'] == "equaltext" ) {
				$placeholder = $tag['placeholder'] ?? '';
				$info = $tag['info'] ?? '';
				$options[] = self::getEqualValueTextCondition($key, $tag['label'], $tag['group'], $placeholder, $info );
			}

			if( $tag['type'] == "dropdown" ) {
				$placeholder = $tag['placeholder'] ?? '';
				$options[] = self::getDropDownCondition($key, $tag['label'], $tag['group'], esc_attr( $placeholder ), $tag['options'] );
			}

			if( isset( $tag['type'] ) && $tag['type'] == "dropdown2nd" ) {
				$placeholder = $tag['placeholder'] ?? '';
				$options[] = self::getDropDownCondition2nd($key, $tag['label'], $tag['group'], esc_attr( $placeholder ), $tag['options'] );
			}

			if( $tag['type'] == "bricks" && $key == 'bu_cookie' ) {
				$options[] = [
					'key'     => $key,
					'group'   => $tag['group'],
					'label'   => $tag['label'],
					'compare' => [
						'type'        => 'select',
						'options'     => [
							'is_set' 		=> esc_html__( 'is set', 'bricksultimate' ),
							'is_no_set' 	=> esc_html__( 'is not set', 'bricksultimate' ),
							'starts_with' 	=> esc_html__( 'starts with', 'bricksultimate' ),
							'ends_with' 	=> esc_html__( 'ends with', 'bricksultimate' ),
							'==' 			=> esc_html__( 'equals', 'bricks' ),
							'!=' 			=> esc_html__( 'not equals', 'bricks' ),
							'>' 			=> esc_html__( 'greater', 'bricksultimate' ),
							'<' 			=> esc_html__( 'lower', 'bricksultimate' ),
							'>=' 			=> esc_html__( 'greater_or_equal', 'bricksultimate' ),
							'<='			=> esc_html__( 'lower_or_equal', 'bricksultimate' ),
							'contains'     	=> esc_html__( 'contains', 'bricks' ),
							'contains_not' 	=> esc_html__( 'does not contain', 'bricks' ),
						],
						'placeholder' => esc_html__( 'equals', 'bricksultimate' ),
					],
					'value'   => [
						'type' 			=> 'text',
						'placeholder' 	=> esc_html__('cookiename:cookievalue', 'bricksultimate'),
						'description' 	=> esc_html__('Enter only cookie name if you choose "is set" or "is not set" option. Enter cookiename:cookievalue for other options', 'bricksultimate')
					],
				];
			}
		}

		return $options;
	}

	public function result_element_condition( $condition_met, $condition_key, $condition ) {
		/*$condition_options = \Bricks\Conditions::$options;
		$key = array_search( $condition_key, array_column( $condition_options, 'key' ));
		if( ! $key )
			return $result;

		$registered_condition = $condition_options[ $key ];
		if ( ! in_array( $registered_condition['group'], [ 'buct', 'buterms', 'buedd' ] ) ) {
			return $result;
		}

		$condition_met = false;*/

		switch( $condition_key ) {
			case 'is_parent_page' :
				$post_id = \Bricks\Query::is_looping() && \Bricks\Query::get_loop_object_type() == 'post' ? \Bricks\Query::get_loop_object_id() : get_the_ID();
				$children = get_posts( array('child_of' => $post_id) );
				$value = count( $children ) > 0 ? true : false;
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_child_page' :
				$post_id = \Bricks\Query::is_looping() && \Bricks\Query::get_loop_object_type() == 'post' ? \Bricks\Query::get_loop_object_id() : get_the_ID();

				$value = wp_get_post_parent_id( $post_id ) > 0 ? true : false;
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_front_page':
				$value = is_front_page();
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_home':
				$value = is_home();
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_page':
				$value = is_page();
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_page_id':
				if( isset( $condition['value'] ) ) {
					$pages = strstr( $condition['value'], ',' ) ? explode( ",", $condition['value'] ) : $condition['value'];
					$value = is_page( $pages );
				} else {
					$value = false;
				}
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_single':
				$value = is_single();
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_singular':
				if( isset( $condition['value'] ) ) {
					$pages = strstr( $condition['value'], ',' ) ? explode( ",", $condition['value'] ) : $condition['value'];
					$value = is_singular( $pages );
				} else {
					$value = false;
				}
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_archive':
				$value = is_archive();
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_category':
				$value = is_category();
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_category_id':
				if( isset( $condition['value'] ) ) {
					$cats = strstr( $condition['value'], ',' ) ? explode( ",", $condition['value'] ) : $condition['value'];
					$value = is_category( $cats );
				} else {
					$value = false;
				}
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_term_id':
				if( isset( $condition['value'] ) && is_tax() ) {
					$arr_val = explode(":", $condition['value']);
					$terms = ( ! empty( $arr_val[1] ) && strstr( $arr_val[1], ',' ) ) ? explode( ",", $arr_val[1] ) : $arr_val[1];
					$value = is_tax($arr_val[0], $terms );
				} else {
					$value = false;
				}
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_tag':
				$value = is_tag();
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_tag_id':
				if( isset( $condition['value'] ) ) {
					$tags = strstr( $condition['value'], ',' ) ? explode( ",", $condition['value'] ) : $condition['value'];
					$value = is_tag( $tags );
				} else {
					$value = false;
				}
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_tax':
				$value = is_tax();
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_post_type_archive':
				if( isset( $condition['value'] ) ) {
					if( strstr( $condition['value'], 'all' ) ) {
						$value = is_post_type_archive();
					} elseif ( strstr( $condition['value'], ',' ) ) {
						$post_types = explode( ",", $condition['value'] );
						$value = is_post_type_archive( $post_types );
					} else {
						$value = is_post_type_archive( $condition['value'] );
					}
				} else {
					$value = is_post_type_archive();
				}
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_author':
				$value = is_author();
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'is_author_id':
				if( isset( $condition['value'] ) ) {
					$authors = strstr( $condition['value'], ',' ) ? explode( ",", $condition['value'] ) : $condition['value'];
					$value = is_author( $authors );
				} else {
					$value = false;
				}
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'taxonomy_exists':
				$value = taxonomy_exists( $condition['value'] );
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'term_is':
				$object = self::getLoopObject();

				if ( ! $object ) {
					$object = get_queried_object();
				}

				// Not a WP_Term, leave
				if ( $object && ! is_a( $object, 'WP_Term' ) ) {
					$terms = get_terms( array( 'include' => $condition['value'], 'fields' => 'ids' ) );
					
					if( empty( $terms ) || is_wp_error( $terms ) ) {
						$condition_met = false;
					} else {
						$_term = array_shift( $terms );
						$value = $object->term_id === $_term ? true : false;
						$condition_met = self::execute_true_false_logic( $condition, $value );
					}
				}
				break;

			case 'has_term':
				if( isset( $condition['value'] ) ) {
					$post_id = \Bricks\Query::is_looping() && \Bricks\Query::get_loop_object_type() == 'post' ? \Bricks\Query::get_loop_object_id() : get_the_ID();

					$user_value = $condition['value'] ?? '';

					if( strstr( $user_value, ':') ) {
						$args = explode(":", trim( $user_value ) );
						$value = @has_term( @explode(",", trim( $args[1] ) ), $args[0], $post_id );
						$condition_met = self::execute_true_false_logic( $condition, $value );
					}
				}
				break;

			case 'is_parent_term':
				$object = self::getLoopObject();

				if ( ! $object ) {
					$object = get_queried_object();
				}

				// Not a WP_Term, leave
				if ( $object && is_a( $object, 'WP_Term' ) ) {
					$value = ( $object->parent > 0 ) ? false : true;
					$condition_met = self::execute_true_false_logic( $condition, $value );
				}
				break;

			case 'has_children':
				$object = self::getLoopObject();

				if ( ! $object ) {
					$object = get_queried_object();
				}

				// Not a WP_Term, leave
				if ( $object && is_a( $object, 'WP_Term' ) ) {
					$hasChild = get_term_children( $object->term_id, $object->taxonomy );
					$value = ( $hasChild ) ? true : false;
					$condition_met = self::execute_true_false_logic( $condition, $value );
				}
				break;

			case 'has_ancestors':
				$object = self::getLoopObject();

				if ( ! $object ) {
					$object = get_queried_object();
				}

				// Not a WP_Term, leave
				if ( $object && is_a( $object, 'WP_Term' ) ) {
					$ancestors = get_ancestors( $object->term_id, $object->taxonomy, 'taxonomy' );
					$value = ( $ancestors ) ? true : false;
					$condition_met = self::execute_true_false_logic( $condition, $value );
				}
				break;

			case 'has_wishlist':
				$post_type = $condition['value'] ?? 'post';
				$value = \BricksUltimate\Wishlist::get_wishlist_counter( $post_type ) > 0 ? false : true;
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'has_compare_items':
				$post_type = $condition['value'] ?? 'post';
				$value = \BricksUltimate\Compare::get_compare_counter( $post_type ) > 0 ? true : false;
				$condition_met = self::execute_true_false_logic( $condition, $value );
				break;

			case 'bu_cookie':
				if( isset( $condition['value'] ) ) {
					$compare = isset( $condition['compare'] ) ? $condition['compare'] : '==';
					if( strstr( $condition['value'], ':' ) ) {
						$value =  explode(":", $condition['value']);
						$cookie_key = $value[1];
						$user_value = $value[2];

						$cookie_value = ( isset( $_COOKIE[ $cookie_key ] ) ? $_COOKIE[ $cookie_key ] : null );
						if ( is_null( $cookie_value ) ) {
							return false;
						}

						if( $compare == 'starts_with' ) {
							$condition_met = substr( $cookie_value, 0, strlen( $user_value ) ) === $user_value;
						} elseif( $compare == 'ends_with' ) {
							$string_length = strlen( $user_value );
							$condition_met = ( $string_length === 0 || substr( $cookie_value, - $string_length ) === $user_value );
						} elseif( $compare == 'contains' ) {
							$condition_met = strstr( $cookie_value, $user_value );
						} elseif( $compare == 'contains_not' ) {
							$condition_met = ! strstr( $cookie_value, $user_value );
						} else {
							$condition_met = self::execute_math_logic( 
								[ 'compare' => $compare, 'value' => $user_value ], 
								$cookie_value 
							);
						}
					} else {
						if( $compare == 'is_set' && isset( $_COOKIE[ $condition['value'] ] ) ) {
							$condition_met = true;
						}

						if( $compare == 'is_not_set' && ! isset( $_COOKIE[ $condition['value'] ] ) ) {
							$condition_met = true;
						}
					}
				}
				break;

			case 'is_doing_ajax':
				$condition_met = self::execute_true_false_logic( $condition, wp_doing_ajax() );
				break;

			case 'buedd_product_purchased':
				$user_value = isset( $condition['value'] ) ? $condition['value'] : false;
				if ( $user_value && function_exists( 'edd_has_user_purchased' ) ) {
					$condition_met = self::execute_true_false_logic( $condition, \edd_has_user_purchased(get_current_user_id(), intval($user_value) ) );
				}
				break;

			case 'buedd_subscribed':
				$user_value = isset( $condition['value'] ) ? $condition['value'] : false;
				if ( $user_value && class_exists( '\EDD_Recurring_Subscriber' ) ) {
					$subscriber = new \EDD_recurring_subscriber( get_current_user_id(), true );
					$value = $subscriber->has_active_product_subscription( intval($user_value) );
					$condition_met = self::execute_true_false_logic( $condition, $value );
				}
				break;

			case 'bu_memberpress_membership':
				$user_value = isset( $condition['value'] ) ? $condition['value'] : false;
				if ( $user_value && class_exists( '\MeprSubscription' )) {
					$value = current_user_can("mepr-active","membership: $user_value");
					$condition_met = self::execute_true_false_logic( $condition, $value );
				}
				break;

			case 'buwp_members_membership':
				$user_value = isset( $condition['value'] ) ? $condition['value'] : false;
				if ( $user_value && class_exists( '\WP_Members_Products' ) ) {
					$product_name = get_post_field( 'post_name', intval( $user_value ) );
					$condition_met = self::execute_true_false_logic( $condition, \wpmem_user_has_access( $product_slug ) );
				}
				break;

			case 'buwc_subscriptions':
				$user_value = isset( $condition['value'] ) ? $condition['value'] : false;
				if ( $user_value && class_exists( '\WC_Subscriptions' ) ) {
					$condition_met = self::execute_true_false_logic( $condition, \wcs_user_has_subscription( '', intval( $user_value ), 'active' ) );
				}
				break;

			case 'bupmp_membership_level':
				$user_value = isset( $condition['value'] ) ? $condition['value'] : 'non-members';
				if ( $user_value && class_exists( '\PMPro_Membership_Level' ) ) {
					$isNonMember = ! \pmpro_hasMembershipLevel();
					$hasMembershipLevel = \pmpro_hasMembershipLevel( $user_value );
					if ( $user_value === 'non-members' ) {
						$condition_met = self::execute_true_false_logic( $condition, $isNonMember );
					} else {
						$condition_met = self::execute_true_false_logic( $condition, $hasMembershipLevel );
					}
				}
				break;

			case 'burcp_has_active_membership':
				if ( function_exists( 'rcp_user_has_active_membership' )  ) {
					$condition_met = self::execute_true_false_logic( $condition, \rcp_user_has_active_membership() );
				}
				break;

			case 'burcp_has_paid_membership':
				if ( function_exists( 'rcp_user_has_paid_membership' )  ) {
					$condition_met = self::execute_true_false_logic( $condition, \rcp_user_has_paid_membership() );
				}
				break;

			case "bu_language_visitor":
				$value = $condition['value'] ?? 'en-US';
				$languages = isset( $_SERVER['HTTP_ACCEPT_LANGUAGE'] ) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : false;

				if (false !== $languages) {
					$pos = strpos( $languages, ',' );
					$language = substr( $languages, 0, $pos );
					$condition_met = self::execute_math_logic( $condition, $language );
				}
			break;

			case 'bu_wpml_language':
				if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
					$current_language = apply_filters( 'wpml_current_language', null );

					if( empty( $condition['value'] ) )
						$condition['value'] = apply_filters('wpml_default_language', NULL );

					$condition_met = self::execute_math_logic($condition, $current_language);
				}
			break;

			case 'bu_polylang_language':
				if( function_exists('pll_current_language') && function_exists('pll_default_language') ) {
					$current_language = pll_current_language();

					if( empty( $condition['value'] ) )
						$condition['value'] = pll_default_language();

					$condition_met = self::execute_math_logic($condition, $current_language);
				}
			break;
		}

		return $condition_met;
	}

	public function get_conditional_tags_conditions() {
		$tags = [];

		$tags['is_parent_page'] = [
			'label' => esc_html__( 'Is parent post/page', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_child_page'] = [
			'label' => esc_html__( 'Is child post/page', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_front_page'] = [
			'label' => esc_html__( 'Is front page', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_home'] = [
			'label' => esc_html__( 'Is blog page', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_page'] = [
			'label' => esc_html__( 'All pages - is_page()', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_page_id'] = [
			'label' => esc_html__( 'Specific page(s)', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'equaltext',
			'placeholder' => esc_html__( 'enter id or slug like 42, about-me, contact', 'bricksultimate' )
		];

		$tags['is_single'] = [
			'label' => esc_html__( 'All single pages - is_single()', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_singular'] = [
			'label' => esc_html__( 'Specific singular page(s)', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'equaltext',
			'placeholder' => esc_html__( 'enter post type like post, product', 'bricksultimate' )
		];

		$tags['is_archive'] = [
			'label' => esc_html__( 'Archive pages - is_archive()', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_category'] = [
			'label' => esc_html__( 'All category pages - is_category()', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_category_id'] = [
			'label' => esc_html__( 'Specific categories page', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'equaltext',
			'placeholder' => esc_html__( '9, blue-cheese, news', 'bricksultimate' ),
			'info' => esc_html__( 'enter term name/id/slug', 'bricksultimate' )
		];

		$tags['is_tag'] = [
			'label' => esc_html__( 'All post tags - is_tag()', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_tag_id'] = [
			'label' => esc_html__( 'Specific tags page', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'equaltext',
			'placeholder' => esc_html__( '30, mild, extreme', 'bricksultimate' ),
			'info' => esc_html__( 'enter term name/id/slug', 'bricksultimate' )
		];

		$tags['is_tax'] = [
			'label' => esc_html__( 'All taxonomy pages - is_tax()', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_term_id'] = [
			'label' => esc_html__( 'Specific terms page', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'equaltext',
			'placeholder' => esc_html__( 'product_cat:9, blue-cheese, news', 'bricksultimate' ),
			'info' => esc_html__( 'enter term taxonomyname:name/id/slug', 'bricksultimate' )
		];

		$tags['is_post_type_archive'] = [
			'label' => esc_html__( 'Post type archive pages', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'equaltext',
			'placeholder' => esc_html__('product, events, services', 'bricksultimate'),
			'info' => esc_html__('Enter custom post type slug. Leave blank for all post types.', 'bricksultimate')
		];

		$tags['is_author'] = [
			'label' => esc_html__( 'All author pages - is_author()', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse'
		];

		$tags['is_author_id'] = [
			'label' => esc_html__( 'Specific author page(s)', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'equaltext',
			'placeholder' => esc_html__( '4,john-jones,Vivian', 'bricksultimate' )
		];

		$tags['is_doing_ajax'] = [
			'label' => esc_html__( 'Is doing AJAX?', 'bricksultimate' ),
			'group' => 'buct',
			'type' => 'truefalse',
		];

		$tags['taxonomy_exists'] = [
			'label' => esc_html__( 'Taxonomy exists', 'bricksultimate' ),
			'group' => 'buterms',
			'type' => 'dropdown',
			'options' => \Bricks\Setup::$control_options['taxonomies'],
			'placeholder' => esc_html__( 'category', 'bricksultimate' )
		];

		$tags['term_is'] = [
			'label' => esc_html__( 'Is Term', 'woocommerce' ),
			'group' => 'buterms',
			'type' => 'equaltext',
			'placeholder' => esc_html__( 'accepts term ID, slug, or name', 'bricksultimate' ),
			'info' => esc_html__('Work on term archive page and inside the terms loop builder.', 'bricksultimate')
		];

		$tags['has_term'] = [
			'label' => esc_html__( 'Has terms - current post', 'bricksultimate' ),
			'group' => 'buterms',
			'type' => 'equaltext',
			'placeholder' => 'category:12,23,24',
			'info' => esc_html__('Checks if the current post has any of given terms. Syntax:- taxonomyname:terms name/id/slug', 'bricksultimate')
		];

		$tags['is_parent_term'] = [
			'label' => esc_html__( 'Is parent term', 'bricksultimate' ),
			'group' => 'buterms',
			'type' => 'truefalse'
		];

		$tags['has_children'] = [
			'label' => esc_html__( 'Has children', 'bricksultimate' ),
			'group' => 'buterms',
			'type' => 'truefalse'
		];

		$tags['has_ancestors'] = [
			'label' => esc_html__( 'Has ancestors', 'bricksultimate' ),
			'group' => 'buterms',
			'type' => 'truefalse'
		];

		$tags['bu_cookie'] = [
			'label' => esc_html__( 'Cookie', 'bricksultimate' ),
			'group' => 'buct',
			'type' 	=> 'bricks'
		];

		$tags['has_wishlist'] = [
			'label' => esc_html__( 'Is wishlist empty?', 'bricksultimate' ),
			'group' => 'buct',
			'type' 	=> 'dropdown',
			'options' => \Bricks\Helpers::get_registered_post_types(),
			'placeholder' => esc_html__('select post type', 'bricksultimate')
		];

		$tags['has_compare_items'] = [
			'label' => esc_html__( 'Has compare items?', 'bricksultimate' ),
			'group' => 'buct',
			'type' 	=> 'dropdown',
			'options' => \Bricks\Helpers::get_registered_post_types(),
			'placeholder' => esc_html__('select post type', 'bricksultimate')
		];

		$tags['bu_language_visitor'] = [
			'label' => esc_html__( 'Language (visitor)', 'bricksultimate' ),
			'group' => 'other',
			'type' => 'truefalsetext',
			'placeholder' => 'en-US'
		];

		if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
			$languages = apply_filters( 'wpml_active_languages', NULL, 'orderby=name&order=asc' );
			$lang_array = [];
			foreach( $languages as $language ) {
				$lang_array[$language['language_code']] = $language['translated_name'];
			}

			$tags['bu_wpml_language'] = [
				'label' => esc_html__( 'WPML language', 'bricksultimate' ),
				'group' => 'other',
				'type' => 'dropdown2nd',
				'options' => $lang_array,
				'placeholder' => $lang_array[apply_filters( 'wpml_default_language', NULL )]
			];
		}

		if ( function_exists( 'pll_count_posts' ) && function_exists('pll_default_language') ) {
			$lang_array = array_combine( pll_languages_list(), pll_languages_list( [ 'fields' => 'name' ] ) );

			$tags['bu_polylang_language'] = [
				'label' => esc_html__( 'Polylang language', 'bricksultimate' ),
				'group' => 'other',
				'type' => 'dropdown2nd',
				'options' => $lang_array,
				'placeholder' => pll_default_language( 'name' )
			];
		}

		if ( function_exists( 'EDD' ) ) {
			$tags['buedd_product_purchased'] = [
				'label' => esc_html__( 'User purchased download', 'bricksultimate' ),
				'group' => 'buedd',
				'type' 	=> 'dropdown2nd',
				'options' => $this->getPostOptions('download'),
				'placeholder' => esc_html__('Select product...', 'bricksultimate'),
			];

			$tags['buedd_subscribed'] = [
				'label' => esc_html__( 'User subscription', 'bricksultimate' ),
				'group' => 'buedd',
				'type' 	=> 'dropdown2nd',
				'options' => $this->getPostOptions('download'),
				'placeholder' => esc_html__('Select product...', 'bricksultimate'),
			];
		}

		if ( class_exists( '\MeprSubscription' ) ) {
			$tags['bu_memberpress_membership'] = [
				'label' => esc_html__( 'Has membership (MemberPress)', 'bricksultimate' ),
				'group' => 'buct',
				'type' => 'dropdown',
				'options' => $this->getPostOptions('memberpressproduct'),
				'placeholder' => esc_html__( 'Select membership...', 'bricksultimate' )
			];
		}

		if ( class_exists( '\WP_Members_Products' ) ) {
			$tags['buwp_members_membership'] = [
				'label' => esc_html__( 'Has membership (WP Members)', 'bricksultimate' ),
				'group' => 'buct',
				'type' => 'dropdown',
				'options' => $this->getPostOptions('wpmem_product'),
				'placeholder' => esc_html__( 'Select product...', 'bricksultimate' )
			];
		}

		if ( class_exists( '\WC_Subscriptions' ) ) {
			$tags['buwc_subscriptions'] = [
				'label' => esc_html__( 'Has active subscription (WooCommerce Subscriptions)', 'bricksultimate' ),
				'group' => 'buct',
				'type' => 'dropdown',
				'options' => $this->getPostOptions('product'),
				'placeholder' => esc_html__( 'Select subscription product...', 'bricksultimate' )
			];
		}

		if ( class_exists( '\PMPro_Membership_Level' ) ) {
			global $pmpro_levels;

			$ddOptions = [ 'non-members' => esc_html__( 'Non-Members', 'bricksultimate' ) ];

			if ( ! empty( $pmpro_levels ) ) {
				foreach( $pmpro_levels as $pmpro_level ) {
					$ddOptions[$pmpro_level->id] = $pmpro_level->name;
				}
			}

			$tags['bupmp_membership_level'] = [
				'label' => esc_html__( 'Paid Memberships Pro Level', 'bricksultimate' ),
				'group' => 'buct',
				'type' => 'dropdown',
				'options' => $ddOptions,
				'placeholder' => esc_html__( 'Non-Members', 'bricksultimate' )
			];
		}

		if ( function_exists( 'rcp_get_membership_levels' )  ) {
			$tags['burcp_has_active_membership'] = [
				'label' => esc_html__( 'Has active membership (Restrict Content)', 'bricksultimate' ),
				'group' => 'buct',
				'type' => 'truefalse'
			];

			$tags['burcp_has_paid_membership'] = [
				'label' => esc_html__( 'Has paid membership (Restrict Content)', 'bricksultimate' ),
				'group' => 'buct',
				'type' => 'truefalse'
			];
		}

		return $tags;
	}

	public static function getLoopObject() {
		$looping_query_id = \Bricks\Query::is_any_looping();
		$object = false;

		if ( ! empty( $looping_query_id ) ) {
			$object = \Bricks\Query::get_loop_object( $looping_query_id );
		}

		return $object;
	}

	function getPostOptions($postType = 'download') {
		$options = [];

		if( ! bricks_is_builder() )
			return $options;

		$args = array(
			'post_type' 		=> $postType,
			'posts_per_page' 	=> -1,
			'orderby' 			=> 'title',
			'order' 			=> 'ASC'
		);

		$posts = \get_posts( $args );
		if ( ! empty( $posts ) ) {
			foreach ( $posts as $post ) {
				$options[$post->ID] = $post->post_title;
			}
		}

		\wp_reset_postdata();
		return $options;
	}
}