<?php
namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CartItems {
	public function __construct() {
		add_filter( "bricks/elements/woocommerce-cart-items/control_groups", [ $this, 'add_cart_items_control_groups' ] );
		add_filter( "bricks/elements/woocommerce-cart-items/controls", [ $this, 'filter_cart_items_controls' ] );
	}

	/**
	 * Adds extra control group for cart items element
	 * 
	 * @since 0.4
	 * @param array $control_groups
	 * @return array $control_groups
	 */
	public function add_cart_items_control_groups( $control_groups ) {
		unset( $control_groups['buttons'] );
		unset( $control_groups['coupon'] );

		$control_groups['qty'] = [
			'title' => esc_html__( 'Quantity', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['buttons'] = [
			'title' => esc_html__( 'Buttons', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['update'] = [
			'title' => esc_html__( 'Update Cart', 'bricksultimate' ),
			'tab'   => 'content',
		];

		$control_groups['coupon'] = [
			'title' => esc_html__( 'Coupon wrapper', 'bricks' ),
			'tab'   => 'content',
		];

		$control_groups['couponfield'] = [
			'title' => esc_html__( 'Coupon field', 'bricks' ),
			'tab'   => 'content',
		];

		return $control_groups;
	}

	public function filter_cart_items_controls( $controls ) {
		//* Quantity
		$selector = '.quantity';

		$controls['qtyWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'qty',
			'type'      => 'number',
			'label'     => esc_html__( 'Wrapper Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '200px',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['qtyHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'qty',
			'type'      => 'number',
			'label'     => esc_html__( 'Wrapper Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				],
				[
					'property' => 'line-height',
					'selector' => '.quantity input'
				],
				[
					'property' => 'height',
					'selector' => $selector . ' .action',
				],
				[
					'property' => 'height',
					'selector' => $selector . ' input',
				]
			],
		];

		$controls['wraprBg'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Wrapper Background', 'bricksultimate' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			]
		];

		$controls['wrapBorder'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Wrapper Border', 'bricksultimate' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			],
		];

		$controls['pmBtnSep'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( '+/- Buttons', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$controls['hidePMBtns'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hide +/- Buttons', 'bricksultimate' ),
			'type'  => 'checkbox',
			'reset' => true,
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action',
					'property' 	=> 'display',
					'value' 	=> 'none'
				]
			]
		];

		$controls['pmBtnWidth'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $selector . ' .action',
				]
			],
			'placeholder' => '45px'
		];

		$controls['pmBtnSize'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'type'  => 'number',
			'unit' 	=> 'px',
			'placeholder' => '14px', 
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'width',
				],
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'height',
				]
			]
		];

		$controls['pmBtnBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action',
					'property' 	=> 'background-color',
				]
			]
		];

		$controls['pmBtnColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'color'
				]
			]
		];

		$controls['pmBtnBrd'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action',
					'property' 	=> 'border',
					'important' => true
				]
			]
		];

		$controls['pmBtnHBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Background', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover',
					'property' 	=> 'background-color',
				]
			]
		];

		$controls['pmBtnHColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover',
					'property' 	=> 'color',
					'important' => true
				]
			]
		];

		$controls['pmBtnHBrd'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Border', 'bricks' ),
			'type'  => 'border',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover',
					'property' 	=> 'border',
					'important' => true
				]
			]
		];

		$controls['inpSep'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Quantity field', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$controls['inpWidth'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $selector . ' .qty',
				],
			],
			'default' => '45px'
		];

		$controls['inpBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty',
					'property' 	=> 'background-color',
				]
			]
		];

		$controls['inpColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty',
					'property' 	=> 'color',
				]
			]
		];

		$controls['inpFocusBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Focus Background', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty:focus',
					'property' 	=> 'background-color',
				]
			]
		];

		$controls['inpFocusColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Focus Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty:focus',
					'property' 	=> 'color',
				]
			]
		];

		//* buttons
		$selector = '.button';

		$controls['buttonsShadow'] = [
			'tab'   => 'content',
			'group' => 'buttons',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				],
			],
		];

		$controls['buttonsTextSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buttons',
			'type'      => 'separator',
			'label'     => esc_html__('Text', 'bricksultimate'),
		];

		$controls['applyCouponText'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buttons',
			'type'      => 'text',
			'label'     => esc_html__( 'Apply coupon', 'woocommerce' ),
			'placeholder' => esc_html__( 'Apply coupon', 'woocommerce' ),
			'hasDynamicData' => false
		];

		$controls['updateCartText'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buttons',
			'type'      => 'text',
			'label'     => esc_html__( 'Update cart', 'woocommerce' ),
			'placeholder' => esc_html__( 'Update cart', 'woocommerce' ),
			'hasDynamicData' => false
		];

		$controls['buttonsSizeSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buttons',
			'type'      => 'separator',
			'label'     => esc_html__('Size & Spacing', 'bricksultimate'),
		];

		$controls['buttonsWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buttons',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['buttonsHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buttons',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$controls['buttonsMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buttons',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'default' 	=> [
				'top' 	=> 32
			],
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				],
			],
		];

		$controls['buttonsPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buttons',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
		];

		$controls['buttonsSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'buttons',
			'type'      => 'separator',
			'label'     => esc_html__('Hover', 'bricksultimate'),
		];

		$controls['buttonsHoverBackground'] = [
			'tab'   => 'content',
			'group' => 'buttons',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['buttonsHoverColor'] = [
			'tab'   => 'content',
			'group' => 'buttons',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['buttonsHoverBorder'] = [
			'tab'   => 'content',
			'group' => 'buttons',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['buttonsHoverBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'buttons',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector . ':hover',
				],
			],
		];



		//* Update button
		$selector = 'button[name="update_cart"]';
		$disabled = 'button[name="update_cart"]:disabled';

		$controls['updateWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'update',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['updateHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'update',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$controls['updateMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'update',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'default' 	=> [
				'top' 	=> 32
			],
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				],
			],
		];

		$controls['updatePadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'update',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
		];

		$controls['defaultSeparator'] = [
			'tab' 		=> 'content',
			'group' 	=> 'update',
			'type'      => 'separator',
			'label'     => esc_html__( 'Default', 'bricks' ),
		];

		$controls['updateTypography'] = [
			'tab'   => 'content',
			'group' => 'update',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			],
		];

		$controls['updateBackground'] = [
			'tab'   => 'content',
			'group' => 'update',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			],
		];

		$controls['updateBorder'] = [
			'tab'   => 'content',
			'group' => 'update',
			'type'  => 'border',
			'label' => esc_html__( 'Border', 'bricks' ),
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			]
		];

		$controls['updateShadow'] = [
			'tab'   => 'content',
			'group' => 'update',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				],
			],
		];

		$controls['disabledSeparator'] = [
			'tab' 		=> 'content',
			'group' 	=> 'update',
			'type'      => 'separator',
			'label'     => esc_html__( 'Disabled', 'bricks' ),
		];

		$controls['disabledOpacity'] = [
			'tab' 		=> 'content',
			'group' 	=> 'update',
			'type'      => 'number',
			'label'     => esc_html__( 'Opacity', 'bricks' ),
			'unitsless' => true,
			'min' 		=> 0,
			'max' 		=> 1,
			'step' 		=> 0.1,
			'placeholder' => '0.5',
			'css'   	=> [
				[
					'property' => 'opacity',
					'selector' => $disabled,
				]
			],
		];

		$controls['disabledBackground'] = [
			'tab'   => 'content',
			'group' => 'update',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $disabled,
				],
			],
		];

		$controls['disabledColor'] = [
			'tab'   => 'content',
			'group' => 'update',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $disabled,
				],
			],
		];

		$controls['updateBtnHover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'update',
			'type'      => 'separator',
			'label'     => esc_html__('Hover', 'bricksultimate'),
		];

		$controls['updateBtnHoverBackgroundColor'] = [
			'tab'   => 'content',
			'group' => 'update',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['updateBtnHoverColor'] = [
			'tab'   => 'content',
			'group' => 'update',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['updateBtnHoverBorder'] = [
			'tab'   => 'content',
			'group' => 'update',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['updateBtnHoverBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'update',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector . ':hover',
				],
			],
		];


		//* Coupon
		$selector = '.coupon';

		$controls['couponPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'coupon',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
		];

		$controls['couponBackground'] = [
			'tab'   => 'content',
			'group' => 'coupon',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			],
		];

		$controls['couponDisplay'] = [
			'tab'         => 'content',
			'group'       => 'coupon',
			'label'       => esc_html__( 'Display', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'flex'         => 'flex',
				'inline-flex'  => 'inline-flex',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'      => true,
			'lowercase'   => true,
			'css'         => [
				[
					'property' => 'display',
					'selector' => $selector
				],
			],
			'placeholder' => 'flex'
		];

		$controls['couponFlexWrap'] = [
			'tab'         	=> 'content',
			'group' 		=> 'coupon',
			'label'       	=> esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'     	=> [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'        	=> 'select',
			'options'     	=> \Bricks\Setup::get_control_options('flexWrap'),
			'inline'     	=> true,
			'css'         	=> [
				[
					'property' => 'flex-wrap',
					'selector' => $selector
				],
			],
			'placeholder' => esc_html__( 'noWrap', 'bricks' ),
			'required' => ['couponDisplay', '=', [ '', 'flex' ] ]
		];

		$controls['couponFlexDirection'] = [
			'tab'      => 'content',
			'group'    => 'coupon',
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
					'selector' => $selector
				],
			],
			'inline'   => true,
			'rerender' => true,
			'required' => ['couponDisplay', '=', [ '', 'flex' ] ]
		];


		//* Coupon input field
		$selector = 'input[name="coupon_code"]';

		$controls['cpfText'] = [
			'tab' 		=> 'content',
			'group' 	=> 'couponfield',
			'type'      => 'text',
			'label'     => esc_html__( 'Placeholder text', 'bricksultimate' ),
			'placeholder' => esc_html__( 'Coupon code', 'woocommerce' ),
			'hasDynamicData' => false
		];

		$controls['cpfWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'couponfield',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['cpfHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'couponfield',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$controls['cpfMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'couponfield',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				],
			],
		];

		$controls['cpfPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'couponfield',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
		];

		$controls['cpfSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'couponfield',
			'type'      => 'separator',
		];

		$controls['cpfBackground'] = [
			'tab'   => 'content',
			'group' => 'couponfield',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			],
		];

		$controls['couponTypography'] = [
			'tab'   => 'content',
			'group' => 'couponfield',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			],
		];

		$controls['cpfPlaceholder'] = [
			'tab'   => 'content',
			'group' => 'couponfield',
			'label' => esc_html__( 'Placeholder', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . "::placeholder",
				],
			],
		];

		$controls['cpfBorder'] = [
			'tab'   => 'content',
			'group' => 'couponfield',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			],
		];

		$controls['cpfBS'] = [
			'tab'   => 'content',
			'group' => 'couponfield',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				],
			],
		];

		$controls['cpfocusSep'] = [
			'tab'   => 'content',
			'group' => 'couponfield',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Focus', 'bricks' ),
		];

		$controls['cpfocusBackground'] = [
			'tab'   => 'content',
			'group' => 'couponfield',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector . ':focus',
				],
			],
		];

		$controls['cpfocusColor'] = [
			'tab'   => 'content',
			'group' => 'couponfield',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . ':focus',
				],
			],
		];

		$controls['cpfocusBorder'] = [
			'tab'   => 'content',
			'group' => 'couponfield',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector . ':focus',
				],
			],
		];

		$controls['cpfocusBS'] = [
			'tab'   => 'content',
			'group' => 'couponfield',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector . ':focus',
				],
			],
		];

		return $controls;
	}
}