<?php
namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CartTotals {
	public function __construct() {
		add_filter( "bricks/elements/woocommerce-cart-collaterals/control_groups", [ $this, 'add_cart_collaterals_control_groups' ] );
		add_filter( "bricks/elements/woocommerce-cart-collaterals/controls", [ $this, 'filter_cart_collaterals_controls' ] );
	}

	public function add_cart_collaterals_control_groups( $control_groups ) {
		$control_groups['form'] = [
			'title' 	=> esc_html__('Shipping Form', 'bricksultimate'),
			'tab' 		=> 'content',
		];

		return $control_groups;
	}

	public function filter_cart_collaterals_controls( $controls ) {
		//* Quantity
		$selector = '.wc-proceed-to-checkout .button';

		$controls['buttonBS'] = [
			'tab' 		=> 'content',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box Shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				]
			],
		];

		$controls['buttonHoverBackground'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Hover Background', 'bricksultimate' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['buttonHoverColor'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Hover Color', 'bricksultimate' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['buttonHoverBorder'] = [
			'tab'   => 'content',
			'type'  => 'border',
			'label' => esc_html__( 'Hover Border', 'bricksultimate' ),
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['buttonHoverBS'] = [
			'tab'   => 'content',
			'type'  => 'box-shadow',
			'label' => esc_html__( 'Hover Box Shadow', 'bricksultimate' ),
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['buttonAlign'] = [
			'tab' 		=> 'content',
			'type'      => 'text-align',
			'label'     => esc_html__( 'Alignment', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'text-align',
					'selector' => '.wc-proceed-to-checkout',
				]
			],
		];

		$controls['buttonWidth'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['buttonHeight'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$controls['buttonMargin'] = [
			'tab' 		=> 'content',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		$controls['buttonPadding'] = [
			'tab' 		=> 'content',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$controls['formPreview'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'checkbox',
			'label'     => esc_html__( 'Show Form On Builder', 'bricksultimate' ),
			'info' 		=> esc_html__( 'Enable this option when you are editing the style', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> '&.bricks-highlight-element .shipping-calculator-form',
					'value' 	=> 'block',
					'important' => true
				]
			],
			'reset' 	=> true,
		];

		$controls['shippingLabel'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'typography',
			'label'     => esc_html__( 'Shipping label', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.woocommerce-shipping-totals.shipping th',
				]
			]
		];

		$controls['shippingLabelAlign'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'checkbox',
			'label'     => esc_html__( 'Shipping label algin at top', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' 	=> 'vertical-align',
					'selector' 	=> '.woocommerce-shipping-totals.shipping th',
					'value' 	=> 'top'
				]
			]
		];

		$controls['formInfo'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'checkbox',
			'label'     => esc_html__( 'Hide shipping info', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> '.woocommerce-shipping-destination',
					'value' 	=> 'none'
				]
			],
			'reset' 	=> true,
		];

		$controls['infoTg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'typography',
			'label'     => esc_html__( 'Shipping info', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.woocommerce-shipping-destination',
				]
			],
			'required' 	=> ['formInfo', '!=', true]
		];

		$controls['addressSeparator'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'separator',
			'label'     => esc_html__( 'Change address link', 'bricksultimate' ),
		];

		$controls['changeAddressTg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.shipping-calculator-button',
				]
			]
		];

		$controls['changeAddressColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'color',
			'label'     => esc_html__( 'Hover color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => '.shipping-calculator-button:hover',
				]
			]
		];

		$selector = '.shipping-calculator-form';

		$controls['formSeparator'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'separator',
			'label'     => esc_html__( 'Wrapper', 'bricksultimate' ),
		];

		$controls['formWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'number',
			'label'     => esc_html__( 'Max Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'max-width',
					'selector' => $selector,
				]
			],
		];

		$controls['formSpacing'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Spacing', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		$selector = '.shipping-calculator-form .input-text, .shipping-calculator-form .select2-selection';

		$controls['fieldsSeparator'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'separator',
			'label'     => esc_html__( 'Input fields', 'bricksultimate' ),
		];

		$controls['formBackground'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$controls['formTypography'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$controls['formPlaceholder'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'color',
			'label'     => esc_html__( 'Placeholder', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => '.shipping-calculator-form .input-text::placeholder'
				]
			],
		];

		$controls['formBorder'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$controls['formFBg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'color',
			'label'     => esc_html__( 'Focus Background', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => '.shipping-calculator-form .input-text:focus'
				]
			],
		];

		$controls['textFColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'color',
			'label'     => esc_html__( 'Focus Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => '.shipping-calculator-form .input-text:focus'
				]
			],
		];

		$controls['textFBrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'border',
			'label'     => esc_html__( 'Focus Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => '.shipping-calculator-form .input-text:focus'
				]
			],
		];

		/*$controls['dropdownSeparator'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'separator',
			'label'     => esc_html__( 'Dropdown fields', 'bricksultimate' ),
		];*/

		$controls['btnSeparator'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'separator',
			'label'     => esc_html__( 'Button', 'bricksultimate' ),
		];

		$selector = '.shipping-calculator-form .button';

		$controls['formButtonWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['formButtonHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'min-height',
					'selector' => $selector,
				]
			],
		];

		$controls['formButtonMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		$controls['formButtonPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$controls['formButtonAlign'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'text-align',
			'label'     => esc_html__( 'Alignment', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'text-align',
					'selector' => '.shipping-calculator-form p:last-of-type',
				]
			],
		];

		$controls['formButtonSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'separator',
		];

		$controls['formButtonBG'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'color',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector,
				]
			],
		];

		$controls['formButtonTG'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector,
				]
			],
		];

		$controls['formButtonBrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector,
				]
			],
		];

		$controls['formButtonBS'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form',
			'type'      => 'box-shadow',
			'label'     => esc_html__( 'Box Shadow', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				]
			],
		];

		$controls['formBtnHoverBackground'] = [
			'tab'   	=> 'content',
			'group' 	=> 'form',
			'label' 	=> esc_html__( 'Hover Background', 'bricksultimate' ),
			'type'  	=> 'color',
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['formBtnHoverColor'] = [
			'tab'   	=> 'content',
			'group' 	=> 'form',
			'label' 	=> esc_html__( 'Hover Color', 'bricksultimate' ),
			'type'  	=> 'color',
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['formBtnHoverBorder'] = [
			'tab'   	=> 'content',
			'group' 	=> 'form',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Hover Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['formBtnHoverBS'] = [
			'tab'   	=> 'content',
			'group' 	=> 'form',
			'type'  	=> 'box-shadow',
			'label' 	=> esc_html__( 'Hover Box Shadow', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector . ':hover',
				],
			],
		];

		return $controls;
	}
}