<?php
namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Plugin;

class ImageMask {
	public function __construct() {
		add_filter( "bricks/elements/image/controls", [ $this, 'add_image_controls' ], 10, 1 );
	}

	/**
	 * Adds image mask controls in image element
	 * 
	 * @param array $controls
	 * @return array $controls
	 */
	public function add_image_controls( $controls ) {
		$controls['mask_sep'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Image Mask', 'bricksultimate' ),
			'type'  	=> 'separator',
		];

		$path = Plugin::instance()->get_root_url();
		$shapes['none'] = esc_html__('Select mask', 'bricksultimate');
		for ($i=1; $i <= 64 ; $i++) { 
			$shapes[ "shape-" . $i ] = "Shape " . $i;
		}

		$controls['mask_shape'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Shape', 'bricksultimate'),
			'options' 	=> $shapes,
			'medium'	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property' 	=> "-webkit-mask-image",
					'value'    	=> "url({$path}assets/shapes/%s.svg)",
				],
				[
					'selector' 	=> '',
					'property' 	=> "mask-image",
					'value'    	=> "url({$path}assets/shapes/%s.svg)",
				]
			]
		];

		$controls['mask_direction'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Direction', 'bricksultimate'),
			'options' 	=> [
				'none' 			=> __('None', 'bricks'), 
				'scaleX(-1)' 	=> __('Horizontal'), 
				'scaleY(-1)' 	=> __('Vertical')
			],
			'default' 	=> 'none',
			'medium'	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property' 	=> "transform"
				],
				[
					'selector' 	=> 'img',
					'property' 	=> "transform"
				]
			]
		];

		$controls['mask_size'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Size', 'bricksultimate'),
			'options' 	=> [
				'auto' 		=> __('Auto', 'bricks'), 
				'cover' 	=> __('Cover', 'bricks'), 
				'contain' 	=> __('Contain', 'bricks'), 
				'unset' 	=> __('Custom', 'bricksultimate')
			],
			'default' 	=> 'cover',
			'medium'	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property' 	=> "-webkit-mask-size"
				]
			]
		];

		$controls['mask_custom_size'] = [
			'tab' 		=> 'content',
			'type'      => 'slider',
			'label'     => esc_html__('Set Custom Size', 'bricksultimate'),
			'units' 	=> [
				'px' => [
					'min'  => 0,
					'max'  => 10000,
					'step' => 1,
				]
			],
			'css' 		=> [
				[
					'selector' 	=> '',
					'property' 	=> '-webkit-mask-size'
				]
			],
			'required' 	=> [ 'mask_size', '=', 'unset' ],
		];

		$controls['mask_repeat'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Repeat', 'bricksultimate'),
			'options' 	=> [
				'no-repeat' => __("No"),
				'repeat' 	=> __('Yes')
			],
			'default' 	=> 'no-repeat',
			'medium'	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property' 	=> "-webkit-mask-repeat"
				]
			]
		];

		$controls['mask_postion'] = [
			'tab'  		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Position', 'bricksultimate'),
			'options' 	=> [
				'top' 		=> esc_html__('Top', 'bricks'), 
				'bottom' 	=> esc_html__('Bottom', 'bricks'), 
				'center' 	=> esc_html__('Center', 'bricks'),
				'left' 		=> esc_html__('Left', 'bricks'),
				'right' 	=> esc_html__('Right', 'bricks'),
				'unset' 	=> esc_html__('Custom', 'bricksultimate'),
			],
			'default' 	=> 'center',
			'medium'	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property' 	=> "-webkit-mask-position"
				]
			]
		];

		$controls['mask_postion_x'] = [
			'tab' 		=> 'content',
			'type'      => 'slider',
			'label'     => esc_html__('X Offset', 'bricksultimate'),
			'units' 	=> [
				'px' => [
					'min'  => -10000,
					'max'  => 10000,
					'step' => 1,
				]
			],
			'css' 		=> [
				[
					'selector' 	=> '',
					'property' 	=> '-webkit-mask-position-x'
				]
			],
			'required' 	=> [ 'mask_postion', '=', 'unset' ],
		];

		$controls['mask_postion_y'] = [
			'tab' 		=> 'content',
			'type'      => 'slider',
			'label'     => esc_html__('Y Offset', 'bricksultimate'),
			'units' 	=> [
				'px' => [
					'min'  => -10000,
					'max'  => 10000,
					'step' => 1,
				]
			],
			'css' 		=> [
				[
					'selector' 	=> '',
					'property' 	=> '-webkit-mask-position-y'
				]
			],
			'required' 	=> [ 'mask_postion', '=', 'unset' ],
		];

		return $controls;
	}
}