<?php
namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class NavNestable {
	public function __construct() {
		//add_filter( "bricks/elements/nav-nested/control_groups", array( $this, 'add_nav_nested_control_groups' ) );
		add_filter( "bricks/elements/dropdown/controls", [ $this, 'add_nav_nested_controls' ] );
	}

	public function add_nav_nested_controls( $controls ) {
		$selector = '.brx-submenu-toggle';

		$controls['sepTopLabel'] = [
			'tab' 		=> 'content',
			'type'      => 'separator',
			'label'     => esc_html__( 'Top Level Item', 'bricksultimate' )
		];

		$controls['width'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['maxWidth'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__( 'Max. Width', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'max-width',
					'selector' => $selector,
				]
			],
		];

		$controls['topLevelBG'] = [
			'tab' 		=> 'content',
			'type'      => 'color',
			'label'     => esc_html__( 'Background color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
				[
					'property' => 'background-color',
					'selector' => '&.open > ' . $selector,
				]
			],
		];

		$controls['topLevelTg'] = [
			'tab' 		=> 'content',
			'type'      => 'typography',
			'label'     => esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector,
				]
			],
		];

		$controls['zIndex'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'unitless' 	=> true,
			'label'     => esc_html__( 'z-index', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'z-index',
					'selector' => $selector,
				]
			],
		];

		$controls['toggleOrder'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'unitless' 	=> true,
			'label'     => esc_html__( 'Order', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'order',
					'selector' => $selector,
				]
			],
		];

		$controls['listStyle'] = [
			'tab' 		=> 'content',
			'type'      => 'text',
			'label'     => esc_html__( 'List style', 'bricksultimate' ),
			'placeholder' => 'none',
			'css'   	=> [
				[
					'property' => 'list-style',
					'selector' => '.brx-dropdown-content li',
				]
			],
		];

		$controls['textSpacing'] = [
			'tab' 		=> 'content',
			'type'      => 'spacing',
			'label'     => esc_html__( 'Text spacing', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector . ' span',
				]
			],
		];

		return $controls;
	}
}