<?php
namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class NestedSlider {
	public function __construct() {
		add_filter( "bricks/elements/slider-nested/control_groups", [ $this, 'add_slider_nested_control_groups' ] );
		add_filter( "bricks/elements/slider-nested/controls", [ $this, 'filter_slider_nested_controls' ] );

		add_action( 'bricks/frontend/before_render_data', [ $this, 'sld_before_render_data' ], 10, 2 );
		add_action( 'wp_footer', function() {
			if( bricks_is_builder() ) {
				echo  "<style>.splide__track--nav>.splide__list>.splide__slide,.splide__track--nav>.splide__list>.splide__slide.is-active {border: none!important;outline: 0;}</style>";
			}
		});
	}

	/**
	 * Adds extra control group for nested slider element
	 * 
	 * @since 1.0.14
	 * @param array $control_groups
	 * @return array $control_groups
	 */
	public function add_slider_nested_control_groups( $control_groups ) {
		$control_groups['sync'] = [
			'title' => esc_html__( 'Sync', 'bricks' ),
			'tab'   => 'content',
		];

		return $control_groups;
	}

	public function filter_slider_nested_controls( $controls ) {
		$controls['syncSlds'] = [
			'tab' 		=> 'content',
			'group' 	=> 'sync',
			'type'      => 'checkbox',
			'label'     => esc_html__( 'Sync it with other slider?', 'bricksultimate' ),
			'reset' 	=> true,
		];

		$controls['mainSld'] = [
			'tab' 		=> 'content',
			'group' 	=> 'sync',
			'type'      => 'text',
			'label'     => esc_html__( 'Other Slider ID', 'bricksultimate' ),
			'hasDynamicData' => false,
			'required' 	=> ['syncSlds', '=', true]
		];

		return $controls;
	}

	public function sld_before_render_data( $elements, $area ) {
		foreach ( $elements as $element ) {
			$settings = $element['settings'];

			if( $element['name'] == 'slider-nested' && ! empty( $settings['syncSlds'] ) && ! empty( $settings['mainSld'] ) ) {
				wp_enqueue_style( 'bu-sync-slider' );
				wp_enqueue_script( 'bu-sync-slider' );
			}

			if( isset( $settings['query']['objectType'] ) && $settings['query']['objectType'] == 'buprdgallery' ) {
				wp_enqueue_script( 'bu-prdgallery-slider' );
			}
		}
	}
}