<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class AnimatedBurger extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-animated-burger';
	public $icon 			= 'ti-menu';
	public $scripts 		= [ 'buAnimatedBurger' ];
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Animated Burger', 'bricksultimate' );
	}

	public function set_control_groups() {
		$this->control_groups['burger']    = array(
			'title' => esc_html__( 'Burger options', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['burger_text']    = array(
			'title' => esc_html__( 'Text', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['dropdown']    = array(
			'title' => esc_html__( 'Popup', 'bricksultimate' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['triggerOn'] = [
			'type'      => 'select',
			'label'     => esc_html__('Trigger on', 'bricksultimate'),
			'options'   => [
				'click'  	=> esc_html__('Click'),
				'mouseenter' => esc_html__('Hover'),
			],
			'default'   => 'click',
			'inline' 	=> true,
		];

		$this->controls['ddIcon'] = [
			'type'      => 'icon',
			'label'     => esc_html__('Dropdown icon', 'bricksultimate'),
		];

		$this->controls['ddIconSize'] = [
			'label'     => esc_html__('Icon size', 'bricksultimate'),
			'type' 		=> 'number',
			'units' 	=> true,
			'css' => [
				[
					'property' 	=> 'font-size',
					'selector' 	=> '.ab-dd-icon',
				]
			],
			'required' => [ 'ddIcon.icon', '!=', '' ],
		];

		$this->controls['ddIconColor'] = [
			'label'     => esc_html__('Icon color', 'bricksultimate'),
			'type' 		=> 'color',
			'css' => [
				[
					'property' 	=> 'color',
					'selector' 	=> '.ab-dd-icon',
				],
				[
					'property' 	=> 'fill',
					'selector' 	=> '.ab-dd-icon',
				]
			],
			'required' => [ 'ddIcon.icon', '!=', '' ],
		];

		$this->controls['varient_type'] = [
			'group' 	=> 'burger',
			'type'      => 'select',
			'label'     => esc_html__('Animation type', 'bricksultimate'),
			'options'   => [
				'standard'  => esc_html__('Standard'),
				'r'  		=> esc_html__('Reverse'),
			],
			'default'   => 'standard',
			'inline' 	=> true,
		];

		$this->controls['varient'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger',
			'type'      => 'select',
			'label'     => esc_html__('Effect', 'bricksultimate'),
			'options'   => [
				'none' 		=> 'None',
				'arrow' 	=> 'Arrow',
				'arrowalt' 	=> 'Arrow Alt',
				'arrowturn' => 'Arrow Turn',
				'boring' 	=> 'Boring',
				'collapse' 	=> 'Collapse',
				'elastic' 	=> 'Elastic',
				'emphatic' 	=> 'Emphatic',
				'minus' 	=> 'Minus',
				'slider' 	=> 'Slider',
				'squeeze' 	=> 'Squeeze',
				'spin' 		=> 'Spin',
				'stand' 	=> 'Stand',
				'spring' 	=> 'Spring',
				'vortex' 	=> 'Vortex',
				'3dx' 		=> '3DX',
				'3dy' 		=> '3DY'
			],
			'default'   => 'spin',
			'medium' 	=> true,
			'inline' 	=> true,
		];

		$this->controls['layer_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger',
			'type'      => 'number',
			'label'     => esc_html__('Lines width(px)', 'bricksultimate'),
			'unit' 		=> 'px',
			'min'		=> 0,
			'max'  		=> 200,
			'step' 		=> 1,
			'default'   => 40,
			'small' 	=> false,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger',
					'property' 	=> '--hamburger-layer-width'
				]
			]
		];

		$this->controls['layer_height'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger',
			'type'      => 'number',
			'label'     => esc_html__('Lines height(px)', 'bricksultimate'),
			'unit' 		=> 'px',
			'min'		=> 0,
			'max'  		=> 50,
			'step' 		=> 1,
			'default'   => 4,
			'small' 	=> false,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger',
					'property' 	=> '--hamburger-layer-height'
				]
			]
		];

		$this->controls['layer_spacing'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger',
			'type'      => 'number',
			'label'     => esc_html__('Gap between lines(px)', 'bricksultimate'),
			'unit' 		=> 'px',
			'min'		=> 0,
			'max'  		=> 50,
			'step' 		=> 1,
			'default'   => 6,
			'small' 	=> false,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger',
					'property' 	=> '--hamburger-layer-spacing'
				]
			]
		];

		$this->controls['top_line_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger',
			'type'      => 'number',
			'label'     => esc_html__('1st line width(px)', 'bricksultimate'),
			'unit' 		=> 'px',
			'min'		=> 0,
			'max'  		=> 200,
			'step' 		=> 1,
			'small' 	=> false,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger .hamburger-inner:before',
					'property' 	=> 'width'
				]
			],
			'required' 	=> ['varient', '=', [ 'arrow', 'arrowalt', 'arrowturn', 'boring', 'spin', 'spring', 'stand','collapse', 'slider', 'minus' ] ]
		];

		$this->controls['bottom_line_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger',
			'type'      => 'number',
			'label'     => esc_html__('3rd line width(px)', 'bricksultimate'),
			'unit' 		=> 'px',
			'min'		=> 0,
			'max'  		=> 200,
			'step' 		=> 1,
			'small' 	=> false,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger .hamburger-inner:after',
					'property' 	=> 'width'
				]
			],
			'required' 	=> ['varient', '=', [ 'arrow', 'arrowalt', 'arrowturn', 'boring', 'spin', 'spring', 'stand','collapse', 'slider', 'minus' ] ]
		];

		$this->controls['layer_brdrad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger',
			'type'      => 'number',
			'label'     => esc_html__('Border radius(px)', 'bricksultimate'),
			'unit' 		=> 'px',
			'min'		=> 0,
			'max'  		=> 50,
			'step' 		=> 1,
			'default'   => 4,
			'small' 	=> false,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger',
					'property' 	=> '--hamburger-layer-border-radius'
				]
			]
		];

		$this->controls['line_color'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger',
			'type'      => 'color',
			'label'     => esc_html__('Line color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger-inner',
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> '.hamburger-inner:after',
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> '.hamburger-inner:before',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['hover_color'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger',
			'type'      => 'color',
			'label'     => esc_html__('Line color - hover', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger:hover .hamburger-inner',
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> '.hamburger:hover .hamburger-inner:before',
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> '.hamburger:hover .hamburger-inner:after',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['active_color'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger',
			'type'      => 'color',
			'label'     => esc_html__('Line color - active', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger.is-active .hamburger-inner',
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> '.hamburger.is-active .hamburger-inner:before',
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> '.hamburger.is-active .hamburger-inner:after',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['aria_label'] = [
			'tab' 			=> 'content',
			'group' 		=> 'burger',
			'type' 			=> 'text',
			'label' 		=> esc_html__( 'Aria label', 'bricksultimate' ),
			'default' 		=> esc_html__( 'Toggle Menu', 'bricksultimate' ),
			'placeholder' 	=> esc_html__( 'Toggle Menu', 'bricksultimate' ),
		];

		$this->controls['menu_text'] = [
			'tab' 			=> 'content',
			'group' 		=> 'burger_text',
			'type' 			=> 'text',
			'label' 		=> esc_html__( 'Text', 'bricksultimate' ),
			'default' 		=> esc_html__( 'Menu', 'bricksultimate' ),
			'placeholder' 	=> esc_html__( 'Menu', 'bricksultimate' ),
		];

		$this->controls['menu_text_pos'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger_text',
			'type'      => 'select',
			'label'     => esc_html__('Position', 'bricks'),
			'options'   => [
				'row'  			=> esc_html__('Right side of the icon'),
				'row-reverse'  	=> esc_html__('Left side of the icon'),
			],
			'css' 		=> [
				[
					'selector' 	=> '.hamburger',
					'property' 	=> 'flex-direction'
				]
			],
			'default'   => 'row',
			'medium' 	=> true,
			'inline' 	=> true,
		];

		$this->controls['space_left'] = [
			'group' 	=> 'burger_text',
			'type'      => 'number',
			'label'     => esc_html__('Space between icon & text', 'bricksultimate'),
			'units' 	=> true,
			'default'   => '8px',
			'css' 		=> [
				[
					'selector' 	=> '.hamburger-label',
					'property' 	=> 'margin-left'
				]
			],
			'required' 	=> ['menu_text_pos', '=', [ 'row' ] ]
		];

		$this->controls['space_right'] = [
			'group' 	=> 'burger_text',
			'type'      => 'number',
			'label'     => esc_html__('Space between text & icon', 'bricksultimate'),
			'units' 	=> true,
			'default'   => '8px',
			'css' 		=> [
				[
					'selector' 	=> '.hamburger-label',
					'property' 	=> 'margin-right'
				]
			],
			'required' 	=> ['menu_text_pos', '=', [ 'row-reverse' ] ]
		];

		$this->controls['btnTextTypography'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger_text',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => '.hamburger-label',
				],
			],
			'exclude'  => [
				'text-align',
				'text-decoration',
			]
		];

		$this->controls['txt_hover_color'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger_text',
			'type'      => 'color',
			'label'     => esc_html__('Text Color - hover', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger:hover .hamburger-label',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['txt_active_color'] = [
			'tab' 		=> 'content',
			'group' 	=> 'burger_text',
			'type'      => 'color',
			'label'     => esc_html__('Text Color - active', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.hamburger.is-active .hamburger-label',
					'property' 	=> 'background-color'
				]
			]
		];

		/**
		 * Dropdown
		 */
		$selector = '.bu-burger-sub-menu';
		$this->controls['hasDropdown'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'type'      => 'checkbox',
			'label'     => esc_html__('Show popup', 'bricksultimate'),
			'reset' 	=> true
		];

		$this->controls['previewDropdown'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'type'      => 'checkbox',
			'label'     => esc_html__('Preview In-Builder mode', 'bricksultimate'),
			'reset' 	=> true,
			'default' 	=> true
		];

		$this->controls['popupWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'type' 		=> 'number',
			'label' 	=> esc_html__('Width', 'bricks'),
			'placeholder' => '300px',
			'units' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'width',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['popupHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'type' 		=> 'number',
			'label' 	=> esc_html__('Height', 'bricks'),
			'units' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'height',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['popupMgn'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'type' 		=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label' 	=> esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'margin',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['popupPad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'type' 		=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label' 	=> esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'padding',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['popupBG'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'type' 		=> 'color',
			'label' 	=> esc_html__('Background', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'background-color',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['popupBRD'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'type' 		=> 'border',
			'label' 	=> esc_html__('Border', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'border',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['popupBS'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'type' 		=> 'box-shadow',
			'label' 	=> esc_html__('Box shadow', 'bricks'),
			'css' 		=> [
				[
					'property' 	=> 'box-shadow',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['positionSeparator'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'label' => esc_html__( 'Positioning', 'bricks' ),
			'type'  => 'separator',
		];

		$this->controls['posTop'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'label' 	=> esc_html__( 'Top', 'bricks' ),
			'type'  	=> 'number',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'top',
					'selector' => $selector
				],
			],
		];

		$this->controls['posRight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'label' 	=> esc_html__( 'Right', 'bricks' ),
			'type'  	=> 'number',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'right',
					'selector' => $selector
				],
			],
		];

		$this->controls['posBottom'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'label' 	=> esc_html__( 'Bottom', 'bricks' ),
			'type'  	=> 'number',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'bottom',
					'selector' => $selector
				],
			],
		];

		$this->controls['posLeft'] = [
			'tab' 		=> 'content',
			'group' 	=> 'dropdown',
			'label' 	=> esc_html__( 'Left', 'bricks' ),
			'type'  	=> 'number',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'left',
					'selector' => $selector
				],
			],
		];
	}

	public function enqueue_scripts() {
		//if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){ }

		wp_enqueue_style( 'bu-animated-burger', Helpers::get_asset_url('css') . 'animatedburger.min.css', [], filemtime(Helpers::get_asset_path('css') . 'animatedburger.min.css'), 'all' );
		wp_enqueue_script( 'bu-animated-burger', Helpers::get_asset_url('js') . 'animatedburger.min.js', [], filemtime(Helpers::get_asset_path('js') . 'animatedburger.min.js'), true );
		
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$aria_label 	= isset( $settings['aria_label'] ) ? $settings['aria_label'] : false;
		$varient 		= isset( $settings['varient'] ) ? $settings['varient'] : 'spin';
		$menu_text 		= isset( $settings['menu_text'] ) ? $settings['menu_text'] : false;
		$has_dropdown 	= isset( $settings['has_dropdown'] ) ? $settings['has_dropdown'] : 'no';

		$class = '';
		$isActive = isset( $settings['is_active'] ) ? $settings['is_active'] : false;
		if( $isActive ) {
			$class = ' is-active';
		}

		$anim_type = ( isset( $settings['varient_type'] ) && $settings['varient_type'] == 'r' ) ? '-r' : '';

		if( in_array( $varient, ['boring', 'minus', 'squeeze'] ) )
			$anim_type = '';

		$this->set_attribute('_root', 'data-trigger_on', Helpers::get_value($settings,'triggerOn', 'click'));
		$this->set_attribute('_root', 'data-ab_varient', $varient);

		echo "<div {$this->render_attributes( '_root' )}>";
	?>
		<button class="hamburger hamburger--<?php echo $varient . $anim_type; ?><?php echo $class; ?>" type="button" aria-label="<?php echo $aria_label; ?>">
			<span class="hamburger-box">
				<span class="hamburger-inner"></span>
			</span>
			<?php if( $menu_text ): ?>
				<span class="hamburger-label"><?php echo $menu_text; ?></span>
			<?php 
				endif; 

				if( ! empty( $settings['ddIcon'] ) ) { 
					echo self::render_icon( $settings['ddIcon'], ['ab-dd-icon'] );
				}
			?>

		</button>
	<?php

		if( ! empty( $settings['hasDropdown'] ) ) {
			echo '<span class="bu-burger-sub-menu screen-reader-text">';
			echo \Bricks\Frontend::render_children( $this );
			echo "</span>";
		}

		echo "</div>";
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-animated-burger">
			<component :is="'div'">
				<button 
					class="hamburger"
					:class="['hamburger--' + settings.varient + (settings.varient_type == 'r' ? '-r' : ''),{'is-active': settings.is_active}]"  
					type="button" 
					aria-label="{{settings.aria_label}}" 
					aria-controls="navigation" 
				>
					<span class="hamburger-box">
						<span class="hamburger-inner"></span>
					</span>
					<span v-if="settings.menu_text" class="hamburger-label">{{settings.menu_text}}</span>
					<icon-svg v-if="settings.ddIcon" :iconSettings="settings.ddIcon" class="ab-dd-icon"/>
				</button>
				<span 
					v-if="settings.hasDropdown" 
					class="bu-burger-sub-menu" 
					:class="[{'bu-burger-sub-menu--open': settings.previewDropdown}]"
				>
					<bricks-element-children :element="element" />
				</span>
			</component>
		</script>
	<?php
	}
}