<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class BackToTop extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-btt';
	public $icon 			= 'ti-angle-up';
	public $scripts 		= [ 'buBackToTop' ];
	public $tag 			= 'div';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Back to top', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['builder_mode'] = [
			'tab' 	=> 'content',
			'type' 	=> 'checkbox',
			'label' => __('Hide in builder editor?', 'bricksultimate'),
			'inline' => true,
		];

		$this->controls['tag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'HTML tag', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'div'     => 'div',
				'span' 	  => 'span',
				'button'  => 'button'
			],
			'lowercase'   => true,
			'inline'      => true,
			'placeholder' => $this->tag ? $this->tag : 'div',
			'fullAccess'  => true,
		];

		$this->controls['offset'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Scroll offset(in px)', 'bricksultimate'),
			'unit' 		=> 'px',
			'min'		=> 0,
			'max'  		=> 10000,
			'step' 		=> 10,
			'default'   => 350,
			'small' 	=> true,
			'inline' 	=> true,
		];

		$this->controls['td'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Transition duration(in sec)', 'bricksultimate'),
			'unitless' 	=> true,
			'min'		=> 0,
			'max'  		=> 100,
			'step' 		=> 0.1,
			'default'   => 0.5,
			'small' 	=> true,
			'inline' 	=> true,
			'css' => [
				[
					'property' 	=> 'transition-duration',
					'value' 	=> "%ss"
				]
			]
		];
		
		$this->controls['_position']['default'] = 'fixed';
		$this->controls['_right']['default'] = 30;
		$this->controls['_bottom']['default'] = 30;
		$this->controls['_zIndex']['default'] = 99;
		$this->controls['_cursor']['default'] = 'pointer';
		$this->controls['_cssCustom']['default'] = "body.bricks-is-frontend .brxe-bu-btt{visibility: hidden; opacity: 0; transition-property: all; transition-duration: 0.3s; animation-timing-function: ease-in-out;transform: scale(0);}body.bricks-is-frontend .brxe-bu-btt.show-btt-btn{visibility: visible; opacity: 1; transform: scale(1);}";
	}

	public function get_nestable_item() {
		return [
			'name'     => 'icon',
			'settings' => [
				'icon'     => [
					'icon'    => 'ti-angle-up',
					'library' => 'themify',
				],
				'iconSize' => '35px',
				'iconColor' => '#333333',
				'_padding' => [
					'top' 	=> 15,
					'right' => 15,
					'bottom' => 15,
					'left' 	=> 15,
				],
				'_background' => [
					'color' => [
						'hex' => '#ffffff',
					]
				],
				'_border' => [
					'radius' => [
						'top' => 50,
						'right' => 50,
						'bottom' => 50,
						'left' => 50,
					]
				],
				'_boxShadow' => [
					'values' => [
						'offsetX' => 0,
						'offsetY' => 0,
						'blur' => 8,
					],
					'color' => [
						'hex' => '#adadad',
					]
				]
			]
		];
	}

	public function get_nestable_children() {
		$children[] = $this->get_nestable_item();
		return $children;
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_script( 'bu-btt', Helpers::get_asset_url('js') . 'bu.btt.min.js', [], filemtime(Helpers::get_asset_path('js') . 'bu.btt.min.js'), true );
	}

	// Render element HTML
	public function render() {
		if( ( bricks_is_builder() || Helpers::isBricksBuilderActive() ) && isset( $this->settings['builder_mode'] ) ) {
			$this->set_attribute( '_root', 'style', 'display:none;' );
		}

		$settings = $this->settings;
		$data = [
			'offset' => isset( $settings['offset'] ) ? $settings['offset'] : 0
		];

		$this->set_attribute( '_root', 'data-btt-config', wp_json_encode( $data ) );

		echo "<{$this->tag} {$this->render_attributes( '_root' )}>";
		echo \Bricks\Frontend::render_children( $this );
		echo "</{$this->tag}>";
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-btt">
			<component :is="tag" v-if="!settings.builder_mode" :data-btt-config="settings.offset">
				<bricks-element-children :element="element" />
			</component>
		</script>
	<?php
	}
}