<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class BeforeAfterImage extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-before-after-image';
	public $icon 			= 'ti-split-v-alt';
	public $scripts 		= [ 'buBeforeAfterImage' ];

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Before After Image', 'bricksultimate' );
	}

	public function set_control_groups() {
		$this->control_groups['image'] = array(
			'title' => esc_html__( 'Images', 'bricksable' ),
			'tab'   => 'content',
		);

		$this->control_groups['label'] = array(
			'title' => esc_html__( 'Labels', 'bricksable' ),
			'tab'   => 'content',
		);

		$this->control_groups['controls'] = array(
			'title' => esc_html__( 'Handler', 'bricksable' ),
			'tab'   => 'content',
		);

		$this->control_groups['other']    = array(
			'title' => esc_html__( 'Extras', 'bricksable' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {

		$this->controls['bainfo'] = [
			'type'      => 'info',
			'content'    => esc_html__('Click on Reload canvas button if preview is blank or messed up.', 'bricksultimate'),
		];

		$this->controls['beforeImage'] = [
			'group' 	=> 'image',
			'type'      => 'image',
			'label'     => esc_html__('Before image', 'bricksultimate'),
			'default' => array(
				'full' => 'https://image-compare-viewer.netlify.app/public/before-3.jpg',
				'url'  => 'https://image-compare-viewer.netlify.app/public/before-3.jpg',
			),
		];

		$this->controls['beforeImgAlt'] = [
			'group' 	=> 'image',
			'type'      => 'text',
			'label'     => esc_html__('Alt text / Caption', 'bricksultimate'),
			'hasDynamicData' => true,
			'rerender' => false
		];

		$this->controls['beforeImageFilter'] = [
			'group' 	=> 'image',
			'label'  => esc_html__( 'Before Image filters', 'bricksultimate' ),
			'type'   => 'filters',
			'inline' => true,
			'css'    => array(
				array(
					'property' => 'filter',
					'selector' => '.before-image',
				),
			),
		];

		$this->controls['beforeImgSep'] = [
			'group' 	=> 'image',
			'type' => 'separator'
		];

		$this->controls['afterImage'] = [
			'group' 	=> 'image',
			'type'      => 'image',
			'label'     => esc_html__('After image', 'bricksultimate'),
			'default' => array(
				'full' => 'https://image-compare-viewer.netlify.app/public/after-3.jpg',
				'url'  => 'https://image-compare-viewer.netlify.app/public/after-3.jpg',
			),
		];

		$this->controls['afterImageFilter'] = [
			'group' 	=> 'image',
			'label'  => esc_html__( 'After Image filters', 'bricksultimate' ),
			'type'   => 'filters',
			'inline' => true,
			'css'    => array(
				array(
					'property' => 'filter',
					'selector' => '.after-image',
				),
			),
		];

		$this->controls['afterImgAlt'] = [
			'group' 	=> 'image',
			'type'      => 'text',
			'label'     => esc_html__('Alt text / Caption', 'bricksultimate'),
			'hasDynamicData' => true,
			'rerender' => false
		];

		//* Labels
		$this->controls['disableLabels'] = [
			'group' 	=> 'label',
			'type'      => 'checkbox',
			'label'     => esc_html__('Disable labels', 'bricksultimate'),
		];

		$this->controls['onHover'] = [
			'group' 	=> 'label',
			'type'      => 'checkbox',
			'label'     => esc_html__('Show on hover', 'bricksultimate'),
			'required' 	=> ['disableLabels', '!=', true],
		];

		$this->controls['beforeLabel'] = [
			'group' 	=> 'label',
			'type'      => 'text',
			'label'     => esc_html__('Before label', 'bricksultimate'),
			'hasDynamicData' => true,
			'placeholder' => __('Before'),
			'required' => ['disableLabels', '!=', true],
		];

		$this->controls['afterLabel'] = [
			'group' 	=> 'label',
			'type'      => 'text',
			'label'     => esc_html__('After label', 'bricksultimate'),
			'hasDynamicData' => true,
			'placeholder' => __('After'),
			'required' => ['disableLabels', '!=', true],
		];

		$this->controls['labelTg'] = [
			'group' 	=> 'label',
			'type'      => 'typography',
			'label'     => esc_html__('Label typography', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => '.icv__label'
				]
			],
			'required' => ['disableLabels', '!=', true],
		];

		$this->controls['labelBg'] = [
			'group' 	=> 'label',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'background',
					'selector' => '.icv__label'
				]
			],
			'required' => ['disableLabels', '!=', true],
		];

		$this->controls['labelBrd'] = [
			'group' 	=> 'label',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'border',
					'selector' => '.icv__label'
				]
			],
			'required' => ['disableLabels', '!=', true],
		];

		$this->controls['labelBS'] = [
			'group' 	=> 'label',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'box-shadow',
					'selector' => '.icv__label'
				]
			],
			'required' => ['disableLabels', '!=', true],
		];

		$this->controls['labelW'] = [
			'group' 	=> 'label',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__('Width', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'width',
					'selector' => '.icv__label'
				]
			],
			'required' => ['disableLabels', '!=', true],
		];

		$this->controls['labelPad'] = [
			'group' 	=> 'label',
			'type'      => 'dimensions',
			'label'     => esc_html__('Padding', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => '.icv__label'
				]
			],
			'required' => ['disableLabels', '!=', true],
		];

		$this->controls['controlShadow'] = [
			'group' 	=> 'controls',
			'type'      => 'checkbox',
			'label'     => esc_html__('Disable line shadow', 'bricksultimate'),
		];

		$this->controls['lineShadow'] = [
			'group' 	=> 'controls',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Line shadow', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'box-shadow',
					'selector' => '.icv__control-line',
					'important' => true
				],
				[
					'property' => 'box-shadow',
					'selector' => '.icv__circle',
					'important' => true
				]
			],
			'exclude' => ['inset'],
			'required' => ['controlShadow', '!=', true]
		];

		$this->controls['addCircle'] = [
			'group' 	=> 'controls',
			'type'      => 'checkbox',
			'label'     => esc_html__('Add circle', 'bricksultimate'),
			'description' => esc_html__('Add circle type to the control handler.', 'bricksultimate'),
			'default' 	=> true
		];

		$this->controls['addCircleBlur'] = [
			'group' 	=> 'controls',
			'type'      => 'checkbox',
			'label'     => esc_html__('Add blur effect to circle', 'bricksultimate'),
			'required' => ['addCircle', '=', true]
		];

		$this->controls['lineColor'] = [
			'group' 	=> 'controls',
			'type'      => 'color',
			'label'     => esc_html__('Handler color', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'background',
					'selector' => '.icv__control-line',
					'important' => true
				],
				[
					'property' => 'border-color',
					'selector' => '&.has-circle-handler .icv__circle',
					'important' => true
				]
			]
		];

		$this->controls['svgPathColor'] = [
			'group' 	=> 'controls',
			'type'      => 'color',
			'label'     => esc_html__('Arrow color', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'fill',
					'selector' => '&:not(.has-circle-handler) .icv__arrow-wrapper path',
					'important' => true
				],
				[
					'property' => 'stroke',
					'selector' => '&:not(.has-circle-handler) .icv__arrow-wrapper path',
					'important' => true
				]
			],
			'required' => ['addCircle', '!=', true],
			'rerender' => false
		];

		$this->controls['circleBG'] = [
			'group' 	=> 'controls',
			'type'      => 'color',
			'label'     => esc_html__('Circle background', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => '&.has-circle-handler .icv__circle',
					'important' => true
				]
			],
			'required' => ['addCircle', '=', true],
			'rerender' => false
		];

		$this->controls['arrowColor'] = [
			'group' 	=> 'controls',
			'type'      => 'color',
			'label'     => esc_html__('Arrow color', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'stroke',
					'selector' => '&.has-circle-handler .icv__arrow-wrapper path',
					'important' => true
				]
			],
			'required' => ['addCircle', '=', true],
			'rerender' => false
		];

		$this->controls['lineWidth'] = [
			'group' 	=> 'controls',
			'type'      => 'number',
			'units' 	=> true,
			'label'     => esc_html__('Handler width', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'width',
					'selector' => '&:not(.icv__icv--vertical) .icv__control-line',
					'important' => true
				],
				[
					'property' => 'border-width',
					'selector' => '&.has-circle-handler .icv__circle',
					'important' => true
				],
				[
					'property' => 'height',
					'selector' => '&.icv__icv--vertical .icv__control-line',
					'important' => true
				],
			],
			'rerender' => false
		];

		$this->controls['circleRadius'] = [
			'group' 	=> 'controls',
			'type'      => 'number',
			"units" 	=> true,
			'label'     => esc_html__('Circle radius', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'border-radius',
					'selector' => '&.has-circle-handler .icv__circle',
					'important' => true
				]
			],
			'required' => ['addCircle', '=', true],
			'default' => '0'
		];

		$this->controls['circleSize'] = [
			'group' 	=> 'controls',
			'type'      => 'number',
			"units" 	=> true,
			'label'     => esc_html__('Circle size', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'width',
					'selector' => '&.has-circle-handler .icv__circle',
					'important' => true
				],
				[
					'property' => 'height',
					'selector' => '&.has-circle-handler .icv__circle',
					'important' => true
				]
			],
			'required' => ['addCircle', '=', true]
		];

		$this->controls['arrowWidth'] = [
			'group' 	=> 'controls',
			'type'      => 'number',
			"units" 	=> true,
			'label'     => esc_html__('Arrow width', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'stroke-width',
					'selector' => '&.has-circle-handler .icv__arrow-wrapper path',
					'important' => true
				]
			],
			'required' => ['addCircle', '=', true]
		];

		$this->controls['arrowSize'] = [
			'group' 	=> 'controls',
			'type'      => 'number',
			"units" 	=> true,
			'label'     => esc_html__('Arrow size', 'bricksultimate'),
			'css' 		=> [
				[
					'property' => 'width',
					'selector' => '&.has-circle-handler .icv__arrow-wrapper svg',
					'important' => true
				],
				[
					'property' => 'height',
					'selector' => '&.has-circle-handler .icv__arrow-wrapper svg',
					'important' => true
				]
			],
			'required' => ['addCircle', '=', true]
		];

		$this->controls['leftArrow'] = [
			'group' 	=> 'controls',
			'type'      => 'number',
			"units" 	=> true,
			'label'     => esc_html__('Left arrow position', 'bricksultimate'),
			'css' 		=> [
				[
					'property' 	=> 'transform',
					'selector' 	=> '&.has-circle-handler .icv__theme-wrapper > :first-child',
					'value' 	=> 'translateX(%s)',
					'important' => true
				]
			],
			'required' => ['addCircle', '=', true]
		];

		$this->controls['rightArrow'] = [
			'group' 	=> 'controls',
			'type'      => 'number',
			"units" 	=> true,
			'label'     => esc_html__('Right arrow position', 'bricksultimate'),
			'css' 		=> [
				[
					'property' 	=> 'transform',
					'selector' 	=> '&.has-circle-handler .icv__theme-wrapper > :last-child',
					'value' 	=> 'translateX(%s)',
					'important' => true
				]
			],
			'required' => ['addCircle', '=', true]
		];

		$this->controls['verticalModeSep'] = [
			'group' 	=> 'controls',
			'type'      => 'separator',
			'label'     => esc_html__('Vertical mode', 'bricksultimate'),
		];

		$this->controls['leftArrowVM'] = [
			'group' 	=> 'controls',
			'type'      => 'number',
			"units" 	=> true,
			'label'     => esc_html__('Left arrow position', 'bricksultimate'),
			'css' 		=> [
				[
					'property' 	=> 'transform',
					'selector' 	=> '&.has-circle-handler .icv__theme-wrapper > :first-child',
					'value' 	=> 'translateY(%s)',
					'important' => true
				]
			],
			'required' => ['addCircle', '=', true]
		];

		$this->controls['rightArrowVM'] = [
			'group' 	=> 'controls',
			'type'      => 'number',
			"units" 	=> true,
			'label'     => esc_html__('Right arrow position', 'bricksultimate'),
			'css' 		=> [
				[
					'property' 	=> 'transform',
					'selector' 	=> '&.has-circle-handler .icv__theme-wrapper > :last-child',
					'value' 	=> 'translateY(%s)',
					'important' => true
				]
			],
			'required' => ['addCircle', '=', true]
		];

		$this->controls['startingPoint'] = [
			'group' 	=> 'other',
			'type'      => 'number',
			'unitless' 	=> true,
			'label'     => esc_html__('Starting point', 'bricksultimate'),
			'description' => esc_html__('The percentage to show of the before image.', 'bricksultimate'),
			'placeholder' => 38
		];

		$this->controls['verticalMode'] = [
			'group' 	=> 'other',
			'type'      => 'checkbox',
			'label'     => esc_html__('Vertical mode', 'bricksultimate'),
			'info' 		=> esc_html__('Vertical mode is mobile friendly!', 'bricksultimate'),
		];

		$this->controls['hoverStart'] = [
			'group' 	=> 'other',
			'type'      => 'checkbox',
			'label'     => esc_html__('Start on hover', 'bricksultimate'),
		];

		$this->controls['smoothing'] = [
			'group' 	=> 'other',
			'type'      => 'checkbox',
			'label'     => esc_html__('Disable smoothing', 'bricksultimate'),
			'info' 		=> esc_html__('Smoothing is automatically disabled on touch enabled screens.', 'bricksultimate'),
			'rerender' => false
		];

		$this->controls['smoothingAmount'] = [
			'group' 	=> 'other',
			'type'      => 'number',
			'unitless' 	=> true,
			'label'     => esc_html__('Smoothing amount', 'bricksultimate'),
			'info' 		=> esc_html__('Milliseconds – a higher number means more dampening', 'bricksultimate'),
			'placeholder' => 100,
			'required' => ['smoothing', '!=', true],
			'rerender' => false
		];
	}

	public function enqueue_scripts() {
		//if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){ }
		
		wp_enqueue_style( 'bu-before-after-image', Helpers::get_asset_url('css') . 'bubaimg.min.css', [], filemtime(Helpers::get_asset_path('css') . 'bubaimg.min.css'), 'all' );
		wp_enqueue_script( 'bu-before-after-image', Helpers::get_asset_url('js') . 'bubaimg.min.js', [], filemtime(Helpers::get_asset_path('js') . 'bubaimg.min.js'), true );
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;
		$beforeImage = $this->getImageSettings($settings, 'beforeImage');
		$afterImage = $this->getImageSettings($settings, 'afterImage');
		$showLabels = isset( $settings['disableLabels'] ) ? false : true;
		$addCircle = isset( $settings['addCircle'] ) ? true : false;
		
		$data = [];
		$data['showLabels'] = $showLabels;
		$data['smoothing'] = isset( $settings['smoothing'] ) ? false : true;
		$data['smoothingAmount'] = Helpers::get_value($settings, 'smoothingAmount', 100);
		$data['verticalMode'] = isset( $settings['verticalMode'] ) ? true : false;
		$data['startingPoint'] = Helpers::get_value( $settings, 'startingPoint', 38 );
		$data['hoverStart'] = isset( $settings['hoverStart'] ) ? true : false;
		$data['addCircle'] = $addCircle;
		$data['addCircleBlur'] = isset( $settings['addCircleBlur'] ) ? true : false;
		$data['controlShadow'] = isset( $settings['controlShadow'] ) ? false : true;

		if( $showLabels ) {
			$beforeLabel = Helpers::get_value( $settings, 'beforeLabel', '' );
			$data['before'] = esc_html( $beforeLabel );
			$afterLabel = Helpers::get_value( $settings, 'afterLabel', '' );
			$data['after'] = esc_html( $afterLabel );
			$data['onHover'] = isset( $settings['onHover'] ) ? true : false;
		}

		$this->set_attribute('_root', 'data-baimg-config', wp_json_encode( $data ) );

		if( $addCircle )
			$this->set_attribute('_root', 'class', ['has-circle-handler'] );

		echo "<div {$this->render_attributes('_root')}>";

		if( $beforeImage['id'] ) {
			echo wp_get_attachment_image( $beforeImage['id'], $beforeImage['size'], false, ['id' => 'image-' . $beforeImage['id'], 'alt' => Helpers::get_value( $settings, 'beforeImgAlt', ''), 'class' => 'before-image'] );
		} elseif( ! empty( $beforeImage['url'] ) ) {
			echo '<img src="' . esc_url( $beforeImage['url'] ) . '" alt="' . Helpers::get_value( $settings, 'beforeImgAlt', '') . '" class="before-image" />';
		}

		if( $afterImage['id'] ) {
			echo wp_get_attachment_image( $afterImage['id'], $afterImage['size'], false, ['id' => 'image-' . $afterImage['id'], 'alt' => Helpers::get_value( $settings, 'beforeImgAlt', ''), 'class' => 'after-image' ] );
		} elseif( ! empty( $afterImage['url'] ) ) {
			echo '<img src="' . esc_url( $afterImage['url'] ) . '" alt="' . Helpers::get_value( $settings, 'afterImgAlt', '') . '" class="after-image"/>';
		}

		echo "</div>";
	}

	public function getImageSettings( $settings, $slug ) {
		if ( empty( $settings[ $slug ] ) ) {
			return [
				'id'   => 0,
				'url'  => false,
				'size' => BRICKS_DEFAULT_IMAGE_SIZE,
			];
		}

		$image = $settings[ $slug ];

		// Size
		$image['size'] = empty( $image['size'] ) ? BRICKS_DEFAULT_IMAGE_SIZE : $settings[$slug]['size'];

		// Image ID or URL from dynamic data
		if ( ! empty( $image['useDynamicData'] ) ) {
			$images = $this->render_dynamic_data_tag( $image['useDynamicData'], 'image', [ 'size' => $image['size'] ] );

			if ( ! empty( $images[0] ) ) {
				if ( is_numeric( $images[0] ) ) {
					$image['id'] = $images[0];
				} else {
					$image['url'] = $images[0];
				}
			}

			// No dynamic data image found (@since 1.6)
			else {
				return;
			}
		}

		$image['id'] = empty( $image['id'] ) ? 0 : $image['id'];

		// If External URL, $image['url'] is already set
		if ( ! isset( $image['url'] ) ) {
			$image['url'] = ! empty( $image['id'] ) ? wp_get_attachment_image_url( $image['id'], $image['size'] ) : false;
		} else {
			// Parse dynamic data in the external URL
			$image['url'] = $this->render_dynamic_data( $image['url'] );
		}

		return $image;
	}
}