<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class Breadcrumbs extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-breadcrumbs';
	public $icon 			= 'ti-angle-double-right';
	public $tag 			= 'div';

	// Return localized element label
	public function get_label() {
		return esc_html__( 'Breadcrumbs - Ultimate', 'bricksultimate' );
	}

	public function set_control_groups() {
		$this->control_groups['separator'] = [
			'tab' => 'content',
			'title' => esc_html__( 'Separator', 'bricks' ),
			'required' =>  [ 'seoPlugin', '=', [ 'rankmath', 'yoast', 'allinone' ] ]
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['tag'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'HTML tag', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'div' 		=> 'div',
				'span' 		=> 'span',
				'p' 		=> 'p',
				'section' 	=> 'section'
			],
			'lowercase'   => true,
			'inline'      => true,
			'placeholder' => $this->tag ? $this->tag : 'div',
			'fullAccess'  => true,
		];

		$this->controls['seoPlugin'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Seo plugin', 'bricksultimate'),
			'inline'      => true,
			'options'   => [
				'allinone' 	=> esc_html__( 'All in One SEO', 'bricksultimate' ),
				'navxt' 	=> esc_html__( 'NavXT', 'bricksultimate' ),
				'rankmath' 	=> esc_html__( 'Rank Math', 'bricksultimate' ),
				'seopress' 	=> esc_html__( 'SEOPress Pro', 'bricksultimate' ),
				'slim' 		=> esc_html__( 'Slim SEO', 'bricksultimate' ),
				'yoast' 	=> esc_html__( 'Yoast', 'bricksultimate' ),
				'zynith' 	=> esc_html__( 'Zynith', 'bricksultimate' ),
			],
			'default'   => $this->getSeoPlugin(),
		];

		$this->controls['disableLink'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Disable links', 'bricksultimate' ),
			'type' => 'checkbox',
			'required' => [ 'seoPlugin', '=', 'navxt' ]
		];

		$this->controls['reverse'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Reverse order', 'bricksultimate' ),
			'type' => 'checkbox',
			'required' => [ 'seoPlugin', '=', 'navxt' ]
		];

		$this->controls['force'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Bypass internal caching', 'bricksultimate' ),
			'type' => 'checkbox',
			'required' => [ 'seoPlugin', '=', 'navxt' ]
		];

		$this->controls['colGap'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Gap between links', 'bricks' ),
			'type' => 'number',
			'units' => true,
			'css'      => [
				[
					'property' => 'column-gap',
					'selector' => '#breadcrumbs > span, .rank-math-breadcrumb p, .aioseo-breadcrumbs, .breadcrumbs'
				],
			],
			'placeholder' => '3px',
			'required' => [ 'seoPlugin', '!=', 'seopress' ]
		];

		$this->controls['textTG'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type' => 'typography',
			'css' 	=> [
				[
					'property' => 'font',
				]
			]
		];

		$this->controls['linkColor'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Link color', 'bricks' ),
			'type' => 'color',
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => 'a'
				]
			]
		];

		$this->controls['linkHColor'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Link hover color', 'bricks' ),
			'type' => 'color',
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => 'a:hover'
				]
			]
		];

		$this->controls['curPage'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Current item: color', 'bricks' ),
			'type' => 'color',
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => '.breadcrumb_last, .current, .current-item, .breadcrumb-item.active, .breadcrumb--last'
				]
			],
			'required' => [ 'seoPlugin', '!=', 'allinone' ]
		];

		$this->controls['curPageFw'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Current item: font-weight', 'bricks' ),
			'type' => 'select',
			'options'   => [
				'100' 	=> 100,
				'200' 	=> 200,
				'300' 	=> 300,
				'400' 	=> 400,
				'500' 	=> 500,
				'600' 	=> 600,
				'700' 	=> 700,
				'900' 	=> 900,
			],
			'inline' => true,
			'css' 	=> [
				[
					'property' => 'font-weight',
					'selector' => '.breadcrumb_last, .current, .current-item, .breadcrumb-item.active, .breadcrumb--last'
				]
			],
			'placeholder' => 400,
			'required' => [ 'seoPlugin', '!=', 'allinone' ]
		];

		$this->controls['spSepClr'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Separator color', 'bricksultimate' ),
			'type' => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.breadcrumb li::after'
				],
				[
					'property' => 'fill',
					'selector' => '.breadcrumb li::after'
				]
			],
			'required' => [ 'seoPlugin', '=', 'seopress' ]
		];

		$this->controls['spSepSize'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Separator size', 'bricksultimate' ),
			'type' => 'number',
			'units' => true,
			'css'      => [
				[
					'property' => 'font-size',
					'selector' => '.breadcrumb li::after'
				]
			],
			'required' => [ 'seoPlugin', '=', 'seopress' ]
		];

		//* separator
		$this->controls['sepIcon'] = [
			'tab'   => 'content',
			'group' => 'separator',
			'label' => esc_html__( 'Icon', 'bricksultimate' ),
			'type' => 'icon',
		];

		$this->controls['sepSize'] = [
			'tab' => 'content',
			'group' => 'separator',
			'label' => esc_html__( 'Size', 'bricks' ),
			'type' => 'number',
			'units' => true,
			'css'      => [
				[
					'property' => 'font-size',
					'selector' => '.separator'
				],
			],
		];

		$this->controls['sepClr'] = [
			'tab'   => 'content',
			'group' => 'separator',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'type' => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.separator'
				],
				[
					'property' => 'fill',
					'selector' => '.separator'
				]
			],
		];

		//* Slim Seo settings
		$this->controls['slimSepSep'] = [
			'tab'   => 'content',
			'type' => 'separator',
			'required' => ['seoPlugin', '=', 'slim']
		];

		$this->controls['separator'] = [
			'tab'   => 'content',
			'label' => esc_html__('Separator symbol', 'bricksultimate'),
			'type' => 'text',
			'placeholder' => '-',
			'required' => ['seoPlugin', '=', 'slim']
		];

		$this->controls['ssSepSize'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Size', 'bricks' ),
			'type' => 'number',
			'units' => true,
			'css'      => [
				[
					'property' => 'font-size',
					'selector' => '.breadcrumbs__separator'
				],
			],
			'required' => ['seoPlugin', '=', 'slim']
		];

		$this->controls['ssSepClr'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'type' => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.breadcrumbs__separator'
				],
				[
					'property' => 'fill',
					'selector' => '.breadcrumbs__separator'
				]
			],
			'required' => ['seoPlugin', '=', 'slim']
		];

		$this->controls['slimSep'] = [
			'tab'   => 'content',
			'type' => 'separator',
			'required' => ['seoPlugin', '=', 'slim']
		];

		$this->controls['disableCurPage'] = [
			'tab'   => 'content',
			'label' => esc_html__('Disable current page', 'bricksultimate'),
			'type' => 'checkbox',
			'required' => ['seoPlugin', '=', 'slim']
		];

		$this->controls['homeLabel'] = [
			'tab'   => 'content',
			'label' => esc_html__('Home label', 'bricksultimate'),
			'type' => 'text',
			'placeholder' => esc_html__('Home'),
			'required' => ['seoPlugin', '=', 'slim']
		];

		$this->controls['searchLabel'] = [
			'tab'   => 'content',
			'label' => esc_html__('Search label', 'bricksultimate'),
			'type' => 'text',
			'placeholder' => esc_html__('Results for &#8220;%s&#8221;'),
			'required' => ['seoPlugin', '=', 'slim']
		];

		$this->controls['errorLabel'] = [
			'tab'   => 'content',
			'label' => esc_html__('404 error label', 'bricksultimate'),
			'type' => 'text',
			'placeholder' => esc_html__('Page not found'),
			'required' => ['seoPlugin', '=', 'slim']
		];

		$this->controls['taxonomy'] = [
			'tab'   => 'content',
			'label' => esc_html__('Taxonomy', 'bricksultimate'),
			'type' => 'select',
			'options' => \Bricks\Setup::get_taxonomies_options(),
			'default' => 'category',
			'placeholder' => esc_html__('category'),
			'required' => ['seoPlugin', '=', 'slim']
		];

		$this->controls['_cssCustom']['default'] = ".breadcrumbs-navxt, .brxe-bu-breadcrumbs #breadcrumbs > span, .brxe-bu-breadcrumbs .rank-math-breadcrumb p, .brxe-bu-breadcrumbs .aioseo-breadcrumbs, .breadcrumbs-slim .breadcrumbs, .breadcrumbs-zynith .breadcrumbs{
			display: flex;
			flex-direction: row;
			align-items: center;
			column-gap: 3px;
		}
		.brxe-bu-breadcrumbs .separator, .breadcrumbs-slim .breadcrumbs__separator{line-height: 1}
		.breadcrumb{padding: 0}";
	}

	private function getSeoPlugin() {
		if ( function_exists( 'aioseo_breadcrumbs' ) ) {
			return 'allinone';
		} elseif ( function_exists('bcn_display') ) {
			return 'navxt';
		} elseif ( function_exists( 'rank_math_the_breadcrumbs' ) ) {
			return 'rankmath';
		} elseif ( function_exists( 'seopress_display_breadcrumbs' ) ) {
			return 'seopress';
		} elseif ( class_exists( '\SlimSEO\Breadcrumbs' ) ) {
			return 'slim';
		} elseif ( function_exists( 'yoast_breadcrumb' ) ) {
			return 'yoast';
		} elseif ( function_exists( 'zynith_seo_breadcrumbs' ) ) {
			return 'zynith';
		} else {
			return 'none';
		}
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;
		$seoPlugin = Helpers::get_value( $settings, 'seoPlugin', $this->getSeoPlugin() );

		$this->set_attribute('_root', 'class', ['breadcrumbs-' . $seoPlugin]);

		echo "<{$this->tag} {$this->render_attributes( '_root' )}>";

		if( $seoPlugin == 'allinone' && function_exists( 'aioseo_breadcrumbs' ) ) {
			add_filter( 'esc_html', [ $this, 'bu_avoid_esc_html' ], 10, 2 );
			add_filter( 'aioseo_breadcrumbs_separator_symbol', [ $this, 'bu_allinone_separator_symbol' ] );
			aioseo_breadcrumbs();
			remove_filter( 'aioseo_breadcrumbs_separator_symbol', [ $this, 'bu_allinone_separator_symbol' ] );
			remove_filter( 'esc_html', [ $this, 'bu_avoid_esc_html' ], 10, 2 );
		} elseif( $seoPlugin == 'navxt' && function_exists( 'bcn_display' ) ) {
			$linked = isset( $settings['disableLink'] ) ? false : true;
			$reverse = isset( $settings['reverse'] ) ? true : false;
			$force = isset( $settings['force'] ) ? true : false;

			bcn_display(false, $linked, $reverse, $force);
		} elseif( $seoPlugin == 'rankmath' && function_exists( 'rank_math_the_breadcrumbs' )) {
			add_filter('rank_math/frontend/breadcrumb/settings', [ $this, 'bu_rank_math_crumbs_settings' ] );
			add_filter('rank_math/frontend/breadcrumb/html', [ $this, 'bu_rank_math_crumbs_html' ], 10, 3 );
			rank_math_the_breadcrumbs();
			remove_filter('rank_math/frontend/breadcrumb/settings', [ $this, 'bu_rank_math_crumbs_settings' ] );
			remove_filter('rank_math/frontend/breadcrumb/html', [ $this, 'bu_rank_math_crumbs_html' ], 10, 3 );
		} elseif( $seoPlugin == 'seopress' && function_exists( 'seopress_display_breadcrumbs' )) {
			seopress_display_breadcrumbs();
		} elseif( $seoPlugin == 'slim' && class_exists( '\SlimSEO\Breadcrumbs' ) ) {
			$homeText = isset( $this->settings['homeLabel'] ) ? esc_html( $settings['homeLabel'] ) : 'Home';
			$current_page = isset( $settings['disableCurPage'] ) ? 'false' : 'true';
			$separator = isset( $settings['separator'] ) ? esc_html( $settings['separator'] ) : '&raquo;';
			$searchLabel = isset( $this->settings['searchLabel'] ) ? esc_html( $this->settings['searchLabel'] ) : 'Results for &#8220;%s&#8221;';
			$errorLabel = isset( $this->settings['errorLabel'] ) ? esc_html( $this->settings['errorLabel'] ) : 'Page not found';
			$taxonomy = isset( $this->settings['taxonomy'] ) ? esc_html( $this->settings['taxonomy'] ) : 'category';

			$slimShortcode = '[slim_seo_breadcrumbs separator="' . $separator . '" display_current="' . $current_page . '" label_home="' . $homeText . '" label_search="' . $searchLabel . '" label_404="' . $errorLabel . '" taxonomy="' . $taxonomy . '"]';
			
			if ( shortcode_exists('slim_seo_breadcrumbs') ) {
				echo do_shortcode( $slimShortcode );
			}
		} elseif( $seoPlugin == 'yoast' && function_exists( 'yoast_breadcrumb' )) {
			add_filter( 'wpseo_frontend_presentation', [$this, 'bu_wpseo_frontend_presentation'], 10, 2 );
			
			add_filter( 'wpseo_breadcrumb_separator', [ $this, 'bu_wpseo_yoast_separator' ] );

			if( $this->tag == 'p' )
				$tag = 'span';
			else
				$tag = 'p';

			yoast_breadcrumb( '<'. $tag .' id="breadcrumbs">','</'. $tag .'>' );

			remove_filter( 'wpseo_breadcrumb_separator', [ $this, 'bu_wpseo_yoast_separator' ] );
			remove_filter( 'wpseo_frontend_presentation', [$this, 'bu_wpseo_frontend_presentation'], 10, 2 );
		} elseif ( function_exists('zynith_seo_breadcrumbs') ) {
			zynith_seo_breadcrumbs();
		}

		echo "</{$this->tag}>";
	}

	public function bu_allinone_separator_symbol( $symbol ) {
		if( ! empty( $this->settings['sepIcon'] ) ) {
			$symbol = self::render_icon( $this->settings['sepIcon'] );
		}
		
		return $symbol;
	}

	public function bu_avoid_esc_html( $esc_html_text, $text ) {
		return $text;
	}

	public function bu_wpseo_frontend_presentation( $presentation, $context ) {
		if( Helpers::isBricksBuilderActive() && is_object( $presentation ) && empty( $presentation->model->breadcrumb_title ) ) {
			$presentation->model->breadcrumb_title = get_the_title();
		}

		return $presentation;
	}

	function bu_wpseo_yoast_separator( $separator ){
		if( ! empty( $this->settings['sepIcon'] ) ) {
			$separator = self::render_icon( $this->settings['sepIcon'] );
		}

		if( strpos( $separator, 'separator' ) > 0 )
			return $separator;
		else
			return '<span class="separator">' . $separator . '</span>';
	}

	public function bu_rank_math_crumbs_settings( $settings ) {
		if( ! empty( $this->settings['sepIcon'] ) ) {
			$settings['separator'] = self::render_icon( $this->settings['sepIcon'] );
		}
		
		return $settings;
	}

	public function bu_rank_math_crumbs_html( $html, $crumbs, $object ) {
		return str_replace( 'class="last"', 'class="last breadcrumb_last"', $html );
	}
}