<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class Countdown extends \Bricks\Element {
	public $category = 'ultimate';
	public $name 	= 'bu-countdown';
	public $icon 	= 'ti-timer';
	public $tag 	= 'div';
	public $scripts = [ 'ultimateCountdown' ];

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Countdown', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {

		$this->control_groups['blocks'] = [
			'title' => esc_html__( 'Blocks', 'bricksultimate' ),
			'tab' 	=> 'content',
		];

		$this->control_groups['labels'] = [
			'title' => esc_html__( 'Labels', 'bricksultimate' ),
			'tab' 	=> 'content',
		];

		$this->control_groups['digit'] = [
			'title' => esc_html__( 'Digits', 'bricksultimate' ),
			'tab' 	=> 'content',
		];

		$this->control_groups['separator'] = [
			'title' => esc_html__( 'Separator colon(:)', 'bricksultimate' ),
			'tab' 	=> 'content',
		];

		$this->control_groups['action'] = [
			'title' => esc_html__( 'Action', 'bricksultimate' ),
			'tab' 	=> 'content',
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['timerType'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Timer type', 'bricksultimate' ),
			'type'        => 'select',
			'options'     => [ 
				"fixed" 	=> esc_html__("Fixed"),  
				"evergreen" => esc_html__("Evergreen") 
			],
			'inline' 		=> true,
			'default' 		=> 'fixed',
			'fullAccess'  => true,
		];

		$this->controls['source'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Time source', 'bricksultimate' ),
			'type'        => 'select',
			'options'     => [ 
				"default" 	=> esc_html__("Default", 'bricksultimate'),
				"cf" 		=> esc_html__("Custom Field", 'bricksultimate'),
				"acf" 		=> esc_html__("ACF", 'bricksultimate'),  
				"acfopt" 	=> esc_html__("ACF Option Page", 'bricksultimate'), 
				"mb" 		=> esc_html__('Metabox', 'bricksultimate'),
				"wcss" 		=> esc_html__('Sale start - Woo', 'bricksultimate'),
				"wcsend" 	=> esc_html__('Sale end - Woo', 'bricksultimate'),
				"wccpn" 	=> esc_html__('Coupon expiry date - Woo', 'bricksultimate'),
				"termmeta" 	=> esc_html__('Term meta', 'bricksultimate'),
			],
			'default' 	=> 'default',
			'info' => esc_html__( 'Date format: Y-m-d H:i:s or timestamp value', 'bricksultimate' ),
			'fullAccess'  => true,
		];

		$this->controls['customField'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Field name', 'bricksultimate' ),
			'type'        => 'text',
			'placeholder' => esc_html__( 'Date/Time picker field name', 'bricksultimate' ),
			'fullAccess'  => true,
			'hasDynamicData' => true,
			'required' 	=> ['source', '=', ['acf', 'mb', 'acfopt', 'cf', 'termmeta']]
		];

		$this->controls['coupon_code'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Enter coupon code', 'bricksultimate' ),
			'type'        => 'text',
			'placeholder' => esc_html__( 'enter code', 'bricksultimate' ),
			'description' => esc_html__( 'Leave blank if you are running the Coupons loop builder.', 'bricksultimate' ),
			'hasDynamicData' => true,
			'required' 	=> ['source', '=', 'wccpn']
		];

		$this->controls['year'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Year', 'bricksultimate' ),
			'type' 		=> 'select',
			'options' 	=> $this->getYear(),
			'inline' 	=> true,
			'default' 	=> date('Y', strtotime('+1 year')),
			'required' 	=> [['source', '=', 'default'], ['timerType', '=', 'fixed']]
		];

		$this->controls['month'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Month', 'bricksultimate' ),
			'type' 		=> 'select',
			'options' 	=> $this->getMonth(),
			'inline' 	=> true,
			'default' 	=> 1,
			'required' 	=> [['source', '=', 'default'], ['timerType', '=', 'fixed']]
		];

		$this->controls['day'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Days/Date', 'bricksultimate' ),
			'type' 		=> 'select',
			'options' 	=> $this->getDay(),
			'inline' 	=> true,
			'default' 	=> 31,
			'required' 	=> [['source', '=', 'default'], ['timerType', '=', ['fixed', 'evergreen']]]
		];

		$this->controls['hour'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Hour', 'bricksultimate' ),
			'type' 		=> 'select',
			'options' 	=> $this->getHour(),
			'inline' 	=> true,
			'default' 	=> 23,
			'required' 	=> [['source', '=', 'default'], ['timerType', '=', ['fixed', 'evergreen']]]
		];

		$this->controls['minute'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Minute', 'bricksultimate' ),
			'type' 		=> 'select',
			'options' 	=> $this->getMinSec(),
			'inline' 	=> true,
			'default' 	=> 59,
			'required' 	=> [['source', '=', 'default'], ['timerType', '=', ['fixed', 'evergreen']]]
		];

		$this->controls['second'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Second', 'bricksultimate' ),
			'type' 		=> 'select',
			'options' 	=> $this->getMinSec(),
			'inline' 	=> true,
			'default' 	=> 59,
			'required' 	=> [['source', '=', 'default'], ['timerType', '=', ['fixed', 'evergreen']]]
		];

		$this->controls['timeZone'] = [
			'tab' 			=> 'content',
			'label' 		=> esc_html__( 'Timezone', 'bricksultimate' ),
			'type' 			=> 'select',
			'options' 		=> $this->getTimezones(),
			'searchable' 	=> true,
			'fullAccess' 	=> true,
			'default' 		=> 'Asia/Kolkata',
			'placeholder' 	=> esc_html__('Select timezone', 'bricksultimate')
		];

		/*$this->controls['isRTL'] = [
			'tab'    	=> 'content',
			'type'      => 'checkbox',
			'label'     => esc_html__('Direction(RTL)', 'bricksultimate'),
			'inline' 	=> true
		];*/

		$this->actionControls();

		$this->blockControls();

		$this->labelControls();

		$this->digitControls();

		$this->separatorControls();
	}

	public function blockControls() {
		$this->controls['bgap'] = [
			'group' => 'blocks',
			'label' => esc_html__( 'Gap', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'css' 	=> [
				[
					'property' => 'gap'
				]
			],
		];

		$this->controls['blckpad'] = [
			'group' => 'blocks',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'type' 	=> 'dimensions',
			'css' 	=> [
				[
					'selector' => '.bu-countdown-item',
					'property' => 'padding'
				]
			],
		];

		$this->controls['bwidth'] = [
			'group' => 'blocks',
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'css' 	=> [
				[
					'selector' => '.bu-countdown-item',
					'property' => 'width'
				]
			],
		];

		$this->controls['bbg'] = [
			'group'    	=> 'blocks',
			'type'      => 'color',
			'label'     => esc_html__('Background color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-countdown-item",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['bborder'] = [
			'group'    	=> 'blocks',
			'type'      => 'border',
			'label'     => esc_html__('Borders', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-countdown-item",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['bshadow'] = [
			'group'    	=> 'blocks',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-countdown-item",
					'property' 	=> 'box-shadow'
				]
			]
		];
	}

	public function digitControls() {
		$this->controls['dtag'] = [
			'group' => 'digit',
			'label' => esc_html__( 'Tag', 'bricksultimate' ),
			'type' => 'select',
			'options' => [ 
				'h1' 	=> __('H1', "bricksultimate"),
				'h2' 	=> __('H2', "bricksultimate"),
				'h3' 	=> __('H3', "bricksultimate"),
				'h4' 	=> __('H4', "bricksultimate"),
				'h5' 	=> __('H5', "bricksultimate"),
				'h6' 	=> __('H6', "bricksultimate"),
				'div' 	=> __('DIV', "bricksultimate"),
				'p' 	=> __('P', "bricksultimate"),
			],
			'inline' 	=> true,
			'default' 	=> 'h3',
			'fullAccess'  => true,
		];

		$this->controls['dmargin'] = [
			'group' => 'digit',
			'label' => esc_html__( 'Margin', 'bricksultimate' ),
			'type' 	=> 'dimensions',
			'css' 	=> [
				[
					'selector' => '.bu-countdown-digit-wrapper',
					'property' => 'margin'
				]
			],
		];

		$this->controls['dpad'] = [
			'group' => 'digit',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'type' 	=> 'dimensions',
			'css' 	=> [
				[
					'selector' => '.bu-countdown-digit',
					'property' => 'padding'
				]
			],
		];

		$this->controls['dwidth'] = [
			'group' => 'digit',
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'css' 	=> [
				[
					'selector' => '.bu-countdown-digit-wrapper',
					'property' => 'width'
				]
			],
		];

		$this->controls['dheight'] = [
			'group' => 'digit',
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'css' 	=> [
				[
					'selector' => '.bu-countdown-digit-wrapper',
					'property' => 'height'
				],
				[
					'selector' => '.bu-countdown-digit-wrapper',
					'property' => 'line-height'
				]
			],
		];

		$this->controls['dbg'] = [
			'group'    	=> 'digit',
			'type'      => 'color',
			'label'     => esc_html__('Background color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-countdown-digit-wrapper",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['dtg'] = [
			'group'    	=> 'digit',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-countdown-digit",
					'property' 	=> 'font'
				]
			]
		];

		$this->controls['dborder'] = [
			'group'    	=> 'digit',
			'type'      => 'border',
			'label'     => esc_html__('Borders', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-countdown-digit-wrapper",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['dbs'] = [
			'group'    	=> 'digit',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-countdown-digit-wrapper",
					'property' 	=> 'box-shadow'
				]
			]
		];
	}

	public function labelControls() {
		$this->controls['displb'] = [
			'group'    	=> 'labels',
			'type'      => 'checkbox',
			'label'     => esc_html__('Show labels', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'default' 	=> true
		];

		$this->controls['lbtag'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Tag', 'bricksultimate' ),
			'type' => 'select',
			'options' => [ 
				'h1' 	=> __('H1', "bricksultimate"),
				'h2' 	=> __('H2', "bricksultimate"),
				'h3' 	=> __('H3', "bricksultimate"),
				'h4' 	=> __('H4', "bricksultimate"),
				'h5' 	=> __('H5', "bricksultimate"),
				'h6' 	=> __('H6', "bricksultimate"),
				'div' 	=> __('DIV', "bricksultimate"),
				'p' 	=> __('P', "bricksultimate"),
			],
			'inline' 	=> true,
			'default' 	=> 'div',
			'fullAccess'  => true,
			'required' => ['displb', '=', true]
		];

		$this->controls['label_position'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Position', 'bricksultimate' ),
			'type' => 'select',
			'options' => [ 
				'below' 	=> __( 'Below Digit', "bricksultimate" ),
				'above' 	=> __( 'Above Digit', "bricksultimate" ),
				'right' 	=> __( 'Right Side of Digit', "bricksultimate" ),
				'left' 		=> __( 'Left Side of Digit', "bricksultimate" ),
			],
			"default" 	=> 'below',
			'fullAccess'  => true,
			'required' => ['displb', '=', true]
		];

		$selector = '.bu-countdown-label-wrapper';

		$this->controls['lbmargin'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Margin', 'bricksultimate' ),
			'type' 	=> 'dimensions',
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'margin'
				]
			],
			'required' => ['displb', '=', true]
		];

		$this->controls['lbpad'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'type' 	=> 'dimensions',
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'padding'
				]
			],
			'required' => ['displb', '=', true]
		];

		$this->controls['lbwidth'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'width'
				]
			],
			'required' => ['displb', '=', true]
		];

		$this->controls['lbbg'] = [
			'group'    	=> 'labels',
			'type'      => 'color',
			'label'     => esc_html__('Background color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			],
			'required' => ['displb', '=', true]
		];

		$this->controls['lbtg'] = [
			'group'    	=> 'labels',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-countdown-label",
					'property' 	=> 'font'
				]
			],
			'required' => ['displb', '=', true]
		];

		$this->controls['lbborder'] = [
			'group'    	=> 'labels',
			'type'      => 'border',
			'label'     => esc_html__('Borders', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			],
			'required' => ['displb', '=', true]
		];

		$this->controls['sepYear'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Year', 'bricksultimate' ),
			'type' => 'separator',
			'required' => ['displb', '=', true]
		];

		$this->controls['dispyear'] = [
			'group'    	=> 'labels',
			'type'      => 'checkbox',
			'label'     => esc_html__('Display year', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'default' 	=> true,
			'required' => ['displb', '=', true]
		];

		$this->controls['yearSing'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Singular', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Year',
			'required' => ['dispyear', '=', true]
		];

		$this->controls['yearPul'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Plural', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Years',
			'required' => ['dispyear', '=', true]
		];

		$this->controls['sepMonth'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Month', 'bricksultimate' ),
			'type' => 'separator',
			'required' => ['displb', '=', true]
		];

		$this->controls['dispmo'] = [
			'group'    	=> 'labels',
			'type'      => 'checkbox',
			'label'     => esc_html__('Display month', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'default' 	=> true,
			'required' => ['displb', '=', true]
		];

		$this->controls['monthSing'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Singular', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Month',
			'required' => ['dispmo', '=', true]
		];

		$this->controls['monthPul'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Plural', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Months',
			'required' => ['dispmo', '=', true]
		];

		$this->controls['sepDay'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Day', 'bricksultimate' ),
			'type' => 'separator',
			'required' => ['displb', '=', true]
		];

		$this->controls['dispday'] = [
			'group'    	=> 'labels',
			'type'      => 'checkbox',
			'label'     => esc_html__('Display day', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'default' 	=> true,
			'required' => ['displb', '=', true]
		];

		$this->controls['daySing'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Singular', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Day',
			'required' => ['dispday', '=', true]
		];

		$this->controls['dayPul'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Plural', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Days',
			'required' => ['dispday', '=', true]
		];

		$this->controls['sepHour'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Hour', 'bricksultimate' ),
			'type' => 'separator',
			'required' => ['displb', '=', true]
		];

		$this->controls['disphr'] = [
			'group'    	=> 'labels',
			'type'      => 'checkbox',
			'label'     => esc_html__('Display hour', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'default' 	=> true,
			'required' => ['displb', '=', true]
		];

		$this->controls['hourSing'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Singular', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Hour',
			'required' => ['disphr', '=', true]
		];

		$this->controls['hourPul'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Plural', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Hours',
			'required' => ['disphr', '=', true]
		];

		$this->controls['sepMinute'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Minute', 'bricksultimate' ),
			'type' => 'separator',
			'required' => ['displb', '=', true]
		];

		$this->controls['dispmin'] = [
			'group'    	=> 'labels',
			'type'      => 'checkbox',
			'label'     => esc_html__('Display minute', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'default' 	=> true,
			'required' => ['displb', '=', true]
		];

		$this->controls['minuteSing'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Singular', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Minute',
			'required' => ['dispmin', '=', true]
		];

		$this->controls['minutePul'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Plural', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Minutes',
			'required' => ['dispmin', '=', true]
		];

		$this->controls['sepSecond'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Second', 'bricksultimate' ),
			'type' => 'separator',
			'required' => ['displb', '=', true]
		];

		$this->controls['dispscnd'] = [
			'group'    	=> 'labels',
			'type'      => 'checkbox',
			'label'     => esc_html__('Display second', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'default' 	=> true,
			'required' => ['displb', '=', true]
		];

		$this->controls['secondSing'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Singular', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Second',
			'required' => ['dispscnd', '=', true]
		];

		$this->controls['secondPul'] = [
			'group' => 'labels',
			'label' => esc_html__( 'Plural', 'bricksultimate' ),
			'type' => 'text',
			'default' => 'Seconds',
			'required' => ['dispscnd', '=', true]
		];
		
	}

	public function separatorControls() {
		$this->controls['isColon'] = [
			'group'    	=> 'separator',
			'type'      => 'checkbox',
			'label'     => esc_html__('Enable', 'bricksultimate'),
			'inline' 	=> true,
			'info' 		=> esc_html__("Display between blocks", "bricksultimate"),
		];

		$this->controls['sepType'] = [
			'group'       => 'separator',
			'label'       => esc_html__( 'Type', 'bricksultimate' ),
			'type'        => 'select',
			'options'     => [ 
				'colon' 	=> __( 'Colon', 'bricksultimate' ),
				'line' 		=> __( 'Line', 'bricksultimate' )
			],
			'default' 	=> 'colon',
			'required'  => [ 'isColon', '=', true ],
		];

		//* Colon properties
		$this->controls['colonSize'] = [
			'group' => 'separator',
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'css' 	=> [
				[
					'selector' => '&.bu-countdown-separator-colon .bu-countdown-digit-wrapper:after',
					'property' => 'font-size'
				]
			],
			'required' 	=> [['isColon', '=', true], ['sepType', '=', 'colon']]
		];

		$this->controls['colonColor'] = [
			'group' => 'separator',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'type' 	=> 'color',
			'inline' => true,
			'css' 	=> [
				[
					'selector' => '&.bu-countdown-separator-colon .bu-countdown-digit-wrapper:after',
					'property' => 'color'
				]
			],
			'required' 	=> [['isColon', '=', true], ['sepType', '=', 'colon']]
		];

		$this->controls['colonPos'] = [
			'group' => 'separator',
			'label' => esc_html__( 'Position top', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'css' 	=> [
				[
					'selector' => '&.bu-countdown-separator-colon .bu-countdown-digit-wrapper:after',
					'property' => 'top'
				]
			],
			'required' 	=> [['isColon', '=', true], ['sepType', '=', 'colon']]
		];

		$this->controls['colonPosRight'] = [
			'group' => 'separator',
			'label' => esc_html__( 'Position right', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'css' 	=> [
				[
					'selector' => '&.bu-countdown-separator-colon .bu-countdown-digit-wrapper:after',
					'property' => 'right'
				]
			],
			'required' 	=> [['isColon', '=', true], ['sepType', '=', 'colon']]
		];

		//* Line properties
		$this->controls['lineSize'] = [
			'group' => 'separator',
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'css' 	=> [
				[
					'selector' => '&.bu-countdown-separator-line .bu-countdown-item:after',
					'property' => 'font-size'
				]
			],
			'required' 	=> [['isColon', '=', true], ['sepType', '=', 'line']]
		];

		$this->controls['lineColor'] = [
			'group' => 'separator',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'type' 	=> 'color',
			'inline' => true,
			'css' 	=> [
				[
					'selector' => '&.bu-countdown-separator-line .bu-countdown-item:after',
					'property' => 'color'
				]
			],
			'required' 	=> [['isColon', '=', true], ['sepType', '=', 'line']]
		];
	}

	public function actionControls() {
		$this->controls['timer_action'] = [
			'group'       => 'action',
			'label'       => esc_html__( 'Action after time expires', 'bricksultimate' ),
			'type'        => 'select',
			'options'     => [ 
				'none' 		=> __( 'None', 'bricksultimate' ),
				'hide' 		=> __( 'Hide timer', 'bricksultimate' ),
				'toggle' 	=> __( 'Hide timer and toggle content', 'bricksultimate' ),
				'reset'     => __( 'Reset timer(evergreen)', 'bricksultimate' ),
				'msg' 		=> __( 'Display message', 'bricksultimate' ),
				'redirect' 	=> __( 'Redirect to URL', 'bricksultimate' )
			],
			'default' 	=> 'none',
			'fullAccess'  => true,
		];

		$this->controls['selector'] = [
			'group'       => 'action',
			'label'       => esc_html__( 'Content selectors: Show', 'bricksultimate' ),
			'type'        => 'text',
			'placeholder' => esc_html__('.add_to_cart_button', 'bricksultimate'),
			'required' 	=> ['timer_action', '=', 'toggle']
		];

		$this->controls['hideSelector'] = [
			'group'       => 'action',
			'label'       => esc_html__( 'Content selectors: Hide', 'bricksultimate' ),
			'type'        => 'text',
			'placeholder' => esc_html__('.add_to_cart_button', 'bricksultimate'),
			'required' 	=> ['timer_action', '=', 'toggle']
		];

		$this->controls['expire_message'] = [
			'group'       => 'action',
			'label'       => esc_html__( 'Message', 'bricksultimate' ),
			'type'        => 'textarea',
			'placeholder' => esc_html__('Enter text here', 'bricksultimate'),
			'required' 	=> ['timer_action', '=', 'msg']
		];

		$this->controls['exppad'] = [
			'group' => 'action',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'type' 	=> 'dimensions',
			'css' 	=> [
				[
					'selector' => '.bu-countdown-expire-message',
					'property' => 'padding'
				]
			],
			'required' 	=> ['timer_action', '=', 'msg']
		];

		$this->controls['expwidth'] = [
			'group' => 'action',
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'inline' => true,
			'css' 	=> [
				[
					'selector' => '.bu-countdown-expire-message',
					'property' => 'width'
				]
			],
			'required' 	=> ['timer_action', '=', 'msg']
		];

		$this->controls['expbg'] = [
			'group'    	=> 'action',
			'type'      => 'color',
			'label'     => esc_html__('Background color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.bu-countdown-expire-message',
					'property' 	=> 'background-color'
				]
			],
			'required' 	=> ['timer_action', '=', 'msg']
		];

		$this->controls['msgTg'] = [
			'group' 	=> 'action',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				'selector' => '.bu-countdown-expire-message',
				'property' => 'font'
			],
			'required' 	=> ['timer_action', '=', 'msg']
		];

		$this->controls['redirect_link'] = [
			'group' 	=> 'action',
			'type' 		=> 'link',
			'label' 	=> esc_html__( 'Redirect URL', 'bricksultimate' ),
			'exclude' 	=> [
				'title',
				'ariaLabel',
				'newTab',
				'rel'
			],
			'required' 	=> ['timer_action', '=', 'redirect']
		];

		$this->controls['redirect_link_target'] = [
			'group' 	=> 'action',
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__( 'Go to new tab', 'bricksultimate' ),
			'required' 	=> [['redirect_link', '!=', ''],['timer_action', '=', 'redirect']]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-countdown', Helpers::get_asset_url('css') . 'countdown.min.css', [], filemtime(Helpers::get_asset_path('css') . 'countdown.min.css'), 'all' );
		}*/

		wp_enqueue_script( 'bu-plugin', Helpers::get_asset_url('js') . 'jquery.plugin.js', [], '1.0', true );
		wp_enqueue_script( 'bu-cookie', Helpers::get_asset_url('js') . 'jquery.cookie.min.js', [], '1.0', true );
		wp_enqueue_script( 'bu-countdown', Helpers::get_asset_url('js') . 'jquery.countdown.js', [], '2.1.0', true );
		wp_enqueue_script( 'bu-countdown-init', Helpers::get_asset_url('js') . 'countdown.min.js', ['jquery'], filemtime(Helpers::get_asset_path('js') . 'countdown.min.js'), true );
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;
		$timeZone = Helpers::get_value($settings, 'timeZone', false);
		$source = Helpers::get_value($settings, 'source', 'default');
		$cmField = bricks_render_dynamic_data( Helpers::get_value($settings, 'customField', false) );
		$position = Helpers::get_value($settings, 'label_position', 'below');

		if ( $timeZone ) {
			$time_zone_kolkata = new \DateTimeZone( 'Asia/Kolkata' );
			$time_zone         = new \DateTimeZone( $timeZone );
			$time_kolkata = new \DateTime( 'now', $time_zone_kolkata );
			$timeoffset = $time_zone->getOffset( $time_kolkata );
			$timeZone = $timeoffset / 3600;
		} else {
			$time_zone = new \DateTimeZone( 'Asia/Kolkata' );
			$timeZone = 'NULL';
		}

		$termId = $time = $loopObject = false;
		$looping_query_id = \Bricks\Query::is_any_looping();
		if ( ! empty( $looping_query_id ) ) {
			$loopObject = \Bricks\Query::get_loop_object( $looping_query_id );
		}

		$post_id = is_object( $loopObject ) ? $loopObject->ID : $this->post_id;

		if( $source == "wcss" || $source == "wcsend" ) {
			
			if( ! class_exists('WooCommerce') )
				return $this->render_element_placeholder( ['title' => esc_html__( 'Install and activate the WooCommerce plugin.', 'bricksultimate' )] );

			global $product;

			if( ! is_a($product, 'WC_Product') ) {
				$product = wc_get_product( $post_id );
			}

			if( $product === false )
				return $this->render_element_placeholder( ['title' => esc_html__( 'This is not a product post type.', 'bricksultimate' )] );

			if( $source == "wcss" )
				$time = $this->prepare_date_response( $product->get_date_on_sale_from(), $time_zone );

			if( $source == "wcsend" )
				$time = $this->prepare_date_response( $product->get_date_on_sale_to(), $time_zone );

			if( $time ) {
				$curtime = new \DateTime( 'now', $time_zone );
				$datetime = \date_create_immutable_from_format( 'Y-m-d H:i:s', $time, $time_zone );

				if( $curtime->getTimestamp() > $datetime->getTimestamp() ) {
					return $this->render_element_placeholder( ['title' => esc_html__( 'This product has no sale date.', 'bricksultimate' )] );
				}

				$settings = $this->getCustomFieldDate( $datetime->format('Y-m-d H:i:s'), $settings );
			} else {
				return $this->render_element_placeholder( ['title' => esc_html__( 'This product has no sale date.', 'bricksultimate' )] );
			}
		}

		if( $source == "wccpn" ) {

			if( ! class_exists('WooCommerce') )
				return $this->render_element_placeholder( ['title' => esc_html__( 'Install and activate the WooCommerce plugin.', 'bricksultimate' )] );

			$looping_query_id = \Bricks\Query::is_any_looping();
			$loop = false;

			if ( ! empty( $looping_query_id ) ) {
				$loop = \Bricks\Query::get_loop_object( $looping_query_id );
			}

			if( $loop && get_post_type( $loop ) == 'shop_coupon' ) {
				$expiry_date = metadata_exists( 'post', $loop->ID, 'date_expires' ) ? get_post_meta( $loop->ID, 'date_expires', true ) : get_post_meta( $loop->ID, 'expiry_date', true );
				if( $expiry_date ) {
					$settings = $this->getCustomFieldDate( date('Y-m-d H:i:s', $expiry_date), $settings );
				} else {
					return $this->render_element_placeholder( ['title' => esc_html__( 'Has no expiry date.', 'bricksultimate' )] );
				}
			} else {
				$coupon = Helpers::get_value($settings, 'coupon_code', false);
				if( $coupon ) {
					$couponObject = new \WC_Coupon( $coupon );
					if ( $couponObject->is_valid() ) {
						$time = $couponObject->get_date_expires()->date('Y-m-d H:i:s');
						if( $time ) {
							$settings = $this->getCustomFieldDate( $time, $settings );
						} else {
							return $this->render_element_placeholder( ['title' => esc_html__( 'Has no expiry date.', 'bricksultimate' )] );
						}
					} else {
						return $this->render_element_placeholder( ['title' => esc_html__( 'Invaid coupon', 'bricksultimate' )] );
					}
				} else {
					return $this->render_element_placeholder( ['title' => esc_html__( 'Enter coupon code.', 'bricksultimate' )] );
				}
			}
		}

		if( ( $source == 'acf' || $source == 'mb' || $source == 'cf' ) && $cmField ) {
			$date = get_post_meta( $post_id, $cmField, true );
			$settings = $this->getCustomFieldDate( $date, $settings );
		}

		if( $source == 'acfopt' && function_exists('get_field') && $cmField ) {
			$date = get_option( 'options_' . $cmField );
			$settings = $this->getCustomFieldDate( $date, $settings );
		}

		if( $source == "termmeta" && $cmField ) {
			$termId = ( is_tax() ) ? get_queried_object_id() : ( is_object( $loopObject ) ? $loopObject->term_id : false );
			if( $termId ) {
				$date = get_term_meta( $termId, $cmField, true);
				$settings = $this->getCustomFieldDate( $date, $settings );
			}
		}

		$timerType = Helpers::get_value($settings, 'timerType', 'fixed');
		$id = sprintf( "%s-{$this->id}", ( $termId && $source == "termmeta" ) ? $termId : $post_id ) ;
		$sepClass = '';
		if ( !empty( $settings['isColon'] ) ) { 
			$sepClass = ' bu-countdown-separator-' . Helpers::get_value($settings, 'sepType', 'colon'); 
		}

		$this->set_attribute('_root', 'class', ["bu-countdown{$sepClass}", "bu-countdown-{$timerType}-timer", "bu-countdown-{$id}"]);

		$layout = null;
		if ( 'above' == $position ) {
			if ( 'evergreen' != $timerType )
				$layout .= '{y<}' . $this->inside_above_countdown( $settings, '{ynn}', '{yl}', '{y>}' );
			
			$layout .= sprintf( '{o<}%s{d<}%s{h<}%s{m<}%s{s<}%s', 
				$this->inside_above_countdown( $settings, '{onn}', '{ol}', '{o>}' ),
				$this->inside_above_countdown( $settings, '{dnn}', '{dl}', '{d>}' ),
				$this->inside_above_countdown( $settings, '{hnn}', '{hl}', '{h>}' ),
				$this->inside_above_countdown( $settings, '{mnn}', '{ml}', '{m>}' ),
				$this->inside_above_countdown( $settings, '{snn}', '{sl}', '{s>}' )
			);

		} elseif ('right' == $position || 'left' == $position ) {
			if ( 'evergreen' != $timerType )
				$layout .= '{y<}' . $this->outside_countdown( $settings, '{ynn}', '{yl}', '{y>}' );
		
			$layout .= sprintf( '{o<}%s{d<}%s{h<}%s{m<}%s{s<}%s', 
				$this->outside_countdown( $settings, '{onn}', '{ol}', '{o>}' ),
				$this->outside_countdown( $settings, '{dnn}', '{dl}', '{d>}' ),
				$this->outside_countdown( $settings, '{hnn}', '{hl}', '{h>}' ),
				$this->outside_countdown( $settings, '{mnn}', '{ml}', '{m>}' ),
				$this->outside_countdown( $settings, '{snn}', '{sl}', '{s>}' )
			);

		} else {
			if ( 'evergreen' != $timerType )
				$layout .= '{y<}' . $this->normal_view( $settings, '{ynn}', '{yl}' ) . '{y>}';

			$layout .= sprintf( "{o<}%s{o>}{d<}%s{d>}{h<}%s{h>}{m<}%s{m>}{s<}%s{s>}", 
				$this->normal_view( $settings, '{onn}', '{ol}' ),
				$this->normal_view( $settings, '{dnn}', '{dl}' ),
				$this->normal_view( $settings, '{hnn}', '{hl}' ),
				$this->normal_view( $settings, '{mnn}', '{ml}' ),
				$this->normal_view( $settings, '{snn}', '{sl}' )
			);
		}
		$url = '';
		if( isset( $settings['redirect_link'] ) ) {
			$this->set_link_attributes( 'pagelink', $settings['redirect_link'] );
			$redirectUrl = $this->attributes['pagelink'];

			$url = esc_url( $redirectUrl['href'][0] );
		}

		$data = [
			'id' 		=> $id,
			'timertype' => $timerType,
			'action' 	=> Helpers::get_value($settings,'timer_action', 'none'),
			'year' 		=> absint( Helpers::get_value($settings,'year',date('Y', strtotime('+1 year'))) ),
			'month' 	=> absint( Helpers::get_value($settings,'month',1) ),
			'day' 		=> absint( Helpers::get_value($settings,'day',31) ),
			'hour' 		=> absint( Helpers::get_value($settings,'hour',23) ),
			'minute' 	=> absint( Helpers::get_value($settings,'minute',59) ),
			'second' 	=> absint( Helpers::get_value($settings,'second',59) ),
			'time_zone' 			=> $timeZone,
			'timer_format' 			=> $this->timerFormat( $settings ),
			'timer_labels' 			=> $this->timerLabels( $settings, 'Pul'),
			'timer_labels_singular' => $this->timerLabels( $settings, 'Sing' ),
			'timer_layout' 			=> trim($layout),
			'timer_exp_text' 		=> sprintf('<div class="bu-countdown-expire-message">%s</div>',
									  		preg_replace( '/\s+/', ' ', Helpers::get_value( $settings, 'expire_message', '') )
										),
			'redirect_link_target' 	=> ! empty($settings['redirect_link_target'] ) ? '_blank' : '_self',
			'redirect_link' 		=> $url,
			'isRTL' 	=> false
		];
		
		if( Helpers::get_value($settings,'timer_action', 'none') == 'toggle' ) {
			$selectors = Helpers::get_value($settings,'selector', false);
			$hideSelectors = Helpers::get_value($settings,'hideSelector', false);
			
			if( $selectors )
				$data['selectors'] = $selectors;

			if( $hideSelectors )
				$data['hideSelectors'] = $hideSelectors;
		}

		$this->set_attribute('_root', 'data-timer-config', wp_json_encode($data));

		echo "<{$this->tag} {$this->render_attributes('_root')}></{$this->tag}>";
	}

	function prepare_date_response( $date, $timeZone ) {
		if ( is_numeric( $date ) ) {
			$date = new WC_DateTime( "@{$date}", $timeZone );
			$date->setTimezone( $timeZone );
		} elseif ( is_string( $date ) ) {
			$date = new WC_DateTime( $date, $timeZone );
			$date->setTimezone( $timeZone );
		}

		if ( ! is_a( $date, 'WC_DateTime' ) ) {
			return null;
		}

		return $date->format('Y-m-d H:i:s');
	}

	public function timerFormat( $settings ) {
		return sprintf('%s%s%s%s%s%s',
			! empty($settings['dispyear']) ? 'Y' : '',
			! empty($settings['dispmo']) ? 'O' : '',
			! empty($settings['dispday']) ? 'D' : '',
			! empty($settings['disphr']) ? 'H' : '',
			! empty($settings['dispmin']) ? 'M' : '',
			! empty($settings['dispscnd']) ? 'S' : ''
		);
	}

	public function timerLabels( $settings, $type ) {
		return sprintf('%s,%s,%s,%s,%s,%s,%s',
			Helpers::get_value($settings, "year{$type}", (($type == 'Sing') ? __('Year') : __('Years')) ),
			Helpers::get_value($settings, "month{$type}", (($type == 'Sing') ? __('Month') : __('Months')) ),
			Helpers::get_value($settings, "month{$type}", (($type == 'Sing') ? __('Week') : __('Weeks')) ),
			Helpers::get_value($settings, "day{$type}", (($type == 'Sing') ? __('Day') : __('Days')) ),
			Helpers::get_value($settings, "hour{$type}", (($type == 'Sing') ? __('Hour') : __('Hours')) ),
			Helpers::get_value($settings, "minute{$type}", (($type == 'Sing') ? __('Minute') : __('Minutes')) ),
			Helpers::get_value($settings, "second{$type}", (($type == 'Sing') ? __('Second') : __('Seconds')) ),
		);
	}

	public function getCustomFieldDate( $date, $options ) {
		if( empty( $date ) )
			return $options;
		
		if( strpos( $date, '-') && strpos( $date, ':') ) {
			$dtArr= explode(" ", $date);
			$dateArr = explode("-", $dtArr[0]);
			$options['year'] = $dateArr[0];
			$options['month'] = $dateArr[1];
			$options['day'] = $dateArr[2];

			$timeArr = explode(":", $dtArr[1]);
			$options['hour'] = $timeArr[0];
			$options['minute'] = $timeArr[1];

			if( isset( $timeArr[2] ) )
				$options['second'] = $timeArr[2];
		} elseif( strpos( $date, '-') ) {
			$dateArr = explode("-", $date);
			$options['year'] = $dateArr[0];
			$options['month'] = $dateArr[1];
			$options['day'] = $dateArr[2];
			$options['hour'] = 23;
			$options['minute'] = 59;
		} elseif( strpos( $date, ':') ) {
			$timeArr = explode(":", $date);
			$options['day'] = '0';

			$options['hour'] = $timeArr[0];
			$options['minute'] = $timeArr[1];

			if( isset( $timeArr[2] ) )
				$options['second'] = $timeArr[2];

			$options['timerType'] = 'evergreen';
		} elseif( strlen( $date ) == 8 ) {
			$options['year'] = substr($date, 0, 4);
			$options['month'] = substr($date, 4, 2);
			$options['day'] = substr($date, 6, 2);
			$options['hour'] = 23;
			$options['minute'] = 59;
		} elseif( strpos( $date, '-') === false ) {
			$timetodate = date("Y-m-d H:i:s", $date );
			$dtArr= explode(" ", $timetodate);
			$dateArr = explode("-", $dtArr[0]);
			$options['year'] = $dateArr[0];
			$options['month'] = $dateArr[1];
			$options['day'] = $dateArr[2];

			$timeArr = explode(":", $dtArr[1]);
			$options['hour'] = $timeArr[0];
			$options['minute'] = $timeArr[1];
			$options['second'] = $timeArr[2];
		}

		return $options;
	}

	public function getTimezones() {
		$continents = array( 'Africa', 'America', 'Antarctica', 'Arctic', 'Asia', 'Atlantic', 'Australia', 'Europe', 'Indian', 'Pacific' );

		$zonen = array();
		foreach ( timezone_identifiers_list() as $zone ) {
			$zone = explode( '/', $zone );
			if ( ! in_array( $zone[0], $continents ) ) {
				continue;
			}

			$exists    = array(
				0 => ( isset( $zone[0] ) && $zone[0] ),
				1 => ( isset( $zone[1] ) && $zone[1] ),
				2 => ( isset( $zone[2] ) && $zone[2] ),
			);
			$exists[3] = ( $exists[0] && 'Etc' !== $zone[0] );
			$exists[4] = ( $exists[1] && $exists[3] );
			$exists[5] = ( $exists[2] && $exists[3] );

			$zonen[] = array(
				'continent'   => ( $exists[0] ? $zone[0] : '' ),
				'city'        => ( $exists[1] ? $zone[1] : '' ),
				'subcity'     => ( $exists[2] ? $zone[2] : '' ),
				't_continent' => ( $exists[3] ? translate( str_replace( '_', ' ', $zone[0] ), 'continents-cities' ) : '' ), // @codingStandardsIgnoreLine
				't_city'      => ( $exists[4] ? translate( str_replace( '_', ' ', $zone[1] ), 'continents-cities' ) : '' ), // @codingStandardsIgnoreLine
				't_subcity'   => ( $exists[5] ? translate( str_replace( '_', ' ', $zone[2] ), 'continents-cities' ) : '' ), // @codingStandardsIgnoreLine
			);
		}
		usort( $zonen, '_wp_timezone_choice_usort_callback' );

		$structure = array();
		foreach ( $zonen as $key => $zone ) {
			// Build value in an array to join later
			$value = array( $zone['continent'] );

			if ( empty( $zone['city'] ) ) {
				// It's at the continent level (generally won't happen)
				$display = $zone['t_continent'];
			} else {
				// It's inside a continent group

				// Continent optgroup
				if ( ! isset( $zonen[ $key - 1 ] ) || $zonen[ $key - 1 ]['continent'] !== $zone['continent'] ) {
					$label = $zone['t_continent'];
					$structure[esc_attr( $label ) . "GroupTitle"] = esc_attr( $label );
				}

				// Add the city to the value
				$value[] = $zone['city'];

				$display = $zone['t_city'];
				if ( ! empty( $zone['subcity'] ) ) {
					// Add the subcity to the value
					$value[]  = $zone['subcity'];
					$display .= ' - ' . $zone['t_subcity'];
				}
			}

			// Build the value
			$value    = join( '/', $value );
			$structure[ esc_attr( $value ) ] = esc_html( $display );
		}

		// Do UTC
		$structure["utcGroupTitle"] = esc_attr__( 'UTC', 'bricksultimate' );
		$structure["UTC"] = esc_html__( 'UTC', 'bricksultimate' );

		return $structure;
	}

	public function getYear() {
		$year['none'] = __('None');
		for ($i = 0; $i < 11; $i++) { 
			$year[date('Y', strtotime("+{$i} year"))] = date('Y', strtotime("+{$i} year"));
		}

		return $year;
	}

	function getMonth() {
		$month = [
			'none' => __('None'),
			1 => __('Jan'),
			2 => __('Feb'),
			3 => __('Mar'),
			4 => __('Apr'),
			5 => __('May'),
			6 => __('Jun'),
			7 => __('Jul'),
			8 => __('Aug'),
			9 => __('Sep'),
			10 => __('Oct'),
			11 => __('Nov'),
			12 => __('Dec')
		];

		return $month;
	}

	function getDay() {
		$date['none'] = __('None');
		for ($i=1; $i <= 31; $i++) { 
			$date[$i] = $i;
		}

		return $date;
	}

	public function getHour() {
		$hour['none'] = __('None');
		for ($i=0; $i < 24; $i++) { 
			$hour[$i] = $i;
		}

		return $hour;
	}

	public function getMinSec() {
		$min_sec['none'] = __('None');
		for ($i=0; $i <= 59; $i++) {
			$min_sec[$i] = $i;
		}

		return $min_sec;
	}

	public function normal_view( $options, $str1, $str2, $str3 = '' ) {
		ob_start();
		?>
		<div class="bu-countdown-item">
			<div class="bu-countdown-digit-wrapper">
				<<?php echo $options['dtag']; ?> class="bu-countdown-digit">
				<?php echo $str1; ?>
				</<?php echo $options['dtag']; ?>>
			</div>
			<?php if( ! empty( $options['displb'] ) ) { ?>
				<div class="bu-countdown-label-wrapper">
					<<?php echo $options['lbtag']; ?> class="bu-countdown-label">
					<?php echo $str2; ?>
					</<?php echo $options['lbtag']; ?>>
				</div>
			<?php } ?>
		</div>
	<?php
		$html = ob_get_contents();
		ob_end_clean();

		return str_replace(["\t", "\n"], '', $html);
	}

	public function inside_above_countdown( $options, $str1, $str2, $str3 ) {
		ob_start();
		?>
			<div class="bu-countdown-item">
				<?php if( ! empty( $options['displb'] ) ) { ?>
					<div class="bu-countdown-label-wrapper">
						<<?php echo $options['lbtag']; ?> class="bu-countdown-label">
							<?php echo $str2; ?>
						</<?php echo $options['lbtag']; ?>>
					</div>
				<?php } ?>
				<div class="bu-countdown-digit-wrapper">
					<<?php echo $options['dtag']; ?> class="bu-countdown-digit">
						<?php echo $str1; ?>
					</<?php echo $options['dtag']; ?>>
				</div>
				<?php echo $str3; ?>
			</div>
	<?php
		$html = ob_get_contents();
		ob_end_clean();
		return str_replace(["\t", "\n"], '', $html);
	}

	public function outside_countdown( $options, $str1, $str2, $str3 ) {
		ob_start();
		?>
		<div class="bu-countdown-item label-position-<?php echo $options['label_position']; ?>">
			<?php if( ! empty( $options['displb'] ) ) { ?>
				<div class="bu-countdown-label-wrapper">
					<<?php echo $options['lbtag']; ?> class="bu-countdown-label">
					<?php echo $str2; ?>
					</<?php echo $options['lbtag']; ?>>
				</div>
			<?php } ?>
			<div class="bu-countdown-digit-wrapper">
				<<?php echo $options['dtag']; ?> class="bu-countdown-digit">
				<?php echo $str1; ?>
				</<?php echo $options['dtag']; ?>>
			</div>
			<?php echo $str3; ?>
		</div>
	<?php
		$html = ob_get_contents();
		ob_end_clean();
		return str_replace(["\t", "\n"], '', $html);
	}
}