<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;
use FluentForm\App\Helpers\Helper;

class FluentFormsStyler extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-ff-styler';
	public $icon 			= 'ti-layout-accordion-merged';
	public $tag 			= 'div';
	public $scripts 		= ['buInitFF'];

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Fluent Forms Styler', 'bricksultimate' );
	}

	public function set_control_groups() {
		$this->control_groups['form_wrap']    = array(
			'title' => esc_html__( 'Form Container', 'bricksultimate' ),
			'tab'   => 'content',
		);
		
		$this->control_groups['label']    = array(
			'title' => esc_html__( 'Labels', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['astrx']    = array(
			'title' => esc_html__( 'Asterisk', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_inp']  = array(
			'title' => esc_html__( 'Input & Textarea', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_sub'] = array(
			'title' => esc_html__( 'Submit Button', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_cbr']  = array(
			'title' => esc_html__( 'GDPR, Checkbox & Radio', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_cbrp']  = array(
			'title' => esc_html__( 'Checkbox/Radio Photo', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_cgrid'] = array(
			'title' => esc_html__( 'Checkable Grid Field', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_rating'] = array(
			'title' => esc_html__( 'Rating Field', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_file'] = array(
			'title' => esc_html__( 'File Upload Field', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_rep'] = array(
			'title' => esc_html__( 'Repeater Field', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_nps'] = array(
			'title' => esc_html__( 'Net Promoter Score', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_paysum'] = array(
			'title' => esc_html__( 'Payment Summary', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_pgb'] = array(
			'title' => esc_html__( 'Form Step', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_sbtn'] = array(
			'title' => esc_html__( 'Form Step Buttons', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_sec'] = array(
			'title' => esc_html__( 'Section Break', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['ff_validation'] = array(
			'title' => esc_html__( 'Validation Error', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['suc_msg'] = array(
			'title' => esc_html__( 'Success Message', 'bricksultimate' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['ff_info'] = [
			'tab' 		=> 'content',
			'type' 		=> 'info',
			'content' 	=> esc_html__( "Create a form with Fluent Forms plugin before using this element.", 'bricksultimate' ),
		];

		$this->controls['source_type'] = [
			'tab' 		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__( 'Source Type', 'bricksultimate' ),
			'default' 	=> 'static',
			'options' 	=> [
				'static' 	=> esc_html__('Choose from dropwdown', 'bricksultimate'),
				'dynamic' 	=> esc_html__( 'Custom Field or Dynamic Tag', 'bricksultimate'),
			],
		];

		$forms = Helper::getForms();
		unset( $forms[ 0 ] );

		$this->controls['ff_form'] = [
			'tab' 			=> 'content',
			'type' 			=> 'select',
			'label' 		=> esc_html__( 'Form', 'bricksultimate' ),
			'options' 		=> $forms,
			'required'		=> [ 'source_type', '=', [ 'static' ] ],
			'placeholder' 	=> esc_html__('Select a Fluent Forms', 'fluentform'),
		];

		$this->controls['ffDynamicTag'] = [
			'tab' 			=> 'content',
			'type' 			=> 'text',
			'label' 		=> esc_html__( 'Dynamic Tag', 'bricksultimate' ),
			'info' 			=> __( "Make sure that it returns the fluent forms ID.", 'bricksultimate' ),
			'placeholder' 	=> esc_html__('Enter form ID or dynamic tag', 'bricksultimate'),
			'hasDynamicData' => true,
			'required'		=> [ 'source_type', '=', [ 'dynamic' ] ],
		];

		$this->controls['dformInfo'] = [
			'tab' 		=> 'content',
			'type' 		=> 'info',
			'content' 	=> esc_html__( "------ OR ------", 'bricksultimate' ),
			'required'	=> [ 'source_type', '=', [ 'dynamic' ] ],
		];

		$this->controls['ff_id'] = [
			'tab' 			=> 'content',
			'type' 			=> 'text',
			'label' 		=> esc_html__( 'Custom Field Name', 'bricksultimate' ),
			'info' 			=> __( "Make sure that it returns the fluent forms ID.", 'bricksultimate' ),
			'placeholder' 	=> esc_html__('Enter custom field key', 'bricksultimate'),
			'hasDynamicData' => false,
			'required'		=> [ 'source_type', '=', [ 'dynamic' ] ],
		];

		$this->formWrapperControls();
		$this->labelControls();
		$this->inputFieldControls();
		$this->submitControls();
		$this->checkboxControls();
		$this->crphotoControls();
		$this->cbgControls();
		$this->ratingControls();
		$this->fileUploadControls();
		$this->repeaterControls();
		$this->npscoreControls();
		$this->paymentControls();
		$this->pbControls();
		$this->sectionBreakControls();
		$this->validationControls();
		$this->successControls();
	}

	public function crphotoControls() {
		$group = 'ff_cbrp';
		$selector = '.fluentform .ff_el_checkable_photo_holders';

		$this->controls['gridcols'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'text',
			'label'     => esc_html__('Grid template columns', 'bricks'),
			'placeholder' => '1fr 1fr',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'grid-template-columns',
				]
			]
		];
		
		$this->controls['gridgap'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'number',
			'label'     => esc_html__('Grid gap', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'max'  		=> 30,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'gap',
				]
			]
		];

		$this->controls['gridPad'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-group.ff_list_buttons .ff-el-form-check.ff-el-image-holder',
					'property'  => 'padding',
				]
			]
		];

		$this->controls['photoWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'number',
			'label'     => esc_html__('Photo width', 'bricksultimate'),
			'units' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform label.ff-el-image-input-src',
					'property'  => 'width',
				]
			]
		];

		$this->controls['photoHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'number',
			'label'     => esc_html__('Photo height', 'bricksultimate'),
			'units' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform label.ff-el-image-input-src',
					'property'  => 'height',
				]
			]
		];

		$this->controls['itemTg'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'typography',
			'label'     => esc_html__('Text typography', 'bricksultimate'),
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-group.ff_list_buttons .ff-el-form-check label>span',
					'property'  => 'font',
				]
			]
		];


		$this->controls['itemBG'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricksultimate'),
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-group.ff_list_buttons .ff-el-form-check label>span',
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['gridborder'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-group.ff_list_buttons .ff-el-form-check.ff-el-image-holder',
					'property'  => 'border',
				]
			]
		];

		$this->controls['gridshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-group.ff_list_buttons .ff-el-form-check.ff-el-image-holder',
					'property'  => 'box-shadow',
				]
			]
		];

		$this->controls['selItems'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'separator',
			'label'     => esc_html__('Selected item', 'bricksultimate'),
		];

		$this->controls['itemSelBG'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricksultimate'),
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-group.ff_list_buttons .ff-el-form-check.ff_item_selected label > span',
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['itemSelClr'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-group.ff_list_buttons .ff-el-form-check.ff_item_selected label > span',
					'property'  => 'color',
				]
			]
		];

		$this->controls['borderSelItem'] = [
			'tab' 		=> 'content',
			'group' 	=> $group,
			'type'      => 'border',
			'label'     => esc_html__('Border of selected item', 'bricksultimate'),
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-group.ff_list_buttons .ff-el-form-check.ff-el-image-holder.ff_item_selected',
					'property'  => 'border',
				]
			]
		];
	}
	

	/*****************
	 * Form wrapper
	 ****************/
	public function formWrapperControls() {
		$selector = '.fluentform';

		$this->controls['form_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'width',
				]
			]
		];

		$this->controls['form_mrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'margin',
				]
			]
		];

		$this->controls['form_pad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'padding',
				]
			]
		];

		$this->controls['form_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['form_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'border',
				]
			]
		];

		$this->controls['form_bs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'box-shadow',
				]
			]
		];
	}

	/******************
	 * Labels
	 *****************/
	public function labelControls() {
		$selector = '.fluentform .ff-el-input--label label';

		$this->controls['label_hide'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'select',
			'label'     => esc_html__('Hide labels', 'bricksultimate'),
			'options' 	=> [
				'none' 		=> __('Yes'),
				'inherit'  	=> __('No'),
			],
			'inline' 	=> true,
			'medium' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'display',
					'value' 	=> '%s'
				]
			]
		];

		$this->controls['label_mrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'margin',
				]
			],
			'required' 	=> ['label_hide', '!=', 'none']
		];

		$this->controls['label_pad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'padding',
				]
			],
			'required' 	=> ['label_hide', '!=', 'none']
		];

		$this->controls['label_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'width',
				]
			],
			'required' 	=> ['label_hide', '!=', 'none']
		];

		$this->controls['label_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'background-color',
				]
			],
			'required' 	=> ['label_hide', '!=', 'none']
		];

		$this->controls['labels_tg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'font',
				]
			],
			'required' 	=> ['label_hide', '!=', 'none']
		];



		/******************
		 * Asterisk
		 *****************/
		$this->controls['astrx_clr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'astrx',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".fluentform .ff-el-input--label.ff-el-is-required.asterisk-left label:before",
					'property'  => 'color',
				],
				[
					'selector' 	=> ".fluentform .ff-el-input--label.ff-el-is-required.asterisk-right label:after",
					'property'  => 'color',
				]
			]
		];

		$this->controls['astrx_gap_left'] = [
			'tab' 		=> 'content',
			'group' 	=> 'astrx',
			'type'      => 'number',
			'label'     => esc_html__('Gap left', 'bricksultimate'),
			'info' 		=> __( 'Set the value when asterisk is placed at right side of label.', 'bricksultimate' ),
			'units' 	=> true,
			'min'		=> 0,
			'max'  		=> 100,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff-el-input--label.ff-el-is-required.asterisk-right label:after',
					'property'  => 'margin-left',
				]
			]
		];


		$this->controls['astrx_gap_right'] = [
			'tab' 		=> 'content',
			'group' 	=> 'astrx',
			'type'      => 'number',
			'label'     => esc_html__('Gap right', 'bricksultimate'),
			'info' 		=> __( 'Set the value when asterisk is placed at left side of label.', 'bricksultimate' ),
			'units' 	=> true,
			'min'		=> 0,
			'max'  		=> 100,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff-el-input--label.ff-el-is-required.asterisk-right label:after',
					'property'  => 'margin-right',
				]
			]
		];

		$this->controls['astrx_size'] = [
			'tab'        => 'content',
			'group' 	=> 'astrx',
			'label'      => esc_html__( 'Size', 'bricks' ),
			'type'       => 'number',
			'units'      => true,
			'css'        => [
				[
					'selector' 	=> '.ff-el-input--label.ff-el-is-required.asterisk-left label:before',
					'property' 	=> 'font-size',
				],
				[
					'selector' 	=> '.ff-el-input--label.ff-el-is-required.asterisk-right label:after',
					'property' 	=> 'font-size',
				],
			],
			'placeholder' => '10px'
		];
	}

	/******************
	 * Input fields
	 *****************/
	public function inputFieldControls() {
		$selector = '.ff-el-form-control';

		$this->controls['h_gap'] = [
			'group' 	=> 'ff_inp',
			'type'      => 'number',
			'label'     => esc_html__('Column Gap', 'bricksultimate'),
			'units' 	=> true,
			'min'		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.frm-fluent-form .ff-t-cell',
					'property'  => 'padding-left',
				],
				[
					'selector' 	=> '.frm-fluent-form .ff-t-cell',
					'property' 	=> 'padding-right',
				],
			]
		];

		$this->controls['v_gap'] = [
			'group' 	=> 'ff_inp',
			'type'      => 'number',
			'label'     => esc_html__('Row Gap', 'bricksultimate'),
			'units' 	=> true,
			'min'		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-group',
					'property'  => 'margin-bottom',
				]
			]
		];

		$this->controls['inp_height'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'label' 	=> esc_html__( 'Height', 'bricks' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'height',
				],
			],
			'placeholder' => '40px',
			'default' 	=> 'auto'
		];

		$this->controls['inp_pad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'padding',
				]
			]
		];

		$this->controls['inp_sep_open'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'separator',
			'label' 	=> esc_html__( 'Textarea', 'bricks' ),
		];

		$this->controls['inpta_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff-el-group textarea' . $selector,
					'property' 	=> 'width',
					'value' 	=> '%s',
					'important' => true
				],
			],
			'placeholder' => '100%'
		];

		$this->controls['inpta_height'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Height', 'bricks' ),
			'min' 		=> 0,
			'step' 		=> 1,
			'units' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff-el-group textarea' . $selector,
					'property' 	=> 'height',
				],
			],
			'placeholder' => '200px'
		];

		$this->controls['inp_sep_close'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'separator'
		];

		$this->controls['inp_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['inp_tg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'font',
				]
			]
		];

		$this->controls['placeholder_color'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'typography',
			'label'     => esc_html__('Placeholder', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "::placeholder",
					'property'  => 'font',
				]
			]
		];

		$this->controls['inp_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'border',
				]
			]
		];

		$this->controls['inp_bs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'box-shadow',
				]
			]
		];

		$this->controls['inp_fsep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'separator',
			'label'     => esc_html__('Focus', 'bricks'),
		];

		$this->controls['inp_fbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['inp_fclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'color',
			'label'     => esc_html__('Text Color', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'color',
				]
			]
		];

		$this->controls['inp_fbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'border',
				]
			]
		];

		$this->controls['inp_fbs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_inp',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'box-shadow',
				]
			]
		];

	}

	/*****************************
	 * Submit button
	 *****************************/
	public function submitControls() {
		$selector = '.ff-btn-submit';
		$this->controls['sub_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sub',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricksultimate'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['sub_sp_sep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sub',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type'  	=> 'separator',
		];

		//margin field
		$this->controls['sub_mrg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sub',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['sub_pad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sub',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['sub_sp_sep_close'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sub',
			'type'  	=> 'separator',
		];

		$this->controls['sub_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sub',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sub_font'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sub',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['sub_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sub',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['sub_shadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sub',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['sub_hover_sep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sub',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover State', 'bricksultimate'),
		];

		$this->controls['sub_hbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sub',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sub_hclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sub',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['sub_hbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sub',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['sub_hshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sub',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];
	}

	/**************************
	 * Checkbox & radio
	 *************************/
	public function checkboxControls() {
		$this->controls['cbr_lbltg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'typography',
			'label' 	=> esc_html__( 'Label Typography', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.ff-el-form-check-label',
				],
				[
					'property' => 'font',
					'selector' => '.ff_t_c',
				],
				[
					'property' => 'font',
					'selector' => '.ff-el-tc',
				]
			],
			'small' 	=> true,
			'inline' 	=> true
		];

		$this->controls['cbr_linkclr'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Link Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => '.ff_t_c a',
				],
				[
					'property' => 'color',
					'selector' => '.ff-el-tc a',
				]
			],
			'small' 	=> true,
			'inline' 	=> true
		];

		$this->controls['cbr_linkhclr'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Link Hover Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => '.ff_t_c a:hover',
				],
				[
					'property' => 'color',
					'selector' => '.ff-el-tc a:hover',
				]
			],
			'small' 	=> true,
			'inline' 	=> true
		];

		$this->controls['cbr_sui'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'separator',
			'label' 	=> esc_html__( 'Smart Settings UI', 'bricksultimate' ),
		];

		$this->controls['cbr_sui_enable'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'select',
			'label' 	=> esc_html__( 'Enable Smart UI', 'bricksultimate' ),
			'default' 	=> 'no',
			'placeholder' => 'no',
			'options'   => [
				'yes' 	=> 'Yes',
				'no' 	=> 'No',
			],
			'inline' 	=> true
		];

		$cb_selector = '.ff-el-group input[type=checkbox]:after';
		$rd_selector = '.ff-el-group input[type=radio]:after';

		$this->controls['cbr_sui_size'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' 	=> '15px',
			'units' 	=> true,
			'medium' 	=> true,
			'inline' 	=> true,
			'required' 	=> ['cbr_sui_enable', '=', 'yes'],
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $cb_selector,
				],
				[
					'property' => 'height',
					'selector' => $cb_selector,
				],
				[
					'property' => 'width',
					'selector' => $rd_selector,
				],
				[
					'property' => 'height',
					'selector' => $rd_selector,
				]
			],
		];

		$this->controls['cbr_sui_bg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $cb_selector,
				],
				[
					'property' => 'background-color',
					'selector' => $rd_selector,
				]
			],
			'small' 	=> true,
			'inline' 	=> true,
			'required' 	=> ['cbr_sui_enable', '=', 'yes'],
		];

		$this->controls['cbr_sui_brdc'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Border Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => $cb_selector,
				],
				[
					'property' => 'border-color',
					'selector' => $rd_selector,
				]
			],
			'small' 	=> true,
			'inline' 	=> true,
			'required' 	=> ['cbr_sui_enable', '=', 'yes'],
		];

		$this->controls['cbr_sui_brdw'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Border Width', 'bricksultimate' ),
			'placeholder' 	=> '1px',
			'units' 	=> true,
			'medium' 	=> true,
			'inline' 	=> true,
			'required' 	=> ['cbr_sui_enable', '=', 'yes'],
			'css'   	=> [
				[
					'property' => 'border-width',
					'selector' => $cb_selector,
				],
				[
					'property' => 'border-width',
					'selector' => $rd_selector,
				]
			],
		];

		$this->controls['cbr_sui_brdrd'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Border Radius for Checkbox', 'bricksultimate' ),
			'placeholder' 	=> '3px',
			'units' 	=> true,
			'medium' 	=> true,
			'inline' 	=> true,
			'required' 	=> ['cbr_sui_enable', '=', 'yes'],
			'css'   	=> [
				[
					'property' => 'border-radius',
					'selector' => ".ff-el-group input[type=checkbox]:after",
				],
				[
					'property' => 'border-radius',
					'selector' => ".ff-el-group input[type=checkbox]:checked:after",
				]
			],
		];

		$cbc_checked = '.fluentform .ff-el-group input[type=checkbox]:checked:after';
		$rdc_checked = '.fluentform .ff-el-group input[type=radio]:checked:after';
		$this->controls['cbr_sui_cbg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color(Checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $cbc_checked,
				],
				[
					'property' => 'background-color',
					'selector' => $rdc_checked,
				]
			],
			'small' 	=> true,
			'inline' 	=> true,
			'required' 	=> ['cbr_sui_enable', '=', 'yes'],
		];

		$this->controls['cbr_sui_cbrdc'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Border Color(Checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border-color',
					'selector' => $cbc_checked,
				],
				[
					'property' => 'border-color',
					'selector' => $rdc_checked,
				]
			],
			'small' 	=> true,
			'inline' 	=> true,
			'required' 	=> ['cbr_sui_enable', '=', 'yes'],
		];

		$this->controls['cbr_sui_wcbsz'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'White Check Mark Size', 'bricksultimate' ),
			'placeholder' 	=> '9px',
			'min' 		=> 9,
			'max' 		=> 30,
			'step' 		=> 1,
			'units' 	=> true,
			'medium' 	=> true,
			'inline' 	=> true,
			'required' 	=> ['cbr_sui_enable', '=', 'yes'],
			'css'   	=> [
				[
					'property' => 'background-size',
					'selector' => ".fluentform .ff-el-group input[type=checkbox]:after",
				]
			],
		];

		$this->controls['cbr_sui_wrdsz'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'White Bullet Size (radio button)', 'bricksultimate' ),
			'placeholder' 	=> '9px',
			'min' 		=> 9,
			'max' 		=> 30,
			'step' 		=> 1,
			'units' 	=> true,
			'medium' 	=> true,
			'inline' 	=> true,
			'required' 	=> ['cbr_sui_enable', '=', 'yes'],
			'css'   	=> [
				[
					'property' => 'background-size',
					'selector' => ".fluentform .ff-el-group input[type=radio]:after",
				]
			],
		];

		$this->controls['cbr_sep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'type'  	=> 'separator',
			'label' 	=> esc_html__( 'Spacing', 'bricksultimate' ),
		];

		$this->controls['cbr_mrg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'label' 	=> esc_html__( 'Checkbox/Radio Button', 'bricksultimate' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.fluentform input[type=checkbox]',
				],
				[
					'property' => 'margin',
					'selector' => '.ff-el-group input[type=radio]',
				]
			],
		];

		$this->controls['cbr_lblsp'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cbr',
			'label' 	=> esc_html__( 'Label (GDPR and T&C)', 'bricksultimate' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => '.ff_t_c'
				]
			],
		];
	}

	/*****************************
	 * Checkable Grid Field
	 *****************************/
	public function cbgControls() {
		$this->controls['cg_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_cgrid',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricksultimate'),
			'units' 	=> true,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> ".fluentform .ff-checkable-grids",
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['cg_thpad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cgrid',
			'label' 	=> esc_html__( 'Table Head Cell Padding', 'bricksultimate' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => ".fluentform .ff-checkable-grids thead>tr>th"
				]
			],
		];

		$this->controls['cg_tdpad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_cgrid',
			'label' 	=> esc_html__( 'Table Body Cell Padding', 'bricksultimate' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => ".fluentform .ff-checkable-grids tbody>tr>td"
				]
			],
		];
		
		$this->controls['hd_tg'] = [
			'tab'      => 'content',
			'group' 	=> 'ff_cgrid',
			'label'    => esc_html__( 'Heading Typography', 'bricksultimate' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => ".fluentform .ff-checkable-grids thead>tr>th"
				],
			]
		];

		$this->controls['cell_tg'] = [
			'tab'      => 'content',
			'group' 	=> 'ff_cgrid',
			'label'    => esc_html__( 'Cell Typography', 'bricksultimate' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => ".fluentform .ff-checkable-grids tbody>tr>td"
				],
			]
		];

		$this->controls['cg_tbl_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_cgrid',
			'type'      => 'border',
			'label'     => esc_html__('Table Border', 'bricksultimate'),
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-checkable-grids',
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['cg_hdbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_cgrid',
			'type'      => 'color',
			'label'     => esc_html__('Table Header Background color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-checkable-grids thead>tr>th',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['cg_bdybg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_cgrid',
			'type'      => 'color',
			'label'     => esc_html__('Table Body Background color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-checkable-grids tbody>tr>td',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['cg_bdyaltbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_cgrid',
			'type'      => 'color',
			'label'     => esc_html__('Table Body Alt Background color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-checkable-grids tbody>tr:nth-child(2n)>td',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['cg_bdyaltclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_cgrid',
			'type'      => 'color',
			'label'     => esc_html__('Table Body Alt Text color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-checkable-grids tbody>tr:nth-child(2n)>td',
					'property' 	=> 'color'
				]
			]
		];
	}

	/**********************
	 * Rating Field
	 *********************/
	public function ratingControls() {
		$selector = '.fluentform .ff-el-ratings';
		$this->controls['rating_inactive'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rating',
			'type'      => 'color',
			'label'     => esc_html__('Inactive Stars Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}",
					'property' 	=> '--fill-inactive'
				]
			]
		];

		$this->controls['rating_active'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rating',
			'type'      => 'color',
			'label'     => esc_html__('Active Stars Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}",
					'property' 	=> '--fill-active'
				]
			]
		];

		$this->controls['rating_size'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rating',
			'type'      => 'number',
			'label'     => esc_html__('Stars Size (in pixels)', 'bricksultimate'),
			'unitless' 	=> false,
			'inline' 	=> true,
			'placeholder' => '22',
			'css' 		=> [
				[
					'selector' 	=> "{$selector} svg",
					'property' 	=> 'width',
					'value' 	=> '%spx'
				],
				[
					'selector' 	=> "{$selector} svg",
					'property' 	=> 'height',
					'value' 	=> '%spx'
				]
			]
		];

		$this->controls['rating_stars_gap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rating',
			'type'      => 'number',
			'label'     => esc_html__('Gap between stars', 'bricksultimate'),
			'units' 	=> true,
			'inline' 	=> true,
			'placeholder' => '3px',
			'css' 		=> [
				[
					'selector' 	=> "{$selector} label",
					'property' 	=> 'margin-right',
				]
			]
		];

		$this->controls['rating_stars_text_gap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rating',
			'type'      => 'number',
			'label'     => esc_html__('Gap between stars & text', 'bricksultimate'),
			'units' 	=> true,
			'inline' 	=> true,
			'placeholder' => '5px',
			'css' 		=> [
				[
					'selector' 	=> ".ff-el-rating-text",
					'property' 	=> 'padding-left',
				]
			]
		];

		$this->controls['rating_textg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rating',
			'type'      => 'typography',
			'label'     => esc_html__('Text Typography', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".ff-el-rating-text",
					'property' 	=> 'font',
				]
			]
		];

		$this->controls['rating_text_align'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rating',
			'type'      => 'select',
			'label'     => esc_html__('Text Vertical Align', 'bricksultimate'),
			'placeholder' => 'bottom',
			'inline' 	=> true,
			'medium' 	=> true,
			'options' 	=> [
				'top' 		=> __('Top'),
				'center' 	=> __('Center'),
				'bottom' 	=> __('Bottom'),
			],
			'css' 		=> [
				[
					'selector' 	=> "span.ff-el-rating-text",
					'property' 	=> 'vertical-align',
					'value' 	=> '%s'
				]
			]
		];

	}

	/*****************************
	 * File upload
	 *****************************/
	public function fileUploadControls() {
		$selector = '.ff_upload_btn';
		$this->controls['fbtn_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_file',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricksultimate'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				],
				[
					'selector' 	=> $selector,
					'property' 	=> 'display',
					'value' 	=> 'block'
				]
			]
		];

		$this->controls['fbtn_pad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_file',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['fbtn_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_file',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['fbtn_font'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_file',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['fbtn_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_file',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['fbtn_shadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_file',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}",
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['fbtn_hover_sep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_file',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover State', 'bricksultimate'),
		];

		$this->controls['fbtn_hbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_file',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['fbtn_hclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_file',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['fbtn_hbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_file',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['fbtn_hshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_file',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];

	}

	/****************************
	 * Repeater Field
	 ***************************/
	public function repeaterControls() {
		$rep_selector = '.ff-el-repeater';

		$this->controls['rep_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'inline' 	=> true,
			'medium' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $rep_selector,
					'property' 	=> 'width',
				]
			]
		];

		$this->controls['rep_pad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_rep',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $rep_selector,
				]
			],
		];

		$this->controls['rep_hgap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'number',
			'label'     => esc_html__('Horizontal Gap between Fields', 'bricksultimate'),
			'units' 	=> true,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '15px',
			'css' 		=> [
				[
					'selector' 	=> "table.ff_repeater_table td",
					'property' 	=> 'padding-right',
				]
			]
		];

		$this->controls['rep_vgap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'number',
			'label'     => esc_html__('Vertical Gap between Fields', 'bricksultimate'),
			'units' 	=> true,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '15px',
			'css' 		=> [
				[
					'selector' 	=> "table.ff_repeater_table td",
					'property' 	=> 'padding-bottom',
				]
			]
		];

		$this->controls['rep_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $rep_selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['rep_brd'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_rep',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'type'  	=> 'border',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $rep_selector,
				]
			],
		];

		$this->controls['rep_bs'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_rep',
			'label' 	=> esc_html__( 'Box shadow', 'bricks' ),
			'type'  	=> 'box-shadow',
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $rep_selector,
				]
			],
		];

		$this->controls['rep_septg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_rep',
			'type'  	=> 'separator',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
		];

		$this->controls['rep_labeltg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_rep',
			'label' 	=> esc_html__( 'Field label', 'bricks' ),
			'type'  	=> 'typography',
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $rep_selector . ' .ff-el-input--label label'
				]
			],
		];

		$this->controls['rep_coltg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_rep',
			'type'  	=> 'typography',
			'label' 	=> esc_html__( 'Column Label', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => '.ff_repeater_table th .ff-el-input--label label',
				]
			],
		];

		$this->controls['rep_sep_inp'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_rep',
			'type'  	=> 'separator',
			'label' 	=> esc_html__( 'Input fields', 'bricksultimate' ),
		];

		$this->controls['rep_inp_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff_repeater_table input',
					'property'  => 'background-color',
				],
				[
					'selector' 	=> '.ff_repeater_table select',
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['rep_inp_tg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff_repeater_table input',
					'property'  => 'font',
				],
				[
					'selector' 	=> '.ff_repeater_table select',
					'property'  => 'font',
				]
			]
		];

		$this->controls['rep_inp_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff_repeater_table input',
					'property'  => 'border',
				],
				[
					'selector' 	=> '.ff_repeater_table select',
					'property'  => 'border',
				]
			]
		];

		$this->controls['rep_inp_bs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff_repeater_table input',
					'property'  => 'box-shadow',
				],
				[
					'selector' 	=> '.ff_repeater_table select',
					'property'  => 'box-shadow',
				]
			]
		];

		$this->controls['rep_inp_fsep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'separator',
			'label'     => esc_html__('Focus - Input Fields', 'bricksultimate'),
		];

		$this->controls['rep_inp_fbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff_repeater_table input:focus',
					'property'  => 'background-color',
				],
				[
					'selector' 	=> '.ff_repeater_table select:focus',
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['rep_inp_fclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'color',
			'label'     => esc_html__('Text Color', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff_repeater_table input:focus',
					'property'  => 'color',
				],
				[
					'selector' 	=> '.ff_repeater_table select:focus',
					'property'  => 'color',
				]
			]
		];

		$this->controls['rep_inp_fbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff_repeater_table input:focus',
					'property'  => 'border',
				],
				[
					'selector' 	=> '.ff_repeater_table select:focus',
					'property'  => 'border',
				]
			]
		];

		$this->controls['rep_inp_fbs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff_repeater_table input:focus',
					'property'  => 'box-shadow',
				],
				[
					'selector' 	=> '.ff_repeater_table select:focus',
					'property'  => 'box-shadow',
				]
			]
		];

		$this->controls['rep_sep_pm'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_rep',
			'type'  	=> 'separator',
			'label' 	=> esc_html__( 'Plus/Minus circle', 'bricksultimate' ),
		];

		$this->controls['rep_pmsize'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'number',
			'label'     => esc_html__('Size', 'bricks'),
			'units' 	=> true,
			'min' 		=> 20,
			'max' 		=> 50,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.repeat-plus svg',
					'property' 	=> 'width',
				],
				[
					'selector' 	=> '.repeat-plus svg',
					'property' 	=> 'height',
				],
				[
					'selector' 	=> '.repeat-minus svg',
					'property' 	=> 'width',
				],
				[
					'selector' 	=> '.repeat-minus svg',
					'property' 	=> 'height',
				]
			]
		];

		$this->controls['rep_pc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'color',
			'label'     => esc_html__('Plus Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.repeat-plus svg',
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['rep_phc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'color',
			'label'     => esc_html__('Plus Hover color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.repeat-plus:hover svg',
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['rep_mc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'color',
			'label'     => esc_html__('Minus color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.repeat-minus svg',
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['rep_mhc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_rep',
			'type'      => 'color',
			'label'     => esc_html__('Minus Hover color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.repeat-minus:hover svg',
					'property' 	=> 'color'
				]
			]
		];

	}

	/****************************
	 * Net Promoter Score
	 ***************************/
	public function npscoreControls() {
		$nps_selector = '.ff_net_table';
		$npscell_selector = '.ff_net_table tbody tr td';

		$this->controls['nps_tlc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'color',
			'label'     => esc_html__('Sub Label color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $nps_selector . ' thead th span',
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['nps_tbgc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'color',
			'label'     => esc_html__('Cell Background color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $npscell_selector,
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['nps_brdc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'color',
			'label'     => esc_html__('Border color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $npscell_selector,
					'property' 	=> 'border-color',
				],
				[
					'selector' 	=> $npscell_selector . ':first-of-type',
					'property' 	=> 'border-color',
				]
			]
		];

		$this->controls['nps_brdw'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'number',
			'label'     => esc_html__('Border width', 'bricksultimate'),
			'units' 	=> true,
			'inline' 	=> true,
			'medium' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $npscell_selector,
					'property' 	=> 'border-width',
				],
				[
					'selector' 	=> $npscell_selector . ':first-of-type',
					'property' 	=> 'border-width',
				]
			]
		];

		$this->controls['nps_sep1'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type' 		=> 'separator'
		];

		$this->controls['nps_hbgc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'color',
			'label'     => esc_html__('Hover Background color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $npscell_selector . ' label:hover:after',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['nps_hbrdc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'color',
			'label'     => esc_html__('Hover Border color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $npscell_selector . ' label:hover:after',
					'property' 	=> 'border-color',
				]
			]
		];

		$this->controls['nps_hbrdw'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'number',
			'label'     => esc_html__('Hover Border width', 'bricksultimate'),
			'units' 	=> true,
			'inline' 	=> true,
			'medium' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $npscell_selector . ' label:hover:after',
					'property' 	=> 'border-width',
				]
			]
		];

		$this->controls['nps_sep2'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type' 		=> 'separator'
		];

		$this->controls['nps_numc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'color',
			'label'     => esc_html__('Number color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff-el-net-label span',
					'property' 	=> 'color',
				]
			]
		];

		$this->controls['nps_hnumc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'color',
			'label'     => esc_html__('Hover Number color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff-el-net-label:hover span',
					'property' 	=> 'color',
				]
			]
		];

		$this->controls['nps_cnumc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'color',
			'label'     => esc_html__('Checked Number color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $npscell_selector . ' input[type=radio]:checked+label *',
					'property' 	=> 'color',
				]
			]
		];

		$this->controls['nps_cnumbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_nps',
			'type'      => 'color',
			'label'     => esc_html__('Checked Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $npscell_selector . ' input[type=radio]:checked+label',
					'property' 	=> 'background-color',
				]
			]
		];
	}

	/*****************************
	 * Payment Summary
	 *****************************/
	public function paymentControls() {
		$ps_selector = '.ff_dynamic_payment_summary';
		
		$this->controls['ps_sep_table'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'separator',
			'label'     => esc_html__('Table', 'bricks'),
		];

		$this->controls['ps_tblbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$ps_selector} .ffp_table",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['ps_tblbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$ps_selector} .ffp_table",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['ps_sep_th'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'separator',
			'label'     => esc_html__('Table Head', 'bricksultimate'),
		];

		$this->controls['ps_thbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$ps_selector} .ffp_table thead",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['ps_thtg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $ps_selector . ' thead th',
					'property' 	=> 'font'
				]
			]
		];

		$this->controls['ps_thbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "table.input_items_table thead tr th",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['ps_sep_bdy'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'separator',
			'label'     => esc_html__('Table Body', 'bricks'),
		];

		$this->controls['ps_tdbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $ps_selector . ' .ffp_table tbody tr',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['ps_tdaltbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'color',
			'label'     => esc_html__('Alt Background Color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $ps_selector . ' .ffp_table tbody tr:even',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['ps_tdtg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $ps_selector . ' tbody td',
					'property' 	=> 'font'
				]
			]
		];

		$this->controls['ps_tdbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "table.input_items_table tbody tr td",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['ps_sep_tf'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'separator',
			'label'     => esc_html__('Table Footer', 'bricksultimate'),
		];

		$this->controls['ps_tfbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $ps_selector . ' .ffp_table tfoot tr',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['ps_totaltexttg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'typography',
			'label'     => esc_html__('Text Typography', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $ps_selector . ' tfoot th.item_right',
					'property' 	=> 'font'
				]
			]
		];

		$this->controls['ps_pricetg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'typography',
			'label'     => esc_html__('Price Typography', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $ps_selector . ' tfoot th',
					'property' 	=> 'font'
				]
			]
		];

		$this->controls['ps_tfbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_paysum',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> 'table.input_items_table tfoot tr th',
					'property' 	=> 'border'
				]
			]
		];
	}

	/*****************************
	 * Progress bar
	 *****************************/
	public function pbControls() {
		$this->controls['pgb_type'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'select',
			'label'     => esc_html__('Progress Indicator', 'bricksultimate'),
			'options' 	=> [ 
				'pb' 	=> __("Progress Bar", "bricksultimate"), 
				"step" 	=> __("Steps", "bricksultimate"), 
				"none" 	=> __("None", "bricksultimate") 
			],
			'default' 	=> 'pb',
			'inline' 	=> true,
			'medium' 	=> true,
		];

		$this->controls['pgb_lbltg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'typography',
			'label'     => esc_html__('Label Typography', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.ff-el-progress-status',
					'property' 	=> 'font'
				]
			],
			'required' 	=> ['pgb_type', '=', 'pb']
		];

		$this->controls['pgb_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'color',
			'label'     => esc_html__('Progress bar color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-progress',
					'property' 	=> 'background-color'
				]
			],
			'required' 	=> ['pgb_type', '=', 'pb']
		];

		$this->controls['pgb_abg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'color',
			'label'     => esc_html__('Progress bar active color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-progress-bar',
					'property' 	=> 'background-color'
				]
			],
			'required' 	=> ['pgb_type', '=', 'pb']
		];

		$this->controls['pgb_h'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'number',
			'label'     => esc_html__('Progress bar height', 'bricksultimate'),
			'inline' 	=> true,
			'medium' 	=> true,
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'placeholder' => '4px',
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-progress',
					'property' 	=> 'height'
				]
			],
			'required' 	=> ['pgb_type', '=', 'pb']
		];

		$this->controls['pgb_ovrf'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'select',
			'label'     => esc_html__('Overflow', 'bricksultimate'),
			'options' 	=> [ 
				'visible' 	=> __("Visible", "bricksultimate"), 
				"hidden" 	=> __("Hidden", "bricksultimate")
			],
			'default' 	=> 'hidden',
			'inline' 	=> true,
			'medium' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-progress',
					'property' 	=> 'overflow',
					'value' 	=> '%s'
				]
			],
			'required' 	=> ['pgb_type', '=', 'pb']
		];

		$this->controls['pgb_spost'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'number',
			'label'     => esc_html__('Score position top', 'bricksultimate'),
			'inline' 	=> true,
			'medium' 	=> true,
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-progress span',
					'property' 	=> 'top'
				]
			],
			'required' 	=> ['pgb_type', '=', 'pb']
		];

		$this->controls['pgb_sposl'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'number',
			'label'     => esc_html__('Score position left', 'bricksultimate'),
			'inline' 	=> true,
			'medium' 	=> true,
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-progress span',
					'property' 	=> 'left'
				]
			],
			'required' 	=> ['pgb_type', '=', 'pb']
		];

		$this->controls['pgb_sctg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'typography',
			'label'     => esc_html__('Score typography', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-el-progress span',
					'property' 	=> 'font'
				]
			],
			'required' 	=> ['pgb_type', '=', 'pb']
		];

		$this->controls['pgb_numtg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'typography',
			'label'     => esc_html__('Number typography', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-step-titles li:not(.ff_active):before',
					'property' 	=> 'font'
				]
			],
			'required' 	=> ['pgb_type', '=', 'step']
		];

		$this->controls['pgb_numac'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'color',
			'label'     => esc_html__('Active number color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-step-titles li.ff_active:before',
					'property' 	=> 'color'
				],
				[
					'selector' 	=> '.fluentform .ff-step-titles li.ff_completed:before',
					'property' 	=> 'color'
				]
			],
			'required' 	=> ['pgb_type', '=', 'step']
		];

		$this->controls['pgb_lbltg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'typography',
			'label'     => esc_html__('Label typography', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-step-titles li',
					'property' 	=> 'font'
				]
			],
			'required' 	=> ['pgb_type', '=', 'step']
		];

		$this->controls['pgb_labelac'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'color',
			'label'     => esc_html__('Active label color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-step-titles li.ff_completed',
					'property' 	=> 'color'
				],
				[
					'selector' 	=> '.fluentform .ff-step-titles li.ff_active',
					'property' 	=> 'color'
				]
			],
			'required' 	=> ['pgb_type', '=', 'step']
		];

		$this->controls['pgb_boxw'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'number',
			'label'     => esc_html__('Box size', 'bricksultimate'),
			'inline' 	=> true,
			'medium' 	=> true,
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-step-titles li:before',
					'property' 	=> 'width'
				],
				[
					'selector' 	=> '.fluentform .ff-step-titles li:before',
					'property' 	=> 'height'
				]
			],
			'required' 	=> ['pgb_type', '=', 'step']
		];

		$this->controls['pgb_boxbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'color',
			'label'     => esc_html__('Background color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=>'.fluentform .ff-step-titles li:not(.ff_active):before',
					'property' 	=> 'background-color'
				]
			],
			'required' 	=> ['pgb_type', '=', 'step']
		];

		$this->controls['pgb_boxbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.fluentform .ff-step-titles li:before',
					'property' 	=> 'border'
				]
			],
			'required' 	=> ['pgb_type', '=', 'step']
		];

		$this->controls['pgb_abox'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_pgb',
			'type'      => 'color',
			'label'     => esc_html__('Active box color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=>'.fluentform .ff-step-titles li.ff_active:before',
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=>'.fluentform .ff-step-titles li.ff_active:before',
					'property' 	=> 'border-color'
				],
				[
					'selector' 	=>'.fluentform .ff-step-titles li.ff_completed:before',
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=>'.fluentform .ff-step-titles li.ff_completed:before',
					'property' 	=> 'border-color'
				]
			],
			'required' 	=> ['pgb_type', '=', 'step']
		];


		/*****************************
		 * Form Step Buttons
		 *****************************/
		$selector = '.ff-btn-secondary';
		$this->controls['sbtn_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sbtn',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricksultimate'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['sbtn_sep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sbtn',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type'  	=> 'separator',
		];

		//margin field
		$this->controls['sbtn_mrg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sbtn',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['sbtn_pad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sbtn',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['sbtn_sep_close'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sbtn',
			'type'  	=> 'separator',
		];

		$this->controls['sbtn_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sbtn',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sbtn_font'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sbtn',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['sbtn_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sbtn',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['sbtn_shadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sbtn',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['sbtn_hover_sep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sbtn',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover State', 'bricksultimate'),
		];

		$this->controls['sbtn_hbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sbtn',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sbtn_hclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sbtn',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['sbtn_hbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sbtn',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['sbtn_hshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sbtn',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];
	}

	/*****************************
	 * Section Break
	 *****************************/
	public function sectionBreakControls() {
		$selector = '.ff-el-section-break';

		$this->controls['secb_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sec',
			'type'      => 'color',
			'label'     => esc_html__('Background color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['secb_line_color'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sec',
			'type'      => 'color',
			'label'     => esc_html__('Line color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector} hr",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['secb_linew'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sec',
			'type'      => 'number',
			'label'     => esc_html__('Line height', 'bricksultimate'),
			'inline' 	=> true,
			'medium' 	=> true,
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'placeholder' => '1px',
			'css' 		=> [
				[
					'selector' 	=> "{$selector} hr",
					'property' 	=> 'height'
				]
			]
		];

		//margin field
		$this->controls['secb_mrg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sec',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['secb_pad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'ff_sec',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['secb_ttltg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sec',
			'type'      => 'typography',
			'label'     => esc_html__('Title', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".ff-el-section-title",
					'property' 	=> 'font'
				]
			]
		];

		$this->controls['secb_desctg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_sec',
			'type'      => 'typography',
			'label'     => esc_html__('Description', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".ff-section_break_desk",
					'property' 	=> 'font'
				]
			]
		];

	}

	/*****************************
	 * Validation Error
	 *****************************/
	public function validationControls(){
		$this->controls['inp_err_bc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_validation',
			'type'      => 'color',
			'label'     => esc_html__('Input fields border color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".ff-el-is-error .ff-el-form-control",
					'property' 	=> 'border-color'
				]
			]
		];

		$this->controls['val_err_tg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_validation',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".ff-el-is-error .text-danger",
					'property' 	=> 'font'
				]
			]
		];

		$this->controls['val_err_mt'] = [
			'tab' 		=> 'content',
			'group' 	=> 'ff_validation',
			'type'      => 'number',
			'label'     => esc_html__('Margin top', 'bricks'),
			'units' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".ff-el-is-error .text-danger",
					'property' 	=> 'margin-top'
				]
			]
		];
	}

	/*****************************
	 * Success Message
	 *****************************/
	public function successControls(){
		$selector = '.ff-message-success';

		$this->controls['suc_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'suc_msg',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		//margin field
		$this->controls['suc_mrg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'suc_msg',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['suc_pad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'suc_msg',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['suc_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'suc_msg',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['suc_tg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'suc_msg',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}",
					'property' 	=> 'font'
				]
			]
		];

		$this->controls['suc_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'suc_msg',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['suc_shadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'suc_msg',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}",
					'property' 	=> 'box-shadow'
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		if ( function_exists( 'wpFluentForm' ) && bricks_is_builder_iframe() ) {
			$app = wpFluentForm();

			wp_enqueue_style(
				'fluent-form-styles',
				$app->publicUrl('css/fluent-forms-public.css'),
				array(),
				FLUENTFORM_VERSION
			);

			wp_enqueue_style(
				'fluentform-public-default',
				$app->publicUrl('css/fluentform-public-default.css'),
				array(),
				FLUENTFORM_VERSION
			);

			if ( ! wp_script_is('flatpickr', 'registered')) {
				wp_enqueue_style(
					'flatpickr',
					$app->publicUrl('libs/flatpickr/flatpickr.min.css')
				);
			}

			wp_enqueue_style(
				'ff_choices',
				$app->publicUrl('css/choices.css'),
				[],
				FLUENTFORM_VERSION
			);

			wp_enqueue_script(
				'fluent-form-submission',
				fluentFormMix('js/form-submission.js'),
				['jquery'],
				FLUENTFORM_VERSION,
				true
			);

			wp_enqueue_script(
				'fluentform-advanced',
				fluentFormMix('js/fluentform-advanced.js'),
				['jquery'],
				FLUENTFORM_VERSION,
				true
			);

			wp_enqueue_script( 'bu-ff-script', Helpers::get_asset_url('js') . 'ffScript.min.js', [], filemtime(Helpers::get_asset_path('js') . 'ffScript.min.js'), 'all' );
        }

        //wp_enqueue_style( 'bu-ff-style', Helpers::get_asset_url('css') . 'fluentform.min.css', [], filemtime(Helpers::get_asset_path('css') . 'fluentform.min.css'), 'all' );
	}

	//* get form id
	public function getDynamicFormID() {
		$term = get_queried_object();
		$formId = false;

		if( ! empty( $this->settings['ff_id'] ) ) {
			if ( $term && ! empty( $term->term_id ) ) {
				$formId = get_term_meta( $term->term_id, Helpers::get_value( $this->settings, 'ff_id'), true );
				return $formId;
			}
			
			$formId = get_post_meta( $this->post_id, Helpers::get_value( $this->settings, 'ff_id'), true );
		} else {
			$formId = strstr( $this->settings['ffDynamicTag'], '{') ? $this->render_dynamic_data_tag( $this->settings['ffDynamicTag'], 'text' ) : $this->settings['ffDynamicTag'];
		}
		
		return $formId;
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$cb_smart_ui = Helpers::get_value( $settings, 'cbr_sui_enable', 'no' );
		if( $cb_smart_ui && $cb_smart_ui == 'yes' ) {
			$this->set_attribute( '_root', 'class', 'bu-ff-cbui' );
		}

		$source = Helpers::get_value( $settings, 'source_type', 'static');
		$ff_id = ( $source == 'static' ) ? Helpers::get_value( $settings, 'ff_form', 'none') : $this->getDynamicFormID();

		if( $ff_id == 'none' ) {
			return $this->render_element_placeholder( ['title' => esc_html__( 'Select a form.', 'bricksultimate' )] );
		} elseif( empty( $ff_id ) || $ff_id === false || is_array( $ff_id ) ) {
			return $this->render_element_placeholder( ['title' => esc_html__( 'Enter custom field name.', 'bricksultimate' )] );
		} else {
			echo "<{$this->tag} {$this->render_attributes('_root')}>";
			echo do_shortcode("[fluentform id=\"{$ff_id}\"]");
			echo "</{$this->tag}>";
		}
	}
}