<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class GridTwo extends \Bricks\Element_Container {
	public $category 		= 'css-grid';
	public $name 			= 'bucg-col-2';
	public $icon 			= 'ti-layout-grid2';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( '2 Columns', 'bricksultimate' );
	}

	public function set_controls() {
		parent::set_controls();

		$this->controls['_display']['default'] = 'grid';
		$this->controls['_gridGap']['default'] = 5;
		$this->controls['_gridTemplateColumns']['default'] = 'repeat(2, 1fr)';
		$this->controls['_gridTemplateColumns:mobile_landscape']['default'] = 'repeat(1, 1fr)';
		$this->controls['_width']['default'] = '100%';
	}

	public function get_nestable_children() {
		return [
				[
					'name' => 'block',
					'label' => esc_html__( 'Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('Column', 'bricksultimate' ),
				]
			];
	}
}