<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class HighlightedHeading extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-hightlighted-heading';
	public $icon 			= 'ti-uppercase';
	public $tag 			= 'h3';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Highlighted Heading', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['tag'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Tag', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'h1' 	=> 'h1',
				'h2' 	=> 'h2',
				'h3' 	=> 'h3',
				'h4' 	=> 'h4',
				'h5' 	=> 'h5',
				'h6' 	=> 'h6',
				'div' 	=> 'div',
				'p' 	=> 'p',
			],
			'inline'    => true,
			'clearable' => false,
			'default'   => 'h3',
		];

		//* Shape Options
		$this->controls['textContent'] = [
			'tab' 		=> 'content',
			"type" 		=> 'separator',
			"label" 	=> __('Text', "bricks")
		];

		$this->controls['text_before'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__('Before Text', 'bricksultimate'),
			'info'   	=> __("This text will be placed before the highlighted text.", "bricksultimate"),
		];

		$this->controls['highlighted_text'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__('Highlighted Text', 'bricksultimate'),
			"default" 	=> esc_html__("Highlighted", "bricksultimate"),
		];

		$this->controls['text_after'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__('After Text', 'bricksultimate'),
			'info'   	=> __("This text will be placed after the highlighted text.", "bricksultimate"),
		];

		//* Shape Options
		$this->controls['shapeSettings'] = [
			'tab' 		=> 'content',
			"type" 		=> 'separator',
			"label" 	=> __('Shape Options', "bricksultimate")
		];

		$this->controls['shape'] = [
			'tab' 		=> 'content',
			"type" 		=> 'select',
			"label" 	=> __('Shape', "bricksultimate"),
			"options" 	=> [
				'circle'			=> __('Circle', 'bricksultimate'),
				'curly'				=> __('Curly', 'bricksultimate'),
				'diagonal'			=> __('Diagonal', 'bricksultimate'),
				'double'			=> __('Double Underline', 'bricksultimate'),
				'doubleub'			=> __('Double Underline Bottom', 'bricksultimate'),
				'strikethrough'		=> __('Strikethrough', 'bricksultimate'),
				'underline'			=> __('Underline', 'bricksultimate'),
				'underline_zigzag'	=> __('Underline Zigzag', 'bricksultimate'),
				'underline_lr' 		=> __('Underline-Left to Right', 'bricksultimate'),
				'underline_rl' 		=> __('Underline-Right to Left', 'bricksultimate'),
				'underline_outwards'=> __('Underline-Outwards', 'bricksultimate'),
				'underline_inwards'	=> __('Underline-Inwards', 'bricksultimate'),
			],
			"default" 	=> 'circle',
		];

		$this->controls['shape_loop'] = [
			'tab' 		=> 'content',
			"type" 		=> 'select',
			"label" 	=> __('Loop', "bricksultimate"),
			"options" 	=> [
				'lopp'		=> __('Yes', 'bricks'),
				'noloop'	=> __('No', 'bricks'),
			],
			"default" 	=> 'loop',
			"inline" 	=> true,
			"medium" 	=> true,
			'required' 	=> ['shape', '!=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];

		$this->controls['anim_onscroll'] = [
			'tab' 		=> 'content',
			"type" 		=> 'select',
			"label" 	=> __('Start Animation After Scroll', "bricksultimate"),
			"options" 	=> [
				'yes' 		=> __('Yes', 'bricks'),
				'no' 		=> __('No', 'bricks'),
			],
			"default" 	=> 'no',
			"inline" 	=> true,
			"medium" 	=> true,
			'info' 		=> __("Enable it when you are adding the Animated Heading below the fold. Preview will not show on builder editor.", "bricksultimate"),
			'required' 	=> ['shape', '!=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];

		/*$this->controls['onscroll_offset'] = [
			'tab' 		=> 'content',
			"type" 		=> 'number',
			"label" 	=> __('Offset(%)', "bricksultimate"),
			"unit" 		=> '%',
			"min" 		=> 0,
			'max' 		=> 100,
			'step' 		=> 1,
			"default" 	=> '65%',
			"inline" 	=> true,
			"medium" 	=> true,
			'required' 	=> ['shape', '!=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];*/

		$this->controls['shape_color'] = [
			'tab' 		=> 'content',
			"type" 		=> 'color',
			"label" 	=> __('Shape Color', "bricksultimate"),
			'css'   => [
				[
					'selector' => ".highlighted-text-wrapper svg path",
					'property' => 'stroke',
				],
			],
			'required' 	=> ['shape', '!=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];

		$this->controls['shape_width'] = [
			'tab' 		=> 'content',
			"type" 		=> 'number',
			"label" 	=> __('Shape Width', "bricksultimate"),
			"default" 	=> 9,
			'min' 		=> 2,
			'max' 		=> 100,
			'step'		=> 1,
			'unitless' 	=> true,
			'inline' 	=> true,
			'css'   	=> [
				[
					'selector' => ".highlighted-text-wrapper svg path",
					'property' => 'stroke-width',
				],
			],
			'required' 	=> ['shape', '!=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];

		$this->controls['hlh_td'] = [
			'tab' 		=> 'content',
			"type" 		=> 'number',
			"label" 	=> __('Transition Duration(sec)', "bricksultimate"),
			"default" 	=> 10,
			'min' 		=> 0,
			'max' 		=> 50,
			'step'		=> 1,
			'unit' 		=> 's',
			'inline' 	=> true,
			'css'   	=> [
				[
					'selector' => "",
					'property' => '--animation-td',
				],
			],
			'required' 	=> ['shape', '!=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];

		$this->controls['hlh_anim_delay'] = [
			'tab' 		=> 'content',
			"type" 		=> 'number',
			"label" 	=> __('Animation Delay(sec)', "bricksultimate"),
			"default" 	=> 0.6,
			'min' 		=> 0,
			'max' 		=> 10,
			'step'		=> 0.1,
			'unit' 		=> 's',
			'inline' 	=> true,
			'css'   	=> [
				[
					'selector' => "",
					'property' => '--animation-delay',
				],
			],
			'required' 	=> ['shape', '!=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];

		$this->controls['shape_appear'] = [
			'tab' 		=> 'content',
			"type" 		=> 'select',
			"label" 	=> __('Appearance', "bricksultimate"),
			"options" 	=> [
				'onhover' 	=> __('Show on Hover', 'bricksultimate'),
				'offhover' 	=> __('Hide on Hover', 'bricksultimate'),
			],
			"default" 	=> 'offhover',
			"inline" 	=> true,
			"medium" 	=> true,
			'info' 		=> __("Enable it when you are adding the Animated Heading below the fold. Preview will not show on builder editor.", "bricksultimate"),
			'required' 	=> ['shape', '=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];

		$this->controls['ul_color'] = [
			'tab' 		=> 'content',
			"type" 		=> 'color',
			"label" 	=> __('Shape Color', "bricksultimate"),
			'css'   => [
				[
					'selector' => ".highlighted-text-content .ul-anim:before",
					'property' => 'background-color',
				],
				[
					'selector' => ".highlighted-text-content .ul-anim:after",
					'property' => 'background-color',
				],
			],
			'required' 	=> ['shape', '=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];

		$this->controls['ul_width'] = [
			'tab' 		=> 'content',
			"type" 		=> 'number',
			"label" 	=> __('Shape Width', "bricksultimate"),
			"default" 	=> 5,
			'min' 		=> 2,
			'max' 		=> 100,
			'step'		=> 1,
			'units' 	=> true,
			'inline' 	=> true,
			'css'   	=> [
				[
					'selector' => ".highlighted-text-content .ul-anim:before",
					'property' => 'height',
				],
				[
					'selector' => ".highlighted-text-content .ul-anim:after",
					'property' => 'height',
				],
			],
			'required' 	=> ['shape', '=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];

		$this->controls['ul_position'] = [
			'tab' 		=> 'content',
			"type" 		=> 'number',
			"label" 	=> __('Position in pixels', "bricksultimate"),
			"default" 	=> -10,
			'min' 		=> -20,
			'max' 		=> 20,
			'step'		=> 1,
			'unit' 		=> 'px',
			'inline' 	=> true,
			'css'   	=> [
				[
					'selector' => ".highlighted-text-content .ul-anim:before",
					'property' => 'bottom',
				],
				[
					'selector' => ".highlighted-text-content .ul-anim:after",
					'property' => 'bottom',
				],
			],
			'required' 	=> ['shape', '=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];

		$this->controls['ul_td'] = [
			'tab' 		=> 'content',
			"type" 		=> 'number',
			"label" 	=> __('Transition Duration(sec)', "bricksultimate"),
			"default" 	=> 0.75,
			'min' 		=> 0,
			'max' 		=> 10,
			'step'		=> 0.1,
			'unit' 		=> 's',
			'inline' 	=> true,
			'css'   	=> [
				[
					'selector' => ".highlighted-text-content .ul-anim:before",
					'property' => 'transition-duration',
				],
				[
					'selector' => ".highlighted-text-content .ul-anim:after",
					'property' => 'transition-duration',
				],
			],
			'required' 	=> ['shape', '=', ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards']]
		];


		//* Typography
		$this->controls['text_tg'] = [
			'tab' 		=> 'content',
			"type" 		=> 'separator',
			"label" 	=> __('Typography', "bricks")
		];

		$this->controls['batext_tg'] = [
			'tab' 		=> 'content',
			"type" 		=> 'typography',
			"label" 	=> __('Before & After Text', "bricksultimate"),
			'css'   => [
				[
					'selector' => ".headline-text",
					'property' => 'font',
				],
			],
		];

		$this->controls['hlh_tg'] = [
			'tab' 	=> 'content',
			"type" 	=> 'typography',
			"label" => __('Highlighted Text', "bricksultimate"),
			'css'   => [
				[
					'selector' => ".highlighted-text",
					'property' => 'font',
				],
			],
		];
	}

	public function enqueue_scripts() {
		wp_enqueue_style( 'bu-hightlighted-heading', Helpers::get_asset_url('css') . 'highlightedheading.min.css', [], filemtime(Helpers::get_asset_path('css') . 'highlightedheading.min.css'), 'all' );

		$settings = $this->settings;
		$waypoint = Helpers::get_value( $settings, 'anim_onscroll', 'no');
		if( $waypoint == 'yes' ) {
			wp_register_script( 'bu-waypoint', Helpers::get_asset_url('js') . 'noframework.waypoints.min.js', [], filemtime(Helpers::get_asset_path('js') . 'noframework.waypoints.min.js'), true );
			wp_register_script( 'bu-highlighted-heading', Helpers::get_asset_url('js') . 'highlightedheading.min.js', [], filemtime(Helpers::get_asset_path('js') . 'highlightedheading.min.js'), true );
		}
	}

	public function render() {
		$settings = $this->settings;
		$shape = Helpers::get_value( $settings, 'shape', 'circle' );
		$loop = 'buhlh-headline-' . Helpers::get_value( $settings, 'shape_loop', 'loop' );

		$before_text = Helpers::get_value($settings, 'text_before', false);
		$after_text = Helpers::get_value($settings, 'text_after', false);
		$highlighted_text = Helpers::get_value($settings, 'highlighted_text', 'Highlighted');

		$svg = '';

		$ulAnim = '';
		$shape_underline = ['underline_lr', 'underline_rl', 'underline_outwards', 'underline_inwards'];
		if( in_array( $shape, $shape_underline ) )
		{
			$ulAnim = ' ul-anim ' . $shape . ' ' . Helpers::get_value( $settings, 'shape_appear', 'offhover' );
		} else {
			$svg = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 150" preserveAspectRatio="none" class="'. $shape .'">';
			$types = [ 
				'circle' 	=> [ 'M325,18C228.7-8.3,118.5,8.3,78,21C22.4,38.4,4.6,54.6,5.6,77.6c1.4,32.4,52.2,54,142.6,63.7 c66.2,7.1,212.2,7.5,273.5-8.3c64.4-16.6,104.3-57.6,33.8-98.2C386.7-4.9,179.4-1.4,126.3,20.7' ],
				'curly' 	=> [ 'M3,146.1c17.1-8.8,33.5-17.8,51.4-17.8c15.6,0,17.1,18.1,30.2,18.1c22.9,0,36-18.6,53.9-18.6 c17.1,0,21.3,18.5,37.5,18.5c21.3,0,31.8-18.6,49-18.6c22.1,0,18.8,18.8,36.8,18.8c18.8,0,37.5-18.6,49-18.6c20.4,0,17.1,19,36.8,19 c22.9,0,36.8-20.6,54.7-18.6c17.7,1.4,7.1,19.5,33.5,18.8c17.1,0,47.2-6.5,61.1-15.6' ],
				'diagonal' 	=> [ 'M13.5,15.5c131,13.7,289.3,55.5,475,125.5'],
				'double' 	=> [ 'M8.4,143.1c14.2-8,97.6-8.8,200.6-9.2c122.3-0.4,287.5,7.2,287.5,7.2', 'M8,19.4c72.3-5.3,162-7.8,216-7.8c54,0,136.2,0,267,7.8'],
				'doubleub' 	=> [ 'M5,125.4c30.5-3.8,137.9-7.6,177.3-7.6c117.2,0,252.2,4.7,312.7,7.6', 'M26.9,143.8c55.1-6.1,126-6.3,162.2-6.1c46.5,0.2,203.9,3.2,268.9,6.4'],
				'strikethrough' => [ 'M3,75h493.5'],
				'underline' 	=> [ 'M7.7,145.6C109,125,299.9,116.2,401,121.3c42.1,2.2,87.6,11.8,87.3,25.7' ],
				'underline_zigzag' => [ 'M9.3,127.3c49.3-3,150.7-7.6,199.7-7.4c121.9,0.4,189.9,0.4,282.3,7.2C380.1,129.6,181.2,130.6,70,139 c82.6-2.9,254.2-1,335.9,1.3c-56,1.4-137.2-0.3-197.1,9' ]
			];

			foreach( $types[ $shape ] as $path ) {
				$svg .= '<path d="' . $path . '" />';
			}

			$svg .= '</svg>';
		}

		$class = ' highlighted-text-wrapper';
		$waypoint = Helpers::get_value( $settings, 'anim_onscroll', 'no');
		if( $waypoint == 'yes' ) {
			//$offset = Helpers::get_value( $settings, 'onscroll_offset', '65');
			$class = '';
			$this->set_attribute( '_root', 'data-animate-onscroll', "yes" );
			//$this->set_attribute( '_root', 'data-waypoint-offset', $offset );
			if( ! bricks_is_builder() ) {
				wp_enqueue_script( 'bu-waypoint' );
				wp_enqueue_script( 'bu-highlighted-heading' );
			}
		}

		$this->set_attribute( '_root', 'class', "buhlh-shape {$loop}" );
		echo "<{$this->tag} {$this->render_attributes('_root')}>";
	?>
		<?php if( isset( $before_text ) ) : ?>
		<span class="headline-text"><?php echo $before_text;?></span> 
		<?php endif; ?>
		<?php if( isset( $highlighted_text ) ) : ?>
		<span class="highlighted-text-content<?php echo $class; ?>">
			<span class="highlighted-text<?php echo $ulAnim; ?>"><?php echo $highlighted_text . $svg;?></span>
		</span> 
		<?php endif; ?>
		<?php if( isset( $after_text ) ) : ?>
			<span class="headline-text"><?php echo $after_text;?></span>
		<?php endif; ?>
	<?php
		echo "</{$this->tag}>";
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-hightlighted-heading">
			<component :is="tag" class="buhlh-shape" :class="[`buhlh-headline-${settings.shape_loop}`]">
				<span v-if="settings.text_before" class="headline-text">{{settings.text_before}}&nbsp;</span> 
				<span class="highlighted-text-content highlighted-text-wrapper">
					<span 
						class="highlighted-text" 
						:class="[
							( settings.shape == 'underline_lr' || settings.shape == 'underline_rl' || settings.shape == 'underline_outwards' || settings.shape == 'underline_inwards' ) ? 'ul-anim ' + settings.shape + ' ' + settings.shape_appear : ''
						]"
					>
					{{settings.highlighted_text}}
					<svg v-if="settings.shape=='circle'"
						xmlns="http://www.w3.org/2000/svg" 
						viewBox="0 0 500 150" 
						preserveAspectRatio="none" 
						:class="settings.shape"
					>
						<path d="M325,18C228.7-8.3,118.5,8.3,78,21C22.4,38.4,4.6,54.6,5.6,77.6c1.4,32.4,52.2,54,142.6,63.7 c66.2,7.1,212.2,7.5,273.5-8.3c64.4-16.6,104.3-57.6,33.8-98.2C386.7-4.9,179.4-1.4,126.3,20.7" />
					</svg>
					<svg v-if="settings.shape=='curly'"
						xmlns="http://www.w3.org/2000/svg" 
						viewBox="0 0 500 150" 
						preserveAspectRatio="none" 
						:class="settings.shape"
					>
						<path d="M3,146.1c17.1-8.8,33.5-17.8,51.4-17.8c15.6,0,17.1,18.1,30.2,18.1c22.9,0,36-18.6,53.9-18.6 c17.1,0,21.3,18.5,37.5,18.5c21.3,0,31.8-18.6,49-18.6c22.1,0,18.8,18.8,36.8,18.8c18.8,0,37.5-18.6,49-18.6c20.4,0,17.1,19,36.8,19 c22.9,0,36.8-20.6,54.7-18.6c17.7,1.4,7.1,19.5,33.5,18.8c17.1,0,47.2-6.5,61.1-15.6" />
					</svg>
					<svg v-if="settings.shape=='diagonal'"
						xmlns="http://www.w3.org/2000/svg" 
						viewBox="0 0 500 150" 
						preserveAspectRatio="none" 
						:class="settings.shape"
					>
						<path d="M13.5,15.5c131,13.7,289.3,55.5,475,125.5" />
					</svg>
					<svg v-if="settings.shape=='double'"
						xmlns="http://www.w3.org/2000/svg" 
						viewBox="0 0 500 150" 
						preserveAspectRatio="none" 
						:class="settings.shape"
					>
						<path d="M8.4,143.1c14.2-8,97.6-8.8,200.6-9.2c122.3-0.4,287.5,7.2,287.5,7.2" /><path d="M8,19.4c72.3-5.3,162-7.8,216-7.8c54,0,136.2,0,267,7.8" />
					</svg>
					<svg v-if="settings.shape=='doubleub'"
						xmlns="http://www.w3.org/2000/svg" 
						viewBox="0 0 500 150" 
						preserveAspectRatio="none" 
						:class="settings.shape"
					>
						<path d="M5,125.4c30.5-3.8,137.9-7.6,177.3-7.6c117.2,0,252.2,4.7,312.7,7.6" /><path d="M26.9,143.8c55.1-6.1,126-6.3,162.2-6.1c46.5,0.2,203.9,3.2,268.9,6.4" />
					</svg>
					<svg v-if="settings.shape=='strikethrough'"
						xmlns="http://www.w3.org/2000/svg" 
						viewBox="0 0 500 150" 
						preserveAspectRatio="none" 
						:class="settings.shape"
					>
						<path d="M3,75h493.5" />
					</svg>
					<svg v-if="settings.shape=='underline'"
						xmlns="http://www.w3.org/2000/svg" 
						viewBox="0 0 500 150" 
						preserveAspectRatio="none" 
						:class="settings.shape"
					>
						<path d="M7.7,145.6C109,125,299.9,116.2,401,121.3c42.1,2.2,87.6,11.8,87.3,25.7" />
					</svg>
					<svg v-if="settings.shape=='underline_zigzag'"
						xmlns="http://www.w3.org/2000/svg" 
						viewBox="0 0 500 150" 
						preserveAspectRatio="none" 
						:class="settings.shape"
					>
						<path d="M9.3,127.3c49.3-3,150.7-7.6,199.7-7.4c121.9,0.4,189.9,0.4,282.3,7.2C380.1,129.6,181.2,130.6,70,139 c82.6-2.9,254.2-1,335.9,1.3c-56,1.4-137.2-0.3-197.1,9" />
					</svg>
					</span>
				</span> 
				<span v-if="settings.text_after" class="headline-text">&nbsp;{{settings.text_after}}</span> 
			</component>
		</script>
	<?php
	}
}