<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class PostGrid extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-post-grid';
	public $icon 			= 'ti-layout-grid2';
	public $tag 			= 'div';
	public $nestable 		= true;
	public $css 			= false;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Post Grid', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['layout'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Grid layout', 'bricksultimate' ),
			'type'        => 'select',
			'options'     => [
				'2' => esc_html__('2 Columns'),
				'3' => esc_html__('3 Columns'),
				'4' => esc_html__('4 Columns'),
				'5' => esc_html__('5 Columns'),
				'6' => esc_html__('6 Columns'),
				'tpl1' => esc_html__('Template 1'),
				'tpl2' => esc_html__('Template 2'),
				'tpl3' => esc_html__('Template 3'),
				'tpl4' => esc_html__('Template 4'),
				'tpl5' => esc_html__('Template 5'),
				//'custom' => esc_html__('Custom'),
			],
			'default'   => '3',
		];

		$this->controls['gap'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Gap', 'bricksultimate' ),
			'type' => 'number',
			'units' => true,
			'placeholder' => '20px',
			'css' => [
				[
					'property' => 'gap'
				]
			]
		];

		$this->controls['gridTemplateColumns'] = [
			'label'          => esc_html__( 'Grid template columns', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-tempate-columns',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-template-columns',
					'selector' => '',
				],
			],
			'placeholder'    => '',
			'required' => ['layout','=','custom']
		];

		$this->controls['gridTemplateRows'] = [
			'label'          => esc_html__( 'Grid template rows', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-tempate-rows',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-template-rows',
					'selector' => '',
				],
			],
			'placeholder'    => '',
			'required' => ['layout','=','custom']
		];

		$this->controls['gridAutoColumns'] = [
			'label'          => esc_html__( 'Grid auto columns', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-auto-columns',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-auto-columns',
					'selector' => '',
				],
			],
		];

		$this->controls['gridAutoRows'] = [
			'label'          => esc_html__( 'Grid auto rows', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-auto-rows',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-auto-rows',
					'selector' => '',
				],
			],
		];

		$this->controls['gridAutoFlow'] = [
			'label'    => esc_html__( 'Grid auto flow', 'bricks' ),
			'type'     => 'select',
			'options'  => [
				'row'    => 'row',
				'column' => 'column',
				'dense'  => 'dense',
			],
			'tooltip'  => [
				'content'  => 'grid-auto-flow',
				'position' => 'top-left',
			],
			'css'      => [
				[
					'property' => 'grid-auto-flow',
					'selector' => '',
				],
			]
		];

		$this->controls['bpSep'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Columns in Breakpoints', 'bricksultimate' ),
			'type' => 'separator',
			//'required' => ['layout', '=', ['2', '3', '4', '5', '6']]
		];

		$this->controls['tablet'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Tablet(<=991)', 'bricksultimate' ),
			'type'        => 'select',
			'options'     => [
				'1' => esc_html__('1 Column'),
				'2' => esc_html__('2 Columns'),
				'3' => esc_html__('3 Columns'),
				'4' => esc_html__('4 Columns'),
			],
			'placeholder'   => '2',
			'inline' => true,
		];

		$this->controls['landscape'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'iPad(<=768)', 'bricksultimate' ),
			'type'        => 'select',
			'options'     => [
				'1' => esc_html__('1 Column'),
				'2' => esc_html__('2 Columns'),
				'3' => esc_html__('3 Columns'),
				'4' => esc_html__('4 Columns'),
			],
			'placeholder'   => '2',
			'inline' => true,
		];

		$this->controls['portrait'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Mobile(<=620)', 'bricksultimate' ),
			'type'        => 'select',
			'options'     => [
				'1' => esc_html__('1 Column'),
				'2' => esc_html__('2 Columns'),
				'3' => esc_html__('3 Columns'),
				'4' => esc_html__('4 Columns'),
			],
			'placeholder'   => '1',
			'inline' => true,
		];

		$this->controls['layoutSep'] = [
			'tab' => 'content',
			'label' => esc_html__( 'Alignment', 'bricksultimate' ),
			'type' => 'separator'
		];

		$this->controls['justifyItemsGrid'] = [
			'label'     => esc_html__( 'Justify items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'justify-items',
				'position' => 'top-left',
			],
			'type'      => 'justify-content',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'justify-items',
				],
			]
		];

		$this->controls['alignItemsGrid'] = [
			'label'     => esc_html__( 'Align items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-items',
				],
			]
		];

		$this->controls['justifyContentGrid'] = [
			'label'     => esc_html__( 'Justify content', 'bricks' ),
			'tooltip'   => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'      => 'justify-content',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'justify-content',
				],
			]
		];

		$this->controls['alignContentGrid'] = [
			'label'     => esc_html__( 'Align content', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-content',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-content',
				],
			]
		];

		/*$this->controls['gridSep'] = [
			'tab' => 'content',
			'label' => esc_html__( 'CSS Grid settings', 'bricksultimate' ),
			'type' => 'separator'
		];

		$this->controls['gridItems'] = [
			'tab'         => 'content',
			'placeholder' => esc_html__( 'Grid item', 'bricks' ),
			'titleProperty' => 'cssSelector',
			'type'        => 'repeater',
			'checkLoop'   => true,
			'fields'      => [
				'cssSelector'    => [
					'label' => esc_html__( 'CSS selector of grid item', 'bricks' ),
					'type'  => 'text',
					'placeholder' => 'grid-item-1'
				],
				'gridColumn' => [
					'label' => esc_html__( 'Grid column', 'bricks' ),
					'type'  => 'text',
					'placeholder' => 'auto / auto',
				],
				'gridRow'  => [
					'label' => esc_html__( 'Grid row', 'bricks' ),
					'type'  => 'text',
					'placeholder' => 'auto / auto'
				],
			],
			//'required' => ['', '', '']
		];*/
	}

	public function get_nestable_children() {
		return [
			[
				'name' => 'block',
				'label' => esc_html__( 'Column', 'bricksultimate' ),
				'settings' => [
					'hasLoop' => true,
					'query' => [
						'objectType' => 'post',
						'post_type' => 'post',
						'posts_per_page' => 3,
						'offset' => 0
					],
					'_hidden' => [
						'_cssClasses' => 'grid-item grid-item-{loop_counter}'
					]
				],
				'children' => [
					[
						'name' => 'image',
						'label' => esc_html__( 'Featured image', 'bricksultimate' ),
						'settings' => [
							'image' => [
								'useDynamicData' => "{featured_image}",
								'size' => 'full'
							]
						]
					],
					[
						'name' => 'post-title',
						'settings' => [
							'linkToPost' => true
						]
					]
				],
				'delete' => false
			]
		];
	}

	// Enqueue element styles and scripts
	/*public function enqueue_scripts() {
		wp_enqueue_style( 'bu-post-grid', Helpers::get_asset_url('css') . 'postgrid.min.css', [], filemtime(Helpers::get_asset_path('css') . 'postgrid.min.css'), 'all' );
	}*/

	public function render() {
		$layout = $this->settings['layout'];

		$this->set_attribute('_root', 'data-grid', $layout);
		if( isset( $this->settings['tablet'] ) )
			$this->set_attribute('_root', 'data-grid-ld', $this->settings['tablet']);

		if( isset( $this->settings['landscape'] ) )
			$this->set_attribute('_root', 'data-grid-md', $this->settings['landscape']);

		if( isset( $this->settings['portrait'] ) )
			$this->set_attribute('_root', 'data-grid-sd', $this->settings['portrait']);

		$this->set_attribute('_root', 'class', [ "bu-pg-{$this->element['id']}" ]);

		echo "<{$this->tag} {$this->render_attributes('_root')}>";
		echo \Bricks\Frontend::render_children($this);
		echo "</{$this->tag}>";

		//$this->genarateCustomLayoutCSS();
	}

	/*function genarateCustomLayoutCSS() {
		$layout = $this->settings['layout'];
		$gridItems = ! empty( $this->settings['gridItems'] ) ? $this->settings['gridItems'] : false;
		if( $gridItems ) {
			$this->css = '';
			foreach( $gridItems as $key => $item ) {
				if( $item['cssSelector'] ) {
					$cssSelector = $item['cssSelector'];
					$gridColumns = $gridRow = '';
					if( isset( $item['gridColumn'] ) ) {
						$gridColumns = "grid-column:{$item['gridColumn']};";
					}
					if( isset( $item['gridRow'] ) ) {
						$gridRow = "grid-row:{$item['gridRow']};";
					}
				}
				$this->css .= ".bu-pg-{$this->element['id']}[data-grid=\"{$layout}\"] .{$cssSelector}{". $gridColumns . $gridRow . "}";
			}

			add_action('wp_footer', function(){
				echo "<style type='text/css'>{$this->css}</style>";
			});

			unset( $gridItems );
		}
	}*/
}