<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class PostTerms extends \Bricks\Element {
	public $category 		= 'single';
	public $name 			= 'bu-post-terms';
	public $icon 			= 'ti-layout-menu-full';
	public $add_css 		= false;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Post Terms', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['taxonomy'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Taxonomy', 'bricks' ),
			'type'      => 'select',
			'options'   => \Bricks\Setup::$control_options['taxonomies'],
			'clearable' => false,
			'default'   => 'category',
		];

		$this->controls['limit'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'How many terms will show?', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'all' 	=> esc_html__('All', 'bricksultimate'),
				'limit' => esc_html__('Set limit', 'bricksultimate')
			],
			'default'   => 'all',
			'inline' 	=> true,
			'medium' 	=> true
		];

		$this->controls['custom_limit'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Limit', 'bricks' ),
			'type'      => 'text',
			'default'   => 1,
			'placeholder' => 1,
			'hasDynamicData'=> false,
			'required' 	=> [ 'limit', '=', 'limit' ]
		];

		$this->controls['orderby'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Orderby', 'bricks' ),
			'type'      => 'select',
			'options'   => \Bricks\Setup::$control_options['termsOrderBy'],
			'clearable' => false,
			'inline' 	=> true,
			'medium' 	=> true,
			'default'   => 'name',
		];

		$this->controls['order'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Order', 'bricks' ),
			'type'      => 'select',
			'options'   => \Bricks\Setup::$control_options['queryOrder'],
			'clearable' => false,
			'inline' 	=> true,
			'medium' 	=> true,
			'default'   => 'ASC',
		];

		$this->controls['disable_link'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Disable link?', 'bricks' ),
			'type'      => 'checkbox',
			'reset' 	=> true,
		];

		$this->controls['separator'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Separator', 'bricks' ),
			'type'      => 'text',
			'placeholder' => ', ',
			'hasDynamicData'=> false
		];

		$this->controls['prefix'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Prefix', 'bricks' ),
			'type'      => 'text',
			'placeholder' => 'Categories:',
			'hasDynamicData'=> false
		];

		$this->controls['iconSeparator'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Icon', 'bricks' ),
			'type'      => 'separator',
		];

		$this->controls['icon'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'icon',
		];

		$this->controls['iconPos'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Direction', 'bricks' ),
			'type'      => 'direction',
			'exclude' 	=> [ 'column' ],
			'direction' => 'row',
			'inline' 	=> true,
			'css' 		=> [
				[ 
					'selector' 	=> '.term-name',
					'property' 	=> 'flex-direction',
					'value' 	=> '%s'
				]
			]
		];

		$this->controls['iconGap'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[ 
					'selector' => '.term-name i',
					'property' => 'margin',
				],
				[ 
					'selector' => '.term-name svg',
					'property' => 'margin',
				]
			]
		];

		$this->controls['spSeparator'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Spacing', 'bricks' ),
			'type'      => 'separator',
		];

		$this->controls['linkMargin'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[ 
					'selector' => '.term-name, .bu-terms-prefix',
					'property' => 'margin',
				]
			]
		];

		$this->controls['linkPadding'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[ 
					'selector' => '.term-name',
					'property' => 'padding',
				]
			],
			'placeholder' => [
				'top' 	=> '3px',
				'right' => '3px',
				'bottom' => '3px',
				'left' 	=> '3px',
			]
		];

		$this->controls['divider'] = [
			'tab'       => 'content',
			'type'      => 'separator',
			'label'     => esc_html__( 'Typography', 'bricks' ),
		];

		$this->controls['prefixTg'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Prefix', 'bricksultimate' ),
			'type'      => 'typography',
			'css' 		=> [
				[ 
					'selector' => '.bu-terms-prefix',
					'property' => 'font',
				]
			],
		];

		$this->controls['termsTg'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Terms', 'bricksultimate' ),
			'type'      => 'typography',
			'css' 		=> [
				[ 
					'selector' => '.term-name',
					'property' => 'font',
				]
			],
		];

		$this->controls['dividerDefault'] = [
			'tab'       => 'content',
			'type'      => 'separator',
			'label'     => esc_html__( 'Default', 'bricksultimate' ),
		];

		$this->controls['termsBg'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Background', 'bricksultimate' ),
			'type'      => 'color',
			'css' 		=> [
				[ 
					'selector' => '.term-name',
					'property' => 'background-color',
				]
			],
		];

		$this->controls['termsBorder'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Border', 'bricks' ),
			'type'      => 'border',
			'css' 		=> [
				[ 
					'selector' => '.term-name',
					'property' => 'border',
				]
			],
		];

		$this->controls['dividerDynamic'] = [
			'tab'       => 'content',
			'type'      => 'separator',
			'label'     => esc_html__( 'Dynamic', 'bricksultimate' ),
		];

		$this->controls['dynBG'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Background', 'bricks' ),
			'type'      => 'text',
			'placeholder' => 'enter meta key name',
			'hasDynamicData'=> false
		];

		$this->controls['dynColor'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Color', 'bricks' ),
			'type'      => 'text',
			'placeholder' => 'enter meta key name',
			'hasDynamicData'=> false
		];

		$this->controls['dividerHover'] = [
			'tab'       => 'content',
			'type'      => 'separator',
			'label'     => esc_html__( 'Hover', 'bricksultimate' ),
		];

		$this->controls['termsHBg'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Background', 'bricksultimate' ),
			'type'      => 'color',
			'css' 		=> [
				[ 
					'selector' 	=> '.term-name:hover',
					'property' 	=> 'background-color',
					'important' => true,
				]
			],
		];

		$this->controls['termsHcolor'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Color', 'bricks' ),
			'type'      => 'color',
			'css' 		=> [
				[ 
					'selector' 	=> '.term-name:hover',
					'property' 	=> 'color',
					'important' => true,
				]
			],
		];
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$taxonomy = isset( $settings['taxonomy'] ) ? $settings['taxonomy'] : 'category';
		$limit    = isset( $settings['limit'] ) ? $settings['limit'] : 'all';

		$terms    = wp_get_object_terms(
			$this->post_id,
			$taxonomy,
			[
				'orderby' => isset( $settings['orderby'] ) ? $settings['orderby'] : 'name',
				'order'   => isset( $settings['order'] ) ? $settings['order'] : 'ASC',
			]
		);
		$terms = wp_list_filter( $terms, [ 'slug' => 'uncategorized' ], 'NOT' );

		if ( ! count( $terms ) || is_wp_error( $terms ) ) {
			return $this->render_element_placeholder(
				[
					'title' => sprintf( esc_html__( 'This post has no %s terms.', 'bricks' ), ucfirst( get_taxonomy( $taxonomy )->name ) ),
				]
			);
		}

		if( $limit != 'all' ) {
			$limit    = isset( $settings['custom_limit'] ) ? $settings['custom_limit'] : 1;
			$new_terms = array_splice( $terms, 0, $limit );
		} else {
			$new_terms = $terms;
		}

		$icon = ! empty( $settings['icon'] ) ? self::render_icon( $settings['icon'] ) : '';

		$list = [];
		foreach ( $new_terms as $index => $term ) {
			$this->set_attribute( "term-$index", "class", [ 'term-' . esc_attr( $term->slug ), 'term-name' ] );
			$this->set_attribute( "term-$index", "rel", "category tag" );

			if( isset( $settings['dynBG'] ) ) {
				$bg = get_term_meta( $term->term_id, $settings['dynBG'], true );
				if( $bg ) {
					$this->set_attribute( "term-$index", "style", "background-color: {$bg};" );
				}
			}

			if( isset( $settings['dynColor'] ) ) {
				$color = get_term_meta( $term->term_id, $settings['dynColor'], true );
				if( $color ) {
					$this->set_attribute( "term-$index", "style", "color: {$color}" );
				}
			}

			if ( ! isset( $settings['disable_link'] ) ) {
				$this->set_attribute( "term-$index", "href", esc_url( get_term_link( $term->term_id, $taxonomy ) ) );
				$list[] = "<a {$this->render_attributes("term-$index")}>" . $icon . esc_html( $term->name ) . '</a>';
			} else {
				$list[] = "<span {$this->render_attributes("term-$index")}>" . apply_filters( 'bu_terms_icon', $icon, $this ) . $term->name . '</span>';
			}
		}

		$this->set_attribute( '_root', 'class', 'entry-' . sanitize_html_class( $taxonomy ) );

		echo "<div {$this->render_attributes( '_root' )}>";

		if( isset( $settings['prefix'] ) ) {
			$this->set_attribute( 'bu-terms-prefix', 'class', "bu-terms-prefix" );
			echo "<span {$this->render_attributes("bu-terms-prefix")}>" . wp_kses_post( $settings['prefix'] ) . '</span>';
		}

		$separator = isset( $settings['separator'] ) ? $settings['separator'] : ' ';

		echo implode( $separator, $list );

		echo "</div>";
	}

	public function add_actions() {
		if( ! $this->add_css ) {
			add_action( 'wp_head', [ $this, 'add_css' ] );
			$this->add_css = true;
		}
	}

	public function add_css() {
		echo "<style type='text/css'>.brxe-bu-post-terms .bu-terms-prefix{display: inline-block;} .brxe-bu-post-terms .term-name{ display:inline-flex; padding: 3px; align-items: center; justify-content: center;}.brxe-bu-post-terms .term-name i{margin-right: 5px;}</style>";
	}
}