<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class ReadingProgressBar extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-readingprogressbar';
	public $icon 			= 'ti-line-double';
	public $scripts 		= ['buReadingProgressBar'];

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Reading Progress Bar', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['container'] = [
			'tab' 			=> 'content',
			'type'        	=> 'text',
			'label' 		=> esc_html__( 'Container selector', 'bricksultimate' ),
			'placeholder' 	=> esc_html__( 'body', 'bricksultimate' ),
		];

		$this->controls['height'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Height', 'bricksultimate'),
			'unit' 		=> 'px',
			'min' 		=> 2,
			'max' 		=> 100,
			'step' 		=> 1,
			'default'   => 5,
			'css' 		=> [
				[
					'property' 	=> 'height'
				],
				[
					'selector' 	=> '.bu-reading-progress-bar-fill',
					'property' 	=> 'height'
				]
			],
			'inline' 	=> true,
			'medium' 	=> true,
		];

		$this->controls['position'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Position', 'bricksultimate'),
			'options'   => [
				'top'  		=> esc_html__('Top'),
				'bottom'  	=> esc_html__('Bottom'),
			],
			'default'   => 'top',
			'medium' 	=> true,
			'inline' 	=> true,
		];

		$this->controls['speed'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Transition Speed(ms)', 'bricksultimate'),
			'unit' 		=> 'ms',
			'min'		=> 0,
			'max'  		=> 10000,
			'step' 		=> 5,
			'default'   => 50,
			'small' 	=> false,
			'css' 		=> [
				[
					'selector' 	=> '.bu-reading-progress-bar-fill',
					'property' 	=> 'transition-duration'
				]
			]
		];

		$this->controls['zindex'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Z-Index', 'bricksultimate'),
			'unitless' 	=> true,
			'small' 	=> false,
			'default'   => 999999,
			'placeholder'   => 999999,
			'css' 		=> [
				[
					'selector' 	=> '.bu-reading-progress-bar',
					'property' 	=> 'z-index'
				]
			]
		];

		$this->controls['bg_color'] = [
			'tab' 		=> 'content',
			'type'      => 'color',
			'label'     => esc_html__('Bar Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['pgb_bg_color'] = [
			'tab' 		=> 'content',
			'type'      => 'color',
			'label'     => esc_html__('Progress Bar Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'default' 	=> [
				'hex' 	=> '#FC5611'
			],
			'css' 		=> [
				[
					'selector' 	=> '.bu-reading-progress-bar-fill',
					'property' 	=> 'background-color'
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_style( 'bu-rpgb', Helpers::get_asset_url('css') . 'readingprogressbar.min.css', [], filemtime(Helpers::get_asset_path('css') . 'readingprogressbar.min.css'), 'all' );
		wp_enqueue_script( 'bu-rpgb', Helpers::get_asset_url('js') . 'readingprogressbar.min.js', [], filemtime(Helpers::get_asset_path('js') . 'readingprogressbar.min.js'), true );
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$pos = Helpers::get_value( $settings, 'position', 'top');
		$container = Helpers::get_value( $settings, 'container', 'body');

		$this->set_attribute( '_root', 'data-rpgb-container', $container );
		$this->set_attribute( '_root', 'class', "bu-reading-progress-bar bu-reading-progress-bar-" . $pos );
		echo "<div {$this->render_attributes('_root')}>";
		echo "<span class=\"bu-reading-progress-bar-fill\"></span>";
		echo "<span class=\"screen-reader-text\">" . __('Reading Progress Bar', 'bricksultimate') . "</span>";
		echo "</div>";
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-readingprogressbar">
			<div
				class="bu-reading-progress-bar"
		        :class="[ settings.position == 'top' ? 'bu-reading-progress-bar-top' : 'bu-reading-progress-bar-bottom']" 
				:data-rpgb-container="settings.hasOwnProperty('container') ? settings.container : 'body'"
			>
				<span class="bu-reading-progress-bar-fill"></span>
				<span class="screen-reader-text">Reading Progress Bar</span>
			</div>
		</script>
	<?php
	}
}