<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class SliderProgressBar extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-sld-progress';
	public $icon 			= 'ti-layout-line-solid';
	public $scripts 		= ['sliderProgressBar'];
	public $tag 			= 'div';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Slider Progress Bar', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['sldSep'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Bricks Nested Slider'),
			'type' 	=> 'separator',
		];

		$this->controls['scriptId'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Script ID'),
			'type' 	=> 'text',
			'inline' => true
		];

		$this->controls['arrowSep'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Styles'),
			'type' 	=> 'separator',
		];

		$bar = '.bbsplide-slider-progress';
		$pbar = '.bbsplide-slider-progress-bar';

		$this->controls['barColor'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Color'),
			'type' 	=> 'color',
			'css' 	=> [
				[
					'property' => 'background',
				]
			],
		];

		$this->controls['pbarColor'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Progress bar color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'background',
					'selector' => $pbar
				]
			],
		];

		$this->controls['barHeight'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Bar width', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'height',
					'selector' => $pbar
				]
			],
			'placeholder' => '2px'
		];

		$this->controls['_position']['default'] = 'relative';
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_style( 'bu-sld-arrow', Helpers::get_asset_url('css') . 'sldarrow.min.css', [], filemtime(Helpers::get_asset_path('css') . 'sldarrow.min.css'), 'all' );
		wp_enqueue_script( 'bu-sld-pb', Helpers::get_asset_url('js') . 'sldpb.min.js', [], filemtime(Helpers::get_asset_path('js') . 'sldpb.min.js'), true );
	}

	// Render element HTML
	public function render() {
		$sliderID = Helpers::get_value( $this->settings, 'scriptId', '');
		if( empty( $sliderID ) ) {
			return $this->render_element_placeholder(
				[
					'title'       => esc_html__( 'Nested slider script ID is required.', 'bricksultimate' ),
					'description' => esc_html__( 'Add a slider(Nestable) element on canvas, copy the 6 digit ID and paste into Script ID input box.', 'bricksultimate' ),
				]
			);
		}
		
		$this->set_attribute( '_root', 'class', [ 'bbsplide-slider-progress' ] );
		$this->set_attribute( '_root', 'data-pbsld-script-id', $sliderID );

		echo "<{$this->tag} {$this->render_attributes( '_root' )}>";
		echo '<div class="bbsplide-slider-progress-bar"></div>';
		echo "</{$this->tag}>";
	}
}