<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use Bricks\Setup;
use BricksUltimate\Helpers;
use BricksUltimate\BuSlidingMenuCategoryWalker;
use BricksUltimate\BuSlidingNavWalker;


class SlidingMenu extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-sliding-menu';
	public $icon 			= 'ti-menu';
	public $scripts 		= [ 'buSlidingMenu' ];

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Sliding Menu', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['menu_title'] = [
			'title' 	=> esc_html__( 'Menu Name', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required'	=> ['sld_source_menu', '=', 'wpmenu']
		];

		$this->control_groups['menu_items'] = [
			'title' 	=> esc_html__( 'Menu Items', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['toggle_icon'] = [
			'title' 	=> esc_html__( 'Toggle Icon', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['back_bar'] = [
			'title' 	=> esc_html__( 'Back Button', 'bricksultimate' ),
			'tab' 		=> 'content',
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['sld_source_menu'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Source', 'bricksultimate'),
			'options'   => [
				'wpmenu'  	=> esc_html__('WP Menu'),
				'tax'  		=> esc_html__('Taxonomy'),
			],
			'default'   => 'wpmenu',
		];

		$this->controls['sld_menu'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('WP Menu', 'bricksultimate'),
			'options'   => Helpers::getWPMenus(),
			'default'   => 'none',
			'required'	=> ['sld_source_menu', '=', 'wpmenu']
		];

		$this->controls['sld_tax_name'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Taxonomy', 'bricksultimate'),
			'options'   => Setup::get_taxonomies_options(),
			'default'   => 'category',
			'required'	=> ['sld_source_menu', '=', 'tax']
		];

		$this->controls['include_ids'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Include terms', 'bricksultimate' ),
			'info' 		=> esc_html__( 'Enter the term ID. Use comma separator for multiple IDs', 'bricksultimate' ),
			'required'	=> ['sld_source_menu', '=', 'tax']
		];

		$this->controls['exclude_ids'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Exclude terms', 'bricksultimate' ),
			'info' 		=> esc_html__( 'Enter the term ID. Use comma separator for multiple IDs', 'bricksultimate' ),
			'required'	=> ['sld_source_menu', '=', 'tax']
		];

		$this->controls['disableTopParentLink'] = array(
			'tab'   	=> 'content',
			'type'  	=> 'checkbox',
			'label' 	=> esc_html__( "Disable top level term's link", 'bricksultimate' ),
			'default' 	=> false,
			'required'	=> ['sld_source_menu', '=', 'tax']
		);

		$this->controls['hide_empty'] = array(
			'tab'   	=> 'content',
			'type'  	=> 'checkbox',
			'label' 	=> esc_html__( 'Hide empty', 'bricksultimate' ),
			'default' 	=> true,
			'required'	=> ['sld_source_menu', '=', 'tax']
		);

		$this->controls['child_of'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Child of', 'bricksultimate' ),
			'medium' 	=> true,
			'inline' 	=> true,
			'required'	=> ['sld_source_menu', '=', 'tax']
		];

		$this->controls['orderby'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Order by', 'bricksultimate'),
			'options'   => [
				'name' 			=> 'Name',
				'id' 			=> 'ID',
				'slug' 			=> 'Slug',
				'menu_order' 	=> 'Menu Order',
				'include' 		=> 'Include',
				'count' 		=> 'Count',
			],
			'default'   => 'name',
			'medium' 	=> true,
			'inline' 	=> true,
			'required'	=> ['sld_source_menu', '=', 'tax']
		];

		$this->controls['order'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Order', 'bricksultimate'),
			'options'   => [
				'ASC'  	=> esc_html__('ASC'),
				'DESC'  => esc_html__('DESC'),
			],
			'default'   => 'ASC',
			'medium' 	=> true,
			'inline' 	=> true,
			'required'	=> ['sld_source_menu', '=', 'tax']
		];

		$this->controls['limit'] = [
			'tab' 		=> 'content',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Limit', 'bricksultimate' ),
			'min'		=> 0,
			'max'  		=> 200,
			'step' 		=> 1,
			'medium' 	=> true,
			'inline' 	=> true,
			'unitless' 	=> true,
			'required'	=> ['sld_source_menu', '=', 'tax']
		];

		/***************
		 * Animation effect
		 ***************/

		$this->controls['anim_effect'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Animation effect', 'bricksultimate' ),
			'type'  	=> 'separator',
		];

		$this->controls['sld_anim_type'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Animation type', 'bricksultimate'),
			'options'   => [
				'overlay'   => __( 'Overlay' ),
				'push'  	=> __( 'Push' ),
			],
			'default'   => 'overlay',
			'medium' 	=> true,
			'inline' 	=> true
		];

		$this->controls['anim_direction'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Slide from', 'bricksultimate'),
			'options'   => [
				'left'   => __( 'Left' ),
				'right'  => __( 'Right' ),
				'top'    => __( 'Top' )
			],
			'default'   => 'left',
			'medium' 	=> true,
			'inline' 	=> true
		];

		$this->controls['sd_menu_height'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Auto Height', 'bricksultimate'),
			'options'   => [
				'auto'  => esc_html__('Yes'),
				'full'  => esc_html__('No'),
			],
			'default'   => 'auto',
			'medium' 	=> true,
			'inline' 	=> true
		];

		$this->controls['sld_td'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Slide Transition Duration(sec)', 'bricksultimate'),
			'unit' 		=> 's',
			'min'		=> 0,
			'max'  		=> 10,
			'step' 		=> .1,
			'default' 	=> 0.4,
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.bu-slide-menu-el',
					'property' 	=> 'transition-duration'
				],
				[
					'selector' 	=> '',
					'property' 	=> '--bu-link-opacity'
				]
			]
		];

		$this->controls['hover_effect'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Hover Animation', 'bricksultimate' ),
			'type'  	=> 'separator',
		];

		$this->controls['hover_td'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Transition Duration(sec)', 'bricksultimate'),
			'unit' 		=> 's',
			'min'		=> 0,
			'max'  		=> 10,
			'step' 		=> .1,
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> 'li a span, .bu-slide-menu-arrow',
					'property' 	=> 'transition-duration'
				],
				[
					'selector' 	=> '.bu-slide-menu-item-link',
					'property' 	=> 'transition-duration'
				],
				[
					'selector' 	=> '.bu-menu-sub-item-back',
					'property' 	=> 'transition-duration'
				],
				[
					'selector' 	=> '.bu-slide-menu-back',
					'property' 	=> 'transition-duration'
				]
			]
		];

		$this->controls['hover_tx'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Slide from Left Side(translateX)', 'bricksultimate'),
			'unit' 		=> 'px',
			'min'		=> 0,
			'max'  		=> 100,
			'step' 		=> 1,
			'default' 	=> 10,
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property' 	=> '--link-span-translatex'
				]
			]
		];

		/**
		 * Sync
		 *------------------------*/
		$this->controls['sync'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Sync', 'bricksultimate' ),
			'type'  	=> 'separator',
		];

		$this->controls['syncSelectors'] = [
			'label' => esc_html__( 'Other Menu Items', 'bricksultimate' ),
			'description' => esc_html__( 'Enter menu item ID.', 'bricksultimate' ),
			'placeholder' => 'From:With',
			'type'  => 'text',
		];

		/***************
		 * Menu title
		 ***************/
		$selector = '.bu-sdmenu-title';
		$this->controls['display_menu_title'] = array(
			'tab'   	=> 'content',
			'group' 	=> 'menu_title',
			'type'  	=> 'checkbox',
			'label' 	=> esc_html__( 'Display Menu Name', 'bricksultimate' ),
			'default' 	=> true,
		);

		$this->controls['menu_title_tag'] = [
			'tab' 		=> 'content',
			'group' 	=> 'menu_title',
			'type'      => 'select',
			'label'     => esc_html__('Tag', 'bricksultimate'),
			'options'   => [
				'h1' 			=> 'H1',
				'h2' 			=> 'H2',
				'h3' 			=> 'H3',
				'h4' 			=> 'H4',
				'h5' 			=> 'H5',
				'h6' 			=> 'H6',
				'div' 			=> 'DIV',
			],
			'default'   => 'h4',
			'medium' 	=> true,
			'inline' 	=> true,
		];

		$this->controls['title_bg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_title',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['titleTypography'] = [
			'tab' 		=> 'content',
			'group' 	=> 'menu_title',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			],
			'exclude'  => [
				'text-decoration',
			]
		];

		$this->controls['title_border'] = [
			'tab'   	=> 'content',
			'group' 	=> 'menu_title',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' => $selector,
					'property' => 'border',
				],
			],
		];

		//margin field
		$this->controls['title_margin'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_title',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['title_padding'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_title',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		/***************
		 * Menu items
		 ***************/
		$selector = '.bu-slide-menu-item-link';

		$this->controls['onlyTopLevel'] = [
			'group'    	=> 'menu_items',
			'type'      => 'checkbox',
			'label'     => esc_html__('Top level items on page load', 'bricksultimate'),
		];

		$this->controls['menu_items_bg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['menu_items_font'] = [
			'tab' 		=> 'content',
			'group' 	=> 'menu_items',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			],
			'exclude'  => [
				'text-decoration',
			]
		];

		$this->controls['mi_brd'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-slide-menu-item",
					'property' 	=> 'border'
				]
			]
		];

		//padding field
		$this->controls['menu_items_padding'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['menu_items_hover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'menu_items',
			'label' 	=> esc_html__( 'Hover', 'bricksultimate' ),
			'type'  	=> 'separator',
		];

		$this->controls['mi_hbg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-slide-menu-item:hover > {$selector}",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['mi_hclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-slide-menu-item:hover > {$selector}",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['mi_hbrd'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-slide-menu-item:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['menu_items_current'] = [
			'tab' 		=> 'content',
			'group' 	=> 'menu_items',
			'label' 	=> esc_html__( 'Current/Active Item', 'bricksultimate' ),
			'type'  	=> 'separator',
		];

		$this->controls['mi_abg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".current-menu-item > " . $selector,
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> ".current-menu-ancestor > " . $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['mi_aclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".current-menu-item > " . $selector,
					'property' 	=> 'color'
				],
				[
					'selector' 	=> ".current-menu-ancestor > " . $selector,
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['mi_abrd'] = [
			'tab' 		=> 'content',
			'group'    	=> 'menu_items',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-slide-menu-item.current-menu-item",
					'property' 	=> 'border'
				],
				[
					'selector' 	=> ".bu-slide-menu-item.current-menu-ancestor",
					'property' 	=> 'border'
				]
			]
		];


		/***************
		 * Toggle icon
		 ***************/
		$selector = '.bu-slide-menu-arrow';

		$this->controls['arrow_icon'] = [
			'tab'     => 'content',
			'group'   => 'toggle_icon',
			'type'    => 'icon',
			'label'   => esc_html__( 'Icon', 'bricksultimate' ),
			'default' => [
				'icon'    => 'ion-ios-arrow-forward',
				'library' => 'ionicons',
			],
		];

		$this->controls['icon_bg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['iconTypography'] = [
			'tab'      => 'content',
			'group'    => 'toggle_icon',
			'label'    => esc_html__( 'Icon size & color', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'line-height',
				'letter-spacing',
			]
		];

		$this->controls['toggle_btn_border'] = [
			'tab'   	=> 'content',
			'group' 	=> 'toggle_icon',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' => $selector,
					'property' => 'border',
				],
			],
		];

		$this->controls['toggle_icon_width'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'label' 	=> esc_html__( 'Width', 'bricks' ),
			'type'  	=> 'number',
			'min' 		=> 0,
			'units' 	=> true,
			'step' 		=> 1,
			'default' 	=> 50,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$this->controls['toggle_icon_hover'] = [
			'tab' 		=> 'content',
			'group' 	=> 'toggle_icon',
			'label' 	=> esc_html__( 'Hover', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['icon_hbg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-slide-menu-item:hover > {$selector}",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['icon_hclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'type'      => 'color',
			'label'     => esc_html__('Icon Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-slide-menu-item:hover > {$selector}",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['toggle_btn_hborder'] = [
			'tab'   	=> 'content',
			'group' 	=> 'toggle_icon',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' => ".bu-slide-menu-item:hover > {$selector}",
					'property' => 'border',
				],
			],
		];

		$this->controls['toggle_icon_current'] = [
			'tab' 		=> 'content',
			'group' 	=> 'toggle_icon',
			'label' 	=> esc_html__( 'Current/Active Item', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['icon_abg_clr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".current-menu-item > {$selector}",
					'property' 	=> 'background-color'
				],
				[
					'selector' 	=> ".current-menu-ancestor > {$selector}",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['icon_aclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'toggle_icon',
			'type'      => 'color',
			'label'     => esc_html__('Icon Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".current-menu-item > {$selector}",
					'property' 	=> 'color'
				],
				[
					'selector' 	=> ".current-menu-ancestor > {$selector}",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['toggle_btn_aborder'] = [
			'tab'   	=> 'content',
			'group' 	=> 'toggle_icon',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' 	=> ".current-menu-item > {$selector}",
					'property' => 'border',
				],
				[
					'selector' 	=> ".current-menu-ancestor > {$selector}",
					'property' => 'border',
				],
			],
		];

		/*****************
		 * Back button
		 * **************/
		$selector = '.bu-slide-menu-back-arrow';
		$bar_selector = '.bu-slide-menu-back';

		$this->controls['back_text'] = [
			'tab' 		=> 'content',
			'group'		=> 'back_bar',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Back text', 'bricksultimate' ),
			'placeholder' => esc_html__( 'Back', 'bricksultimate' )
		];

		$this->controls['back_text_font'] = [
			'tab'      => 'content',
			'group'    => 'back_bar',
			'label'    => esc_html__( 'Typography', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.bu-menu-sub-item-back',
				],
			]
		];

		$this->controls['back_bar_bg'] = [
			'tab' 		=> 'content',
			'group'    	=> 'back_bar',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $bar_selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['back_bar_hbg'] = [
			'tab' 		=> 'content',
			'group'    	=> 'back_bar',
			'type'      => 'color',
			'label'     => esc_html__('Hover Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $bar_selector . ':hover',
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['back_text_hclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'back_bar',
			'type'      => 'color',
			'label'     => esc_html__('Hover Text Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $bar_selector . ":hover .bu-menu-sub-item-back",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['back_bar_border'] = [
			'tab'   	=> 'content',
			'group' 	=> 'back_bar',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'selector' 	=> $bar_selector,
					'property' => 'border',
				],
			],
		];

		$this->controls['back_text_padding'] = [
			'tab' 		=> 'content',
			'group'    	=> 'back_bar',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => '.bu-menu-sub-item-back',
				]
			],
		];

		$this->controls['back_icon_sep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'back_bar',
			'label' 	=> esc_html__( 'Back Icon', 'bricksultimate' ),
			'type'  	=> 'separator',
		];

		$this->controls['back_arrow_icon'] = [
			'tab'     => 'content',
			'group'   => 'back_bar',
			'type'    => 'icon',
			'label'   => esc_html__( 'Back Icon', 'bricksultimate' ),
			'default' => [
				'icon'    => 'ion-ios-arrow-back',
				'library' => 'ionicons',
			],
		];

		$this->controls['back_icon_width'] = [
			'tab' 		=> 'content',
			'group'    	=> 'back_bar',
			'label' 	=> esc_html__( 'Wrapper Width', 'bricksultimate' ),
			'type'  	=> 'number',
			'min' 		=> 0,
			'units' 	=> true,
			'step' 		=> 1,
			'default' 	=> 50,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$this->controls['back_icon_bg'] = [
			'tab' 		=> 'content',
			'group'    	=> 'back_bar',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['back_icon_size'] = [
			'tab'      => 'content',
			'group'    => 'back_bar',
			'label'    => esc_html__( 'Icon size & color', 'bricksultimate' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'line-height',
				'letter-spacing',
			]
		];

		$this->controls['back_icon_hbg'] = [
			'tab' 		=> 'content',
			'group'    	=> 'back_bar',
			'type'      => 'color',
			'label'     => esc_html__('Hover Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$bar_selector}:hover {$selector}",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['back_icon_hclr'] = [
			'tab' 		=> 'content',
			'group'    	=> 'back_bar',
			'type'      => 'color',
			'label'     => esc_html__('Hover Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$bar_selector}:hover {$selector}",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['back_icon_hbrd'] = [
			'tab' 		=> 'content',
			'group'    	=> 'back_bar',
			'type'      => 'border',
			'label'     => esc_html__('Hover Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$bar_selector}:hover > {$selector}",
					'property' 	=> 'border'
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-sliding-menu', Helpers::get_asset_url('css') . 'slidingmenu.min.css', [], filemtime( Helpers::get_asset_path('css') . 'slidingmenu.min.css'), 'all' );
		}*/
		wp_enqueue_script( 'bu-sliding-menu', Helpers::get_asset_url('js') . 'slidingmenu.min.js', [], filemtime( Helpers::get_asset_path('js') . 'slidingmenu.min.js'), true );
	}

	public function render() {
		$settings = $this->settings;
		$icon_html = $back_arrow_html = '';

		$menuSource = Helpers::get_value( $settings, 'sld_source_menu', 'wpmenu');
		$effect = Helpers::get_value( $settings, 'sld_anim_type', 'overlay' );
		$direction = Helpers::get_value( $settings, 'anim_direction', 'left' );
		$classes = 'bu-sliding-menu-effect-' . $effect . ' bu-sliding-menu-direction-' . $direction;

		$datattr = array();
		$datattr[] = 'data-back-text="' . Helpers::get_value($settings, 'back_text') . '"';
		$datattr[] = 'data-nav-height="' . Helpers::get_value($settings, 'sd_menu_height', 'auto') . '"';
		$datattr[] = 'data-top-level="' . (! empty( $settings['onlyTopLevel'] ) ? 'yes' : 'no') . '"';
		$datattr[] = 'data-sync-selector="' . (! empty( $settings['syncSelectors'] ) ? $settings['syncSelectors'] : 'no') . '"';
		

		if ( isset( $settings['arrow_icon'] ) ) {
			$icon_html = self::render_icon( $settings['arrow_icon'], [ 'icon bu-slide-menu-arrow' ] );
			$icon_html = str_replace( '<i', '<i aria-expanded="false" aria-pressed="false"', $icon_html );
		}

		if ( isset( $settings['back_arrow_icon'] ) ) {
			$back_arrow_html = self::render_icon( $settings['back_arrow_icon'], [ 'icon bu-slide-menu-back-arrow' ] );
		}
		
		echo "<div {$this->render_attributes('_root')}>";

		if( $menuSource == 'wpmenu' ) {
			$sld_menu = Helpers::get_value($settings, 'sld_menu', 'none');
			if( $sld_menu == 'none' || $sld_menu == 'nomenu' ) {
				return $this->render_element_placeholder( ['title' => esc_html__( 'Select a menu.', 'bricksultimate' )] );
			}

			$display_title = ! empty( $settings['display_menu_title'] ) ? true : false;
			if( $display_title ) {
				$tag = Helpers::get_value($settings, 'menu_title_tag', 'h4');
				echo '<' . $tag . ' class="bu-sdmenu-title">'. wp_get_nav_menu_object($sld_menu)->name . '</' . $tag .'>';
			}

			$args = array(
				'echo'        => false,
				'menu'        => $sld_menu,
				'menu_class'  => 'bu-slide-menu-el',
				'menu_id'     => 'bu-menu-' . $this->id,
				'fallback_cb' => '__return_empty_string',
				'before'      => $icon_html,
				'link_before' => '<span itemprop="name">',
				'link_after'  => '</span>',
				'container'   => '',
				'walker' 	=> new BuSlidingNavWalker,
				'back_arrow_icon' => $back_arrow_html
			);

			add_filter( 'nav_menu_link_attributes', array( $this, 'bu_sdmenu_link_attributes' ), 10, 4 );
			add_filter( 'nav_menu_submenu_css_class', array( $this, 'bu_sdmenu_submenu_css_class' ) );
			add_filter( 'nav_menu_css_class', array( $this, 'bu_sdmenu_css_class' ) );

			$menu = '<nav class="'. $classes .'" '. implode(" ", $datattr) .'>';
			$menu .= wp_nav_menu( $args );
			$menu .= '</nav>';

			remove_filter( 'nav_menu_link_attributes', array( $this, 'bu_sdmenu_link_attributes' ), 10, 4 );
			remove_filter( 'nav_menu_submenu_css_class', array( $this, 'bu_sdmenu_submenu_css_class' ) );
			remove_filter( 'nav_menu_css_class', array( $this, 'bu_sdmenu_css_class' ) );

			echo $menu;
		}

		/**
		 * Terms list
		 */
		if( $menuSource == 'tax' ) {
			$taxonomy = Helpers::get_value( $settings, 'sld_tax_name', 'category');

			$args = array(
				'show_option_all'    => '',
				'style'              => 'list',
				'show_count'         => 0,
				'hide_empty'         => 1,
				'hierarchical'       => 1,
				'include'    		 => '',
				'exclude'    		 => '',
				'title_li'           => '',
				'show_option_none'   => '',
				'number'             => null,
				'echo'               => 0,
				'depth'              => 0,
				'current_category'   => 0,
				'pad_counts'         => 0,
				'taxonomy'           => $taxonomy,
				'walker'             => new BuSlidingMenuCategoryWalker
			);

			$include_ids = Helpers::get_value($settings, 'include_ids', false);
			if( $include_ids ) {
				$args['include'] = array_filter( array_map( 'trim', explode( ',', $include_ids ) ) );
			}

			$exclude_ids = Helpers::get_value($settings, 'exclude_ids', false);
			if( $exclude_ids ) {
				$args['exclude'] = array_filter( array_map( 'trim', explode( ',', $exclude_ids ) ) );
			}

			$child_of = Helpers::get_value($settings, 'child_of', false );
			if( $child_of ) {
				$args['child_of'] = absint( $child_of );
			}

			$limit = Helpers::get_value($settings, 'limit', false );
			if( $limit ) {
				$args['number'] = absint( $limit );
			}

			$args['arrow_icon'] = $icon_html;
			$args['back_arrow_icon'] = $back_arrow_html;

			$args['hide_empty'] = ! empty($settings['hide_empty']) ? 1 : 0;
			$args['orderby'] = Helpers::get_value($settings, 'orderby', "name");
			$args['order'] = Helpers::get_value($settings, 'order', "ASC");

			$sm_html = '<nav class="'. $classes .'" '. implode(" ", $datattr) .'>';
			$sm_html .= '<ul id="menu-' . $this->id .'" class="bu-slide-menu-el">';

			do_action( 'bu_before_terms_list', $this );

			if( ! empty( $settings['disableTopParentLink'] ) )
				add_filter('term_link', [$this, 'remove_term_link'], 10, 3 );

			$sm_html .= wp_list_categories( $args );

			if( ! empty( $settings['disableTopParentLink'] ) )
				remove_filter('term_link', [$this, 'remove_term_link'], 10, 3 );

			do_action( 'bu_after_terms_list', $this );

			$sm_html .= '</ul></nav>';

			echo $sm_html;
		}

		echo "</div>";
	}

	function remove_term_link($termlink, $term, $taxonomy) {
		$settings = $this->settings;
		$children = get_term_children( $term->term_id, $taxonomy );
		if( $children )
			$termlink = '#';

		return $termlink;
	}

	function bu_sdmenu_link_attributes( $atts, $item, $args, $depth ) {
		$classes = $depth ? 'bu-slide-menu-item-link bu-slide-menu-sub-item-link' : 'bu-slide-menu-item-link';

		if ( in_array( 'current-menu-item', $item->classes ) ) {
			$classes .= ' bu-slide-menu-item-link-current';
		}

		if ( empty( $atts['class'] ) ) {
			$atts['class'] = $classes;
		} else {
			$atts['class'] .= ' ' . $classes;
		}

		$atts['itemprop'] = 'url';
		if( isset( $item->title ) ) {
			$atts['data-title'] = esc_attr( $item->title );
		}

		return $atts;
	}

	function bu_sdmenu_submenu_css_class( $classes ) {
		$classes[] = 'bu-slide-menu-sub-menu';

		return $classes;
	}

	function bu_sdmenu_css_class( $classes ) {
		$classes[] = 'bu-slide-menu-item';

		if ( in_array( 'menu-item-has-children', $classes ) ) {
			$classes[] = 'bu-slide-menu-item-has-children';
		}

		if ( in_array( 'current-menu-item', $classes ) ) {
			$classes[] = 'bu-slide-menu-item-current';
		}

		return $classes;
	}
}