<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class StarRating extends \Bricks\Element {
	public $category 	= 'ultimate';
	public $name 		= 'bu-star-rating';
	public $icon 		= 'ti-star';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Star Ratings', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['rating_points'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Rating points', 'bricksultimate' ),
			'placeholder' => esc_html__( '3.7', 'bricksultimate' ),
		];

		$this->controls['displayStars'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Display stars', 'bricksultimate'),
			'options' 	=> [ 
				'full' => esc_html__('With empty stars', 'bricksultimate' ), 
				'noempty' => esc_html__('Without empty stars', 'bricksultimate' )
			],
			'default' 	=> 'full'
		];

		$this->controls['aria_label'] = [
			'tab' 		=> 'content',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Aria label', 'bricksultimate' ),
			'placeholder' => esc_html__( 'Rating of this product is 3.7 out of 5.', 'bricksultimate' ),
		];

		$this->controls['fillStarsColor'] = [
			'tab' 		=> 'content',
			'type'      => 'color',
			'label'     => esc_html__('Fill stars color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'property' 	=> '--star-background'
				]
			]
		];

		$this->controls['emptyStarsColor'] = [
			'tab' 		=> 'content',
			'type'      => 'color',
			'label'     => esc_html__('Empty stars Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'property' 	=> '--star-color'
				]
			]
		];

		$this->controls['starsSize'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Stars Size', 'bricks' ),
			'type'  	=> 'number',
			'min' 		=> 0,
			'units' 	=> true,
			'step' 		=> 1,
			'default' 	=> 20,
			'css'   	=> [
				[
					'property' => 'font-size',
				]
			],
		];

		$this->controls['gapStars'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Space between stars', 'bricks' ),
			'type'  	=> 'number',
			'min' 		=> 0,
			'max' 		=> 20,
			'units' 	=> true,
			'step' 		=> 1,
			'default' 	=> 3,
			'css'   	=> [
				[
					'property' => 'letter-spacing',
					'selector' => '&:before',
				],
				[
					'property' => '--gap-stars',
					'selector' => '',
				]
			],
		];
	}

	// Enqueue element styles and scripts
	/*public function enqueue_scripts() {
		wp_enqueue_style( 'bu-stars-rating', Helpers::get_asset_url('css') . 'starratings.min.css', [], filemtime(Helpers::get_asset_path('css') . 'starratings.min.css'), 'all' );
	}*/

	// Render element HTML
	public function render() {
		$settings = $this->settings;
		$ratings = Helpers::get_value( $settings, 'rating_points', 3.7 );
		$starRating = strstr( $ratings, '{') ? $this->render_dynamic_data( $ratings ) : $ratings;
		$aria = Helpers::get_value( $settings, 'aria_label', false );
		$displayStars = Helpers::get_value( $settings, 'displayStars', 'full' );

		if( $displayStars == 'full' ) {
			$this->set_attribute( '_root', 'class', 'stars-full' );
		} else {
			$this->set_attribute( '_root', 'class', 'stars-no-empty' );
		}

		if( $aria ) {
			$this->set_attribute( '_root', 'aria-label', esc_attr__($aria) );
		}

		$this->set_attribute( '_root', 'style', '--rating:' . $starRating );
		echo "<div {$this->render_attributes('_root')}></div>";
	}
}