<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class Table extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-table';
	public $icon 			= 'ti-layout-grid4-alt';
	public $scripts 		= ['buTable'];
 	public $tag 			= 'table';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Table', 'bricksultimate' );
	}

	public function set_control_groups() {
		$this->control_groups['table_header'] = [
			'tab' => 'content',
			'title' => esc_html__( 'Header', 'bricksultimate' )
		];

		$this->control_groups['rows_cols'] = [
			'tab' => 'content',
			'title' => esc_html__( 'Row/Cell', 'bricksultimate' )
		];

		$this->control_groups['sticky_header'] = [
			'tab' => 'content',
			'title' => esc_html__( 'Sticky Header', 'bricksultimate' )
		];

		$this->control_groups['col_stack'] = [
			'tab' => 'content',
			'title' => esc_html__( 'Stack Vertically', 'bricksultimate' )
		];
	}

	public function set_controls() {
		$this->controls['table_layout'] = [
			'label' => esc_html__( 'Table layout', 'bricksultimate' ),
			'type' => 'select',
			'options' => [
				'auto' 	=> esc_html__( 'Auto', 'bricksultimate' ),
				'fixed' => esc_html__( 'Fixed', 'bricksultimate' )
			],
			'inline' => true,
			'css' => [
				[
					'property' => 'table-layout',
				]
			]
		];

		$this->controls['removeBorders'] = [
			'label' => esc_html__( 'Remove all borders', 'bricksultimate' ),
			'type' => 'checkbox',
			'css' => [
				[
					'property' 	=> 'border',
					'selector' 	=> '&:not(.stacked)',
					'value' 	=> '0'
				],
				[
					'property' 	=> 'border',
					'selector' 	=> '&:not(.stacked) td,&:not(.stacked) th',
					'value' 	=> '0'
				]
			],
		];

		$this->controls['removeVBorders'] = [
			'label' => esc_html__( 'Remove vertical lines', 'bricksultimate' ),
			'type' => 'checkbox',
			'css' => [
				[
					'property' 	=> 'border-left',
					'selector' 	=> '&:not(.stacked) td,&:not(.stacked) th',
					'value' 	=> '0'
				],
				[
					'property' 	=> 'border-right',
					'selector' 	=> '&:not(.stacked) td,&:not(.stacked) th',
					'value' 	=> '0'
				]
			],
		];

		$this->controls['removeHBorders'] = [
			'label' => esc_html__( 'Remove horizontal lines', 'bricksultimate' ),
			'type' => 'checkbox',
			'css' => [
				[
					'property' 	=> 'border-top',
					'selector' 	=> '&:not(.stacked) td,&:not(.stacked) th',
					'value' 	=> '0'
				],
				[
					'property' 	=> 'border-bottom',
					'selector' 	=> '&:not(.stacked) td,&:not(.stacked) th',
					'value' 	=> '0'
				]
			],
		];

		$this->controls['header_bg'] = [
			'label' => esc_html__( 'Background', 'bricks' ),
			'group'	=> 'table_header',
			'type' => 'color',
			'inline' => true,
			'css' => [
			  [
				'property' => 'background-color',
				'selector' => 'th',
			  ],
			  [
				'property' => 'background-color',
				'selector' => '&.stacked td:before',
			  ]
			],
		  ];

		  $this->controls['header_typography'] = [
			'group'  => 'table_header',
			'type'   => 'typography',
			'label'  => esc_html__( 'Typography', 'bricks' ),
			'css'    => [
				[
					'property' => 'font',
					'selector' => 'th',
				],
				[
					'property' => 'font',
					'selector' => '&.stacked td:before',
				]
			],
		];

		$this->controls['header_padding'] = [
			'group'	=> 'table_header',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type' => 'dimensions',
			'css' => [
				[
					'property' => 'padding',
					'selector' => 'th',
				]
			],
		];

		$this->controls['rowTg'] = [
			'group'	=> 'rows_cols',
			'label'  => esc_html__( 'Typography', 'bricks' ),
			'type'   => 'typography',
			'css'    => [
				[
					'property' => 'font',
					'selector' => 'td',
				],
			],
		];

		$this->controls['rowBg'] = [
			'group'	=> 'rows_cols',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type' => 'color',
			'css' => [
				[
					'property' => 'background-color',
					'selector' => 'td',
				]
			],
		];

		$this->controls['rowBgEven'] = [
			'group'	=> 'rows_cols',
			'label' => esc_html__( 'Background (even)', 'bricksultimate' ),
			'type' => 'color',
			'css' => [
				[
					'property' => 'background-color',
					'selector' => 'tr:nth-child(even) td',
				]
			],
		];

		$this->controls['textColor'] = [
			'group'	=> 'rows_cols',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'type' => 'color',
			'css' => [
				[
					'property' => 'color',
					'selector' => 'td',
				]
			],
		];

		$this->controls['textColorEven'] = [
			'group'	=> 'rows_cols',
			'label' => esc_html__( 'Text color (even)', 'bricksultimate' ),
			'type' => 'color',
			'css' => [
				[
					'property' => 'color',
					'selector' => '.tr:nth-child(even) td',
				]
			],
		];

		$this->controls['cellBrd'] = [
			'group'	=> 'rows_cols',
			'label' => esc_html__( 'Cell border color', 'bricksultimate' ),
			'type' => 'color',
			'css' => [
				[
				'property' => '--bricks-border-color',
				]
			]
		];

		$this->controls['cellBrdCollapsed'] = [
			'group'	=> 'rows_cols',
			'label' => esc_html__( 'border-collapse', 'bricksultimate' ),
			'type' => 'checkbox',
			'default' => true,
		];

		$this->controls['cellBrdSpacing'] = [
			'group'	=> 'rows_cols',
			'label' => esc_html__( 'border-spacing', 'bricksultimate' ),
			'type' => 'number',
			'units' => true,
			'default' => '4px',
			'css' => [
				[
					'property' => 'border-spacing',
				]
			],
			'required' => ['cellBrdCollapsed', '=', false]
		];

		$this->controls['rowPadding'] = [
			'group'	=> 'rows_cols',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type' => 'dimensions',
			'css' => [
				[
					'property' => 'padding',
					'selector' => 'td',
				]
			]
		];

		$this->controls['rowMinHeight'] = [
			'group'	=> 'rows_cols',
			'label' => esc_html__( 'Row height (fixed)', 'bricksultimate' ),
			'type' => 'number',
			'units' => true,
			'css' => [
				[
					'property' => 'height',
					'selector' => 'td',
				]
			],
		];

		$this->controls['stickyInfo'] = [
			'group'   => 'sticky_header',
			'label'   => esc_html__( 'Note:', 'bricks' ),
			'type'    => 'info',
			'content' => esc_html__( "Sticky position can't be used inside containers using the overflow property", 'bricksultimate' ),
		];

		$this->controls['position'] = [
			'group'   => 'sticky_header',
			'label'   => esc_html__( 'Position', 'bricks' ),
			'type'    => 'select',
			'options' => [
				'sticky' => 'Sticky',
				'static' => 'Static',
			],
			'inline'  => true,
			'css'     => [
				[
					'property' => 'position',
					'selector' => 'thead:not(.stacked thead)',
				],
			],
		];

		$this->controls['posTop'] = [
			'group'   => 'sticky_header',
			'label'   => esc_html__( 'Top (offset)', 'bricks' ),
			'type'    => 'number',
			'placeholder' => '0',
			'css'     => [
				[
					'property' => 'top',
					'selector' => 'thead:not(.stacked thead)',
				],
			],
			'required' => [ 'position', '=', 'sticky' ],
		];

		$breakpointOptions['none'] = 'None';

		foreach ( \Bricks\Breakpoints::$breakpoints as $breakpoint ) {
			$breakpointOptions[$breakpoint['width']] = $breakpoint['label'] . ' (<= ' . $breakpoint['width'] . 'px )';
		}

		$this->controls['isStackVertically'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Breakpoint', 'bricks' ),
			'type' => 'select',
			'options' => $breakpointOptions,
			'placeholder' => esc_html__('None')
		];

		$this->controls['rowGap'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Row gap', 'bricksultimate' ),
			'type' => 'number',
			'inline' => true,
			'units' => true,
			'placeholder' => '10px',
			'css' => [
				[
				  'property' => 'gap',
				  'selector' => '&.stacked tbody',
				]
			],
		];

		$this->controls['goNextLine'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Cell content on new line', 'bricksultimate' ),
			'type' => 'checkbox'
		];

		$this->controls['cellsSep'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Cells', 'bricksultimate' ),
			'type' => 'separator',
		];

		$this->controls['cellPadLeft'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Padding-left', 'bricksultimate' ),
			'type' => 'number',
			'min' => 0,
			'max' => 1000,
			'units' => true,
			'inline' => true,
			'placeholder' => '150px',
			'css' => [
				[
					'property' => 'padding-left',
					'selector' => '&:not([data-table-config*=goNextLine]).stacked td',
				]
			],
			'required' => [ 'goNextLine', '!=', true ],
		];

		$selector = '&.stacked td';

		$this->controls['stackCellTg'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type' => 'typography',
			'css' => [
				[
				  'property' => 'font',
				  'selector' => $selector,
				]
			]
		];

		$this->controls['cellAlign'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Align', 'bricks' ),
			'type' => 'text-align',
			'units' => true,
			'css' => [
				[
					'property' => 'text-align',
					'selector' => $selector,
				],
				[
					'property' => 'align-items',
					'selector' => $selector,
					'value'    => 'flex-start',
					'required' => 'left',
				],
				[
					'property' => 'align-items',
					'selector' => $selector,
					'value'    => 'center',
					'required' => 'center',
				],
				[
					'property' => 'align-items',
					'selector' => $selector,
					'value'    => 'flex-end',
					'required' => 'right',
				],
			],
			'exclude' => [
				'justify',
			],
		];

		$this->controls['contentPadding'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Content padding', 'bricksultimate' ),
			'type' => 'dimensions',
			'css' => [
				[
					'property' => 'padding',
					'selector' => '&[data-table-config*=goNextLine].stacked td span',
				],
				[
					'property' => 'padding',
					'selector' => '&[data-table-config*=goNextLine].stacked td > div',
				]
			],
			'required' => [ 'goNextLine', '=', true ]
		];

		$this->controls['stackTitleSep'] = [
			'group'	=> 'col_stack',
			'type'  => 'separator',
			'label' => esc_html__( 'Column title', 'bricksultimate' ),
		];

		$this->controls['stackCellWidth'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type' => 'number',
			'css' => [
				[
				  'property' => 'width',
				  'selector' => '&:not([data-table-config*=goNextLine]).stacked td:before',
				]
			],
			'required' => [ 'goNextLine', '!=', true ]
		];

		$this->controls['stackCellMinW'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Min-width', 'bricks' ),
			'type' => 'number',
			'placeholder' => '150px',
			'css' => [
				[
					'property' => 'min-width',
					'selector' => '&:not([data-table-config*=goNextLine]).stacked td:before',
				]
			],
			'required' => [ 'goNextLine', '=', false ]
		];

		$this->controls['stackCellHBg'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Background color', 'bricks' ),
			'type' => 'color',
			'css' => [
				[
				  'property' => 'background-color',
				  'selector' => '&.stacked td:before',
				]
			]
		];

		$this->controls['stackCellHTg'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type' => 'typography',
			'css' => [
				[
				  'property' => 'font',
				  'selector' => '&.stacked td:before',
				]
			],
			'exclude' => [
				'text-align'
			]
		];

		$this->controls['alignTitle'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Vertical Align', 'bricksultimate' ),
			'type' => 'select',
			'options' => [
				'flex-start' => esc_html__( 'Flex start', 'bricks' ),
				'center' => esc_html__( 'Center', 'bricks' ),
				'flex-end' => esc_html__( 'Flex end', 'bricks' ),
			],
			'inline' => true,
			'placeholder' => esc_html__( 'Center', 'bricks' ),
			'css' => [
				[
					'property' => 'align-items',
					'selector' => '&.stacked td:before',
				]
			],
			'required' => [ 'goNextLine', '=', false ]
		];

		$this->controls['stackCellPadding'] = [
			'group'	=> 'col_stack',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type' => 'dimensions',
			'css' => [
				[
					'property' => 'padding',
					'selector' => '&.stacked td:before',
				]
			],
		];
	}

	public function get_nestable_children() {
		return [
			[
				'name' => 'div',
				'label' => esc_html__( 'Head', 'bricks' ),
				'cloneable' => false,	
				'settings' => [
					'tag' => 'custom',
					'customTag' => 'thead'
				],
				'children' => [
					[
						'name' => 'div',
						'label' => esc_html__( 'Row', 'bricks' ),
						'cloneable' => false,
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'tr'
						],
						'children' => [
							[
								'name' => 'div',
								'label' => esc_html__( 'Cell', 'bricks' ),
								'settings' => [
									'tag' => 'custom',
									'customTag' => 'th',
								],
								'children' => [
									[
										'name' => 'text-basic',
										'settings' => [
											'text' => esc_html__( 'First Name', 'bricks' ),
											'tag' 	=> 'span'
										]
									]
								]
							],
							[
								'name' => 'div',
								'label' => esc_html__( 'Cell', 'bricks' ),
								'settings' => [
									'tag' => 'custom',
									'customTag' => 'th',
								],
								'children' => [
									[
										'name' => 'text-basic',
										'settings' => [
											'text' => esc_html__( 'Last Name', 'bricks' ),
											'tag' 	=> 'span'
										]
									]
								]
							],
						],
					],
				],
			],
			[
				'name' => 'div',
				'label' => esc_html__( 'Body', 'bricks' ),
				'cloneable' => false,
				'settings' => [
					'tag' => 'custom',
					'customTag' => 'tbody'
				],
				'children' => [
					[
						'name' => 'div',
						'label' => esc_html__( 'Row', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'tr'
						],
						'children' => [
							[
								'name' => 'div',
								'label' => esc_html__( 'Cell', 'bricks' ),
								'settings' => [
									'tag' => 'custom',
									'customTag' => 'td',
								],
								'children' => [
									[
									'name' => 'text-basic',
									'settings' => [
										'text' => esc_html__( 'Jhon', 'bricks' ),
										'tag' 	=> 'span'
										]
									]
								]
							],
							[
								'name' => 'div',
								'label' => esc_html__( 'Cell', 'bricks' ),
								'settings' => [
									'tag' => 'custom',
									'customTag' => 'td',
								],
								'children' => [
									[
										'name' => 'text-basic',
										'settings' => [
											'text' => esc_html__( 'Doe', 'bricks' ),
											'tag' 	=> 'span'
										]
									]
								]
							],
						]
					],
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_style( 'bu-table', Helpers::get_asset_url('css') . 'butable.min.css', [], filemtime(Helpers::get_asset_path('css') . 'butable.min.css'), 'all' );
		
		if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_script( 'bu-table', Helpers::get_asset_url('js') . 'butable.min.js', [], filemtime(Helpers::get_asset_path('js') . 'butable.min.js'), true );
		}
		
		if( isset( $this->settings['isStackVertically'] ) && $this->settings['isStackVertically'] != 'none' ) {
			wp_enqueue_script( 'bu-table', Helpers::get_asset_url('js') . 'butable.min.js', [], filemtime(Helpers::get_asset_path('js') . 'butable.min.js'), true );
		}
	}

	public function render() {
		$settings = $this->settings;
		$data = [
			'breakpoint' => isset( $settings['isStackVertically'] ) ? $settings['isStackVertically'] : 'none',
		];

		if ( isset( $settings['goNextLine'] ) ) {
			$data['goNextLine'] = "yes";
		}

		$this->set_attribute( '_root', 'data-table-config', wp_json_encode( $data ) );
		
		if( ! empty( $settings['cellBrdCollapsed'] ) )
			$this->set_attribute( '_root', 'class', ['border-collapsed'] );

		$tag = Helpers::isBricksBuilderEditor() ? 'div' : $this->tag;

		echo "<{$tag} {$this->render_attributes( '_root' )}>";
		echo \Bricks\Frontend::render_children( $this );
		echo "</{$tag}>";

	}
}