<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

class TemplateFive extends \Bricks\Element_Container {
	public $category 		= 'css-grid';
	public $name 			= 'bucg-tfive';
	public $icon 			= 'ti-layout-grid3';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( 'Template Five', 'bricksultimate' );
	}

	public function set_controls() {
		parent::set_controls();

		$this->controls['_display']['default'] = 'grid';
		$this->controls['_gridGap']['default'] = 5;
		$this->controls['_gridTemplateColumns']['default'] = 'repeat(5, 1fr)';
		$this->controls['_gridTemplateRows']['default'] = 5;
		$this->controls['_gridTemplateColumns:mobile_landscape']['default'] = 'repeat(1, 1fr)';
		$this->controls['_gridTemplateRows:mobile_landscape']['default'] = 'repeat(11, 1fr)';
		$this->controls['_width']['default'] = '100%';
	}

	public function get_nestable_item() {
		return [
				[
					'name' => 'block',
					'label' => esc_html__( '1st Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '1 / 3',
						'_gridItemColumnSpan:mobile_landscape' => 'auto / auto',
					]
				],
				[
					'name' => 'block',
					'label' => esc_html__('2nd Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__( '3rd Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '4 / 6',
						'_gridItemColumnSpan:mobile_landscape' => 'auto / auto',
					]
				],
				[
					'name' => 'block',
					'label' => esc_html__('4th Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('5th Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '2 / 5',
						'_gridItemRowSpan' => '2 / 4',
						'_gridItemColumnSpan:mobile_landscape' => 'auto / auto',
						'_gridItemRowSpan:mobile_landscape' => 'auto / auto',
					]
				],
				[
					'name' => 'block',
					'label' => esc_html__('6th Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('7th Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('8th Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__( '9th Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '1 / 3',
						'_gridItemColumnSpan:mobile_landscape' => 'auto / auto',
					]
				],
				[
					'name' => 'block',
					'label' => esc_html__('10th Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__( '11th Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '4 / 6',
						'_gridItemColumnSpan:mobile_landscape' => 'auto / auto',
					]
				],
		];
	}

	public function get_nestable_children() {
		return $this->get_nestable_item();
	}
}