<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

class TemplateSix extends \Bricks\Element_Container {
	public $category 		= 'css-grid';
	public $name 			= 'bucg-tsix';
	public $icon 			= 'ti-layout-grid3';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( 'Template Six', 'bricksultimate' );
	}

	public function set_controls() {
		parent::set_controls();

		$this->controls['_display']['default'] = 'grid';
		$this->controls['_gridGap']['default'] = 5;
		$this->controls['_gridTemplateColumns']['default'] = 'repeat(4, 1fr)';
		$this->controls['_gridTemplateRows']['default'] = 4;
		$this->controls['_width']['default'] = '100%';
	}

	public function get_nestable_item() {
		return [
				[
					'name' => 'block',
					'label' => esc_html__( '1st Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '1 / 4',
						'_gridItemRowSpan' => '1 / 3',
					]
				],
				[
					'name' => 'block',
					'label' => esc_html__('2nd Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('3rd Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__( '4th Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('5th Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('6th Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '2 / 5',
						'_gridItemRowSpan' => '3 / 5',
					]
				]
		];
	}

	public function get_nestable_children() {
		return $this->get_nestable_item();
	}
}