<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

class TemplateThree extends \Bricks\Element_Container {
	public $category 		= 'css-grid';
	public $name 			= 'bucg-tthree';
	public $icon 			= 'ti-layout-grid3';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( 'Template Three', 'bricksultimate' );
	}

	public function set_controls() {
		parent::set_controls();

		$this->controls['_display']['default'] = 'grid';
		$this->controls['_gridGap']['default'] = 5;
		$this->controls['_gridTemplateColumns']['default'] = 'repeat(3, 1fr)';
		$this->controls['_gridTemplateColumns:mobile_landscape']['default'] = 'repeat(1, 1fr)';
		$this->controls['_gridTemplateRows:mobile_landscape']['default'] = 'repeat(6, 1fr)';
		$this->controls['_gridTemplateRows']['default'] = 3;
		$this->controls['_width']['default'] = '100%';
	}

	public function get_nestable_item() {
		return [
				[
					'name' => 'block',
					'label' => esc_html__('1st Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__( '2nd Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '2 / 4',
						'_gridItemColumnSpan:mobile_landscape' => 'auto / auto',
					]
				],
				[
					'name' => 'block',
					'label' => esc_html__('3rd Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '1 / 3',
						'_gridItemColumnSpan:mobile_landscape' => 'auto / auto',
					]
				],
				[
					'name' => 'block',
					'label' => esc_html__('4th Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('5th Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__( '6th Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '2 / 4',
						'_gridItemColumnSpan:mobile_landscape' => 'auto / auto',
					]
				],
		];
	}

	public function get_nestable_children() {
		return $this->get_nestable_item();
	}
}