<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

class TemplateTwo extends \Bricks\Element_Container {
	public $category 		= 'css-grid';
	public $name 			= 'bucg-ttwo';
	public $icon 			= 'ti-layout-grid3';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( 'Template Two', 'bricksultimate' );
	}

	public function set_controls() {
		parent::set_controls();

		$this->controls['_display']['default'] = 'grid';
		$this->controls['_gridGap']['default'] = 5;
		$this->controls['_gridTemplateColumns']['default'] = 'repeat(3, 1fr)';
		$this->controls['_gridTemplateColumns:mobile_landscape']['default'] = 'repeat(1, 1fr)';
		$this->controls['_gridTemplateRows']['default'] = 2;
		$this->controls['_width']['default'] = '100%';
	}

	public function get_nestable_item() {
		return [
				[
					'name' => 'block',
					'label' => esc_html__( 'Column', 'bricksultimate' ),
					'settings' => [
						'_gridItemColumnSpan' => '1 / 3',
						'_gridItemRowSpan' => '1 / 3',
						'_gridItemColumnSpan:mobile_landscape' => 'auto / auto',
						'_gridItemRowSpan:mobile_landscape' => 'auto / auto',
					]
				],
				[
					'name' => 'block',
					'label' => esc_html__('Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('Column', 'bricksultimate' ),
				]
		];
	}

	public function get_nestable_children() {
		return $this->get_nestable_item();
	}
}