<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class UltimateCartItems extends \Bricks\Woocommerce_Cart_Items {
	public function add_filters() {
		add_filter('gettext', [ $this, 'translate_text' ], 9, 3 );
	}

	public function translate_text( $translated_text, $text, $domain ) {
		switch( $translated_text ) {
			case 'Update cart' : 
				$translated_text = isset( $this->settings['updateCartText'] ) ? esc_attr( $this->settings['updateCartText'] ) : $translated_text;
				break;

			case 'Apply coupon' : 
				$translated_text = isset( $this->settings['applyCouponText'] ) ? esc_attr( $this->settings['applyCouponText'] ) : $translated_text;
				break;

			case 'Coupon code' : 
				$translated_text = isset( $this->settings['cpfText'] ) ? esc_attr( $this->settings['cpfText'] ) : $translated_text;
				break;
		}

		return $translated_text;
	}
}