<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WSFormsStyler extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-wsf-styler';
	public $icon 			= 'ti-layout-accordion-merged';
	public $tag 			= 'div';

	public function __construct($element = null) {

		if(bricks_is_builder()) {

			$this->scripts = ['wsf_form_init'];
		}

		parent::__construct($element);
	}

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)WSForms Styler', 'bricksultimate' );
	}

	public function set_control_groups() {
		$this->control_groups['section']    = array(
			'title' => esc_html__( 'Sections', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['label']    = array(
			'title' => esc_html__( 'Fields Label', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['input']  = array(
			'title' => esc_html__( 'Input & Textarea', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['prefix']  = array(
			'title' => esc_html__( 'Prefix - Suffix', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['cb']  = array(
			'title' => esc_html__( 'Checkbox', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['radio']  = array(
			'title' => esc_html__( 'Radio', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['progress']  = array(
			'title' => esc_html__( 'Progress Bar', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['meter']  = array(
			'title' => esc_html__( 'Meter', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['range']  = array(
			'title' => esc_html__( 'Range Slider', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['rating']  = array(
			'title' => esc_html__( 'Rating', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['file']  = array(
			'title' => esc_html__( 'File Upload', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['spacer']  = array(
			'title' => esc_html__( 'Divider / Sapcer', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['tabs']  = array(
			'title' => esc_html__( 'Tabs', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['button'] = array(
			'title' => esc_html__( 'Buttons', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['clear'] = array(
			'title' => esc_html__( 'Clear Button', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['reset'] = array(
			'title' => esc_html__( 'Reset Button', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['msg'] = array(
			'title' => esc_html__( 'Message', 'bricksultimate' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['wsfInfo'] = [
			'tab' 		=> 'content',
			'type' 		=> 'info',
			'content' 	=> esc_html__( "Create a form with WSForms plugin before using this element.", 'bricksultimate' ),
		];

		$this->controls['source_type'] = [
			'tab' 		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__( 'Source Type', 'bricksultimate' ),
			'default' 	=> 'static',
			'options' 	=> [
				'static' 	=> esc_html__('Choose from dropwdown', 'bricksultimate'),
				'dynamic' 	=> esc_html__( 'Custom Field', 'bricksultimate'),
			],
		];

		$this->controls['wsform'] = [
			'tab' 			=> 'content',
			'type' 			=> 'select',
			'label' 		=> esc_html__( 'Form', 'bricksultimate' ),
			'options' 		=> $this->getWSForms(),
			'default' 		=> 'none',
			'required'		=> [ 'source_type', '=', [ 'static' ] ],
			'placeholder' 	=> esc_html__('Select a WSForms', 'bricksultimate'),
		];

		$this->controls['custom_field'] = [
			'tab' 			=> 'content',
			'type' 			=> 'text',
			'label' 		=> esc_html__( 'Custom Field Name', 'bricksultimate' ),
			'info' 			=> __( "Make sure that it returns the WSForms ID.", 'bricksultimate' ),
			'placeholder' 	=> esc_html__('Enter custom field key', 'bricksultimate'),
			'hasDynamicData' => true,
			'required'		=> [ 'source_type', '=', [ 'dynamic' ] ],
		];

		$this->sectionsControls();
		$this->labelsControls();
		$this->inputControls();
		$this->prefixControls();
		$this->checkboxControls();
		$this->radioControls();
		$this->pgbmrControls();
		$this->ratingControls();
		$this->fileControls();
		$this->spacerControls();
		$this->tabsControls();
		$this->buttonControls();
		$this->clearControls();
		$this->resetControls();
		$this->messageControls();
	}

	public function sectionsControls() {
		$selector = '.wsf-section';
		$this->controls['sectionBG'] = [
			'group' 	=> 'section',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['sectionABG'] = [
			'group' 	=> 'section',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Alt background color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'background-color',
					'selector' => $selector . ":nth-child(2n+2)"
				]
			],
		];

		$this->controls['sectionBrd'] = [
			'group' 	=> 'section',
			'type' 		=> 'border',
			'label' 	=> esc_html__( 'Borders', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$this->controls['sectionMrg'] = [
			'group' 	=> 'section',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Margin', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			],
		];

		$this->controls['sectionPad'] = [
			'group' 	=> 'section',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$this->controls['sectionSep'] = [
			'group' 	=> 'section',
			'type' 		=> 'separator',
			'label' 	=> esc_html__( 'Labels', 'bricksultimate' ),
		];

		$this->controls['sectionLblTg'] = [
			'group' 	=> 'section',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'font',
					'selector' => '.wsf-section > legend'
				],
				[
					'property' => 'font',
					'selector' => '.wsf-fieldset > legend'
				]
			],
		];

		$this->controls['sectionLblBg'] = [
			'group' 	=> 'section',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'background-color',
					'selector' => '.wsf-section > legend'
				],
				[
					'property' => 'background-color',
					'selector' => '.wsf-fieldset > legend'
				]
			],
		];

		$this->controls['sectionLblBrd'] = [
			'group' 	=> 'section',
			'type' 		=> 'border',
			'label' 	=> esc_html__( 'Borders', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'border',
					'selector' => '.wsf-section > legend'
				],
				[
					'property' => 'border',
					'selector' => '.wsf-fieldset > legend'
				]
			],
		];

		$this->controls['sectionLblW'] = [
			'group' 	=> 'section',
			'type' 		=> 'number',
			'units' 	=> true,
			'label' 	=> esc_html__( 'Width', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'width',
					'selector' => '.wsf-section > legend'
				],
				[
					'property' => 'width',
					'selector' => '.wsf-fieldset > legend'
				]
			],
		];

		$this->controls['sectionLblMrg'] = [
			'group' 	=> 'section',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Margin', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'margin',
					'selector' => '.wsf-section > legend'
				],
				[
					'property' => 'margin',
					'selector' => '.wsf-fieldset > legend'
				]
			],
		];

		$this->controls['sectionLblPad'] = [
			'group' 	=> 'section',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'padding',
					'selector' => '.wsf-section > legend'
				],
				[
					'property' => 'padding',
					'selector' => '.wsf-fieldset > legend'
				]
			],
		];
	}

	public function labelsControls() {

		$selector = '.wsf-field-wrapper > .wsf-label';
		$this->controls['labelTypography'] = [
			'group' 	=> 'label',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$this->controls['astTypography'] = [
			'group' 	=> 'label',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Asterisk', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'font',
					'selector' => '.wsf-required-wrapper .wsf-text-danger'
				]
			],
			'exclude' => [
				'text-transform',
				'text-align',
				'text-decoration',
				'letter-spacing',
				'text-shadow'
			]
		];

		$this->controls['helpText'] = [
			'group' 	=> 'label',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Help text', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'font',
					'selector' => '.wsf-help'
				]
			],
		];

		$this->controls['labelSep'] = [
			'group' 	=> 'label',
			'type' 		=> 'separator',
		];

		$this->controls['labelBG'] = [
			'group' 	=> 'label',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['labelBrd'] = [
			'group' 	=> 'label',
			'type' 		=> 'border',
			'label' 	=> esc_html__( 'Borders', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$this->controls['labelWidth'] = [
			'group' 	=> 'label',
			'type' 		=> 'number',
			'units' 	=> true,
			'label' 	=> esc_html__( 'Width', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			],
		];

		$this->controls['labelMrg'] = [
			'group' 	=> 'label',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Margin', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			],
		];

		$this->controls['labelPad'] = [
			'group' 	=> 'label',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$this->controls['labelSepReq'] = [
			'group' 	=> 'label',
			'type' 		=> 'separator',
			'label' 	=> esc_html__( 'Required Text', 'bricksultimate' ),
		];

		$selector = '.wsf-invalid-feedback';

		$this->controls['reqTypography'] = [
			'group' 	=> 'label',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$this->controls['reqMrg'] = [
			'group' 	=> 'label',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Margin', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			],
		];

		$this->controls['reqPad'] = [
			'group' 	=> 'label',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];
	}

	public function inputControls() {
		$selector = '.wsf-field';

		$this->controls['inpPlaceholder'] = [
			'group' 	=> 'input',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Placeholder', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'color',
					'selector' => 'input[type=email].wsf-field::placeholder, 
									input[type=number].wsf-field::placeholder, 
									input[type=tel].wsf-field::placeholder, 
									input[type=text].wsf-field::placeholder, 
									input[type=url].wsf-field::placeholder, 
									select.wsf-field::placeholder, 
									textarea.wsf-field::placeholder'
				]
			],
		];

		$this->controls['inpBG'] = [
			'group' 	=> 'input',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];
		
		$this->controls['inpTypography'] = [
			'group' 	=> 'input',
			'type' 		=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpBorder'] = [
			'group' 	=> 'input',
			'type' 		=> 'border',
			'label' 	=> esc_html__( 'Borders', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpBs'] = [
			'group' 	=> 'input',
			'type' 		=> 'box-shadow',
			'label' 	=> esc_html__( 'Box shadow', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpSep'] = [
			'group' 	=> 'input',
			'type' 		=> 'separator',
		];

		$this->controls['inpGap'] = [
			'group' 	=> 'input',
			'type' 		=> 'number',
			'units' 	=> true,
			'label' 	=> esc_html__( 'Row gap', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'margin-bottom',
					'selector' => '.wsf-field-wrapper'
				]
			],
		];

		$this->controls['inpWidth'] = [
			'group' 	=> 'input',
			'type' 		=> 'number',
			'units' 	=> true,
			'label' 	=> esc_html__( 'Width', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'width',
					'selector' => 'input[type=email].wsf-field, 
									input[type=number].wsf-field, 
									input[type=tel].wsf-field, 
									input[type=text].wsf-field, 
									input[type=url].wsf-field, 
									select.wsf-field:not([multiple]):not([size])'
				]
			],
		];

		$this->controls['inpHeight'] = [
			'group' 	=> 'input',
			'type' 		=> 'number',
			'units' 	=> true,
			'label' 	=> esc_html__( 'Height', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'height',
					'selector' => 'input[type=email].wsf-field, 
									input[type=number].wsf-field, 
									input[type=tel].wsf-field, 
									input[type=text].wsf-field, 
									input[type=url].wsf-field, 
									select.wsf-field:not([multiple]):not([size])'
				]
			],
		];

		$this->controls['inpMrg'] = [
			'group' 	=> 'input',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Margin', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpPad'] = [
			'group' 	=> 'input',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpFocus'] = [
			'group' 	=> 'input',
			'type' 		=> 'separator',
			'label' 	=> esc_html__( 'Focus', 'bricksultimate' ),
		];

		$selector = 'input[type=email].wsf-field:focus, 
					input[type=number].wsf-field:focus, 
					input[type=tel].wsf-field:focus, 
					input[type=text].wsf-field:focus, 
					input[type=url].wsf-field:focus, 
					select.wsf-field:focus, textarea.wsf-field:focus';

		$this->controls['inpFocusBG'] = [
			'group' 	=> 'input',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpFocusColor'] = [
			'group' 	=> 'input',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Text color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'color',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpFocusBorder'] = [
			'group' 	=> 'input',
			'type' 		=> 'border',
			'label' 	=> esc_html__( 'Borders', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpFocusBs'] = [
			'group' 	=> 'input',
			'type' 		=> 'box-shadow',
			'label' 	=> esc_html__( 'Box shadow', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpSepReq'] = [
			'group' 	=> 'input',
			'type' 		=> 'separator',
			'label' 	=> esc_html__( 'Required Fields', 'bricksultimate' ),
		];

		$selector = '.wsf-validated input[type=date].wsf-field:invalid, 
					.wsf-validated input[type=datetime-local].wsf-field:invalid, 
					.wsf-validated input[type=file].wsf-field:invalid, 
					.wsf-validated input[type=month].wsf-field:invalid, 
					.wsf-validated input[type=password].wsf-field:invalid, 
					.wsf-validated input[type=search].wsf-field:invalid, 
					.wsf-validated input[type=time].wsf-field:invalid, 
					.wsf-validated input[type=week].wsf-field:invalid, 
					.wsf-validated input[type=email].wsf-field:invalid, 
					.wsf-validated input[type=number].wsf-field:invalid, 
					.wsf-validated input[type=tel].wsf-field:invalid, 
					.wsf-validated input[type=text].wsf-field:invalid, 
					.wsf-validated input[type=url].wsf-field:invalid, 
					.wsf-validated select.wsf-field:invalid, 
					.wsf-validated textarea.wsf-field:invalid';

		$this->controls['inpReqBG'] = [
			'group' 	=> 'input',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpReqColor'] = [
			'group' 	=> 'input',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Text color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'color',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpReqBrdColor'] = [
			'group' 	=> 'input',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Border color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'border-color',
					'selector' => $selector
				]
			],
		];

		$selector = ".wsf-validated input[type=date].wsf-field:invalid:focus, 
					.wsf-validated input[type=datetime-local].wsf-field:invalid:focus, 
					.wsf-validated input[type=file].wsf-field:invalid:focus, 
					.wsf-validated input[type=month].wsf-field:invalid:focus, 
					.wsf-validated input[type=password].wsf-field:invalid:focus, 
					.wsf-validated input[type=search].wsf-field:invalid:focus, 
					.wsf-validated input[type=time].wsf-field:invalid:focus, 
					.wsf-validated input[type=week].wsf-field:invalid:focus, 
					.wsf-validated input[type=email].wsf-field:invalid:focus, 
					.wsf-validated input[type=number].wsf-field:invalid:focus, 
					.wsf-validated input[type=tel].wsf-field:invalid:focus, 
					.wsf-validated input[type=text].wsf-field:invalid:focus, 
					.wsf-validated input[type=url].wsf-field:invalid:focus, 
					.wsf-validated select.wsf-field:invalid:focus, 
					.wsf-validated textarea.wsf-field:invalid:focus";

		$this->controls['inpReqBs'] = [
			'group' 	=> 'input',
			'type' 		=> 'box-shadow',
			'label' 	=> esc_html__( 'Box shadow', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			],
		];

		$this->controls['inpTa'] = [
			'group' 	=> 'input',
			'type' 		=> 'separator',
			'label' 	=> esc_html__( 'Textarea', 'bricksultimate' ),
		];

		$this->controls['inpTaWidth'] = [
			'group' 	=> 'input',
			'type' 		=> 'number',
			'units' 	=> true,
			'label' 	=> esc_html__( 'Width', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'width',
					'selector' => 'textarea.wsf-field'
				]
			],
		];

		$this->controls['inpTaHeight'] = [
			'group' 	=> 'input',
			'type' 		=> 'number',
			'units' 	=> true,
			'label' 	=> esc_html__( 'Height', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'height',
					'selector' => 'textarea.wsf-field'
				]
			],
		];
	}

	public function prefixControls() {
		$selector = '.wsf-input-group-prepend, .wsf-input-group-append';
		$this->controls['psWidth'] = [
			'group' 	=> 'prefix',
			'type' 		=> 'number',
			'units' 	=> true,
			'label' 	=> esc_html__( 'Width', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'width',
					'selector' => $selector
				],
				[
					'property' 	=> 'justify-content',
					'selector' 	=> $selector,
					'values' 	=> 'center'
				]
			],
		];

		$this->controls['psHeight'] = [
			'group' 	=> 'prefix',
			'type' 		=> 'number',
			'units' 	=> true,
			'label' 	=> esc_html__( 'Height', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			],
		];

		$this->controls['psPad'] = [
			'group' 	=> 'prefix',
			'type' 		=> 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$this->controls['psBG'] = [
			'group' 	=> 'prefix',
			'type' 		=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'		=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['psTypography'] = [
			'group' => 'prefix',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
		];

		$this->controls['psBorder'] = [
			'group' => 'prefix',
			'type' 	=> 'border',
			'label' => esc_html__( 'Borders', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			],
		];
	}

	public function checkboxControls() {
		$selector = 'input[type=checkbox].wsf-field + label.wsf-label';

		$this->controls['cbLabels'] = [
			'group' => 'cb',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector,
				]
			]
		];

		$this->controls['cbGap'] = [
			'group' => 'cb',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__( 'Gap', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => '-webkit-padding-start',
					'selector' => $selector,
				],
				[
					'property' => 'padding-inline-start',
					'selector' => $selector,
				]
			]
		];

		$this->controls['cbSize'] = [
			'group' => 'cb',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'line-height',
					'selector' => $selector,
				],
				[
					'property' => 'width',
					'selector' => "input[type=checkbox].wsf-field, input[type=checkbox].wsf-field + label.wsf-label:before, input[type=checkbox].wsf-field + label.wsf-label:after",
				],
				[
					'property' => 'height',
					'selector' => "input[type=checkbox].wsf-field, input[type=checkbox].wsf-field + label.wsf-label:before, input[type=checkbox].wsf-field + label.wsf-label:after",
				]
			]
		];

		$selector = "input[type=checkbox].wsf-field + label.wsf-label:before";
		$this->controls['cbColor'] = [
			'group' => 'cb',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['cbCheckColor'] = [
			'group' => 'cb',
			'type' 	=> 'color',
			'label' => esc_html__( 'Checked color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "input[type=checkbox].wsf-field:checked + label.wsf-label:before"
				],
				[
					'property' => 'background-color',
					'selector' => "input[type=checkbox].wsf-field:checked + label.wsf-label:before"
				]
			]
		];

		$this->controls['cbBW'] = [
			'group' => 'cb',
			'type' 	=> 'number',
			'unit' 	=> 'px',
			'label' => esc_html__( 'Border width', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-width',
					'selector' => $selector
				]
			]
		];

		$this->controls['cbBRD'] = [
			'group' => 'cb',
			'type' 	=> 'number',
			'unit' 	=> 'px',
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-radius',
					'selector' => $selector
				]
			]
		];

		$this->controls['cbSep'] = [
			'group' => 'cb',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Disabled Checkboxes', 'bricksultimate' ),
		];

		$this->controls['cbDColor'] = [
			'group' => 'cb',
			'type' 	=> 'color',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "input[type=checkbox].wsf-field:disabled + label.wsf-label"
				]
			]
		];

		$this->controls['cbDBG'] = [
			'group' => 'cb',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "input[type=checkbox].wsf-field:disabled + label.wsf-label:before"
				],
				[
					'property' => 'border-color',
					'selector' => "input[type=checkbox].wsf-field:disabled + label.wsf-label:before"
				]
			]
		];
	}

	public function radioControls() {
		$selector = "input[type=radio].wsf-field + label.wsf-label";
		$pseudoBefore = "input[type=radio].wsf-field + label.wsf-label:before";
		$pseudoAfter = "input[type=radio].wsf-field + label.wsf-label:after";

		$this->controls['radioLabels'] = [
			'group' => 'radio',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector,
				]
			]
		];

		$this->controls['radioGap'] = [
			'group' => 'radio',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__( 'Gap', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => '-webkit-padding-start',
					'selector' => $selector,
				],
				[
					'property' => 'padding-inline-start',
					'selector' => $selector,
				]
			]
		];

		$this->controls['radioSize'] = [
			'group' => 'radio',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'line-height',
					'selector' => $selector,
				],
				[
					'property' => 'width',
					'selector' => "input[type=radio].wsf-field, {$pseudoBefore}, {$pseudoAfter}",
				],
				[
					'property' => 'height',
					'selector' => "input[type=radio].wsf-field, {$pseudoBefore}, {$pseudoAfter}",
				]
			]
		];

		$this->controls['radioBW'] = [
			'group' => 'radio',
			'type' 	=> 'number',
			'unit' 	=> 'px',
			'label' => esc_html__( 'Border width', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-width',
					'selector' => $pseudoBefore
				]
			]
		];

		$this->controls['radioColor'] = [
			'group' => 'radio',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => $pseudoBefore
				]
			]
		];

		$this->controls['radioCheckColor'] = [
			'group' => 'radio',
			'type' 	=> 'color',
			'label' => esc_html__( 'Checked color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "input[type=radio].wsf-field:checked + label.wsf-label:before"
				],
				[
					'property' => 'background-color',
					'selector' => "input[type=radio].wsf-field:checked + label.wsf-label:before"
				]
			]
		];

		$this->controls['radioSep'] = [
			'group' => 'radio',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Disabled radio buttons', 'bricksultimate' ),
		];

		$this->controls['radioDColor'] = [
			'group' => 'radio',
			'type' 	=> 'color',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "input[type=radio].wsf-field:disabled + label.wsf-label"
				]
			]
		];

		$this->controls['radioDBG'] = [
			'group' => 'radio',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "input[type=radio].wsf-field:disabled + label.wsf-label:before",
				],
				[
					'property' => 'border-color',
					'selector' => "input[type=radio].wsf-field:disabled + label.wsf-label:before",
				]
			]
		];
	}

	public function pgbmrControls() {
		$selector = "progress.wsf-progress, progress.wsf-progress[value]";
		$this->controls['pgbH'] = [
			'group' => 'progress',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			]
		];

		$this->controls['pgbBR'] = [
			'group' => 'progress',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-radius',
					'selector' => $selector
				],
				[
					'property' => 'border-radius',
					'selector' => "progress.wsf-progress[value]::-webkit-progress-bar"
				],
				[
					'property' => 'border-radius',
					'selector' => "progress.wsf-progress[value]::-webkit-progress-value"
				],
				[
					'property' => 'border-radius',
					'selector' => "progress.wsf-progress[value]::-moz-progress-bar"
				],
				[
					'property' => 'border-radius',
					'selector' => "progress.wsf-progress[value]::-ms-fill"
				],
				[
					'property' => 'border-radius',
					'selector' => "progress.wsf-progress.wsf-progress-success[value]::-webkit-progress-value"
				],
				[
					'property' => 'border-radius',
					'selector' => "progress.wsf-progress.wsf-progress-success[value]::-moz-progress-bar"
				],
				[
					'property' => 'border-radius',
					'selector' => "progress.wsf-progress.wsf-progress-success[value]::-ms-fill"
				]
			]
		];

		$this->controls['pgbColor'] = [
			'group' => 'progress',
			'type' 	=> 'color',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				],
				[
					'property' => 'background-color',
					'selector' => "progress.wsf-progress[value]::-webkit-progress-bar"
				],
				[
					'property' => 'background-color',
					'selector' => "progress.wsf-progress[value]::-moz-progress-bar"
				]
				,
				[
					'property' => 'background-color',
					'selector' => "progress.wsf-progress[value]::-ms-fill"
				]
			]
		];

		$this->controls['pgbFillColor'] = [
			'group' => 'progress',
			'type' 	=> 'color',
			'label' => esc_html__( 'Fill track Color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "progress.wsf-progress[value]::-webkit-progress-value"
				],
				[
					'property' => 'background-color',
					'selector' => "progress.wsf-progress.wsf-progress-success[value]::-webkit-progress-value"
				],
				[
					'property' => 'background-color',
					'selector' => "progress.wsf-progress.wsf-progress-success[value]::-moz-progress-bar"
				],
				[
					'property' => 'background-color',
					'selector' => "progress.wsf-progress.wsf-progress-success[value]::-ms-fill"
				]
			]
		];

		$this->controls['pgbBorder'] = [
			'group' => 'progress',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['pgbText'] = [
			'group' => 'progress',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Help text', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => ".wsf-field-wrapper[data-type=progress] .wsf-help"
				]
			]
		];

		/*********************
		 * Meter
		 ********************/
		$selector = "meter.wsf-meter, meter.wsf-meter::-webkit-meter-bar";
		$this->controls['meterH'] = [
			'group' => 'meter',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			]
		];

		$this->controls['meterBR'] = [
			'group' => 'meter',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-radius',
					'selector' => $selector
				]
			]
		];

		$this->controls['meterColor'] = [
			'group' => 'meter',
			'type' 	=> 'color',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['meterFillColor'] = [
			'group' => 'meter',
			'type' 	=> 'color',
			'label' => esc_html__( 'Fill track Color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background',
					'selector' => "meter.wsf-meter::-webkit-meter-optimum-value"
				],
				[
					'property' => 'background',
					'selector' => "meter.wsf-meter:-moz-meter-optimum::-moz-meter-bar"
				],
				[
					'property' => 'background',
					'selector' => "meter.wsf-meter::-webkit-meter-suboptimum-value"
				],
				[
					'property' => 'background',
					'selector' => "meter.wsf-meter:-moz-meter-sub-optimum::-moz-meter-bar"
				],
				[
					'property' => 'background',
					'selector' => "meter.wsf-meter::-webkit-meter-even-less-good-value"
				],
				[
					'property' => 'background',
					'selector' => "meter.wsf-meter:-moz-meter-sub-sub-optimum::-moz-meter-bar, div#value.optimum"
				]
			]
		];

		$this->controls['meterBorder'] = [
			'group' => 'meter',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['meterText'] = [
			'group' => 'meter',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Help text', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => ".wsf-field-wrapper[data-type=meter] .wsf-help"
				]
			]
		];

		/*********************
		 * Range Slider
		 ********************/
		$selector = "input[type=range].wsf-field";
		$this->controls['rangeText'] = [
			'group' => 'range',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Help text', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => ".wsf-field-wrapper[data-type=range] .wsf-help"
				]
			]
		];

		$this->controls['rangeH'] = [
			'group' => 'range',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => "input[type=range].wsf-field::-webkit-slider-runnable-track"
				],
				[
					'property' => 'height',
					'selector' => "input[type=range].wsf-field::-moz-range-track"
				],
				[
					'property' => 'height',
					'selector' => "input[type=range].wsf-field::-ms-track"
				],
				[
					'property' => 'height',
					'selector' => "input[type=range].wsf-field::-ms-fill-lower"
				],
				[
					'property' => 'height',
					'selector' => "input[type=range].wsf-field::-ms-fill-upper"
				]
			]
		];

		$this->controls['rangeBR'] = [
			'group' => 'range',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-radius',
					'selector' => "input[type=range].wsf-field::-webkit-slider-runnable-track"
				],
				[
					'property' => 'border-radius',
					'selector' => "input[type=range].wsf-field::-moz-range-track"
				],
				[
					'property' => 'border-radius',
					'selector' => "input[type=range].wsf-field::-ms-track"
				],
				[
					'property' => 'border-radius',
					'selector' => "input[type=range].wsf-field::-ms-fill-lower"
				],
				[
					'property' => 'border-radius',
					'selector' => "input[type=range].wsf-field::-ms-fill-upper"
				]
			]
		];

		$this->controls['rangeColor'] = [
			'group' => 'range',
			'type' 	=> 'color',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => '--wsf-color-upper-track',
					'selector' => $selector
				],
				[
					'selector' => "input[type=range].wsf-field::-webkit-slider-runnable-track",
					'property' => 'background-color',
				],
				[
					'property' => 'background-color',
					'selector' => "input[type=range].wsf-field::-moz-range-track"
				],
				[
					'property' => 'background-color',
					'selector' => "input[type=range].wsf-field::-ms-track"
				],
				[
					'property' => 'background-color',
					'selector' => "input[type=range].wsf-field::-ms-fill-lower"
				],
				[
					'property' => 'background-color',
					'selector' => "input[type=range].wsf-field::-ms-fill-upper"
				]
			]
		];

		$this->controls['rangeFillColor'] = [
			'group' => 'range',
			'type' 	=> 'color',
			'label' => esc_html__( 'Fill track Color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => '--wsf-color-lower-track',
					'selector' => $selector
				]
			]
		];

		$this->controls['rangeBorder'] = [
			'group' => 'range',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'selector' => "input[type=range].wsf-field::-webkit-slider-runnable-track",
					'property' => 'border',
				],
				[
					'property' => 'border',
					'selector' => "input[type=range].wsf-field::-moz-range-track"
				],
				[
					'property' => 'border',
					'selector' => "input[type=range].wsf-field::-ms-track"
				],
				[
					'property' => 'border',
					'selector' => "input[type=range].wsf-field::-ms-fill-lower"
				],
				[
					'property' => 'border',
					'selector' => "input[type=range].wsf-field::-ms-fill-upper"
				]
			]
		];

		$this->controls['rangeCircle'] = [
			'group' => 'range',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Circle', 'bricksultimate' ),
		];

		$this->controls['rangeCBG'] = [
			'group' => 'range',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "input[type=range].wsf-field::-webkit-slider-thumb",
				],
				[
					'property' => 'background-color',
					'selector' => "input[type=range].wsf-field::-moz-range-thumb"
				],
				[
					'property' => 'background-color',
					'selector' => "input[type=range].wsf-field::-ms-thumb"
				]
			]
		];

		$this->controls['rangeCSize'] = [
			'group' => 'range',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => "input[type=range].wsf-field::-webkit-slider-thumb",
				],
				[
					'property' => 'height',
					'selector' => "input[type=range].wsf-field::-webkit-slider-thumb",
				],
				[
					'property' => 'width',
					'selector' => "input[type=range].wsf-field::-moz-range-thumb"
				],
				[
					'property' => 'height',
					'selector' => "input[type=range].wsf-field::-moz-range-thumb"
				],
				[
					'property' => 'width',
					'selector' => "input[type=range].wsf-field::-ms-thumb"
				],
				[
					'property' => 'height',
					'selector' => "input[type=range].wsf-field::-ms-thumb"
				]
			]
		];

		$this->controls['rangeCPos'] = [
			'group' => 'range',
			'type' 	=> 'number',
			'unit' 	=> 'px',
			'label' => esc_html__( 'Position', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'margin-top',
					'selector' => "input[type=range].wsf-field::-webkit-slider-thumb",
				],
				[
					'property' => 'margin-top',
					'selector' => "input[type=range].wsf-field::-moz-range-thumb"
				],
				[
					'property' => 'margin-top',
					'selector' => "input[type=range].wsf-field::-ms-thumb"
				]
			]
		];

		$this->controls['rangeCBrd'] = [
			'group' => 'range',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => "input[type=range].wsf-field::-webkit-slider-thumb",
				],
				[
					'property' => 'border',
					'selector' => "input[type=range].wsf-field::-moz-range-thumb"
				],
				[
					'property' => 'border',
					'selector' => "input[type=range].wsf-field::-ms-thumb"
				]
			]
		];
	}

	public function ratingControls() {
		$this->controls['ratingColor'] = [
			'group' => 'rating',
			'type' 	=> 'color',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "svg.wsf-rating-icon, svg.wsf-rating-icon path"
				],
				[
					'property' => 'fill',
					'selector' => "svg.wsf-rating-icon, svg.wsf-rating-icon path",
					'value' => 'currentColor',
					'important' => true
				]
			]
		];

		$this->controls['ratingAColor'] = [
			'group' => 'rating',
			'type' 	=> 'color',
			'label' => esc_html__( 'Active color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "li.wsf-rating-selected svg.wsf-rating-icon, li.wsf-rating-selected svg.wsf-rating-icon path"
				],
				[
					'property' => 'fill',
					'selector' => "li.wsf-rating-selected svg.wsf-rating-icon, li.wsf-rating-selected svg.wsf-rating-icon path",
					'value' => 'currentColor',
					'important' => true
				]
			]
		];

		$this->controls['ratingSize'] = [
			'group' => 'rating',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => "svg.wsf-rating-icon, svg.wsf-rating-icon path",
				],
				[
					'property' => 'height',
					'selector' => "svg.wsf-rating-icon, svg.wsf-rating-icon path",
				]
			]
		];

		$this->controls['ratingGap'] = [
			'group' => 'rating',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Gap', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => '-webkit-padding-end',
					'selector' => ".wsf-rating li",
					'important' => true
				],
				[
					'property' => 'padding-inline-end',
					'selector' => ".wsf-rating li",
					'important' => true
				]
			]
		];
	}

	public function fileControls() {
		$selector = "input[type=text].wsf-field ~ .dropzone";
		$this->controls['filePadding'] = [
			'group' => 'file',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Spacing', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['fileBG'] = [
			'group' => 'file',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['fileBrd'] = [
			'group' => 'file',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['fileTg'] = [
			'group' => 'file',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => "{$selector} .dz-message"
				]
			]
		];

		$this->controls['filesep'] = [
			'group' => 'file',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Preview Style', 'bricksultimate' ),
		];

		$this->controls['filePPadding'] = [
			'group' => 'file',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Spacing', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => "{$selector} .wsf-dropzonejs-preview"
				]
			]
		];

		$this->controls['filePBG'] = [
			'group' => 'file',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "{$selector} .wsf-dropzonejs-preview"
				]
			]
		];

		$this->controls['filePBrd'] = [
			'group' => 'file',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => "{$selector} .wsf-dropzonejs-preview"
				]
			]
		];

		$this->controls['fileName'] = [
			'group' => 'file',
			'type' 	=> 'typography',
			'label' => esc_html__( 'File name', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => "{$selector} .wsf-dropzonejs-preview small[data-dz-name]"
				]
			]
		];

		$this->controls['fileSize'] = [
			'group' => 'file',
			'type' 	=> 'typography',
			'label' => esc_html__( 'File size', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => "{$selector} .wsf-dropzonejs-preview small[data-dz-size]"
				]
			]
		];

		$this->controls['fileRemove'] = [
			'group' => 'file',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Remove link', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => "{$selector} .wsf-dropzonejs-preview a"
				]
			]
		];
	}

	public function spacerControls() {
		$this->controls['spacerH'] = [
			'group' => 'spacer',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => ".wsf-tile[data-type=\"spacer\"] div"
				]
			]
		];

		$this->controls['divider'] = [
			'group' => 'spacer',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Divider', 'bricksultimate' ),
		];

		$this->controls['dividerH'] = [
			'group' => 'spacer',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Border width', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-top-width',
					'selector' => "hr.wsf-field"
				]
			]
		];

		$this->controls['dividerColor'] = [
			'group' => 'spacer',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "hr.wsf-field"
				],
  				[
					'property' => 'background-color',
					'selector' => "hr.wsf-field",
					'value' 	=> 'transparent'
				],
				[
					'property' => 'border-style',
					'selector' => "hr.wsf-field",
					'value' 	=> 'solid'
				],
			]
		];

		$this->controls['dividerSpacing'] = [
			'group' => 'spacer',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Spacing', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => "hr.wsf-field"
				]
			]
		];
	}

	public function tabsControls() {
		$selector = ".wsf-form ul.wsf-group-tabs";

		$this->controls['tabWrapMrg'] = [
			'group' => 'tabs',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Margin', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => $selector
				]
			]
		];

		$this->controls['tabsWrapPad'] = [
			'group' => 'tabs',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['tabsWrapBrd'] = [
			'group' => 'tabs',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['tabsWrapBG'] = [
			'group' => 'tabs',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['tabsSep'] = [
			'group' => 'tabs',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Tab Items', 'bricksultimate' ),
		];

		$selector =".wsf-form ul.wsf-group-tabs > li > a";
		$hover =".wsf-form ul.wsf-group-tabs > li > a:hover";
		$active = ".wsf-form ul.wsf-group-tabs > li.wsf-tab-active > a";

		$this->controls['tabsGap'] = [
			'group' => 'tabs',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Gap between items', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'margin-right',
					'selector' => ".wsf-form ul.wsf-group-tabs > li"
				],
				[
					'property' 	=> 'margin-right',
					'selector' 	=> ".wsf-form ul.wsf-group-tabs > li:last-child",
					'value' 	=> '0'
				]
			]
		];

		$this->controls['tabItemsPad'] = [
			'group' => 'tabs',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['tabItemsWidth'] = [
			'group' => 'tabs',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		$this->controls['tabItemsBG'] = [
			'group' => 'tabs',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['tabItemsTG'] = [
			'group' => 'tabs',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['tabItemsBrd'] = [
			'group' => 'tabs',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['tabHoverSep'] = [
			'group' => 'tabs',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Hover Tab', 'bricksultimate' ),
		];

		$this->controls['tabHBG'] = [
			'group' => 'tabs',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $hover
				]
			]
		];

		$this->controls['tabHText'] = [
			'group' => 'tabs',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => $hover
				]
			]
		];

		$this->controls['tabHBrd'] = [
			'group' => 'tabs',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => $hover
				]
			]
		];

		$this->controls['tabActiveSep'] = [
			'group' => 'tabs',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Active Tab', 'bricksultimate' ),
		];

		$this->controls['tabActiveBG'] = [
			'group' => 'tabs',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $active
				]
			]
		];

		$this->controls['tabActiveText'] = [
			'group' => 'tabs',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => $active
				]
			]
		];

		$this->controls['tabActiveBrd'] = [
			'group' => 'tabs',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => $active
				]
			]
		];

		$this->controls['tabsContentSep'] = [
			'group' => 'tabs',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Tab Content', 'bricksultimate' ),
		];

		$this->controls['tabContentPad'] = [
			'group' => 'tabs',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => ".wsf-groups"
				]
			]
		];

		$this->controls['tabContentBG'] = [
			'group' => 'tabs',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => ".wsf-groups"
				]
			]
		];

		$this->controls['tabContentBrd'] = [
			'group' => 'tabs',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => ".wsf-groups"
				]
			]
		];
	}

	public function buttonControls() {
		$selector = "button.wsf-button";

		$this->controls['buttonPad'] = [
			'group' => 'button',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['buttonW'] = [
			'group' => 'button',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		$this->controls['buttonH'] = [
			'group' => 'button',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			]
		];

		$this->controls['buttonTg'] = [
			'group' => 'button',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['buttonBrd'] = [
			'group' => 'button',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['buttonBS'] = [
			'group' => 'button',
			'type' 	=> 'box-shadow',
			'label' => esc_html__( 'Box shadow', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			]
		];

		$this->controls['buttonPrimary'] = [
			'group' => 'button',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Default/Primary Button', 'bricksultimate' ),
		];

		$this->controls['buttonBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button, button.wsf-button.wsf-button-primary"
				]
			]
		];

		$this->controls['buttonTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button, button.wsf-button.wsf-button-primary"
				]
			]
		];

		$this->controls['buttonBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button, button.wsf-button.wsf-button-primary"
				]
			]
		];

		$this->controls['buttonHBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button:hover, button.wsf-button.wsf-button-primary:hover"
				]
			]
		];

		$this->controls['buttonHTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button:hover, button.wsf-button.wsf-button-primary:hover"
				]
			]
		];

		$this->controls['buttonHBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button:hover, button.wsf-button.wsf-button-primary:hover"
				]
			]
		];

		$this->controls['buttonSecond'] = [
			'group' => 'button',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Secondary Button', 'bricksultimate' ),
		];

		$this->controls['buttonSBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button.wsf-button-secondary"
				]
			]
		];

		$this->controls['buttonSTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button.wsf-button-secondary"
				]
			]
		];

		$this->controls['buttonSBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button.wsf-button-secondary"
				]
			]
		];

		$this->controls['buttonSHBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button.wsf-button-secondary:hover"
				]
			]
		];

		$this->controls['buttonSHTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button.wsf-button-secondary:hover"
				]
			]
		];

		$this->controls['buttonSHBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button.wsf-button-secondary:hover"
				]
			]
		];

		$this->controls['buttonSuc'] = [
			'group' => 'button',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Success Button', 'bricksultimate' ),
		];

		$this->controls['buttonSucBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button.wsf-button-success"
				]
			]
		];

		$this->controls['buttonSucTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button.wsf-button-success"
				]
			]
		];

		$this->controls['buttonSucBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button.wsf-button-success"
				]
			]
		];

		$this->controls['buttonSucHBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button.wsf-button-success:hover"
				]
			]
		];

		$this->controls['buttonSucHTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button.wsf-button-success:hover"
				]
			]
		];

		$this->controls['buttonSucHBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button.wsf-button-success:hover"
				]
			]
		];

		$this->controls['buttonInfo'] = [
			'group' => 'button',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Information Button', 'bricksultimate' ),
		];

		$this->controls['buttonInfoBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button.wsf-button-information"
				]
			]
		];

		$this->controls['buttonInfoTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button.wsf-button-information"
				]
			]
		];

		$this->controls['buttonInfoBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button.wsf-button-information"
				]
			]
		];

		$this->controls['buttonInfoHBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button.wsf-button-information:hover"
				]
			]
		];

		$this->controls['buttonInfoHTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button.wsf-button-information:hover"
				]
			]
		];

		$this->controls['buttonInfoHBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button.wsf-button-information:hover"
				]
			]
		];

		$this->controls['buttonWrn'] = [
			'group' => 'button',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Warning Button', 'bricksultimate' ),
		];

		$this->controls['buttonWBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button.wsf-button-warning"
				]
			]
		];

		$this->controls['buttonWTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button.wsf-button-warning"
				]
			]
		];

		$this->controls['buttonWBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button.wsf-button-warning"
				]
			]
		];

		$this->controls['buttonWHBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button.wsf-button-warning:hover"
				]
			]
		];

		$this->controls['buttonWHTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button.wsf-button-warning:hover"
				]
			]
		];

		$this->controls['buttonWHBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button.wsf-button-warning:hover"
				]
			]
		];

		$this->controls['buttonD'] = [
			'group' => 'button',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Danger Button', 'bricksultimate' ),
		];

		$this->controls['buttonDBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button.wsf-button-danger"
				]
			]
		];

		$this->controls['buttonDTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button.wsf-button-danger"
				]
			]
		];

		$this->controls['buttonDBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button.wsf-button-danger"
				]
			]
		];

		$this->controls['buttonDHBG'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => "button.wsf-button.wsf-button-danger:hover"
				]
			]
		];

		$this->controls['buttonDHTxt'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => "button.wsf-button.wsf-button-danger:hover"
				]
			]
		];

		$this->controls['buttonDHBrdC'] = [
			'group' => 'button',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => "button.wsf-button.wsf-button-danger:hover"
				]
			]
		];
	}

	public function clearControls() {
		$selector = 'button.wsf-button[data-action="wsf-clear"]';
		$hover_selector = 'button.wsf-button[data-action="wsf-clear"]:hover';

		$this->controls['clearPad'] = [
			'group' => 'clear',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['clearW'] = [
			'group' => 'clear',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		$this->controls['clearH'] = [
			'group' => 'clear',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			]
		];

		$this->controls['clearBG'] = [
			'group' => 'clear',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['clearTg'] = [
			'group' => 'clear',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['clearBrd'] = [
			'group' => 'clear',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['clearBS'] = [
			'group' => 'clear',
			'type' 	=> 'box-shadow',
			'label' => esc_html__( 'Box shadow', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			]
		];

		$this->controls['clearHBG'] = [
			'group' => 'clear',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $hover_selector
				]
			]
		];

		$this->controls['clearHTxt'] = [
			'group' => 'clear',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => $hover_selector
				]
			]
		];

		$this->controls['clearHBrdC'] = [
			'group' => 'clear',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => $hover_selector
				]
			]
		];

		$this->controls['clearHBS'] = [
			'group' => 'clear',
			'type' 	=> 'box-shadow',
			'label' => esc_html__( 'Hover box shadow', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $hover_selector
				]
			]
		];
	}

	public function resetControls() {
		$selector = 'button.wsf-button[data-action="wsf-reset"]';
		$hover_selector = 'button.wsf-button[data-action="wsf-reset"]:hover';

		$this->controls['resetPad'] = [
			'group' => 'reset',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			]
		];

		$this->controls['resetW'] = [
			'group' => 'reset',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Width', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		$this->controls['resetH'] = [
			'group' => 'reset',
			'type' 	=> 'number',
			"units" => true,
			'label' => esc_html__( 'Height', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			]
		];

		$this->controls['resetBG'] = [
			'group' => 'reset',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['resetTg'] = [
			'group' => 'reset',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['resetBrd'] = [
			'group' => 'reset',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];

		$this->controls['resetBS'] = [
			'group' => 'reset',
			'type' 	=> 'box-shadow',
			'label' => esc_html__( 'Box shadow', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector
				]
			]
		];

		$this->controls['resetHBG'] = [
			'group' => 'reset',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover background', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $hover_selector
				]
			]
		];

		$this->controls['resetHTxt'] = [
			'group' => 'reset',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => $hover_selector
				]
			]
		];

		$this->controls['resetHBrdC'] = [
			'group' => 'reset',
			'type' 	=> 'color',
			'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-color',
					'selector' => $hover_selector
				]
			]
		];

		$this->controls['resetHBS'] = [
			'group' => 'clear',
			'type' 	=> 'box-shadow',
			'label' => esc_html__( 'Hover box shadow', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $hover_selector
				]
			]
		];
	}

	public function messageControls() {
		$this->controls['msgPadding'] = [
			'group' => 'msg',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Padding', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => ".wsf-alert"
				]
			]
		];

		$this->controls['msgTg'] = [
			'group' => 'msg',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => ".wsf-alert"
				]
			]
		];

		$this->controls['msgBrd'] = [
			'group' => 'msg',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__( 'Border width', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => '-webkit-border-start-width',
					'selector' => ".wsf-alert.wsf-alert-success, .wsf-alert.wsf-alert-information, .wsf-alert.wsf-alert-warning, .wsf-alert.wsf-alert-danger"
				],
				[
					'property' => 'border-inline-start-width',
					'selector' => ".wsf-alert.wsf-alert-success, .wsf-alert.wsf-alert-information, .wsf-alert.wsf-alert-warning, .wsf-alert.wsf-alert-danger"
				]
			]
		];

		$this->controls['msgBrdRadius'] = [
			'group' => 'msg',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'border-radius',
					'selector' => ".wsf-alert"
				]
			]
		];

		$this->controls['msgSuccess'] = [
			'group' => 'msg',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Success Type', 'bricksultimate' ),
		];

		$this->controls['sucBg'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => ".wsf-alert.wsf-alert-success"
				]
			]
		];

		$this->controls['sucText'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => ".wsf-alert.wsf-alert-success"
				]
			]
		];

		$this->controls['sucBorder'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => '-webkit-border-start-color',
					'selector' => ".wsf-alert.wsf-alert-success"
				],
				[
					'property' => 'border-inline-start-color',
					'selector' => ".wsf-alert.wsf-alert-success"
				]
			]
		];

		$this->controls['msgInfo'] = [
			'group' => 'msg',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Information Type', 'bricksultimate' ),
		];

		$this->controls['infoBg'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => ".wsf-alert.wsf-alert-information"
				]
			]
		];

		$this->controls['infoText'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => ".wsf-alert.wsf-alert-information"
				]
			]
		];

		$this->controls['infoBorder'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => '-webkit-border-start-color',
					'selector' => ".wsf-alert.wsf-alert-information"
				],
				[
					'property' => 'border-inline-start-color',
					'selector' => ".wsf-alert.wsf-alert-information"
				]
			]
		];

		$this->controls['msgWrn'] = [
			'group' => 'msg',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Warning Type', 'bricksultimate' ),
		];

		$this->controls['wrnBg'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => ".wsf-alert.wsf-alert-warning"
				]
			]
		];

		$this->controls['wrnText'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => ".wsf-alert.wsf-alert-warning"
				]
			]
		];

		$this->controls['wrnBorder'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => '-webkit-border-start-color',
					'selector' => ".wsf-alert.wsf-alert-warning"
				],
				[
					'property' => 'border-inline-start-color',
					'selector' => ".wsf-alert.wsf-alert-warning"
				]
			]
		];

		$this->controls['msgDanger'] = [
			'group' => 'msg',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Danger Type', 'bricksultimate' ),
		];

		$this->controls['dangerBg'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => ".wsf-alert.wsf-alert-danger"
				]
			]
		];

		$this->controls['dangerText'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => ".wsf-alert.wsf-alert-danger"
				]
			]
		];

		$this->controls['dangerBorder'] = [
			'group' => 'msg',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => '-webkit-border-start-color',
					'selector' => ".wsf-alert.wsf-alert-danger"
				],
				[
					'property' => 'border-inline-start-color',
					'selector' => ".wsf-alert.wsf-alert-danger"
				]
			]
		];
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		echo "<{$this->tag} {$this->render_attributes('_root')}>";

		$source = Helpers::get_value( $settings, 'source_type', 'static');
		$wsform = ( $source == 'static' ) ? Helpers::get_value( $settings, 'wsform', 'none') : $this->getDynamicFormID();

		if( $wsform == 'none' ) {
			return $this->render_element_placeholder( ['title' => esc_html__( 'Select a WSForm.', 'bricksultimate' )] );
		} elseif( empty( $wsform ) || $wsform === false || is_array( $wsform ) ) {
			return $this->render_element_placeholder( ['title' => esc_html__( 'Enter WSForm ID.', 'bricksultimate' )] );
		} else {
			echo do_shortcode('[ws_form id="' . $wsform . '"]');
		}

		echo "</{$this->tag}>";
	}

	//* get form id
	public function getDynamicFormID() {
		$term = get_queried_object();
		$formId = '';
		
		if ( $term && ! empty( $term->term_id ) ) {
			$formId = get_term_meta( $term->term_id, Helpers::get_value( $this->settings, 'custom_field'), true );
		} else {
			$formId = get_post_meta( $this->post_id, Helpers::get_value( $this->settings, 'custom_field'), true );
		}

		if( empty( $formId ) || $formId === false || is_array( $formId ) ) {
			$formId = strstr( $this->settings['custom_field'], '{') ? $this->render_dynamic_data_tag( $this->settings['custom_field'], 'text' ) : $this->settings['custom_field'];
		}
		
		return $formId;
	}

	public function getWSForms() {
		$ws_form_form = New \WS_Form_Form();
		$forms = $ws_form_form->db_read_all('', 'NOT status="trash"', 'label', '', '', false);
		
		if( $forms ) {
			$wsforms = [ 'none' => esc_html__('Select a WSForm', 'fluentform')];
			foreach ($forms as $form) {
				$wsforms[esc_attr($form['id'])] = esc_html(sprintf('%s (ID: %u)', $form['label'], $form['id']));
			}
		}  else {
			$wsforms = [ 'none' => esc_html__('Create a Form First', 'fluentform')];
		}

		return $wsforms;
	}
}