<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\{Helpers, Wishlist};

class WishlistCleanAll extends \Bricks\Element {
	public $category 		= 'wishlist';
	public $name 			= 'bu-wsl-clean';
	public $icon 			= 'ti-trash';
	public $nestable 		= true;
	public $confirmModal 	= '';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Clean All - Wishlist', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['icon']  = array(
			'title' => esc_html__( 'Icon', 'bricks' ),
			'tab'   => 'content',
		);

		$this->control_groups['style'] = array(
			'title' => esc_html__( 'Button Styles', 'bricks' ),
			'tab'   => 'content',
		);

		$this->control_groups['confirm'] = array(
			'title' => esc_html__( 'Confirmation Popup', 'bricks' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['_typography']['css'][0]['selector'] = '.button-text';

		$this->controls['postType'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Post type', 'bricks' ),
			'options'     => \Bricks\Helpers::get_registered_post_types(),
			'multiple'    => false,
			'inline' => true,
			'placeholder' => esc_html__( 'Select post type', 'bricks' ),
			'default' 	=> 'post'
		];

		$this->controls['link_button'] = [
			'type' 		=> 'select',
			'label' 	=> esc_html__('Button type', 'ziultimate'),
			'default' 	=> 'button',
			'options' 	=> [
				'button' 	=> esc_html__('Button'),
				'link' 		=> esc_html__('Plain Link'),
			],
			'inline' 	=> true,
			'medium' 	=> true
		];

		$this->controls['button_text'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Button Text', 'bricksultimate' ),
			'placeholder' => esc_html__( 'Clean All', 'bricksultimate' ),
			'default' 	  => esc_html__( 'Clean All', 'bricksultimate' ),
		];

		$this->controls['size'] = [
			'label'       => esc_html__( 'Size', 'bricks' ),
			'type'        => 'select',
			'options'     => $this->control_options['buttonSizes'],
			'inline'      => true,
			'reset'       => true,
			'placeholder' => esc_html__( 'Default', 'bricks' ),
			'required' 	  => ['link_button', '=', 'button']
		];

		$this->controls['style'] = [
			'label'       => esc_html__( 'Style', 'bricks' ),
			'type'        => 'select',
			'options'     => $this->control_options['styles'],
			'inline'      => true,
			'reset'       => true,
			'default'     => 'primary',
			'placeholder' => esc_html__( 'None', 'bricks' ),
			'required' 	  => ['link_button', '=', 'button']
		];

		$this->controls['circle'] = [
			'label' 	=> esc_html__( 'Circle', 'bricks' ),
			'type'  	=> 'checkbox',
			'reset' 	=> true,
			'required' 	=> ['link_button', '=', 'button']
		];

		$this->controls['outline'] = [
			'label' 	=> esc_html__( 'Outline', 'bricks' ),
			'type'  	=> 'checkbox',
			'reset' 	=> true,
			'required' 	=> ['link_button', '=', 'button']
		];

		$this->controls['aria_label'] = [
			'type'      => 'text',
			'label'     => esc_html__('Aria label', 'bricksultimate'),
		];

		$this->controls['loadingColor'] = [
			'label'    	=> esc_html__( 'Loading icon color', 'bricksultimate' ),
			'type'     	=> 'color',
			'css'      	=> [
				[
					'property' => '--loading-color'
				],
			],
		];

		$this->controls['icon'] = [
			'group' => 'icon',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'icon',
		];

		$this->controls['iconTypography'] = [
			'group' 	=> 'icon',
			'label'    => esc_html__( 'Typography', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => 'i',
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'line-height',
				'letter-spacing',
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconPosition'] = [
			'group' 	  => 'icon',
			'label'       => esc_html__( 'Position', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'row-reverse' 		=> esc_html__('Left', 'bricks'),
				'row' 				=> esc_html__('Right', 'bricks'),
				'column-reverse' 	=> esc_html__('Top', 'bricks'),
			],
			'inline'      	=> true,
			'placeholder' 	=> esc_html__( 'Right', 'bricks' ),
			'default' 		=> 'row',
			'css' 			=> [
				[
					'selector' => '',
					'property' => 'flex-direction'
				]
			],
			'required'    	=> [ 'icon', '!=', '' ],
		];

		$this->controls['iconGap'] = [
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Gap', 'bricksultimate' ),
			'type'     	=> 'number',
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 100,
			'step' 		=> 1,
			'inline' 	=> true,
			'css'      	=> [
				[
					'property' => 'gap',
					'selector' => '',
				],
			],
			'default' 	=> '10px',
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconMrg'] = [
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Margin', 'bricks' ),
			'type'     	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'      	=> [
				[
					'property' => 'margin',
					'selector' => 'i',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconHColor'] = [
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Hover color', 'bricksultimate' ),
			'type'     	=> 'color',
			'css'      	=> [
				[
					'property' => 'color',
					'selector' => '&:hover i',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$selector = '&';
		$this->controls['sub_width'] = [
			'group' 	=> 'style',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricksultimate'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['sub_sp_sep'] = [
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type'  	=> 'separator',
		];

		//margin field
		$this->controls['sub_mrg'] = [
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['sub_pad'] = [
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['sub_sp_sep_close'] = [
			'group' 	=> 'style',
			'type'  	=> 'separator',
		];

		$this->controls['sub_bg'] = [
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sub_font'] = [
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.button-text',
				],
			]
		];

		$this->controls['sub_brd'] = [
			'group' 	=> 'style',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['sub_shadow'] = [
			'group' 	=> 'style',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['sub_hover_sep'] = [
			'group' 	=> 'style',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover State', 'bricksultimate'),
		];

		$this->controls['sub_hbg'] = [
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sub_hclr'] = [
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['sub_hbrd'] = [
			'group' 	=> 'style',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['sub_hshadow'] = [
			'group' 	=> 'style',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];

		/**
		 * Confirmation message box
		 *******************************/

		$this->controls['enableConfirmPopup'] = [
			'group' => 'confirm',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Enable confirmation modal')
		];

		$this->controls['previewBuilder'] = [
			'group' => 'confirm',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Show preview on builder'),
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['cancelButton'] = [
			'group' => 'confirm',
			'type' 	=> 'text',
			'label' => esc_html__('Cancel button selector', 'bricksultimate'),
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['okButton'] = [
			'group' => 'confirm',
			'type' 	=> 'text',
			'label' => esc_html__('Confirm button selector', 'bricksultimate'),
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$selector = '.modal-content';
		$this->controls['modalBG'] = [
			'group' => 'confirm',
			'type' 	=> 'color',
			'label' => esc_html__('Modal background', 'bricksultimate'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'background-color'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalBrd'] = [
			'group' => 'confirm',
			'type' 	=> 'border',
			'label' => esc_html__('Modal border', 'bricksultimate'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'border'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalBS'] = [
			'group' => 'confirm',
			'type' 	=> 'box-shadow',
			'label' => esc_html__('Modal box shadow', 'bricksultimate'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'box-shadow'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalWidth'] = [
			'group' => 'confirm',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__('Width', 'bricks'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'width'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalMHeight'] = [
			'group' => 'confirm',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__('Min. Height', 'bricks'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'min-height'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalHeight'] = [
			'group' => 'confirm',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__('Height', 'bricks'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'height'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalPad'] = [
			'group' => 'confirm',
			'type' 	=> 'spacing',
			'label' => esc_html__('Padding', 'bricks'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'padding'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalSep'] = [
			'group' => 'confirm',
			'type' 	=> 'separator',
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$selector = '.bu-cnf-backdrop';
		$this->controls['disableBackdrop'] = [
			'group' => 'confirm',
			'type' 	=> 'checkbox',
			'label' => __('Disable backdrop', 'bricksultimate'),
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['backdropBG'] = [
			'group' 	=> 'confirm',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];
	}

	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-wishlistcompare' );
		} else {*/
			wp_enqueue_script( 'bu-wishlist' );
		//}
	}

	public function add_actions() {
		if( ! empty( $this->settings['enableConfirmPopup'] ) ) {
			add_action('wp_footer', [$this, 'confirmationModal']);
		}
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;
		$postType = Helpers::get_value( $settings, 'postType', 'post' );
		$cookie_key = Wishlist::get_cookie_key( $postType );

		$data = [
			'postType' => $postType,
			'cookie_key' => $cookie_key
		];

		$button_text = bricks_render_dynamic_data( Helpers::get_value( $settings, 'button_text', false ) );
		$url = esc_url( get_permalink( $this->post_id) );
		$isButton 	= Helpers::get_value( $settings, 'link_button', 'button' );

		if( $isButton == 'button' ) {
			$this->set_attribute( '_root', 'class', 'bricks-button' );
			$this->set_attribute( '_root', 'role', 'button' );

			if ( ! empty( $settings['size'] ) ) {
				$this->set_attribute( '_root', 'class', $settings['size'] );
			}

			if ( ! empty( $settings['style'] ) ) {
				// Outline
				if ( isset( $settings['outline'] ) ) {
					$this->set_attribute( '_root', 'class', 'outline' );
					$this->set_attribute( '_root', 'class', "bricks-color-{$settings['style']}" );
				}

				// Fill (= default)
				else {
					$this->set_attribute( '_root', 'class', "bricks-background-{$settings['style']}" );
				}
			}

			// Button circle
			if ( isset( $settings['circle'] ) ) {
				$this->set_attribute( '_root', 'class', 'circle' );
			}

			if ( isset( $settings['block'] ) ) {
				$this->set_attribute( '_root', 'class', 'block' );
			}
		}

		$aria_label = Helpers::get_value( $settings, 'aria_label', false );
		if( $aria_label ) {
			$this->set_attribute( '_root', 'aria-label', esc_html( bricks_render_dynamic_data( $aria_label ) ) );
		}

		if( ! empty( $this->settings['enableConfirmPopup'] ) ) {
			$data['isConfirm'] = "yes";
			$data['elementId'] = $this->id;
			$data['cancelButton'] = $settings['cancelButton'] ?? null;
			$data['confirmButton'] = $settings['okButton'] ?? null;

			$this->confirmModal = \Bricks\Frontend::render_children( $this );
		}

		$this->set_attribute('_root', 'data-wslc-config', wp_json_encode( $data ) );

		echo "<a href='{$url}' {$this->render_attributes('_root')}>";
		if( $button_text )
			echo "<span class='button-text'>{$button_text}</span>";
		
		$icon = ! empty( $settings['icon'] ) ? self::render_icon( $settings['icon'] ) : false;
		echo $icon;
		echo '</a>';
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-wsl-clean">
			<component
				:is="'a'"
				:class="[
					settings.link_button == 'button' ? 'bricks-button' : null,
					settings.size ? settings.size : null,
					settings.style ? settings.outline ? `outline bricks-color-${settings.style}` : `bricks-background-${settings.style}` : null,
					settings.circle ? 'circle' : null,
					settings.block ? 'block' : null
				]">
				<contenteditable tag="span" :name="name" controlKey="button_text" class="button-text" toolbar="style" :settings="settings"/>
				<icon-svg v-if="settings.icon" :iconSettings="settings.icon"/>
				<div class="buec-confirm-popup" v-if="settings.previewBuilder">
					<div class="bu-cnf-backdrop" v-if="!settings.disableBackdrop"></div>
					<div class="modal-content">
						<bricks-element-children :element="element" />
					</div>
				</div>
			</component>
		</script>
		<?php
	}

	public function confirmationModal() {
		$settings = $this->settings;

		if( $this->confirmModal ) :
			echo '<div class="buec-confirm-popup modal-' . $this->id . ' brxe-' . $this->id . '">';

				if( ! isset( $settings['disableBackdrop'] ) )
					echo '<div class="bu-cnf-backdrop"></div>';
				
				echo "<div class=\"modal-content\">";
				echo $this->confirmModal;
				echo "</div>";

			echo "</div>";
		endif;
	}
}