<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;
use BricksUltimate\Wishlist;

class WishlistCounter extends \Bricks\Element {
	public $category = 'wishlist';
	public $name 	= 'bu-wsl-counter';
	public $icon 	= 'ti-heart';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Wishlist Counter', 'bricksultimate' );
	}

	public function get_keywords() {
		return [ 'Wishlist', 'counter', 'count', 'wishlist link', 'wishlist total' ];
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['counter']    = array(
			'title' => esc_html__( 'Counter', 'bricks' ),
			'tab'   => 'content',
		);

		$this->control_groups['extra']    = array(
			'title' => esc_html__( 'Extra', 'bricks' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['postType'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Post type', 'bricks' ),
			'options'     => \Bricks\Helpers::get_registered_post_types(),
			'multiple'    => false,
			'placeholder' => esc_html__( 'Select post type', 'bricks' ),
			'default' 		=> 'post'
		];

		$this->controls['wslHideBtn'] = [
			'group' => 'extra',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Hide button when empty', 'bricksultimate')
		];

		$this->controls['ariaLabel'] = array(
			'group' 	=> 'extra',
			'type' 		=> 'text',
			'label'		=> esc_html__( 'Aria label', 'bricksultimate' ),
		);

		$this->controls['cta'] = array(
			'group' 	=> 'extra',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Call to action', 'bricksultimate' ),
			'default' 	=> 'none',
			'options' 	=> [
				'none' 		=> esc_html__( 'None', 'bricksultimate' ),
				//'popup' 	=> esc_html__( 'Show dropdown(on hover/click)', 'bricksultimate' ),
				'link' 		=> esc_html__( 'Link to URL', 'bricksultimate' ),
			]
		);

		$this->controls['pageLink'] = array(
			'tab' 		=> 'content',
			'group' 	=> 'extra',
			'type' 		=> 'link',
			'label'		=> esc_html__( 'URL', 'bricksultimate' ),
			'exclude' 	=> [
				'title',
				'ariaLabel',
				'newTab',
				'rel'
			],
			'required' 	=> [ 'cta', '=', 'link' ]
		);


		/**
		 * Button settings
		 */
		$this->controls['contentSource'] = array(
			'type' 		=> 'select',
			'label' 	=> esc_html__('Type', 'bricksultimate' ),
			'default' 	=> 'icon',
			'options' 	=> [
				'text' 		=> esc_html__( 'Text', 'bricksultimate' ),
				'icon' 		=> esc_html__( 'Icon', 'bricksultimate' ),
				'icontext' 	=> esc_html__( 'Icon + Text', 'bricksultimate' ),
			],
			'inline' 	=> true,
			'medium' 	=> true,
		);

		$this->controls['buttonText'] = array(
			'type' 		=> 'text',
			'label'		=> esc_html__( 'Button Text', 'bricksultimate' ),
			'required' 	=> [ 'contentSource', '!=', 'icon' ]
		);

		$this->controls['buttonTg'] = array(
			'type' 		=> 'typography',
			'label'		=> esc_html__( 'Typography', 'bricks' ),
			'required' 	=> [ 'contentSource', '!=', 'icon' ],
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => '.bu-wsl-counter-btn-text'
				]
			]
		);

		$this->controls['btnTxtHoverColor'] = [
			'type'     => 'color',
			'label'    => esc_html__( 'Hover Color', 'bricks' ),
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.bu-wsl-counter-btn:hover .bu-wsl-counter-btn-text',
				]
			],
			'required' 	=> [ 'contentSource', '!=', 'icon' ],
		];

		$this->controls['iconSep'] = array(
			'type' 		=> 'separator',
			'label'   	=> esc_html__( 'Icon', 'bricks' ),
			'required' 	=> [ 'contentSource', '!=', 'text' ]
		);

		$this->controls['heartIcon'] = [
			'label'   => esc_html__( 'Icon', 'bricks' ),
			'type'    => 'icon',
			'default' => [
				'library' => 'themify',
				'icon'    => 'ti-heart',
			],
			'required' 	=> [ 'contentSource', '!=', 'text' ],
		];

		$this->controls['iconPosition'] = array(
			'type' 		=> 'select',
			'label' 	=> esc_html__('Icon Position', 'bricksultimate' ),
			'default' 	=> 'right',
			'options' 	=> [
				'left' 		=> esc_html__( 'Left', 'bricks' ),
				'right' 	=> esc_html__( 'Right', 'bricks' )
			],
			'inline' 	=> true,
			'medium' 	=> true,
			'required' 	=> [ 'contentSource', '=', 'icontext' ]
		);

		$this->controls['iconGap'] = [
			'type'      => 'number',
			'label'     => esc_html__('Gap', 'bricksultimate'),
			'units' 	=> true,
			'default'   => 6,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-wsl-icon--right .bu-wsl-counter-btn-icon",
					'property' 	=> 'margin-left'
				],
				[
					'selector' 	=> ".bu-wsl-icon--left .bu-wsl-counter-btn-icon",
					'property' 	=> 'margin-right'
				]
			],
			'required' 	=> [ 'contentSource', '=', 'icontext' ]
		];

		$this->controls['iconColor'] = [
			'label'    => esc_html__( 'Color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.bu-wsl-counter-btn-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-wsl-counter-btn-icon'
				],
			],
			'required' 	=> [ 'contentSource', '!=', 'text' ]
		];

		$this->controls['iconHoverColor'] = [
			'label'    => esc_html__( 'Hover Color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.bu-wsl-counter-btn:hover .bu-wsl-counter-btn-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-wsl-counter-btn:hover .bu-wsl-counter-btn-icon'
				],
			],
			'required' 	=> [ 'contentSource', '!=', 'text' ]
		];

		$this->controls['iconSize'] = [
			'label' 	=> esc_html__( 'Size', 'bricks' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'css' 		=> [
				[
					'property' => 'font-size',
					'selector' => '.bu-wsl-counter-btn-icon'
				],
			],
			'placeholder' => '22px',
			'required' 	=> [ 'contentSource', '!=', 'text' ]
		];


		/**
		 * Counter settings
		 */
		$selector = '.bu-wsl-counter';
		$this->controls['hideCounter'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Completely hide counter', 'bricksultimate')
		];

		$this->controls['hideCounterIsEmpty'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Hide it when empty', 'bricksultimate')
		];

		$this->controls['bubble'] = [
			'tab' 		=> 'content',
			'group' 	=> 'counter',
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__('Show in bubble', 'bricksultimate'),
			'default'	=> true
		];

		$this->controls['counterPosition'] = array(
			'tab'   	=> 'content',
			'group' 	=> 'counter',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Position', 'bricks' ),
			'default' 	=> 'left',
			'options' 	=> [
				'left' 		=> esc_html__( 'Left', 'bricks' ),
				'right' 	=> esc_html__( 'Right', 'bricks' )
			],
			'inline' 	=> true,
			'medium' 	=> true,
			'required' 	=> ['bubble', '!=', true]
		);

		$this->controls['counterGap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'counter',
			'type'      => 'number',
			'label'     => esc_html__('Gap(px)', 'bricksultimate'),
			'unitless' 	=> true,
			'min'		=> 0,
			'max'  		=> 100,
			'step' 		=> 1,
			'default'   => 6,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".bu-wsl-counter--right .bu-wsl-counter",
					'property' 	=> 'margin-left',
					'value'		=> '%spx'
				],
				[
					'selector' 	=> ".bu-wsl-counter--left .bu-wsl-counter",
					'property' 	=> 'margin-right',
					'value'		=> '%spx'
				]
			],
			'required' 	=> ['bubble', '!=', true]
		];

		$this->controls['bubbleTop'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'number',
			'label' => esc_html__('Position top', 'bricksultimate'),
			'units' => true,
			'placeholder' => '5px',
			'css'	=> [
				[
					'property' 	=> 'top',
					'selector' 	=> $selector
				]
			],
			'required' 	=> ['bubble', '=', true]
		];

		$this->controls['bubbleRight'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'number',
			'label' => esc_html__('Position right', 'bricksultimate'),
			'units' => true,
			'placeholder' => '-4px',
			'css'	=> [
				[
					'property' 	=> 'right',
					'selector' 	=> $selector
				]
			],
			'required' 	=> ['bubble', '=', true]
		];

		$this->controls['counterWidth'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'number',
			'label' => esc_html__('Width', 'bricks'),
			'units' => true,
			'inline' => true,
			'css'	=> [
				[
					'property' 	=> 'width',
					'selector' 	=> $selector
				]
			],
			'required' 	=> ['bubble', '!=', true]
		];

		$this->controls['counterHeight'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'number',
			'label' => esc_html__('Height', 'bricks'),
			'units' => true,
			'css'	=> [
				[
					'property' 	=> 'height',
					'selector' 	=> $selector
				]
			],
			'required' 	=> ['bubble', '!=', true]
		];

		$this->controls['bubbleSize'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'number',
			'label' => esc_html__('Bubble size', 'bricksultimate'),
			'units' => true,
			'placeholder' => '16px',
			'css'	=> [
				[
					'property' 	=> 'width',
					'selector' 	=> ".bu-wsl-counter-in-bubble {$selector}"
				],
				[
					'property' 	=> 'height',
					'selector' 	=> ".bu-wsl-counter-in-bubble {$selector}"
				],
				[
					'property' 	=> 'line-height',
					'selector' 	=> ".bu-wsl-counter-in-bubble {$selector}"
				]
			],
			'required' 	=> ['bubble', '=', true]
		];

		$this->controls['counterBG'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css'	=> [
				[
					'property' 	=> 'background-color',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['counterHBG'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'color',
			'label' => esc_html__('Hover background', 'bricks'),
			'css'	=> [
				[
					'property' 	=> 'background-color',
					'selector' 	=> '&:hover ' . $selector
				]
			]
		];

		$this->controls['counterTG'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css'	=> [
				[
					'property' 	=> 'font',
					'selector' 	=> $selector
				]
			]
		];

		$this->controls['counterHClr'] = [
			'tab' 	=> 'content',
			'group' => 'counter',
			'type' 	=> 'color',
			'label' => esc_html__('Hover color', 'bricks'),
			'css'	=> [
				[
					'property' 	=> 'color',
					'selector' 	=> '&:hover ' . $selector
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-wishlistcompare' );
		} else {*/
			wp_enqueue_script( 'bu-wishlist' );
		//}
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$post_type 		= Helpers::get_value( $settings, 'postType', 'post' );
		$counter 		= Wishlist::get_wishlist_counter( $post_type );
		$cta 			= Helpers::get_value( $settings, 'cta', 'none' );
		$button_label 	= Helpers::get_value( $settings, 'contentSource', 'icon' );
		$class 			= [ 'bu-wsl-counter-btn', 'bu-wsl-counter-cta-' . $cta, 'bu-wsl-counter-btn--' . $post_type ];

		if( ! empty( $settings['wslHideBtn'] ) ) {
			$this->set_attribute( '_root', 'class', 'bu-wsl-hide-counter-btn--' . $post_type );

			if( $counter <= 0 ) {
				$this->set_attribute( '_root', 'class', 'bu-wsl-hide-btn' );
			}
		}

		//* root markup start
		echo "<div {$this->render_attributes("_root")}>";

		$link = Helpers::get_value( $settings, 'pageLink', false );
		if( $link )
			$this->set_link_attributes( '_wslbutton', $settings['pageLink'] );
		else
			$this->set_attribute( '_wslbutton', 'href', 'JavaScript: void(0)' );

		$wsl_counter_html = '';
		if( empty( $settings['hideCounter'] ) ) {

			$wsl_counter_html = "<span class='bu-wsl-counter'>{$counter}</span>";

			if( ! empty( $settings['bubble'] ) )
				$class[] = 'bu-wsl-counter-in-bubble';
			else
				$class[] = 'bu-wsl-counter--' . Helpers::get_value( $settings, 'counterPosition', 'left' );

			if( ! empty( $settings['hideCounterIsEmpty'] ) ) {
				$class[] = 'hide-empty-wsl-counter';
			}

			if( ! empty( $settings['hideCounterIsEmpty'] ) && $counter <= 0 ) {
				$class[] = 'bu-wsl-counter-hide-counter';
			}
		}

		if( $button_label == 'icontext' ) {
			$class[] = 'bu-wsl-icon--' . Helpers::get_value( $settings, 'iconPosition', 'right' );
		}

		$this->set_attribute( '_wslbutton', 'class', $class );
		$this->set_attribute( '_wslbutton', 'aria-label', esc_attr( Helpers::get_value( $settings, 'ariaLabel', 'Wishlist' ) ) );
		$this->set_attribute( '_wslbutton', 'role', "button" );

		//* cart button markup start
		echo "<a {$this->render_attributes("_wslbutton")}>";

		//*counter markup
		echo $wsl_counter_html;

		//* button contents wrapper start
		$this->set_attribute( '_wslbuttoncontents', 'class', 'wsl-btn-contents' );
		echo "<span {$this->render_attributes("_wslbuttoncontents")}>";

		if( ! empty( $settings['heartIcon'] ) && $button_label !== 'text' )
			echo self::render_icon( $settings['heartIcon'], ['class' => [ 'bu-wsl-counter-btn-icon'] ] );
		
		if( ! empty( $settings['buttonText'] ) && $button_label !== 'icon' )
			echo '<span class="bu-wsl-counter-btn-text">' . esc_attr( $settings['buttonText'] ) . '</span>';

		echo '</span>'; //* button contents wrapper end

		echo "</a>"; //* wsl button markup end

		echo "</div>";
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-wsl-counter">
			<component :is="tag">
				<a 
					:href="settings.cta == 'link' ? settings.pageLink : 'JavaScript: void(0)'" 
					class="bu-wsl-counter-btn" 
					:class="[
						`bu-wsl-counter-cta-${settings.contentSource}`,
						settings.hideCounter ? 'bu-hide-wsl-counter' : 'bu-show-wsl-counter',
						settings.contentSource === 'icontext' ? `bu-wsl-icon--${settings.iconPosition}`: null,
						!settings.hideCounter && settings.bubble ? 'bu-wsl-counter-in-bubble' : null,
						!settings.hideCounter && !settings.bubble ? `bu-wsl-counter--${settings.counterPosition}` : null 
					]"
					role="button" 
					:aria-label="settings.ariaLabel"
					:data-bucc-config="JSON.stringify({})"
				>
					
					<span class="bu-wsl-counter">0</span>

					<span class="wsl-btn-contents">
						<icon-svg v-if="settings.heartIcon && settings.contentSource != 'text'" :iconSettings="settings.heartIcon" class="bu-wsl-counter-btn-icon"/>
						<span v-if="settings.buttonText != null && settings.contentSource != 'icon'" class="bu-wsl-counter-btn-text">{{settings.buttonText}}</span>
					</span>
				</a>
			</component>
		</script>
	<?php 
	}
}