<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooAppliedCoupons extends \Bricks\Element {
	public $category 	= 'coupon';
	public $name 		= 'bu-coupons';
	public $icon 		= 'ti-money';
	public $called 		= false;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Applied Coupons', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_controls() {

		$this->controls['typographyText'] = [
			'tab' 		=> 'content',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.bu-coupon-code',
					'property'  => 'font',
				]
			]
		];

		$this->controls['code'] = [
			'tab' 		=> 'content',
			'type'      => 'typography',
			'label'     => esc_html__('Coupon code', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.bu-coupon-code strong',
					'property'  => 'font',
				]
			]
		];

		$this->controls['price'] = [
			'tab' 		=> 'content',
			'type'      => 'typography',
			'label'     => esc_html__('Price', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.woocommerce-Price-amount.amount',
					'property'  => 'font',
				]
			]
		];

		$this->controls['remove'] = [
			'tab' 		=> 'content',
			'type'      => 'typography',
			'label'     => esc_html__('Remove link', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.bu-remove-coupon',
					'property'  => 'font',
				]
			]
		];
	}

	// Render element HTML
	public function render() {
		if( bricks_is_builder() || Helpers::isBricksBuilderActive() ) {
			echo "<div {$this->render_attributes("_root")}>";
			echo '<div class="cart-discount coupon-discount5">
					<span class="bu-coupon-code">Discount: <strong>discount5</strong> <a href="#" class="bu-remove-coupon" data-coupon="discount5">[Remove]</a>
					</span>
					<span class="cart-discount-value">-<span class="woocommerce-Price-amount amount"><bdi><span class="woocommerce-Price-currencySymbol">$</span>5</bdi></span>
					</span>
				</div>';
			echo "</div>";
		} else {
			echo "<div {$this->render_attributes("_root")}>";
			\BricksUltimate\WooCommerce::appliedCoupons();
			echo "</div>";
		}
	}
}