<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\{Plugin, Helpers};

class WooCartContent extends \Bricks\Element {
	public $category 	= 'cart';
	public $name 		= 'bu-cart-content';
	public $icon 		= 'ti-shopping-cart-full';
	public $called 		= false;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Cart Content', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['remove'] = [
			'title' 	=> esc_html__( 'Remove Link', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['qty'] = [
			'title' 	=> esc_html__( 'Quantity', 'bricksultimate' ),
			'tab' 		=> 'content',
		];

		$this->control_groups['variation'] = [
			'title' 	=> esc_html__( 'Variations', 'bricksultimate' ),
			'tab' 		=> 'content',
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['imageWidth'] = [
			'label' 	=> esc_html__( 'Image width', 'bricks' ),
			'type'  	=> 'number',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => '--image-width',
				]
			],
			'placeholder' => '55px'
		];

		$selector = '.product-image img';

		$this->controls['imgBrd'] = [
			'label' 	=> esc_html__( 'Border(Image)', 'bricksultimate' ),
			'type'  	=> 'border',
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector,
				]
			],
		];

		$this->controls['imgPadding'] = [
			'label' 	=> esc_html__( 'Padding(Image)', 'bricksultimate' ),
			'type'  	=> 'dimensions',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$selector = 'li';
		$this->controls['blockSep'] = [
			'tab' 	=> 'content',
			'label' => esc_html__( 'Item block', 'bricks' ),
			'type'  => 'separator',
		];

		//margin field
		$this->controls['blockMargin'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['blockPadding'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['blockBG'] = [
			'tab' 	=> 'content',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector,
				]
			],
		];

		$this->controls['blockHBG'] = [
			'tab' 	=> 'content',
			'label' => esc_html__( 'Hover background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector . ":hover",
				]
			],
		];

		$this->controls['blockBorder'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'type'  	=> 'border',
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector,
				]
			],
		];

		$this->controls['blockShadow'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Box shadow', 'bricks' ),
			'type'  	=> 'box-shadow',
			'css'   	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				]
			],
		];

		$this->controls['titleSep'] = [
			'tab' 	=> 'content',
			'label' => esc_html__( 'Product title', 'bricks' ),
			'type'  => 'separator',
		];

		$this->controls['prdTitle'] = [
			'tab' 	=> 'content',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.product-title--link',
				]
			],
		];

		$this->controls['prdTitleHC'] = [
			'tab' 	=> 'content',
			'label' => esc_html__( 'Hover color', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => '.product-title--link:hover',
				]
			],
		];

		$this->controls['prdPrice'] = [
			'tab' 	=> 'content',
			'label' => esc_html__( 'Price', 'bricks' ),
			'type'  => 'typography',
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.brxe-bu-cart-item-qty .woocommerce-Price-amount.amount',
				]
			],
			'exclude' => ['text-align', 'letter-spacing']
		];

		$this->removeControls();
		$this->qtyControls();
		$this->variationsControls();

		$this->controls[ '_margin' ]['css'][0]['selector'] = '.widget_shopping_cart_content';
		$this->controls[ '_padding' ]['css'][0]['selector'] = '.widget_shopping_cart_content';
	}

	/**
	 * Remove button controls
	 * 
	 * @return void
	 */
	public function removeControls() {
		$selector = ".remove_from_cart_button";

		$this->controls['rmMargin'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['rmPadding'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['rmWidth'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'label' 	=> esc_html__( 'Width', 'bricks' ),
			'type'  	=> 'number',
			"units" 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$this->controls['rmHeight'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'label' 	=> esc_html__( 'Height', 'bricks' ),
			'type'  	=> 'number',
			"units" 	=> true,
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$this->controls['rmSize'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'label' 	=> esc_html__( 'Size', 'bricks' ),
			'type'  	=> 'number',
			"units" 	=> true,
			'css'   	=> [
				[
					'property' => 'font-size',
					'selector' => $selector,
				]
			],
			'placeholder' 	=> '18px'
		];

		$this->controls['rmBG'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['rmColor'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'color'
				],
				[
					'selector' 	=> $selector,
					'property' 	=> 'fill'
				]
			]
		];

		$this->controls['rmBorder'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['rmHover'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'type'      => 'separator',
			'label'     => esc_html__('Hover', 'bricks'),
		];

		$this->controls['rmHBG'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector . ":hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['rmHColor'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector . ":hover",
					'property' 	=> 'color'
				],
				[
					'selector' 	=> $selector . ":hover",
					'property' 	=> 'fill'
				]
			]
		];

		$this->controls['rmHBorder'] = [
			'tab' 		=> 'content',
			'group'    	=> 'remove',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":hover",
					'property' 	=> 'border'
				]
			]
		];
	}

	/**
	 * Quantity input controls
	 * 
	 * @return void
	 */
	public function qtyControls() {
		//* Quantity
		$selector = '.quantity';

		$this->controls['qtyWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'qty',
			'type'      => 'number',
			'label'     => esc_html__( 'Wrapper Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '80px',
			'css'   	=> [
				[
					'property' => '--qty-wrapper',
					'selector' => '',
				]
			],
		];

		$this->controls['qtyHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'qty',
			'type'      => 'number',
			'label'     => esc_html__( 'Wrapper Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$this->controls['wraprBg'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Wrapper Background', 'bricksultimate' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			]
		];

		$this->controls['wrapBorder'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Wrapper Border', 'bricksultimate' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			],
		];

		$this->controls['pmBtnSep'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( '+/- Buttons', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$this->controls['pmBtnWidth'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $selector . ' .action',
				]
			],
			'placeholder' => '25px'
		];

		$this->controls['pmBtnBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['pmBtnSize'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'type'  => 'number',
			'unit' 	=> 'px',
			'placeholder' => '13px', 
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'width',
				],
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'height',
				]
			]
		];

		$this->controls['pmBtnColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['pmBtnBrd'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action',
					'property' 	=> 'border',
					'important' => true
				]
			]
		];

		$this->controls['pmBtnHBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Background', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['pmBtnHColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover svg',
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['pmBtnHBrd'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Hover Border', 'bricks' ),
			'type'  => 'border',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover',
					'property' 	=> 'border',
					'important' => true
				]
			]
		];

		$this->controls['inpSep'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Quantity field', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$this->controls['inpWidth'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $selector . ' .qty',
				],
			],
			'placeholder' => '25px'
		];

		$this->controls['inpBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['qtySize'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Font Size', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'font-size',
					'selector' => $selector . ' .qty',
				],
			],
			'placeholder' => '10px'
		];

		$this->controls['inpColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty',
					'property' 	=> 'color',
				]
			]
		];

		$this->controls['inpFocusBG'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Focus Background', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty:focus',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['inpFocusColor'] = [
			'tab'   => 'content',
			'group' => 'qty',
			'label' => esc_html__( 'Focus Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty:focus',
					'property' 	=> 'color',
				]
			]
		];
	}

	/**
	 * Variations controls
	 * 
	 * @return void
	 */
	public function variationsControls() {
		//margin field
		$this->controls['vMargin'] = [
			'tab' 		=> 'content',
			'group'	 	=> 'variation',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => '.variation',
				]
			],
		];

		$this->controls['variationKey'] = [
			'tab'   => 'content',
			'group' => 'variation',
			'type'  => 'typography',
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' 	=> 'font',
					'selector' 	=> '.variation dt'
				]
			]
		];

		$this->controls['variationValue'] = [
			'tab'   => 'content',
			'group' => 'variation',
			'type'  => 'typography',
			'label' => esc_html__( 'Value', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' 	=> 'font',
					'selector' 	=> '.variation dd p'
				]
			]
		];
	}

	public function add_actions() {
		add_action( 'woocommerce_before_mini_cart_contents', function() {
			add_filter( 'woocommerce_is_attribute_in_product_name', '__return_false' );
		});

		add_action( 'woocommerce_mini_cart_contents', function() {
			remove_filter( 'woocommerce_is_attribute_in_product_name', '__return_false' );
		});
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-item-qty', Helpers::get_asset_url('css') . 'buitemqty.min.css', [], filemtime(Helpers::get_asset_path('css') . 'buitemqty.min.css' ));

			wp_enqueue_style( 'bu-cart-content', Helpers::get_asset_url('css') . 'cartcontent.min.css', [], filemtime(Helpers::get_asset_path('css') . 'cartcontent.min.css'), 'all' );
		}*/

		wp_enqueue_script( 'bu-item-qty', Helpers::get_asset_url('js') . 'buitemqty.min.js', ['jquery','wc-cart-fragments'], filemtime(Helpers::get_asset_path('js') . 'buitemqty.min.js' ), true
		);
	}

	// Render element HTML
	public function render() {
		if( ( bricks_is_builder() || Helpers::isBricksBuilderActive() ) && \Bricks\Capabilities::current_user_can_use_builder( $this->post_id ) ) {
			echo "<div {$this->render_attributes('_root')}><div class='cart-content widget_shopping_cart_content'>";
			\woocommerce_mini_cart();
			echo "</div></div>";
		} else {
			$emptyCarthtml = '';
			$buSettings = Plugin::$bu_settings;
			if( $buSettings && isset( $buSettings['ccempty'] ) && $buSettings['ccempty'] != 'none' && !Helpers::isBricksBuilderActive() ) {
				$emptyCarthtml .= "<div class='bu-empty-cart-msg-tpl screen-reader-text'>";
				$emptyCarthtml .= do_shortcode("[bricks_template id={$buSettings['ccempty']}]");
				$emptyCarthtml .= "</div>";
			}

			$contentHtml = get_option('bultimate_client')??'';

			echo "<div {$this->render_attributes('_root')}>{$emptyCarthtml}{$contentHtml}<div class='widget_shopping_cart_content'></div></div>";
		}
	}
}