<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooCartItemFormatedData extends \Bricks\Element {
	public $category 	= 'cart';
	public $name 		= 'bu-cart-item-data';
	public $icon 		= 'ti-list';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Variation Attributes', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_controls() {
		$this->controls['variationKey'] = [
			'tab'   => 'content',
			'type'  => 'typography',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'css' 	=> [
				[
					'property' 	=> 'font',
					'selector' 	=> ''
				]
			]
		];

		$this->controls['variationValue'] = [
			'tab'   => 'content',
			'type'  => 'typography',
			'label' => esc_html__( 'Value Typography', 'bricks' ),
			'css' 	=> [
				[
					'property' 	=> 'font',
					'selector' 	=> '.variation dd'
				]
			]
		];
	}

	// Render element HTML
	public function render() {
		if( is_null( WC()->cart ) || WC()->cart->is_empty() )
			return;

		$product_id = $this->post_id;
		$loop_object = false;

		$loop_object_type = \Bricks\Query::is_looping() ? \Bricks\Query::get_query_object_type() : false;
		if ( $loop_object_type === 'wooCart' ) {
			$loop_object = \Bricks\Query::get_loop_object();
		} else {
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
				if( $cart_item['product_id'] == $product_id || $cart_item['variation_id'] == $product_id ) {
					$loop_object = $cart_item;
					break;
				}
			}
		}

		if( ! $loop_object )
			return;

		add_filter( 'woocommerce_is_attribute_in_product_name', '__return_false' );
		$variationsData = wc_get_formatted_cart_item_data( $loop_object );
		
		if( $variationsData ) {
			echo "<{$this->tag} {$this->render_attributes('_root')}>";

			echo $variationsData;

			echo "</{$this->tag}>";
		}
	}
}