<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooCheckboxAddToCart extends \Bricks\Element {
	public $category = 'ultimate';
	public $name 	= 'bu-cb-atc';
	public $icon 	= 'ti-shopping-cart-full';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Checkbox Add To Cart', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['info'] = [
			'type' 	=> 'info',
			'content' => esc_html__( 'It should only work for the Simple and Variation products.', 'bricksultimate' ),
		];

		$this->controls['action'] = [
			'type' 		=> 'select',
			'label'		=> esc_html__( 'Action', 'bricksultimate' ),
			'options' 	=> [
				'atc' 	=> esc_html__( 'Add To Cart', 'bricksultimate' )
			],
			'inline'    => true,
			'default' 	=> 'atc',
			'placeholder' => esc_html__( 'Add To Cart', 'bricksultimate' )
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		//wp_enqueue_script('wc-add-to-cart-variation');
		//wp_enqueue_style( 'bu-swatches' );
		//wp_enqueue_script( 'bu-swatches' );
		wp_enqueue_script( 'bu-atc', Helpers::get_asset_url('js') . 'buatc.min.js', ['wc-add-to-cart'], filemtime(Helpers::get_asset_path('js') . 'buatc.min.js'), true );
	}

	// Render element HTML
	public function render() {
		global $product;

		$product = wc_get_product( $this->post_id );

		if( empty( $product ) && ( bricks_is_builder() || bricks_is_builder_iframe() || Helpers::isBricksBuilderActive() ) ) {
			$product = wc_get_products(
				[
					'limit'   	=> 1,
					'type' 		=> 'simple',
					'status' 	=> 'publish',
					'orderby' 	=> 'date',
					'order'   	=> 'DESC',
				]
			)[0];
		}

		if ( empty( $product ) ) {
			return $this->render_element_placeholder(
				[
					'title'       => esc_html__( 'For better preview select content to show.', 'bricks' ),
					'description' => esc_html__( 'Go to: Settings > Template Settings > Populate Content', 'bricks' ),
				]
			);
		}

		$settings = $this->settings;
		$type = $product->get_type();
		$action = Helpers::get_value( $settings, 'action', 'atc' );

		if( in_array( $type, [ 'grouped', 'external', 'composite' ] ) )
			return;

		$this->set_attribute('_root', 'class', [ "product-type-{$type}"] );
		echo "<div {$this->render_attributes('_root')}>";

		$this->set_attribute('checkbox-add-to-cart', 'type', "checkbox" );

		if( 'atc' === $action ) {
			$this->doAddToCart( $product );
		}

		echo "</div>";
	}

	public function doAddToCart( &$product ) {
		if(  ( $product->get_type() == 'simple' || $product->get_type() == 'variation' ) 
			&& $product->is_purchasable() && $product->is_in_stock()
		) {
			$incart = false;
			if( ! is_null( WC()->cart ) && is_a( $product, '\WC_Product' ) ) {
				foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
					if ( $cart_item['product_id'] == $product->get_id() ) {
						$this->set_attribute('checkbox-add-to-cart', 'checked', "checked" );
						$this->set_attribute('checkbox-add-to-cart', 'data-cart_item_key', $cart_item_key );
						$this->set_attribute('checkbox-add-to-cart', 'class', [ "add-to-cart-cb", "remove", "remove_from_cart_button" ] );
						$incart = true;
						break;
					}
				}
			}
			
			if( ! $incart )
				$this->set_attribute('checkbox-add-to-cart', 'class', [ "add-to-cart-cb", "ajax_cb_add_to_cart" ] );

			$this->set_attribute('checkbox-add-to-cart', 'data-product_id', $product->get_id() );
			$this->set_attribute('checkbox-add-to-cart', 'data-quantity', 1 );
			$this->set_attribute('checkbox-add-to-cart', 'data-product_sku', $product->get_sku() );
			$this->set_attribute('checkbox-add-to-cart', 'data-product_type', $product->get_type() );
			$this->set_attribute('checkbox-add-to-cart', 'aria-label', $product->add_to_cart_description() );
			$this->set_attribute('checkbox-add-to-cart', 'aria-describedby_text', $product->add_to_cart_aria_describedby() );
			echo "<input {$this->render_attributes('checkbox-add-to-cart')} />";
		}
	}
}