<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\{Helpers, WooCommerce};
use Automattic\WooCommerce\Utilities\NumberUtil;

class WooFreeShippingBar extends \Bricks\Element {
	public $category 		= 'free shipping notice';
	public $name 			= 'bu-free-shipping-bar';
	public $icon 			= 'ti-layout-line-solid';
	public $scripts 		= ['buCalculateBarProgress'];

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Free Shipping Bar', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['info'] = [
			'tab' 		=> 'content',
			'type' 		=> 'info',
			'content' 	=> sprintf( __( 'A <a href="%s" target="_blank">free shipping method</a> must be enabled in your shipping zone and be set to the "Free Shipping Requires", "Minimum order amount", etc setting.', 'woocommerce' ), 'https://docs.woocommerce.com/document/free-shipping/' )
		];

		$this->controls['thresholdAmount'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Threshold amount', 'bricksultimate' ),
			'info' 		=> esc_html__( 'Threshold amount after which notice should start appear. Do not enter the currency.', "bricksultimate" ),
			'type' 		=> 'text',
			'placeholder' 	=> 50,
			'hasDynamicData' => false
		];

		$this->controls['hideBar'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Hide when free shipping rule is reached', 'bricksultimate' ),
			'type' 		=> 'checkbox',
			'reset' 	=> true
		];

		$this->controls['fsnSeparator'] = [
			'tab' 		=> 'content',
			'type' 		=> 'separator',
		];

		$this->controls['hidePrice'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Hide price', 'bricksultimate' ),
			'type' 		=> 'checkbox',
			'reset' 	=> true
		];

		$this->controls['priceTypography'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Price Typography', 'bricksultimate' ),
			'type' 		=> 'typography',
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => '.woocommerce-Price-amount.amount',
				],
			],
			'required' 	=> ['hidePrice', '!=', true]
		];

		$this->controls['gap'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Gap between price and bar', 'bricksultimate' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'inline' 	=> true,
			'placeholder' => '10px',
			'css' 		=> [
				[
					'property' => 'margin-right',
					'selector' => '.fsn-progress-bar-min-price',
				],
				[
					'property' => 'margin-left',
					'selector' => '.fsn-progress-amount',
				],
			],
			'required' 	=> ['hidePrice', '!=', true]
		];

		$this->controls['barSeparator'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Progress Bar', 'bricksultimate' ),
			'type' 		=> 'separator'
		];

		$this->controls['barHeight'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Height', 'bricksultimate' ),
			'type' 		=> 'number',
			'unit' 		=> 'px',
			'inline' 	=> true,
			'placeholder' => '7',
			'css' 		=> [
				[
					'property' => 'height',
					'selector' => '.fsn-progress-bar',
				]
			]
		];

		$this->controls['barColor'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Color', 'bricksultimate' ),
			'type' 		=> 'color',
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => '.fsn-progress-bar',
				]
			]
		];

		$this->controls['barAltColor'] = [
			'tab' 		=> 'content',
			'label' 	=> esc_html__( 'Alt Color', 'bricksultimate' ),
			'type' 		=> 'color',
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => '.fsn-progress-bar-res',
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*wp_enqueue_style( 'bu-fsn-bar', Helpers::get_asset_url('css') . 'fsn-bar.min.css', [], filemtime(Helpers::get_asset_path('css') . 'fsn-bar.min.css') );*/
		wp_enqueue_script( 'bu-fsn-bar', Helpers::get_asset_url('js') . 'fsnbar.min.js', [], filemtime(Helpers::get_asset_path('js') . 'fsnbar.min.js'), true );
		wp_enqueue_script( 'wc-cart-fragments' );
	}

	// Render element HTML
	public function render() {
		$min_amount = WooCommerce::freeShippingMinAmount();
		$decimals 	= \wc_get_price_decimals() == 0 ? 2 : \wc_get_price_decimals();

		if( Helpers::isBricksBuilderActive() && Helpers::parseCurrency( $min_amount ) <= 0 )
			$min_amount = number_format( 200, $decimals, wc_get_price_decimal_separator(), wc_get_price_thousand_separator() );

		$settings 		= $this->settings;
		$thresholdAmount = Helpers::get_value( $settings, 'thresholdAmount', false);
		$cart_total 	= WooCommerce::get_customer_order_amount();
		$formattedTotal = number_format( $cart_total, $decimals, \wc_get_price_decimal_separator(), \wc_get_price_thousand_separator() );
		$pbres = ( Helpers::parseCurrency( $formattedTotal ) < Helpers::parseCurrency( $min_amount ) ) ? round( ( Helpers::parseCurrency( $formattedTotal ) / Helpers::parseCurrency( $min_amount ) ) * 100 ) : 100;
		
		$attr = [
			'minAmount' 		=> $min_amount,
			'thresholdAmount' 	=> ( $thresholdAmount ) ? number_format( $thresholdAmount, $decimals, wc_get_price_decimal_separator(), wc_get_price_thousand_separator() ) : 'no',
			'hideBar' 			=> ! empty( $settings['hideBar'] ) ? 'yes' : 'no'
		];

		if( $thresholdAmount && ( Helpers::parseCurrency( $thresholdAmount ) > Helpers::parseCurrency( $cart_total ) ) && ! Helpers::isBricksBuilderActive() ) {
			$this->set_attribute('_root', 'class', 'screen-reader-text');
		}

		if( ( WooCommerce::hasFreeShippingMethod() === 'no' || ( $pbres == 100 && ! empty( $settings['hideBar'] ) ) ) && ! Helpers::isBricksBuilderActive() ) {
			$this->set_attribute('_root', 'class', 'screen-reader-text');
		}

		$this->set_attribute('_root', 'class', 'fsn-progress-bar-wrap');
		$this->set_attribute( '_root', 'data-fsn-bar', wp_json_encode( $attr ) );

		echo "<{$this->tag} {$this->render_attributes('_root')}>";
		
		if( empty( $settings['hidePrice'] ) ): ?>
			<span class="fsn-progress-bar-min-price"><?php echo wc_price(0) ; ?></span>
		<?php endif; ?>
		<div class="fsn-progress-bar">
			<div class="fsn-progress-bar-res" style="width: <?php echo $pbres; ?>%;"></div>
		</div>
		<?php if( empty( $settings['hidePrice'] ) ): ?>
			<span class="fsn-progress-amount">
				<?php echo wc_price( $min_amount ) ; ?>
			</span>
		<?php endif;

		echo "</{$this->tag}>";
	}
}