<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooShippingCalculator extends \Bricks\Element {
	public $category = 'ultimate';
	public $name 	= 'bu-shipping-cal';
	public $icon 	= 'ti-receipt';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Shipping Calculator', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['frmtitle'] = array(
			'title' => esc_html__( 'Form title', 'bricks' ),
			'tab'   => 'content'
		);

		$this->control_groups['fields'] = array(
			'title' => esc_html__( 'Form fields', 'bricks' ),
			'tab'   => 'content'
		);

		$this->control_groups['btn'] = array(
			'title' => esc_html__( 'Button', 'bricks' ),
			'tab'   => 'content'
		);

		$this->control_groups['shpmd'] = array(
			'title' => esc_html__( 'Shipping Methods', 'bricks' ),
			'tab'   => 'content'
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['pmInfo'] = [
			'type' 		=> 'info',
			'content' 	=> esc_html__( 'Refresh the builder editor for the preview.', 'bricksultimate' ),
		];

		$this->controls['hideAddress'] = [
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Disable shipping to text', 'bricksultimate' ),
		];

		$this->controls['disableForm'] = [
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Disable shipping form', 'bricksultimate' ),
		];

		$this->controls['addressTg'] = [
			'label' 	=> esc_html__( 'Typography(Shipping to)', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.woocommerce-shipping-destination',
				],
			],
			'required' => ['hideAddress', '=', false]
		];

		$this->controls['formWrapSep'] = [
			'type' 			=> 'separator',
			'label' 		=> esc_html__( 'Form Container', 'bricksultimate' ),
		];

		$selector = "form";

		$this->controls['containerBg'] = [
			'label' 	=> esc_html__( 'Background', 'bricks' ),
			'type' 		=> 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => $selector
				],
			]
		];

		$this->controls['containerMrg'] = [
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type' 		=> 'dimensions',
			'css'      => [
				[
					'property' => 'margin',
					'selector' => $selector
				],
			]
		];

		$this->controls['containerPad'] = [
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type' 		=> 'dimensions',
			'css'      => [
				[
					'property' => 'padding',
					'selector' => $selector
				],
			]
		];

		/**************************************
		 * Form Title
		 **************************************/

		$this->controls['formTitle'] = [
			'group' 		=> 'frmtitle',
			'type' 			=> 'text',
			'label' 		=> esc_html__( 'Title', 'bricksultimate' ),
			'placeholder' 	=> esc_html__( 'Calculate Shipping', 'bricksultimate' )
		];

		$selector = ".shipping-cal-title";
		$this->controls['titleTg'] = [
			'group' 	=> 'frmtitle',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['titleBg'] = [
			'group' 	=> 'frmtitle',
			'label' 	=> esc_html__( 'Background', 'bricks' ),
			'type' 		=> 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			]
		];

		$this->controls['titleBrd'] = [
			'group' 	=> 'frmtitle',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'type' 		=> 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			]
		];

		//margin field
		$this->controls['titlemrg'] = [
			'group' 	=> 'frmtitle',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['titlePad'] = [
			'group' 	=> 'frmtitle',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		/*****************************************
		 * Fields
		 *****************************************/
		$this->controls['disableCountry'] = [
			'group' 	=> 'fields',
			'label' 	=> esc_html__( 'Disable country', 'bricks' ),
			'type'  	=> 'checkbox',
		];

		$this->controls['disableState'] = [
			'group' 	=> 'fields',
			'label' 	=> esc_html__( 'Disable state / county', 'bricks' ),
			'type'  	=> 'checkbox',
		];

		$this->controls['disableCity'] = [
			'group' 	=> 'fields',
			'label' 	=> esc_html__( 'Disable city', 'bricks' ),
			'type'  	=> 'checkbox',
		];

		$this->controls['disablePostcode'] = [
			'group' 	=> 'fields',
			'label' 	=> esc_html__( 'Disable postcode', 'bricks' ),
			'type'  	=> 'checkbox',
		];

		$this->controls['labelSep'] = [
			'group' 	=> 'fields',
			'label' 	=> esc_html__( 'Label', 'bricksultimate' ),
			'type'  	=> 'separator',
		];

		/**
		 * Label
		 * ----------------------------------------*/
		$selector = '.form-row label:not(.radio)';

		$this->controls['labelDisable'] = [
			'group' => 'fields',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Hide label', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> $selector,
					'value' 	=> 'none'
				]
			]
		];

		$this->controls['labelTg'] = [
			'group' => 'fields',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			],
			'required' => ['labelDisable', '=', false]
		];

		$this->controls['labelGap'] = [
			'group' => 'fields',
			'type' 	=> 'number',
			'label' => esc_html__( 'Gap from left', 'bricksultimate' ),
			'units' => true,
			'css' 	=> [
				[
					'property' => 'left',
					'selector' => $selector
				]
			],
			'required' => ['labelDisable', '=', false]
		];

		$this->controls['inpSep'] = [
			'group' 	=> 'fields',
			'label' 	=> esc_html__( 'Input Fields', 'bricksultimate' ),
			'type'  	=> 'separator',
		];

		/**
		 * Fields
		 * ----------------------------------------*/
		$selector = 'input:not([type=submit]):not([type=radio]), .select2-selection, select';
		$selector2 = 'input:not([type=submit]):not([type=radio]), .select2-selection, select';
		$selector_f = 'input:not([type=submit]):focus, .select2-selection:focus, select:focus';

		$this->controls['fieldTg'] = [
			'group' => 'fields',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => $selector2
				],
				[
					'property' => 'font',
					'selector' => ".select2-container .select2-selection__rendered"
				],
			]
		];

		$this->controls['fieldBg'] = [
			'group' => 'fields',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector2
				]
			]
		];

		$this->controls['fieldBrd'] = [
			'group' => 'fields',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector2
				]
			]
		];

		$this->controls['fieldBs'] = [
			'group' => 'fields',
			'type' 	=> 'box-shadow',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector2
				]
			]
		];

		$this->controls['selectArrow'] = [
			'group' => 'fields',
			'type' 	=> 'color',
			'label' => esc_html__( 'Dropdown arrow color', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'border-top-color',
					'selector' => ".select2-selection__arrow b"
				]
			]
		];

		$this->controls['fieldFSep'] = [
			'group' => 'fields',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Focus', 'bricksultimate' ),
		];

		$this->controls['fieldFColor'] = [
			'group' => 'fields',
			'type' 	=> 'color',
			'label' => esc_html__( 'Text color', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'color',
					'selector' => $selector_f
				]
			]
		];

		$this->controls['fieldFBg'] = [
			'group' => 'fields',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => $selector_f
				]
			]
		];

		$this->controls['fieldFBrd'] = [
			'group' => 'fields',
			'type' 	=> 'border',
			'label' => esc_html__( 'Border', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => $selector_f
				]
			]
		];

		$this->controls['fieldFBs'] = [
			'group' => 'fields',
			'type' 	=> 'box-shadow',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector_f
				]
			]
		];

		$this->controls['fieldSep'] = [
			'group' => 'fields',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Fields Size', 'bricks' ),
		];

		$this->controls['fieldW'] = [
			'group' => 'fields',
			'type' 	=> 'number',
			'label' => esc_html__( 'Width', 'bricks' ),
			'units' => true,
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => $selector
				]
			]
		];

		$this->controls['fieldMH'] = [
			'group' => 'fields',
			'type' 	=> 'number',
			'label' => esc_html__( 'Min-height', 'bricks' ),
			'units' => true,
			'css' 	=> [
				[
					'property' => 'min-height',
					'selector' => $selector
				]
			]
		];

		$this->controls['fieldH'] = [
			'group' => 'fields',
			'type' 	=> 'number',
			'label' => esc_html__( 'Height', 'bricks' ),
			'units' => true,
			'css' 	=> [
				[
					'property' => 'height',
					'selector' => $selector
				]
			]
		];


		$this->controls['fieldMrg'] = [
			'group' => 'fields',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Margin', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => '.form-row'
				]
			],
		];

		$this->controls['fieldPad'] = [
			'group' => 'fields',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Spacing', 'bricks' ),
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => '.select2-selection:focus, .select2-selection:valid, p.is-active .select2-selection, p.is-active input:not([type=submit]):not(.checkbox):not(.radio), &.is-active .select2-selection, &.is-active select, select'
				]
			],
		];

		/*****************************************
		 * button
		 *****************************************/
		$this->controls['button_text'] = [
			'group' 		=> 'btn',
			'type' 			=> 'text',
			'label' 		=> esc_html__( 'Button Text', 'bricksultimate' ),
			'placeholder' 	=> esc_html__( 'Update', 'bricksultimate' )
		];

		$this->controls['loadingColor'] = [
			'group' 	=> 'btn',
			'label'    	=> esc_html__( 'Loading icon color', 'bricksultimate' ),
			'type'     	=> 'color',
			'css'      	=> [
				[
					'property' => '--loading-color'
				],
			],
		];

		$selector = '.button';

		$this->controls['btnSpSep'] = [
			'group' 	=> 'btn',
			'label' 	=> esc_html__( 'Spacing & Size', 'bricks' ),
			'type'  	=> 'separator',
		];

		$this->controls['btnWidth'] = [
			'group' 	=> 'btn',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricksultimate'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['btnMHeight'] = [
			'group' 	=> 'btn',
			'type'      => 'number',
			'label'     => esc_html__('Min-height', 'bricksultimate'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'min-height'
				]
			]
		];

		$this->controls['btnHeight'] = [
			'group' 	=> 'btn',
			'type'      => 'number',
			'label'     => esc_html__('Height', 'bricksultimate'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'height'
				]
			]
		];

		//margin field
		$this->controls['sub_mrg'] = [
			'group' 	=> 'btn',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['btnPad'] = [
			'group' 	=> 'btn',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['btnSepClose'] = [
			'group' 	=> 'btn',
			'type'  	=> 'separator',
		];

		$this->controls['btnBg'] = [
			'group' 	=> 'btn',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['btnFont'] = [
			'group' 	=> 'btn',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.button-text',
				],
			]
		];

		$this->controls['btnBrd'] = [
			'group' 	=> 'btn',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['btnShadow'] = [
			'group' 	=> 'btn',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['btnTs'] = [
			'group' 	=> 'btn',
			'type'      => 'text',
			'label'     => esc_html__('Transition', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'transition'
				]
			]
		];

		$this->controls['btnHoverSep'] = [
			'group' 	=> 'btn',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover', 'bricksultimate'),
		];

		$this->controls['btnHbg'] = [
			'group' 	=> 'btn',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['btnhclr'] = [
			'group' 	=> 'btn',
			'type'      => 'color',
			'label'     => esc_html__('Text color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['btnhbrd'] = [
			'group' 	=> 'btn',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['btnhshadow'] = [
			'group' 	=> 'btn',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];



		/*****************************************
		 * Methods
		 *****************************************/
		$this->controls['enableMethods'] = [
			'group' => 'shpmd',
			'type'  => 'checkbox',
			'label' => esc_html__( 'Enable shipping option', 'bricksultimate' ),
		];

		$this->controls['hideMethods'] = [
			'group' => 'shpmd',
			'type'  => 'checkbox',
			'label' => esc_html__( 'Hide shipping option', 'bricksultimate' ),
			'description' => esc_html__( 'When "Free Shipping" is available', 'bricksultimate' ),
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smWraper'] = [
			'group' => 'shpmd',
			'type' 	=> 'separator',
			'label' => esc_html__('Outer Container', 'bricksultimate'),
			'required' => ['enableMethods', '=', true]
		];

		$selector = ".shipping-methods-wrap";

		$this->controls['smwrapMrg'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'dimensions',
			'label' 	=> esc_html__( 'Margin', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smwrapPad'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smWrapperBg'] = [
			'group' 	=> 'shpmd',
			'label' 	=> esc_html__( 'Background', 'bricks' ),
			'type' 		=> 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smHeading'] = [
			'group' => 'shpmd',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Heading', 'bricks' ),
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smTitle'] = [
			'group' 		=> 'shpmd',
			'type' 			=> 'text',
			'label' 		=> esc_html__( 'Heading', 'bricksultimate' ),
			'placeholder' 	=> esc_html__( 'Shipping Methods', 'bricksultimate' ),
			'required' => ['enableMethods', '=', true]
		];

		$selector = ".shipping-methods-title";

		$this->controls['smTitleTg'] = [
			'group' 	=> 'shpmd',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smTitleBg'] = [
			'group' 	=> 'shpmd',
			'label' 	=> esc_html__( 'Background', 'bricks' ),
			'type' 		=> 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smTitleBrd'] = [
			'group' 	=> 'shpmd',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'type' 		=> 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			],
			'required' => ['enableMethods', '=', true]
		];

		//margin field
		$this->controls['smTitlemrg'] = [
			'group' 	=> 'shpmd',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		//padding field
		$this->controls['smTitlePad'] = [
			'group' 	=> 'shpmd',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smHeadingSep'] = [
			'group' => 'shpmd',
			'type' 	=> 'separator',
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smButtonsBG'] = [
			'group' => 'shpmd',
			'type'  => 'color',
			'label' => esc_html__( 'Background color', 'bricksultimate' ),
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => 'ul.woocommerce-shipping-methods li',
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smBorderW'] = [
			'group' => 'shpmd',
			'type' 	=> 'number',
			'label' => esc_html__( 'Border width', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => 'border-width',
					'selector' => 'ul.woocommerce-shipping-methods'
				],
				[
					'property' => 'border-bottom-width',
					'selector' => 'ul.woocommerce-shipping-methods li'
				]
			],
			'default' => '1px',
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smBorderColor'] = [
			'group' => 'shpmd',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => '--bricks-border-color'
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smBorderStyle'] = [
			'group' => 'shpmd',
			'type' 	=> 'select',
			'label' => esc_html__( 'Border style', 'bricksultimate' ),
			'options' => [ 'none' => 'none', 'solid' => 'Solid', 'dashed' => 'Dashed', 'dotted' => 'Dotted'],
			'css'	=> [
				[
					'property' => 'border-style',
					'selector' => 'ul.woocommerce-shipping-methods, ul.woocommerce-shipping-methods li'
				]
			],
			'default' => 'solid',
			'inline' => true,
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smBorderRadius'] = [
			'group' => 'shpmd',
			'type' 	=> 'number',
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => '--bricks-border-radius'
				]
			],
			'default' => '4px',
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smbtnsSpacing'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'dimensions',
			'label' 	=> esc_html__( 'Inner spacing', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => 'ul.woocommerce-shipping-methods li .bu-shipping-method-inner',
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smStyleSep'] = [
			'group' => 'shpmd',
			'type' 	=> 'separator',
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['methodTitle'] = [
			'group' => 'shpmd',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'font',
					'selector' => '.bu-shipping-method-inner label'
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['methodPrice'] = [
			'group' => 'shpmd',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Price', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'font',
					'selector' => '.bu-shipping-method-inner label .woocommerce-Price-amount'
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smRadioSep'] = [
			'group' => 'shpmd',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Radio', 'bricks' ),
			'required' => ['enableMethods', '=', true]
		];

		$rd_selector = 'ul.woocommerce-shipping-methods input[type=radio]';
		$this->controls['smrdsize'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' => '15px',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $rd_selector,
				],
				[
					'property' => 'height',
					'selector' => $rd_selector,
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smRdbg'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rd_selector,
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['smrdbrd'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rd_selector,
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$rdc_checked = 'ul.woocommerce-shipping-methods input[type=radio]:checked:after';
		$this->controls['smrdcbg'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => 'ul.woocommerce-shipping-methods input[type=radio]:checked',
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['rdCheckedBrd'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => 'ul.woocommerce-shipping-methods input[type=radio]:checked',
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['rdwrdsz'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Mini bullet size', 'bricksultimate' ),
			'placeholder' 	=> '6px',
			'min' 		=> 1,
			'max' 		=> 30,
			'step' 		=> 1,
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $rdc_checked
				],
				[
					'property' => 'height',
					'selector' => $rdc_checked
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['rdwbcolor'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Mini bullet color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rdc_checked
				]
			],
			'required' => ['enableMethods', '=', true]
		];

		$this->controls['rdBulletPos'] = [
			'group' 	=> 'shpmd',
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Bullet position(Translate)', 'bricksultimate' ),
			'placeholder' => '-50%,-50%',
			'css'   	=> [
				[
					'property' => '--bullet-position',
				]
			],
			'required' => ['enableMethods', '=', true]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-shipping-cal', Helpers::get_asset_url('css') . 'shippingcal.min.css', [], filemtime(Helpers::get_asset_path('css') . 'shippingcal.min.css') );
		} else {*/
			wp_enqueue_script( 'bu-shipping-cal', Helpers::get_asset_url('js') . 'shippingcal.min.js', [], filemtime(Helpers::get_asset_path('js') . 'shippingcal.min.js'), true );
		//}
	}

	// Render element HTML
	public function render() {
		if( ! Helpers::isBricksBuilderActive() ) {
			wp_enqueue_style( 'select2' );
			wp_enqueue_script( 'selectWoo' );
			wp_enqueue_script( 'wc-country-select' );
			wp_enqueue_script( 'wc-address-i18n' );
		}

		if( Helpers::isBricksBuilderEditor() ) {
			$this->set_attribute('_root', 'class', ['is-active'] );
			$packages = \WC()->shipping()->calculate_shipping( WC()->cart->get_shipping_packages() );
		}

		$settings = $this->settings;

		$this->set_attribute('_root', 'class', ['woocommerce'] );

		echo "<{$this->tag} {$this->render_attributes('_root')}>";

		$packages = \WC()->shipping()->get_packages();
		$available_methods = false;
		$has_free_shipping = false;
		if( $packages ):
			$package = $packages[0];

			$formatted_destination = WC()->countries->get_formatted_address( $package['destination'], ', ' );
			$available_methods = $package['rates'];

			if( empty( $settings['hideAddress'] ) ) {
				echo "<p class=\"woocommerce-shipping-destination\">";
				if ( $formatted_destination  ) {
					printf( esc_html__( 'Shipping to %s.', 'woocommerce' ) . ' ', '<strong>' . esc_html( $formatted_destination ) . '</strong>' );
				}
				echo "</p>";
			}

			if( ! empty( $settings['hideMethods'] ) ):
				foreach ( $package['rates'] as $rate_id => $rate ) {
					if ( 'free_shipping' === $rate->method_id ) {
						$has_free_shipping = true;
						break;
					}
				}
			endif;
		endif;

		// form
		if( empty( $settings['disableForm'] ) )
			$this->form();

		// methods
		if( $available_methods && ! empty( $settings['enableMethods'] ) && ! $has_free_shipping ) {
			echo "<{$this->tag} class='shipping-methods-wrap'>";
			$this->get_shipping_methods( $available_methods );
			echo "</{$this->tag}>";
		}

		echo "</{$this->tag}>";
	}

	public function get_shipping_methods( $available_methods ) {
		$chosen_method = isset( \WC()->session->chosen_shipping_methods[ 0 ] ) ? \WC()->session->chosen_shipping_methods[ 0 ] : '';
		$index = 0;
		$heading = Helpers::get_value( $this->settings, 'smTitle', false);
	?>
		<?php if( $heading ): ?>
		<h4 class="shipping-methods-title"><?php echo $heading; ?></h4>
		<?php endif; ?>

		<ul class="woocommerce-shipping-methods">
			<?php foreach ( $available_methods as $method ) : ?>
				<li>
					<div class="bu-shipping-method-inner">
					<?php
						if ( 0 < count( $available_methods ) ) {
							$label = wc_cart_totals_shipping_method_label( $method );
							$label = str_replace( ': <span', '<span', $label );
							printf( '<input type="radio" name="bu_shipping_method[%1$d]" data-index="%1$d" value="%2$s" class="bu-shipping-method" %3$s /><label for="shipping_method_%1$s_%2$s">%4$s</label>', $index, esc_attr( $method->id ), checked( $method->id, $chosen_method, false ), $label ); // WPCS: XSS ok.
						} else {
							printf( '<input type="hidden" name="bu_shipping_method[%1$d]" data-index="%1$d" value="%2$s" class="bu-shipping-method" />', $index, esc_attr( $method->id ) ); // WPCS: XSS ok.
						}

						do_action( 'woocommerce_after_shipping_rate', $method, $index );
					?>
					</div>
				</li>
			<?php endforeach; ?>
		</ul>
	<?php
	}

	public function form() {
		$settings = $this->settings;
		$class = Helpers::isBricksBuilderEditor() ? ' is-active' : '';
		do_action( 'woocommerce_before_shipping_calculator' );

		$title = bricks_render_dynamic_data( Helpers::get_value( $settings, 'formTitle', false ) );
		$hasCountry = ! empty( $settings['disableCountry'] ) ? false : true;
		$hasCounty = ! empty( $settings['disableState'] ) ? false : true;
		$hasCity = ! empty( $settings['disableCity'] ) ? false : true;
		$hasPostcode = ! empty( $settings['disablePostcode'] ) ? false : true;
	?>
		<?php if($title): ?>
		<h4 class="shipping-cal-title"><?php echo $title; ?></h4>
		<?php endif; ?>

		<form class="woocommerce-shipping-calculator" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
			<?php if ( apply_filters( 'woocommerce_shipping_calculator_enable_country', $hasCountry ) ) : ?>
				<p class="form-row form-row-wide<?php echo $class;?>" id="calc_shipping_country_field">
					<label for="calc_shipping_country"><?php esc_html_e( 'Country / region:', 'woocommerce' ); ?></label>
					<select name="calc_shipping_country" id="calc_shipping_country" class="country_to_state country_select" rel="calc_shipping_state">
						<option value="default"><?php esc_html_e( 'Select a country / region&hellip;', 'woocommerce' ); ?></option>
						<?php
						foreach ( WC()->countries->get_shipping_countries() as $key => $value ) {
							echo '<option value="' . esc_attr( $key ) . '"' . selected( WC()->customer->get_shipping_country(), esc_attr( $key ), false ) . '>' . esc_html( $value ) . '</option>';
						}
						?>
					</select>
				</p>
			<?php endif; ?>

			<?php if ( apply_filters( 'woocommerce_shipping_calculator_enable_state', $hasCounty ) ) : ?>
				<p class="form-row form-row-wide<?php echo $class;?>" id="calc_shipping_state_field">
					<?php
					$current_cc = WC()->customer->get_shipping_country();
					$current_r  = WC()->customer->get_shipping_state();
					$states     = WC()->countries->get_states( $current_cc );

					if ( is_array( $states ) && empty( $states ) ) {
						?>
						<input type="hidden" name="calc_shipping_state" id="calc_shipping_state" placeholder="<?php esc_attr_e( 'State / County', 'woocommerce' ); ?>" />
						<?php
					} elseif ( is_array( $states ) ) {
						?>
						<span>
							<label for="calc_shipping_state"><?php esc_html_e( 'State / County:', 'woocommerce' ); ?></label>
							<select name="calc_shipping_state" class="state_select" id="calc_shipping_state" data-placeholder="<?php esc_attr_e( 'State / County', 'woocommerce' ); ?>">
								<option value=""><?php esc_html_e( 'Select an option&hellip;', 'woocommerce' ); ?></option>
								<?php
								foreach ( $states as $ckey => $cvalue ) {
									echo '<option value="' . esc_attr( $ckey ) . '" ' . selected( $current_r, $ckey, false ) . '>' . esc_html( $cvalue ) . '</option>';
								}
								?>
							</select>
						</span>
						<?php
					} else {
						?>
						<label for="calc_shipping_state"><?php esc_html_e( 'State / County:', 'woocommerce' ); ?></label>
						<input type="text" class="input-text" value="<?php echo esc_attr( $current_r ); ?>" name="calc_shipping_state" id="calc_shipping_state" />
						<?php
					}
					?>
				</p>
			<?php endif; ?>

			<?php if ( apply_filters( 'woocommerce_shipping_calculator_enable_city', $hasCity ) ) : ?>
				<p class="form-row form-row-wide<?php echo (WC()->customer->get_shipping_city() != '') ? ' is-active' : ''; ?><?php echo $class;?>" id="calc_shipping_city_field">
					<label for="calc_shipping_city"><?php esc_html_e( 'City:', 'woocommerce' ); ?></label>
					<input type="text" class="input-text" value="<?php echo esc_attr( WC()->customer->get_shipping_city() ); ?>" name="calc_shipping_city" id="calc_shipping_city" />
				</p>
			<?php endif; ?>

			<?php if ( apply_filters( 'woocommerce_shipping_calculator_enable_postcode', $hasPostcode ) ) : ?>
				<p class="form-row form-row-wide<?php echo (WC()->customer->get_shipping_postcode() != '') ? ' is-active' : ''; ?><?php echo $class;?>" id="calc_shipping_postcode_field">
					<label for="calc_shipping_postcode"><?php esc_html_e( 'Postcode / ZIP:', 'woocommerce' ); ?></label>
					<input type="text" class="input-text" value="<?php echo esc_attr( WC()->customer->get_shipping_postcode() ); ?>" name="calc_shipping_postcode" id="calc_shipping_postcode" />
				</p>
			<?php endif; ?>

			<p>
				<?php
					$button_text = bricks_render_dynamic_data( Helpers::get_value( $settings, 'button_text', esc_html__( 'Update', 'woocommerce' ) ) );
					$this->set_attribute('calc_shipping_btn', 'type', 'submit');
					$this->set_attribute('calc_shipping_btn', 'name', 'calc_shipping');
					$this->set_attribute('calc_shipping_btn', 'value', "1");
					$this->set_attribute('calc_shipping_btn', 'class', "button");
				?>
				<button <?php echo $this->render_attributes('calc_shipping_btn'); ?>>
					<?php echo "<span class='button-text'>{$button_text}</span>"; ?>
				</button>
			</p>


			<?php wp_nonce_field( 'woocommerce-shipping-calculator', 'woocommerce-shipping-calculator-nonce' ); ?>
			<input type="hidden" name="action" value="buwoo_calculate_shipping_cost" />
			<input type="hidden" name="element_id" value="<?php echo $this->id; ?>" />
			<input type="hidden" name="post_id" value="<?php echo $this->post_id; ?>" />
			
		</form>

	<?php
		do_action( 'woocommerce_after_shipping_calculator' );
	}
}