<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WPFormsStyler extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-wpf-styler';
	public $icon 			= 'ti-layout-accordion-merged';
	public $tag 			= 'div';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)WPForms Styler', 'bricksultimate' );
	}

	public function set_control_groups() {
		$this->control_groups['form_wrap']    = array(
			'title' => esc_html__( 'Form Container', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['label']    = array(
			'title' => esc_html__( 'Labels', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['inp']  = array(
			'title' => esc_html__( 'Input fields', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['file']  = array(
			'title' => esc_html__( 'File upload fields', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['section']  = array(
			'title' => esc_html__( 'Section Field', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['submit']  = array(
			'title' => esc_html__( 'Submit button', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['error']  = array(
			'title' => esc_html__( 'Validation error', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['success']  = array(
			'title' => esc_html__( 'Success Message', 'bricksultimate' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['wpf_info'] = [
			'tab' 		=> 'content',
			'type' 		=> 'info',
			'content' 	=> esc_html__( "Create a form with WPForms plugin before using this element.", 'bricksultimate' ),
		];

		$this->controls['source_type'] = [
			'tab' 		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__( 'Source Type', 'bricksultimate' ),
			'default' 	=> 'static',
			'options' 	=> [
				'static' 	=> esc_html__('Choose from dropwdown', 'bricksultimate'),
				'dynamic' 	=> esc_html__( 'Custom Field', 'bricksultimate'),
			],
		];

		$this->controls['wpf_form'] = [
			'tab' 			=> 'content',
			'type' 			=> 'select',
			'default' 		=> 'none',
			'label' 		=> esc_html__( 'Form', 'bricksultimate' ),
			'options' 		=> $this->getWPForms(),
			'required'		=> [ 'source_type', '=', [ 'static' ] ],
		];

		$this->controls['wpf_id'] = [
			'tab' 			=> 'content',
			'type' 			=> 'text',
			'label' 		=> esc_html__( 'Custom Field Name', 'bricksultimate' ),
			'info' 			=> __( "Make sure that it returns the fluent forms ID.", 'bricksultimate' ),
			'placeholder' 	=> esc_html__('Enter custom field key', 'bricksultimate'),
			'hasDynamicData' => false,
			'required'		=> [ 'source_type', '=', [ 'dynamic' ] ],
		];

		$this->controls['wpfTitle'] = [
			'tab' 		=> 'content',
			'type' 		=> 'checkbox',
			'label' 	=> __('Show title', 'bricksultimate'),
			'default' 	=> true,
			'reset' 	=> true,
		];

		$this->controls['wpfDesc'] = [
			'tab' 		=> 'content',
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__('Show description', 'bricksultimate'),
			'default' 	=> true,
			'reset' 	=> true,
		];

		$this->controls['titleTypography'] = [
			'tab' 		=> 'content',
			'type'      => 'typography',
			'label'     => esc_html__('Form ttile typography', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-title',
					'property'  => 'font',
				]
			],
			'required' 	=> ['wpfTitle', '=', true]
		];

		$this->controls['descTypography'] = [
			'tab' 		=> 'content',
			'type'      => 'typography',
			'label'     => esc_html__('Form description typography', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-description',
					'property'  => 'font',
				]
			],
			'required' 	=> ['wpfDesc', '=', true]
		];


		/*****************
		 * Form wrapper
		 ****************/
		$selector = '.wpforms-container';

		$this->controls['form_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'width',
				]
			]
		];

		$this->controls['form_mrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'margin',
				]
			]
		];

		$this->controls['form_pad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'default' 	=> [
				'top' 		=> 25,
				'right' 	=> 25,
				'bottom' 	=> 25,
				'left' 		=> 25,
			],
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'padding',
				]
			]
		];

		$this->controls['form_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['form_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'border',
				]
			]
		];

		$this->controls['form_bs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'box-shadow',
				]
			]
		];

		/******************
		 * Labels
		 *****************/
		$this->controls['labelstg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-field-label',
					'property'  => 'font',
				]
			]
		];

		$this->controls['sublabelstg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'typography',
			'label'     => esc_html__('Sub labels typography', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-field-sublabel',
					'property'  => 'font',
				]
			]
		];

		$this->controls['astrx'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'typography',
			'label'     => esc_html__('Asterisk', 'bricksultimate'),
			'exclude' 	=> [
				'text-align',
				'font-weight',
				'font-family',
				'font-style',
				'line-height',
				'text-decoration',
				'text-transform',
				'text-shadow',
				'letter-spacing'
			],
			'css' 		=> [
				[
					'selector' 	=> ".wpforms-container-full .wpforms-form .wpforms-required-label",
					'property'  => 'font',
				]
			]
		];

		$this->controls['labelMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-field-label',
					'property'  => 'padding',
				]
			]
		];

		$this->controls['desctg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'typography',
			'label'     => esc_html__('Description typography', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> ".wpforms-field-description",
					'property'  => 'font',
				]
			]
		];

		$this->controls['descpad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'dimensions',
			'label'     => esc_html__('Description Padding', 'bricksultimate'),
			'css' 		=> [
				[
					'selector' 	=> ".wpforms-field-description",
					'property'  => 'padding',
				]
			]
		];

		/******************
		 * Input fields
		 *****************/
		$wpfinp_selector = '.wpforms-form .wpforms-field input:not([type=radio]):not([type=checkbox]):not([type=submit]):not([type=button]):not([type=image]):not([type=file]), .wpforms-field-textarea textarea, select, .wpforms-form .choices__list--single .choices__item, .wpforms-form .choices__list--dropdown .choices__item, select.wpforms-payment-price';
		$focus_selector = '.wpforms-form .wpforms-field input:not([type=radio]):not([type=checkbox]):not([type=submit]):not([type=button]):not([type=image]):not([type=file]):focus, .wpforms-field-textarea textarea:focus';

		$this->controls['inpHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'label' 	=> esc_html__( 'Height', 'bricks' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $wpfinp_selector,
					'property' 	=> 'height',
				],
			],
			'placeholder' => '40px',
			'default' 	=> 'auto'
		];

		$this->controls['inpPad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $wpfinp_selector,
					'property'  => 'padding',
				]
			]
		];

		$this->controls['v_gap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'number',
			'label'     => esc_html__('Vertical Gap', 'bricksultimate'),
			'units' 	=> true,
			'min'		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-form .wpforms-field',
					'property'  => 'margin-bottom',
				]
			]
		];

		$this->controls['textareaSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'separator',
			'label' 	=> esc_html__( 'Textarea', 'bricks' ),
		];

		$this->controls['inptaWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-field-textarea textarea',
					'property' 	=> 'width',
					'value' 	=> '%s',
					'important' => true
				],
			],
			'placeholder' => '100%'
		];

		$this->controls['inptaHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Height', 'bricks' ),
			'min' 		=> 0,
			'step' 		=> 1,
			'units' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-field-textarea textarea',
					'property' 	=> 'height',
				],
			],
			'placeholder' => '200px'
		];

		$this->controls['inpCBSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'separator',
			'label' 	=> esc_html__( 'Radio/Checkbox', 'bricks' ),
		];

		$this->controls['cbSpace'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Spacing', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> ".wpforms-form ul li",
					'property'  => 'margin',
				]
			]
		];

		$this->controls['cbSize'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricks' ),
			'min' 		=> 0,
			'step' 		=> 1,
			'units' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-form input[type=checkbox], .wpforms-form input[type=radio]',
					'property' 	=> 'width',
				],
				[
					'selector' 	=> '.wpforms-form input[type=checkbox], .wpforms-form input[type=radio]',
					'property' 	=> 'height',
				],
			],
			'placeholder' => '14px'
		];

		$this->controls['cbAlign'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type' 		=> 'select',
			'label' 	=> esc_html__( 'Vertical align', 'bricks' ),
			'inline' 	=> true,
			'options' 	=> [
				'top' 		=> esc_html__('Top', 'bricks'),
				'bottom' 	=> esc_html__('Bottom', 'bricks'),
				'middle' 	=> esc_html__('Middle', 'bricks'),
				'baseline' 	=> esc_html__('Baseline', 'bricks')
			],
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-form input[type=checkbox], .wpforms-form input[type=radio]',
					'property' 	=> 'vertical-align',
				],
				[
					'selector' 	=> '.wpforms-field-checkbox li label, .wpforms-field-radio li label, label.wpforms-field-label-inline',
					'property' 	=> 'vertical-align',
				],
			]
		];

		$this->controls['cbLabels'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'typography',
			'label'     => esc_html__('Label Typography', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-field-checkbox li label, .wpforms-field-radio li label, label.wpforms-field-label-inline',
					'property'  => 'font',
				]
			]
		];

		$this->controls['cbGap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'number',
			'label'     => esc_html__('Gap between button and label', 'bricksultimate'),
			'min' 		=> 0,
			'step' 		=> 1,
			'units' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '.wpforms-form input[type=checkbox], .wpforms-form input[type=radio]',
					'property'  => 'margin-right',
				]
			],
			'placeholder' => '10px'
		];

		$this->controls['inpStyleSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'separator'
		];

		$this->controls['inpbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $wpfinp_selector,
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['inptg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $wpfinp_selector,
					'property'  => 'font',
				]
			]
		];

		$this->controls['placeholdercolor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'typography',
			'label'     => esc_html__('Placeholder', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'exclude' 	=> [
				'text-align',
				'font-weight',
				'font-family',
				'font-style',
				'line-height',
				'text-decoration',
				'text-shadow',
				'letter-spacing'
			],
			'css' 		=> [
				[
					'selector' 	=> "::placeholder",
					'property'  => 'font',
				]
			]
		];

		$this->controls['inpBrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $wpfinp_selector,
					'property'  => 'border',
				]
			]
		];

		$this->controls['inpBoxShadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $wpfinp_selector,
					'property'  => 'box-shadow',
				]
			]
		];

		$this->controls['inpfsep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'separator',
			'label'     => esc_html__('Focus', 'bricks'),
		];

		$this->controls['inpfbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $focus_selector,
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['inpfclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'color',
			'label'     => esc_html__('Text Color', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $focus_selector,
					'property'  => 'color',
				]
			]
		];

		$this->controls['inpfbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $focus_selector,
					'property'  => 'border',
				]
			]
		];

		$this->controls['inpfbs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $focus_selector,
					'property'  => 'box-shadow',
				]
			]
		];


		/*****************************
		 * Submit button
		 *****************************/
		$selector = ".wpforms-submit";
		$this->controls['subWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['subHidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'number',
			'label'     => esc_html__('Height', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '40px',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'height'
				]
			]
		];

		$this->controls['subSpaceSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'submit',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type'  	=> 'separator',
		];

		//margin field
		$this->controls['subMrg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'submit',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['subPad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'submit',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['subStyleSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'submit',
			'type'  	=> 'separator',
		];

		$this->controls['subBg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['subFont'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['subBrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['subShadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['subHoverSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'submit',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover State', 'bricksultimate'),
		];

		$this->controls['subHBg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['subHClr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['subHBrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['subHShadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];


		/*****************************
		 * File upload fields
		 *****************************/
		$selector = '.wpforms-uploader';

		$this->controls['fileWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'file',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['filePad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'file',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['fileBg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'file',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['fileFont'] = [
			'tab' 		=> 'content',
			'group' 	=> 'file',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['fileIconColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'file',
			'type'      => 'color',
			'label'     => esc_html__('Icon Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . " svg",
					'property' 	=> 'fill'
				]
			]
		];

		$this->controls['fileBrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'file',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			]
		];

		/*****************
		 * Section field
		 ****************/
		$selector = ".wpforms-field-divider";

		$this->controls['secWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'section',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		//margin field
		$this->controls['secMargin'] = [
			'tab'   => 'content',
			'group' => 'section',
			'label' => esc_html__( 'Margin', 'bricks' ),
			'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['secPadding'] = [
			'tab'   => 'content',
			'group' => 'section',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['sectionBg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'section',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['secTitle'] = [
			'tab' 		=> 'content',
			'group' 	=> 'section',
			'label' 	=> esc_html__( 'Title', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => ".wpforms-field-divider h3",
				],
			]
		];

		$this->controls['secDesc'] = [
			'tab' 		=> 'content',
			'group' 	=> 'section',
			'label' 	=> esc_html__( 'Description', 'bricksultimate' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => ".wpforms-field-divider .wpforms-field-description",
				],
			]
		];

		$this->controls['secBorder'] = [
			'tab' 		=> 'content',
			'group' 	=> 'section',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'type' 		=> 'border',
			'css'      	=> [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			]
		];

		$this->controls['secShadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'section',
			'label' 	=> esc_html__( 'Box Shadow', 'bricks' ),
			'type' 		=> 'box-shadow',
			'css'      	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				],
			]
		];

		/*****************
		 * Validation error
		 ****************/
		$selector = ".wpforms-error";

		$this->controls['errorTg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'error',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['errorMargin'] = [
			'tab'   => 'content',
			'group' => 'error',
			'label' => esc_html__( 'Margin', 'bricks' ),
			'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		/*****************
		 * Success message
		 ****************/
		$selector = ".wpforms-confirmation-container-full";

		$this->controls['smsgWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'success',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		//margin field
		$this->controls['smsgMargin'] = [
			'tab'   => 'content',
			'group' => 'success',
			'label' => esc_html__( 'Margin', 'bricks' ),
			'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['smsgPadding'] = [
			'tab'   => 'content',
			'group' => 'success',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   => [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['smsgBg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'success',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['smsgTg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'success',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['smsgBorder'] = [
			'tab' 		=> 'content',
			'group' 	=> 'success',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'type' 		=> 'border',
			'css'      	=> [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			]
		];

		$this->controls['smsgShadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'success',
			'label' 	=> esc_html__( 'Box Shadow', 'bricks' ),
			'type' 		=> 'box-shadow',
			'css'      	=> [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				],
			]
		];
	}

	//* get form id
	public function getDynamicFormID() {
		$term = get_queried_object();
		
		if ( $term && ! empty( $term->term_id ) ) {
			$formId = get_term_meta( $term->term_id, Helpers::get_value( $this->settings, 'wpf_id'), true );
			return $formId;
		}
		
		$formId = get_post_meta( $this->post_id, Helpers::get_value( $this->settings, 'wpf_id'), true );
		
		return $formId;
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$source = Helpers::get_value( $settings, 'source_type', 'static');
		$wpf_id = ( $source == 'static' ) ? Helpers::get_value( $settings, 'wpf_form', 'none') : $this->getDynamicFormID();

		if( $wpf_id == 'none' ) {
			return $this->render_element_placeholder( ['title' => esc_html__( 'Select a form.', 'bricksultimate' )] );
		} elseif( empty( $wpf_id ) || $wpf_id === false ) {
			return $this->render_element_placeholder( ['title' => esc_html__( 'Enter custom field name.', 'bricksultimate' )] );
		} else {
			$title = isset( $settings['wpfTitle'] ) ? "true" : "false";
			$desc = isset( $settings['wpfDesc'] ) ? "true" : "false";

			echo "<{$this->tag} {$this->render_attributes('_root')}>";
			echo do_shortcode("[wpforms id=\"{$wpf_id}\" title=\"{$title}\" description=\"{$desc}\"]");
			echo "</{$this->tag}>";
		}
	}

	private function getWPForms() {
		$forms['none'] = esc_html__( 'Select a form', 'bricksultimate' );

		if ( class_exists( 'WPForms_Pro' ) || class_exists( 'WPForms_Lite' ) ) {

			$args = array(
				'post_type'      => 'wpforms',
				'posts_per_page' => -1,
			);
			$wpforms = get_posts( $args );

			if ( $wpforms ) {
				foreach ( $wpforms as $form ) {
					$forms[ $form->ID ] = str_replace(' ', '&#8205; ', preg_replace("/[^a-zA-Z0-9\s]+/", "", $form->post_title ) );
				}
			}
		}

		return $forms;
	}
}