<?php
namespace BricksUltimate;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\{Helpers, Plugin};
use BricksUltimate\Trait\{WpElements,WooElements};

class RegisterElements {
	use WpElements;
	use WooElements;

	function __construct() {
		$this->register_elements();
	}

	/**
	 * Registering the all active elements
	 */
	public function register_elements() {
		$elements = $this->get_elements();
		$active_els = Plugin::$general_elements;
		asort( $active_els );
		//* Loading all general elements
		foreach ( $active_els as $element ) {
			if( empty( $element ) || empty( $elements[ $element ] ) )
				continue;

			if( isset( $elements[ $element ]['show'] ) && ! $elements[ $element ]['show'] )
				continue;

			$this->register_element( $elements[ $element ]['file'] );
		}

		//* Loading all CSS Grid layouts
		if( in_array( 'cgrid', $active_els ) ) {
			$grids = [ 
				'GridTwo', 
				'GridThree', 
				'GridFour', 
				'GridFive', 
				'GridSix', 
				'TemplateOne', 
				'TemplateTwo', 
				'TemplateThree', 
				'TemplateFour', 
				'TemplateFive', 
				'TemplateSix', 
				'TemplateSeven' 
			];

			foreach( $grids as $element ) {
				$this->register_element( $element . '.php' );
			}
		}

		//* Loading all wishlist releated elements
		if( in_array( 'wsl', $active_els ) ) {
			$wlelements = [ 'AddToWishlist', 'WishlistCounter', 'MiniWishlist', 'WishlistCleanAll' ];
			
			if( class_exists('WooCommerce') ) {
				$wlelements[] = 'WishlistAddAllToCart';
			}

			foreach( $wlelements as $element ) {
				$this->register_element( $element . '.php' );
			}
		}

		//* Loading all compare releated elements
		if( in_array( 'compare', $active_els ) ) {
			foreach( [ 'AddToCompare', 'CompareCounter', 'CompareItems' ] as $element ) {
				$this->register_element( $element . '.php' );
			}
		}

		//* Loading all WooCommerce Elements
		if( \Bricks\Woocommerce::is_woocommerce_active() ) {
			$buSettings 	= Plugin::$bu_settings;
			$wooelements 	= $this->get_woo_elements();
			$active_els 	= Plugin::$woo_elements;

			foreach ( $active_els as $element ) {
				if( empty( $element ) || empty( $wooelements[ $element ] ) )
					continue;

				if( isset( $wooelements[ $element ]['show'] ) && ! $wooelements[ $element ]['show'] )
					continue;

				$this->register_element( $wooelements[ $element ]['file'] );
			}

			//* Loading all mini-cart releated elements
			if( in_array( 'minicart', $active_els ) ) {
				$mcsubelements = [ 
					'WooRemoveCartItem', 'WooCartQuantity', 
					'WooItemCartPrice', 'WooCartItemFormatedData' 
				];

				foreach( $mcsubelements as $element ) {
					$this->register_element( $element . '.php' );
				}
			}

			//* Loading all free shipping notice releated elements
			if( isset( $buSettings['fsn'] ) && $buSettings['fsn'] == 'enabled' && wc_shipping_enabled() ) {
				foreach( [ 'WooFreeShippingBar', 'WooFreeShippingNotice' ] as $element ) {
					$this->register_element( $element . '.php' );
				}
			}

			//* Loading all checkout releated elements
			if( in_array( 'checkout', $active_els ) ) {
				$checkoutElements = [ 
					'WooBillTo', 
					'WooBillingFields', 
					'WooShipTo', 
					'WooShippingFields', 
					'WooCheckoutHooks', 
					'WooShippingMethods', 
					'WooReviewOrder', 
					'WooCost', 
					'WooPaymentMethods', 
					'WooPlaceOrderButton',
					'WooBankDetails' 
				];

				foreach( $checkoutElements as $element ) {
					$this->register_element( $element . '.php' );
				}
			}

			if( ! empty( Plugin::$bu_settings['linked_variation'] ) 
				&& Plugin::$bu_settings['linked_variation'] == 'enabled' ) {
				$this->register_element('WooLinkedVariations.php');
			}
		}
	}

	public function register_element( $file ) {
		$file = __DIR__ . '/Elements/' . $file;

		if( file_exists( $file ) ) {
			\Bricks\Elements::register_element( $file );
		}
	}
}