<?php
namespace BricksUltimate;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed Woocommerce_directly

class Cf7Styles {
	public function __construct() {
		add_filter( 'bricks/theme_styles/control_groups', [ $this, 'set_groups' ] );
		add_filter( 'bricks/theme_styles/controls', [ $this, 'set_controls' ] );
	}

	/**
	 * Add BricksUltimate elements style control groups
	 */
	public function set_groups( $control_groups ) {
		$control_groups['bucf7'] = [
			'title' => 'Ultimate - ' . esc_html__( 'Contact Form 7 Styler', 'bricksultimate' ),
		];

		return $control_groups;
	}

	/**
	 * Add BricksUltimate elements style controls
	 */
	public function set_controls( $controls ) {
		$cf7_controls = [];

		$inp_selector = '.wpcf7-form-control:not(input[type="submit"])';
		$selector = '.wpcf7-form-control.wpcf7-submit';

		$cf7_controls['bucf7'] = [
			'labels' => [
				'group'  => 'bucf7',
				'label'  => esc_html__( 'Labels', 'bricks' ),
				'type'   => 'typography',
				'inline' => true,
				'small' => true,
				'css'    => [
					[
						'selector' => '.wpcf7-form label',
						'property' => 'font',
					],
				],
			],

			'inpSep' => [
				'group'  => 'bucf7',
				'label'  => esc_html__( 'Input Fields', 'bricksultimate' ),
				'type'   => 'separator',
			],

			'inpWidth' => [
				'group'  => 'bucf7',
				'label'  => esc_html__( 'Width', 'bricks' ),
				'type'   => 'number',
				'units'  => true,
				'min' 	 => 0,
				'step' 	 => 1,
				'inline' => true,
				'medium' => true,
				'css'    => [
					[
						'selector' => $inp_selector,
						'property' => 'width',
					],
				],
			],

			'inpMargin' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Margin', 'bricks' ),
				'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
				'css'   => [
					[
						'selector' => $inp_selector,
						'property' => 'margin',
					],
				],
			],

			'inpPadding' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Padding', 'bricks' ),
				'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
				'css'   => [
					[
						'selector' => $inp_selector,
						'property' => 'padding',
					],
				],
			],

			'inpBackground' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Background Color', 'bricks' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => $inp_selector,
						'property' => 'background-color',
					],
				],
			],

			'inpTypography' => [
				'group'  => 'bucf7',
				'label'  => esc_html__( 'Typography', 'bricks' ),
				'type'   => 'typography',
				'inline' => true,
				'small' => true,
				'css'    => [
					[
						'selector' => $inp_selector,
						'property' => 'font',
					],
				],
			],

			'phTypography' => [
				'group'  => 'bucf7',
				'label'  => esc_html__( 'Placeholder', 'bricks' ),
				'type'   => 'typography',
				'inline' => true,
				'small' => true,
				'css'    => [
					[
						'selector' 	=> "{$inp_selector}::-webkit-input-placeholder",
						'property' 	=> 'font'
					],
					[
						'selector' 	=> "{$inp_selector}::-ms-input-placeholder",
						'property' 	=> 'font'
					],
					[
						'selector' 	=> "{$inp_selector}::-moz-input-placeholder",
						'property' 	=> 'font'
					],
					[
						'selector' 	=> "{$inp_selector}::-moz-placeholder",
						'property' 	=> 'font'
					]
				],
			],

			'inpBorder' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Border', 'bricks' ),
				'type'  => 'border',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => $inp_selector,
						'property' => 'border',
					],
				],
			],

			'inpFocusSep' => [
				'group'  => 'bucf7',
				'label'  => esc_html__( 'Focus', 'bricksultimate' ),
				'type'   => 'separator',
			],

			'inpFBackground' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Background Color', 'bricks' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$inp_selector}:focus",
						'property' => 'background-color',
					],
				],
			],

			'inpFColor' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Color', 'bricks' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$inp_selector}:focus",
						'property' => 'color',
					],
				],
			],

			'inpFBorder' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Border', 'bricks' ),
				'type'  => 'border',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$inp_selector}:focus",
						'property' => 'border',
					],
				],
			],

			'buttonSep' => [
				'group'  => 'bucf7',
				'label'  => esc_html__( 'Submit Button', 'bricksultimate' ),
				'type'   => 'separator',
			],

			'width' => [
				'group'  => 'bucf7',
				'label'  => esc_html__( 'Width', 'bricks' ),
				'type'   => 'number',
				'units'  => true,
				'min' 	 => 0,
				'step' 	 => 1,
				'inline' => true,
				'medium' => true,
				'css'    => [
					[
						'selector' => $selector,
						'property' => 'width',
					],
				],
			],

			'padding' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Padding', 'bricks' ),
				'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
				'css'   => [
					[
						'selector' => $selector,
						'property' => 'padding',
					],
				],
			],

			'background' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Background Color', 'bricks' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => $selector,
						'property' => 'background-color',
					],
				],
			],

			'typography' => [
				'group'  => 'bucf7',
				'label'  => esc_html__( 'Typography', 'bricks' ),
				'type'   => 'typography',
				'inline' => true,
				'small' => true,
				'css'    => [
					[
						'selector' => $selector,
						'property' => 'font',
					],
				],
			],

			'border' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Border', 'bricks' ),
				'type'  => 'border',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => $selector,
						'property' => 'border',
					],
				],
			],

			'boxshadow' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Box shadow', 'bricks' ),
				'type'  => 'box-shadow',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => $selector,
						'property' => 'box-shadow',
					],
				],
			],

			'hBtnSep' => [
				'group'  => 'bucf7',
				'label'  => esc_html__( 'Hover Button', 'bricksultimate' ),
				'type'   => 'separator',
			],

			'transition' => [
				'group' 	=> 'bucf7',
				'label' 	=> esc_html__( 'Transition', 'bricks' ),
				'css' 		=> [
					[
						'property' => 'transition',
						'selector' => $selector,
					],
				],
				'type'        => 'text',
				'placeholder' => 'all 0.2s ease-in',
				'description' => sprintf( '<a href="https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Transitions/Using_CSS_transitions" target="_blank">%s</a>', esc_html__( 'Learn more about CSS transitions', 'bricks' ) ),
			],

			'hbackground' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Background Color', 'bricks' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$selector}:hover",
						'property' => 'background-color',
					],
				],
			],

			'hcolor' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Text Color', 'bricksultimate' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$selector}:hover",
						'property' => 'color',
					],
				],
			],

			'hborder' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Border', 'bricks' ),
				'type'  => 'border',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$selector}:hover",
						'property' => 'border',
					],
				],
			],

			'hboxshadow' => [
				'group' => 'bucf7',
				'label' => esc_html__( 'Box shadow', 'bricks' ),
				'type'  => 'box-shadow',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$selector}:hover",
						'property' => 'box-shadow',
					],
				],
			],
		];

		return array_merge( $controls, $cf7_controls );
	}
}