<?php
namespace BricksUltimate;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed Woocommerce_directly

class FluentFormsStyles {
	public function __construct() {
		add_filter( 'bricks/theme_styles/control_groups', [ $this, 'set_groups' ] );
		add_filter( 'bricks/theme_styles/controls', [ $this, 'set_controls' ] );
	}

	/**
	 * Add BricksUltimate elements style control groups
	 */
	public function set_groups( $control_groups ) {
		$control_groups['buffs'] = [
			'title' => 'Ultimate - ' . esc_html__( 'Fluent Forms Styler', 'bricksultimate' ),
		];

		return $control_groups;
	}

	/**
	 * Add BricksUltimate elements style controls
	 */
	public function set_controls( $controls ) {
		$ffs_controls = [];

		$labels = '.brxe-bu-ff-styler .fluentform .ff-el-input--label label';
		$inp = '.brxe-bu-ff-styler .ff-el-form-control';
		$button = '.brxe-bu-ff-styler .ff-btn-submit';

		$ffs_controls['buffs'] = [
			'labelsTg' => [
				'group' 	=> 'buffs',
				'type'      => 'typography',
				'label'     => esc_html__('Labels', 'bricks'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $labels,
						'property'  => 'font',
					]
				]
			],

			'astClr' => [
				'group' 	=> 'buffs',
				'type'      => 'color',
				'label'     => esc_html__('Asterisk Color', 'bricks'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> ".brxe-bu-ff-styler .fluentform .ff-el-input--label.ff-el-is-required.asterisk-left label:before",
						'property'  => 'color',
					],
					[
						'selector' 	=> ".brxe-bu-ff-styler .fluentform .ff-el-input--label.ff-el-is-required.asterisk-right label:after",
						'property'  => 'color',
					]
				]
			],

			'astrxGapLeft' => [
				'group' 	=> 'buffs',
				'type'      => 'number',
				'label'     => esc_html__('Gap left', 'bricksultimate'),
				'info' 		=> __( 'Set the value when asterisk is placed at right side of label.', 'bricksultimate' ),
				'units' 	=> true,
				'min'		=> 0,
				'max'  		=> 100,
				'step' 		=> 1,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> '.brxe-bu-ff-styler .ff-el-input--label.ff-el-is-required.asterisk-right label:after',
						'property'  => 'margin-left',
					]
				]
			],

			'astrxGapRight' => [
				'group' 	=> 'buffs',
				'type'      => 'number',
				'label'     => esc_html__('Gap right', 'bricksultimate'),
				'info' 		=> __( 'Set the value when asterisk is placed at left side of label.', 'bricksultimate' ),
				'units' 	=> true,
				'min'		=> 0,
				'max'  		=> 100,
				'step' 		=> 1,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> '.brxe-bu-ff-styler .ff-el-input--label.ff-el-is-required.asterisk-right label:after',
						'property'  => 'margin-right',
					]
				]
			],

			'astSize' => [
				'group' 	=> 'buffs',
				'type'      => 'number',
				'label'     => esc_html__('Asterisk Size', 'bricks'),
				'units' 	=> true,
				'medium' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> ".brxe-bu-ff-styler .fluentform .ff-el-input--label.ff-el-is-required.asterisk-left label:before",
						'property'  => 'font-size',
					],
					[
						'selector' 	=> ".brxe-bu-ff-styler .fluentform .ff-el-input--label.ff-el-is-required.asterisk-right label:after",
						'property'  => 'font-size',
					]
				]
			],

			'sepOne' => [
				'group' 	=> 'buffs',
				'type'      => 'separator',
			],

			'hGap' => [
				'group' 	=> 'buffs',
				'type'      => 'number',
				'label'     => esc_html__('Horizontal Gap', 'bricksultimate'),
				'units' 	=> true,
				'min'		=> 0,
				'max'  		=> 10000,
				'step' 		=> 1,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> '.brxe-bu-ff-styler .frm-fluent-form .ff-t-cell',
						'property'  => 'padding-left',
					],
					[
						'selector' 	=> '.brxe-bu-ff-styler .frm-fluent-form .ff-t-cell',
						'property' 	=> 'padding-right',
					],
				]
			],

			'vGap' => [
				'group' 	=> 'buffs',
				'type'      => 'number',
				'label'     => esc_html__('Vertical Gap', 'bricksultimate'),
				'units' 	=> true,
				'min'		=> 0,
				'max'  		=> 10000,
				'step' 		=> 1,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> '.brxe-bu-ff-styler .fluentform .ff-el-group',
						'property'  => 'margin-bottom',
					]
				]
			],

			'sepInp' => [
				'group' 	=> 'buffs',
				'type'      => 'separator',
				'label'     => esc_html__('Input Fields', 'bricksultimate'),
			],

			'inpHeight' => [
				'group' 	=> 'buffs',
				'label' 	=> esc_html__( 'Height', 'bricks' ),
				'type' 		=> 'number',
				'units' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $inp,
						'property' 	=> 'height',
					],
				],
				'placeholder' => '40px',
				'default' 	=> 'auto'
			],

			'inpPad' => [
				'group' 	=> 'buffs',
				'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
				'label'     => esc_html__('Padding', 'bricks'),
				'css' 		=> [
					[
						'selector' 	=> $inp,
						'property'  => 'padding',
					]
				]
			],

			'inpBg' => [
				'group' 	=> 'buffs',
				'type'      => 'color',
				'label'     => esc_html__('Background Color', 'bricks'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $inp,
						'property'  => 'background-color',
					]
				]
			],

			'inp_tg' => [
				'group' 	=> 'buffs',
				'type'      => 'typography',
				'label'     => esc_html__('Typography', 'bricks'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $inp,
						'property'  => 'font',
					]
				]
			],

			'placeholderColor' => [
				'group' 	=> 'buffs',
				'type'      => 'typography',
				'label'     => esc_html__('Placeholder', 'bricksultimate'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> "::placeholder",
						'property'  => 'font',
					]
				]
			],

			'inpBrd' => [
				'group' 	=> 'buffs',
				'type'      => 'border',
				'label'     => esc_html__('Border', 'bricks'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $inp,
						'property'  => 'border',
					]
				]
			],

			'inpBs' => [
				'group' 	=> 'buffs',
				'type'      => 'box-shadow',
				'label'     => esc_html__('Box shadow', 'bricks'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $inp,
						'property'  => 'box-shadow',
					]
				]
			],

			'sepFocus' => [
				'group' 	=> 'buffs',
				'type'      => 'separator',
				'label'     => esc_html__('Focus', 'bricksultimate'),
			],

			'inpfbg' => [
				'group' 	=> 'buffs',
				'type'      => 'color',
				'label'     => esc_html__('Background Color', 'bricks'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $inp . ":focus",
						'property'  => 'background-color',
					]
				]
			],

			'inpfclr' => [
				'group' 	=> 'buffs',
				'type'      => 'color',
				'label'     => esc_html__('Text Color', 'bricksultimate'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $inp . ":focus",
						'property'  => 'color',
					]
				]
			],

			'inpfbrd' => [
				'group' 	=> 'buffs',
				'type'      => 'border',
				'label'     => esc_html__('Border', 'bricks'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $inp . ":focus",
						'property'  => 'border',
					]
				]
			],

			'inpfbs' => [
				'group' 	=> 'buffs',
				'type'      => 'box-shadow',
				'label'     => esc_html__('Box shadow', 'bricks'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $inp . ":focus",
						'property'  => 'box-shadow',
					]
				]
			],

			'sepBtn' => [
				'group' 	=> 'buffs',
				'type'      => 'separator',
				'label'     => esc_html__('Submit Button', 'bricksultimate'),
			],

			'subWidth' => [
				'group' 	=> 'buffs',
				'type'      => 'number',
				'label'     => esc_html__('Width', 'bricksultimate'),
				'units' 	=> true,
				'min' 		=> 0,
				'step' 		=> 1,
				'inline' 	=> true,
				'placeholder' => '100%',
				'css' 		=> [
					[
						'selector' 	=> $button,
						'property' 	=> 'width'
					]
				]
			],

			'subPad' => [
				'group' 	=> 'buffs',
				'label' 	=> esc_html__( 'Padding', 'bricks' ),
				'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
				'css' 		=> [
					[
						'property' => 'padding',
						'selector' => $button,
					]
				],
			],

			'subBg' => [
				'group' 	=> 'buffs',
				'type'      => 'color',
				'label'     => esc_html__('Background Color', 'bricksultimate'),
				'inline' 	=> true,
				'small' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $button,
						'property' 	=> 'background-color'
					]
				]
			],

			'subFont' => [
				'group' 	=> 'buffs',
				'label' 	=> esc_html__( 'Typography', 'bricks' ),
				'type' 		=> 'typography',
				'css'      => [
					[
						'property' => 'font',
						'selector' => $button,
					],
				]
			],

			'subBrd' => [
				'group' 	=> 'buffs',
				'type'      => 'border',
				'label'     => esc_html__('Border', 'bricksultimate'),
				'inline' 	=> true,
				'small' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $button,
						'property' 	=> 'border'
					]
				]
			],

			'subShadow' => [
				'group' 	=> 'buffs',
				'type'      => 'box-shadow',
				'label'     => esc_html__('Box shadow', 'bricks'),
				'inline' 	=> true,
				'small' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> $button,
						'property' 	=> 'box-shadow'
					]
				]
			],

			'sepBtnHover' => [
				'group' 	=> 'buffs',
				'type'      => 'separator',
				'label'     => esc_html__('Hover', 'bricksultimate'),
			],

			'subHbg' => [
				'group' 	=> 'buffs',
				'type'      => 'color',
				'label'     => esc_html__('Background Color', 'bricksultimate'),
				'inline' 	=> true,
				'small' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> "{$button}:hover",
						'property' 	=> 'background-color'
					]
				]
			],

			'subHclr' => [
				'group' 	=> 'buffs',
				'type'      => 'color',
				'label'     => esc_html__('Color', 'bricksultimate'),
				'inline' 	=> true,
				'small' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> "{$button}:hover",
						'property' 	=> 'color'
					]
				]
			],

			'subHbrd' => [
				'group' 	=> 'buffs',
				'type'      => 'border',
				'label'     => esc_html__('Border', 'bricksultimate'),
				'inline' 	=> true,
				'small' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> "{$button}:hover",
						'property' 	=> 'border'
					]
				]
			],

			'subHshadow' => [
				'group' 	=> 'buffs',
				'type'      => 'box-shadow',
				'label'     => esc_html__('Box shadow', 'bricks'),
				'inline' 	=> true,
				'small' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> "{$button}:hover",
						'property' 	=> 'box-shadow'
					]
				]
			],
		];

		return array_merge( $controls, $ffs_controls );
	}
}