<?php
namespace BricksUltimate\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait LayoutControls {
	public function bu_layout_settings( $controls, $group, $selector, $return = false ) {
		// Display
		$controls['display'] = [
			'group' 	=> $group,
			'label'     => esc_html__( 'Display', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'flex'         => 'flex',
				'grid'         => 'grid',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'add'       => true,
			'inline'    => true,
			'lowercase' => true,
			'css'       => [
				[
					'property' => 'display',
					'selector' => $selector
				],
				[
					'selector' => '',
					'property' => 'align-items',
					'value'    => 'initial',
					'required' => 'grid',
				],
			],
		];

		// Display: grid
		$controls['gridGap'] = [
			'group' 	=> $group,
			'label'       => esc_html__( 'Gap', 'bricks' ),
			'type'        => 'number',
			'units'       => true,
			'css'         => [
				[
					'property' => 'grid-gap',
					'selector' => $selector,
				],
			],
			'placeholder' => '',
			'required'    => [ 'display', '=', 'grid' ],
		];

		$controls['gridTemplateColumns'] = [
			'group' 		=> $group,
			'label'          => esc_html__( 'Grid template columns', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-template-columns',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-template-columns',
					'selector' => $selector,
				],
			],
			'placeholder'    => '',
			'required'       => [ 'display', '=', 'grid' ],
		];

		$controls['gridTemplateRows'] = [
			'group' 		=> $group,
			'label'          => esc_html__( 'Grid template rows', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-template-rows',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-template-rows',
					'selector' => $selector,
				],
			],
			'placeholder'    => '',
			'required'       => [ 'display', '=', 'grid' ],
		];

		$controls['gridAutoColumns'] = [
			'group' 		=> $group,
			'label'          => esc_html__( 'Grid auto columns', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-auto-columns',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-auto-columns',
					'selector' => $selector,
				],
			],
			'required'       => [ 'display', '=', 'grid' ],
		];

		$controls['gridAutoRows'] = [
			'group' 		=> $group,
			'label'          => esc_html__( 'Grid auto rows', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'grid-auto-rows',
				'position' => 'top-left',
			],
			'hasDynamicData' => false,
			'css'            => [
				[
					'property' => 'grid-auto-rows',
					'selector' => $selector,
				],
			],
			'required'       => [ 'display', '=', 'grid' ],
		];

		$controls['gridAutoFlow'] = [
			'group' 	=> $group,
			'label'    => esc_html__( 'Grid auto flow', 'bricks' ),
			'type'     => 'select',
			'options'  => [
				'row'    => 'row',
				'column' => 'column',
				'dense'  => 'dense',
			],
			'tooltip'  => [
				'content'  => 'grid-auto-flow',
				'position' => 'top-left',
			],
			'css'      => [
				[
					'property' => 'grid-auto-flow',
					'selector' => $selector,
				],
			],
			'required' => [ 'display', '=', 'grid' ],
		];

		$controls['justifyItemsGrid'] = [
			'group' 	=> $group,
			'label'     => esc_html__( 'Justify items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'justify-items',
				'position' => 'top-left',
			],
			'type'      => 'justify-content',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'justify-items',
					'selector' => $selector,
				],
			],
			'required'  => [ 'display', '=', 'grid' ],
		];

		$controls['alignItemsGrid'] = [
			'group' 	=> $group,
			'label'     => esc_html__( 'Align items', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-items',
					'selector' => $selector,
				],
			],
			'required'  => [ 'display', '=', 'grid' ],
		];

		$controls['justifyContentGrid'] = [
			'group' 	=> $group,
			'label'     => esc_html__( 'Justify content', 'bricks' ),
			'tooltip'   => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'      => 'justify-content',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'justify-content',
					'selector' => $selector,
				],
			],
			'required'  => [ 'display', '=', 'grid' ],
		];

		$controls['alignContentGrid'] = [
			'group' 	=> $group,
			'label'     => esc_html__( 'Align content', 'bricks' ),
			'tooltip'   => [
				'content'  => 'align-content',
				'position' => 'top-left',
			],
			'type'      => 'align-items',
			'direction' => 'row',
			'css'       => [
				[
					'property' => 'align-content',
					'selector' => $selector,
				],
			],
			'required'  => [ 'display', '=', 'grid' ],
		];

		// Display: flex

		// Flex controls
		$controls['flexWrap'] = [
			'group' 	=> $group,
			'label'    => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'     => 'select',
			'options'  => [
				'nowrap'       => esc_html__( 'No wrap', 'bricks' ),
				'wrap'         => esc_html__( 'Wrap', 'bricks' ),
				'wrap-reverse' => esc_html__( 'Wrap reverse', 'bricks' ),
			],
			'inline'   => true,
			'css'      => [
				[
					'property' => 'flex-wrap',
					'selector' => $selector,
				],
			],
			'required' => [ 'display', '=', 'flex' ],
		];

		$controls['direction'] = [
			'group' 	=> $group,
			'label'    => esc_html__( 'Direction', 'bricks' ),
			'tooltip'  => [
				'content'  => 'flex-direction',
				'position' => 'top-left',
			],
			'type'     => 'direction',
			'css'      => [
				[
					'property' => 'flex-direction',
					'selector' => $selector,
				],
			],
			'inline'   => true,
			'rerender' => true,
			'required' => [ 'display', '=', 'flex' ],
		];

		$controls['alignSelf'] = [
			'group' 	=> $group,
			'label'    => esc_html__( 'Align self', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-self',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property'  => 'align-self',
					'selector' => $selector,
					'important' => true,
				],
				[
					'selector' => $selector,
					'property' => 'width',
					'value'    => '100%',
					'required' => 'stretch',
				],
			],
			'required' => [ 'display', '=', 'flex' ],
		];

		$controls['justifyContent'] = [
			'group' 	=> $group,
			'label'    => esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     => 'justify-content',
			'css'      => [
				[
					'property' => 'justify-content',
					'selector' => $selector,
				],
			],
			'required' => [ 'display', '=', 'flex' ],
		];

		$controls['alignItems'] = [
			'group' 	=> $group,
			'label'    => esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
					'selector' => $selector,
				],
			],
			'required' => [ 'display', '=', 'flex' ],
		];

		$controls['columnGap'] = [
			'group' 	=> $group,
			'label'    => esc_html__( 'Column gap', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'column-gap',
					'selector' => $selector,
				],
			],
			'required' => [ 'display', '=', 'flex' ],
		];

		$controls['rowGap'] = [
			'group' 	=> $group,
			'label'    => esc_html__( 'Row gap', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'row-gap',
					'selector' => $selector,
				],
			],
			'required' => [ 'display', '=', 'flex' ],
		];

		// @since 1.3.5
		$controls['flexGrow'] = [
			'group' 	=> $group,
			'label'       => esc_html__( 'Flex grow', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'tooltip'     => [
				'content'  => 'flex-grow',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'property' => 'flex-grow',
					'selector' => $selector,
				],
			],
			'placeholder' => 0,
			'required'    => [ 'display', '=', 'flex' ],
		];

		$controls['flexShrink'] = [
			'group' 	=> $group,
			'label'       => esc_html__( 'Flex shrink', 'bricks' ),
			'type'        => 'number',
			'min'         => 0,
			'tooltip'     => [
				'content'  => 'flex-shrink',
				'position' => 'top-left',
			],
			'css'         => [
				[
					'property' => 'flex-shrink',
					'selector' => $selector,
				],
			],
			'placeholder' => 1,
			'required'    => [ 'display', '=', 'flex' ],
		];

		$controls['flexBasis'] = [
			'group' 		=> $group,
			'label'          => esc_html__( 'Flex basis', 'bricks' ),
			'type'           => 'text',
			'tooltip'        => [
				'content'  => 'flex-basis',
				'position' => 'top-left',
			],
			'css'            => [
				[
					'property' => 'flex-basis',
					'selector' => $selector,
				],
			],
			'inline'         => true,
			'small'          => true,
			'placeholder'    => 'auto',
			'hasDynamicData' => false,
			'required'       => [ 'display', '=', 'flex' ],
		];

		if( $return )
			return $controls;
	}
}