<?php
namespace BricksUltimate\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait WooElements {

	private $link = \BricksUltimate\PLugin::BU_SITE_URL;
	/**
	 * Gets all woocommerce elements
	 * 
	 * @return array $elements
	 */
	function get_woo_elements() {
		$part = 'documentations/bricksultimate/woo/';
		$elements = [
			'atc' => [
				'name' 	=> __('Add To Cart', 'bricksultimate'),
				'file' 	=> 'WooAddToCart.php',
				'link' 	=> $this->link . $part . 'add-to-cart.php'
			],
			'atci' => [
				'name' 	=> __('Add To Cart Icon', 'bricksultimate'),
				'file' 	=> 'WooAddToCartIcon.php',
				'link' 	=> $this->link . $part . 'add-to-cart-icon.php'
			],
			'acps' => [
				'name' 	=> __('Applied Coupons', 'bricksultimate'),
				'file' 	=> 'WooAppliedCoupons.php',
				'link' 	=> 'https://youtu.be/iJJfJgzHViM'
			],
			'buynow' => [
				'name' 	=> __('Buy Now Button', 'bricksultimate'),
				'file' 	=> 'WooBuyNow.php',
				'link' 	=> $this->link . $part . 'buy-now.php'
			],
			'bsell' => [
				'name' 	=> __('Best Selling Badge', 'bricksultimate'),
				'file' 	=> 'WooBestSellingBadge.php',
				'link' 	=> $this->link . 'doc/best-selling-badge/'
			],
			'cartcounter' => [
				'name' 	=> __('Cart Counter', 'bricksultimate'),
				'file' 	=> 'WooCartCounter.php',
				'link' 	=> $this->link . $part . 'cart-counter.php',
			],
			'cf' => [
				'name' 	=> __('Coupon Form', 'bricksultimate'),
				'file' 	=> 'WooCouponForm.php',
				'link' 	=> $this->link . $part . 'coupon-form.php'
			],
			'cartcontent' => [
				'name' 	=> __('Cart Content', 'bricksultimate'),
				'file' 	=> 'WooCartContent.php',
				'link' 	=> $this->link . $part . 'cart-content.php',
				'info' 	=> esc_html__('Do not activate if you are using the Bricks Mini Cart element.', 'bricksultimate')
			],
			'checkout' => [
				'name' 	=> __('Checkout Builder', 'bricksultimate'),
				'file' 	=> '#',
				'link' 	=> $this->link . 'doc/checkout-builder/',
			],
			'empcart' => [
				'name' 	=> __('Empty Cart Button', 'bricksultimate'),
				'file' 	=> 'WooEmptyCartButton.php',
				'link' 	=> $this->link . 'doc/empty-cart-button/'
			],
			'minicart' => [
				'name' 	=> __('Mini Cart', 'bricksultimate'),
				'file' 	=> 'WooMiniCart.php',
				'link' 	=> $this->link . 'doc/mini-cart/'
			],
			'prdimg' => [
				'name' 	=> __('Product Image', 'bricksultimate'),
				'file' 	=> 'WooProductImage.php',
				'link' 	=> $this->link . 'doc/product-image/'
			],
			'prdrat' => [
				'name' 	=> __('Product Ratings', 'bricksultimate'),
				'file' 	=> 'WooProductRatings.php',
				'link' 	=> $this->link . 'doc/product-ratings/'
			],
			'ddqty' => [
				'name' 	=> __('Dropdown Quantity', 'bricksultimate'),
				'file' 	=> 'WooDropdownQty.php',
				'link' 	=> '#'
			],
			'mcep' => [
				'name' 	=> __('My Account Navigation', 'bricksultimate'),
				'file' 	=> 'WooMaEndpoints.php',
				'link' 	=> '#',
			],
			'atcqty' => [
				'name' 	=> __('Quantity', 'bricksultimate'),
				'file' 	=> 'WooQuantity.php',
				'link' 	=> 'https://youtu.be/v47dEJyhD4Q',
			],
			'salesbdge' => [
				'name' 	=> __('Sales Badge', 'bricksultimate'),
				'file' 	=> 'WooSalesBadge.php',
				'link' 	=> $this->link . 'doc/sales-badge/'
			],
			'shipcal'	=> [
				'name' 	=> __('Shipping Calculator', 'bricksultimate'),
				'file' 	=> 'WooShippingCalculator.php',
				'link' 	=> $this->link . 'doc/shipping-calculator/'
			],
			'soldbdge' => [
				'name' 	=> __('Sold Out Badge', 'bricksultimate'),
				'file' 	=> 'WooSoldOutBadge.php',
				'link' 	=> $this->link . 'doc/sold-out-badge/'
			],
			'stock' => [
				'name' 	=> __('Stock Indicator', 'bricksultimate'),
				'file' 	=> 'WooStockIndicator.php',
				'link' 	=> 'https://youtu.be/L74Sp-xwme4',
			],
			'swatch' => [
				'name' 	=> __('Swatches for Loop', 'bricksultimate'),
				'file' 	=> 'WooSwatchesLoop.php',
				'link' 	=> $this->link . $part . 'swatches-for-loop.php'
			],
			'wh' => [
				'name' 	=> __('Woo Hooks', 'bricksultimate'),
				'file' 	=> 'WooHooks.php',
				'link' 	=> '#',
			],
		];

		return $elements;
	}
}